<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Base_Model extends CI_Model

{
	public function __construct()

	{
		parent::__construct();
	}

	public function create_thumbnail($sourceimage, $newpath, $width, $height)
	{

		$this->load->library('image_lib');

		$this->image_lib->clear();



		$config['image_library'] = 'gd2';

		$config['source_image'] = $sourceimage;

		$config['create_thumb'] = TRUE;

		$config['new_image'] = $newpath;

		$config['dynamic_output'] = FALSE;

		$config['maintain_ratio'] = TRUE;

		$config['width'] = $width;

		$config['height'] = $height;

		$config['thumb_marker'] = '';



		$this->image_lib->initialize($config);

		return $this->image_lib->resize();
	}

	function fetch_records_from_query($query = '', $offset = '', $perpage = '')
	{
		$rs = $this->db->query($query);
		$this->numrows = $rs->num_rows();
		if ($offset != '' && $perpage != '')		$this->db->limit($perpage, $offset);
		return $rs->result();
	}

	function validate_upload_image($fieldmessage, $fieldname, $filepath, $thumbnailpath = '', $width = '', $height = '')

	{

		$config['upload_path'] = $filepath;

		$config['allowed_types'] = 'gif|jpeg|jpg|png';

		//$config['max_size']	= '500';

		//$config['max_width']  = '1024';

		//$config['max_height']  = '768';

		$config['remove_spaces'] = TRUE;

		$config['overwrite'] = FALSE;

		//print_r($config);

		//die();

		$this->load->library('upload', $config);



		if (!$this->upload->do_upload($fieldname)) {

			$this->form_validation->set_message($fieldmessage, $this->upload->display_errors());

			return $this->upload->display_errors();

			//return FALSE;

		} else {

			$filedata = $this->upload->data();



			//$this->session->set_userdata('uploadedphotoname',$filedata['file_name']);

			$this->uploadedimagename = $filedata['file_name'];

			if (!empty($thumbnailpath)) {

				$this->create_thumbnail($filedata['full_path'], $thumbnailpath, $width, $height);
			}

			return TRUE;
		}
	}



	//General database operations

	function run_query($query)

	{

		$result = ($this->db->query($query)->result());

		if (!empty($result)) {
			return true;
		} else {
			return false;
		}
	}



	function getMaxId($TableName, $ColName)

	{

		$query = $this->db->query("select max(" . $ColName . ") as Id from " . $this->db->dbprefix($TableName))->result();

		return $query[0]->Id;
	}



	function insert_operation($inputdata, $table, $email = '')

	{
		if ($this->db->insert($this->db->dbprefix($table), $inputdata))

			return 1;

		else

			return 0;
	}



	function insert_operation_id($inputdata, $table, $email = '')

	{

		$result  = $this->db->insert($this->db->dbprefix($table), $inputdata);

		return $this->db->insert_id();
	}





	function update_operation($inputdata, $table, $where)

	{
		$result  = $this->db->update($this->db->dbprefix($table), $inputdata, $where);
		return $result;
	}



	function insert_or_update($inputdata, $table, $where = '', $id = '')

	{
	}



	function fetch_records_from($table, $condition = '', $select = '*', $order_by = '', $order_type = 'asc', $limit = '')
	{
		$this->db->select($select, FALSE);
		$this->db->from($this->db->dbprefix($table));
		if (!empty($condition))			$this->db->where($condition);

		if (!empty($order_by))
			$this->db->order_by($order_by, $order_type);

		if (!empty($limit))
			$this->db->limit($limit);

		$result = $this->db->get();

		return $result->result();
	}



	function fetch_single_column_value($table, $column, $where)
	{

		$this->db->select($column, FALSE);

		$this->db->from($this->db->dbprefix($table));



		if (!empty($where))

			$this->db->where($where);

		$result_rs = $this->db->get();

		$result = $result_rs->result();

		if (count($result) > 0)

			$ret = $result[0]->$column;

		else

			$ret = '-';

		return $ret;
	}



	function fetch_business_info($condition = '', $andcondition = '', $featurecondition = '', $offset = '', $perpage = '')

	{

		$this->db->start_cache();

		$this->db->select("*", FALSE);



		$this->db->from('gps_business');





		if (!empty($condition))

			$this->db->where($condition);

		if (!empty($andcondition))

			$this->db->where($andcondition, 'date(now())', FALSE);

		if (!empty($featurecondition))

			$this->db->where($featurecondition);

		$this->db->stop_cache();



		$this->numrows = $this->db->count_all_results();



		//$this->db->limit($perpage,$offset);

		$result = $this->db->get();

		$this->db->flush_cache();

		return $result->result();
	}



	function changestatus($table, $inputdata, $where)

	{

		$result = $this->db->update($this->db->dbprefix($table), $inputdata, $where);

		return $result;
	}



	function delete_record($table, $where)

	{

		$result = $this->db->delete($table, $where);

		return $result;
	}



	function getAreas($TableName = '', $Val = '', $Name = '')

	{

		return ($this->db->query("Select " . $Val . "," . $Name . " from " . $TableName . "")->result());
	}

	function get_areasinfo($areaid)

	{

		$q = $this->db->query("SELECT a.*,sub.* FROM veggies_main_areas a,veggies_sub_areas sub WHERE sub.main_area_id = a.main_area_id and a.main_area_id='" . $areaid . "'")->result();

		return $q;
	}





	function get_tasks()

	{

		$query	=	$this->db->get('gps_tasks');

		return $query->result_array();
	}

	function check_duplicate($table_name, $cond, $cond_val)
	{
		$col_name = '*';
		$this->db->where(array($cond => $cond_val));
		$this->db->from($this->db->dbprefix($table_name));
		$query = $this->db->get();
		$rows = $query->num_rows();
		if ($rows > 0) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public function get_details($table)

	{

		$query	=	$this->db->get($table);

		return $query->result_array();
	}





	//////////Adiyya////////////////

	function fetch_records_from_new($table, $condition = '', $select = '*', $order_by = '', $like = '', $offset = '', $perpage = '')
	{
		$this->db->start_cache();
		$this->db->select($select, FALSE);
		$this->db->from($this->db->dbprefix($table));
		if (!empty($condition))
			$this->db->where($condition);
		if (!empty($like))
			$this->db->like($like);
		//$this->db->where( array( 'is_deleted' => 'no' ) );
		if (!empty($order_by))
			$this->db->order_by($order_by);
		$this->db->stop_cache();

		$this->numrows = $this->db->count_all_results();

		if ($perpage != '')
			$this->db->limit($perpage, $offset);
		$result = $this->db->get();
		$this->db->flush_cache();
		return $result->result();
	}
	function SaveForm($table, $form_data)
	{
		$this->db->insert($table, $form_data);



		if ($this->db->affected_rows() == '1') {
			return TRUE;
		}

		return FALSE;
	}

	/****** GET SUM OF COLUMNS ******/
	function getSumOfColumns($column_name, $table_name)
	{

		$this->db->select_sum($column_name);
		$result_rs = $this->db->get($this->db->dbprefix($table_name));

		$result = $result_rs->row();

		return $result->$column_name;
	}


	/****** GET SUBJECTS	
	 * Author @
	 *Raghu
	 ******/
	function getSubjects()
	{

		/* $query = "SELECT c.*,(select r.subject_name from ".$this->db->dbprefix('subjects')." r where c.subject_parent_id=r.id ) as parent_name from ".$this->db->dbprefix('subjects')." c where c.status='Active'"; */

		$subjects = array();

		$parentSubjectDetails = $this->db->select('id AS parentSubject_id, subject_name AS parentSubject_name')->get_where($this->db->dbprefix('subjects'), array('subject_parent_id' => 0, 'status' => 'Active'))->result();

		foreach ($parentSubjectDetails as $p) {

			$query = "SELECT s . * , (

					SELECT count( * )
					FROM " . $this->db->dbprefix('tutor_subjects') . " ts
					WHERE ts.subject_id = s.id
					AND ts.status = 'Active'
					) AS no_of_tutors
					FROM " . $this->db->dbprefix('subjects') . " s
					WHERE s.subject_parent_id = " . $p->parentSubject_id . "
					AND s.status = 'active'";

			$childSubjects = $this->db->query($query)->result();

			$subjects[$p->parentSubject_name] = $childSubjects;
		}

		return $subjects;
	}

	/****** GET TUTOR SUBJECTS	
	 * Author @
	 *Raghu
	 ******/
	function getTutorSubjects($tutor_id = null)
	{
		$tutorSubjects = array();
		$tutorSubjectsArr = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorSubjectsRec = $this->db->select('subject_id')->get_where($this->db->dbprefix('tutor_subjects'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorSubjectsRec as $t)
				array_push($tutorSubjectsArr, $t->subject_id);

			$parentSubjectDetails = $this->db->select('id AS parentSubject_id, subject_name AS parentSubject_name')->get_where($this->db->dbprefix('subjects'), array('subject_parent_id' => 0, 'status' => 'Active'))->result();

			foreach ($parentSubjectDetails as $p) {

				$childSubjects = $this->db->query("SELECT * FROM " . $this->db->dbprefix('subjects') . " WHERE subject_parent_id = " . $p->parentSubject_id . " AND id IN (" . implode(',', $tutorSubjectsArr) . ") AND status='Active'")->result();

				if (count($childSubjects) > 0)
					$tutorSubjects[$p->parentSubject_name] = $childSubjects;
			}
		}

		return $tutorSubjects;
	}


	/****** GET TUTOR SUBJECT IDs
	 * Author @
	 *Raghu
	 ******/
	function getTutorSubjectIds($tutor_id = null)
	{

		$tutorSubjectIds = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorSubjectsRec = $this->db->select('subject_id')->get_where($this->db->dbprefix('tutor_subjects'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorSubjectsRec as $t)
				array_push($tutorSubjectIds, $t->subject_id);
		}

		return $tutorSubjectIds;
	}

	/****** GET TUTOR Skills IDs
	 * Author @
	 *Raghu
	 ******/
	function getTutorSkillIds($tutor_id = null)
	{

		$tutorSkillIds = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorSkillsRec = $this->db->select('skill_id')->get_where($this->db->dbprefix('tutor_skills'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorSkillsRec as $t)
				array_push($tutorSkillIds, $t->skill_id);
		}

		return $tutorSkillIds;
	}

	function getTrainingInstituteSkillIds($traininginstitute_id = null)
	{

		$traininginstituteSkillIds = array();

		if ($traininginstitute_id != null && is_numeric($traininginstitute_id)) {

			$traininginstituteSkillsRec = $this->db->select('skill_id')->get_where($this->db->dbprefix('training_institute_skills'), array('user_id' => $traininginstitute_id, 'status' => 'Active'))->result();

			foreach ($traininginstituteSkillsRec as $t)
				array_push($traininginstituteSkillIds, $t->skill_id);
		}

		return $traininginstituteSkillIds;
	}
	/****** GET SUBJECTS	
	 * Author @
	 *Raghu
	 ******/
	function getSkills()
	{
		$skills = array();

		$query = "SELECT s.* 
					FROM " . $this->db->dbprefix('skills') . " s
					WHERE s.status = 'active'";

		$skills = $this->db->query($query)->result();

		return $skills;
	}
	/****** GET LOCATIONS	
	 * Author @
	 *Raghu
	 ******/
	function getLocations()
	{

		$locations = array();

		$parentLocationDetails = $this->db->select('id AS parentLocation_id, location_name AS parentLocation_name')->get_where($this->db->dbprefix('locations'), array('parent_location_id' => 0, 'status' => 'Active'))->result();

		foreach ($parentLocationDetails as $p) {

			$query = "SELECT l . * , (

					SELECT count( * )
					FROM " . $this->db->dbprefix('tutor_locations') . " tl,
					 " . $this->db->dbprefix('users') . " u,
					 " . $this->db->dbprefix('users_groups') . " ug
					WHERE (tl.location_id = l.id OR 
					u.location_id = l.id) 
					AND ug.group_id = 3
					AND ug.user_id = u.id
					AND u.id = tl.user_id
					AND u.active = 1
					AND tl.status = 'Active'
					) AS no_of_tutors
					FROM " . $this->db->dbprefix('locations') . " l
					WHERE l.parent_location_id = " . $p->parentLocation_id . "
					AND l.status = 'active'";

			$childLocations = $this->db->query($query)->result();

			$locations[$p->parentLocation_name] = $childLocations;
		}

		return $locations;
	}


	/****** GET TUTOR LOCATIONS	
	 * Author @
	 *Raghu
	 ******/
	function getTutorLocations($tutor_id = null)
	{
		$tutorLocations = array();
		$tutorLocationsArr = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorLocationsRec = $this->db->select('location_id')->get_where($this->db->dbprefix('tutor_locations'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorLocationsRec as $l)
				array_push($tutorLocationsArr, $l->location_id);

			$parentLocationDetails = $this->db->select('id AS parentLocation_id, location_name AS parentLocation_name')->get_where($this->db->dbprefix('locations'), array('parent_location_id' => 0, 'status' => 'Active'))->result();

			foreach ($parentLocationDetails as $p) {

				$childLocations = $this->db->query("SELECT * FROM " . $this->db->dbprefix('locations') . " WHERE parent_location_id = " . $p->parentLocation_id . " AND id IN (" . implode(',', $tutorLocationsArr) . ") AND status='Active'")->result();

				if (count($childLocations) > 0)
					$tutorLocations[$p->parentLocation_name] = $childLocations;
			}
		}

		return $tutorLocations;
	}


	/****** GET TUTOR LOCATION IDs
	 * Author @
	 *Raghu
	 ******/
	function getTutorLocationIds($tutor_id = null)
	{

		$tutorLocationIds = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorLocationsRec = $this->db->select('location_id')->get_where($this->db->dbprefix('tutor_locations'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorLocationsRec as $l)
				array_push($tutorLocationIds, $l->location_id);
		}

		return $tutorLocationIds;
	}


	/****** GET STUDENT REQUIREMENTS
	 * Author @
	 *Raghu
	 ******/
	function getLearnerRequirements($learner_id = null, $status = null, $limit = null)
	{

		$learnerRequirements = array();
		$status_column 	= "";
		$limit_cond 	= "";

		if ($learner_id != null && is_numeric($learner_id)) {

			if ($status != "" && in_array($status, array('Opened', 'Closed'))) {

				$status_column = " AND s.status='" . $status . "' ";
			}

			if ($limit != "" && $limit > 0) {

				$limit_cond = " LIMIT " . $limit . " ";
			}

			$query = "SELECT s . * , t.tutor_type, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name,
						sub.subject_name, (

						SELECT ps.subject_name
						FROM " . $this->db->dbprefix('subjects') . " ps
						WHERE ps.id = sub.subject_parent_id
						) AS parent_subject_name
						FROM " . $this->db->dbprefix('learner_leads') . " s,
						" . $this->db->dbprefix('tutor_types') . " t,
						" . $this->db->dbprefix('locations') . " loc,
						" . $this->db->dbprefix('subjects') . " sub
						WHERE loc.id = s.location_id
						AND sub.id = s.subject_id
						AND s.user_id =" . $learner_id . " 
						" . $status_column . "
						AND t.tutor_type_id = s.tutor_type_id
						ORDER BY s.id DESC " . $limit_cond;

			$learnerRequirements = $this->db->query($query)->result();
		}

		return $learnerRequirements;
	}

	function getLearnerLeads($learner_id = null)
	{
		$this->getLearnerRequirements($learner_id);
	}



	/****** GET TUTOR TYPES
	 * Author @
	 *Raghu
	 ******/
	function getTutorTypes()
	{
		$tutorTypes = $this->db->get_where($this->db->dbprefix('tutor_types'), array('status' => 'Active'))->result();

		return $tutorTypes;
	}

	/****** GET TUTOR LOCATION IDs
	 * Author @
	 *Raghu
	 ******/
	function gettTutorSelectedTypeIds($tutor_id = null)
	{

		$tutorSelectedTypeIds = array();

		if ($tutor_id != null && is_numeric($tutor_id)) {

			$tutorSelectedTypesRec = $this->db->select('tutor_type_id')->get_where($this->db->dbprefix('tutor_selected_types'), array('user_id' => $tutor_id, 'status' => 'Active'))->result();

			foreach ($tutorSelectedTypesRec as $t)
				array_push($tutorSelectedTypeIds, $t->tutor_type_id);
		}

		return $tutorSelectedTypeIds;
	}

	function getTrainingInstituteSelectedTypeIds($training_institute_ids = null)
	{

		$training_institute_SelectedTypeIds = array();

		if ($training_institute_ids != null && is_numeric($training_institute_ids)) {

			$traininginstituteSelectedTypesRec = $this->db->select('training_institute_type_id')->get_where($this->db->dbprefix('training_institute_selected_types'), array('user_id' => $training_institute_ids, 'status' => 'Active'))->result();

			foreach ($traininginstituteSelectedTypesRec as $t)
				array_push($training_institute_SelectedTypeIds, $t->training_institute_type_id);
		}

		return $training_institute_SelectedTypeIds;
	}


	/****** GET TUTOR COMMENTS
	 * Author @
	 *Raghu
	 ******/
	function getTutorComments($tutor_id = null, $status = null, $limit = null, $learner_id = null, $review_status = null)
	{

		$tutorComments 	= array();
		$status_column 	= "";
		$lim 		   	= "";
		$learner_column	= "";
		$review_status_column	= "";

		if ($tutor_id != null && is_numeric($tutor_id)) {

			if ($status != null)
				$status_column = " AND tc.status = '" . $status . "' ";

			if ($limit != null && is_numeric($limit))
				$lim = "LIMIT " . $limit;

			if ($learner_id != null && is_numeric($learner_id))
				$learner_column = " AND tc.learner_user_id =" . $learner_id;

			if ($review_status != null && ($review_status == '1' || $review_status == '0'))
				$review_status_column = " AND tc.isReviewGiven ='" . $review_status . "' ";

			$tutorComments = $this->db->query("SELECT tc.id AS comment_id, tc.tutor_user_id, tc.learner_user_id, tc.rating_value, tc.comment, tc.status AS comment_status, tc.is_read, tc.date_of_comment, tc.isReviewGiven, s.username AS learner_name, s.photo as learner_photo
			FROM " . $this->db->dbprefix('tutor_comments') . " tc,
			" . $this->db->dbprefix('users') . " s
			WHERE s.id = tc.learner_user_id
			AND tc.tutor_user_id = " . $tutor_id . " 
			" . $learner_column . " 
			" . $status_column . " 
			" . $review_status_column . " 
			ORDER BY tc.date_of_comment DESC " . $lim)->result();
		}
		return $tutorComments;
	}

	/****** GET TRAINING INSTITUTE TYPES
	 * Author @
	 *Raghu
	 ******/
	function getTrainingInstituteTypes()
	{
		$training_instituteTypes = $this->db->get_where($this->db->dbprefix('training_institute_types'), array('status' => 'Active'))->result();

		return $training_instituteTypes;
	}

	/****** GET TRAINING INSTITUTE LOCATION IDs
	 * Author @
	 *Raghu
	 ******/
	function gettTrainingInstituteSelectedTypeIds($training_institute_id = null)
	{

		$training_instituteSelectedTypeIds = array();

		if ($training_institute_id != null && is_numeric($training_institute_id)) {

			$training_instituteSelectedTypesRec = $this->db->select('training_institute_type_id')->get_where($this->db->dbprefix('training_institute_selected_types'), array('user_id' => $training_institute_id, 'status' => 'Active'))->result();

			foreach ($training_instituteSelectedTypesRec as $t)
				array_push($training_instituteSelectedTypeIds, $t->training_institute_type_id);
		}

		return $training_instituteSelectedTypeIds;
	}


	/****** GET TRAINING INSTITUTE COMMENTS
	 * Author @
	 *Raghu
	 ******/
	function getTrainingInstituteComments($training_institute_id = null, $status = null, $limit = null, $learner_id = null, $review_status = null)
	{

		$training_instituteComments 	= array();
		$status_column 	= "";
		$lim 		   	= "";
		$learner_column	= "";
		$review_status_column	= "";

		if ($training_institute_id != null && is_numeric($training_institute_id)) {

			if ($status != null)
				$status_column = " AND tc.status = '" . $status . "' ";

			if ($limit != null && is_numeric($limit))
				$lim = "LIMIT " . $limit;

			if ($learner_id != null && is_numeric($learner_id))
				$learner_column = " AND tc.learner_user_id =" . $learner_id;

			if ($review_status != null && ($review_status == '1' || $review_status == '0'))
				$review_status_column = " AND tc.isReviewGiven ='" . $review_status . "' ";

			$training_instituteComments = $this->db->query("SELECT tc.id AS comment_id, tc.training_institute_user_id, tc.learner_user_id, tc.rating_value, tc.comment, tc.status AS comment_status, tc.is_read, tc.date_of_comment, tc.isReviewGiven, s.username AS learner_name, s.photo as learner_photo
			FROM " . $this->db->dbprefix('training_institute_comments') . " tc,
			" . $this->db->dbprefix('users') . " s
			WHERE s.id = tc.learner_user_id
			AND tc.training_institute_user_id = " . $training_institute_id . " 
			" . $learner_column . " 
			" . $status_column . " 
			" . $review_status_column . " 
			ORDER BY tc.date_of_comment DESC " . $lim)->result();
		}
		return $training_instituteComments;
	}
	/******Institute Functions**************************************/

	/****** Get User Name By Id ******/
	function getUserNameById($user_id = null)
	{
		$user_name = "";

		if (is_numeric($user_id)) {

			$usernameRec = $this->db->select('username')->get_where($this->db->dbprefix('users'), array('id' => $user_id))->row();
			if (count($usernameRec) > 0)
				$user_name = $usernameRec->username;
		}
		return $user_name;
	}

	/****** Get User Email By Id ******/
	function getUserEmailById($user_id = null)
	{
		$user_email = "";

		if (is_numeric($user_id)) {

			$userEmailRec = $this->db->select('email')->get_where($this->db->dbprefix('users'), array('id' => $user_id))->row();
			if (count($userEmailRec) > 0)
				$user_email = $userEmailRec->email;
		}
		return $user_email;
	}


	/****** Get Testimonials ******/
	function getTestimonials($user_group_id = null, $status = null)
	{
		$testimonials 		= array();
		$user_group_column 	= "";
		$status_column 		= "";

		if ($user_group_id != "") {

			if (!is_numeric($user_group_id))
				return array();

			$user_group_column = " AND ug.group_id =" . $user_group_id . " ";
		}

		if ($status != "" && in_array($status, array('Approved', 'Pending', 'Blocked'))) {

			$status_column = " AND t.status = '" . $status . "'";
		}

		$query = "SELECT t . * , u.username, u.photo
				FROM " . $this->db->dbprefix('testimonials') . " t, 
				" . $this->db->dbprefix('users') . " u, 
				" . $this->db->dbprefix('users_groups') . " ug
				WHERE u.id = t.user_id
				AND ug.user_id = u.id
				" . $user_group_column . " 
				" . $status_column . " 
				AND u.active =1
				ORDER BY t.testimony_id DESC ";

		$testimonials = $this->db->query($query)->result();

		return $testimonials;
	}



	/****** Send  Message ******/
	function sendMessage($sender_id = 0, $receiver_id = null, $msg = null, $msg_type = null)
	{

		if (is_numeric($sender_id) && is_numeric($receiver_id) && trim($msg) != "") {

			$inputdata['sender_id'] 	= $sender_id;
			$inputdata['receiver_id'] 	= $receiver_id;
			$inputdata['message'] 		= trim($msg);
			$inputdata['message_type'] 	= trim($msg_type);
			$inputdata['date_posted']  	= time();

			if ($this->insert_operation($inputdata, 'messages'))
				return true;
		}
		return false;
	}


	/****** GET Unregistered User MESSAGES
	 * Author @
	 *Raghu
	 ******/
	function getUnregisteredUserMsgs($receiver_id = null, $msg_type = 'Message', $read_status = null)
	{

		$unRegisteredUserMsgs = array();
		$read_status_column = "";

		if ($receiver_id != null && is_numeric($receiver_id)) {

			if ($read_status != null && ($read_status == '0' || $read_status == '1'))
				$read_status_column = " AND m.read_status = '" . $read_status . "' ";

			$query = "SELECT m.*,m.name as username, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name
						FROM " . $this->db->dbprefix('messages') . " m,
						" . $this->db->dbprefix('locations') . " loc
						WHERE m.receiver_id  =" . $receiver_id . "
						AND m.sender_id 	 = 0 
						AND m.location_id 	 = loc.id 
						AND m.message_type 	 = '" . $msg_type . "'
						AND m.message_status = 'Active' 
						" . $read_status_column . "
						ORDER BY m.message_id DESC";

			$unRegisteredUserMsgs = $this->db->query($query)->result();
		}

		return $unRegisteredUserMsgs;
	}


	/****** GET INBOX MESSAGES
	 * Author @
	 *Raghu
	 ******/
	function getInboxMessages($receiver_id = null, $msg_type = 'Message', $read_status = null)
	{

		$inboxMessages = array();
		$read_status_column   = "";

		if ($receiver_id != null && is_numeric($receiver_id)) {

			if ($read_status != null && ($read_status == '0' || $read_status == '1'))
				$read_status_column = " AND m.read_status = '" . $read_status . "' ";

			$query = "SELECT m.*, u.*, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name
						FROM " . $this->db->dbprefix('messages') . " m,
						" . $this->db->dbprefix('users') . " u,
						" . $this->db->dbprefix('locations') . " loc
						WHERE m.receiver_id =" . $receiver_id . "
						AND m.message_type = '" . $msg_type . "'
						AND m.message_status = 'Active' 
						" . $read_status_column . "
						AND u.id = m.sender_id 
						AND loc.id = u.location_id
						AND u.active = 1  
						ORDER BY m.message_id DESC, u.is_premium = 1";

			$inboxMessages = $this->db->query($query)->result();
		}

		return $inboxMessages;
	}


	/****** GET SENT MESSAGES
	 * Author @
	 *Raghu
	 ******/
	function getSentMessages($sender_id = null)
	{

		$sentMessages = array();

		if ($sender_id != null && is_numeric($sender_id)) {

			$query = "SELECT m.*, u.*, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name
						FROM " . $this->db->dbprefix('messages') . " m,
						" . $this->db->dbprefix('users') . " u,
						" . $this->db->dbprefix('locations') . " loc
						WHERE m.sender_id =" . $sender_id . "
						AND m.message_type = 'Message'
						AND u.id = m.receiver_id 
						AND loc.id = u.location_id
						AND u.active = 1  
						ORDER BY m.message_id DESC, u.is_premium = 1";

			$sentMessages = $this->db->query($query)->result();
		}

		return $sentMessages;
	}

	/****** Get Total Receivable amoount by according to admin
	 ******/
	function getAmount($receiver_id = null, $user_group = 3, $amount_type = 'Total Receivable', $client_id = 0)
	{
		//echo $user_group;
		$amount = array();

		if ($client_id == 0) return $amount;
		if ($receiver_id != null && is_numeric($receiver_id)) {

			if ($this->session->userdata('start_date') != '') {
				$start_date = date('Y-m-d', strtotime($this->session->userdata('start_date')));
			} else {
				$start_date = date('Y-m-d', strtotime(date('Y-m-d') . " -1 month"));
			}

			if ($this->session->userdata('end_date') != '') {
				$end_date = date('Y-m-d', strtotime($this->session->userdata('end_date')));
			} else {
				$end_date = date("Y-m-d");
			}
			$date_con = "next_follow_up_date between '" . $start_date . "' and '" . $end_date . "'";


			if ($amount_type == "Total Receivable" && ($user_group == 1 || $user_group == 2)) {

				$query = "SELECT SUM(invoice_amount) AS TotalReceivable FROM dt_tasks WHERE active='1' AND client_id=" . $client_id . " AND (" . $date_con . ")";
				$amount = $this->db->query($query)->result();
			} elseif ($amount_type == "Total Received" && ($user_group == 1 || $user_group == 2)) {

				$query = "SELECT SUM(amount_collected) AS TotalReceived FROM dt_tasks WHERE client_id=" . $client_id . " AND (" . $date_con . ")";
				$amount = $this->db->query($query)->result();
			} elseif ($amount_type == "Total Panding" && ($user_group == 1 || $user_group == 2)) {

				$query = "SELECT SUM(invoice_amount) AS TotalPanding FROM dt_tasks WHERE active='1' AND client_id=" . $client_id . " AND (" . $date_con . ")";
				$amount = $this->db->query($query)->result();
			}

			if ($amount_type == "Total Receivable" && $user_group == 3) {

				$query = "SELECT SUM(invoice_amount) AS TotalReceivable FROM dt_tasks WHERE active='1' AND client_id=" . $client_id . " AND emp_id=" . $receiver_id . " AND (" . $date_con . ")";
				$amount = $this->db->query($query)->result();
			} elseif ($amount_type == "Total Received" && $user_group == 3) {

				$query = "SELECT SUM(amount_collected) AS TotalReceived FROM dt_tasks WHERE active='1' AND client_id=" . $client_id . " AND emp_id=" . $receiver_id . " AND (" . $date_con . ")";
				$amount = $this->db->query($query)->result();
			}
		}
		return $amount;
	}

	function is_customer_exists($customer_code, $id = "", $client_id)
	{
		//echo $customer_code; echo $id; echo $client_id; 

		if ($id > 0) {
			$query = $query = $this->db->get_where($this->db->dbprefix('customers'), array('customer_code' => $customer_code, 'client_id' => $client_id, 'id !=' => $id));
		} else {
			$this->db->select('*', FALSE);
			$this->db->from($this->db->dbprefix('customers'));
			$this->db->where('customer_code', $customer_code);
			$this->db->where('client_id', $client_id);
			$query = $this->db->get();
		}
		return $query->num_rows();
	}

	function is_task_exists($client_id, $customer_code, $invoice_control_number, $id = 0)
	{
		//echo $customer_code; echo $id; echo $client_id;  echo $invoice_control_number; 
		if ($id > 0) {
			$query = $query = $this->db->get_where($this->db->dbprefix('tasks'), array('client_id' => $client_id, 'invoice_control_number' => $invoice_control_number, 'id !=' => $id));
		} else {
			$this->db->select('*', FALSE);
			$this->db->from($this->db->dbprefix('tasks'));
			//$this->db->where('client_id', $client_id );
			//$this->db->where('customer_code', $customer_code );
			$this->db->where('invoice_control_number', $invoice_control_number);
			$query = $this->db->get();
		}
		return $query->num_rows();
	}



	/****** GET ADMIN INBOX MESSAGES FROM TUTOR/STUDENT
	 * Author @
	 *Raghu
	 ******/
	function getAdminInboxMessages($receiver_id = null, $user_group = 3, $msg_type = 'Message', $read_status = null)
	{

		$inboxMessages = array();
		$read_status_column   = "";

		if ($receiver_id != null && is_numeric($receiver_id)) {

			if ($read_status != null && ($read_status == '0' || $read_status == '1'))
				$read_status_column = " AND m.read_status = '" . $read_status . "' ";

			$query = "SELECT m.*, u.*, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name
						FROM " . $this->db->dbprefix('messages') . " m,
						" . $this->db->dbprefix('users') . " u,
						" . $this->db->dbprefix('users_groups') . " ug,
						" . $this->db->dbprefix('locations') . " loc
						WHERE m.receiver_id =" . $receiver_id . "
						AND m.message_type = '" . $msg_type . "'
						AND m.message_status = 'Active' 
						" . $read_status_column . "						
						AND ug.user_id = m.sender_id 
						AND ug.group_id = " . $user_group . " 
						AND u.id = ug.user_id 
						AND loc.id = u.location_id
						AND u.active = 1  
						ORDER BY m.message_id DESC, u.is_premium = 1";

			$inboxMessages = $this->db->query($query)->result();
		}

		return $inboxMessages;
	}



	/****** Update Message Read Status ******/
	function updateMessageReadStatus($message_id = null)
	{

		if ($message_id != "" && is_numeric($message_id)) {

			if ($this->update_operation(array('read_status' => '1'), 'messages', array('message_id' => $message_id))) {

				return 1;
			}
		}
		return 0;
	}

	/****** Update Message Reply Status ******/
	function updateMessageReplyStatus($message_id = null)
	{

		if ($message_id != "" && is_numeric($message_id)) {

			if ($this->base_model->update_operation(array('isReplied' => 'Yes'), 'messages', array('message_id' => $message_id))) {

				return 1;
			}
		}
		return 0;
	}



	/****** Get Leads Count******/
	function getLeadsCount($user_id = null)
	{
		$leads_count = $this->run_query(" select (select count(*) from dt_learner_leads l where status='Opened' and user_id!=0) as total_leads, (SELECT
count(*) as cnt
FROM 
dt_learner_leads l, dt_tutor_selected_types tst,
dt_tutor_subjects ts, dt_users u
WHERE
l.subject_id = ts.subject_id
AND u.id = ts.user_id
AND l.tutor_type_id = tst.tutor_type_id
AND u.id = tst.user_id
AND u.id = " . $this->ion_auth->get_user_id() . ") as matching_leads ");
		return $leads_count;
	}

	/****** Get Lead Records******/
	function getLeadRecords($user_id = null)
	{
		$leads_records = $this->run_query("SELECT
l.*,l.title_of_requirement as title, tt.tutor_type, 
s.subject_name, 
loc.location_name, (SELECT u1.photo FROM dt_users u1 WHERE u1.id=l.user_id) AS photo, 
(SELECT u2.username FROM dt_users u2 WHERE u2.id=l.user_id) AS username   
FROM 
dt_learner_leads l, dt_tutor_selected_types tst,
dt_tutor_subjects ts, dt_users u, dt_locations loc, dt_subjects s, dt_tutor_types tt 
WHERE
l.subject_id = ts.subject_id
AND u.id = ts.user_id
AND l.tutor_type_id = tst.tutor_type_id 
AND l.tutor_type_id = tt.tutor_type_id 
AND u.id = tst.user_id
AND loc.id = l.location_id AND l.user_id!=0
AND u.id = " . $this->ion_auth->get_user_id() . " group by l.id order by l.id desc limit 5");
		return $leads_records;
	}

	//Get Random Premium Tutors if Premium is 1
	function getRandomTutors($premium = '1')
	{
		$tutors = $this->run_query(" Select u.* from dt_users u, dt_users_groups ug, dt_groups g  where u.id = ug.user_id and ug.group_id = g.id and g.id=3 and u.is_premium='" . $premium . "' ORDER BY rand()");
		return $tutors;
	}

	function getUsersCount1($param1 = '')
	{
		/*$users = $this->run_query(" SELECT 
												count(*) cnt, l.country
												FROM
												dt_locations l, dt_users u
												WHERE
												u.location_id = l.id 
												GROUP BY l.country");
		return $users;*/
	}

	function getUsersCount($param1 = '')
	{
		$users = array();
		if ($param1 != '' && is_numeric($param1)) {


			$users = $this->run_query(" SELECT 
												count(*) cnt,l.location_name as parent_name


												FROM
												dt_users u, dt_locations l
												WHERE
												u.location_id = l.id AND
												l.parent_location_id = $param1
												group by l.parent_location_id");
		} else {
			$users = $this->run_query(" SELECT 
												 count(*) cnt, l.parent_location_id 
												 as parent_id, 
												 (select location_name from 
												 dt_locations 
												 where id = l.parent_location_id) 
												 as parent_name
												FROM
												dt_users u, dt_locations l
												WHERE
												u.location_id = l.id 
	                                            group by l.parent_location_id");
		}


		return $users;
	}

	function getUsersCountPremium($param1 = '')
	{
		$users = $this->run_query(" SELECT
												u.id, u.username, u.email, u.no_of_profile_views as views, g.name as usertype
												FROM
												dt_users u, dt_users_groups ug, dt_groups g
												WHERE
												u.id = ug.user_id AND
												ug.group_id = g.id AND
												g.name!='admin' AND
												u.is_premium=1");
		return $users;
	}


	function getPackageReport($param1 = '')
	{
		$data = $this->run_query(" SELECT 
									count(*) as cnt, p.package_name
									FROM 
									dt_subscriptions s, dt_packages p 
									WHERE 
									s.package_id = p.id
									GROUP BY 
									p.id");
		return $data;
	}

	function getClientRequirements($client_id = null, $status = null, $limit = null)
	{

		$clientRequirements = array();
		$status_column 	= "";
		$limit_cond 	= "";

		if ($client_id != null && is_numeric($client_id)) {

			if ($status != "" && in_array($status, array('Opened', 'Closed'))) {

				$status_column = " AND s.status='" . $status . "' ";
			}

			if ($limit != "" && $limit > 0) {

				$limit_cond = " LIMIT " . $limit . " ";
			}

			$query = "SELECT s . * , t.tutor_type, loc.location_name, (

						SELECT pl.location_name
						FROM " . $this->db->dbprefix('locations') . " pl
						WHERE pl.id = loc.parent_location_id
						) AS parent_location_name,
						sub.subject_name, (

						SELECT ps.subject_name
						FROM " . $this->db->dbprefix('subjects') . " ps
						WHERE ps.id = sub.subject_parent_id
						) AS parent_subject_name
						FROM " . $this->db->dbprefix('client_leads') . " s,
						" . $this->db->dbprefix('tutor_types') . " t,
						" . $this->db->dbprefix('locations') . " loc,
						" . $this->db->dbprefix('subjects') . " sub
						WHERE loc.id = s.location_id
						AND sub.id = s.subject_id
						AND s.user_id =" . $client_id . " 
						" . $status_column . "
						AND t.tutor_type_id = s.tutor_type_id
						ORDER BY s.id DESC " . $limit_cond;

			$clientRequirements = $this->db->query($query)->result();
		}

		return $clientRequirements;
	}

	function record_count()
	{

		return $this->db->count_all("dt_blog");
	}

	public function fetch_blogs($limit, $start)
	{
		$this->db->limit($limit, $start);
		$query = $this->db->get("dt_blog");

		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return false;
	}
	public function get_store_image($store_id)
	{
		$this->db->select('*', true);
		$this->db->from('dt_stores');
		$this->db->where('store_id', $store_id);
		$query = $this->db->get();
		return $query->row();
	}

	private $_batchImport;

	public function setBatchImport($batchImport)
	{

		$this->_batchImport = $batchImport;
	}

	// save data
	public function importData()
	{
		$data = $this->_batchImport;



		if ($this->db->insert_batch('variance_report', $data)) {
			return 1;
		} else {

			return 0;
		}
	}
	//-----------------------------------
	private $_batchImport_physical;

	public function setBatchImport_physical($_batchImport_physical)
	{

		$this->_batchImport_physical = $_batchImport_physical;
	}

	// save data
	public function importData_physical()
	{
		$data_physical_stock = $this->_batchImport_physical;



		if ($this->db->insert_batch('physical_stock', $data_physical_stock)) {
			return 1;
		} else {

			return 0;
		}
	}




	public function getCountForAttendance($employee_id, $date)
	{
		$first_day_this_month = date('Y-m-01', strtotime($date));
		$last_day_this_month = date('Y-m-t', strtotime($date));


		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'I');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$Icount = $this->db->get()->num_rows();

		// print_r($this->db->last_query()); die;

		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'BOW');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$BOWcount = $this->db->get()->num_rows();

		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'L');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$Lcount = $this->db->get()->num_rows();



		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'WF');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$WFcount = $this->db->get()->num_rows();

		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'WFH');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$WFHcount = $this->db->get()->num_rows();

		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'A');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$Acount = $this->db->get()->num_rows();

		$this->db->select('*');
		$this->db->from('attendance');
		$this->db->where('attendance.attendance_status', 'CO');
		$this->db->where('attendance.employee_id', $employee_id);
		$this->db->where('attendance.date >=', $first_day_this_month);
		$this->db->where('attendance.date <=', $last_day_this_month);
		$COcount = $this->db->get()->num_rows();

		$resultArray['I'] = $Icount;
		$resultArray['L'] = $Lcount;
		$resultArray['BOW'] = $BOWcount;
		$resultArray['WF'] = $WFcount;
		$resultArray['WFH'] =  $WFHcount;
		$resultArray['CO'] =   $COcount;
		$resultArray['A'] =   $Acount;
		$resultArray['Total'] = $Icount + $Lcount + $BOWcount + $WFcount + $WFHcount + $COcount + $Acount;

		return $resultArray;
	}

	public function milestone_list()
	{

		$this->db->select('*');
		$this->db->from('milestone');
		$this->db->where('milestone.flag!=', '1');
		$this->db->order_by("milestone.position", "asc");
		$result = $this->db->get()->result();

		return $result;
	}

	public function company_list()
	{

		$this->db->select('*');
		$this->db->from('companies');
		$this->db->where('companies.flag!=', '1');
		$result = $this->db->get()->result();

		return $result;
	}


	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportVertical;

	public function setBatchImportVertical($batchImport)
	{

		$this->_batchImportVertical = $batchImport;
	}

	// save data
	public function importDataVertical()
	{
		$data = $this->_batchImportVertical;



		if ($this->db->insert_batch('vertical_master', $data)) {
			return 1;
		} else {

			return 0;
		}
	}


	public function get_vertical_list()
	{

		$this->db->select('vertical_name,vertical_code');
		$this->db->from('vertical_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();

		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportCluster;

	public function setBatchImportCluster($batchImport)
	{

		$this->_batchImportCluster = $batchImport;
	}

	// save data
	public function importDataCluster()
	{
		$data = $this->_batchImportCluster;
		if ($this->db->insert_batch('cluster_master', $data)) {
			return 1;
		} else {

			return 0;
		}
	}

	public function get_cluster_list()
	{

		$this->db->select('cluster_name,cluster_code');
		$this->db->from('cluster_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}


	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportSBU;

	public function setBatchImportSBU($batchImport)
	{
		$this->_batchImportSBU = $batchImport;
	}

	// save data
	public function importDataSBU()
	{
		$data = $this->_batchImportSBU;
		if ($this->db->insert_batch('sbu_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_sbu_list()
	{

		$this->db->select('sbu_name,sbu_code');
		$this->db->from('sbu_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportCountry;

	public function setBatchImportCountry($batchImport)
	{
		$this->_batchImportCountry = $batchImport;
	}

	// save data
	public function importDataCountry()
	{
		$data = $this->_batchImportCountry;
		if ($this->db->insert_batch('country_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_country_list()
	{

		$this->db->select('country_name,country_code');
		$this->db->from('country_master');
		//$this->db->where('companies.flag!=','1');
		return $this->db->get()->result();
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportLocalFX;

	public function setBatchImportLocalFX($batchImport)
	{
		$this->_batchImportLocalFX = $batchImport;
	}

	// save data
	public function importDataLocalFX()
	{
		$data = $this->_batchImportLocalFX;
		if ($this->db->insert_batch('local_fx_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_local_fx_list()
	{

		$this->db->select('local_fx_name');
		$this->db->from('local_fx_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportArea;

	public function setBatchImportArea($batchImport)
	{
		$this->_batchImportArea = $batchImport;
	}

	// save data
	public function importDataArea()
	{
		$data = $this->_batchImportArea;
		if ($this->db->insert_batch('area_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_area_list()
	{

		$this->db->select('area_name,area_code');
		$this->db->from('area_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}


	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportDPST;

	public function setBatchImportDPST($batchImport)
	{
		$this->_batchImportDPST = $batchImport;
	}

	// save data
	public function importDataDPST()
	{
		$data = $this->_batchImportDPST;
		if ($this->db->insert_batch('dpst_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_dpst_list()
	{
		$this->db->select('dpst_name,dpst_code');
		$this->db->from('dpst_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportARType;

	public function setBatchImportARType($batchImport)
	{
		$this->_batchImportARType = $batchImport;
	}

	// save data
	public function importDataARType()
	{
		$data = $this->_batchImportARType;
		if ($this->db->insert_batch('ar_type_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_artype_list()
	{
		$this->db->select('ar_type_name,ar_type_code');
		$this->db->from('ar_type_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/


	private $_batchImportTransactionType;

	public function setBatchImportTransactionType($batchImport)
	{
		$this->_batchImportTransactionType = $batchImport;
	}

	// save data
	public function importDataTransactionType()
	{
		$data = $this->_batchImportTransactionType;
		if ($this->db->insert_batch('transaction_type_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function get_transactiontype_list()
	{
		$this->db->select('transaction_type_name,transaction_type_code');
		$this->db->from('transaction_type_master');
		//$this->db->where('companies.flag!=','1');
		$result = $this->db->get()->result();
		return $result;
	}

	/********* ELGI BASED MODEL RAGHU***********/

	/* Kiran */
	private $_batchImportDPSTVertical;

	public function setBatchImportDPSTVertical($batchImport)
	{
		$this->_batchImportDPSTVertical = $batchImport;
	}

	// save data
	public function importDataDPSTVertical()
	{
		$data = $this->_batchImportDPSTVertical;
		if ($this->db->insert_batch('dpst_vertical_mapping', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	/********* ELGI BASED MODEL RAGHU***********/


	/* Kiran */
	private $_batchImportMonth_end_Ar_list;

	public function setBatchImportMonth_end_Ar_list($batchImport)
	{
		$this->_batchImportMonth_end_Ar_list = $batchImport;
	}

	// save data
	public function importDataMonth_end_Ar_list()
	{
		$data = $this->_batchImportMonth_end_Ar_list;
		if ($this->db->insert_batch('month_end_ar_list', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	/* Kiran */
	private $_batchImportMonth_end_fx_rate;

	public function setBatchImportMonth_end_fx_rate($batchImport)
	{
		$this->_batchImportMonth_end_fx_rate = $batchImport;
	}

	// save data
	public function importDataMonth_end_fx_rate()
	{
		$data = $this->_batchImportMonth_end_fx_rate;
		if ($this->db->insert_batch('month_end_fx_rates', $data)) {
			return 1;
		} else {
			return 0;
		}
	}
	/********* ELGI BASED MODEL RAGHU***********/
	/* Kiran */
	private $_batchImportUploadUserInput;

	public function setBatchImportUploadUserInput($batchImport)
	{
		$this->_batchImportUploadUserInput = $batchImport;
	}

	// save data
	public function importDataUploadUserInput()
	{
		$data = $this->_batchImportUploadUserInput;
		if ($this->db->insert_batch('user_input', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	/********* ELGI BASED MODEL RAGHU***********/


	/* Kiran */
	private $_batchImportUploadDailyColl;

	public function setBatchImportUploadDailyColl($batchImport)
	{
		$this->_batchImportUploadDailyColl = $batchImport;
	}

	// save data
	public function importDataUploadDailyColl()
	{
		$data = $this->_batchImportUploadDailyColl;
		if ($this->db->insert_batch('daily_collection', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	/* Kiran */
	private $_batchImportUploadDailyAR;

	public function setBatchImportUploadDailyAR($batchImport)
	{
		$this->_batchImportUploadDailyAR = $batchImport;
	}

	// save data
	public function importDataUploadDailyAR()
	{
		$data = $this->_batchImportUploadDailyAR;
		if ($this->db->insert_batch('daily_ar', $data)) {
			return 1;
		} else {
			return 0;
		}
	}


	/* Kiran */
	private $_batchImportUploadCollecPlan;

	public function setBatchImportUploadCollecPlan($batchImport)
	{
		$this->_batchImportUploadCollecPlan = $batchImport;
	}

	// save data
	public function importDataUploadCollecPlan()
	{
		$data = $this->_batchImportUploadCollecPlan;
		if ($this->db->insert_batch('upload_collection_plan', $data)) {
			return 1;
		} else {
			return 0;
		}
	}


	/* Kiran */
	private $_batchImportAreaCountry;

	public function setBatchImportAreaCountry($batchImport)
	{
		$this->_batchImportAreaCountry = $batchImport;
	}

	// save data
	public function importDataAreaCountry()
	{
		$data = $this->_batchImportAreaCountry;
		if ($this->db->insert_batch('area_country_mapping', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	/* Kiran */
	private $_batchImportTransactionTypeMap;

	public function setBatchImportTransactionTypeMap($batchImport)
	{
		$this->_batchImportTransactionTypeMap = $batchImport;
	}

	// save data
	public function importDataTransactionTypeMap()
	{
		$data = $this->_batchImportTransactionTypeMap;
		if ($this->db->insert_batch('transaction_type_mapping', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function setBatchImportVerticalEntity($batchImport)
	{
		$this->_batchImportVerticalEntity = $batchImport;
	}

	// save data
	public function importDataVerticalEntity()
	{
		$data = $this->_batchImportVerticalEntity;
		if ($this->db->insert_batch('vertical_entity_mapping', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function setBatchImportConsoleMaster($batchImport)
	{
		$this->importDataConsoleMaster = $batchImport;
	}

	// save data
	public function importDataConsoleMaster()
	{
		$data = $this->_batchImportConsoleMaster;
		if ($this->db->insert_batch('console_master', $data)) {
			return 1;
		} else {
			return 0;
		}
	}

	public function getTransactionTypeList($sequence_id, $priority)
	{
		$this->db->select('transaction_type_master.transaction_type_code');
		$this->db->from('transaction_type_master');
		$this->db->from('transaction_type_mapping');
		$this->db->join('vertical_master', 'vertical_master.id = transaction_type_mapping.vertical_id', 'left');
		$this->db->where('transaction_type_mapping.transaction_type_id = transaction_type_master.id');
		$this->db->where('transaction_type_mapping.priority', $priority);
		$this->db->where('transaction_type_mapping.sequence_id', $sequence_id);
		$result = $this->db->get()->result();
		$array = json_decode(json_encode($result), true);
		return $array;
	}


	public function getTransactionPriorityList($sequence_id)
	{
		$this->db->select('transaction_type_mapping.priority');
		$this->db->from('transaction_type_mapping');
		$this->db->where('transaction_type_mapping.sequence_id', $sequence_id);
		$this->db->group_by('transaction_type_mapping.priority');
		$this->db->order_by('transaction_type_mapping.priority', 'asc');
		return $this->db->get()->result();
	}

	/* AVIANSH GET Data FROM month_end_ar_list */

	public function month_end_ar_list_DPST($month_year = '', $ar_type = '')
	{

		$this->db->select('*');
		$this->db->from('month_end_ar_list');
		$this->db->where('month_end_ar_list.month_year', $month_year);
		if ($ar_type != '') {
			$this->db->where_in('month_end_ar_list.dpst', $ar_type);
		}
		$this->db->where('month_end_ar_list.process_data !=', 1);
		return $this->db->get()->result();
	}


	public function month_end_ar_list_DPST_ar_type($logical_ar_type = '')
	{

		$this->db->select('dpst_code');
		$this->db->from('dpst_vertical_mapping');
		$this->db->from('dpst_master');
		$this->db->where('dpst_vertical_mapping.dpst_id = dpst_master.id');
		$this->db->where_in('dpst_vertical_mapping.ar_type_id', $logical_ar_type);
		$result = $this->db->get()->result();
		$array = json_decode(json_encode($result), true);
		return $array;
	}



	public function month_end_ar_list_TransactionType($month_year = '', $TransactionTypeList = '')
	{

		$this->db->select('*');
		$this->db->from('month_end_ar_list');
		$this->db->where('month_end_ar_list.month_year', $month_year);
		if ($TransactionTypeList != '') {
			$this->db->where_in('month_end_ar_list.transaction_type', $TransactionTypeList);
		}
		$this->db->where('month_end_ar_list.process_data !=', 1);
		return $this->db->get()->result();
	}

	public function month_end_ar_list_value($month_year = '')
	{

		$this->db->select('*');
		$this->db->from('month_end_ar_list');
		$this->db->where('month_end_ar_list.month_year', $month_year);
		$this->db->where('month_end_ar_list.balance_amount <=', 100);
		$this->db->where('month_end_ar_list.process_data !=', 1);
		return $this->db->get()->result();
	}

	public function getMonthEndReport($month_year = '', $ar_type_id = '', $dpst_id = '', $cluster_id = '', $vertical_id = '', $limit = '', $start = '')
	{


		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim(get_artype_name($a));
			}
		}

		if (!empty($dpst_id)) {
			$dpst_code = array();
			foreach ($dpst_id as $d) {
				$dpst_code[] = trim(get_dpst_code($d));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('*');
		$this->db->from('month_end_ar_process_data as m');
		$this->db->where('m.month_year', $month_year);

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($dpst_code)) {
			$this->db->where_in('m.dpst', $dpst_code);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if ($limit != '') {
			if ($start != '') {
				$this->db->limit($limit, $start);
			} else {
				$this->db->limit($limit, 0);
			}
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query()); die; 


	}


	public function getMonthEndReportListForExcel($month_year = '')
	{

		$this->db->select('*');
		$this->db->from('month_end_ar_process_data as m');
		$this->db->where('m.month_year', $month_year);
		return $this->db->get()->result();
	}



	public function setBatchImportProcessData($batchImport)
	{

		$this->setBatchImportProcessData = $batchImport;
	}

	// save data
	public function importDataProcessData()
	{
		$data = $this->setBatchImportProcessData;

		if ($this->db->insert_batch('month_end_ar_process_data', $data)) {
			return 1;
		} else {

			return 0;
		}
	}



	//----------- Current AR List ------------------//


	public function setBatchImportCurrentARProcessData($batchImport)
	{

		$this->setBatchImportProcessData = $batchImport;
	}

	// save data
	public function importDataCurrentARProcessData()
	{
		$data = $this->setBatchImportProcessData;

		if ($this->db->insert_batch('current_ar_process_data', $data)) {
			return 1;
		} else {

			return 0;
		}
	}



	public function getMonthEndReportListForExcelMapping($month_year = '', $vertical_id = '')
	{

		$vertical_name = array();
		foreach (explode(',', $vertical_id) as $v) {
			$vertical_name[] = trim(get_vertical_name($v));
		}



		$this->db->select('*');
		$this->db->from('month_end_ar_process_data as m');
		$this->db->where('m.month_year', $month_year);
		if (!empty($vertical_id)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}
		return $this->db->get()->result();
	}


	public function getUserInputList($month_year = '', $vertical_id = '')
	{

		$vertical_name = array();
		foreach (explode(',', $vertical_id) as $v) {
			$vertical_name[] = trim(get_vertical_name($v));
		}

		$this->db->select('*');
		$this->db->from('user_input as u');
		$this->db->where('u.month_year', $month_year);
		if (!empty($vertical_id)) {
			$this->db->where_in('u.vertical', $vertical_name);
		}
		return $this->db->get()->result();
	}

	/* SBU List */
	public function getVerticleMappingCluster($sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '')
	{

		$this->db->select('v.*');
		$this->db->from('vertical_entity_mapping as v');
		$this->db->from('cluster_master as c');
		if (!empty($cluster_id)) {
			$this->db->where_in('c.id', $cluster_id);
		}
		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}
		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}
		if (!empty($console_entity_id)) {
			$this->db->where_in('v.console_id', $console_entity_id);
		}
		$this->db->where('c.id = v.cluster_id');
		$this->db->group_by('v.cluster_id');
		$this->db->order_by("cluster_name", "desc");
		return $this->db->get()->result();
	}


	public function getVerticleMappingSBU()
	{

		$this->db->select('s.*');
		$this->db->from('vertical_entity_mapping as v');
		$this->db->from('sbu_master as s');
		$this->db->where('s.id = v.sbu_id');
		$this->db->group_by('v.sbu_id');
		$this->db->order_by("sbu_name", "desc");
		return $this->db->get()->result();
	}


	public function getARSummaryByARTypeReportFxImpact($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim(get_console_name($co));
			}
		}

		$this->db->select('sum(fx_impact) as fx');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		$this->db->group_by('cluster');
		return $this->db->get()->row('fx');

		// print_r($this->db->last_query());

	}

	public function getCurrencyValReport($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $currency = '', $ar_type_id = '')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		$this->db->select('sum(fx_impact) as fx');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($currency)) {
			$this->db->where_in('currency', $currency);
		}

		$this->db->group_by('currency');
		return $this->db->get()->row('fx');

		// print_r($this->db->last_query());

	}


	public function getExportInvoiceFEMAReport($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim(get_console_name($co));
			}
		}

		$this->db->select('sum(balance_amount) as bal, sum(fx_balance_amount) as fx_bal');
		$this->db->from('month_end_ar_process_data');

		$this->db->where('fema_days >', 240);

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		$this->db->group_by('cluster');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}

	public function getVerticleMappingClusterss($sbu_id = '', $cluster_id = '', $vertical_id = '', $console_id = '')
	{

		$this->db->select('v.*');
		$this->db->from('vertical_entity_mapping as v');
		$this->db->from('vertical_master as vm');
		
		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}
		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}
		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}
		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}
		
		$this->db->where('vm.id = v.vertical_id');
		
		$this->db->order_by('vm.vertical_name', 'asc');
		return $this->db->get()->result();
	}


	public function getARSummaryByARTypeReportVerticalFxImpact($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		if (!empty($console_id)) {
			$console_name = array();
			foreach ($console_id as $co) {
				$console_name[] = trim(get_console_name($co));
			}
		}

		$this->db->select('sum(fx_impact) as fx');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		$this->db->group_by('vertical');
		return $this->db->get()->row('fx');

		// print_r($this->db->last_query());

	}

	/* Export Invoice FEMA */

	public function getExportInvoiceFEMAReportVerticalBal($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		if (!empty($console_id)) {
			$console_name = array();
			foreach ($console_id as $co) {
				$console_name[] = trim(get_console_name($co));
			}
		}

		$this->db->select('sum(balance_amount) as bal, sum(fx_balance_amount) as fx_bal');
		$this->db->from('month_end_ar_process_data');

		$this->db->where('fema_days >', 240);

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		$this->db->group_by('vertical');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}


	/* AR Summary Report */

	public function getTradeARSummaryReport($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		$this->db->select('sum(ftm_due) as ftm_due, sum(fx_ftm_due) as fx_ftm_due, sum(retention) as retention, sum(within_due) as within_due, sum(fx_within_due) as fx_within_due, sum(actual_coll_amount) as col_amt, sum(invoice_amount) as inv_amt, sum(fx_invoice_amount) as fx_inv_amt, sum(warranty_retention) as war_ret, sum(overdue) as overdue, sum(fx_overdue) as fx_overdue, sum(balance_amount) as bal, sum(fx_balance_amount) as fx_bal');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		$this->db->group_by('cluster');
		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}

	public function getODdaysAmt($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $from = '', $to = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		$this->db->select('sum(overdue) as overdue1, sum(fx_overdue) as fx_overdue');
		$this->db->from('month_end_ar_process_data');


		$this->db->group_start();
		if ($to == 1081) {
			$this->db->where('od_days > "' . $to . '"');
		} else {
			$this->db->where('od_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}



		$this->db->group_by('cluster');
		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}

	public function getODdaysAmtVertical($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $from = '', $to = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		$this->db->select('sum(overdue) as overdue2, sum(fx_overdue) as fx_overdue2');
		$this->db->from('month_end_ar_process_data');

		$this->db->group_start();
		if ($to == 1081) {
			$this->db->where('od_days > "' . $to . '"');
		} else {
			$this->db->where('od_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}



		$this->db->group_by('cluster');
		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}



	public function getTradeARSummaryReportVertical($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach (explode(',', $cluster_id) as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}

		$this->db->select('sum(ftm_due) as ftm_due, sum(fx_ftm_due) as fx_ftm_due, sum(retention) as retention, sum(within_due) as within_due, sum(fx_within_due) as fx_within_due, sum(actual_coll_amount) as col_amt, sum(invoice_amount) as inv_amt, sum(fx_invoice_amount) as fx_inv_amt, sum(warranty_retention) as war_ret, sum(overdue) as overdue, sum(fx_overdue) as fx_overdue, sum(balance_amount) as bal, sum(fx_balance_amount) as fx_bal');


		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		$this->db->group_by('vertical');
		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}

	/* Current AR Data List */

	public function current_ar_list_DPST($month_year = '', $ar_type = '')
	{

		$this->db->select('*');
		$this->db->from('daily_ar');
		$this->db->where('daily_ar.month_year', $month_year);
		if ($ar_type != '') {
			$this->db->where_in('daily_ar.dpst', $ar_type);
		}
		$this->db->where('daily_ar.process_data !=', 1);
		return $this->db->get()->result();
	}


	public function current_ar_list_TransactionType($month_year = '', $TransactionTypeList = '')
	{

		$this->db->select('*');
		$this->db->from('daily_ar');
		$this->db->where('daily_ar.month_year', $month_year);
		if ($TransactionTypeList != '') {
			$this->db->where_in('daily_ar.transaction_type', $TransactionTypeList);
		}
		$this->db->where('daily_ar.process_data !=', 1);
		return $this->db->get()->result();
	}


	public function current_ar_list_value($month_year = '')
	{
		$this->db->select('*');
		$this->db->from('daily_ar');
		$this->db->where('daily_ar.month_year', $month_year);
		$this->db->where('daily_ar.balance_amount <=', 100);
		$this->db->where('daily_ar.process_data !=', 1);
		return $this->db->get()->result();
	}

	public function getCurrentARReportListForExcel($month_year = '')
	{

		$this->db->select('*');
		$this->db->from('current_ar_process_data as m');
		$this->db->where('m.month_year', $month_year);
		return $this->db->get()->result();
	}


	public function getDailyARReport($month_year = '', $ar_type_id = '', $dpst_id = '', $cluster_id = '', $vertical_id = '', $limit = '', $start = '')
	{


		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim(get_artype_name($a));
			}
		}


		if (!empty($dpst_id)) {
			$dpst_code = array();
			foreach ($dpst_id as $d) {
				$dpst_code[] = trim(get_dpst_code($d));
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}

		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('*');
		$this->db->from('current_ar_process_data as m');
		$this->db->where('m.month_year', $month_year);

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($dpst_code)) {
			$this->db->where_in('m.dpst', $dpst_code);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if ($limit != '') {
			if ($start != '') {
				$this->db->limit($limit, $start);
			} else {
				$this->db->limit($limit, 0);
			}
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query()); die; 	  
	}


	/* ----------------- ECL First Report ---------------*/

	public function getEclFirstdaysAmt($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $ecl_category = '', $from = '', $to = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('sum(overdue) as overdue, sum(fx_overdue) as fx_overdue');
		$this->db->from('month_end_ar_process_data');

		$this->db->group_start();
		if ($to == 1081) {
			$this->db->where('od_days > "' . $to . '"');
		} else {
			$this->db->where('od_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($ecl_category)) {
			$this->db->where_in('ecl_category', $ecl_category);
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}


	public function getEclTotalBalanceAmt($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $ecl_category = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('sum(balance_amount) as balance_amount, sum(fx_balance_amount) as fx_balance_amount, sum(retention) as retention, sum(within_due) as within_due, sum(fx_within_due) as fx_within_due, sum(overdue) as overdue, sum(fx_overdue) as fx_overdue');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($ecl_category)) {
			$this->db->where_in('ecl_category', $ecl_category);
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}



	public function getEclTwoTotalBalanceAmt($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $ecl_category = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('sum(retention) as retention');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($ecl_category)) {
			$this->db->where_in('ecl_category', $ecl_category);
		}


		return $this->db->get()->result();
	}


	public function getEclTwo_Not_dueAmt($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $ecl_category = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('sum(retention) as retention_notdue');
		$this->db->from('month_end_ar_process_data');
		$this->db->where("ecl_days < 0");
		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($ecl_category)) {
			$this->db->where_in('ecl_category', $ecl_category);
		}

		return $this->db->get()->result();
	}


	public function getEclTwodaysAmt($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $ecl_category = '', $from = '', $to = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('sum(retention) as retention');
		$this->db->from('month_end_ar_process_data');

		$this->db->group_start();
		if ($to == 1081) {
			$this->db->where('ecl_days > "' . $to . '"');
		} else {
			$this->db->where('ecl_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($ecl_category)) {
			$this->db->where_in('ecl_category', $ecl_category);
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}


	/*-------------- Collection summary --------------*/

	public function getSBUCollectionSummary($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		/* if (!empty($ar_type)) {
			$ar_type_name = array();
			foreach ($ar_type as $a) {
				$ar_type_name[] = trim(get_artype_name($a));
			}
		} */

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('m.sbu, sum(m.balance_amount) as bal, sum(m.fx_balance_amount) as fx_bal, sum(m.overdue) as overdue, sum(m.fx_overdue) as fx_overdue, sum(m.ftm_due) as ftm_due, sum(m.fx_ftm_due) as fx_ftm_due, sum(m.within_due) as within_due, sum(m.retention) as ret, sum(m.warranty_retention) as wret');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		$this->db->group_by('m.sbu');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}

	public function getSBUCollectionSummaryMonthEndAR($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $invoice_type = '')
	{

		/* if (!empty($ar_type)) {
			$ar_type_name = array();
			foreach ($ar_type as $a) {
				$ar_type_name[] = trim(get_artype_name($a));
			}
		} */

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('sum(m.actual_coll_amount) as actual_coll_amount');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}

		$this->db->group_by('m.sbu');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}



	public function getVerticalSBUlist($console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		$this->db->select('v.sbu_id');
		$this->db->from('vertical_entity_mapping as v');

		if (!empty($console_entity)) {
			$this->db->where_in('console_id', $console_entity);
		}

		if (!empty($sbu_id)) {
			$this->db->where_in('sbu_id', $sbu_id);
		}

		if (!empty($cluster_id)) {
			$this->db->where_in('cluster_id', $cluster_id);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('vertical_id', $vertical_id);
		}

		$this->db->group_by('sbu_id');
		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}



	public function getSBUCollectionPlanSummary($month_year = '', $console_id = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		$this->db->select('sum(u.advance) as adv, sum(u.collection) as col, sum(u.od) as od, sum(u.ftm) as ftm, sum(u.not_due) as not_due, sum(u.same_eith_mht) as sam, sum(u.rtn_w_rtn) as rtn_w_rtn');
		$this->db->from('upload_collection_plan as u');
		$this->db->join('vertical_master as vm', 'vm.vertical_name = u.vertical_name', 'left');
		$this->db->join('vertical_entity_mapping as v', 'v.vertical_id = vm.id', 'left');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}

		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}

		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}

		$this->db->group_by('v.sbu_id');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}


	public function getSBUActualCollectionPlanSummary($month_year = '', $console_id = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		$this->db->select('sum(u.adavance) as adv, sum(u.collection) as col');
		$this->db->from('daily_collection as u');
		$this->db->join('vertical_master as vm', 'vm.vertical_name = u.vertical', 'left');
		$this->db->join('vertical_entity_mapping as v', 'v.vertical_id = vm.id', 'left');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}

		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}

		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}

		$this->db->group_by('v.sbu_id');
		return $this->db->get()->result()[0];
	}


	public function getVerticleMappingClusterNames($sbu_id = '', $cluster_id = '', $vertical_id = '', $console_id = '')
	{

		$this->db->select('v.*');
		$this->db->from('vertical_entity_mapping as v');
		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}
		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}
		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}
		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}
		return $this->db->get()->result();
	}


	public function getVerticalCollectionSummary($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('m.sbu, sum(m.balance_amount) as bal, sum(m.fx_balance_amount) as fx_bal, sum(m.overdue) as overdue, sum(m.fx_overdue) as fx_overdue, sum(m.ftm_due) as ftm_due, sum(m.fx_ftm_due) as fx_ftm_due, sum(m.within_due) as within_due, sum(m.retention) as ret, sum(m.warranty_retention) as wret');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		$this->db->group_by('m.vertical');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}


	public function getVerticalCollectionPlanSummary($month_year = '', $console_id = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		$this->db->select('sum(u.advance) as adv, sum(u.collection) as col, sum(u.od) as od, sum(u.ftm) as ftm, sum(u.not_due) as not_due, sum(u.same_eith_mht) as sam, sum(u.rtn_w_rtn) as rtn_w_rtn');
		$this->db->from('upload_collection_plan as u');
		$this->db->join('vertical_master as vm', 'vm.vertical_name = u.vertical_name', 'left');
		$this->db->join('vertical_entity_mapping as v', 'v.vertical_id = vm.id', 'left');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}

		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}

		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}

		$this->db->group_by('v.vertical_id');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}


	public function getVerticalActualCollectionPlanSummary($month_year = '', $console_id = '', $sbu_id = '', $cluster_id = '', $vertical_id = '')
	{

		$this->db->select('sum(u.adavance) as adv, sum(u.collection) as col');
		$this->db->from('daily_collection as u');
		$this->db->join('vertical_master as vm', 'vm.vertical_name = u.vertical', 'left');
		$this->db->join('vertical_entity_mapping as v', 'v.vertical_id = vm.id', 'left');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_id)) {
			$this->db->where_in('v.console_id', $console_id);
		}

		if (!empty($sbu_id)) {
			$this->db->where_in('v.sbu_id', $sbu_id);
		}

		if (!empty($cluster_id)) {
			$this->db->where_in('v.cluster_id', $cluster_id);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('v.vertical_id', $vertical_id);
		}

		$this->db->group_by('v.vertical_id');
		return $this->db->get()->result()[0];
	}


	public function getVerticalCollectionSummaryMonthEndAR($month_year = '', $console_entity = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $invoice_type = '')
	{

		/* if (!empty($ar_type)) {
			$ar_type_name = array();
			foreach ($ar_type as $a) {
				$ar_type_name[] = trim(get_artype_name($a));
			}
		} */

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}


		$this->db->select('sum(m.actual_coll_amount) as actual_coll_amount');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		/* if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		} */

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}

		$this->db->group_by('m.sbu');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}


	public function getmonth_end_ar_list($sbu_id, $cluster_id, $vertical_id, $console_entity)
	{

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach (explode(',', $vertical_id) as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}

		$this->db->select('org_document_number, child_code, customer_name');
		$this->db->from('month_end_ar_process_data');
		
		$this->db->where('fema_days >', 240);

		$this->db->group_start();
		if ($to == 1081) {
			$this->db->where('ecl_days > "' . $to . '"');
		} else {
			$this->db->where('ecl_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', date('m-Y', strtotime($month_year)));
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		return $this->db->get()->result();

		// print_r($this->db->last_query());

	}


	//------------ Dashboard Links ------------------------//


	public function grtTopODCustomers($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}

		$this->db->select('overdue, od_days, child_code, customer_name');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}

		$this->db->order_by("overdue", "desc");
		$this->db->limit(15);
		return $this->db->get()->result();

		// print_r($this->db->last_query());die;

	}
	
	
	
	public function getTopCollection($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('u.collection,m.*');
		$this->db->from('daily_collection as u');
		$this->db->join('month_end_ar_process_data as m', 'm.org_document_number = u.org_doc_number', 'left');

		if (!empty($month_year)) {
			$this->db->where('u.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('m.console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}
		
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}

		$this->db->order_by("collection", "desc");
		$this->db->limit(15);
		return $this->db->get()->result();
		
		// print_r($this->db->last_query());die;
	}
	
	
	public function getDashboardMonthEndAR($month_year = '', $org_doc_number = '', $invoice_type = '')
	{

		$this->db->select('m.actual_coll_amount');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		if (!empty($org_doc_number)) {
			$this->db->where('m.org_document_number', $org_doc_number);
		}
		
		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}

		return $this->db->get()->result()[0];

	}
	
		public function getCollectionPerformancesummary($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('*');
		$this->db->from('month_end_ar_process_data');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}

		$this->db->order_by("planned_coll_amt", "desc");
		$this->db->limit(15);
		return $this->db->get()->result();
		
		// print_r($this->db->last_query());die;
	}
	
	
	
	public function getcollectiontrendData($current_date = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('sum(u.collection) as col_amount');
		$this->db->from('daily_collection as u');
		$this->db->join('month_end_ar_process_data as m', 'm.org_document_number = u.org_doc_number', 'left');

		if (!empty($current_date)) {
			$this->db->where('u.document_date', $current_date);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('u.vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('m.console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}

		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('u.vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by('u.document_date');
		return $this->db->get()->result()[0];
		
		// print_r($this->db->last_query());die;
	}
	
	public function getTotalCollectionAmt($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '', $org_document_number)
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('u.collection as col_amount');
		$this->db->from('daily_collection as u');
		$this->db->join('month_end_ar_process_data as m', 'm.org_document_number = u.org_doc_number', 'left');

		if (!empty($month_year)) {
			$this->db->where('u.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('u.vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('m.console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}
		
		if (!empty($org_document_number)) {
			$this->db->where_in('u.org_doc_number', $org_document_number);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('u.vertical', $ver_name);
		}
		
		}
		
		return $this->db->get()->result()[0];
		
		// print_r($this->db->last_query());die;
	}
	
	
	public function getdashboardCollectionData($month_year='', $sbu_id='', $cluster_id='', $vertical_id='', $console_entity='', $country_id='', $ar_type_id='', $invoice_type = '', $document_no ='')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}
		
		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('sum(m.planned_coll_amt) as planned_coll_amt');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}
		
		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}
		
		if (!empty($document_no)) {
			$this->db->where('m.org_document_number', $document_no);
		}

		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}
		
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}
	
	//------------ Group of responsibility ------------------//
	
	
	public function getdashboardCollectionDataresponsibility($month_year='', $sbu_id='', $cluster_id='', $vertical_id='', $console_entity='', $country_id='', $ar_type_id='', $invoice_type = '', $document_no ='', $responsibility='')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}
		
		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('sum(m.planned_coll_amt) as planned_coll_amt');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}
		
		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}
		
		if (!empty($document_no)) {
			$this->db->where('m.org_document_number', $document_no);
		}
		
		if (!empty($responsibility)) {
			$this->db->where('m.responsibility', $responsibility);
		}
		
		$this->db->group_by("m.responsibility");
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}
		
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}
	
	
		public function top_15_collection_performance_responsibility($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('*');
		$this->db->from('user_input');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by('responsibility');
		$this->db->order_by("planned_coll_amt", "desc");
		$this->db->limit(15);
		return $this->db->get()->result();
		
		// print_r($this->db->last_query());die;
	}
	
	
		public function top_15_collection_performance_customer($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('*');
		$this->db->from('user_input');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by('customer_name');
		$this->db->order_by("planned_coll_amt", "desc");
		$this->db->limit(15);
		return $this->db->get()->result();
		
		// print_r($this->db->last_query());die;
	}
	
	
	
	//------------ Group of Customer ------------------//
	
	
	public function getdashboardCollectionDatacustomer($month_year='', $sbu_id='', $cluster_id='', $vertical_id='', $console_entity='', $country_id='', $ar_type_id='', $invoice_type = '', $document_no ='', $customer_name='')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}

		if (!empty($console_entity)) {
			$console_entity_name = array();
			foreach ($console_entity as $ce) {
				$console_entity_name[] = trim(get_console_name($ce));
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach (explode(',', $sbu_id) as $s) {
				$sbu_name[] = trim(get_sbu_name($s));
			}
		}


		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim(get_cluster_name($c));
			}
		}


		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim(get_vertical_name($v));
			}
		}
		
		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('sum(m.planned_coll_amt) as planned_coll_amt');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}
		
		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}

		if (!empty($console_entity_name)) {
			$this->db->where_in('m.console_entity', $console_entity_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}
		
		if (!empty($document_no)) {
			$this->db->where('m.org_document_number', $document_no);
		}
		
		if (!empty($customer_name)) {
			$this->db->where('m.customer_name', $customer_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by("m.customer_name");
		
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}
	
	
	public function getTotalCollectionAmtcustomer($month_year = '', $sbu_id='', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '', $org_document_number)
	{
		
		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}


		$this->db->select('sum(u.collection) as col_amount');
		$this->db->from('daily_collection as u');
		$this->db->join('month_end_ar_process_data as m', 'm.org_document_number = u.org_doc_number', 'left');

		if (!empty($month_year)) {
			$this->db->where('u.month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('m.ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('m.sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('m.cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('u.vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('m.console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('m.country', $country_name);
		}
		
		if (!empty($org_document_number)) {
			$this->db->where_in('u.org_doc_number', $org_document_number);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('u.vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by('u.customer_name');
		return $this->db->get()->result()[0];
		
		// print_r($this->db->last_query());die;
	}
	
	
	public function getODdaysAmtGraph($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '', $from = '', $to = ''){

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}

		$this->db->select('sum(overdue) as overdue1');
		$this->db->from('month_end_ar_process_data');


		$this->db->group_start();
		if ($to == 731) {
			$this->db->where('od_days > "' . $to . '"');
		} else {
			$this->db->where('od_days BETWEEN "' . $from . '" AND "' . $to . '"');
		}
		$this->db->group_end();

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}

		 return $this->db->get()->result();

		// print_r($this->db->last_query());die;

	}
	
	//------------ 2nd Graph OD------------------//
	
	

	public function getGraphCollectionSummary($month_year = '', $sbu_id = '', $cluster_id = '', $vertical_id = '', $console_entity_id = '', $country_id = '', $ar_type_id = '')
	{

		if (!empty($ar_type_id)) {
			$ar_type_name = array();
			foreach ($ar_type_id as $a) {
				$ar_type_name[] = trim($a);
			}
		}



		if (!empty($vertical_id)) {
			$vertical_name = array();
			foreach ($vertical_id as $v) {
				$vertical_name[] = trim($v);
			}
		}

		if (!empty($cluster_id)) {
			$cluster_name = array();
			foreach ($cluster_id as $c) {
				$cluster_name[] = trim($c);
			}
		}

		if (!empty($sbu_id)) {
			$sbu_name = array();
			foreach ($sbu_id as $s) {
				$sbu_name[] = trim($s);
			}
		}

		if (!empty($console_entity_id)) {
			$console_name = array();
			foreach ($console_entity_id as $co) {
				$console_name[] = trim($co);
			}
		}

		if (!empty($country_id)) {
			$country_name = array();
			foreach ($country_id as $cu) {
				$country_name[] = trim($cu);
			}
		}

		$this->db->select('m.sbu, sum(m.balance_amount) as bal, sum(m.overdue) as overdue, sum(m.ftm_due) as ftm_due, sum(m.within_due) as within_due, sum(m.retention) as ret, sum(m.warranty_retention) as wret');
		$this->db->from('month_end_ar_process_data as m');


		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($ar_type_name)) {
			$this->db->where_in('ar_type', $ar_type_name);
		}

		if (!empty($sbu_name)) {
			$this->db->where_in('sbu', $sbu_name);
		}

		if (!empty($cluster_name)) {
			$this->db->where_in('cluster', $cluster_name);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('vertical', $vertical_name);
		}

		if (!empty($console_name)) {
			$this->db->where_in('console_entity', $console_name);
		}

		if (!empty($country_name)) {
			$this->db->where_in('country', $country_name);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('vertical', $ver_name);
		}
		
		}

		$this->db->group_by('month_year');
		
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}
	
	
	public function getGraphCollectionPlanSummary($month_year = '', $vertical_id = '')
	{

		$this->db->select('sum(u.advance) as adv, sum(u.collection) as col, sum(u.od) as od, sum(u.ftm) as ftm, sum(u.not_due) as not_due, sum(u.same_eith_mht) as sam, sum(u.rtn_w_rtn) as rtn_w_rtn');
		$this->db->from('upload_collection_plan as u');

		if (!empty($month_year)) {
			$this->db->where('month_year', $month_year);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('u.vertical_name', $vertical_id);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('u.vertical_name', $ver_name);
		}
		
		}

		$this->db->group_by('u.month_year');
		return $this->db->get()->result()[0];

		// print_r($this->db->last_query());

	}
	
	
	public function getGraphActualCollectionPlanSummary($month_year = '',$vertical_id = '')
	{

		$this->db->select('sum(u.adavance) as adv, sum(u.collection) as col');
		$this->db->from('daily_collection as u');

		if (!empty($month_year)) {
			$this->db->where('u.month_year', $month_year);
		}

		if (!empty($vertical_id)) {
			$this->db->where_in('u.vertical', $vertical_id);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('u.vertical', $ver_name);
		}
		
		}
		
		$this->db->group_by('u.month_year');
		return $this->db->get()->result()[0];
	}
	
	
	public function getODActualCollection($month_year = '', $vertical_id = '', $invoice_type = '')
	{

		$this->db->select('sum(m.actual_coll_amount) as actual_coll_amount');
		$this->db->from('month_end_ar_process_data as m');

		if (!empty($month_year)) {
			$this->db->where('m.month_year', $month_year);
		}

		if (!empty($vertical_name)) {
			$this->db->where_in('m.vertical', $vertical_name);
		}

		if (!empty($invoice_type)) {
			$this->db->where('m.invoice_type', $invoice_type);
		}
		
		if($this->ion_auth->is_user()){ 
			
		$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
		
		
		if (!empty($ver_id)) {
			$ver_name = array();
			foreach (explode(',',$ver_id) as $ve) { 
				$ver_name[] = trim(get_vertical_name($ve));
			}
		}
		
		
		if (!empty($ver_name)) {
			$this->db->where_in('m.vertical', $ver_name);
		}
		
		}

		$this->db->group_by('m.month_year');
		return $this->db->get()->result()[0];

	}


}
