<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends Admin_Controller
{

	public function __construct()
	{


		parent::__construct();

		/* Load :: Common */
		$this->load->helper('number');
		$this->load->model('admin/dashboard_model');
	}


	public function index()
	{

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			// print_r($this->db->last_query());die;

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id IN (" . $v .") ORDER by position " )->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		} else {



			$this->data['vertical_master']  = $this->db->query("select * from vertical_master ORDER by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master ORDER by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		}



		if ($this->input->post("od_ageing_category") != '') {
			$od_ageing_category = $this->input->post("od_ageing_category");
			$this->data['od_ageing_category'] = $this->input->post("od_ageing_category");
		} else {
			$od_ageing_category = '';
			$this->data['od_ageing_category'] = '';
		}


		if (is_array($this->input->post("sbu_id"))) {
			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $sbu_id;
			}
		} else {
			if ($this->input->post("sbu_id") != '') {
				$sbu_id = explode(',', $this->input->post("sbu_id"));
				$this->data['sbu_id'] = $sbu_id;
			}
		}

		if (is_array($this->input->post("cluster_id"))) {
			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}
		} else {
			if ($this->input->post("cluster_id") != '') {
				$cluster_id = explode(',', $this->input->post("cluster_id"));
				$this->data['cluster_id'] = $cluster_id;
			}
		}


		if (is_array($this->input->post("vertical_id"))) {
			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $vertical_id;
			}
		} else {
			if ($this->input->post("vertical_id") != '') {
				$vertical_id = explode(',', $this->input->post("vertical_id"));
				$this->data['vertical_id'] = $vertical_id;
			}
		}

		if (is_array($this->input->post("ar_type_id"))) {
			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $ar_type_id;
			}
		} else {
			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = explode(',', $this->input->post("ar_type_id"));
				$this->data['ar_type_id'] = $ar_type_id;
			}
		}


		if (is_array($this->input->post("consol_id"))) {
			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $consol_id;
			}
		} else {
			if ($this->input->post("consol_id") != '') {
				$consol_id = explode(',', $this->input->post("consol_id"));
				$this->data['consol_id'] = $consol_id;
			}
		}

		if (is_array($this->input->post("country_id"))) {
			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $country_id;
			}
		} else {
			if ($this->input->post("country_id") != '') {
				$country_id = explode(',', $this->input->post("country_id"));
				$this->data['country_id'] = $country_id;
			}
		}
		
		
		if (is_array($this->input->post("region_id"))) {
			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $region_id;
			}
		} else {
			if ($this->input->post("region_id") != '') {
				$region_id = explode(',', $this->input->post("region_id"));
				$this->data['region_id'] = $region_id;
			}
		}


		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
			$this->data['denomination'] = $this->input->post("denomination");
		} else {
			$this->data['denomination'] = 1000000;
		}

		// if ($this->input->post("month_year") != '') {

		$month_year = $this->input->post("month_year");
		if ($month_year != '') {
			$this->data['month_year'] = $this->input->post("month_year");
			$month_year = $this->input->post("month_year");
		} else {
			$this->data['month_year'] = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}


		//-------- Top 15 OD Customers -----------//

		$this->data['top_15_od_days'] = $this->base_model->grtTopODCustomers($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $od_ageing_category, $region_id);

		//-------- Top 15 Collection Customers -----------//

		$this->data['top_15_collection_days'] = $this->base_model->getTopCollection($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);

		//-------- Top 15 Collection Performance -----------//

		$this->data['top_15_collection_performance'] = $this->base_model->getCollectionPerformancesummary($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);

		// print_r($this->db->last_query());die;

		//-------- Top 15 Collection Performance responsibility-----------//

		$this->data['top_15_collection_performance_responsibility'] = $this->base_model->top_15_collection_performance_responsibility($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);

		//-------- Top 15 Collection Performance Customer-----------//

		$this->data['top_15_collection_performance_customer'] = $this->base_model->top_15_collection_performance_customer($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);

		$this->data['top_15_late_paying_list'] = $this->base_model->getDelayedCollectionReportLimit($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $country_id, $region_id);

		$this->data['top_15_rolling_collection_list'] = $this->base_model->rollingCollectionReportLimit($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $country_id, $region_id);

		// $this->base_model->rollingCollectionReport($month_year, $console_entity_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $org_document_no);


		$this->data['od_ageing_category_list'] = $this->base_model->od_ageing_category_list($od_ageing_category);

		$this->data['od_ageing_category_list_filter'] = $this->base_model->od_ageing_category_list_filter();

		// print_r($this->db->last_query());die;

		// } else {
		// $this->data['month_year'] = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));

		// $this->data['od_ageing_category_list'] = $this->base_model->od_ageing_category_list($od_ageing_category);

		// $this->data['od_ageing_category_list_filter'] = $this->base_model->od_ageing_category_list_filter();

		// $month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		// }


		$this->template->admin_render('admin/dashboard/index', $this->data);
	}
}
