<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Evencal extends Admin_Controller {
	public function __construct(){
		parent::__construct();
		
		$this->load->helper('url');
		$this->load->helper('security');
		$this->load->model('admin/evencal_model', 'evencal');
		
		$list_team = $this->base_model->run_query(
		"select u.* from users as u  where u.id = ".$this->ion_auth->get_user_id() )[0];
		
		if($list_team->role_id == "1"){
		$this->load->library('calendar', $this->_settings());
		}else{
		$this->load->library('calendar', $this->_setting());
		}
		
		
		
	}
	
	public function index($year = null, $month = null, $day = null){
		
		
		$list = $this->base_model->run_query(
		"select u.* from users as u  where u.id = ".$this->ion_auth->get_user_id() )[0];
		
		
		if($list->role_id == "1"){
		
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('F');
		$day   = (is_numeric($day) &&  $day > 0 && $day < 31)?  $day : date('d');
		
		$date2      = $this->evencal->getTeamLeadDateEvent($year, $month);
		$cur_event = $this->evencal->getTeamLeadEvent($year, $month, $day);
		
		$data      = array(
						'notes' => $this->calendar->generate($year, $month, $date2),
						'year'  => $year, 
						'mon'   => $month,
						'month' => $this->team_month($month),
						'day'   => $day,
						'events'=> $cur_event
					);
		   
		   $this->template->admin_render('admin/audits/team_lead_calender', $data);
		   
	}else{
		
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('F');
		$day   = (is_numeric($day) &&  $day > 0 && $day < 31)?  $day : date('d');
		
		$date      = $this->evencal->getDateEvent($year, $month, $day);
		$cur_event = $this->evencal->getEvent($year, $month, $day);
		
		$data      = array(
						'notes' => $this->calendar->generate($year, $month, $date),
						'year'  => $year, 
						'mon'   => $month,
						'month' => $this->_month($month),
						'day'   => $day,
						'events'=> $cur_event
					);
					
		
		   $this->template->admin_render('admin/audits/calender', $data);
			 
	}			 
	}
	
	// for convert (int) month to (string) month in Indonesian
	public function _month($month){
		$month = (int) $month;
		switch($month){
			case 1 : $month = 'January'; Break;
			case 2 : $month = 'February'; Break;
			case 3 : $month = 'March'; Break;
			case 4 : $month = 'April'; Break;
			case 5 : $month = 'May'; Break;
			case 6 : $month = 'June'; Break;
			case 7 : $month = 'July'; Break;
			case 8 : $month = 'August'; Break;
			case 9 : $month = 'September'; Break;
			case 10 : $month = 'October'; Break;
			case 11 : $month = 'November'; Break;
			case 12 : $month = 'December'; Break;
		}
		return $month;
	}
	
	// get detail event for selected date
	public function detail_event(){		
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
		}else{
			$data = $this->evencal->getEvent($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
		
			if($data == null){
				echo json_encode(array('status' => false, 'title_msg' => 'No Event', 'msg' => 'There\'s no event in this date'));
			}else{			
				echo json_encode(array('status' => true, 'data' => $data));
			}
		}
	}
	
	// popup for adding event
	public function add_event(){
		$data = array(
					'day'   => $this->input->post('day', true),
					'mon'   => $this->input->post('mon', true),
					'month' => $this->_month($this->input->post('mon', true)),
					'year'  => $this->input->post('year', true),
				);
				
				
				$this->load->view('admin/audits/add_event', $data);
				
		 //$this->template->admin_render('admin/audits/add_event', $data);
	}
	
	// do adding event for selected date
	public function do_add(){
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		$this->form_validation->set_rules('hour', 'Hour', 'trim|required');
		$this->form_validation->set_rules('minute', 'Minute', 'trim|required');
		$this->form_validation->set_rules('event', 'Event', 'trim|required');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
		}else{
			$this->evencal->addEvent($this->input->post('year', true), 
											 $this->input->post('mon', true), 
											 $this->input->post('day', true), 
											 $this->input->post('hour', true).":".$this->input->post('minute', true).":00",
											 $this->input->post('event', true));
			echo json_encode(array('status' => true, 'time' => $this->input->post('time', true), 'event' => $this->input->post('event', true)));
		}
	}
	
	// delete event
	public function delete_event(){
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		$this->form_validation->set_rules('del', 'ID', 'trim|required|is_natural_no_zero');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false));
		}else{
			$rows = $this->evencal->deleteEvent($this->input->post('year', true),$this->input->post('mon', true),$this->input->post('day', true), $this->input->post('del', true));
			if($rows > 0){
				echo json_encode(array('status' => true, 'row' => $rows));
			}else{
				echo json_encode(array('status' => true, 'row' => $rows, 'title_msg' => 'No Event', 'msg' => 'There\'s no event in this date'));
			}
		}
	}
	
	// same as index() function
	public function detail($year = null, $month = null, $day = null){
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('m');
		$day   = (is_numeric($day) &&  $day > 0 && $day < 31)?  $day : date('d');
		
		$date      = $this->evencal->getDateEvent($year, $month);
		$cur_event = $this->evencal->getEvent($year, $month, $day);
		$data 	   = array(
						'notes' => $this->calendar->generate($year, $month, $date),
						'year'  => $year,
						'mon'   => $month,
						'month' => $this->_month($month),
						'day'   => $day,
						'events'=> $cur_event
					);
					
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*, um.* from audit as a left join user_mapping as um on a.company_id = um.company_id group by store_id");
		
		 $this->template->admin_render('admin/audits/calender', $data , $this->data);
	}
	
	// setting for calendar
	public function _setting(){
		return array(
			'start_day' 		=> 'monday',
			'show_next_prev' 	=> true,
			'next_prev_url' 	=> base_url('admin/evencal'),
			'month_type'   		=> 'long',
            'day_type'     		=> 'short',
			'template' 			=> '{table_open}<table class="date">{/table_open}
								   {heading_row_start}&nbsp;{/heading_row_start}
								   {heading_previous_cell}<caption><a href="{previous_url}" class="prev_date" title="Previous Month"><i class="fa fa-fw fa-chevron-circle-left"></i></a>{/heading_previous_cell}
								   {heading_title_cell}<span class="head">{heading}</span>{/heading_title_cell}
								   {heading_next_cell}<a href="{next_url}" class="next_date"  title="Next Month"><i class="fa fa-fw fa-chevron-circle-right"></i></a></caption>{/heading_next_cell}
								   {heading_row_end}<col class="weekday" span="5"><col class="weekend_sat"><col class="weekend_sun">{/heading_row_end}
								   {week_row_start}<thead><tr>{/week_row_start}
								   {week_day_cell}<th>{week_day}</th>{/week_day_cell}
								   {week_row_end}</tr></thead><tbody>{/week_row_end}
								   {cal_row_start}<tr>{/cal_row_start}
								   {cal_cell_start}  <td>{/cal_cell_start}
								    
									
								   {cal_cell_content}
								   <div class="date_event detail" data-toggle="modal" data-target="#myModal" val="{day}">
								   <span class="date">{day}</span><span class="event d{day}">{content}</span>
								   </div>
								   {/cal_cell_content}
									
								   
								   {cal_cell_content_today}<div class="active_date_event detail" data-toggle="modal" data-target="#myModal" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div>{/cal_cell_content_today}
								   
								   
								   {cal_cell_no_content}<div class="no_event detail" data-toggle="modal" data-target="#myModal" val="{day}"><span class="date">{day}</span><span class="eventnn d{day}">&nbsp;</span></div>{/cal_cell_no_content}
								   
								   
								   {cal_cell_no_content_today}<div class="active_no_event detail" data-toggle="modal" data-target="#myModal" val="{day}"><span class="date">{day}</span><span class="eventnn d{day}">&nbsp;</span></div>{/cal_cell_no_content_today}
								   
								   
								   {cal_cell_blank}&nbsp;{/cal_cell_blank}
								   {cal_cell_end}</td> {/cal_cell_end}
								   
								   
								   {cal_row_end}</tr>{/cal_row_end}
								   {table_close}</tbody></table>{/table_close}');
	}
	
	
	/***************************************Team lead Calander*********************/
	
	
	// for convert (int) month to (string) month in Indonesian
	public function team_month($month){
		$month = (int) $month;
		switch($month){
			case 1 : $month = 'January'; Break;
			case 2 : $month = 'February'; Break;
			case 3 : $month = 'March'; Break;
			case 4 : $month = 'April'; Break;
			case 5 : $month = 'May'; Break;
			case 6 : $month = 'June'; Break;
			case 7 : $month = 'July'; Break;
			case 8 : $month = 'August'; Break;
			case 9 : $month = 'September'; Break;
			case 10 : $month = 'October'; Break;
			case 11 : $month = 'November'; Break;
			case 12 : $month = 'December'; Break;
		}
		return $month;
	}
	
	// get detail event for selected date
	public function team_detail_event(){		
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
		}else{
			$data = $this->evencal->getTeamLeadEvent($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
			if($data == null){
				echo json_encode(array('status' => false, 'title_msg' => 'No Event', 'msg' => 'There\'s no event in this date'));
			}else{			
				echo json_encode(array('status' => true, 'data' => $data));
			}
		}
	}
	
	// popup for adding event
	public function team_add_event(){
		$data = array(
					'day'   => $this->input->post('day', true),
					'mon'   => $this->input->post('mon', true),
					'month' => $this->team_month($this->input->post('mon', true)),
					'year'  => $this->input->post('year', true),
				);
				
				
				$this->load->view('admin/audits/team_add_event', $data);
				
		 //$this->template->admin_render('admin/audits/add_event', $data);
	}
	
	// do adding event for selected date
	public function team_do_add(){
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		$this->form_validation->set_rules('hour', 'Hour', 'trim|required');
		$this->form_validation->set_rules('minute', 'Minute', 'trim|required');
		$this->form_validation->set_rules('event', 'Event', 'trim|required');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
		}else{
			$this->evencal->addEvent($this->input->post('year', true), 
											 $this->input->post('mon', true), 
											 $this->input->post('day', true), 
											 $this->input->post('hour', true).":".$this->input->post('minute', true).":00",
											 $this->input->post('event', true));
			echo json_encode(array('status' => true, 'time' => $this->input->post('time', true), 'event' => $this->input->post('event', true)));
		}
	}
	
	// delete event
	public function team_delete_event(){
		$this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
		$this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
		$this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
		$this->form_validation->set_rules('del', 'ID', 'trim|required|is_natural_no_zero');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('status' => false));
		}else{
			$rows = $this->evencal->deleteEvent($this->input->post('year', true),$this->input->post('mon', true),$this->input->post('day', true), $this->input->post('del', true));
			if($rows > 0){
				echo json_encode(array('status' => true, 'row' => $rows));
			}else{
				echo json_encode(array('status' => true, 'row' => $rows, 'title_msg' => 'No Event', 'msg' => 'There\'s no event in this date'));
			}
		}
	}
	
	// same as index() function
	public function team_detail($year = null, $month = null, $day = null){
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('m');
		$day   = (is_numeric($day) &&  $day > 0 && $day < 31)?  $day : date('d');
		
		$date      = $this->evencal->getTeamLeadDateEvent($year, $month);
		$cur_event = $this->evencal->getTeamLeadEvent($year, $month, $day);
		$data 	   = array(
						'notes' => $this->calendar->generate($year, $month, $date),
						'year'  => $year,
						'mon'   => $month,
						'month' => $this->team_month($month),
						'day'   => $day,
						'events'=> $cur_event
					);
					
		
		 $this->template->admin_render('admin/audits/team_lead_calender', $data);
	}
	
	// setting for calendar
	public function _settings(){
		return array(
			'start_day' 		=> 'monday',
			'show_next_prev' 	=> true,
			'next_prev_url' 	=> base_url('admin/evencal'),
			'month_type'   		=> 'long',
            'day_type'     		=> 'short',
			'template' 			=> '{table_open}<table class="date">{/table_open}
								   {heading_row_start}&nbsp;{/heading_row_start}
								   {heading_previous_cell}<caption><a href="{previous_url}" class="prev_date" title="Previous Month"><i class="fa fa-fw fa-chevron-circle-left"></i></a>{/heading_previous_cell}
								   {heading_title_cell}<span class="head">{heading}</span>{/heading_title_cell}
								   {heading_next_cell}<a href="{next_url}" class="next_date"  title="Next Month"><i class="fa fa-fw fa-chevron-circle-right"></i></a></caption>{/heading_next_cell}
								   {heading_row_end}<col class="weekday" span="5"><col class="weekend_sat"><col class="weekend_sun">{/heading_row_end}
								   {week_row_start}<thead><tr>{/week_row_start}
								   {week_day_cell}<th>{week_day}</th>{/week_day_cell}
								   {week_row_end}</tr></thead><tbody>{/week_row_end}
								   {cal_row_start}<tr>{/cal_row_start}
								   {cal_cell_start}  <td>{/cal_cell_start}
								    
									
								   {cal_cell_content}

								   <a href="http://proteam.co.in/showroom/admin/audits/team_audit_list"><div class="date_event detail" val="{day}">
								   <span class="date">{day}</span><span class="event d{day}">{content}</span>
								   </div></a>
								   {/cal_cell_content}
									
									
								   
								   {cal_cell_content_today}
								   <a href="http://proteam.co.in/showroom/admin/audits/team_audit_list"><div class="active_date_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div></a>
								   {/cal_cell_content_today}
								   
								   
								   {cal_cell_no_content}<div class="no_event detail" val="{day}"><span class="date">{day}</span><span class="eventnn d{day}">&nbsp;</span></div>{/cal_cell_no_content}
								   
								   
								   {cal_cell_no_content_today}<div class="active_no_event detail" val="{day}"><span class="date">{day}</span><span class="eventnn d{day}">&nbsp;</span></div>{/cal_cell_no_content_today}
								   
								   
								   {cal_cell_blank}&nbsp;{/cal_cell_blank}
								   {cal_cell_end}</td> {/cal_cell_end}
								   
								   
								   {cal_row_end}</tr>{/cal_row_end}
								   {table_close}</tbody></table>{/table_close}');
	}
	
	
	/***************************************End Team Lead Calander*****************/
	
}