<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Groups extends CI_Controller {

    public function __construct()
	{
		parent::__construct();

		$this->load->helper('security');

		$this->load->model('Base_model');

		$this->load->model('ajax_model');

		$this->load->library('form_validation');

		$this->load->helper('url');

		$this->load->library("pagination");

		$this->load->library('excel');

		$this->load->model('Ajax_model');
	}


	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['groups'] = $this->ion_auth->groups()->result();

            /* Load Template */
            $this->template->admin_render('admin/groups/index', $this->data);
        }
    }


		public function cron_in()
		{
		 
		 
		 $current_array = $this->db->get_where('cron_table', array('cron_type' => 'current_ar', 'cron_status' => 0, 'process_data' => 0 ))->result();
		
		 
		 $month_end_array = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'cron_status' => 0, 'process_data' => 0 ))->result();
		 
		 
		 if(count($current_array) > 0){
			 
		// $month_year = $current_array[0]->month;

		// if ($month_year != '') {
			
			$this->db->set("process_data", 1);
			$this->db->where("cron_type", "current_ar");
			// $this->db->where("month", $month_year);
			$this->db->update('cron_table');


			/*--------- DPST SEARCH --------*/
			
			

			// $ar_type = array('90993', '90994', '90995', '90996');
			
			$ar_type = $this->base_model->month_end_ar_list_DPST_No();

			$current_ar_data = $this->base_model->current_ar_list_DPST($ar_type);

			$table_rep = "current_ar_process_data";



			if (!empty($current_ar_data)) {
				$fetchData = array();
				foreach ($current_ar_data as $key => $m) {


					$fetchData[$key]['ar_type'] 		= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchData[$key]['vertical']		= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchData[$key]['cluster'] 		= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchData[$key]['sbu'] 			= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchData[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchData[$key]['country'] 		= get_country_name(get_area_country($m->area)->country_id);

					$fetchData[$key]['daily_ar_id']		= $m->daily_ar_id;
					$fetchData[$key]['month_year'] 		= $m->month_year;
					$fetchData[$key]['area'] 			= $m->area;
					$fetchData[$key]['region'] 			= $m->region;
					$fetchData[$key]['dpst'] 			= $m->dpst;
					$fetchData[$key]['month'] 			= $m->month;
					$fetchData[$key]['sales_engg_code'] = $m->sales_engg_code;
					$fetchData[$key]['sales_engg_name'] = $m->sales_engg_name;
					$fetchData[$key]['customer_group'] 	= $m->customer_group;
					$fetchData[$key]['parent_code'] 	= $m->parent_code;
					$fetchData[$key]['child_code'] 		= $m->child_code;
					$fetchData[$key]['customer_name'] 	= $m->customer_name;
					$fetchData[$key]['project_name'] 	= $m->project_name;
					$fetchData[$key]['po_name'] 		= $m->po_name;
					$fetchData[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData[$key]['company'] 		= $m->company;
					$fetchData[$key]['transaction_type'] = $m->transaction_type;
					$fetchData[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData[$key]['org_document_number'] = $m->org_document_number;
					$fetchData[$key]['document_number'] = $m->document_number;
					$fetchData[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData[$key]['invoice_date']	= $m->invoice_date;
					$fetchData[$key]['credit_days'] 	= $m->credit_days;
					$fetchData[$key]['due_date']		= $m->due_date;
					$fetchData[$key]['credit_days_adj'] = $m->credit_days_adj;
					$fetchData[$key]['rev_due_date'] 	= $m->rev_due_date;
					$fetchData[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData[$key]['paid_amount'] 	= $m->paid_amount;
					$fetchData[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData[$key]['currency']		= $m->currency;
					$fetchData[$key]['fx_rate'] 		= $m->fx_rate;
					$fetchData[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData[$key]['customer_type'] 	= $m->customer_type;
					$fetchData[$key]['ecl_category'] 	= $m->ecl_category;
					$fetchData[$key]['consol'] 			= $m->consol;
					$fetchData[$key]['org_dpst'] 		= $m->org_dpst;
					$fetchData[$key]['org_tt'] 			= $m->org_tt;
					$fetchData[$key]['fema_days'] 		= $m->fema_days;
					$fetchData[$key]['ecl_days'] 		= $m->ecl_days;
					$fetchData[$key]['user_id'] 		= 1;
					
					$user_input_current_1 =  get_current_ar_user_input($m->org_document_number);

					$fetchData[$key]['responsibility'] 	= $user_input_current_1->responsibility;

					$fetchData[$key]['planned_coll_amt'] = $user_input_current_1->planned_coll_amt;
					$fetchData[$key]['planned_coll_date'] = $user_input_current_1->planned_coll_date;
					$fetchData[$key]['retention'] = $user_input_current_1->retention;
					$fetchData[$key]['warranty_retention'] = $user_input_current_1->warranty_retention;
					$fetchData[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_current_1->planned_rtn_wrtn_coll_amt;
					$fetchData[$key]['planned_rtn_wrtn_date'] = $user_input_current_1->planned_rtn_wrtn_date;
					$fetchData[$key]['pbg_lc'] = $user_input_current_1->pbg_lc;
					$fetchData[$key]['won'] = $user_input_current_1->won;
					$fetchData[$key]['cnaf'] = $user_input_current_1->cnaf;
					$fetchData[$key]['srn'] = $user_input_current_1->srn;
					$fetchData[$key]['foc'] = $user_input_current_1->foc;
					$fetchData[$key]['wds'] = $user_input_current_1->wds;
					$fetchData[$key]['gst_tds'] = $user_input_current_1->gst_tds;
					$fetchData[$key]['tds'] = $user_input_current_1->tds;
					$fetchData[$key]['ld'] = $user_input_current_1->ld;
					$fetchData[$key]['legal'] = $user_input_current_1->legal;
					$fetchData[$key]['commissioning'] = $user_input_current_1->commissioning;
					
					$coll_date = get_daily_collection($m->org_document_number, $user_input_current_1->month_year)->document_date;
					
					$coll_daily = get_daily_collection($m->org_document_number, $user_input_current_1->month_year)->collection;
					
					if($coll_date!=''){
					$fetchData[$key]['actual_coll_date'] = $coll_date;
					}else{
					$fetchData[$key]['actual_coll_date'] = '';	
					}
					
					if($coll_daily!=''){
					$fetchData[$key]['actual_coll_amount'] = $coll_daily;
					}else{
					$fetchData[$key]['actual_coll_amount'] = '';	
					}
					
					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData[$key]['modified_doc']			= 1;
					} else {
						$fetchData[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData[$key]['od_days'] >= '0') {
						$fetchData[$key]['overdue'] = $m->balance_amount - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData[$key]['within_due'] = $m->balance_amount - $fetchData[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[0] != 12){
					$from_date1 = $split_month[0] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1) {
						$fetchData[$key]['ftm_due'] = $fetchData[$key]['within_due'] - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['overdue'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData[$key]['ftm_due'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['od_days'] <= '30') {
						$fetchData[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData[$key]['od_days'] >='31' && $fetchData[$key]['od_days'] <= '60') {
						$fetchData[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData[$key]['od_days'] >= '61' && $fetchData[$key]['od_days'] <= '90') {
						$fetchData[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData[$key]['od_days'] >= '91' && $fetchData[$key]['od_days'] <= '120') {
						$fetchData[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData[$key]['od_days'] >= '121' && $fetchData[$key]['od_days'] <= '150') {
						$fetchData[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData[$key]['od_days'] >= '151' && $fetchData[$key]['od_days'] <= '180') {
						$fetchData[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData[$key]['od_days'] >= '181' && $fetchData[$key]['od_days'] <= '360') {
						$fetchData[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData[$key]['od_days'] >= '361' && $fetchData[$key]['od_days'] <= '720') {
						$fetchData[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData[$key]['od_days'] >= '721' && $fetchData[$key]['od_days'] <= '1080') {
						$fetchData[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData[$key]['od_days'] >= '1081') {
						$fetchData[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData[$key]['od_ageing_category'] 		= "Not Due";
					}


					// Seventh cal FX within Due
					$fx_within_due = $fetchData[$key]['within_due'] / $m->fx_rate;
					if($fx_within_due!='' && !is_nan($fx_within_due) && !is_infinite($fx_within_due) ){
					$fetchData[$key]['fx_within_due'] 		= $fx_within_due;
					}else{
					$fetchData[$key]['fx_within_due'] 		= 0;
					}

					// Eight cal fx_overdue
					
					$fx_overdue = $fetchData[$key]['overdue'] / $m->fx_rate;
					if($fx_overdue!='' && !is_nan($fx_overdue) && !is_infinite($fx_overdue) ){
					$fetchData[$key]['fx_overdue'] 		= $fx_overdue;
					}else{
					$fetchData[$key]['fx_overdue'] 		= 0;
					}

					/* // Night cal fx_ftm_due

					$fetchData[$key]['fx_ftm_due'] 		= $fetchData[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact

					$fetchData[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount; */
					
					
					$fx_ftm_due = round($fetchData[$key]['ftm_due'] / $m->fx_rate);
					
					$fx_impact = (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					if($fx_ftm_due!='' && !is_nan($fx_ftm_due)  && !is_infinite($fx_ftm_due)){
					$fetchData[$key]['fx_ftm_due'] 		= $fx_ftm_due;
					}else{						
					$fetchData[$key]['fx_ftm_due'] 		= '';
					}

					// Tenth cal fx_impact
							
					if($fx_impact!='' && !is_nan($fx_impact)  && !is_infinite($fx_impact)){
					$fetchData[$key]['fx_impact'] 		= $fx_impact;
					}else{						
					$fetchData[$key]['fx_impact'] 		= '';
					}

					// Eleven cal collection_days

					$fetchData[$key]['collection_days'] 		= $this->get_number_of_days($fetchData[$key]['planned_coll_date'], $fetchData[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 1);
					$this->db->update('daily_ar');
				}
			}
			
			// $this->db->query("DELETE FROM current_ar_process_data WHERE month_year='" . $month_year . "'");

			$this->db->query("DELETE FROM current_ar_process_data WHERE 1=1");


			if (!empty($fetchData)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData);

				$this->base_model->importDataCurrentARProcessData();
			}
			


			/*--------- Tarial Units Transaction SEARCH --------*/

			$priority_list = $this->base_model->getTransactionPriorityList(2);

			
			
			$sequence2 = array();
			
			if (!empty($priority_list)) {

				foreach ($priority_list as $p) {

					$TransactionTypeListArray = $this->base_model->getTransactionTypeList(2, $p->priority); 

					$TransactionTypeList = array_column($TransactionTypeListArray, 'transaction_type_code');

					$current_ar_transaction = $this->base_model->current_ar_list_TransactionType($month_year, $TransactionTypeList);

					// echo "<pre>"; print_r($this->db->last_query());die;
					
					$fetchData_TransactionType = array();
					
					if (!empty($current_ar_transaction)) {
						
						foreach ($current_ar_transaction as $key => $m) {

							$fetchData_TransactionType[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);

							$fetchData_TransactionType[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);


							$fetchData_TransactionType[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

							$fetchData_TransactionType[$key]['daily_ar_id'] 		= $m->daily_ar_id;
							$fetchData_TransactionType[$key]['month_year'] 			= $m->month_year;
							$fetchData_TransactionType[$key]['area'] 				= $m->area;
							$fetchData_TransactionType[$key]['region'] 				= $m->region;
							$fetchData_TransactionType[$key]['dpst'] 				= $m->dpst;
							$fetchData_TransactionType[$key]['month'] 				= $m->month;
							$fetchData_TransactionType[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType[$key]['customer_group'] 		= $m->customer_group;
							$fetchData_TransactionType[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType[$key]['child_code'] 			= $m->child_code;
							$fetchData_TransactionType[$key]['customer_name'] 		= $m->customer_name;
							$fetchData_TransactionType[$key]['project_name'] 		= $m->project_name;
							$fetchData_TransactionType[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType[$key]['po_credit_term'] 		= $m->po_credit_term;
							$fetchData_TransactionType[$key]['company'] 			= $m->company;
							$fetchData_TransactionType[$key]['transaction_type'] 	= $m->transaction_type;
							$fetchData_TransactionType[$key]['invoice_number'] 		= $m->invoice_number;
							$fetchData_TransactionType[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType[$key]['dispatch_date'] 		= $m->dispatch_date;
							$fetchData_TransactionType[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType[$key]['rev_due_date'] 		= $m->rev_due_date;
							$fetchData_TransactionType[$key]['invoice_amount'] 		= $m->invoice_amount;
							$fetchData_TransactionType[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType[$key]['balance_amount'] 		= $m->balance_amount;
							$fetchData_TransactionType[$key]['currency']			= $m->currency;
							$fetchData_TransactionType[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
							$fetchData_TransactionType[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
							$fetchData_TransactionType[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
							$fetchData_TransactionType[$key]['customer_type'] 		= $m->customer_type;
							$fetchData_TransactionType[$key]['ecl_category'] 		= $m->ecl_category;
							$fetchData_TransactionType[$key]['consol'] 				= $m->consol;
							$fetchData_TransactionType[$key]['org_dpst'] 			= $m->org_dpst;
							$fetchData_TransactionType[$key]['org_tt'] 				= $m->org_tt;
							$fetchData_TransactionType[$key]['fema_days'] 			= $m->fema_days;
							$fetchData_TransactionType[$key]['ecl_days'] 			= $m->ecl_days;
							$fetchData_TransactionType[$key]['user_id'] 			= 1;
							
							$user_input_current_2 =  get_current_ar_user_input($m->org_document_number);

							$fetchData_TransactionType[$key]['responsibility'] 	= $user_input_current_2->responsibility;

							$fetchData_TransactionType[$key]['planned_coll_amt'] 	= $user_input_current_2->planned_coll_amt;
							$fetchData_TransactionType[$key]['planned_coll_date'] 	= $user_input_current_2->planned_coll_date;
							$fetchData_TransactionType[$key]['retention'] 		= $user_input_current_2->retention;
							$fetchData_TransactionType[$key]['warranty_retention'] = $user_input_current_2->warranty_retention;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_current_2->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_date'] = $user_input_current_2->planned_rtn_wrtn_date;
							$fetchData_TransactionType[$key]['pbg_lc'] 				= $user_input_current_2->pbg_lc;
							$fetchData_TransactionType[$key]['won'] 	= $user_input_current_2->won;
							$fetchData_TransactionType[$key]['cnaf']	= $user_input_current_2->cnaf;
							$fetchData_TransactionType[$key]['srn'] 	= $user_input_current_2->srn;
							$fetchData_TransactionType[$key]['foc'] 	= $user_input_current_2->foc;
							$fetchData_TransactionType[$key]['wds'] 	= $user_input_current_2->wds;
							$fetchData_TransactionType[$key]['tds'] 	= $user_input_current_2->tds;
							$fetchData_TransactionType[$key]['gst_tds'] = $user_input_current_2->gst_tds;
							$fetchData_TransactionType[$key]['ld'] 		= $user_input_current_2->ld;
							$fetchData_TransactionType[$key]['legal'] 	= $user_input_current_2->legal;
							
							/* $fetchData_TransactionType[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number, $m->month_year)->document_date;
							$fetchData_TransactionType[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number, $m->month_year)->collection; */
							
							
							$coll_date = get_daily_collection($m->org_document_number, $user_input_current_2->month_year)->document_date;
					
							$coll_daily = get_daily_collection($m->org_document_number, $user_input_current_2->month_year)->collection;
							
							if($coll_date!=''){
							$fetchData_TransactionType[$key]['actual_coll_date'] = $coll_date;
							}else{
							$fetchData_TransactionType[$key]['actual_coll_date'] = '';	
							}
							
							if($coll_daily!=''){
							$fetchData_TransactionType[$key]['actual_coll_amount'] = $coll_daily;
							}else{
							$fetchData_TransactionType[$key]['actual_coll_amount'] = '';	
							}
					

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType[$key]['od_days'] >= '0') {
								$fetchData_TransactionType[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							if($split_month[0] != 12){
							$from_date1 = $split_month[0] + 1;
							}else{
							$from_date1 = 1;	
							}

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1) {
								$fetchData_TransactionType[$key]['ftm_due'] = $fetchData_TransactionType[$key]['within_due'] - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['overdue'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['od_days'] <= '30') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >='31' && $fetchData_TransactionType[$key]['od_days'] <= '60') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '61' && $fetchData_TransactionType[$key]['od_days'] <= '90') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '91' && $fetchData_TransactionType[$key]['od_days'] <= '120') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '121' && $fetchData_TransactionType[$key]['od_days'] <= '150') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '151' && $fetchData_TransactionType[$key]['od_days'] <= '180') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '181' && $fetchData_TransactionType[$key]['od_days'] <= '360') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '361' && $fetchData_TransactionType[$key]['od_days'] <= '720') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '721' && $fetchData_TransactionType[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Not Due";
							}


									// Seventh cal FX within Due
					$fx_within_due = $fetchData_TransactionType[$key]['within_due'] / $m->fx_rate;
					if($fx_within_due!='' && !is_nan($fx_within_due) && !is_infinite($fx_within_due) ){
					$fetchData_TransactionType[$key]['fx_within_due'] 		= $fx_within_due;
					}else{
					$fetchData_TransactionType[$key]['fx_within_due'] 		= 0;
					}

					// Eight cal fx_overdue
					
					$fx_overdue = $fetchData_TransactionType[$key]['overdue'] / $m->fx_rate;
					if($fx_overdue!='' && !is_nan($fx_overdue) && !is_infinite($fx_overdue) ){
					$fetchData_TransactionType[$key]['fx_overdue'] 		= $fx_overdue;
					}else{
					$fetchData_TransactionType[$key]['fx_overdue'] 		= 0;
					}

							/* // Night cal fx_ftm_due

							$fetchData_TransactionType[$key]['fx_ftm_due'] 		= $fetchData_TransactionType[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount; */
							
							
							$fx_ftm_due = round($fetchData_TransactionType[$key]['ftm_due'] / $m->fx_rate);
					
							$fx_impact = (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
							if($fx_ftm_due!='' && !is_nan($fx_ftm_due) && !is_infinite($fx_ftm_due)){
							$fetchData_TransactionType[$key]['fx_ftm_due'] 		= $fx_ftm_due;
							}else{						
							$fetchData_TransactionType[$key]['fx_ftm_due'] 		= '';
							}

							// Tenth cal fx_impact
							
							if($fx_impact!='' && !is_nan($fx_impact) && !is_infinite($fx_impact)){
							$fetchData_TransactionType[$key]['fx_impact'] 		= $fx_impact;
							}else{						
							$fetchData_TransactionType[$key]['fx_impact'] 		= '';
							}

							// Eleven cal collection_days

							$fetchData_TransactionType[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType[$key]['planned_coll_date'], $fetchData_TransactionType[$key]['actual_coll_date']);

							// Update the Process Data
							$this->db->where('daily_ar_id', $m->daily_ar_id);
							$this->db->set('process_data', 1);
							$this->db->set('sequence', 2);
							$this->db->update('daily_ar');
						}
					}
					
					$sequence2[] = $fetchData_TransactionType;
					
				}
			}
			
			$sequence2_final_result = [];

	foreach ($sequence2 as $value) {
    $sequence2_final_result = array_merge($sequence2_final_result, $value);
	}

	// echo "<pre>"; print_r($sequence2_final_result);die;

			if (!empty($sequence2_final_result)) {

				$this->base_model->setBatchImportCurrentARProcessData($sequence2_final_result);

				$this->base_model->importDataCurrentARProcessData();
			}

			// print_r("Avinash");die;


			/*--------- Value SEARCH --------*/

			$current_ar_by_value = $this->base_model->current_ar_list_value($month_year);

			// print_r($this->db->last_query());die;

			if (!empty($current_ar_by_value)) {
				$fetchData_value = array();
				foreach ($current_ar_by_value as $key => $m) {


					if ($m->balance_amount <= 100 && $m->balance_amount >= 0) {
						
						if(strtoupper($m->consol) == 'ATS'){
							
							$vertical_id = 59;
							
						}elseif(strtoupper($m->consol) == 'ELGI'){
							
							$vertical_id = 18;
							
						}elseif(strtoupper($m->consol) == 'GULF'){
							
							$vertical_id = 76;
							
						}

						$fetchData_value[$key]['vertical'] 			= get_vertical_name($vertical_id);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping($vertical_id)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping($vertical_id)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping($vertical_id)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						
						if(get_vertical_entity_mapping($vertical_id)->console_id == 1){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(13);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 2){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(25);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 4){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(37);
						}
						
					} else if ($m->balance_amount < 0) {

						// print_r($m);die;
						
						if(strtoupper($m->consol) == 'ATS'){
							
							$vertical_id = 60;
							
						}elseif(strtoupper($m->consol) == 'ELGI'){
							
							$vertical_id = 19;
							
						}elseif(strtoupper($m->consol) == 'GULF'){
							
							$vertical_id = 75;
							
						}
						
						$fetchData_value[$key]['vertical'] 			= get_vertical_name($vertical_id);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping($vertical_id)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping($vertical_id)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping($vertical_id)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						
						if(get_vertical_entity_mapping($vertical_id)->console_id == 1){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(14);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 2){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(26);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 4){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(36);
						}
					}

					$fetchData_value[$key]['daily_ar_id'] 		= $m->daily_ar_id;
					$fetchData_value[$key]['month_year'] 		= $m->month_year;
					$fetchData_value[$key]['area'] 				= $m->area;
					$fetchData_value[$key]['region'] 			= $m->region;
					$fetchData_value[$key]['dpst'] 				= $m->dpst;
					$fetchData_value[$key]['month'] 			= $m->month;
					$fetchData_value[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchData_value[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchData_value[$key]['customer_group'] 	= $m->customer_group;
					$fetchData_value[$key]['parent_code'] 		= $m->parent_code;
					$fetchData_value[$key]['child_code'] 		= $m->child_code;
					$fetchData_value[$key]['customer_name'] 	= $m->customer_name;
					$fetchData_value[$key]['project_name'] 		= $m->project_name;
					$fetchData_value[$key]['po_name'] 			= $m->po_name;
					$fetchData_value[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData_value[$key]['company'] 			= $m->company;
					$fetchData_value[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchData_value[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData_value[$key]['org_document_number'] = $m->org_document_number;
					$fetchData_value[$key]['document_number'] 	= $m->document_number;
					$fetchData_value[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData_value[$key]['invoice_date']		= $m->invoice_date;
					$fetchData_value[$key]['credit_days'] 		= $m->credit_days;
					$fetchData_value[$key]['due_date']			= $m->due_date;
					$fetchData_value[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchData_value[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchData_value[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData_value[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchData_value[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData_value[$key]['currency']			= $m->currency;
					$fetchData_value[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchData_value[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData_value[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData_value[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData_value[$key]['customer_type'] 	= $m->customer_type;
					$fetchData_value[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchData_value[$key]['consol'] 			= $m->consol;
					$fetchData_value[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchData_value[$key]['org_tt'] 			= $m->org_tt;
					$fetchData_value[$key]['fema_days'] 		= $m->fema_days;
					$fetchData_value[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchData_value[$key]['user_id'] 			= 1;
					
					$user_input_current_3 =  get_current_ar_user_input($m->org_document_number);
					
					$fetchData_value[$key]['responsibility'] 	= $user_input_current_3->responsibility;


					$fetchData_value[$key]['planned_coll_amt'] 	= $user_input_current_3->planned_coll_amt;
					$fetchData_value[$key]['planned_coll_date'] 	= $user_input_current_3->planned_coll_date;
					$fetchData_value[$key]['retention'] 		= $user_input_current_3->retention;
					$fetchData_value[$key]['warranty_retention'] = $user_input_current_3->warranty_retention;
					$fetchData_value[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_current_3->planned_rtn_wrtn_coll_amt;
					$fetchData_value[$key]['planned_rtn_wrtn_date'] = $user_input_current_3->planned_rtn_wrtn_date;
					$fetchData_value[$key]['pbg_lc'] 	= $user_input_current_3->pbg_lc;
					$fetchData_value[$key]['won'] 		= $user_input_current_3->won;
					$fetchData_value[$key]['cnaf']		= $user_input_current_3->cnaf;
					$fetchData_value[$key]['srn'] 		= $user_input_current_3->srn;
					$fetchData_value[$key]['foc'] 		= $user_input_current_3->foc;
					$fetchData_value[$key]['wds'] 		= $user_input_current_3->wds;
					$fetchData_value[$key]['tds'] 		= $user_input_current_3->tds;
					$fetchData_value[$key]['gst_tds'] 		= $user_input_current_3->gst_tds;
					$fetchData_value[$key]['ld'] 		= $user_input_current_3->ld;
					$fetchData_value[$key]['legal'] 	= $user_input_current_3->legal;
/* 
					$fetchData_value[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number, $m->month_year)->document_date;
					$fetchData_value[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number, $m->month_year)->collection; */
					
					$coll_date = get_daily_collection($m->org_document_number, $user_input_current_3->month_year)->document_date;
					
					$coll_daily = get_daily_collection($m->org_document_number, $user_input_current_3->month_year)->collection;
							
							if($coll_date!=''){
							$fetchData_value[$key]['actual_coll_date'] = $coll_date;
							}else{
							$fetchData_value[$key]['actual_coll_date'] = '';	
							}
							
							if($coll_daily!=''){
							$fetchData_value[$key]['actual_coll_amount'] = $coll_daily;
							}else{
							$fetchData_value[$key]['actual_coll_amount'] = '';	
							}

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData_value[$key]['modified_doc']			= 1;
					} else {
						$fetchData_value[$key]['modified_doc']			= 0;
					}

					// Third Cal

					$fetchData_value[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData_value[$key]['od_days'] >= '0') {
						$fetchData_value[$key]['overdue'] = $m->balance_amount - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData_value[$key]['within_due'] = $m->balance_amount - $fetchData_value[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[0] != 12){
					$from_date1 = $split_month[0] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1) {
						$fetchData_value[$key]['ftm_due'] = $fetchData_value[$key]['within_due'] - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['overdue'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData_value[$key]['ftm_due'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData_value[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['od_days'] <= '30') {
						$fetchData_value[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData_value[$key]['od_days'] >='31' && $fetchData_value[$key]['od_days'] <= '60') {
						$fetchData_value[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '61' && $fetchData_value[$key]['od_days'] <= '90') {
						$fetchData_value[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '91' && $fetchData_value[$key]['od_days'] <= '120') {
						$fetchData_value[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '121' && $fetchData_value[$key]['od_days'] <= '150') {
						$fetchData_value[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '151' && $fetchData_value[$key]['od_days'] <= '180') {
						$fetchData_value[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '181' && $fetchData_value[$key]['od_days'] <= '360') {
						$fetchData_value[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '361' && $fetchData_value[$key]['od_days'] <= '720') {
						$fetchData_value[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '721' && $fetchData_value[$key]['od_days'] <= '1080') {
						$fetchData_value[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '1081') {
						$fetchData_value[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData_value[$key]['od_ageing_category'] 		= "Not Due";
					}


							// Seventh cal FX within Due
					$fx_within_due = $fetchData_value[$key]['within_due'] / $m->fx_rate;
					if($fx_within_due!='' && !is_nan($fx_within_due) && !is_infinite($fx_within_due) ){
					$fetchData_value[$key]['fx_within_due'] 		= $fx_within_due;
					}else{
					$fetchData_value[$key]['fx_within_due'] 		= 0;
					}

					// Eight cal fx_overdue
					
					$fx_overdue = $fetchData_value[$key]['overdue'] / $m->fx_rate;
					if($fx_overdue!='' && !is_nan($fx_overdue) && !is_infinite($fx_overdue) ){
					$fetchData_value[$key]['fx_overdue'] 		= $fx_overdue;
					}else{
					$fetchData_value[$key]['fx_overdue'] 		= 0;
					}

					/* // Night cal fx_ftm_due

					$fetchData_value[$key]['fx_ftm_due'] 		= $fetchData_value[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact
					$fetchData_value[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount; */
					
					
					$fx_ftm_due = round($fetchData_value[$key]['ftm_due'] / $m->fx_rate);
					
					$fx_impact = (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					if($fx_ftm_due!='' && !is_nan($fx_ftm_due) && !is_infinite($fx_ftm_due)){
					$fetchData_value[$key]['fx_ftm_due'] 		= $fx_ftm_due;
					}else{						
					$fetchData_value[$key]['fx_ftm_due'] 		= '';
					}

					// Tenth cal fx_impact
					
					if($fx_impact!='' && !is_nan($fx_impact) && !is_infinite($fx_impact) ){
					$fetchData_value[$key]['fx_impact'] 		= $fx_impact;
					}else{						
					$fetchData_value[$key]['fx_impact'] 		= '';
					}
					

					// Eleven cal collection_days

					$fetchData_value[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_value[$key]['planned_coll_date'], $fetchData_value[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 3);
					$this->db->update('daily_ar');
				}
			}

			// print_r($fetchData_value);die;


			if (!empty($fetchData_value)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData_value);

				$this->base_model->importDataCurrentARProcessData();
			}



			/*--------- FOC Transaction SEARCH --------*/


			$Focpriority_list = $this->base_model->getTransactionPriorityList(4);

			if (!empty($Focpriority_list)) {
				
				$sequence4 = array();
				
				
				foreach ($Focpriority_list as $p) {

					$FOCTransactionTypeListArray = $this->base_model->getTransactionTypeList(4, $p->priority);

					$FOCTransactionTypeList = array_column($FOCTransactionTypeListArray, 'transaction_type_code');

					$current_ar_transaction_list = $this->base_model->current_ar_list_TransactionType($month_year, $FOCTransactionTypeList);
					
					$fetchData_TransactionType_Fourth = array();
					
					if (!empty($current_ar_transaction_list)) {
						
						foreach ($current_ar_transaction_list as $key => $m) {



							$fetchData_TransactionType_Fourth[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);
							$fetchData_TransactionType_Fourth[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType_Fourth[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType_Fourth[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);
							$fetchData_TransactionType_Fourth[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);
							$fetchData_TransactionType_Fourth[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);


							$fetchData_TransactionType_Fourth[$key]['daily_ar_id'] 		= $m->daily_ar_id;
							$fetchData_TransactionType_Fourth[$key]['month_year'] 		= $m->month_year;
							$fetchData_TransactionType_Fourth[$key]['area'] 			= $m->area;
							$fetchData_TransactionType_Fourth[$key]['region'] 			= $m->region;
							$fetchData_TransactionType_Fourth[$key]['dpst'] 			= $m->dpst;
							$fetchData_TransactionType_Fourth[$key]['month'] 			= $m->month;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType_Fourth[$key]['customer_group'] 	= $m->customer_group;
							$fetchData_TransactionType_Fourth[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType_Fourth[$key]['child_code'] 		= $m->child_code;
							$fetchData_TransactionType_Fourth[$key]['customer_name'] 	= $m->customer_name;
							$fetchData_TransactionType_Fourth[$key]['project_name'] 	= $m->project_name;
							$fetchData_TransactionType_Fourth[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType_Fourth[$key]['po_credit_term'] 	= $m->po_credit_term;
							$fetchData_TransactionType_Fourth[$key]['company'] 			= $m->company;
							$fetchData_TransactionType_Fourth[$key]['transaction_type'] = $m->transaction_type;
							$fetchData_TransactionType_Fourth[$key]['invoice_number'] 	= $m->invoice_number;
							$fetchData_TransactionType_Fourth[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType_Fourth[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType_Fourth[$key]['dispatch_date'] 	= $m->dispatch_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType_Fourth[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType_Fourth[$key]['rev_due_date'] 	= $m->rev_due_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_amount'] 	= $m->invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType_Fourth[$key]['balance_amount'] 	= $m->balance_amount;
							$fetchData_TransactionType_Fourth[$key]['currency']			= $m->currency;
							$fetchData_TransactionType_Fourth[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType_Fourth[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_balance_amount'] = $m->fx_balance_amount;
							$fetchData_TransactionType_Fourth[$key]['customer_type'] 	= $m->customer_type;
							$fetchData_TransactionType_Fourth[$key]['ecl_category'] 	= $m->ecl_category;
							$fetchData_TransactionType_Fourth[$key]['consol'] 			= $m->consol;
							$fetchData_TransactionType_Fourth[$key]['org_dpst'] 		= $m->org_dpst;
							$fetchData_TransactionType_Fourth[$key]['org_tt'] 			= $m->org_tt;
							$fetchData_TransactionType_Fourth[$key]['fema_days'] 		= $m->fema_days;
							$fetchData_TransactionType_Fourth[$key]['ecl_days'] 		= $m->ecl_days;
							$fetchData_TransactionType_Fourth[$key]['user_id'] 			= 1;
							
							$user_input_current_4 =  get_current_ar_user_input($m->org_document_number);

							$fetchData_TransactionType_Fourth[$key]['responsibility'] 	= $user_input_current_4->responsibility;

							$fetchData_TransactionType_Fourth[$key]['planned_coll_amt'] 	= $user_input_current_4->planned_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_coll_date'] 	= $user_input_current_4->planned_coll_date;
							$fetchData_TransactionType_Fourth[$key]['retention'] 		= $user_input_current_4->retention;
							$fetchData_TransactionType_Fourth[$key]['warranty_retention'] = $user_input_current_4->warranty_retention;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_current_4->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_date'] = $user_input_current_4->planned_rtn_wrtn_date;
							$fetchData_TransactionType_Fourth[$key]['pbg_lc'] 	= $user_input_current_4->pbg_lc;
							$fetchData_TransactionType_Fourth[$key]['won'] 		= $user_input_current_4->won;
							$fetchData_TransactionType_Fourth[$key]['cnaf']		= $user_input_current_4->cnaf;
							$fetchData_TransactionType_Fourth[$key]['srn'] 		= $user_input_current_4->srn;
							$fetchData_TransactionType_Fourth[$key]['foc'] 		= $user_input_current_4->foc;
							$fetchData_TransactionType_Fourth[$key]['wds'] 		= $user_input_current_4->wds;
							$fetchData_TransactionType_Fourth[$key]['tds'] 		= $user_input_current_4->tds;
							$fetchData_TransactionType_Fourth[$key]['gst_tds'] 		= $user_input_current_4->gst_tds;
							$fetchData_TransactionType_Fourth[$key]['ld'] 		= $user_input_current_4->ld;
							$fetchData_TransactionType_Fourth[$key]['legal'] 	= $user_input_current_4->legal;
							
							/* $fetchData_TransactionType_Fourth[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number, $m->month_year)->document_date;
							$fetchData_TransactionType_Fourth[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number, $m->month_year)->collection; */
							
							$coll_date = get_daily_collection($m->org_document_number, $user_input_current_4->month_year)->document_date;
					
							$coll_daily = get_daily_collection($m->org_document_number, $user_input_current_4->month_year)->collection;
							
							if($coll_date!=''){
							$fetchData_TransactionType_Fourth[$key]['actual_coll_date'] = $coll_date;
							}else{
							$fetchData_TransactionType_Fourth[$key]['actual_coll_date'] = '';	
							}
							
							if($coll_daily!=''){
							$fetchData_TransactionType_Fourth[$key]['actual_coll_amount'] = $coll_daily;
							}else{
							$fetchData_TransactionType_Fourth[$key]['actual_coll_amount'] = '';	
							}

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType_Fourth[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0') {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType_Fourth[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							if($split_month[0] != 12){
							$from_date1 = $split_month[0] + 1;
							}else{
							$from_date1 = 1;	
							}

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1) {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = $fetchData_TransactionType_Fourth[$key]['within_due'] - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['overdue'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType_Fourth[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '30') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >='31' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '60') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '61' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '90') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '91' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '120') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '121' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '150') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '151' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '180') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '181' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '360') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '361' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '720') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '721' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Not Due";
							}


							// Seventh cal FX within Due
					$fx_within_due = $fetchData_TransactionType_Fourth[$key]['within_due'] / $m->fx_rate;
					if($fx_within_due!='' && !is_nan($fx_within_due) && !is_infinite($fx_within_due) ){
					$fetchData_TransactionType_Fourth[$key]['fx_within_due'] 		= $fx_within_due;
					}else{
					$fetchData_TransactionType_Fourth[$key]['fx_within_due'] 		= 0;
					}

					// Eight cal fx_overdue
					
					$fx_overdue = $fetchData_TransactionType_Fourth[$key]['overdue'] / $m->fx_rate;
					if($fx_overdue!='' && !is_nan($fx_overdue) && !is_infinite($fx_overdue) ){
					$fetchData_TransactionType_Fourth[$key]['fx_overdue'] 		= $fx_overdue;
					}else{
					$fetchData_TransactionType_Fourth[$key]['fx_overdue'] 		= 0;
					}

							/* // Night cal fx_ftm_due

							$fetchData_TransactionType_Fourth[$key]['fx_ftm_due'] 		= $fetchData_TransactionType_Fourth[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount; */
							
							// Night cal fx_ftm_due
					
					$fx_ftm_due = round($fetchData_TransactionType_Fourth[$key]['ftm_due'] / $m->fx_rate);
					
					$fx_impact = (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					if($fx_ftm_due!='' && !is_nan($fx_ftm_due) && !is_infinite($fx_ftm_due) ){
					$fetchData_TransactionType_Fourth[$key]['fx_ftm_due'] 		= $fx_ftm_due;
					}else{						
					$fetchData_TransactionType_Fourth[$key]['fx_ftm_due'] 		= '';
					}

					// Tenth cal fx_impact
					
					if($fx_impact!='' && !is_nan($fx_impact) && !is_infinite($fx_impact) ){
					$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= $fx_impact;
					}else{						
					$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= '';
					}

							// Eleven cal collection_days

							$fetchData_TransactionType_Fourth[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType_Fourth[$key]['planned_coll_date'], $fetchData_TransactionType_Fourth[$key]['actual_coll_date']);


							// Update the Process Data
							$this->db->where('daily_ar_id', $m->daily_ar_id);
							$this->db->set('process_data', 1);
							$this->db->set('sequence', 4);
							$this->db->update('daily_ar');
						}
					}
					
					$sequence4[] = $fetchData_TransactionType_Fourth;
					
				}
			}
			
			$sequence4_final_result = [];

	foreach ($sequence4 as $value) {
    $sequence4_final_result = array_merge($sequence4_final_result, $value);
	}	


			if (!empty($sequence4_final_result)) {

				$this->base_model->setBatchImportCurrentARProcessData($sequence4_final_result);

				$this->base_model->importDataCurrentARProcessData();
			}




			/*--------- DPST Fifth stage SEARCH --------*/

			$logical_ar_type = implode(',',$this->base_model->month_end_ar_list_vetical_DPST_ar_type_all());

			$ar_type = $this->base_model->month_end_ar_list_DPST_ar_type($logical_ar_type);

			$ar_typess = array_column($ar_type, 'dpst_code');

			$current_ar_data_last = $this->base_model->current_ar_list_DPST($month_year, $ar_typess);

			if (!empty($current_ar_data_last)) {
				$fetchDatalast = array();
				foreach ($current_ar_data_last as $key => $m) {


					$fetchDatalast[$key]['ar_type'] 			= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchDatalast[$key]['vertical'] 			= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchDatalast[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchDatalast[$key]['sbu']					= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchDatalast[$key]['console_entity'] 		= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchDatalast[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

					$fetchDatalast[$key]['daily_ar_id'] 		= $m->daily_ar_id;
					$fetchDatalast[$key]['month_year'] 			= $m->month_year;
					$fetchDatalast[$key]['area'] 				= $m->area;
					$fetchDatalast[$key]['region'] 				= $m->region;
					$fetchDatalast[$key]['dpst'] 				= $m->dpst;
					$fetchDatalast[$key]['month'] 				= $m->month;
					$fetchDatalast[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchDatalast[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchDatalast[$key]['customer_group'] 		= $m->customer_group;
					$fetchDatalast[$key]['parent_code'] 		= $m->parent_code;
					$fetchDatalast[$key]['child_code'] 			= $m->child_code;
					$fetchDatalast[$key]['customer_name'] 		= $m->customer_name;
					$fetchDatalast[$key]['project_name'] 		= $m->project_name;
					$fetchDatalast[$key]['po_name'] 			= $m->po_name;
					$fetchDatalast[$key]['po_credit_term'] 		= $m->po_credit_term;
					$fetchDatalast[$key]['company'] 			= $m->company;
					$fetchDatalast[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchDatalast[$key]['invoice_number'] 		= $m->invoice_number;
					$fetchDatalast[$key]['org_document_number'] = $m->org_document_number;
					$fetchDatalast[$key]['document_number'] 	= $m->document_number;
					$fetchDatalast[$key]['dispatch_date'] 		= $m->dispatch_date;
					$fetchDatalast[$key]['invoice_date']		= $m->invoice_date;
					$fetchDatalast[$key]['credit_days'] 		= $m->credit_days;
					$fetchDatalast[$key]['due_date']			= $m->due_date;
					$fetchDatalast[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchDatalast[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchDatalast[$key]['invoice_amount'] 		= $m->invoice_amount;
					$fetchDatalast[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchDatalast[$key]['balance_amount'] 		= $m->balance_amount;
					$fetchDatalast[$key]['currency']			= $m->currency;
					$fetchDatalast[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchDatalast[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
					$fetchDatalast[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
					$fetchDatalast[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
					$fetchDatalast[$key]['customer_type'] 		= $m->customer_type;
					$fetchDatalast[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchDatalast[$key]['consol'] 				= $m->consol;
					$fetchDatalast[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchDatalast[$key]['org_tt'] 				= $m->org_tt;
					$fetchDatalast[$key]['fema_days'] 			= $m->fema_days;
					$fetchDatalast[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchDatalast[$key]['user_id'] 			= 1;
					
					$user_input_current_5 =  get_current_ar_user_input($m->org_document_number);
					
					$fetchDatalast[$key]['responsibility'] 	= $user_input_current_5->responsibility;

					$fetchDatalast[$key]['planned_coll_amt'] 	= $user_input_current_5->planned_coll_amt;
					$fetchDatalast[$key]['planned_coll_date'] 	= $user_input_current_5->planned_coll_date;
					$fetchDatalast[$key]['retention'] 		= $user_input_current_5->retention;
					$fetchDatalast[$key]['warranty_retention'] = $user_input_current_5->warranty_retention;
					$fetchDatalast[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_current_5->planned_rtn_wrtn_coll_amt;
					$fetchDatalast[$key]['planned_rtn_wrtn_date'] = $user_input_current_5->planned_rtn_wrtn_date;
					$fetchDatalast[$key]['pbg_lc'] 		= $user_input_current_5->pbg_lc;
					$fetchDatalast[$key]['won'] 		= $user_input_current_5->won;
					$fetchDatalast[$key]['cnaf']		= $user_input_current_5->cnaf;
					$fetchDatalast[$key]['srn'] 		= $user_input_current_5->srn;
					$fetchDatalast[$key]['foc'] 		= $user_input_current_5->foc;
					$fetchDatalast[$key]['wds'] 		= $user_input_current_5->wds;
					$fetchDatalast[$key]['tds'] 		= $user_input_current_5->tds;
					$fetchDatalast[$key]['gst_tds'] 	= $user_input_current_5->gst_tds;
					$fetchDatalast[$key]['ld'] 			= $user_input_current_5->ld;
					$fetchDatalast[$key]['legal'] 		= $user_input_current_5->legal;

					/* $fetchDatalast[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number, $m->month_year)->document_date;
					$fetchDatalast[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number, $m->month_year)->collection; */
					
					
					$coll_date = get_daily_collection($m->org_document_number, $user_input_current_5->month_year)->document_date;
					
					$coll_daily = get_daily_collection($m->org_document_number, $user_input_current_5->month_year)->collection;
							
							if($coll_date!=''){
							$fetchDatalast[$key]['actual_coll_date'] = $coll_date;
							}else{
							$fetchDatalast[$key]['actual_coll_date'] = '';	
							}
							
							if($coll_daily!=''){
							$fetchDatalast[$key]['actual_coll_amount'] = $coll_daily;
							}else{
							$fetchDatalast[$key]['actual_coll_amount'] = '';	
							}

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchDatalast[$key]['modified_doc']			= 1;
					} else {
						$fetchDatalast[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchDatalast[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchDatalast[$key]['od_days'] >= '0') {
						$fetchDatalast[$key]['overdue'] = $m->balance_amount - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchDatalast[$key]['within_due'] = $m->balance_amount - $fetchDatalast[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[0] != 12){
					$from_date1 = $split_month[0] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1) {
						$fetchDatalast[$key]['ftm_due'] = $fetchDatalast[$key]['within_due'] - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['overdue'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchDatalast[$key]['ftm_due'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchDatalast[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['od_days'] <= '30') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchDatalast[$key]['od_days'] >='31' && $fetchDatalast[$key]['od_days'] <= '60') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '61' && $fetchDatalast[$key]['od_days'] <= '90') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '91' && $fetchDatalast[$key]['od_days'] <= '120') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '121' && $fetchDatalast[$key]['od_days'] <= '150') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '151' && $fetchDatalast[$key]['od_days'] <= '180') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '181' && $fetchDatalast[$key]['od_days'] <= '360') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '361' && $fetchDatalast[$key]['od_days'] <= '720') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '721' && $fetchDatalast[$key]['od_days'] <= '1080') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '1081') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Not Due";
					}


					// Seventh cal FX within Due
					$fx_within_due = $fetchDatalast[$key]['within_due'] / $m->fx_rate;
					if($fx_within_due!='' && !is_nan($fx_within_due) && !is_infinite($fx_within_due) ){
					$fetchDatalast[$key]['fx_within_due'] 		= $fx_within_due;
					}else{
					$fetchDatalast[$key]['fx_within_due'] 		= 0;
					}

					// Eight cal fx_overdue
					
					$fx_overdue = $fetchDatalast[$key]['overdue'] / $m->fx_rate;
					if($fx_overdue!='' && !is_nan($fx_overdue) && !is_infinite($fx_overdue) ){
					$fetchDatalast[$key]['fx_overdue'] 		= $fx_overdue;
					}else{
					$fetchDatalast[$key]['fx_overdue'] 		= 0;
					}

					// Night cal fx_ftm_due
					
					$fx_ftm_due = round($fetchDatalast[$key]['ftm_due'] / $m->fx_rate);
					
					$fx_impact = (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					if($fx_ftm_due!='' && !is_nan($fx_ftm_due) && !is_infinite($fx_ftm_due)){
					$fetchDatalast[$key]['fx_ftm_due'] 		= $fx_ftm_due;
					}else{						
					$fetchDatalast[$key]['fx_ftm_due'] 		= 0;
					}

					// Tenth cal fx_impact
					
					if($fx_impact!='' && !is_nan($fx_impact) && !is_infinite($fx_impact)){
					$fetchDatalast[$key]['fx_impact'] 		= $fx_impact;
					}else{						
					$fetchDatalast[$key]['fx_impact'] 		= 0;
					}

					// Eleven cal collection_days

					$fetchDatalast[$key]['collection_days'] 		= $this->get_number_of_days($fetchDatalast[$key]['planned_coll_date'], $fetchDatalast[$key]['actual_coll_date']);

					// if(empty($fetchDatalast[$key]['ar_type'])){
					// 	echo "<pre>";
					//  print_r($fetchDatalast);die;
					// }

					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 5);
					$this->db->update('daily_ar');
				}
			}
 
			
			if (!empty($fetchDatalast)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchDatalast);

				$this->base_model->importDataCurrentARProcessData();
			}

		// }
		
			$this->db->set("cron_status", 1);
			$this->db->where("cron_type", "current_ar");
			// $this->db->where("month", $current_array->month);
			$this->db->update('cron_table');
			 
			 
		 }
		 
		 //--------------- Month End AR Report -----------------//
		 
		 if(count($month_end_array) > 0){
			 
			 $month_year = $month_end_array[0]->month;
			 
			$ar_typess = array_column($ar_type, 'dpst_code');
			 

		if ($month_year != '') {
			
			$this->db->set("process_data", 1);
			$this->db->where("month", $month_year);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');


			/*--------- DPST SEARCH --------*/
			
			$ar_type = $this->base_model->month_end_ar_list_DPST_No();
			
			// $ar_type = array('90993', '90994');

			$month_end_ar_data = $this->base_model->month_end_ar_list_DPST($month_year, $ar_type);
			
			//	print_r($this->db->last_query());die;
			 
			$table_rep = "month_end_ar_process_data";


			if (!empty($month_end_ar_data)) {
				
				$fetchData = array();
				foreach ($month_end_ar_data as $key => $m) {

					$fetchData[$key]['ar_type'] 		= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchData[$key]['vertical']		= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchData[$key]['cluster'] 		= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchData[$key]['sbu'] 			= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchData[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchData[$key]['country'] 		= get_country_name(get_area_country($m->area)->country_id);	
					
					// $fetchData[$key]['commissioning']	= $m->commissioning;

					$fetchData[$key]['month_end_ar_id']	= $m->month_end_ar_id;
					$fetchData[$key]['month_year'] 		= $m->month_year;
					$fetchData[$key]['area'] 			= $m->area;
					$fetchData[$key]['region'] 			= $m->region;
					$fetchData[$key]['dpst'] 			= $m->dpst;
					$fetchData[$key]['month'] 			= $m->month;
					$fetchData[$key]['sales_engg_code'] = $m->sales_engg_code;
					$fetchData[$key]['sales_engg_name'] = $m->sales_engg_name;
					$fetchData[$key]['customer_group'] 	= $m->customer_group;
					$fetchData[$key]['parent_code'] 	= $m->parent_code;
					$fetchData[$key]['child_code'] 		= $m->child_code;
					$fetchData[$key]['customer_name'] 	= $m->customer_name;
					$fetchData[$key]['project_name'] 	= $m->project_name;
					$fetchData[$key]['po_name'] 		= $m->po_name;
					$fetchData[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData[$key]['company'] 		= $m->company;
					$fetchData[$key]['transaction_type'] = $m->transaction_type;
					$fetchData[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData[$key]['org_document_number'] = $m->org_document_number;
					$fetchData[$key]['document_number'] = $m->document_number;
					$fetchData[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData[$key]['invoice_date']	= $m->invoice_date;
					$fetchData[$key]['credit_days'] 	= $m->credit_days;
					$fetchData[$key]['due_date']		= $m->due_date;
					$fetchData[$key]['credit_days_adj'] = $m->credit_days_adj;
					$fetchData[$key]['rev_due_date'] 	= $m->rev_due_date;
					$fetchData[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData[$key]['paid_amount'] 	= $m->paid_amount;
					$fetchData[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData[$key]['currency']		= $m->currency;
					$fetchData[$key]['fx_rate'] 		= $m->fx_rate;
					$fetchData[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData[$key]['customer_type'] 	= $m->customer_type;
					$fetchData[$key]['ecl_category'] 	= $m->ecl_category;
					$fetchData[$key]['consol'] 			= $m->consol;
					$fetchData[$key]['org_dpst'] 		= $m->org_dpst;
					$fetchData[$key]['org_tt'] 			= $m->org_tt;
					$fetchData[$key]['fema_days'] 		= $m->fema_days;
					$fetchData[$key]['ecl_days'] 		= $m->ecl_days;
					$fetchData[$key]['user_id'] 		= 1;
					

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData[$key]['modified_doc']			= 1;
					} else {
						$fetchData[$key]['modified_doc']			= 0;
					}
					

					// Third Cal
					
					$fetchData[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);

					// Six cal OD Ageing category

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['od_days'] <= '30') {
						$fetchData[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData[$key]['od_days'] >='31' && $fetchData[$key]['od_days'] <= '60') {
						$fetchData[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData[$key]['od_days'] >= '61' && $fetchData[$key]['od_days'] <= '90') {
						$fetchData[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData[$key]['od_days'] >= '91' && $fetchData[$key]['od_days'] <= '120') {
						$fetchData[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData[$key]['od_days'] >= '121' && $fetchData[$key]['od_days'] <= '150') {
						$fetchData[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData[$key]['od_days'] >= '151' && $fetchData[$key]['od_days'] <= '180') {
						$fetchData[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData[$key]['od_days'] >= '181' && $fetchData[$key]['od_days'] <= '360') {
						$fetchData[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData[$key]['od_days'] >= '361' && $fetchData[$key]['od_days'] <= '720') {
						$fetchData[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData[$key]['od_days'] >= '721' && $fetchData[$key]['od_days'] <= '1080') {
						$fetchData[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData[$key]['od_days'] >= '1081') {
						$fetchData[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData[$key]['od_ageing_category'] 		= "Not Due";
					}
					
					
					
					
					// Tenth cal fx_impact

					$fetchData[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					$fetchData[$key]['current_mth_fx_rate'] 		= get_month_end_fx_rates($m->currency, $m->month_year);
					
					if ($fetchData[$key]['od_days'] >= '0') {
						$fetchData[$key]['overdue'] = $m->balance_amount;
					} else {
						$fetchData[$key]['overdue'] = '0';
					}
					
						
					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 1);
					$this->db->update('month_end_ar_list'); 
					
				}
			}
			
			 
			
			$this->db->query("DELETE FROM month_end_ar_process_data_final WHERE month_year='" . $month_year . "'");
			
			$this->db->query("DELETE FROM month_end_ar_process_data WHERE month_year='" . $month_year . "'");
			
			

			if (!empty($fetchData)) {

				$this->base_model->setBatchImportProcessData($fetchData);

				$this->base_model->importDataProcessData();
				
				
				//----- Process Data ---------
				
				$this->base_model->setBatchImportProcessDataFinal($fetchData);

				$this->base_model->importDataProcessDataFinal();
			}

					 

			/*--------- Tarial Units Transaction SEARCH --------*/


			$priority_list = $this->base_model->getTransactionPriorityList(2);
			
			

			if (!empty($priority_list)) {
				
				$sequence2 = array();
				
				
				
				foreach ($priority_list as $p) {

					$TransactionTypeListArray = $this->base_model->getTransactionTypeList(2, $p->priority);
					
					$TransactionTypeList = array_column($TransactionTypeListArray, 'transaction_type_code');
					
					$month_end_ar_transaction = $this->base_model->month_end_ar_list_TransactionType($month_year, $TransactionTypeList);
					
					$fetchData_TransactionType = array();
					
					if (!empty($month_end_ar_transaction)) {
						
						foreach ($month_end_ar_transaction as $key => $m) {


							$fetchData_TransactionType[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);

							$fetchData_TransactionType[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType[$key]['console_entity'] 		= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);

							$fetchData_TransactionType[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

							// $fetchData_TransactionType[$key]['commissioning']		= $m->commissioning;

							$fetchData_TransactionType[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
							$fetchData_TransactionType[$key]['month_year'] 			= $m->month_year;
							$fetchData_TransactionType[$key]['area'] 				= $m->area;
							$fetchData_TransactionType[$key]['region'] 				= $m->region;
							$fetchData_TransactionType[$key]['dpst'] 				= $m->dpst;
							$fetchData_TransactionType[$key]['month'] 				= $m->month;
							$fetchData_TransactionType[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType[$key]['customer_group'] 		= $m->customer_group;
							$fetchData_TransactionType[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType[$key]['child_code'] 			= $m->child_code;
							$fetchData_TransactionType[$key]['customer_name'] 		= $m->customer_name;
							$fetchData_TransactionType[$key]['project_name'] 		= $m->project_name;
							$fetchData_TransactionType[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType[$key]['po_credit_term'] 		= $m->po_credit_term;
							$fetchData_TransactionType[$key]['company'] 			= $m->company;
							$fetchData_TransactionType[$key]['transaction_type'] 	= $m->transaction_type;
							$fetchData_TransactionType[$key]['invoice_number'] 		= $m->invoice_number;
							$fetchData_TransactionType[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType[$key]['dispatch_date'] 		= $m->dispatch_date;
							$fetchData_TransactionType[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType[$key]['rev_due_date'] 		= $m->rev_due_date;
							$fetchData_TransactionType[$key]['invoice_amount'] 		= $m->invoice_amount;
							$fetchData_TransactionType[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType[$key]['balance_amount'] 		= $m->balance_amount;
							$fetchData_TransactionType[$key]['currency']			= $m->currency;
							$fetchData_TransactionType[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
							$fetchData_TransactionType[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
							$fetchData_TransactionType[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
							$fetchData_TransactionType[$key]['customer_type'] 		= $m->customer_type;
							$fetchData_TransactionType[$key]['ecl_category'] 		= $m->ecl_category;
							$fetchData_TransactionType[$key]['ecl_days'] 			= $m->ecl_days;
							$fetchData_TransactionType[$key]['consol'] 				= $m->consol;
							$fetchData_TransactionType[$key]['org_dpst'] 			= $m->org_dpst;
							$fetchData_TransactionType[$key]['org_tt'] 				= $m->org_tt;
							$fetchData_TransactionType[$key]['fema_days'] 			= $m->fema_days;
							$fetchData_TransactionType[$key]['user_id'] 			= 1;
 
							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);

							// Six cal OD Ageing category

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['od_days'] <= '30') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >='31' && $fetchData_TransactionType[$key]['od_days'] <= '60') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '61' && $fetchData_TransactionType[$key]['od_days'] <= '90') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '91' && $fetchData_TransactionType[$key]['od_days'] <= '120') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '121' && $fetchData_TransactionType[$key]['od_days'] <= '150') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '151' && $fetchData_TransactionType[$key]['od_days'] <= '180') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '181' && $fetchData_TransactionType[$key]['od_days'] <= '360') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '361' && $fetchData_TransactionType[$key]['od_days'] <= '720') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '721' && $fetchData_TransactionType[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Not Due";
							}

							// Tenth cal fx_impact
							$fetchData_TransactionType[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
							
							$fetchData_TransactionType[$key]['current_mth_fx_rate'] 		= get_month_end_fx_rates($m->currency, $m->month_year);
							
							if ($fetchData_TransactionType[$key]['od_days'] >= '0') {
								$fetchData_TransactionType[$key]['overdue'] = $m->balance_amount;
							} else {
								$fetchData_TransactionType[$key]['overdue'] = '0';
							}

							// Update the Process Data
							$this->db->where('month_end_ar_id', $m->month_end_ar_id);
							$this->db->set('process_data', 1);
							$this->db->set('sequence', 2);
							$this->db->update('month_end_ar_list');
						}
					}
					
					$sequence2[] = $fetchData_TransactionType;
					
				}
			}
			
			$sequence2_final_result = [];

	foreach ($sequence2 as $value) {
    $sequence2_final_result = array_merge($sequence2_final_result, $value);
	}
	
			if (!empty($sequence2_final_result)) {

				$this->base_model->setBatchImportProcessData($sequence2_final_result);

				$this->base_model->importDataProcessData();
				
				//----- Process Data ---------
				
				$this->base_model->setBatchImportProcessDataFinal($sequence2_final_result);

				$this->base_model->importDataProcessDataFinal();
			}

			// print_r("Avinash");die;


			/*--------- Value SEARCH --------*/

			$month_end_ar_by_value = $this->base_model->month_end_ar_list_value($month_year);

			// print_r($this->db->last_query());die;

			if (!empty($month_end_ar_by_value)) {
				$fetchData_value = array();
				foreach ($month_end_ar_by_value as $key => $m) {


					if ($m->balance_amount <= 100 && $m->balance_amount >= 0) {
						
						if(strtoupper($m->consol) == 'ATS'){
							
							$vertical_id = 59;
							
						}elseif(strtoupper($m->consol) == 'ELGI'){
							
							$vertical_id = 18;
							
						}elseif(strtoupper($m->consol) == 'GULF'){
							
							$vertical_id = 76;
							
						}

						$fetchData_value[$key]['vertical'] 			= get_vertical_name($vertical_id);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping($vertical_id)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping($vertical_id)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping($vertical_id)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						
						if(get_vertical_entity_mapping($vertical_id)->console_id == 1){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(13);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 2){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(25);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 4){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(37);
						}
						
					} else if ($m->balance_amount < 0) {
						
						if(strtoupper($m->consol) == 'ATS'){
							
							$vertical_id = 60;
							
						}elseif(strtoupper($m->consol) == 'ELGI'){
							
							$vertical_id = 19;
							
						}elseif(strtoupper($m->consol) == 'GULF'){
							
							$vertical_id = 75;
							
						}

						$fetchData_value[$key]['vertical'] 			= get_vertical_name($vertical_id);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping($vertical_id)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping($vertical_id)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping($vertical_id)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						
						if(get_vertical_entity_mapping($vertical_id)->console_id == 1){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(14);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 2){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(26);
						}elseif(get_vertical_entity_mapping($vertical_id)->console_id == 4){
						$fetchData_value[$key]['ar_type'] 			= get_artype_name(36);
						}
						
					}


					// $fetchData_value[$key]['commissioning']		= $m->commissioning;

					$fetchData_value[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
					$fetchData_value[$key]['month_year'] 		= $m->month_year;
					$fetchData_value[$key]['area'] 				= $m->area;
					$fetchData_value[$key]['region'] 			= $m->region;
					$fetchData_value[$key]['dpst'] 				= $m->dpst;
					$fetchData_value[$key]['month'] 			= $m->month;
					$fetchData_value[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchData_value[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchData_value[$key]['customer_group'] 	= $m->customer_group;
					$fetchData_value[$key]['parent_code'] 		= $m->parent_code;
					$fetchData_value[$key]['child_code'] 		= $m->child_code;
					$fetchData_value[$key]['customer_name'] 	= $m->customer_name;
					$fetchData_value[$key]['project_name'] 		= $m->project_name;
					$fetchData_value[$key]['po_name'] 			= $m->po_name;
					$fetchData_value[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData_value[$key]['company'] 			= $m->company;
					$fetchData_value[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchData_value[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData_value[$key]['org_document_number'] = $m->org_document_number;
					$fetchData_value[$key]['document_number'] 	= $m->document_number;
					$fetchData_value[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData_value[$key]['invoice_date']		= $m->invoice_date;
					$fetchData_value[$key]['credit_days'] 		= $m->credit_days;
					$fetchData_value[$key]['due_date']			= $m->due_date;
					$fetchData_value[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchData_value[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchData_value[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData_value[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchData_value[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData_value[$key]['currency']			= $m->currency;
					$fetchData_value[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchData_value[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData_value[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData_value[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData_value[$key]['customer_type'] 	= $m->customer_type;
					$fetchData_value[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchData_value[$key]['consol'] 			= $m->consol;
					$fetchData_value[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchData_value[$key]['org_tt'] 			= $m->org_tt;
					$fetchData_value[$key]['fema_days'] 		= $m->fema_days;
					$fetchData_value[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchData_value[$key]['user_id'] 			= 1;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData_value[$key]['modified_doc']			= 1;
					} else {
						$fetchData_value[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData_value[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Six cal OD Ageing category

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['od_days'] <= '30') {
						$fetchData_value[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData_value[$key]['od_days'] >='31' && $fetchData_value[$key]['od_days'] <= '60') {
						$fetchData_value[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '61' && $fetchData_value[$key]['od_days'] <= '90') {
						$fetchData_value[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '91' && $fetchData_value[$key]['od_days'] <= '120') {
						$fetchData_value[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '121' && $fetchData_value[$key]['od_days'] <= '150') {
						$fetchData_value[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '151' && $fetchData_value[$key]['od_days'] <= '180') {
						$fetchData_value[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '181' && $fetchData_value[$key]['od_days'] <= '360') {
						$fetchData_value[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '361' && $fetchData_value[$key]['od_days'] <= '720') {
						$fetchData_value[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '721' && $fetchData_value[$key]['od_days'] <= '1080') {
						$fetchData_value[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '1081') {
						$fetchData_value[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData_value[$key]['od_ageing_category'] 		= "Not Due";
					}
					
					
					// Tenth cal fx_impact
					$fetchData_value[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					$fetchData_value[$key]['current_mth_fx_rate'] 		= get_month_end_fx_rates($m->currency, $m->month_year);
					
					if ($fetchData_value[$key]['od_days'] >= '0') {
								$fetchData_value[$key]['overdue'] = $m->balance_amount;
							} else {
								$fetchData_value[$key]['overdue'] = '0';
							}

					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 3);
					$this->db->update('month_end_ar_list');
				}
			}


			if (!empty($fetchData_value)) {

				$this->base_model->setBatchImportProcessData($fetchData_value);

				$this->base_model->importDataProcessData();
				
				
				//----- Process Data ---------
				
				$this->base_model->setBatchImportProcessDataFinal($fetchData_value);

				$this->base_model->importDataProcessDataFinal();
			}



			/*--------- FOC Transaction SEARCH --------*/
			
			
			
			$Focpriority_list = $this->base_model->getTransactionPriorityList(4);
			
			if (!empty($Focpriority_list)) {
				
				$sequence4 = array();
				
				foreach ($Focpriority_list as $p) {

					$FOCTransactionTypeListArray = $this->base_model->getTransactionTypeList(4, $p->priority);

					$FOCTransactionTypeList = array_column($FOCTransactionTypeListArray, 'transaction_type_code');

					$month_end_ar_transaction_list = $this->base_model->month_end_ar_list_TransactionType($month_year, $FOCTransactionTypeList);
					 
					 $fetchData_TransactionType_Fourth = array();	

					if (!empty($month_end_ar_transaction_list)) {
						
						foreach ($month_end_ar_transaction_list as $key => $m) {
						
							 


							$fetchData_TransactionType_Fourth[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);
							$fetchData_TransactionType_Fourth[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType_Fourth[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType_Fourth[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);

							$fetchData_TransactionType_Fourth[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType_Fourth[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

							// $fetchData_TransactionType_Fourth[$key]['commissioning']	= $m->commissioning;


							$fetchData_TransactionType_Fourth[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
							$fetchData_TransactionType_Fourth[$key]['month_year'] 		= $m->month_year;
							$fetchData_TransactionType_Fourth[$key]['area'] 			= $m->area;
							$fetchData_TransactionType_Fourth[$key]['region'] 			= $m->region;
							$fetchData_TransactionType_Fourth[$key]['dpst'] 			= $m->dpst;
							$fetchData_TransactionType_Fourth[$key]['month'] 			= $m->month;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType_Fourth[$key]['customer_group'] 	= $m->customer_group;
							$fetchData_TransactionType_Fourth[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType_Fourth[$key]['child_code'] 		= $m->child_code;
							$fetchData_TransactionType_Fourth[$key]['customer_name'] 	= $m->customer_name;
							$fetchData_TransactionType_Fourth[$key]['project_name'] 	= $m->project_name;
							$fetchData_TransactionType_Fourth[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType_Fourth[$key]['po_credit_term'] 	= $m->po_credit_term;
							$fetchData_TransactionType_Fourth[$key]['company'] 			= $m->company;
							$fetchData_TransactionType_Fourth[$key]['transaction_type'] = $m->transaction_type;
							$fetchData_TransactionType_Fourth[$key]['invoice_number'] 	= $m->invoice_number;
							$fetchData_TransactionType_Fourth[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType_Fourth[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType_Fourth[$key]['dispatch_date'] 	= $m->dispatch_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType_Fourth[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType_Fourth[$key]['rev_due_date'] 	= $m->rev_due_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_amount'] 	= $m->invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType_Fourth[$key]['balance_amount'] 	= $m->balance_amount;
							$fetchData_TransactionType_Fourth[$key]['currency']			= $m->currency;
							$fetchData_TransactionType_Fourth[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType_Fourth[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_balance_amount'] = $m->fx_balance_amount;
							$fetchData_TransactionType_Fourth[$key]['customer_type'] 	= $m->customer_type;
							$fetchData_TransactionType_Fourth[$key]['ecl_category'] 	= $m->ecl_category;
							$fetchData_TransactionType_Fourth[$key]['consol'] 			= $m->consol;
							$fetchData_TransactionType_Fourth[$key]['org_dpst'] 		= $m->org_dpst;
							$fetchData_TransactionType_Fourth[$key]['org_tt'] 			= $m->org_tt;
							$fetchData_TransactionType_Fourth[$key]['fema_days'] 		= $m->fema_days;
							$fetchData_TransactionType_Fourth[$key]['ecl_days'] 		= $m->ecl_days;
							$fetchData_TransactionType_Fourth[$key]['user_id'] 			= 1;

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType_Fourth[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);

							// Six cal OD Ageing category

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '30') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >='31' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '60') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '61' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '90') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '91' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '120') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '121' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '150') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '151' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '180') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '181' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '360') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '361' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '720') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '721' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Not Due";
							}

							// Tenth cal fx_impact
							$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
							
							$fetchData_TransactionType_Fourth[$key]['current_mth_fx_rate'] 		= get_month_end_fx_rates($m->currency, $m->month_year);
							
							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0') {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = $m->balance_amount;
							} else {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = '0';
							}

							// Update the Process Data
							$this->db->where('month_end_ar_id', $m->month_end_ar_id);
							$this->db->set('process_data', 1);
							$this->db->set('sequence', 4);
							$this->db->update('month_end_ar_list');	
						
						} 
						
					} 
					
					$sequence4[] = $fetchData_TransactionType_Fourth;
					
				}
				
			} 
			
			
	$sequence4_final_result = [];

	foreach ($sequence4 as $value) {
    $sequence4_final_result = array_merge($sequence4_final_result, $value);
	}	
					

			if (!empty($sequence4_final_result)) {

				$this->base_model->setBatchImportProcessData($sequence4_final_result);

				$this->base_model->importDataProcessData();
				
				
				//----- Process Data ---------
				
				$this->base_model->setBatchImportProcessDataFinal($sequence4_final_result);

				$this->base_model->importDataProcessDataFinal();
				
			}



			/*--------- DPST Fifth stage SEARCH --------*/

			 $logical_ar_type = implode(',',$this->base_model->month_end_ar_list_vetical_DPST_ar_type_all());

			$ar_type = $this->base_model->month_end_ar_list_DPST_ar_type($logical_ar_type);

			$ar_typess = array_column($ar_type, 'dpst_code');

			$month_end_ar_data_last = $this->base_model->month_end_ar_list_DPST($month_year, $ar_typess);

			if (!empty($month_end_ar_data_last)) {
				$fetchDatalast = array();
				foreach ($month_end_ar_data_last as $key => $m) {


					$fetchDatalast[$key]['ar_type'] 			= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchDatalast[$key]['vertical'] 			= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchDatalast[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchDatalast[$key]['sbu']					= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchDatalast[$key]['console_entity'] 		= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchDatalast[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

					// $fetchDatalast[$key]['commissioning']		= $m->commissioning;

					$fetchDatalast[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
					$fetchDatalast[$key]['month_year'] 			= $m->month_year;
					$fetchDatalast[$key]['area'] 				= $m->area;
					$fetchDatalast[$key]['region'] 				= $m->region;
					$fetchDatalast[$key]['dpst'] 				= $m->dpst;
					$fetchDatalast[$key]['month'] 				= $m->month;
					$fetchDatalast[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchDatalast[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchDatalast[$key]['customer_group'] 		= $m->customer_group;
					$fetchDatalast[$key]['parent_code'] 		= $m->parent_code;
					$fetchDatalast[$key]['child_code'] 			= $m->child_code;
					$fetchDatalast[$key]['customer_name'] 		= $m->customer_name;
					$fetchDatalast[$key]['project_name'] 		= $m->project_name;
					$fetchDatalast[$key]['po_name'] 			= $m->po_name;
					$fetchDatalast[$key]['po_credit_term'] 		= $m->po_credit_term;
					$fetchDatalast[$key]['company'] 			= $m->company;
					$fetchDatalast[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchDatalast[$key]['invoice_number'] 		= $m->invoice_number;
					$fetchDatalast[$key]['org_document_number'] = $m->org_document_number;
					$fetchDatalast[$key]['document_number'] 	= $m->document_number;
					$fetchDatalast[$key]['dispatch_date'] 		= $m->dispatch_date;
					$fetchDatalast[$key]['invoice_date']		= $m->invoice_date;
					$fetchDatalast[$key]['credit_days'] 		= $m->credit_days;
					$fetchDatalast[$key]['due_date']			= $m->due_date;
					$fetchDatalast[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchDatalast[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchDatalast[$key]['invoice_amount'] 		= $m->invoice_amount;
					$fetchDatalast[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchDatalast[$key]['balance_amount'] 		= $m->balance_amount;
					$fetchDatalast[$key]['currency']			= $m->currency;
					$fetchDatalast[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchDatalast[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
					$fetchDatalast[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
					$fetchDatalast[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
					$fetchDatalast[$key]['customer_type'] 		= $m->customer_type;
					$fetchDatalast[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchDatalast[$key]['consol'] 				= $m->consol;
					$fetchDatalast[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchDatalast[$key]['org_tt'] 				= $m->org_tt;
					$fetchDatalast[$key]['fema_days'] 			= $m->fema_days;
					$fetchDatalast[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchDatalast[$key]['user_id'] 			= 1;
					
					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchDatalast[$key]['modified_doc']			= 1;
					} else {
						$fetchDatalast[$key]['modified_doc']			= 0;
					}


					// Third Cal

					$fetchDatalast[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);

					// Six cal OD Ageing category

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['od_days'] <= '30') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchDatalast[$key]['od_days'] >='31' && $fetchDatalast[$key]['od_days'] <= '60') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '61' && $fetchDatalast[$key]['od_days'] <= '90') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '91' && $fetchDatalast[$key]['od_days'] <= '120') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '121' && $fetchDatalast[$key]['od_days'] <= '150') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '151' && $fetchDatalast[$key]['od_days'] <= '180') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '181' && $fetchDatalast[$key]['od_days'] <= '360') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '361' && $fetchDatalast[$key]['od_days'] <= '720') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '721' && $fetchDatalast[$key]['od_days'] <= '1080') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '1081') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Not Due";
					}

					// Tenth cal fx_impact
					$fetchDatalast[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;
					
					$fetchDatalast[$key]['current_mth_fx_rate'] 		= get_month_end_fx_rates($m->currency, $m->month_year);
					
					if ($fetchDatalast[$key]['od_days'] >= '0') {
								$fetchDatalast[$key]['overdue'] = $m->balance_amount;
							} else {
								$fetchDatalast[$key]['overdue'] = '0';
							}

					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->set('sequence', 5);
					$this->db->update('month_end_ar_list');
				}
			}



			if (!empty($fetchDatalast)) {

				$this->base_model->setBatchImportProcessData($fetchDatalast);

				$this->base_model->importDataProcessData();
				
				//----- Process Data ---------
				
				$this->base_model->setBatchImportProcessDataFinal($fetchDatalast);

				$this->base_model->importDataProcessDataFinal();
			}

		}
			
			$this->db->set("cron_status", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array[0]->month);
			$this->db->update('cron_table');
			
			//--------------- Excel Export ---------------------------//

			/* $list = $this->base_model->getMonthEndReportListForExcel($month_end_array[0]->month);
			
			$this->load->library('Excel');
			ob_start();
			
			$objPHPExcel = new PHPExcel();
			$styleArray = array(
				'font' => array(
					'size' => 13,
					'name' => 'Roboto'
				)
			);
			$fontArray = array(
				'font' => array(
					'bold' => true,
					'size' => 11,
					'name' => 'Roboto'
				)
			);
			$dateArray = array(
				'font' => array(
					'bold' => true,
				)
			);
			$bgcolor = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'E7E7E7'),
				)
			);

			$bgcolorblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '66bfff'),
				)
			);

			$bgblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'ff0000'),
				)
			);

			$bgbrr = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '82b7da'),
				)
			);
			
			$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
				->setLastModifiedBy("Comprehensive School Management")
				->setTitle("Office  XLSX Test Document")
				->setSubject("Office XLSX Test Document")
				->setDescription("Test document for Office XLSX, generated by PHP classes.")
				->setKeywords("office openxml php")
				->setCategory("Excel Sheet");


			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AY')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AZ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BF')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BH')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('BI')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BU')->setWidth(20);

			$objPHPExcel->getActiveSheet(0)->getStyle('A1:AF1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


			$objPHPExcel->getActiveSheet()
				->getStyle('A')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('B')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('C')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('D')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('E')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('F')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('K')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('L')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()
				->getStyle('H')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('I')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('M')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('N')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('O')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('P')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('Q')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('Y')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('Z')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AB')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AD')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('AE')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

					
			$objPHPExcel->getActiveSheet()
				->getStyle('AF')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			
			$objPHPExcel->getActiveSheet()
				->getStyle('AG')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AI:AL')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AU:BC')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);	
				
			$objPHPExcel->getActiveSheet()
				->getStyle('BK:BT')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);	
				
				
			$objPHPExcel->getActiveSheet()->getStyle('A1:BU1')->applyFromArray($bgcolorblue);

			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
			$objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
			$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
			$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
			$objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Consol');
			$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Area');
			$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Region');
			$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org DPST');
			$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Org TT');
			$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Month');
			$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Sales Engg Code');
			$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Sales Engg Name');
			$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Customer Group');
			$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Parent Code');
			$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Child Code');
			$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Customer_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Project_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('T1', 'PO Number');
			$objPHPExcel->getActiveSheet()->setCellValue('U1', 'PO Credit Term');
			$objPHPExcel->getActiveSheet()->setCellValue('V1', 'Company');
			$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Invoice Number');
			$objPHPExcel->getActiveSheet()->setCellValue('X1', 'Org. Document Number');
			$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'Dispatch Date');
			$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'Invoice_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'Credit Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'Due Date');
			$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'Credit Days Adj');
			$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'Rev Due date');
			$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Balance Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AH1', 'Currency');
			$objPHPExcel->getActiveSheet()->setCellValue('AI1', 'FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AJ1', 'FX Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AK1', 'FX Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AL1', 'FX Balance Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AM1', 'Customer Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AN1', 'ECL Category');
			$objPHPExcel->getActiveSheet()->setCellValue('AO1', 'ECL RTN Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AP1', 'FEMA Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AQ1', 'Current Mth FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AR1', 'Modified Doc');
			$objPHPExcel->getActiveSheet()->setCellValue('AS1', 'Invoice Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AT1', 'OD Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AU1', 'Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AV1', 'Overdue');
			$objPHPExcel->getActiveSheet()->setCellValue('AW1', 'FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AX1', 'OD Ageing Category');
			$objPHPExcel->getActiveSheet()->setCellValue('AY1', 'FX Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AZ1', 'FX Over Due');
			$objPHPExcel->getActiveSheet()->setCellValue('BA1', 'FX FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('BB1', 'FX Impact');
			$objPHPExcel->getActiveSheet()->setCellValue('BC1', 'Collection Days');
			$objPHPExcel->getActiveSheet()->setCellValue('BD1', 'Responsibity');
			$objPHPExcel->getActiveSheet()->setCellValue('BE1', 'Planned Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BF1', 'Planned_Coll_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BG1', 'Retention');
			$objPHPExcel->getActiveSheet()->setCellValue('BH1', 'Retention_Warranty');
			$objPHPExcel->getActiveSheet()->setCellValue('BI1', 'Planned_RTN_WRTN_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BJ1', 'Planned_RTN_WRTN_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BK1', 'WON');
			$objPHPExcel->getActiveSheet()->setCellValue('BL1', 'LD');
			$objPHPExcel->getActiveSheet()->setCellValue('BM1', 'Legal');
			$objPHPExcel->getActiveSheet()->setCellValue('BN1', 'PBG_LC');
			$objPHPExcel->getActiveSheet()->setCellValue('BO1', 'CNAF');
			$objPHPExcel->getActiveSheet()->setCellValue('BP1', 'SRN');
			$objPHPExcel->getActiveSheet()->setCellValue('BQ1', 'FOC');
			$objPHPExcel->getActiveSheet()->setCellValue('BR1', 'WDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BS1', 'TDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BT1', 'Actual Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BU1', 'Actual Coll Date');

			$c = '2';
			$count = '1';
			foreach ($list as $l) {

				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);

				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);

				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);

				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);

				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->consol);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->area);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->region);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_dpst);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, $l->org_tt);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, $l->month);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, $l->sales_engg_code);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, $l->sales_engg_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, $l->customer_group);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->parent_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, $l->child_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, $l->customer_name);
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, $l->project_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, $l->po_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, $l->po_credit_term);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, $l->company);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, $l->invoice_number);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, $l->org_document_number);
				
				if ($l->dispatch_date != '' && $l->dispatch_date != '0000-00-00' && $l->dispatch_date != '1970-01-01' && $l->dispatch_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, date('d-M-Y', strtotime($l->dispatch_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "-");
				}
				
				if ($l->invoice_date != '' && $l->invoice_date != '0000-00-00' && $l->invoice_date != '1970-01-01' && $l->invoice_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, date('d-M-Y', strtotime($l->invoice_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "-");
				}
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, $l->credit_days);
				
				if ($l->due_date != '' && $l->due_date != '0000-00-00' && $l->due_date != '1970-01-01' && $l->due_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, date('d-M-Y', strtotime($l->due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "-");
				}

				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, $l->credit_days_adj);

				if ($l->rev_due_date != '' && $l->rev_due_date != '0000-00-00' && $l->rev_due_date != '1970-01-01' && $l->rev_due_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "-");
				}
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, money_format('%!i', $l->invoice_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, money_format('%!i', $l->paid_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, money_format('%!i', $l->balance_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('AH' . $c, $l->currency);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AI' . $c, money_format('%!i', $l->fx_rate));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AJ' . $c, money_format('%!i', $l->fx_invoice_amount));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AK' . $c, money_format('%!i', $l->fx_paid_amount));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AL' . $c, money_format('%!i', $l->fx_balance_amount));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AM' . $c, $l->customer_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AN' . $c, $l->ecl_category);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AO' . $c, $l->ecl_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AP' . $c, $l->fema_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AQ' . $c, $l->current_mth_fx_rate);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AR' . $c, $l->modified_doc);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AS' . $c, $l->invoice_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AT' . $c, $l->od_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AU' . $c, money_format('%!i',$l->within_due));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AV' . $c, money_format('%!i',$l->overdue));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AW' . $c, money_format('%!i',$l->ftm_due));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AX' . $c, $l->od_ageing_category);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AY' . $c, money_format('%!i',$l->fx_within_due));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AZ' . $c, money_format('%!i',$l->fx_over_due));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BA' . $c, money_format('%!i',$l->fx_ftm_due));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BB' . $c, money_format('%!i',$l->fx_impact));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BC' . $c, $l->collection_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BD' . $c, $l->responsibility);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BE' . $c, money_format('%!i',$l->planned_coll_amt));
				
				if ($l->planned_coll_date != '' && $l->planned_coll_date != '0000-00-00' && $l->planned_coll_date != '1970-01-01' && $l->planned_coll_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BF' . $c, date('d-M-Y', strtotime($l->planned_coll_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BF' . $c, "-");
				}
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BG' . $c, money_format('%!i',$l->retention));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BH' . $c, money_format('%!i',$l->warranty_retention));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BI' . $c, $l->planned_rtn_wrtn_coll_amt);
				
				if ($l->planned_rtn_wrtn_date != '' && $l->planned_rtn_wrtn_date != '0000-00-00' && $l->planned_rtn_wrtn_date != '1970-01-01' && $l->planned_rtn_wrtn_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BJ' . $c, date('d-M-Y', strtotime($l->planned_rtn_wrtn_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BJ' . $c, "-");
				}
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BK' . $c, money_format('%!i',$l->won));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BL' . $c, money_format('%!i',$l->ld));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BM' . $c, money_format('%!i',$l->legal));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BN' . $c, money_format('%!i',$l->pbg_lc));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BO' . $c, money_format('%!i',$l->cnaf));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BP' . $c, money_format('%!i',$l->srn));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BQ' . $c, money_format('%!i',$l->foc));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BR' . $c, money_format('%!i',$l->wds));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BS' . $c, money_format('%!i',$l->tds));
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BT' . $c, money_format('%!i',$l->actual_coll_amount)); 
				
				if ($l->actual_coll_date != '' && $l->actual_coll_date != '0000-00-00' && $l->actual_coll_date != '1970-01-01' && $l->actual_coll_date != null ) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BU' . $c, date('d-M-Y', strtotime($l->actual_coll_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BU' . $c, "-");
				}
				
				
				$c++;
				$count++;
			}

			ob_end_clean();

			$today = date('m-Y');

			$objPHPExcel->getActiveSheet()->setTitle('Month End AR Report');

			$objPHPExcel->setActiveSheetIndex(0);

			ob_clean();

			ob_end_flush();

			$filename = 'Month End AR Report-' . $month_year . '.xlsx';

			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $filename . '"'); 
			
			header('Cache-Control: max-age=0');

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

			ob_end_clean();

			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/elgi_month_end_ar/" . $filename;
			

			$objWriter->save($path); 
			
			$this->db->set("excel_report", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array[0]->month);
			$this->db->update('cron_table'); */
			
			
			//---------- User Input List ---------------//
			
		
           /*  $vertical_id = '';
            $month_year = $month_end_array[0]->month;
       

        $list1 = $this->base_model->getMonthEndReportListForExcelMapping($month_year, $vertical_id);

            //load PHPExcel library
            $this->load->library('Excel');
            ob_start();
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
            $styleArray = array(
                'font' => array(
                    'size' => 13,
                    'name' => 'Roboto'
                )
            );
            $fontArray = array(
                'font' => array(
                    'bold' => true,
                    'size' => 11,
                    'name' => 'Roboto'
                )
            );
            $dateArray = array(
                'font' => array(
                    'bold' => true,
                )
            );
            $bgcolor = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'E7E7E7'),
                )
            );

            $bgcolorblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '66bfff'),
                )
            );

            $bgblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ff0000'),
                )
            );

            $bgbrr = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '82b7da'),
                )
            );



            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
                ->setLastModifiedBy("Comprehensive School Management")
                ->setTitle("Office  XLSX Test Document")
                ->setSubject("Office XLSX Test Document")
                ->setDescription("Test document for Office XLSX, generated by PHP classes.")
                ->setKeywords("office openxml php")
                ->setCategory("Excel Sheet");


            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);

            $objPHPExcel->getActiveSheet(0)->getStyle('A1:AG1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


            $objPHPExcel->getActiveSheet()
                ->getStyle('A')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('B')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('C')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('D')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('E')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('F')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('K')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()
                ->getStyle('L')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            $objPHPExcel->getActiveSheet()
                ->getStyle('H')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('I')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('M')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('N')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('O')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('P')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('Q')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            // Add some data

            $objPHPExcel->getActiveSheet()->getStyle('A1:AG1')->applyFromArray($bgcolorblue);



            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
            $objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
            $objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
            $objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
            $objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
            $objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
            $objPHPExcel->getActiveSheet()->setCellValue('G1', 'Child_Code');
            $objPHPExcel->getActiveSheet()->setCellValue('H1', 'Customer_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('I1', 'Project_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org_Document_Number');
            $objPHPExcel->getActiveSheet()->setCellValue('K1', 'Invoice_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('L1', 'Rev_Due_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('M1', 'Invoice_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('N1', 'Paid_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('O1', 'Balance_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('P1', 'Currency');
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Fx_Rate');
            $objPHPExcel->getActiveSheet()->setCellValue('R1', 'Planned_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('S1', 'Planned_Coll_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('T1', 'Retention');
            $objPHPExcel->getActiveSheet()->setCellValue('U1', 'Retention_Warranty');
            $objPHPExcel->getActiveSheet()->setCellValue('V1', 'Planned_RTN_WRTN_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('W1', 'Planned_RTN_WRTN_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('X1', 'PBG_LC');
            $objPHPExcel->getActiveSheet()->setCellValue('Y1', 'WON');
            $objPHPExcel->getActiveSheet()->setCellValue('Z1', 'CNAF');
            $objPHPExcel->getActiveSheet()->setCellValue('AA1', 'SRN');
            $objPHPExcel->getActiveSheet()->setCellValue('AB1', 'FOC');
            $objPHPExcel->getActiveSheet()->setCellValue('AC1', 'WDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AD1', 'TDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AE1', 'LD');
            $objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Legal');
            $objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Responsibility');

            $c = '2';
            $count = '1';
            foreach ($list1 as $l) {

                if (!empty($l->console_entity)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
                }

                if (!empty($l->sbu)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
                }

                if (!empty($l->cluster)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
                }

                if (!empty($l->vertical)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "NA");
                }

                if (!empty($l->country)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "NA");
                }

                if (!empty($l->ar_type)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, "NA");
                }

                if (!empty($l->child_code)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->child_code);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "NA");
                }

                if (!empty($l->customer_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->customer_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "NA");
                }

                if (!empty($l->project_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->project_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, "NA");
                }

                if (!empty($l->org_document_number)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_document_number);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, "NA");
                }

                if ($l->invoice_date != '' && $l->invoice_date != null && $l->invoice_date != '1970-01-01' && $l->invoice_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, date('d-M-Y', strtotime($l->invoice_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
                }

                if ($l->rev_due_date != '' && $l->rev_due_date != null && $l->rev_due_date != '1970-01-01' && $l->rev_due_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
                }

                if (!empty($l->invoice_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!i', $l->invoice_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, "0");
                }

                if (!empty($l->paid_amount)) { 
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!i', $l->paid_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, "0");
                }

                if (!empty($l->balance_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!i', $l->balance_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "0");
                }

                if (!empty($l->currency)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->currency);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "0");
                }

                if (!empty($l->fx_rate)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!i', $l->fx_rate));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "0");
                }

                if (!empty($l->planned_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!i', $l->planned_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "0");
                }

                if ($l->planned_coll_date != null && $l->planned_coll_date != '0000-00-00' && $l->planned_coll_date != '' && $l->planned_coll_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, date('d-M-Y', strtotime($l->planned_coll_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "");
                }

                if (!empty($l->retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!i', $l->retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "0");
                }

                if (!empty($l->warranty_retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!i', $l->warranty_retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "0");
                }

                if (!empty($l->planned_rtn_wrtn_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!i', $l->planned_rtn_wrtn_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "0");
                }

                if ($l->planned_rtn_wrtn_date != null && $l->planned_rtn_wrtn_date != '0000-00-00' && $l->planned_rtn_wrtn_date != '' && $l->planned_rtn_wrtn_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, date('d-M-Y', strtotime($l->planned_rtn_wrtn_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "");
                }

                if (!empty($l->pbg_lc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, money_format('%!i', $l->pbg_lc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "0");
                }

                if (!empty($l->won)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, money_format('%!i', $l->won));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "0");
                }

                if (!empty($l->cnaf)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, money_format('%!i', $l->cnaf));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "0");
                }

                if (!empty($l->srn)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, money_format('%!i', $l->srn));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "0");
                }

                if (!empty($l->foc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, money_format('%!i', $l->foc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "0");
                }

                if (!empty($l->wds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, money_format('%!i', $l->wds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "0");
                }

                if (!empty($l->tds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, money_format('%!i', $l->tds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "0");
                }

                if (!empty($l->ld)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, money_format('%!i', $l->ld));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "0");
                }

                if (!empty($l->legal)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, money_format('%!i', $l->legal));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "0");
                }

                if (!empty($l->responsibility)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, money_format('%!i', $l->responsibility));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, "");
                }

                $c++;
                $count++;
            }
			
			$this->db->set("user_input_excel", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array[0]->month);
			$this->db->update('cron_table');
			
            ob_end_clean();

            $today = date('m-Y');

            // Rename worksheet (worksheet, not filename)
            $objPHPExcel->getActiveSheet()->setTitle('User Upload Template format v2');

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            // Redirect output to a client’s web browser (Excel2007)

            $filename = 'AR-' . $month_year . '.xlsx'; //save our workbook as this file name

            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0');

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            ob_end_clean();
			
			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/user_input_excels/" . $filename;
			
			$objWriter->save($path); */
			
            // $objWriter->save('php://output');  
			
			
			
		 }
		 	
    }
	
	

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_groups_create'), 'admin/groups/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('group_name', 'lang:create_group_validation_name_label', 'required|alpha_dash');

		if ($this->form_validation->run() == TRUE)
		{
			$new_group_id = $this->ion_auth->create_group($this->input->post('group_name'), $this->input->post('description'));
			if ($new_group_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('admin/groups', 'refresh');
			}
		}
		else
		{
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['group_name'] = array(
				'name'  => 'group_name',
				'id'    => 'group_name',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('group_name')
			);
			$this->data['description'] = array(
				'name'  => 'description',
				'id'    => 'description',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('description')
			);

            /* Load Template */
            $this->template->admin_render('admin/groups/create', $this->data);
		}
	}


	public function delete()
	{
        if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        elseif ( ! $this->ion_auth->is_admin())
		{
            return show_error('You must be an administrator to view this page.');
        }
        else
        {
            $this->load->view('admin/groups/delete');
        }
	}


	public function edit($id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $id OR empty($id))
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_groups_edit'), 'admin/groups/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */
		$group = $this->ion_auth->group($id)->row();

		/* Validate form input */
        $this->form_validation->set_rules('group_name', $this->lang->line('edit_group_validation_name_label'), 'required|alpha_dash');

		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$group_update = $this->ion_auth->update_group($id, $_POST['group_name'], $_POST['group_description']);

				if ($group_update)
				{
					$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));

                    /* IN TEST */
                    $this->db->update('groups', array('bgcolor' => $_POST['group_bgcolor']), 'id = '.$id);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				redirect('admin/groups', 'refresh');
			}
		}

        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        $this->data['group']   = $group;

		$readonly = $this->config->item('admin_group', 'ion_auth') === $group->name ? 'readonly' : '';

		$this->data['group_name'] = array(
			'type'    => 'text',
			'name'    => 'group_name',
			'id'      => 'group_name',
			'value'   => $this->form_validation->set_value('group_name', $group->name),
            'class'   => 'form-control',
			$readonly => $readonly
		);
		$this->data['group_description'] = array(
			'type'  => 'text',
			'name'  => 'group_description',
			'id'    => 'group_description',
			'value' => $this->form_validation->set_value('group_description', $group->description),
            'class' => 'form-control'
		);
		$this->data['group_bgcolor'] = array(
			'type'     => 'text',
			'name'     => 'group_bgcolor',
			'id'       => 'group_bgcolor',
			'value'    => $this->form_validation->set_value('group_bgcolor', $group->bgcolor),
			'data-src' => $group->bgcolor,
            'class'    => 'form-control'
		);

        /* Load Template */
        $this->template->admin_render('admin/groups/edit', $this->data);
	}
	
	

	
	
		public function excel_report(){
			
			//--------------- Excel Export ---------------------------//
			
			$month_end_array = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'cron_status' => 1, 'process_data' => 1, 'excel_start_report' => 0, 'excel_report' => 0 ))->result();	
			
			$month_end_array1 = $month_end_array[0]->month;
			
			$this->db->set("excel_start_report", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array1);
			$this->db->update('cron_table');

			$list = $this->base_model->getMonthEndReportListForExcel($month_end_array1);
			
			$this->load->library('Excel');
			ob_start();
			
			$objPHPExcel = new PHPExcel();
			$styleArray = array(
				'font' => array(
					'size' => 13,
					'name' => 'Roboto'
				)
			);
			$fontArray = array(
				'font' => array(
					'bold' => true,
					'size' => 11,
					'name' => 'Roboto'
				)
			);
			$dateArray = array(
				'font' => array(
					'bold' => true,
				)
			);
			$bgcolor = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'E7E7E7'),
				)
			);

			$bgcolorblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '66bfff'),
				)
			);

			$bgblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'ff0000'),
				)
			);

			$bgbrr = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '82b7da'),
				)
			);
			
			$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
				->setLastModifiedBy("Comprehensive School Management")
				->setTitle("Office  XLSX Test Document")
				->setSubject("Office XLSX Test Document")
				->setDescription("Test document for Office XLSX, generated by PHP classes.")
				->setKeywords("office openxml php")
				->setCategory("Excel Sheet");


			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AY')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AZ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BF')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BH')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('BI')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BU')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BV')->setWidth(20);

			$objPHPExcel->getActiveSheet(0)->getStyle('A1:AF1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


			$objPHPExcel->getActiveSheet()
				->getStyle('A')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('B')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('C')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('D')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('E')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('F')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('K')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('L')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()
				->getStyle('H')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('I')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('M')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('N')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('O')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('P')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('Q')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('Y')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('Z')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AB')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AD')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('AE')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

					
			$objPHPExcel->getActiveSheet()
				->getStyle('AF')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			
			$objPHPExcel->getActiveSheet()
				->getStyle('AG')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AI:AL')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('AU:BC')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);	
				
			$objPHPExcel->getActiveSheet()
				->getStyle('BK:BT')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);	
				
				
			$objPHPExcel->getActiveSheet()->getStyle('A1:BV1')->applyFromArray($bgcolorblue);

			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
			$objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
			$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
			$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
			$objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Consol');
			$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Area');
			$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Region');
			$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org DPST');
			$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Org TT');
			$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Month');
			$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Sales Engg Code');
			$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Sales Engg Name');
			$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Customer Group');
			$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Parent Code');
			$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Child Code');
			$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Customer_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Project_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('T1', 'PO Number');
			$objPHPExcel->getActiveSheet()->setCellValue('U1', 'PO Credit Term');
			$objPHPExcel->getActiveSheet()->setCellValue('V1', 'Company');
			$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Invoice Number');
			$objPHPExcel->getActiveSheet()->setCellValue('X1', 'Org. Document Number');
			$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'Dispatch Date');
			$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'Invoice_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'Credit Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'Due Date');
			$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'Credit Days Adj');
			$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'Rev Due date');
			$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Balance Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AH1', 'Currency');
			$objPHPExcel->getActiveSheet()->setCellValue('AI1', 'FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AJ1', 'FX Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AK1', 'FX Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AL1', 'FX Balance Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AM1', 'Customer Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AN1', 'ECL Category');
			$objPHPExcel->getActiveSheet()->setCellValue('AO1', 'ECL RTN Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AP1', 'FEMA Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AQ1', 'Current Mth FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AR1', 'Modified Doc');
			$objPHPExcel->getActiveSheet()->setCellValue('AS1', 'Invoice Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AT1', 'OD Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AU1', 'Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AV1', 'Overdue');
			$objPHPExcel->getActiveSheet()->setCellValue('AW1', 'FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AX1', 'OD Ageing Category');
			$objPHPExcel->getActiveSheet()->setCellValue('AY1', 'FX Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AZ1', 'FX Over Due');
			$objPHPExcel->getActiveSheet()->setCellValue('BA1', 'FX FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('BB1', 'FX Impact');
			$objPHPExcel->getActiveSheet()->setCellValue('BC1', 'Collection Days');
			$objPHPExcel->getActiveSheet()->setCellValue('BD1', 'Responsibity');
			$objPHPExcel->getActiveSheet()->setCellValue('BE1', 'Planned Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BF1', 'Planned_Coll_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BG1', 'Retention');
			$objPHPExcel->getActiveSheet()->setCellValue('BH1', 'Retention_Warranty');
			$objPHPExcel->getActiveSheet()->setCellValue('BI1', 'Planned_RTN_WRTN_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BJ1', 'Planned_RTN_WRTN_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BK1', 'WON');
			$objPHPExcel->getActiveSheet()->setCellValue('BL1', 'LD');
			$objPHPExcel->getActiveSheet()->setCellValue('BM1', 'Legal');
			$objPHPExcel->getActiveSheet()->setCellValue('BN1', 'PBG_LC');
			$objPHPExcel->getActiveSheet()->setCellValue('BO1', 'CNAF');
			$objPHPExcel->getActiveSheet()->setCellValue('BP1', 'SRN');
			$objPHPExcel->getActiveSheet()->setCellValue('BQ1', 'FOC');
			$objPHPExcel->getActiveSheet()->setCellValue('BR1', 'WDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BS1', 'TDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BT1', 'Actual Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BU1', 'Actual Coll Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BV1', 'Commissioning');

			$c = '2';
			$count = '1';
			foreach ($list as $l) {

				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);

				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);

				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);

				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);

				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->consol);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->area);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->region);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_dpst);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, $l->org_tt);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, $l->month);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, $l->sales_engg_code);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, $l->sales_engg_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, $l->customer_group);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->parent_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, $l->child_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, $l->customer_name);
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, $l->project_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, $l->po_name);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, $l->po_credit_term);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, $l->company);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, $l->invoice_number);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, $l->org_document_number);
				
				if ($l->dispatch_date != '' && $l->dispatch_date != '0000-00-00' && $l->dispatch_date != '1970-01-01' && $l->dispatch_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, date('d-M-Y', strtotime($l->dispatch_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "-");
				}
				
				if ($l->invoice_date != '' && $l->invoice_date != '0000-00-00' && $l->invoice_date != '1970-01-01' && $l->invoice_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, date('d-M-Y', strtotime($l->invoice_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "-");
				}
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, $l->credit_days);
				
				if ($l->due_date != '' && $l->due_date != '0000-00-00' && $l->due_date != '1970-01-01' && $l->due_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, date('d-M-Y', strtotime($l->due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "-");
				}

				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, $l->credit_days_adj);

				if ($l->rev_due_date != '' && $l->rev_due_date != '0000-00-00' && $l->rev_due_date != '1970-01-01' && $l->rev_due_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "-");
				}
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, $l->invoice_amount);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, $l->paid_amount);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, $l->balance_amount);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AH' . $c, $l->currency);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AI' . $c, $l->fx_rate);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AJ' . $c, $l->fx_invoice_amount);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AK' . $c, $l->fx_paid_amount);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AL' . $c, $l->fx_balance_amount);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AM' . $c, $l->customer_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AN' . $c, $l->ecl_category);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AO' . $c, $l->ecl_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AP' . $c, $l->fema_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AQ' . $c, $l->current_mth_fx_rate);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AR' . $c, $l->modified_doc);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AS' . $c, $l->invoice_type);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AT' . $c, $l->od_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AU' . $c, $l->within_due);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AV' . $c, $l->overdue);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AW' . $c, $l->ftm_due);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AX' . $c, $l->od_ageing_category);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AY' . $c, $l->fx_within_due);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('AZ' . $c, $l->fx_over_due);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BA' . $c, $l->fx_ftm_due);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BB' . $c, $l->fx_impact);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BC' . $c, $l->collection_days);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BD' . $c, $l->responsibility);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BE' . $c, $l->planned_coll_amt);
				
				if ($l->planned_coll_date != '' && $l->planned_coll_date != '0000-00-00' && $l->planned_coll_date != '1970-01-01' && $l->planned_coll_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BF' . $c, date('d-M-Y', strtotime($l->planned_coll_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BF' . $c, "-");
				}
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BG' . $c, $l->retention);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BH' . $c, $l->warranty_retention);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BI' . $c, $l->planned_rtn_wrtn_coll_amt);
				
				if ($l->planned_rtn_wrtn_date != '' && $l->planned_rtn_wrtn_date != '0000-00-00' && $l->planned_rtn_wrtn_date != '1970-01-01' && $l->planned_rtn_wrtn_date != null) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BJ' . $c, date('d-M-Y', strtotime($l->planned_rtn_wrtn_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BJ' . $c, "-");
				}
				
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BK' . $c, $l->won);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BL' . $c, $l->ld);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BM' . $c, $l->legal);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BN' . $c, $l->pbg_lc);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BO' . $c, $l->cnaf);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BP' . $c, $l->srn);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BQ' . $c, $l->foc);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BR' . $c, $l->wds);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BS' . $c, $l->tds);
				
				$objPHPExcel->getActiveSheet(0)->setCellValue('BT' . $c, $l->actual_coll_amount); 
				
				if ($l->actual_coll_date != '' && $l->actual_coll_date != '0000-00-00' && $l->actual_coll_date != '1970-01-01' && $l->actual_coll_date != null ) {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BU' . $c, date('d-M-Y', strtotime($l->actual_coll_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('BU' . $c, "-");
				}

				$objPHPExcel->getActiveSheet(0)->setCellValue('BV' . $c, $l->commissioning);
				
				$c++;
				$count++;
			}
			
			

			ob_end_clean();

			$today = date('m-Y');

			$objPHPExcel->getActiveSheet()->setTitle('Month End AR Report');

			$objPHPExcel->setActiveSheetIndex(0);

			ob_clean();

			ob_end_flush();

			$filename = 'Month End AR Report-' . $month_end_array1 . '.xlsx';

			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $filename . '"'); 
			
			header('Cache-Control: max-age=0');

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

			ob_end_clean();

			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/elgi_month_end_ar/" . $filename;
			

			$objWriter->save($path);

			$this->db->set("excel_report", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array1);
			$this->db->update('cron_table');			
			
			}
			
			
			public function user_input_excel(){
				
				//---------- User Input List ---------------//
				
			$month_end_array = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'cron_status' => 1, 'process_data' => 1, 'user_input_start_excel' => 0, 'user_input_excel' => 0 ))->result();	
			
			$month_end_array = $month_end_array[0]->month;
			
			$this->db->set("user_input_start_excel", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array);
			$this->db->update('cron_table');
			
            $vertical_id = '';
            $month_year = $month_end_array;
       

        $list1 = $this->base_model->getMonthEndReportListForExcelMapping($month_year, $vertical_id);

            //load PHPExcel library
            $this->load->library('Excel');
            ob_start();
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
            $styleArray = array(
                'font' => array(
                    'size' => 13,
                    'name' => 'Roboto'
                )
            );
            $fontArray = array(
                'font' => array(
                    'bold' => true,
                    'size' => 11,
                    'name' => 'Roboto'
                )
            );
            $dateArray = array(
                'font' => array(
                    'bold' => true,
                )
            );
            $bgcolor = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'E7E7E7'),
                )
            );

            $bgcolorblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '66bfff'),
                )
            );

            $bgblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ff0000'),
                )
            );

            $bgbrr = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '82b7da'),
                )
            );



            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
                ->setLastModifiedBy("Comprehensive School Management")
                ->setTitle("Office  XLSX Test Document")
                ->setSubject("Office XLSX Test Document")
                ->setDescription("Test document for Office XLSX, generated by PHP classes.")
                ->setKeywords("office openxml php")
                ->setCategory("Excel Sheet");


            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);

            $objPHPExcel->getActiveSheet(0)->getStyle('A1:AG1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


            $objPHPExcel->getActiveSheet()
                ->getStyle('A')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('B')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('C')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('D')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('E')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('F')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('K')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()
                ->getStyle('L')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            $objPHPExcel->getActiveSheet()
                ->getStyle('H')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('I')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('M')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('N')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('O')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('P')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('Q')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            // Add some data

            $objPHPExcel->getActiveSheet()->getStyle('A1:AG1')->applyFromArray($bgcolorblue);



            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
            $objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
            $objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
            $objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
            $objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
            $objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
            $objPHPExcel->getActiveSheet()->setCellValue('G1', 'Child_Code');
            $objPHPExcel->getActiveSheet()->setCellValue('H1', 'Customer_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('I1', 'Project_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org_Document_Number');
            $objPHPExcel->getActiveSheet()->setCellValue('K1', 'Invoice_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('L1', 'Rev_Due_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('M1', 'Invoice_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('N1', 'Paid_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('O1', 'Balance_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('P1', 'Currency');
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Fx_Rate');
            $objPHPExcel->getActiveSheet()->setCellValue('R1', 'Planned_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('S1', 'Planned_Coll_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('T1', 'Retention');
            $objPHPExcel->getActiveSheet()->setCellValue('U1', 'Retention_Warranty');
            $objPHPExcel->getActiveSheet()->setCellValue('V1', 'Planned_RTN_WRTN_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('W1', 'Planned_RTN_WRTN_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('X1', 'PBG_LC');
            $objPHPExcel->getActiveSheet()->setCellValue('Y1', 'WON');
            $objPHPExcel->getActiveSheet()->setCellValue('Z1', 'CNAF');
            $objPHPExcel->getActiveSheet()->setCellValue('AA1', 'SRN');
            $objPHPExcel->getActiveSheet()->setCellValue('AB1', 'FOC');
            $objPHPExcel->getActiveSheet()->setCellValue('AC1', 'WDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AD1', 'TDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AE1', 'LD');
            $objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Legal');
            $objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Responsibility');

            $c = '2';
            $count = '1';
            foreach ($list1 as $l) {

                if (!empty($l->console_entity)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
                }

                if (!empty($l->sbu)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
                }

                if (!empty($l->cluster)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
                }

                if (!empty($l->vertical)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "NA");
                }

                if (!empty($l->country)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "NA");
                }

                if (!empty($l->ar_type)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, "NA");
                }

                if (!empty($l->child_code)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->child_code);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "NA");
                }

                if (!empty($l->customer_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->customer_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "NA");
                }

                if (!empty($l->project_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->project_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, "NA");
                }

                if (!empty($l->org_document_number)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_document_number);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, "NA");
                }

                if ($l->invoice_date != '' && $l->invoice_date != null && $l->invoice_date != '1970-01-01' && $l->invoice_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, date('d-M-Y', strtotime($l->invoice_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
                }

                if ($l->rev_due_date != '' && $l->rev_due_date != null && $l->rev_due_date != '1970-01-01' && $l->rev_due_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
                }

                if (!empty($l->invoice_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!i', $l->invoice_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, "0");
                }

                if (!empty($l->paid_amount)) { 
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!i', $l->paid_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, "0");
                }

                if (!empty($l->balance_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!i', $l->balance_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "0");
                }

                if (!empty($l->currency)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->currency);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "0");
                }

                if (!empty($l->fx_rate)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!i', $l->fx_rate));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "0");
                }

                if (!empty($l->planned_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!i', $l->planned_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "0");
                }

                if ($l->planned_coll_date != null && $l->planned_coll_date != '0000-00-00' && $l->planned_coll_date != '' && $l->planned_coll_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, date('d-M-Y', strtotime($l->planned_coll_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "");
                }

                if (!empty($l->retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!i', $l->retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "0");
                }

                if (!empty($l->warranty_retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!i', $l->warranty_retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "0");
                }

                if (!empty($l->planned_rtn_wrtn_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!i', $l->planned_rtn_wrtn_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "0");
                }

                if ($l->planned_rtn_wrtn_date != null && $l->planned_rtn_wrtn_date != '0000-00-00' && $l->planned_rtn_wrtn_date != '' && $l->planned_rtn_wrtn_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, date('d-M-Y', strtotime($l->planned_rtn_wrtn_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "");
                }

                if (!empty($l->pbg_lc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, money_format('%!i', $l->pbg_lc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "0");
                }

                if (!empty($l->won)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, money_format('%!i', $l->won));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "0");
                }

                if (!empty($l->cnaf)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, money_format('%!i', $l->cnaf));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "0");
                }

                if (!empty($l->srn)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, money_format('%!i', $l->srn));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "0");
                }

                if (!empty($l->foc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, money_format('%!i', $l->foc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "0");
                }

                if (!empty($l->wds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, money_format('%!i', $l->wds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "0");
                }

                if (!empty($l->tds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, money_format('%!i', $l->tds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "0");
                }

                if (!empty($l->ld)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, money_format('%!i', $l->ld));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "0");
                }

                if (!empty($l->legal)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, money_format('%!i', $l->legal));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "0");
                }

                if (!empty($l->responsibility)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, money_format('%!i', $l->responsibility));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, "");
                }

                $c++;
                $count++;
            }

            ob_end_clean();

            $today = date('m-Y');

            // Rename worksheet (worksheet, not filename)
            $objPHPExcel->getActiveSheet()->setTitle('User Upload Template format v2');

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            // Redirect output to a client’s web browser (Excel2007)

            $filename = 'AR-' . $month_year . '.xlsx'; //save our workbook as this file name

            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0');

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            ob_end_clean();
			
			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/user_input_excels/" . $filename;
			
			$objWriter->save($path);
			
            // $objWriter->save('php://output');
			
			$this->db->set("user_input_excel", 1);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->where("month", $month_end_array[0]->month);
			$this->db->update('cron_table');
			
			}
			
			
			
		public function user_input_calculation(){
				
		//--------------- Month End AR Report -----------------//	 
				 
		 $month_end_array = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'cron_status' => 1, 'process_data' => 1, 'user_input_start_status' => 0, 'user_input_end_status' => 0 ))->result();
		 
		 if(count($month_end_array) > 0){
			 
			 $month_year = $month_end_array[0]->month;

		if ($month_year != '') {
			
			$this->db->set("user_input_start_status", 1);
			$this->db->where("month", $month_year);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');

			$month_end_ar_data = $this->base_model->month_end_ar_process_data_list($month_year);

			$table_rep = "month_end_ar_process_data";

			if (!empty($month_end_ar_data)) {
				
				$fetchData = array();
				foreach ($month_end_ar_data as $key => $m) {
					
					$user_input_1 = get_user_input($m->org_document_number);
					
					$user_input_daily_collection_1 = get_daily_collection($m->org_document_number, $m->month_year);
					
					$fetchData[$key]['org_document_number'] 		= $m->org_document_number;
					$fetchData[$key]['responsibility'] 		= $user_input_1->responsibility;
					$fetchData[$key]['planned_coll_amt'] = $user_input_1->planned_coll_amt;
					$fetchData[$key]['planned_coll_date'] = $user_input_1->planned_coll_date;
					$fetchData[$key]['retention'] = $user_input_1->retention;
					$fetchData[$key]['warranty_retention'] = $user_input_1->warranty_retention;
					$fetchData[$key]['planned_rtn_wrtn_coll_amt'] = $user_input_1->planned_rtn_wrtn_coll_amt;
					$fetchData[$key]['planned_rtn_wrtn_date'] = $user_input_1->planned_rtn_wrtn_date;
					$fetchData[$key]['pbg_lc'] = $user_input_1->pbg_lc;
					$fetchData[$key]['won'] = $user_input_1->won;
					$fetchData[$key]['cnaf'] = $user_input_1->cnaf;
					$fetchData[$key]['srn'] = $user_input_1->srn;
					$fetchData[$key]['foc'] = $user_input_1->foc;
					$fetchData[$key]['wds'] = $user_input_1->wds;
					$fetchData[$key]['tds'] = $user_input_1->tds;
					$fetchData[$key]['gst_tds'] = $user_input_1->gst_tds;
					$fetchData[$key]['ld'] = $user_input_1->ld;
					$fetchData[$key]['legal'] = $user_input_1->legal;
					
					$fetchData[$key]['actual_coll_date'] = $user_input_daily_collection_1->document_date;
					$fetchData[$key]['actual_coll_amount'] = $user_input_daily_collection_1->collection;
					

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData[$key]['modified_doc']			= 1;
					} else {
						$fetchData[$key]['modified_doc']			= 0;
					}
					

					// Third Cal

					$fetchData[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData[$key]['od_days'] >= '0') {
						$fetchData[$key]['overdue'] = $m->balance_amount - ($fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention']);
					} else {
						$fetchData[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData[$key]['within_due'] = $m->balance_amount - $fetchData[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[0] != 12){
					$from_date1 = $split_month[0] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1) {
						$fetchData[$key]['ftm_due'] = $fetchData[$key]['within_due'] - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['overdue'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData[$key]['ftm_due'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData[$key]['invoice_type'] 		= "Not Due";
					}
					

					// Seventh cal FX within Due

					$fetchData[$key]['fx_within_due'] 		= $fetchData[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchData[$key]['fx_overdue'] 		= $fetchData[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchData[$key]['fx_ftm_due'] 		= $fetchData[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact

					$fetchData[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchData[$key]['collection_days'] 		= $this->get_number_of_days($fetchData[$key]['planned_coll_date'], $fetchData[$key]['actual_coll_date']);
					
					
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('calc', 1);
					$this->db->update('month_end_ar_process_data');
					

				} 
			}
			
			//print_r($fetchData);
		
			if (!empty($fetchData)) {
				//$this->db->where('month_year',$month_year);
				$this->db->update_batch('month_end_ar_process_data', $fetchData,'org_document_number');

			}
			// print_r($this->db->last_query());
			//die;

			/* $this->db->set("user_input_end_status", 1);
			$this->db->where("month", $month_year);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table'); */
		
		       }
			
			}
	 
		}
		
		
		
		/************************************************************************/
		
		
    public function upload_user_input_upload_ajax_cron()
    {
		

        $error = '';
        $output = array();
		
		
//print_r("ffffff");die;
        if (1 == 1) {
			 
			
			
            if (1 == 1) {
                //$f_type                             = explode(".", $_FILES['upload_user_input_list_file']['name']);
                //$last_in                          = (count($f_type) - 1);

                if (1 != 1) {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
					
					
					
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = "./upload/elgi_month_end_ar/userinput.xlsx";
					
					
					
					
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
					
					

                    $objPHPExcel                             = $objReader->load($inputFileName);
					
					
					
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);



                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
					
					$createArray = array('Consol_Entity', 'SBU', 'Cluster', 'Vertical', 'Country', 'AR_Type', 'Child_Code', 'Customer_Name', 'Project_Name', 'Org_Document_Number', 'Invoice_Date', 'Rev_Due_Date', 'Invoice_Amount', 'Paid_Amount', 'Balance_Amount', 'Currency', 'Fx_Rate', 'Planned_Coll_Amount',  'Planned_Coll_Date', 'Retention', 'Retention_Warranty',  'Planned_RTN_WRTN_Coll_Amount', 'Planned_RTN_WRTN_Date', 'PBG_LC',  'WON', 'CNAF', 'SRN', 'FOC',  'WDS',  'TDS', 'LD', 'Legal', 'Responsibility');
                    
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
						
						//print_r($SheetDataKey);die;
						
                       

                       
                    }

                    if (empty($erroredRcords)) {
                        
						 
						

                        if (0 == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Consol_Entity = trim($SheetDataKey['Consol_Entity']);
								
								
								//print_r($arrayCount);
					//print_r("cccc");
								//print_r($SheetDataKey['Consol_Entity']);die;
								
                                $SBU = trim($SheetDataKey['SBU']);
                                $Cluster = trim($SheetDataKey['Cluster']);
                                $Vertical = trim($SheetDataKey['Vertical']);
                                $Country = trim($SheetDataKey['Country']);
                                $AR_Type = trim($SheetDataKey['AR_Type']);
                                $Child_Code = trim($SheetDataKey['Child_Code']);
                                $Customer_Name = trim($SheetDataKey['Customer_Name']);
                                $Project_Name = trim($SheetDataKey['Project_Name']);
                                $Org_Document_Number = trim($SheetDataKey['Org_Document_Number']);
                                $Invoice_Date = trim($SheetDataKey['Invoice_Date']);
                                $Rev_Due_Date = trim($SheetDataKey['Rev_Due_Date']);
                                $Invoice_Amount = trim($SheetDataKey['Invoice_Amount']);
                                $Paid_Amount = trim($SheetDataKey['Paid_Amount']);
                                $Balance_Amount = trim($SheetDataKey['Balance_Amount']);
                                $Currency = trim($SheetDataKey['Currency']);
                                $Fx_Rate = trim($SheetDataKey['Fx_Rate']);
                                $Planned_Coll_Amount = trim($SheetDataKey['Planned_Coll_Amount']);
                                $Planned_Coll_Date = trim($SheetDataKey['Planned_Coll_Date']);
                                $Retention = trim($SheetDataKey['Retention']);
                                $Retention_Warranty = trim($SheetDataKey['Retention_Warranty']);
                                $Planned_RTN_WRTN_Coll_Amount = trim($SheetDataKey['Planned_RTN_WRTN_Coll_Amount']);
                                $Planned_RTN_WRTN_Date = trim($SheetDataKey['Planned_RTN_WRTN_Date']);
                                $PBG_LC = trim($SheetDataKey['PBG_LC']);
                                $WON = trim($SheetDataKey['WON']);
                                $CNAF = trim($SheetDataKey['CNAF']);
                                $SRN = trim($SheetDataKey['SRN']);
                                $FOC = trim($SheetDataKey['FOC']);
                                $WDS = trim($SheetDataKey['WDS']);
                                $TDS = trim($SheetDataKey['TDS']);
                                $LD = trim($SheetDataKey['LD']);
                                $Legal = trim($SheetDataKey['Legal']);
                                $Responsibility = trim($SheetDataKey['Responsibility']);
                                $Consol_Entity = filter_var(trim($allDataInSheet[$i][$Consol_Entity]), FILTER_SANITIZE_STRING);
                                $SBU = filter_var(trim($allDataInSheet[$i][$SBU]), FILTER_SANITIZE_STRING);
                                $Cluster = filter_var(trim($allDataInSheet[$i][$Cluster]), FILTER_SANITIZE_STRING);
                                $Vertical = filter_var(trim($allDataInSheet[$i][$Vertical]), FILTER_SANITIZE_STRING);
                                $Country = filter_var(trim($allDataInSheet[$i][$Country]), FILTER_SANITIZE_STRING);
                                $AR_Type = filter_var(trim($allDataInSheet[$i][$AR_Type]), FILTER_SANITIZE_STRING);
                                $Child_Code = filter_var(trim($allDataInSheet[$i][$Child_Code]), FILTER_SANITIZE_STRING);
                                $Customer_Name = filter_var(trim($allDataInSheet[$i][$Customer_Name]), FILTER_SANITIZE_STRING);
                                $Project_Name = filter_var(trim($allDataInSheet[$i][$Project_Name]), FILTER_SANITIZE_STRING);
                                $Org_Document_Number = filter_var(trim($allDataInSheet[$i][$Org_Document_Number]), FILTER_SANITIZE_STRING);
                                $Invoice_Date = filter_var(trim($allDataInSheet[$i][$Invoice_Date]), FILTER_SANITIZE_STRING);

                                if ($Invoice_Date != '') {
                                    $Invoice_Datee =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_RTN_WRTN_Date)));
                                } else {
                                    $Invoice_Datee = '';
                                }

                                $Rev_Due_Date = filter_var(trim($allDataInSheet[$i][$Rev_Due_Date]), FILTER_SANITIZE_STRING);

                                if ($Rev_Due_Date != '') {
                                    $Rev_Due_Datee =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_RTN_WRTN_Date)));
                                } else {
                                    $Rev_Due_Datee = '';
                                }
                                $Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Paid_Amount = filter_var(trim($allDataInSheet[$i][$Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Balance_Amount = filter_var(trim($allDataInSheet[$i][$Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Currency = filter_var(trim($allDataInSheet[$i][$Currency]), FILTER_SANITIZE_STRING);
                                $Fx_Rate = filter_var(trim($allDataInSheet[$i][$Fx_Rate]), FILTER_SANITIZE_STRING);
                                $Planned_Coll_Amount = filter_var(trim($allDataInSheet[$i][$Planned_Coll_Amount]), FILTER_SANITIZE_STRING);
                                $Planned_Coll_Date = filter_var(trim($allDataInSheet[$i][$Planned_Coll_Date]), FILTER_SANITIZE_STRING);

                                if ($Planned_Coll_Date != '') {
                                    $Planned_Coll_Datee =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_RTN_WRTN_Date)));
                                } else {
                                    $Planned_Coll_Datee = '';
                                }

                                $Retention = filter_var(trim($allDataInSheet[$i][$Retention]), FILTER_SANITIZE_STRING);
                                $Retention_Warranty = filter_var(trim($allDataInSheet[$i][$Retention_Warranty]), FILTER_SANITIZE_STRING);
                                $Planned_RTN_WRTN_Coll_Amount = filter_var(trim($allDataInSheet[$i][$Planned_RTN_WRTN_Coll_Amount]), FILTER_SANITIZE_STRING);

                                $Planned_RTN_WRTN_Date = filter_var(trim($allDataInSheet[$i][$Planned_RTN_WRTN_Date]), FILTER_SANITIZE_STRING);
                                if ($Planned_RTN_WRTN_Date != '') {
                                    $Planned_RTN_WRTN_Datee =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_RTN_WRTN_Date)));
                                } else {
                                    $Planned_RTN_WRTN_Datee = '';
                                }

                                $PBG_LC = filter_var(trim($allDataInSheet[$i][$PBG_LC]), FILTER_SANITIZE_STRING);
                                $WON = filter_var(trim($allDataInSheet[$i][$WON]), FILTER_SANITIZE_STRING);
                                $CNAF = filter_var(trim($allDataInSheet[$i][$CNAF]), FILTER_SANITIZE_STRING);
                                $SRN = filter_var(trim($allDataInSheet[$i][$SRN]), FILTER_SANITIZE_STRING);
                                $FOC = filter_var(trim($allDataInSheet[$i][$FOC]), FILTER_SANITIZE_STRING);
                                $WDS = filter_var(trim($allDataInSheet[$i][$WDS]), FILTER_SANITIZE_STRING);
                                $TDS = filter_var(trim($allDataInSheet[$i][$TDS]), FILTER_SANITIZE_STRING);
                                $LD = filter_var(trim($allDataInSheet[$i][$LD]), FILTER_SANITIZE_STRING);
                                $Legal = filter_var(trim($allDataInSheet[$i][$Legal]), FILTER_SANITIZE_STRING);
                                $Responsibility = filter_var(trim($allDataInSheet[$i][$Responsibility]), FILTER_SANITIZE_STRING);
                                $created_on =   date("Y-m-d h:i:s");
                                $user_id =  2;

                                $fetchData[] = array(
                                    'month_year' =>  "12-2021",
                                    'console_entity' =>  $Consol_Entity,
                                    'sbu' => $SBU,
                                    'cluster' => $Cluster,
                                    'vertical' =>  $Vertical,
                                    'country' => $Country,
                                    'ar_type' => $AR_Type,
                                    'child_node' => $Child_Code,
                                    'customer_name' =>  $Customer_Name,
                                    'project_name' => $Project_Name,
                                    'org_document_number' => $Org_Document_Number,
                                    'invoice_date' => $Invoice_Datee,
                                    'rev_due_date' => $Rev_Due_Datee,
                                    'invoice_amount' =>  $Invoice_Amount,
                                    'paid_amount' => $Paid_Amount,
                                    'balance_amount' => $Balance_Amount,
                                    'currency' =>  $Currency,
                                    'fx_rate' => $Fx_Rate,
                                    'planned_coll_amt' => $Planned_Coll_Amount,
                                    'planned_coll_date' => $Planned_Coll_Datee,
                                    'retention' => $Retention,
                                    'warranty_retention' => $Retention_Warranty,
                                    'planned_rtn_wrtn_coll_amt' =>  $Planned_RTN_WRTN_Coll_Amount,
                                    'planned_rtn_wrtn_date' => $Planned_RTN_WRTN_Datee,
                                    'pbg_lc' => $PBG_LC,
                                    'won' => $WON,
                                    'cnaf' => $CNAF,
                                    'srn' =>  $SRN,
                                    'foc' => $FOC,
                                    'wds' => $WDS,
                                    'tds' => $TDS,
                                    'ld' =>  $LD,
                                    'legal' => $Legal,
                                    'responsibility' =>  $Responsibility,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            //echo '<pre>';
                           // print_r($fetchData);
                           // die;
                            $this->db->delete('user_input', array('month_year' => "12-2021", 'user_id' =>  $user_id));
                            $this->base_model->setBatchImportUploadUserInput($fetchData);
                            if ($this->base_model->importDataUploadUserInput() == 1) {
                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */
                                $msg_success = count($fetchData) . "  Rows of User Input Info Uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                                /* Update month end ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('month_end_ar_list', array('process_data' => 0));
                                /* Update current ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('daily_ar', array('process_data' => 0));
                            } else {
                                echo 'no';
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('AH2:AH' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AH2:AH' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('AH1:AH' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AH1:AH' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('AH1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }
		
		
			
	



	public function get_number_of_days($date1, $date2)
	{
		$now = strtotime($date1); // or your date as well
		$your_date = strtotime($date2);
		$datediff = $now - $your_date;

		return round($datediff / (60 * 60 * 24)); 
	}	
	

	// ----------------- Final Table --------------

			public function Final_calculation(){	 
				 
		 $month_end_array = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'cron_status' => 1, 'process_data' => 1, 'user_input_start_status' => 0, 'user_input_end_status' => 0 ))->result();
		 
		 
		 if(count($month_end_array) > 0){
			 
			 $month_year = $month_end_array[0]->month;


			 
		if ($month_year != '') {
			
			$this->db->set("user_input_start_status", 1);
			$this->db->where("month", $month_year);
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');
		
		$month_end_ar_data = $this->db->query("select month_end_ar_process_data_final.*,tot_sum.col,
    tot_sum.date_1 from  month_end_ar_process_data_final LEFT JOIN(
    SELECT SUM(daily_collection.collection) AS col,
        MAX(daily_collection.document_date) AS date_1,
    	original_doc_number
    
    FROM
        daily_collection
    WHERE
        daily_collection.month_year = '" . $month_year . "'
    GROUP BY
        daily_collection.original_doc_number
) AS tot_sum
ON
    (month_end_ar_process_data_final.org_document_number = tot_sum.original_doc_number) where month_end_ar_process_data_final.org_document_number != '' AND month_end_ar_process_data_final.month_year='".$month_year."'")->result();
	
	// print_r($this->db->last_query());die;
		
		// $user_input_data = $this->db->query('select user_input.* from user_input where user_input.org_document_number !='' AND user_input.org_document_number="'.$month_year.'" and user_input.month_year="'.$month_year.'"')->result();
		
		// $month_end_ar_data = $this->base_model->process_data_userinput_list($month_year);
		
		// print_r($this->db->last_query());die; 
		/* echo "<pre>"; 
		print_r($month_end_ar_data);die; */
			
			/* echo "rrrr";
			print_r($this->db->last_query());die; */

			$table_rep = "month_end_ar_process_data";

			if (!empty($month_end_ar_data)) {
				
				foreach ($month_end_ar_data as $m) {
					
					
				// $user_input_data = $this->db->query("select user_input.* from user_input where user_input.org_document_number !='' AND user_input.org_document_number='".$m->org_document_number ."' and user_input.month_year='".$m->month_year ."'")->result();
				
				
				$user_input_data = $this->db->query("select user_input.* from user_input where user_input.org_document_number !='' AND user_input.org_document_number='".$m->org_document_number ."' and user_input.month_year='".$m->month_year ."'")->result();	
				
				
				  if(!empty($user_input_data)){  foreach ($user_input_data as $u) {
					
					if($u->responsibility!='' && $u->responsibility!='0' && $u->responsibility!='-'){
					$fetchData['responsibility'] 		= $u->responsibility;
					}else{
					$fetchData['responsibility'] 		= $m->responsibility;	
					}
					
					if($u->planned_coll_amt!='' && $u->planned_coll_amt!='0' && $u->planned_coll_amt!='-'){
					$fetchData['planned_coll_amt'] = $u->planned_coll_amt;
					}else{
					$fetchData['planned_coll_amt'] = $m->planned_coll_amt;	
					}
					
					if($u->planned_coll_date!='' && $u->planned_coll_date!='0000-00-00' && $u->planned_coll_date!='-' && $u->planned_coll_date!='1970-01-01'){
					$fetchData['planned_coll_date'] = $u->planned_coll_date;
					}else{
					$fetchData['planned_coll_date'] = $m->planned_coll_date;	
					}
					
					if($u->retention!='' && $u->retention!='0' && $u->retention!='-'){
					$fetchData['retention'] = $u->retention;
					}else{
					$fetchData['retention'] = $m->retention;	
					}
					
					if($u->warranty_retention!='' && $u->warranty_retention!='0' && $u->warranty_retention!='-'){
					$fetchData['warranty_retention'] = $u->warranty_retention;
					}else{
					$fetchData['warranty_retention'] = $m->warranty_retention;	
					}
					
					if($u->planned_rtn_wrtn_coll_amt!='' && $u->planned_rtn_wrtn_coll_amt!='0' && $u->planned_rtn_wrtn_coll_amt!='-'){
					$fetchData['planned_rtn_wrtn_coll_amt'] = $u->planned_rtn_wrtn_coll_amt;
					}else{
					$fetchData['planned_rtn_wrtn_coll_amt'] = $m->planned_rtn_wrtn_coll_amt;	
					}
					
					if($u->planned_rtn_wrtn_date!='' && $u->planned_rtn_wrtn_date!='0000-00-00' && $u->planned_rtn_wrtn_date!='-' && $u->planned_rtn_wrtn_date!='1970-01-01'){
					$fetchData['planned_rtn_wrtn_date'] = $u->planned_rtn_wrtn_date;
					}else{
					$fetchData['planned_rtn_wrtn_date'] = $m->planned_rtn_wrtn_date;	
					}
					
					if($u->pbg_lc!='' && $u->pbg_lc!='0' && $u->pbg_lc!='-'){
					$fetchData['pbg_lc'] = $u->pbg_lc;
					}else{
					$fetchData['pbg_lc'] = $m->pbg_lc;	
					}
					
					if($u->won!='' && $u->won!='0' && $u->won!='-'){
					$fetchData['won'] = $u->won;
					}else{
					$fetchData['won'] = $m->won;	
					}
					
					if($u->cnaf!='' && $u->cnaf!='0' && $u->cnaf!='-'){
					$fetchData['cnaf'] = $u->cnaf;
					}else{
					$fetchData['cnaf'] = $m->cnaf;	
					}
					
					if($u->srn!='' && $u->srn!='0' && $u->srn!='-'){
					$fetchData['srn'] = $u->srn;
					}else{
					$fetchData['srn'] = $m->srn;	
					}
					
					if($u->foc!='' && $u->foc!='0' && $u->foc!='-'){
					$fetchData['foc'] = $u->foc;
					}else{
					$fetchData['foc'] = $m->foc;	
					}
					
					if($u->wds!='' && $u->wds!='0' && $u->wds!='-'){
					$fetchData['wds'] = $u->wds;
					}else{
					$fetchData['wds'] = $m->wds;	
					}
					
					if($u->tds!='' && $u->tds!='0' && $u->tds!='-'){
					$fetchData['tds'] = $u->tds;
					}else{
					$fetchData['tds'] = $m->tds;	
					}
					
					if($u->gst_tds!='' && $u->gst_tds!='0' && $u->gst_tds!='-'){
					$fetchData['gst_tds'] = $u->gst_tds;
					}else{
					$fetchData['gst_tds'] = $m->gst_tds;	
					}
					
					if($u->ld!='' && $u->ld!='0' && $u->ld!='-'){
					$fetchData['ld'] = $u->ld;
					}else{
					$fetchData['ld'] = $m->ld;	
					}
					
					if($u->legal!='' && $u->legal!='0' && $u->legal!='-'){
					$fetchData['legal'] = $u->legal;
					}else{
					$fetchData['legal'] = $m->legal;	
					}
					
					
					
					// $fetchData[$key]['actual_coll_date'] = 0;
					$fetchData['actual_coll_date'] = $m->date_1;
					$fetchData['actual_coll_amount'] = $m->col;
					
					
					//echo "<pre>";
					 //print_r($m->col);die;
					
					
					
					if ($m->org_document_number != $m->document_number) {
						$fetchData['modified_doc']			= 1;
					} else {
						$fetchData['modified_doc']			= 0;
					}


				

					// Six cal OD Ageing category
					
					$fetchData['od_ageing_category'] = $m->od_ageing_category;
					
					$fetchData['od_days'] = $m->od_days;
					
					$fetchData['fx_impact'] = $m->fx_impact;
					
					$fetchData['current_mth_fx_rate'] = $m->current_mth_fx_rate;



					// Fifth Cal 
						$fetchData['overdue'] = '';
					if ($fetchData['od_days'] >= 0) {
						$fetchData['overdue'] = $m->balance_amount - ($fetchData['retention'] + $fetchData['warranty_retention']);
					} else {
						$fetchData['overdue'] = 0;
					}


					// Fourth Cal 

					$fetchData['within_due'] = $m->balance_amount - $fetchData['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[1] != 12){
					$from_date1 = $split_month[1] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[1];
					
					// print_r($split_rev_month);
					
					


					if ($from_date2 == $from_date1) {
						$fetchData['ftm_due'] = $fetchData['within_due'] - ($fetchData['retention'] + $fetchData['warranty_retention']);
					} else {
						$fetchData['ftm_due'] = 0;
					}
					
					// print_r($fetchData[$key]['ftm_due']);


					// Second Cal

					if ($fetchData['od_days'] >= 0 && $fetchData['overdue'] != 0) {
						$fetchData['invoice_type'] 		= "OD";
					} elseif ($fetchData['ftm_due'] != 0) {
						$fetchData['invoice_type'] 		= "FTM";
					} else {
						$fetchData['invoice_type'] 		= "Not Due";
					}
					

					// Seventh cal FX within Due
						
					$fx_within_val = $fetchData['within_due'] / $m->fx_rate;	
						
					if($fx_within_val!='' && !is_nan($fx_within_val) && !is_infinite($fx_within_val) ){	

					$fetchData['fx_within_due'] 		= $fx_within_val;

					}else{
						
					$fetchData['fx_within_due'] 		= 0;	
						
					}
					
					// Eight cal fx_overdue
						
					$fx_overdue_val	= $fetchData['overdue'] / $m->fx_rate;
						
					if($fx_overdue_val!='' && !is_nan($fx_overdue_val) && !is_infinite($fx_overdue_val) ){	

					$fetchData['fx_overdue'] 		= $fx_overdue_val;

					}else{
						
					$fetchData['fx_overdue'] 		= 0;	
						
					}
					
					// Night cal fx_ftm_du
						
					$fx_ftm_val = $fetchData['ftm_due'] / $m->fx_rate;	
						
					if($fx_ftm_val!='' && !is_nan($fx_ftm_val) && !is_infinite($fx_ftm_val) ){	

					$fetchData['fx_ftm_due'] 		= $fx_ftm_val;

					}else{
						
					$fetchData['fx_ftm_due'] 		= 0;	
						
					}

					
					// Eleven cal collection_days

					$fetchData['collection_days'] 		= $this->get_number_of_days($fetchData['planned_coll_date'], $fetchData['actual_coll_date']);
					
					
					// if( $u->org_document_number !='490_432_30002014'){
					
				$this->db->where("month_year", $u->month_year);
				$this->db->where("org_document_number", $u->org_document_number);
				$this->db->update('month_end_ar_process_data', $fetchData);
				
					/* }else{
						
				$this->db->where("month_year", $u->month_year);
				// $this->db->where("org_document_number", $u->org_document_number);
				// $this->db->update('month_end_ar_process_data', $fetchData);	

				print_r($fetchData);die;	
				
				// print_r($this->db->last_query());die;		
						
					} */
				
				
				
					
				}

				}else{
					// echo "test222";
					//===== Code -----------//
					
					
					// $fetchData[$key]['actual_coll_date'] = 0;
					$fetchData1['actual_coll_date'] = $m->date_1;
					$fetchData1['actual_coll_amount'] = $m->col;
					
					
					//echo "<pre>";
					 //print_r($m->col);die;
					
					
					
					if ($m->org_document_number != $m->document_number) {
						$fetchData1['modified_doc']			= 1;
					} else {
						$fetchData1['modified_doc']			= 0;
					}


				

					// Six cal OD Ageing category
					
					$fetchData1['od_ageing_category'] = $m->od_ageing_category;
					

					$fetchData1['od_days'] = $m->od_days;
					
					$fetchData1['fx_impact'] = $m->fx_impact;
					
					$fetchData1['current_mth_fx_rate'] = $m->current_mth_fx_rate;



					// Fifth Cal 
						$fetchData1['overdue'] = '';
					if ($fetchData1['od_days'] >= 0) {
						$fetchData1['overdue'] = $m->balance_amount - ($fetchData1['retention'] + $fetchData1['warranty_retention']);
					} else {
						$fetchData1['overdue'] = 0;
					}


					// Fourth Cal 

					$fetchData1['within_due'] = $m->balance_amount - $fetchData1['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					if($split_month[1] != 12){
					$from_date1 = $split_month[1] + 1;
					}else{
					$from_date1 = 1;	
					}

					$from_date2 = $split_rev_month[1];
					
					// print_r($split_rev_month);
					
					


					if ($from_date2 == $from_date1) {
						$fetchData1['ftm_due'] = $fetchData1['within_due'] - ($fetchData1['retention'] + $fetchData1['warranty_retention']);
					} else {
						$fetchData1['ftm_due'] = 0;
					}
					
					// print_r($fetchData[$key]['ftm_due']);


					// Second Cal

					if ($fetchData1['od_days'] >= 0 && $fetchData1['overdue'] != 0) {
						$fetchData1['invoice_type'] 		= "OD";
					} elseif ($fetchData1['ftm_due'] != 0) {
						$fetchData1['invoice_type'] 		= "FTM";
					} else {
						$fetchData1['invoice_type'] 		= "Not Due";
					}
					

					// Seventh cal FX within Due
					
					
					$fx_with = $fetchData1['within_due'] / $m->fx_rate;

					if($fx_with!='' && !is_nan($fx_with) && !is_infinite($fx_with) ){		

					$fetchData1['fx_within_due'] 		= $fx_with;

					}else{
						
					$fetchData1['fx_within_due'] 		= 0;	
						
					}
					
					// Eight cal fx_overdue
					
					// if($fetchData1['overdue']!= 0 && ) {

					$fx_od = $fetchData1['overdue'] / $m->fx_rate;

					if($fx_od!='' && !is_nan($fx_od) && !is_infinite($fx_od) ){		

					$fetchData1['fx_overdue'] 		= $fx_od;

					}else{
						
					$fetchData1['fx_overdue'] 		= 0;	
						
					}
					
					// Night cal fx_ftm_due


					$ftm_val = $fetchData1['ftm_due'] / $m->fx_rate;
					
					if($ftm_val!='' && !is_nan($ftm_val) && !is_infinite($ftm_val) ){	

					$fetchData1['fx_ftm_due'] 		= $ftm_val;

					}else{
						
					$fetchData1['fx_ftm_due'] 		= 0;	
						
					}

					
					// Eleven cal collection_days

					$fetchData1['collection_days'] 		= $this->get_number_of_days($fetchData1['planned_coll_date'], $fetchData1['actual_coll_date']);
					
					
					// print_r($fetchData1); die;


					
					// if( $m->org_document_number !='490_432_30002014'){
					
				$this->db->where("month_year", $m->month_year);
				$this->db->where("org_document_number", $m->org_document_number);
				$this->db->update('month_end_ar_process_data', $fetchData1);
				
				/* }else{
						
				$this->db->where("month_year", $m->month_year);
				$this->db->where("org_document_number", $m->org_document_number);
				$this->db->update('month_end_ar_process_data', $fetchData1);	
				
				print_r($this->db->last_query());die;	

				print_r($fetchData1);die;	
				
					
						
					} */

					// echo "continue";

					// print_r($this->db->last_query());

				
				
					// print_r($fetchData1);
					
				} 

				//  echo "<pre>";
				// print_r($fetchData1['overdue'] / $m->fx_rate);die;
				// print_r($fx_od ."///");
				// print_r($fetchData1['fx_overdue']);die;

				// print_r($fetchData1);
				
				}



				
				/* echo "<pre>";
				echo "testing";
				die; */	
				
				$this->db->set("user_input_end_status", 1);
				$this->db->where("month", $m->month_year);
				$this->db->where("cron_type", "month_end_ar");
				$this->db->update('cron_table');
				
			}
			
			
			
			
			
			// $this->db->query("DELETE FROM month_end_ar_process_data WHERE month_year='" . $month_year . "'");
			
			// if (!empty($fetchData)) {

				// $this->base_model->setBatchImportProcessDataFinal($fetchData);

				// $this->base_model->importDataProcessDataFinal();
				
				/* $this->db->set("user_input_end_status", 1);
				$this->db->where("month", $month_year);
				$this->db->where("cron_type", "month_end_ar");
				$this->db->update('cron_table'); */
			
			// }
			
		
		       }

		        
			
			}
	 
		}
		
		
}
