<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Masters extends Admin_Controller
{

    public function __construct()
    {

        parent::__construct();
        //echo count($admin_execution_overdue);
        $this->load->helper('security');
        $this->load->model('Base_model');
        $this->load->model('ajax_model');
        $this->load->library('form_validation');
        $this->load->library("pagination");
        $this->load->helper('url');

        $this->data['pagetitle'] = $this->page_title->show();
        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_users'), 'admin/masters');
    }


    public function index()
    {

        if (!$this->ion_auth->logged_in() or !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Get all users */
            $this->data['users'] = $this->ion_auth->users()->result();
            foreach ($this->data['users'] as $k => $user) {
                $this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
            }

            /* Load Template */
            $this->template->admin_render('admin/masters/index', $this->data);
        }
    }


    /************ELGI CODE START FROM HERE*****************/
    /*Kiran */
    public function console_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('console_name', 'Console Name', 'xss_clean|required');
            $this->form_validation->set_rules('console_code', 'Console Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "console_master";
                $inputdata['console_name']                        = $this->input->post('console_name');
                $inputdata['console_code']                        = $this->input->post('console_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Console Updated Succesfully');
                        redirect('admin/masters/console_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/console_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Console Added Succesfully');
                    redirect('admin/masters/console_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/console_master');
                }
            }
        }

        if ($param1 == "edit") {
            $console_master_details = $this->db->get_where('console_master', array('id' => $param2))->result();
            $this->data['console_master_details'] =  $console_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('console_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Console Deleted Succesfully');
                redirect('admin/masters/console_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/console_master');
            }
        }
        $this->data['console_master'] = $this->db->query("select * from console_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/console_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/console_master', $this->data);
    }

    /*Kiran */
    public function console_validation()
    {
        $console_name = trim($this->input->post('console_name'));
        $console_code = trim($this->input->post('console_code'));
        $cosole_master = $this->db->query("select * from console_master where console_name='" . $console_name . "' and console_code='" . $console_code . "'")->row();

        if (count($cosole_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function sbu_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('sbu_name', 'SBU Name', 'xss_clean|required');
            $this->form_validation->set_rules('sbu_code', 'SBU Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "sbu_master";
                $inputdata['sbu_name']                        = $this->input->post('sbu_name');
                $inputdata['sbu_code']                        = $this->input->post('sbu_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'SBU Updated Succesfully');
                        redirect('admin/masters/sbu_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/sbu_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'SBU Added Succesfully');
                    redirect('admin/masters/sbu_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/sbu_master');
                }
            }
        }


        if ($param1 == "edit") {
            $sbu_master_details = $this->db->get_where('sbu_master', array('id' => $param2))->result();
            $this->data['sbu_master_details'] =  $sbu_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('sbu_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'SBU Deleted Succesfully');
                redirect('admin/masters/sbu_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/sbu_master');
            }
        }
        $this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/sbu_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/sbu_master', $this->data);
    }

    /*Kiran */
    public function sbu_validationn()
    {
        $sbu_name = trim($this->input->post('sbu_name'));
        $sbu_code = trim($this->input->post('sbu_code'));
        $sbu_master = $this->db->query("select * from sbu_master where sbu_name='" . $sbu_name . "' and sbu_code='" . $sbu_code . "'")->row();

        if (count($sbu_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function cluster_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('cluster_name', 'Cluster Name', 'xss_clean|required');
            $this->form_validation->set_rules('cluster_code', 'Cluster Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "cluster_master";
                $inputdata['cluster_name']                        = $this->input->post('cluster_name');
                $inputdata['cluster_code']                        = $this->input->post('cluster_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Cluster Updated Succesfully');
                        redirect('admin/masters/cluster_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/cluster_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Cluster Added Succesfully');
                    redirect('admin/masters/cluster_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/cluster_master');
                }
            }
        }

        if ($param1 == "edit") {
            $cluster_master_details = $this->db->get_where('cluster_master', array('id' => $param2))->result();
            $this->data['cluster_master_details'] =  $cluster_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('cluster_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Cluster Deleted Succesfully');
                redirect('admin/masters/cluster_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/cluster_master');
            }
        }
        $this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position asc,cluster_name")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/cluster_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/cluster_master', $this->data);
    }

    /*Kiran */
    public function clusterr_validation()
    {
        $cluster_name = trim($this->input->post('cluster_name'));
        $cluster_code = trim($this->input->post('cluster_code'));
        $cluster_master = $this->db->query("select * from cluster_master where cluster_name='" . $cluster_name . "' and cluster_code='" . $cluster_code . "'")->row();

        if (count($cluster_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /*Kiran */
    public function update_cluster_position()
    {
        $position = trim($this->input->post('position'));
        $id = trim($this->input->post('id'));

        $data = array(
            'position' => $position
        );
        $this->db->where('id', $id);
        if ($this->db->update('cluster_master', $data)) {
            echo "0";
        }
    }

    /*Kiran */
    public function update_vertical_position()
    {
        $position = trim($this->input->post('position'));
        $id = trim($this->input->post('id'));

        $data = array(
            'position' => $position
        );
        $this->db->where('id', $id);
        if ($this->db->update('vertical_master', $data)) {
            echo "0";
        }
    }

    /*Kiran */
    public function vertical_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }
        if ($this->input->post()) {
            $this->form_validation->set_rules('vertical_name', 'Vertical Name', 'xss_clean|required');
            $this->form_validation->set_rules('vertical_code', 'Vertical Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "vertical_master";
                $inputdata['vertical_name']                        = $this->input->post('vertical_name');
                $inputdata['vertical_code']                        = $this->input->post('vertical_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Vertical Succesfully');
                        redirect('admin/masters/vertical_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/vertical_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Vertical Added Succesfully');
                    redirect('admin/masters/vertical_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/vertical_master');
                }
            }
        }

        if ($param1 == "edit") {
            $vertical_master_details = $this->db->get_where('vertical_master', array('id' => $param2))->result();
            $this->data['vertical_master_details'] =  $vertical_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('vertical_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Vertical Deleted Succesfully');
                redirect('admin/masters/vertical_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/vertical_master');
            }
        }
        $this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position asc,vertical_name ")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/vertical_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/vertical_master', $this->data);
    }

    /*Kiran */
    public function verticall_validation()
    {
        $vertical_name = trim($this->input->post('vertical_name'));
        $vertical_code = trim($this->input->post('vertical_code'));
        $vertical_master = $this->db->query("select * from vertical_master where vertical_name='" . $vertical_name . "' and vertical_code='" . $vertical_code . "'")->row();

        if (count($vertical_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function region_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('region_name', 'Region Name', 'xss_clean|required');
            $this->form_validation->set_rules('region_code', 'Region Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "region_master";
                $inputdata['region_name']                        = $this->input->post('region_name');
                $inputdata['region_code']                        = $this->input->post('region_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Region Updated Succesfully');
                        redirect('admin/masters/region_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/region_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Region Added Succesfully');
                    redirect('admin/masters/region_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/region_master');
                }
            }
        }

        if ($param1 == "edit") {
            $region_master_details = $this->db->get_where('region_master', array('id' => $param2))->result();
            $this->data['region_master_details'] =  $region_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('region_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Region Deleted Succesfully');
                redirect('admin/masters/region_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/region_master');
            }
        }
        $this->data['region_master'] = $this->db->query("select * from region_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/region_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/region_master', $this->data);
    }

    /*Kiran */
    public function regionr_validation()
    {
        $region_name = trim($this->input->post('region_name'));
        $region_code = trim($this->input->post('region_code'));
        $region_master = $this->db->query("select * from region_master where region_name='" . $region_name . "' and region_code='" . $region_code . "'")->row();

        if (count($region_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /*Kiran */
    public function country_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('country_name', 'Country Name', 'xss_clean|required');
            $this->form_validation->set_rules('country_code', 'Country Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "country_master";
                $inputdata['country_name']                        = $this->input->post('country_name');
                $inputdata['country_code']                        = $this->input->post('country_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Country Updated Succesfully');
                        redirect('admin/masters/country_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/country_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Country Added Succesfully');
                    redirect('admin/masters/country_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/country_master');
                }
            }
        }

        if ($param1 == "edit") {
            $country_master_details = $this->db->get_where('country_master', array('id' => $param2))->result();
            $this->data['country_master_details'] =  $country_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('country_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Country Deleted Succesfully');
                redirect('admin/masters/country_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/country_master');
            }
        }

        $this->data['country_master'] = $this->db->query("select * from country_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/country_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/country_master', $this->data);
    }

    /*Kiran */
    public function countryy_validation()
    {
        $country_name = trim($this->input->post('country_name'));
        $country_code = trim($this->input->post('country_code'));
        $country_master = $this->db->query("select * from country_master where country_name='" . $country_name . "' and country_code='" . $country_code . "'")->row();

        if (count($country_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function dpst_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('dpst_name', 'DPST Name', 'xss_clean|required');
            $this->form_validation->set_rules('dpst_code', 'DPST Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "dpst_master";
                $inputdata['dpst_name']                        = $this->input->post('dpst_name');
                $inputdata['dpst_code']                        = $this->input->post('dpst_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'DPST Updated Succesfully');
                        redirect('admin/masters/dpst_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/dpst_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'DPST Added Succesfully');
                    redirect('admin/masters/dpst_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/dpst_master');
                }
            }
        }

        if ($param1 == "edit") {
            $dpst_master_details = $this->db->get_where('dpst_master', array('id' => $param2))->result();
            $this->data['dpst_master_details'] =  $dpst_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('dpst_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'DPST Deleted Succesfully');
                redirect('admin/masters/dpst_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/dpst_master');
            }
        }
        $this->data['dpst_master'] = $this->db->query("select * from dpst_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/dpst_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/dpst_master', $this->data);
    }

    /*Kiran */
    public function dpstt_validation()
    {
        $dpst_name = trim($this->input->post('dpst_name'));
        $dpst_code = trim($this->input->post('dpst_code'));
        $dpst_master = $this->db->query("select * from dpst_master where dpst_name='" . $dpst_name . "' and dpst_code='" . $dpst_code . "' ")->row();

        if (count($dpst_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function ar_type_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('ar_type_name', 'AR Type Name', 'xss_clean|required');
            $this->form_validation->set_rules('ar_type_code', 'AR Type Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "ar_type_master";
                $inputdata['ar_type_name']                        = $this->input->post('ar_type_name');
                $inputdata['ar_type_code']                        = $this->input->post('ar_type_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Area Updated Succesfully');
                        redirect('admin/masters/ar_type_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/ar_type_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Area Added Succesfully');
                    redirect('admin/masters/ar_type_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/ar_type_master');
                }
            }
        }

        if ($param1 == "edit") {
            $ar_type_master_details = $this->db->get_where('ar_type_master', array('id' => $param2))->result();
            $this->data['ar_type_master_details'] =  $ar_type_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('ar_type_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'AR Type Deleted Succesfully');
                redirect('admin/masters/ar_type_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/ar_type_master');
            }
        }
        $this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/ar_type_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/ar_type_master', $this->data);
    }

    /*Kiran */
    public function artype_validation()
    {
        $ar_type_name = trim($this->input->post('ar_type_name'));
        $ar_type_code = trim($this->input->post('ar_type_code'));
        $ar_type_master = $this->db->query("select * from ar_type_master where ar_type_name='" . $ar_type_name . "' and ar_type_code='" . $ar_type_code . "' ")->row();

        if (count($ar_type_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }
    /*Kiran */
    public function local_fx_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('local_fx_name', 'Local FX Name', 'xss_clean|required');
            //$this->form_validation->set_rules('local_fx_code', 'Console Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "local_fx_master";
                $inputdata['local_fx_name']                        = $this->input->post('local_fx_name');
                //$inputdata['local_fx_code']                        = $this->input->post('local_fx_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Local FX Updated Succesfully');
                        redirect('admin/masters/local_fx_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/local_fx_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Local FX Added Succesfully');
                    redirect('admin/masters/local_fx_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/local_fx_master');
                }
            }
        }

        if ($param1 == "edit") {
            $local_fx_master_details = $this->db->get_where('local_fx_master', array('id' => $param2))->result();
            $this->data['local_fx_master_details'] =  $local_fx_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('local_fx_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Local FX Deleted Succesfully');
                redirect('admin/masters/local_fx_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/local_fx_master');
            }
        }
        $this->data['local_fx_master'] = $this->db->query("select * from local_fx_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/local_fx_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/local_fx_master', $this->data);
    }

    /*Kiran */
    public function localfx_validation()
    {
        $local_fx_name = trim($this->input->post('local_fx_name'));
        $local_fx_master = $this->db->query("select * from local_fx_master where local_fx_name='" . $local_fx_name . "'")->row();

        if (count($local_fx_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function area_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('area_name', 'Area Name', 'xss_clean|required');
            $this->form_validation->set_rules('area_code', 'Area Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "area_master";
                $inputdata['area_name']                        = $this->input->post('area_name');
                $inputdata['area_code']                        = $this->input->post('area_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");
                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Area Updated Succesfully');
                        redirect('admin/masters/area_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/area_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Area Added Succesfully');
                    redirect('admin/masters/area_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/area_master');
                }
            }
        }

        if ($param1 == "edit") {
            $area_master_details = $this->db->get_where('area_master', array('id' => $param2))->result();
            $this->data['area_master_details'] =  $area_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('area_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Area Deleted Succesfully');
                redirect('admin/masters/area_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/area_master');
            }
        }
        $this->data['area_master'] = $this->db->query("select * from area_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/area_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/area_master', $this->data);
    }

    /*Kiran */
    public function areaa_validation()
    {
        $area_name = trim($this->input->post('area_name'));
        $area_code = trim($this->input->post('area_code'));
        $area_master = $this->db->query("select * from area_master where area_name='" . $area_name . "' and area_code='" . $area_code . "' ")->row();

        if (count($area_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function transaction_type_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('transaction_type_name', 'Transaction Name', 'xss_clean|required');
            $this->form_validation->set_rules('transaction_type_code', 'Transaction Code', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "transaction_type_master";
                $inputdata['transaction_type_name']                        = $this->input->post('transaction_type_name');
                $inputdata['transaction_type_code']                        = $this->input->post('transaction_type_code');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Transaction Type Updated Succesfully');
                        redirect('admin/masters/transaction_type_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/transaction_type_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Transaction Type Added Succesfully');
                    redirect('admin/masters/transaction_type_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/transaction_type_master');
                }
            }
        }

        if ($param1 == "edit") {
            $transaction_type_master_details = $this->db->get_where('transaction_type_master', array('id' => $param2))->result();
            $this->data['transaction_type_master_details'] =  $transaction_type_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('transaction_type_master', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Transaction Type Deleted Succesfully');
                redirect('admin/masters/transaction_type_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/transaction_type_master');
            }
        }
        $this->data['transaction_type_master'] = $this->db->query("select * from transaction_type_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/transaction_type_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/transaction_type_master', $this->data);
    }

    /*Kiran */
    public function transactionn_validation()
    {
        $transaction_type_name = trim($this->input->post('transaction_type_name'));
        $transaction_type_code = trim($this->input->post('transaction_type_code'));
        $transaction_type_master = $this->db->query("select * from transaction_type_master where transaction_type_name='" . $transaction_type_name . "' and transaction_type_code='" . $transaction_type_code . "' ")->row();

        if (count($transaction_type_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*bulk upload*/
    public function vertical_bulk_upload_master()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->template->admin_render('admin/masters/vertical_bulk_upload_master', $this->data);
    }

    /*************************AJAX VERTCAL BULK UPLOAD*******************/


    /*bulk upload*/
    public function vertical_bulk_upload_master_ajax()
    {


        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['vertical_master_file']['name'] != '') {
            if ($_FILES['vertical_master_file']['name']) {
                $f_type                             = explode(".", $_FILES['vertical_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {



                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['vertical_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);


                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);


                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  


                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Vertical_Code', 'Vertical_Name', 'Position');
                    $makeArray = array('Vertical_Code' => 'Vertical_Code', 'Vertical_Name' => 'Vertical_Name', 'Position' => 'Position');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }



                        $dataInSheet = $this->vertical_validation($dataInSheet);
                        if ($dataInSheet['D'] != '') {
                            $erroredRcords[$j++] = $dataInSheet;
                            //continue;
                            //print_r($erroredRcords);
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }




                        if ($flag == 0) {


                            for ($i = 2; $i <= $arrayCount; $i++) {

                                $Vertical_Code = $SheetDataKey['Vertical_Code'];
                                $Vertical_Name = $SheetDataKey['Vertical_Name'];
                                $Position = $SheetDataKey['Position'];
                                $Vertical_Code = filter_var(trim($allDataInSheet[$i][$Vertical_Code]), FILTER_SANITIZE_STRING);
                                $Vertical_Name = filter_var(trim($allDataInSheet[$i][$Vertical_Name]), FILTER_SANITIZE_STRING);
                                $Position = filter_var(trim($allDataInSheet[$i][$Position]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'vertical_name' => $Vertical_Name,
                                    'vertical_code' => $Vertical_Code,
                                    'position' => $Position,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['vertical_info'] = $fetchData;
                            $this->base_model->setBatchImportVertical($fetchData);
                            if ($this->base_model->importDataVertical() == 1) {

                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */

                                $msg_success = count($fetchData) . " rows of vertical info uploaded Successfully.";

                                $output = array('success'  => true, 'msg_success' => $msg_success);


                                //redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {



                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('Vertical-Error-List' . date("Y-m-d"));

                        $red_cl = count($erroredRcords) + 1;

                        $objSheet->getStyle('D2:D' . $red_cl)->getFont()->setBold(true)->setSize(12);


                        $objSheet->getStyle('D2:D' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('D1')->setValue('Remarks');

                        //echo "<pre>";
                        //print_r($erroredRcords);die;

                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";


                        //$this->session->set_flashdata('unsucces', $msg);



                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);

                        // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        echo json_encode($output);
    }

    /*********************************END AJAX VERTCAL BULK UPLOAD*********/

    function vertical_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_vertical_list = $this->base_model->get_vertical_list();
        $array = json_decode(json_encode($get_vertical_list), true);
        $column_vertical_code = array_column($array, 'vertical_code');

        $duplicate = in_array($dataInSheet['A'], $column_vertical_code);


        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Vertical Code already exists";
        }

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Vertical Code is missing";
        }

        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Vertical Name is missing";
        }

        if ($dataInSheet['C'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Position is missing";
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['D'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }


    /*bulk upload*/
    public function region_bulk_upload_master()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->template->admin_render('admin/masters/region_bulk_upload_master', $this->data);
    }


    /*bulk upload*/
    public function region_bulk_upload_master_ajax()
    {


        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['region_master_file']['name'] != '') {
            if ($_FILES['region_master_file']['name']) {
                $f_type                             = explode(".", $_FILES['region_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['region_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);


                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);


                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  


                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Region_Code', 'Region_Name');
                    $makeArray = array('Region_Code' => 'Region_Code', 'Region_Name' => 'Region_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }



                        $dataInSheet = $this->region_master_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[$j++] = $dataInSheet;
                            //continue;
                            //print_r($erroredRcords);
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {

                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Region_Code = $SheetDataKey['Region_Code'];
                                $Region_Name = $SheetDataKey['Region_Name'];
                                $Region_Code = filter_var(trim($allDataInSheet[$i][$Region_Code]), FILTER_SANITIZE_STRING);
                                $Region_Name = filter_var(trim($allDataInSheet[$i][$Region_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $fetchData[] = array(
                                    'region_name' => $Region_Name,
                                    'region_code' => $Region_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->base_model->setBatchImportRegion($fetchData);
                            if ($this->base_model->importDataRegion() == 1) {
                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */

                                $msg_success = count($fetchData) . " rows of region info uploaded Successfully.";

                                $output = array('success'  => true, 'msg_success' => $msg_success);


                                //redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {



                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('Vertical-Error-List' . date("Y-m-d"));

                        $red_cl = count($erroredRcords) + 1;

                        $objSheet->getStyle('C2:C' . $red_cl)->getFont()->setBold(true)->setSize(12);


                        $objSheet->getStyle('C2:C' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remarks');

                        //echo "<pre>";
                        //print_r($erroredRcords);die;

                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";


                        //$this->session->set_flashdata('unsucces', $msg);



                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);

                        // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        echo json_encode($output);
    }


    function region_master_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_region_list = $this->base_model->get_region_list();
        $array = json_decode(json_encode($get_region_list), true);
        $column_region_code = array_column($array, 'region_code');

        $duplicate = in_array($dataInSheet['A'], $column_region_code);


        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Region Code already exists";
        }

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Region Code is missing";
        }

        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Region Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }


    /*Kiran */
    function cluster_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_cluster_list = $this->base_model->get_cluster_list();
        $array = json_decode(json_encode($get_cluster_list), true);
        $column_cluster_code = array_column($array, 'cluster_code');

        $duplicate = array_search($dataInSheet['A'], $column_cluster_code);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Cluster Code already exists";
        }

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Cluster Code is missing";
        }

        if ($dataInSheet['B'] == NULL) {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Cluster Name is missing";
        }
        if ($dataInSheet['C'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Position is missing";
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['D'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }



    /*Kiran */
    /*bulk upload*/
    public function cluster_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['cluster_master_file']['name'] != '') {
            if ($_FILES['cluster_master_file']['name']) {
                $f_type                             = explode(".", $_FILES['cluster_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/cluster_bulk_upload_master', 'refresh');
                } else {



                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['cluster_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Cluster_Code', 'Cluster_Name', 'Position');
                    $makeArray = array('Cluster_Code' => 'Cluster_Code', 'Cluster_Name' => 'Cluster_Name', 'Position' => 'Position');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }



                        $dataInSheet = $this->cluster_validation($dataInSheet);
                        if ($dataInSheet['D'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Cluster_Code = $SheetDataKey['Cluster_Code'];
                                $Cluster_Name = $SheetDataKey['Cluster_Name'];
                                $Position = $SheetDataKey['Position'];
                                $Cluster_Code = filter_var(trim($allDataInSheet[$i][$Cluster_Code]), FILTER_SANITIZE_STRING);
                                $Cluster_Name = filter_var(trim($allDataInSheet[$i][$Cluster_Name]), FILTER_SANITIZE_STRING);
                                $Position = filter_var(trim($allDataInSheet[$i][$Position]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'cluster_name' => $Cluster_Name,
                                    'cluster_code' => $Cluster_Code,
                                    'position' => $Position,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['cluster_info'] = $fetchData;
                            $this->base_model->setBatchImportCluster($fetchData);
                            if ($this->base_model->importDataCluster() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of cluster info uploaded Successfully.');
                                redirect('admin/masters/cluster_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('Cluster-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('D2:D' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('D2:D' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('D1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/cluster_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/cluster_bulk_upload_master', $this->data);
    }

    /*Kiran */
    /*bulk upload*/
    public function sbu_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['sbu_master_file']['name'] != '') {
            if ($_FILES['sbu_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['sbu_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/sbu_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['sbu_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('SBU_Code', 'SBU_Name');
                    $makeArray = array('SBU_Code' => 'SBU_Code', 'SBU_Name' => 'SBU_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->sbu_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $SBU_Code = $SheetDataKey['SBU_Code'];
                                $SBU_Name = $SheetDataKey['SBU_Name'];
                                $SBU_Code = filter_var(trim($allDataInSheet[$i][$SBU_Code]), FILTER_SANITIZE_STRING);
                                $SBU_Name = filter_var(trim($allDataInSheet[$i][$SBU_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'sbu_name' => $SBU_Name,
                                    'sbu_code' => $SBU_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['sbu_info'] = $fetchData;
                            $this->base_model->setBatchImportSBU($fetchData);
                            if ($this->base_model->importDataSBU() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of sbu info uploaded Successfully.');
                                redirect('admin/masters/sbu_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/sbu_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/sbu_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function sbu_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_sbu_list = $this->base_model->get_sbu_list();
        $array = json_decode(json_encode($get_sbu_list), true);
        $column_sbu_code = array_column($array, 'sbu_code');

        $duplicate = array_search($dataInSheet['A'], $column_sbu_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "SBU Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "SBU Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "SBU Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*bulk upload*/
    public function country_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['country_master_file']['name'] != '') {
            if ($_FILES['country_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['country_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/country_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['country_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Country_Code', 'Country_Name');
                    $makeArray = array('Country_Code' => 'Country_Code', 'Country_Name' => 'Country_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->country_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Country_Code = $SheetDataKey['Country_Code'];
                                $Country_Name = $SheetDataKey['Country_Name'];
                                $Country_Code = filter_var(trim($allDataInSheet[$i][$Country_Code]), FILTER_SANITIZE_STRING);
                                $Country_Name = filter_var(trim($allDataInSheet[$i][$Country_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'country_name' => $Country_Name,
                                    'country_code' => $Country_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['country_info'] = $fetchData;
                            $this->base_model->setBatchImportCountry($fetchData);
                            if ($this->base_model->importDataCountry() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of country info uploaded Successfully.');
                                redirect('admin/masters/country_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/country_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/country_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function country_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_country_list = $this->base_model->get_country_list();
        $array = json_decode(json_encode($get_country_list), true);
        $column_country_code = array_column($array, 'country_code');

        $duplicate = array_search($dataInSheet['A'], $column_country_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Country Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Country Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Country Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*bulk upload*/
    public function local_fx_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['local_fx_master_file']['name'] != '') {
            if ($_FILES['local_fx_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['local_fx_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/local_fx_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['local_fx_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Local_FX_Name');
                    $makeArray = array('Local_FX_Name' => 'Local_FX_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->local_fx_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Local_FX_Name = $SheetDataKey['Local_FX_Name'];
                                $Local_FX_Name = filter_var(trim($allDataInSheet[$i][$Local_FX_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'local_fx_name' => $Local_FX_Name,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['local_fx_info'] = $fetchData;
                            $this->base_model->setBatchImportLocalFX($fetchData);
                            if ($this->base_model->importDataLocalFX() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of local_fx info uploaded Successfully.');
                                redirect('admin/masters/local_fx_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/local_fx_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/local_fx_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function local_fx_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_local_fx_list = $this->base_model->get_local_fx_list();
        $array = json_decode(json_encode($get_local_fx_list), true);
        $column_local_fx_name = array_column($array, 'local_fx_name');

        $duplicate = array_search($dataInSheet['A'], $column_local_fx_name);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Local FX Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Local FX Name is missing";
        }


        /*    if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Local FX Name is missing";
        }
 */

        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*bulk upload*/
    public function area_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['area_master_file']['name'] != '') {
            if ($_FILES['area_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['area_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/area_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['area_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Area_Code', 'Area_Name');
                    $makeArray = array('Area_Code' => 'Area_Code', 'Area_Name' => 'Area_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->area_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Area_Code = $SheetDataKey['Area_Code'];
                                $Area_Name = $SheetDataKey['Area_Name'];
                                $Area_Code = filter_var(trim($allDataInSheet[$i][$Area_Code]), FILTER_SANITIZE_STRING);
                                $Area_Name = filter_var(trim($allDataInSheet[$i][$Area_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'area_name' => $Area_Name,
                                    'area_code' => $Area_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['area_info'] = $fetchData;
                            $this->base_model->setBatchImportArea($fetchData);
                            if ($this->base_model->importDataArea() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of area info uploaded Successfully.');
                                redirect('admin/masters/area_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/area_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/area_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function area_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_area_list = $this->base_model->get_area_list();
        $array = json_decode(json_encode($get_area_list), true);
        $column_area_code = array_column($array, 'area_code');

        $duplicate = array_search($dataInSheet['A'], $column_area_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Area Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Area Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Area Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }
    /*Kiran */
    /*bulk upload*/
    public function dpst_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['dpst_master_file']['name'] != '') {
            if ($_FILES['dpst_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['dpst_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/dpst_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['dpst_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('DPST_Code', 'DPST_Name');
                    $makeArray = array('DPST_Code' => 'DPST_Code', 'DPST_Name' => 'DPST_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->dpst_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $DPST_Code = $SheetDataKey['DPST_Code'];
                                $DPST_Name = $SheetDataKey['DPST_Name'];
                                $DPST_Code = filter_var(trim($allDataInSheet[$i][$DPST_Code]), FILTER_SANITIZE_STRING);
                                $DPST_Name = filter_var(trim($allDataInSheet[$i][$DPST_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'dpst_name' => $DPST_Name,
                                    'dpst_code' => $DPST_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['dpst_info'] = $fetchData;
                            $this->base_model->setBatchImportDPST($fetchData);
                            if ($this->base_model->importDataDPST() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of dpst info uploaded Successfully.');
                                redirect('admin/masters/dpst_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/dpst_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/dpst_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function dpst_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_dpst_list = $this->base_model->get_dpst_list();
        $array = json_decode(json_encode($get_dpst_list), true);
        $column_dpst_code = array_column($array, 'dpst_code');

        $duplicate = array_search($dataInSheet['A'], $column_dpst_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "DPST Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "DPST Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "DPST Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*bulk upload*/
    public function artype_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['artype_master_file']['name'] != '') {
            if ($_FILES['artype_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['artype_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/artype_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['artype_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('ARType_Code', 'ARType_Name');
                    $makeArray = array('ARType_Code' => 'ARType_Code', 'ARType_Name' => 'ARType_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->ar_type_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $ARType_Code = $SheetDataKey['ARType_Code'];
                                $ARType_Name = $SheetDataKey['ARType_Name'];
                                $ARType_Code = filter_var(trim($allDataInSheet[$i][$ARType_Code]), FILTER_SANITIZE_STRING);
                                $ARType_Name = filter_var(trim($allDataInSheet[$i][$ARType_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'ar_type_name' => $ARType_Name,
                                    'ar_type_code' => $ARType_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['ar_type_info'] = $fetchData;
                            $this->base_model->setBatchImportARType($fetchData);
                            if ($this->base_model->importDataARType() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of ar type info uploaded Successfully.');
                                redirect('admin/masters/artype_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/artype_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/artype_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function ar_type_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_artype_list = $this->base_model->get_artype_list();
        $array = json_decode(json_encode($get_artype_list), true);
        $column_ar_type_code = array_column($array, 'ar_type_code');

        $duplicate = array_search($dataInSheet['A'], $column_ar_type_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "AR Type Code already exists";
        }


        //die;

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "AR Type Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "AR Type Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*bulk upload*/
    public function transactiontype_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        if ($_FILES['transactiontype_master_file']['name'] != '') {
            if ($_FILES['transactiontype_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['transactiontype_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/transactiontype_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['transactiontype_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Transaction_Type_Code', 'Transaction_Type_Name');
                    $makeArray = array('Transaction_Type_Code' => 'Transaction_Type_Code', 'Transaction_Type_Name' => 'Transaction_Type_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $dataInSheet = $this->transactiontype_validation($dataInSheet);
                        if ($dataInSheet['C'] != '') {
                            $erroredRcords[++$j] = $dataInSheet;
                            //continue;
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }
                        //print_r($SheetDataKey);
                        //print_r(array_diff_key($makeArray, $SheetDataKey)); die;



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Transaction_Type_Code = $SheetDataKey['Transaction_Type_Code'];
                                $Transaction_Type_Name = $SheetDataKey['Transaction_Type_Name'];
                                $Transaction_Type_Code = filter_var(trim($allDataInSheet[$i][$Transaction_Type_Code]), FILTER_SANITIZE_STRING);
                                $Transaction_Type_Name = filter_var(trim($allDataInSheet[$i][$Transaction_Type_Name]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();


                                $fetchData[] = array(
                                    'transaction_type_name' => $Transaction_Type_Name,
                                    'transaction_type_code' => $Transaction_Type_Code,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $data['ar_type_info'] = $fetchData;
                            $this->base_model->setBatchImportTransactionType($fetchData);
                            if ($this->base_model->importDataTransactionType() == 1) {
                                $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of transaction type info uploaded Successfully.');
                                redirect('admin/masters/transactiontype_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {

                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('sbu-Error-List' . date("Y-m-d"));
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('C2:C' . count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('C1')->setValue('Remark');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " records with error out of " . $total_data_rows . ". Please download for reference and clear the error in the original file and upload again.";
                        $this->session->set_flashdata('unsucces', $msg);
                        redirect('admin/masters/transactiontype_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/transactiontype_bulk_upload_master', $this->data);
    }

    /*Kiran */
    function transactiontype_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $date = array();
        $record_status['error_msg'] = "";

        $get_transactiontype_list = $this->base_model->get_transactiontype_list();
        $array = json_decode(json_encode($get_transactiontype_list), true);
        $column_transaction_type_code = array_column($array, 'transaction_type_code');

        $duplicate = array_search($dataInSheet['A'], $column_transaction_type_code);

        //echo "<pre>";
        //print_r($duplicate);

        if ($duplicate != '') {
            $record_status['error'] = 1;
            $record_status['error_msg'] = "Transaction Type Code already exists";
        }

        if ($dataInSheet['A'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Transaction Type Code is missing";
        }


        if ($dataInSheet['B'] == NULL) {

            $record_status['error'] = 1;
            $record_status['error_msg'] = "Transaction Type Name is missing";
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['C'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Kiran */
    /*users*/
    public function users_list()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->data['user_list'] = $this->db->query("select * from users where id !='1' order by id desc")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/users_list');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/users/users_list', $this->data);
    }

    /*Kiran */
    public function users_list_create($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* Validate form input */
        $this->form_validation->set_rules('username', 'User Name', 'required');
        if ($param1 == "edit") {
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        } else {
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
        }
        $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'required|regex_match[/^[0-9]{10}$/]');
        $this->form_validation->set_rules('role_id', 'Role Name', 'required');
        $this->form_validation->set_rules('active', 'Status', 'required');
        $this->form_validation->set_rules('verical_id[]', 'Vertical Name', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[password]');

        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        if ($this->form_validation->run() == TRUE) {
            $inputdata['phone']                        = $this->input->post('mobile_number');
            $inputdata['role_id']                        = $this->input->post('role_id');
            $inputdata['active']                        = $this->input->post('active');
            $inputdata['vertical_id']                        = implode(",", $this->input->post('verical_id'));
            $inputdata['sys_created_on']                        = date('Y-m-d H:i:s');
            $group_id = 2;
            $password = $this->input->post('password');
            $email    = strtolower($this->input->post('email'));
            $username =  $this->input->post('username');

            // print_r( $this->input->post('verical_id'));
            // die;
            if ($this->input->post('id')) {
                $data = array(
                    'username' => $this->input->post('username'),
                    'vertical_id'    => implode(",", $this->input->post('verical_id')),
                    'email'    => $this->input->post('email'),
                    'phone'      => $this->input->post('mobile_number'),
                    'role_id'    => $this->input->post('role_id'),
                    'active'    => $this->input->post('active'),
                    'password' => $this->input->post('password')
                );
                if ($this->ion_auth->update($param2, $data)) {
                    $this->session->set_flashdata('success', 'User Updated Successfully.');
                    redirect('admin/masters/users_list', 'refresh');
                } else {
                    $this->session->set_flashdata('unsucces', 'Unable to update');
                    redirect('admin/masters/users_list');
                }
            }

            if ($this->ion_auth->register($username, $password, $email, $group_id, $inputdata)) {
                $this->session->set_flashdata('success', 'User Created Succesfully');
                redirect('admin/masters/users_list', 'refresh');
            } else {
                $this->session->set_flashdata('unsucces', 'Unable to Add');
                redirect('admin/masters/users_list');
            }
        }

        if ($param1 == "edit") {
            $users_list_create = $this->db->get_where('users', array('id' => $param2))->result();
            $this->data['users_list_create'] =  $users_list_create[0];
        }


        if ($param1 == "delete") {
            if ($this->db->delete('users', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'User Deleted Succesfully');
                redirect('admin/masters/users_list', 'refresh');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/users_list');
            }
        }

        $this->data['vertical_master'] = $this->db->query("select * from vertical_master")->result();
        $this->data['role_list'] = $this->db->query("select * from roles")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/users_list_create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/users/users_list_create', $this->data);
    }

    /*Kiran */
    public function role_name_save()
    {
        $role_name = trim($this->input->post('role_name'));
        $roles = $this->db->query("select * from roles where role_name='" . $role_name . "'")->row();

        if ($this->input->post('role_name') == '') {
            echo "2";
        } elseif (count($roles) > 0) {
            echo "1";
        } else {
            $inputdata['role_name'] =  $role_name;
            $inputdata['user_id'] = $this->ion_auth->get_user_id();
            $inputdata['sys_created_on'] = date('Y-m-d h i s');
            if ($this->db->insert("roles", $inputdata)) {
                echo "0";
            }
        }
    }

    /*Kiran */
    public function users_acess_control($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $data_access['role_access'] = implode(",", $this->input->post('access'));
            $this->db->where('role_id', $this->input->post('role_id'));
            $this->db->update('roles', $data_access);
            $this->session->set_flashdata('success', 'Updated Succesfully');
        }

        if ($param1 == "get_access") {
            $this->data['user_role_access'] = $this->db->query("select * from roles where role_id=" . $param2)->row();
        }


        $this->data['role_list'] = $this->db->query("select * from roles")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/users_acess_control');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/users/users_acess_control', $this->data);
    }

    /*Kiran */
    /*users*/
    public function create_users_bulk_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/create_users_bulk_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/users/create_users_bulk_upload', $this->data);
    }

    /*bulk upload*/
    public function users_list_bulk_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['users_list_file']['name'] != '') {
            if ($_FILES['users_list_file']['name']) {
                $f_type                             = explode(".", $_FILES['users_list_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['users_list_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;



                    $createArray = array('User_Name', 'Email_ID', 'Mobile_Number', 'Role_Name', 'Vertical_Name', 'Status', 'Password', 'Confirm_Password');
                    $makeArray = array('User_Name' => 'User_Name', 'Email_ID' => 'Email_ID', 'Mobile_Number' => 'Mobile_Number', 'Role_Name' => 'Role_Name', 'Vertical_Name' => 'Vertical_Name', 'Status' => 'Status', 'Password' => 'Password', 'Confirm_Password' => 'Confirm_Password');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            }
                        }

                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->user_list_validation($dataInSheet);
                            if ($dataInSheet['I'] != '') {
                                // echo '<pre>';
                                // print_r($dataInSheet);
                                // die;
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }

                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $User_Name = $SheetDataKey['User_Name'];
                                $Email_ID = $SheetDataKey['Email_ID'];
                                $Mobile_Number = $SheetDataKey['Mobile_Number'];
                                $Role_Name = $SheetDataKey['Role_Name'];
                                $Vertical_Name = $SheetDataKey['Vertical_Name'];
                                $Status = $SheetDataKey['Status'];
                                $Password = $SheetDataKey['Password'];
                                $User_Name = filter_var(trim($allDataInSheet[$i][$User_Name]), FILTER_SANITIZE_STRING);
                                $Email_ID = filter_var(trim($allDataInSheet[$i][$Email_ID]), FILTER_SANITIZE_STRING);
                                $Mobile_Number = filter_var(trim($allDataInSheet[$i][$Mobile_Number]), FILTER_SANITIZE_STRING);
                                $Role_Name = filter_var(trim($allDataInSheet[$i][$Role_Name]), FILTER_SANITIZE_STRING);
                                $Vertical_Name = filter_var(trim($allDataInSheet[$i][$Vertical_Name]), FILTER_SANITIZE_STRING);
                                $Status = filter_var(trim($allDataInSheet[$i][$Status]), FILTER_SANITIZE_STRING);
                                $Password = filter_var(trim($allDataInSheet[$i][$Password]), FILTER_SANITIZE_STRING);

                                $Vertical_Name = preg_replace('/\s*,\s*/', ',', $Vertical_Name);
                                $get_role_id = $this->db->query("select role_id from roles where role_name='" . $Role_Name . "'")->row();
                                $vertical_arrays = explode(',', $Vertical_Name);


                                $vertical_ids = array();
                                foreach ($vertical_arrays as $vers) {
                                    $verticals_names = $this->db->query("select id from vertical_master where vertical_name='" . $vers . "'")->row();
                                    $vertical_ids[] = $verticals_names->id;
                                }
                                $string_vetical_ids = implode(',', $vertical_ids);
                                $group_id = 2;

                                if ($Status == 'ACTIVE' || $Status == 'Active' || $Status == 'active') {
                                    $FStatus = 1;
                                }
                                if ($Status == 'INACTIVE' || $Status == 'Inactive' || $Status == 'inactive') {
                                    $FStatus = 0;
                                }

                                $fetchData[] = array(
                                    'user_name' => $User_Name,
                                    'email_id' => $Email_ID,
                                    'password' => $Password,
                                    'group_id' => $group_id,
                                    'phone' => $Mobile_Number,
                                    'role_id' => $get_role_id->role_id,
                                    'active' => $FStatus,
                                    'vertical_id' => $string_vetical_ids,
                                    'sys_created_on' => date('Y-m-d h:i:s')
                                );
                            }

                            if (count($fetchData) >= 1) {
                                foreach ($fetchData as $f) {
                                    $this->ion_auth->register($f['user_name'], $f['password'], $f['email_id'], $f['group_id'], $f);
                                }
                                $msg_success = "Users list info uploaded successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo "Excel is empty";
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('Vertical-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('I1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;

                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }


    function user_list_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";
        $record_status['error_msg2'] = "";
        $record_status['error_msg3'] = "";
        $record_status['error_msg4'] = "";
        $record_status['error_msg5'] = "";
        $record_status['error_msg6'] = "";


        if ($dataInSheet['A'] != "User_Name" || $dataInSheet['B'] != "Email_ID" || $dataInSheet['C'] != "Mobile_Number" || $dataInSheet['D'] != "Role_Name" || $dataInSheet['E'] != "Vertical_Name" || $dataInSheet['F'] != "Status" || $dataInSheet['G'] != "Password" || $dataInSheet['H'] != "Confirm_Password") {
            if ($dataInSheet['A'] == NULL || $dataInSheet['B'] == NULL || $dataInSheet['C'] == NULL || $dataInSheet['D'] == NULL || $dataInSheet['E'] == NULL || $dataInSheet['F'] == NULL || $dataInSheet['G'] == NULL || $dataInSheet['H'] == NULL) {
               // echo '1';
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['B']) {
                    /* email validations */;
                if (!(filter_var(trim($dataInSheet['B']), FILTER_VALIDATE_EMAIL))) {
                   // echo '2';
                    $record_status['error'] = 1;
                    $record_status['error_msg1'] = "Enter Valid Email address";
                    if ($record_status['error_msg1'] != '') {
                        $_email = '|';
                    }
                }

                $email_exits__or_not = $this->db->query("select u.*from users as u where u.email='" . (filter_var(trim($dataInSheet['B']), FILTER_VALIDATE_EMAIL)) . "'")->result();
                if (count($email_exits__or_not) >= 1) {
                   // echo '3';
                    $record_status['error'] = 1;
                    $record_status['error_msg2'] = "Email address already exits";
                    if ($record_status['error_msg2'] != '') {
                        $_email1 = '|';
                    }
                }
            }

            if ($dataInSheet['D']) {
                /* role Id validations */
                $role = filter_var(trim($dataInSheet['D']), FILTER_SANITIZE_STRING);
                $role_exits__or_not = $this->db->query("select r.*from roles as r where r.role_name='" .  $role . "'")->result();
                if (count($role_exits__or_not) == 0) {
                   // echo  $role;
                    $record_status['error'] = 1;
                    $record_status['error_msg3'] = "Role name does not exits";
                    if ($record_status['error_msg3'] != '') {
                        $_role = '|';
                    }
                }
            }

            if ($dataInSheet['E']) {
                /* Vertical validations */
                $vertical_arrays = explode(',', preg_replace('/\s*,\s*/', ',', filter_var(strtolower(trim($dataInSheet['E'])), FILTER_SANITIZE_STRING)));
                $vertical_data_db = $this->db->query("select LOWER(vertical_name) from vertical_master")->result();
                $arr = array_column(json_decode(json_encode($vertical_data_db), true), 'LOWER(vertical_name)');
                $bFound = 0;

                foreach ($arr as $array) {
                    if (in_array($array, $vertical_arrays)) {
                        $bFound++;
                    }
                }

                if ($bFound != count($vertical_arrays)) {
                    $result = array_diff($vertical_arrays, $arr);
                    $string_version = implode(',', $result);
                    $record_status['error'] = 1;
                    $record_status['error_msg4'] = "Vertical Name [{$string_version}] does not exits";
                    if ($record_status['error_msg4'] != '') {
                        $_verti = '|';
                    }
                }
            }

            if (!((filter_var(trim($dataInSheet['G']), FILTER_VALIDATE_EMAIL)) == (filter_var(trim($dataInSheet['H']), FILTER_VALIDATE_EMAIL)))) {
                $record_status['error'] = 1;
                $record_status['error_msg5'] = "Passwords did not match";
                if ($record_status['error_msg5'] != '') {
                    $_pass = '|';
                }
            }

            if (!(strtolower(trim($dataInSheet['F'])) == 'active' || strtolower(trim($dataInSheet['F'])) == 'inactive')) {
                $record_status['error'] = 1;
                $record_status['error_msg6'] = "Invalid status, allowed[active/inactive]";
                if ($record_status['error_msg6'] != '') {
                    $_sta = '|';
                }
            }
        }


        if ($record_status['error'] == 1) {
            $dataInSheet['I'] = $record_status['error_msg'] .  $_email . $record_status['error_msg1'] . $_email1 . $record_status['error_msg2'] .  $_role . $record_status['error_msg3'] . $_verti . $record_status['error_msg4'] . $_pass . $record_status['error_msg5'] . $_sta . $record_status['error_msg6'];
        }
        return $dataInSheet;
    }


    public function role_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('role_name', 'Role Name', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "roles";
                $inputdata['role_name']                        = $this->input->post('role_name');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('role_id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Role Updated Succesfully');
                        redirect('admin/masters/role_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/role_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Role Added Succesfully');
                    redirect('admin/masters/role_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/role_master');
                }
            }
        }

        if ($param1 == "edit") {
            $role_master_details = $this->db->get_where('roles', array('role_id' => $param2))->result();
            $this->data['role_master_details'] =  $role_master_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('roles', array('role_id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Role Deleted Succesfully');
                redirect('admin/masters/role_master');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/masters/role_master');
            }
        }
        $this->data['role_master'] = $this->db->query("select * from roles")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/role_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/role_master', $this->data);
    }

    /*Kiran */
    public function role_validation()
    {
        $role_name = trim($this->input->post('role_name'));
        $role_master = $this->db->query("select * from roles where role_name='" . $role_name . "'")->row();

        if (count($role_master) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function vertical_master_mapping_val()
    {
        $vertical_id = trim($this->input->post('vertical_id'));
        $dpst_ver_map = $this->db->query("select * from dpst_vertical_mapping where vertical_id='" . $vertical_id . "'")->row();
        $tran_ver_map = $this->db->query("select * from vertical_entity_mapping where vertical_id='" . $vertical_id . "'")->row();
        $ver_ent_map = $this->db->query("select * from transaction_type_mapping where vertical_id='" . $vertical_id . "'")->row();

        if (count($dpst_ver_map) > 0 || count($tran_ver_map) > 0 || count($ver_ent_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function cluster_master_mapping_val()
    {
        $cluster_id = trim($this->input->post('cluster_id'));
        $tran_ver_map = $this->db->query("select * from vertical_entity_mapping where cluster_id='" . $cluster_id . "'")->row();

        if (count($tran_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function sbu_master_mapping_val()
    {
        $sbu_id = trim($this->input->post('sbu_id'));
        $tran_ver_map = $this->db->query("select * from vertical_entity_mapping where sbu_id='" . $sbu_id . "'")->row();

        if (count($tran_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function country_master_mapping_val()
    {
        $country_id = trim($this->input->post('country_id'));
        $tran_ver_map = $this->db->query("select * from area_country_mapping where country_id='" . $country_id . "'")->row();

        if (count($tran_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function currency_master_mapping_val()
    {
        $local_fx_id = trim($this->input->post('local_fx_id'));
        $tran_ver_map = $this->db->query("select * from vertical_entity_mapping where local_fx_id='" . $local_fx_id . "' or reporting_fx_id='" . $local_fx_id . "'")->row();

        if (count($tran_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function area_master_mapping_val()
    {
        $area_id = trim($this->input->post('area_id'));
        $tran_ver_map = $this->db->query("select * from area_country_mapping where area_name_id='" . $area_id . "'")->row();

        if (count($tran_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /*Kiran */
    public function dpst_master_mapping_val()
    {
        $dpst_id = trim($this->input->post('dpst_id'));
        $dpst_ver_map = $this->db->query("select * from dpst_vertical_mapping where dpst_id='" . $dpst_id . "'")->row();

        if (count($dpst_ver_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /*Kiran */
    public function ar_type_master_mapping_val()
    {
        $ar_type_id = trim($this->input->post('ar_type_id'));
        $dpst_ver_map = $this->db->query("select * from dpst_vertical_mapping where ar_type_id='" . $ar_type_id . "'")->row();
        $ver_ent_map = $this->db->query("select * from transaction_type_mapping where ar_type_id='" . $ar_type_id . "'")->row();
        if (count($dpst_ver_map) > 0 || count($ver_ent_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Kiran */
    public function tran_master_mapping_val()
    {
        $tran_id = trim($this->input->post('tran_id'));
        $ver_ent_map = $this->db->query("select * from transaction_type_mapping where transaction_type_id='" . $tran_id . "'")->row();
        if (count($ver_ent_map) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /*Kiran */
    /*bulk upload*/
    public function region_dummy_bulk_upload_master()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($_FILES['dummyregion_master_file']['name'] != '') {

            if ($_FILES['dummyregion_master_file']['name']) {
                $f_type                           = explode(".", $_FILES['dummyregion_master_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    redirect('admin/masters/region_dummy_bulk_upload_master', 'refresh');
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

                    $file                                     = $_FILES['dummyregion_master_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    //echo '<hr />';
                    $allDataInSheet                                 = $objPHPExcel->getActiveSheet()->toArray(
                        null,
                        true,
                        true,
                        true
                    );
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();
                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Region_Code', 'Region_Name');
                    $makeArray = array('Region_Code' => 'Region_Code', 'Region_Name' => 'Region_Name');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        // $dataInSheet = $this->area_validation($dataInSheet);
                        // if ($dataInSheet['C'] != '') {
                        //     $erroredRcords[++$j] = $dataInSheet;
                        //     //continue;
                        // }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }



                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Region_Code = $SheetDataKey['Region_Code'];
                                $Region_Name = $SheetDataKey['Region_Name'];
                                $Code = filter_var(trim($allDataInSheet[$i][$Region_Code]), FILTER_SANITIZE_STRING);
                                $Name = filter_var(trim($allDataInSheet[$i][$Region_Name]), FILTER_SANITIZE_STRING);

                                $fetchData[] = array(
                                    'name' => $Name,
                                    'code' => $Code,
                                );
                            }
                        }


                        for ($i = 0; $i < count($fetchData); $i++) {
                            $month_ar_list = $this->db->query("select * from month_end_ar_process_data_final where area ='" . $fetchData[$i]['code'] . "'")->row();
                            if (count($month_ar_list) >= 1) {
                                $data = array(
                                    'region' => $fetchData[$i]['name'],
                                );
                                $this->db->where('area', $fetchData[$i]['code']);
                                $this->db->update('month_end_ar_process_data_final', $data);
                                // echo '<pre>';
                                // print_r($this->db->last_query());
                                // die;
                            }
                        }
                    }
                }
            }
        }

        $this->template->admin_render('admin/masters/region_dummy_bulk_upload_master', $this->data);
    }


    //------------ Auto Lock user input ----------//

    public function auto_lock_master($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('auto_lock_day', 'Auto Lock Day', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "auto_lock_setting";
                $inputdata['auto_lock_day']                  = $this->input->post('auto_lock_day');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                 = date("Y-m-d h:i:s");

                if ($this->input->post('auto_lock_id')) {
                    $this->db->where('auto_lock_id', $this->input->post('auto_lock_id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'Auto Lock Updated Succesfully');
                        redirect('admin/masters/auto_lock_master', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/masters/auto_lock_master');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'Auto Lock Added Succesfully');
                    redirect('admin/masters/auto_lock_master', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/masters/auto_lock_master');
                }
            }
            
        }


        $this->data['auto_lock_master'] = $this->db->query("select * from auto_lock_setting")->row();
       
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/masters/auto_lock_master');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/masters/auto_lock_master', $this->data);
    }


}
