<?php
defined('BASEPATH') or exit('No direct script access allowed');
ini_set('memory_limit', '-1');

require_once APPPATH . '/third_party/spout/src/Spout/Autoloader/autoload.php';

require_once('vendor/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

//lets Use the Spout Namespaces
use Box\Spout\Reader\Common\Creator\ReaderEntityFactory;
use Box\Spout\Common\Type;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
use Box\Spout\Common\Entity\Style\CellAlignment;
use Box\Spout\Common\Entity\Style\Color;

class Reports extends Admin_Controller
{

	public function __construct()
	{
		parent::__construct();

		$this->load->helper('security');

		$this->load->model('Base_model');

		$this->load->model('ajax_model');

		$this->load->library('form_validation');

		$this->load->helper('url');

		$this->load->library("pagination");

		$this->load->library('excel');

		$this->load->model('Ajax_model');
	}


	public function index()
	{
		if (!$this->ion_auth->logged_in() or !$this->ion_auth->is_admin() or !$this->ion_auth->is_user()) {
			redirect('auth/login', 'refresh');
		} else {

			/* Get all users */
			$this->data['users'] = $this->ion_auth->users()->result();
			foreach ($this->data['users'] as $k => $user) {
				$this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
			}

			/* Load Template */
			$this->template->admin_render('admin/masters/index', $this->data);
		}
	}



	public function create_excel($store_id)
	{

		//include (FCPATH . '/assets/excelassets/PHPExcel/PHPExcel.php');
		//echo  APPPATH;die;

		$this->load->library('Excel');
		ob_start();

		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);
		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);

		$objPHPExcel->getProperties()->setCreator("Stock Report")
			->setLastModifiedBy("Stock Report")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', 'Date: ' . date('F-Y', strtotime($yymm)));


		$stock 				= $this->base_model->run_query(
			"select book.* from  stock_report as book where store_id=" . $store_id
		);

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('C4', 'Brand Code');
		foreach ($stock as $s) {


			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('C3', $s->barcode);
		}

		$objPHPExcel->getActiveSheet()->setTitle('Stock Report');
		$objPHPExcel->setActiveSheetIndex(0);
		ob_end_clean();
		$filename = date('M-Y', strtotime($yymm)) . '  ' . 'Employee Attendance.xls';
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}


	function top_negetive_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		$this->data['stock'] 				= $this->base_model->run_query(
			"select * from stock_report"
		);


		$this->template->admin_render('admin/reports/top_negetive_report', $this->data);
	}


	function top_positive_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		$this->data['stock'] 				= $this->base_model->run_query(
			"select * from stock_report  "
		);


		$this->template->admin_render('admin/reports/top_positive_report', $this->data);
	}


	/* 	function top_neg_pos_report()
	{
		
		 if ( ! $this->ion_auth->logged_in() ){
			redirect('auth/login', 'refresh');
		}
		
		 $keyword='';
		 if($this->input->post('keyword')!=''){			 
			 $this->session->set_userdata("keyword",$this->input->post('keyword'));			 
			 $keyword=" where store_id = ".$this->input->post('keyword'); 
		 }elseif($this->input->post('keyword')== ''){
		// $this->session->unset_userdata("keyword");
			//	$keyword='';
		 }
		 
		  $inv_date='';
		 if($this->input->post('inventory_date')!=''){			 
			 $this->session->set_userdata("inventory_date",$this->input->post('inventory_date'));
			$inv_date=" AND book.Inventory_Date = '".$this->input->post('inventory_date') ."'"; 
		 }elseif($this->input->post('inventory_date')== ''){
		// $this->session->unset_userdata("keyword");
				//$keyword='';
		 }
		 
		  if($this->input->post('keyword')!=''){	
		 //print_r($this->input->post('keyword'));die;
		 
		 $stock			= $this->base_model->run_query(
		"select book.* from stock_report as book 
		".$keyword);
		
		 $physical			= $this->base_model->run_query(
		"select phy.* from physical_stock as phy 
		".$keyword);
			
		
		$inputdata_top_stock = array();
		$inputdata_top_phy = array();
		
		foreach ($physical as $p){
			
			$inputdata_top_phy[] = array(
			  'barcode'=>$p->barcode,
			  'store_id'=>$this->input->post('keyword'),
			  
        'physicalstock_qty'=>$p->physicalstock_qty,
       
        
    );  
			
		}
		
//echo "<pre>";


		//die;
		
		$barcodes = array_column($inputdata_top_phy, 'barcode');
		$phy=0;
	 	foreach ($stock as $s){
			
			
			
$array_num = array_keys($barcodes, $s->barcode);

if(!empty($array_num)){
	
	//echo "raghu";die;
	//print_r($array_num);
$final_val = $inputdata_top_phy[$array_num[0]];
$phy=$final_val[physicalstock_qty];
}else{
	$phy=0;
}

		//print_r($phy);die;
			
			 $physicalstock_qty_var=$phy;
			if($physicalstock_qty_var==''){
				$physicalstock_qty_var=0;
			}
			
			//print_r($this->input->post('keyword'));die;
			
			 $inputdata_top_stock[] = array(
			  'barcode'=>$s->barcode,
			  'store_id'=> $this->session->userdata("keyword"),
			  
        'physicalstock_qty'=>$physicalstock_qty_var,
        'physicalstock_value' => $s->cost * $physicalstock_qty_var,
        'qty_descrepancy' => $s->bookstock_qty - $physicalstock_qty_var,
        'value_descrepancy' =>($s->cost * $s->bookstock_qty) - ($s->cost *$physicalstock_qty_var)
        
    );  
	
	
						
						
						 //print_r($this->db->last_query());die;
			
		}
		
	 	$where2 = $this->input->post('keyword');  
	$this->db->where('store_id', $where2);
	$this->db->update_batch('stock_report',$inputdata_top_stock, 'barcode');  
		 
	
		
		
		$this->data['stock'] 				= $this->base_model->run_query(
		"select * from stock_report ".$keyword ." ORDER BY  value_descrepancy DESC LIMIT 10 ");
		
		
		$this->data['stocks'] 				= $this->base_model->run_query(
		"select * from stock_report ".$keyword ." ORDER BY CAST( value_descrepancy AS DECIMAL ) ASC    LIMIT 10 ");
		
		  }
	
		
		
		if($this->ion_auth->is_client()){
			
				//echo "raghu";die;
			$this->template->client_render('admin/reports/top_neg_pos_report', $this->data);
		}else{
			
			
			
		$this->template->admin_render('admin/reports/top_neg_pos_report', $this->data);
		}
		
		
	} */


	function barcode_wise_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if ($this->input->post()) {

			$keyword = '';
			if ($this->input->post('keyword') != '') {
				$this->session->set_userdata("keyword", $this->input->post('keyword'));
				$keyword = " where store_id = " . $this->input->post('keyword');
			} elseif ($this->input->post('keyword') == '') {
				$this->session->unset_userdata("keyword");
				$keyword = '';
			}


			$barcode = '';
			if ($this->input->post('barcode') != '') {
				$this->session->set_userdata("barcode", $this->input->post('barcode'));
				if ($this->input->post('keyword') == '') {
					$barcode = " where barcode = '" . $this->input->post('barcode') . "'";
				} else {
					$barcode = " and barcode = '" . $this->input->post('barcode') . "'";
				}
			} elseif ($this->input->post('barcode') == '') {
				$this->session->unset_userdata("barcode");
				$barcode = '';
			}



			$this->data['stock'] 				= $this->base_model->run_query(
				"select * from stock_report  " . $keyword . "" . $barcode
			);

			// print_r($this->db->last_query());die;

		}


		if ($this->ion_auth->is_client()) {

			$this->template->client_render('admin/reports/barcode_wise_report', $this->data);
		} else {

			$this->template->admin_render('admin/reports/barcode_wise_report', $this->data);
		}
	}


	function team_utilization_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '' || $this->session->userdata('month_year') != '') {



			if ($this->input->post("month_year") != '') {
				$this->session->set_userdata('month_year', $this->input->post("month_year"));
				$this->data['month_year'] = $this->input->post("month_year");
			} elseif ($this->session->userdata('month_year') != '') {
				$this->session->set_userdata('month_year', $this->session->userdata('month_year'));
				$this->data['month_year'] = $this->session->userdata("month_year");
			}

			// $this->data['users_list'] = $this->db->query("Select * from users where  ( role_id='1' OR role_id='2' OR role_id='12' ) ")->result();


			$per_page = 10;

			$qry = "Select * from users where  ( role_id='1' OR role_id='2' OR role_id='12' ) ";

			$offset = ($this->uri->segment(4) != '' ? $this->uri->segment(4) : 0);


			$config['total_rows'] = $this->db->query($qry)->num_rows();



			$config['per_page'] = $per_page;
			$config['uri_segment'] = 4;


			$config['base_url'] = site_url() . '/admin/reports/team_utilization_report/';


			$config['full_tag_open'] = "<ul class='pagination'>";
			$config['full_tag_close'] = '</ul>';
			$config['num_tag_open'] = '<li class="paginate-dark list">';
			$config['num_tag_close'] = '</li>';
			$config['cur_tag_open'] = '<li class="paginate-dark active list" ><a href="#" class="cdp_i">';
			$config['cur_tag_close'] = '</a></li>';
			$config['prev_tag_open'] = '<li class="paginate-dark list">';
			$config['prev_tag_close'] = '</li>';
			$config['first_tag_open'] = '<li class="paginate-dark list">';
			$config['first_tag_close'] = '</li>';
			$config['last_tag_open'] = '<li class="paginate-dark list">';
			$config['last_tag_close'] = '</li>';



			$config['prev_link'] = '<i class="fa fa-long-arrow-left"></i>';
			$config['prev_tag_open'] = '<li class="paginate-dark list">';
			$config['prev_tag_close'] = '</li>';


			$config['next_link'] = '<i class="fa fa-long-arrow-right"></i>';
			$config['next_tag_open'] = '<li class="paginate-dark list">';
			$config['next_tag_close'] = '</li>';
			$config['num_links'] = 3;

			$total = $config["total_rows"];


			$this->pagination->initialize($config);

			$this->data['pagination_links'] = $this->pagination->create_links();


			$this->data['offset'] = $offset;

			$qry .= " limit " . $per_page . " offset " . $offset;

			// print_r($this->db->last_query());die;

			if ($this->data['pagination_links'] != '') {
				$this->data['pagermessage'] = 'Showing ' . ((($this->pagination->cur_page - 1) * $this->pagination->per_page) + 1) . ' to ' . ($this->pagination->cur_page * $this->pagination->per_page) . ' results, of ' . $total;
			}



			$this->data['users_list'] = $this->db->query($qry)->result();
		}



		if ($this->ion_auth->is_client()) {

			$this->template->client_render('admin/reports/team_utilization_report', $this->data);
		} else {

			$this->template->admin_render('admin/reports/team_utilization_report', $this->data);
		}
	}


	function audit_details_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		//if($this->input->post()){

		$keyword = '';
		if ($this->input->post('keyword') != '') {
			$this->session->set_userdata("keyword", $this->input->post('keyword'));
			$keyword = " where book.store_id = " . $this->input->post('keyword');
		} elseif ($this->input->post('keyword') == '') {
			// $this->session->unset_userdata("keyword");
			//$keyword='';
		}

		$stock1			= $this->base_model->run_query(
			"select book.* from stock_report as book 
		
		
		
		
		" . $keyword
		);

		$config = array();
		$config["base_url"] = base_url() . "admin/reports/stock_report/";
		$config["total_rows"] = count($stock1);
		$config["per_page"] = 20;
		$config["uri_segment"] = 4;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] = '</ul>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="active"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['prev_tag_open'] = '<li>';
		$config['prev_tag_close'] = '</li>';
		$config['first_tag_open'] = '<li>';
		$config['first_tag_close'] = '</li>';
		$config['last_tag_open'] = '<li>';
		$config['last_tag_close'] = '</li>';



		$config['prev_link'] = '<i class="fa fa-long-arrow-left"></i>';
		$config['prev_tag_open'] = '<li>';
		$config['prev_tag_close'] = '</li>';


		$config['next_link'] = '<i class="fa fa-long-arrow-right"></i>';
		$config['next_tag_open'] = '<li>';
		$config['next_tag_close'] = '</li>';

		$start = (int)$this->uri->segment(4) * $config['per_page'] + 1;
		$end = ($this->uri->segment(4) == floor($config['total_rows'] / $config['per_page'])) ? $config['total_rows'] : (int)$this->uri->segment(4) * $config['per_page'] + $config['per_page'];

		$this->data['result_count'] = "Showing " . $start . " - " . $end . " of " . $config['total_rows'] . " Results";

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$this->data["links"] = $this->pagination->create_links();
		//$data['authors'] = $this->base_model->get_stock_report($config["per_page"], $page);

		$this->data['stock'] 				= $this->base_model->run_query(
			"select book.* from  stock_report as book 
		
		
		
		
		" . $keyword . " LIMIT " . $page . " , " . $config["per_page"]
		);




		//echo $this->data["links"];die;

		//print_r( $this->db->last_query() );die; 


		//}

		if ($this->ion_auth->is_client()) {

			$this->template->client_render('admin/reports/audit_details_report', $this->data);
		} else {

			$this->template->admin_render('admin/reports/audit_details_report', $this->data);
		}
	}


	function team_members_mgmt_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		// print_r("Avi");

		if ($this->input->post("month_year") != '' || $this->session->userdata('month_year') != '') {



			if ($this->input->post("month_year") != '') {
				$this->session->set_userdata('month_year', $this->input->post("month_year"));
				$this->data['month_year'] = $this->input->post("month_year");
			} elseif ($this->session->userdata('month_year') != '') {
				$this->session->set_userdata('month_year', $this->session->userdata('month_year'));
				$this->data['month_year'] = $this->session->userdata("month_year");
			}

			// $this->data['users_list'] = $this->db->query("Select * from users where  ( role_id='1' OR role_id='2' OR role_id='12' ) ")->result();


			$per_page = 10;

			$qry = "Select * from users where  ( role_id='1' OR role_id='2' OR role_id='12' ) ";

			$offset = ($this->uri->segment(4) != '' ? $this->uri->segment(4) : 0);


			$config['total_rows'] = $this->db->query($qry)->num_rows();



			$config['per_page'] = $per_page;
			$config['uri_segment'] = 4;


			$config['base_url'] = site_url() . '/admin/reports/team_members_mgmt_report/';


			$config['full_tag_open'] = "<ul class='pagination'>";
			$config['full_tag_close'] = '</ul>';
			$config['num_tag_open'] = '<li class="paginate-dark list">';
			$config['num_tag_close'] = '</li>';
			$config['cur_tag_open'] = '<li class="paginate-dark active list" ><a href="#" class="cdp_i">';
			$config['cur_tag_close'] = '</a></li>';
			$config['prev_tag_open'] = '<li class="paginate-dark list">';
			$config['prev_tag_close'] = '</li>';
			$config['first_tag_open'] = '<li class="paginate-dark list">';
			$config['first_tag_close'] = '</li>';
			$config['last_tag_open'] = '<li class="paginate-dark list">';
			$config['last_tag_close'] = '</li>';



			$config['prev_link'] = '<i class="fa fa-long-arrow-left"></i>';
			$config['prev_tag_open'] = '<li class="paginate-dark list">';
			$config['prev_tag_close'] = '</li>';


			$config['next_link'] = '<i class="fa fa-long-arrow-right"></i>';
			$config['next_tag_open'] = '<li class="paginate-dark list">';
			$config['next_tag_close'] = '</li>';
			$config['num_links'] = 3;

			$total = $config["total_rows"];


			$this->pagination->initialize($config);

			$this->data['pagination_links'] = $this->pagination->create_links();


			$this->data['offset'] = $offset;

			$qry .= " limit " . $per_page . " offset " . $offset;

			// print_r($this->db->last_query());die;

			if ($this->data['pagination_links'] != '') {
				$this->data['pagermessage'] = 'Showing ' . ((($this->pagination->cur_page - 1) * $this->pagination->per_page) + 1) . ' to ' . ($this->pagination->cur_page * $this->pagination->per_page) . ' results, of ' . $total;
			}



			$this->data['users_list'] = $this->db->query($qry)->result();
		}



		if ($this->ion_auth->is_client()) {

			$this->template->client_render('admin/reports/team_members_mgmt_report', $this->data);
		} else {

			$this->template->admin_render('admin/reports/team_members_mgmt_report', $this->data);
		}
	}


	function update_attendance()
	{
		if ($_POST) {
			$emp_id = $this->input->post('emp_id');
			$status = $this->input->post('status');
			$emp_date = $this->input->post('emp_date');

			$attendance = array(
				'attendance_status' => $this->input->post('status'),
				'date' => $this->input->post('emp_date'),
				'employee_id' => $this->input->post('emp_id')
			);

			$check_result = $this->db->query("select * from attendance where employee_id=" . $emp_id . " and date='" . $emp_date . " '")->result();

			if (count($check_result) == 0) {
				$this->db->insert('attendance', $attendance);
			} else {
				$attendance_update = array(
					'attendance_status' => $this->input->post('status'),
				);
				$this->db->where('employee_id', $emp_id);
				$this->db->where('date', $emp_date);
				$this->db->update('attendance', $attendance_update);
			}


			echo json_encode("Success");
		}
	}



	// summaryReport Detailed Download

	public function team_utilization_excel_report()
	{
		$customer_list = array();
		$invoice_list = array();

		$today_date = date('Y-m-d');


		if ($this->session->userdata('month_year') != '') {

			$this->session->userdata('month_year');

			$users_list = $this->db->query("Select * from users where  ( role_id='1' OR role_id='2' OR role_id='12' ) ")->result();
		}

		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);
		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'E7E7E7'),
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '66bfff'),
			)
		);

		$bgcolordarkblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '34a5f5'),
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ff0000'),
			)
		);



		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");


		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', 'Team utilization Report - Generated On ' . date('F d, Y') . ' - ' . date('M-Y', strtotime($this->session->userdata("month_year"))));




		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getRowDimension('3')->setRowHeight(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);

		$objPHPExcel->getActiveSheet(0)->getStyle('A3:E3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


		$objPHPExcel->getActiveSheet()
			->getStyle('A')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('B')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('C')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('D')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('E')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);



		$objPHPExcel->getActiveSheet()->getStyle('A2:E2')->applyFromArray($bgcolor);
		$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray($bgcolor);
		$objPHPExcel->getActiveSheet()->getStyle('A4:E4')->applyFromArray($bgcolor);
		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		// Add some data



		// Add some data

		$objPHPExcel->getActiveSheet()->getStyle('A3:E3')->applyFromArray($bgcolorblue);
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A3:E3');



		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('B1:F1');
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('B2:F2');

		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A3:E3');

		$objPHPExcel->getActiveSheet(0)->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objPHPExcel->getActiveSheet()->setCellValue('A3', 'Manpower Details');


		$month_year = $this->session->userdata('month_year');

		if ($month_year != '') {


			$month = date('n', strtotime($month_year));
			$year = date('Y', strtotime($month_year));
			$num = cal_days_in_month(CAL_GREGORIAN, $month, $year);


			$d = 'F';
			for ($j = 1; $j <= $num; $j++) {

				$objPHPExcel->getActiveSheet()->getStyle($d . '3')->applyFromArray($dateArray);
				$objPHPExcel->getActiveSheet()->getStyle($d . '3')->applyFromArray($bgcolorblue);

				$objPHPExcel->getActiveSheet(0)->getStyle($d . '3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$objPHPExcel->getActiveSheet(0)->getStyle($d . '4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$mo = date('M', strtotime($month_year));

				$ee = $j . "-" . $month . "-" . $year;
				$t = date($ee);

				$objPHPExcel->getActiveSheet()->setCellValue($d . '3', $j . "-" . $mo);
				$objPHPExcel->getActiveSheet()->setCellValue($d . '4',  date("D", strtotime($t)));

				$objPHPExcel->getActiveSheet()->getColumnDimension($d)->setWidth(20);

				$objPHPExcel->getActiveSheet()->getStyle($d . '4')->applyFromArray($bgcolordarkblue);


				$d++;
			}
		}

		for ($i = 1; $i <= 10; $i++) {

			$month_year = $this->session->userdata('month_year');

			if ($month_year != '') {

				$objPHPExcel->getActiveSheet()->getStyle($d . '4')->applyFromArray($bgcolordarkblue);
				$objPHPExcel->getActiveSheet()->getColumnDimension($d)->setWidth(25);
				$objPHPExcel->getActiveSheet(0)->getStyle($d . '4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				if ($i == 1) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Days in Office');
				}

				if ($i == 2) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Week From Home');
				}

				if ($i == 3) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Holidays/Week Off');
				}

				if ($i == 4) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Comp off');
				}

				if ($i == 5) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Absent');
				}

				if ($i == 6) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Idle');
				}

				if ($i == 7) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', '# of Leave');
				}

				if ($i == 8) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', 'Monthly Utilization');
				}

				if ($i == 9) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', 'No of days occupied');
				}

				if ($i == 10) {
					$objPHPExcel->getActiveSheet()->setCellValue($d . '4', 'No of days available for audits');
				}




				$month = date('n', strtotime($month_year));
				$year = date('Y', strtotime($month_year));
				$num = cal_days_in_month(CAL_GREGORIAN, $month, $year);


				if ($num == 31) {
					$objPHPExcel->setActiveSheetIndex(0)->mergeCells($d . '3' . ":" . 'AT3');
					$objPHPExcel->getActiveSheet()->setCellValue('AK3',  "Analysis");
					$objPHPExcel->getActiveSheet()->getStyle($d . '3' . ":" . 'AT3')->applyFromArray($bgcolorblue);
					$objPHPExcel->getActiveSheet(0)->getStyle($d . '3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$objPHPExcel->getActiveSheet()->getStyle('A2:AT2')->applyFromArray($bgcolor);
					$objPHPExcel->getActiveSheet()->getStyle('A1:AT1')->applyFromArray($bgcolor);
				}

				if ($num == 30) {
					$objPHPExcel->setActiveSheetIndex(0)->mergeCells($d . '3' . ":" . 'AS3');
					$objPHPExcel->getActiveSheet()->setCellValue('AJ3',  "Analysis");
					$objPHPExcel->getActiveSheet()->getStyle($d . '3' . ":" . 'AS3')->applyFromArray($bgcolorblue);
					$objPHPExcel->getActiveSheet(0)->getStyle($d . '3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$objPHPExcel->getActiveSheet()->getStyle('A2:AS2')->applyFromArray($bgcolor);
					$objPHPExcel->getActiveSheet()->getStyle('A1:AS1')->applyFromArray($bgcolor);
				}

				if ($num == 29) {
					$objPHPExcel->setActiveSheetIndex(0)->mergeCells($d . '3' . ":" . 'AR3');
					$objPHPExcel->getActiveSheet()->setCellValue('AI3',  "Analysis");
					$objPHPExcel->getActiveSheet()->getStyle($d . '3' . ":" . 'AR3')->applyFromArray($bgcolorblue);
					$objPHPExcel->getActiveSheet(0)->getStyle($d . '3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$objPHPExcel->getActiveSheet()->getStyle('A2:AR2')->applyFromArray($bgcolor);
					$objPHPExcel->getActiveSheet()->getStyle('A1:AR1')->applyFromArray($bgcolor);
				}

				if ($num == 28) {
					$objPHPExcel->setActiveSheetIndex(0)->mergeCells($d . '3' . ":" . 'AQ3');
					$objPHPExcel->getActiveSheet()->setCellValue('AH3',  "Analysis");
					$objPHPExcel->getActiveSheet()->getStyle($d . '3' . ":" . 'AQ3')->applyFromArray($bgcolorblue);
					$objPHPExcel->getActiveSheet(0)->getStyle($d . '3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$objPHPExcel->getActiveSheet()->getStyle('A2:AQ2')->applyFromArray($bgcolor);
					$objPHPExcel->getActiveSheet()->getStyle('A1:AQ1')->applyFromArray($bgcolor);
				}

				$d++;
			}
		}





		$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Sl No.');
		$objPHPExcel->getActiveSheet()->setCellValue('B4', 'Employee Name');
		$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Location');
		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Designation');
		$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Region');

		$objPHPExcel->getActiveSheet()->getStyle('A4:E4')->applyFromArray($bgcolordarkblue);


		// print_r($users_list);die;

		$c = '5';
		$count = '1';
		foreach ($users_list as $u) {

			$countss = $this->Base_model->getCountForAttendance($u->id, $t);

			$objPHPExcel->getActiveSheet()->getRowDimension($c)->setRowHeight(20);

			$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $count);
			$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, ucfirst($u->username));

			$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "-");

			if ($u->role_id == '1') {

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "TL");
			} elseif ($u->role_id == '2') {

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "KAM");
			} elseif ($u->role_id == '12') {

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "Member");
			}


			$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "-");


			$month_year = $this->session->userdata('month_year');

			if ($month_year != '') {

				$month = date('n', strtotime($month_year));
				$year = date('Y', strtotime($month_year));
				$num = cal_days_in_month(CAL_GREGORIAN, $month, $year);

				$f = 'F';
				for ($j = 1; $j <= $num; $j++) {

					$d = $j . "-" . $month . "-" . $year;
					$s = date('Y-m-d', strtotime($d));

					$query = $this->db->query("Select * from resource_internal_execution where member_name =" . $u->id . " AND date='" . $s . "' AND ( day ='1' OR night = '2' ) ")->result()[0];


					if (!empty($query)) {

						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, get_store_name($query->store_id));
					} else {

						if (get_attendence($s, $u->id) == 'I') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Idel");
						} elseif (get_attendence($s, $u->id) == 'BOW') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Back office work");
						} elseif (get_attendence($s, $u->id) == 'CO') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Comp off");
						} elseif (get_attendence($s, $u->id) == 'A') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Absent");
						} elseif (get_attendence($s, $u->id) == 'L') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Leave");
						} elseif (get_attendence($s, $u->id) == 'WF') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Week off");
						} elseif (get_attendence($s, $u->id) == 'WFH') {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "Work from Home");
						} else {
							$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, "-");
						}
					}

					$f++;
				}
			}


			$first_day = '01' . "-" . $month . "-" . $year;
			$s1 = date('Y-m-d', strtotime($first_day));

			$last_day = $num . "-" . $month . "-" . $year;
			$s2 = date('Y-m-d', strtotime($last_day));

			$query1 = $this->db->query("Select count(*) as count from resource_internal_execution where member_name =" . $u->id . " AND date between '" . $s1 . "' AND '" . $s2 . "'  AND ( day ='1' OR night = '2' ) ")->result()[0];

			for ($i = 1; $i <= 10; $i++) {

				/* if($countss['BOW'] !=''){
	$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['BOW']);	
	} */

				if ($i == 1) {
					if ($countss['BOW'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['BOW']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 2) {
					if ($countss['WFH'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['WFH']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 3) {
					if ($countss['WF'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['WF']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 4) {
					if ($countss['CO'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['CO']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 5) {
					if ($countss['A'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['A']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 6) {
					if ($countss['I'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['I']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 7) {
					if ($countss['L'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $countss['L']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 8) {
					if ($countss['Total'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $num - $countss['Total']);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 9) {

					if (!empty($query1)) {

						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, $query1->count);
					} else {

						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}

				if ($i == 10) {
					if ($countss['Total'] != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, ($num - $countss['Total']) - $query1->count);
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue($f . $c, '0');
					}
				}
				$f++;
			}

			$c++;
			$count++;
		}




		$today = date('d-m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Team Utilization Report');


		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)
		//clean the output buffer
		ob_end_clean();
		//this is the header given from PHPExcel examples. but the output seems somewhat corrupted in some cases.
		//header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//so, we use this header instead.
		$filename = 'Team Utilization Report(' . date('d-m-Y') . ').xls';

		// ob_end_clean(); 
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}


	function get_variance_date($param1 = '', $param2 = '')
	{
		$store_id = '';
		if ($this->input->post('store_id') != '') {
			$store_id = $this->input->post('store_id');
		} else {
			//$location = $this->session->userdata("block_id");
		}

		$inventory_date_list = $this->db->query('select Inventory_Date from variance_report where store_id=' . $store_id . " Group by Inventory_Date")->row();

		echo json_encode($inventory_date_list);
	}

	function top_neg_pos_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		$keyword = '';
		if ($this->input->post('keyword') != '') {
			$this->session->set_userdata("keyword", $this->input->post('keyword'));
			$keyword = " AND store_id = " . $this->input->post('keyword');
		} elseif ($this->input->post('keyword') == '') {
			// $this->session->unset_userdata("keyword");
			//	$keyword='';
		}

		$inv_date = '';
		if ($this->input->post('inventory_date') != '') {
			$this->session->set_userdata("inventory_date", $this->input->post('inventory_date'));
			$inv_date = " AND book.Inventory_Date = '" . $this->input->post('inventory_date') . "'";
		} elseif ($this->input->post('inventory_date') == '') {
			// $this->session->unset_userdata("keyword");
			//$keyword='';
		}

		if ($this->input->post('keyword') != '') {
			//print_r($this->input->post('keyword'));die;

			$this->data['stocks_max']		= $this->base_model->run_query(
				" SELECT book.*
FROM variance_report as book 
WHERE Difference_MRP_Value = (SELECT MAX(book.Difference_MRP_Value)
             FROM variance_report AS book2
             WHERE book2.id = book.id) " . $keyword . " " . $inv_date . "  ORDER BY  Difference_MRP_Value DESC LIMIT 10 "
			);

			// print_r($this->db->last_query());die;


			$this->data['stocks_min']		= $this->base_model->run_query(
				" SELECT book.*
FROM variance_report as book 
WHERE Difference_MRP_Value = (SELECT MIN(book.Difference_MRP_Value)
             FROM variance_report AS book2
             WHERE book2.id = book.id) " . $keyword . " " . $inv_date . " ORDER BY  Difference_MRP_Value ASC LIMIT 10 "
			);


			/* $this->data['stocks'] 				= $this->base_model->run_query(
		"select * from stock_report ".$keyword ." ORDER BY CAST( value_descrepancy AS DECIMAL ) ASC    LIMIT 10 "); */
		}

		if ($this->ion_auth->is_client()) {

			//echo "raghu";die;
			$this->template->client_render('admin/reports/top_neg_pos_report', $this->data);
		} else {



			$this->template->admin_render('admin/reports/top_neg_pos_report', $this->data);
		}
	}


	function milestone_wise_report()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		$this->data['milestone_list'] = $this->base_model->milestone_list();

		$this->data['company_list'] = $this->base_model->company_list();



		if ($this->ion_auth->is_client()) {

			//echo "raghu";die;
			$this->template->client_render('admin/reports/milestone_wise_report', $this->data);
		} else {



			$this->template->admin_render('admin/reports/milestone_wise_report', $this->data);
		}
	}

	function collection_summary_report($param = '')
	{
		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['region_id'] = $region_id;

			$this->data['sbu_list'] = $this->base_model->getVerticalSBUlist($console_entity_id, $sbu_id, $cluster_id, $vertical_id);
		} else {


			$this->data['sbu_list'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/collection_summary_report', $this->data);
	}

	function ecl_output_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* 
			$ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity'] = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
		}

		if ($param == 'search') {

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$ecl_category = $this->input->post("ecl_category");
			$region_id = $this->input->post("region_id");

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['ecl_category'] = $ecl_category;
			$this->data['region_id'] = $region_id;
		} else {
			$this->data['month_year'] = '';
			$this->data['ar_type_id'] = '';
			$this->data['console_entity_id'] = '';
			$this->data['sbu_id'] = '';
			$this->data['cluster_id'] = '';
			$this->data['vertical_id'] = '';
			$this->data['denomination'] = '1';
			$this->data['fx_type_id'] = '0';
			$this->data['ecl_category'] = '';
			$this->data['region_id'] = '';
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/ecl_output_report', $this->data);
	}


	function ecl_two_output_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity'] = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
		}

		if ($param == 'search') {

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$ecl_category = $this->input->post("ecl_category");
			$region_id = $this->input->post("region_id");


			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}


			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}


			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['denomination'] = $denomination;
			$this->data['ecl_category'] = $ecl_category;
			$this->data['region_id'] = $region_id;
		} else {

			$this->data['month_year'] = '';
			$this->data['ar_type_id'] = '';
			$this->data['console_entity_id'] = '';
			$this->data['sbu_id'] = '';
			$this->data['cluster_id'] = '';
			$this->data['vertical_id'] = '';
			$this->data['denomination'] = '1';
			$this->data['ecl_category'] = '';
			$this->data['region_id'] = '';
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/ecl_two_output_report', $this->data);
	}


	function ar_summary_by_ar_type_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if ($param == 'search') {

			if (!$this->ion_auth->is_admin()) {

				$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

				$console_master1 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id = co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();

				$console_master = array();
				if (!empty($console_master1)) {
					foreach ($console_master1 as $v) {
						$console_master[] = $this->db->query("select console_name from console_master where id=" . $v->id)->result()[0];
					}
				}

				$result = array_column($console_master, 'console_name');

				$res = array();
				foreach ($result as $r) {
					$res[] = "'" . $r . "'";
				}

				/* echo "<pre>";
			print_r($res);die; */

				$this->data['console_master'] 	= $console_master1;
			} else {

				$this->data['console_master'] = $this->db->query("select * from console_master")->result();
			}


			$month_year = '';
			if ($this->input->post("month_year") != '') {
				$this->session->set_userdata("month_year_report", $this->input->post("month_year"));
				$month_year = $this->session->userdata("month_year_report");
				$this->data['month'] = $this->input->post("month_year");
			} else {

				$this->session->set_userdata("month_year_report", date('m-Y', strtotime('-1 months', strtotime(date('Y-m')))));
				$month_year = $this->session->userdata("month_year_report");
				$this->data['month'] = $this->input->post("month_year");
			}


			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
			} else {
				$consol_id = '';
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
			} else {
				$region_id = '';
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['consol_id'] = $consol_id;
			$this->data['region_id'] = $region_id;


			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}
			$this->data['month_year'] = $month_year;
			$ar_type_id = '';
			if ($this->input->post("ar_type_id") != '') {

				$this->session->set_userdata("ar_type_id_report", $this->input->post("ar_type_id"));

				$ar_type_name = array();
				foreach ($this->input->post("ar_type_id") as $a) {
					$ar_type_name[] = trim("'" . $a . "'");
				}

				if (!$this->ion_auth->is_admin()) {
					$ar_type_id = " AND ar_type IN(" . implode(',', $ar_type_name) . ")";
				} else {
					$ar_type_id = " WHERE ar_type IN(" . implode(',', $ar_type_name) . ")";
				}
			} else {

				$this->session->unset_userdata("ar_type_id_report");
				$ar_type_id = '';
			}

			if (!$this->ion_auth->is_admin()) {

				$this->data['ar_type_master'] = $this->db->query("select * from month_end_ar_process_data WHERE console_entity IN (" . implode(',', $res) . ") " . $ar_type_id . "  group by ar_type ")->result();

				// print_r($this->db->last_query());die;

				$this->data['ar_type_master_list'] = $this->db->query("select * from month_end_ar_process_data WHERE console_entity IN (" . implode(',', $res) . ") group by ar_type")->result();
			} else {

				$this->data['ar_type_master'] = $this->db->query("select * from month_end_ar_process_data " . $ar_type_id . "  group by ar_type ")->result();

				$this->data['ar_type_master_list'] = $this->db->query("select * from month_end_ar_process_data group by ar_type")->result();
			}
		} else {

			$this->data['ar_type_master_list'] = $this->db->query("select * from month_end_ar_process_data group by ar_type")->result();

			$this->data['console_master'] = $this->db->query("select * from console_master")->result();

			$this->data['ar_type_master'] = '';
			$this->data['denomination'] = '';
			$this->data['fx_type_id'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/ar_summary_by_ar_type_report', $this->data);
	}

	function trade_ar_summary_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}

			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
		} else {
			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] = $this->db->query("select * from console_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $this->input->post("consol_id");

				/* if(!empty($consol_id)){ $console_list = array();
					foreach($consol_id as $c){
						$console_list[] = get_console_id($c);
					}
				} */
			}


			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}


			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['month_year'] = $month_year;

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$this->data['vertical_list'] = $this->base_model->getVerticleMappingCluster($sbu_id, $cluster_id, $vertical_id, $consol_id);
			// print_r($this->db->last_query());die;

		} else {

			$this->data['vertical_list'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/trade_ar_summary_report', $this->data);
	}

	function exchange_impact_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if ($this->ion_auth->is_admin()) {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_entity'] = $this->db->query("select * from console_master")->result();
		} elseif ($this->ion_auth->is_user()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_entity'] = $this->db->query("select * from console_master")->result();
		}

		if ($param == 'search') {

			// print_r($this->input->post("vertical_id"));die;

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			$this->data['month_year'] = $month_year;

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$this->data['denomination'] = $denomination;

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}

			if ($this->input->post("console_entity_id") != '') {
				$console_entity_id = $this->input->post("console_entity_id");
				$this->data['console_entity_id'] = $this->input->post("console_entity_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}



			$this->data['vertical_list'] = $this->base_model->getVerticleMappingCluster($sbu_id, $cluster_id, $vertical_id, $console_entity_id);

			// print_r($this->db->last_query());die;

		} else {

			$this->data['vertical_list'] = '';
		}


		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/exchange_impact_report', $this->data);
	}


	function export_invoice_fema($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master_list'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_list'] 	= $this->db->query("select * from country_master")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_entity'] = $this->db->query("select * from console_master")->result();
			$this->data['ar_type_master_list'] = $this->db->query("select * from ar_type_master")->result();
			$this->data['country_list'] = $this->db->query("select * from country_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}

			if ($this->input->post("console_entity_id") != '') {
				$console_entity_id = $this->input->post("console_entity_id");
				$this->data['console_entity_id'] = $this->input->post("console_entity_id");
			}

			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $this->input->post("ar_type_id");
			}

			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $this->input->post("country_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['month_year'] = $month_year;


			$this->data['vertical_list'] = $this->base_model->getVerticleMappingClusterCurrency($sbu_id, $cluster_id, $vertical_id, $console_entity_id);

			// print_r($this->db->last_query());die;

		} else {

			$this->data['vertical_list'] = '';
		}


		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/export_invoice_fema', $this->data);
	}


	function exchange_impact_by_currency($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();

			$this->data['currency'] 		= $this->db->query("select * from local_fx_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
			$this->data['currency'] 		= $this->db->query("select * from local_fx_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month = $this->input->post("month_year");
			} else {
				$month = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['month_year'] = $month;
			$this->data['month'] = $month;

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}


			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $this->input->post("ar_type_id");
			}

			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $this->input->post("consol_id");
			}

			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $this->input->post("country_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			if ($this->input->post("currency") != '') {
				$currency = $this->input->post("currency");
				$this->data['currencysss'] = $this->input->post("currency");
				$list_currency = implode(',', $currency);
				$list_currencyss = "WHERE id IN (" . $list_currency  . ")";
			}


			if ($list_currencyss != '') {
				$this->data['currency_list'] = $this->db->query("select * from local_fx_master " . $list_currencyss)->result();
			} else {
				$this->data['currency_list'] = $this->db->query("select * from local_fx_master ")->result();
			}

			// print_r($this->db->last_query());die;

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}
		} else {

			$this->data['currency_list'] = '';
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/exchange_impact_by_currency', $this->data);
	}


	/*month end ar*/
	public function month_end_ar_report($param = '', $param1 = '')
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] = $this->db->query("select * from console_master")->result();
			$this->data['country_master'] = $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		}

		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/month_end_ar_report');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/month_end_ar_report', $this->data);
	}



	public function month_end_ar_report_ajax()
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
			redirect('auth/login', 'refresh');
		}

		// POST data
		$postData = $this->input->post();
		// Get data
		$data = $this->Ajax_model->month_end_ar_report_ajaxdata($postData);

		echo json_encode($data);
	}


	/*upload_daily_ar*/
	public function current_ar_report($param = '', $param1 = '')
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		} else {

			$this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] = $this->db->query("select * from console_master")->result();
			$this->data['country_master'] = $this->db->query("select * from country_master")->result();
			$this->data['region_master'] 	= $this->db->query("select * from region_master")->result();
		}

		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/current_ar_report');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/current_ar_report', $this->data);
	}

	public function current_ar_report_ajax()
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
			redirect('auth/login', 'refresh');
		}

		// POST data
		$postData = $this->input->post();
		// Get data
		$data = $this->Ajax_model->current_ar_report_ajaxdata($postData);
		echo json_encode($data);
	}


	public function month_end_process_for_table()
	{

		// Insert process_pending_list Data 

		$process_data_list = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'month' => $this->input->post('month_year')))->result();

		$data_array = array(
			'cron_type' => "month_end_ar",
			'month' => $this->input->post('month_year'),
			'cron_status' => 0,
			'process_data' => 0,
			'excel_report' => 0
		);

		if (count($process_data_list) > 0) {
			$this->db->where('cron_type', 'month_end_ar');
			$this->db->where('month', $this->input->post('month_year'));
			$this->db->update('cron_table', array('cron_status' => 0, 'process_data' => 0, 'excel_report' => 0));
		} else {
			$this->db->insert('cron_table', $data_array);
		}

		$month_data_list = $this->db->get_where('month_end_ar_list', array('month_year' => $this->input->post('month_year')))->result();

		if (count($month_data_list) > 0) {
			$this->db->where('month_year', $this->input->post('month_year'));
			$this->db->update('month_end_ar_list', array('process_data' => 0, 'sequence' => 0));
		}

		echo json_encode(1);
	}

	public function current_ar_process_for_table()
	{

		// Insert process_pending_list Data 

		$process_data_list = $this->db->get_where('cron_table', array('cron_type' => 'current_ar'))->result();

		$data_array = array(
			'cron_type' => "current_ar",
			// 'month' => $this->input->post('month_year'),
			'cron_status' => 0,
			'process_data' => 0,
			'excel_report' => 0
		);

		if (count($process_data_list) > 0) {
			$this->db->where('cron_type', 'current_ar');
			// $this->db->where('month', $this->input->post('month_year'));
			$this->db->update('cron_table', array('cron_status' => 0, 'process_data' => 0, 'excel_report' => 0));
		} else {
			$this->db->insert('cron_table', $data_array);
		}


		$current_data_list = $this->db->get_where('daily_ar')->result();

		if (count($current_data_list) > 0) {
			// $this->db->where('month_year', $this->input->post('month_year'));
			$this->db->update('daily_ar', array('process_data' => 0));
		}

		echo json_encode(1);
	}

	public function month_end_ar_process_data()
	{

		$month_year = '';
		if ($this->input->post("month_year") != '') {
			$this->session->set_userdata("month_year_month_end_ar_report", $this->input->post("month_year"));
			$month_year = $this->session->userdata("month_year_month_end_ar_report");
		} else {
			$this->session->unset_userdata("month_year_month_end_ar_report");
			$month_year = '';
		}


		if ($this->input->post() != '') {


			$this->db->query("DELETE FROM month_end_ar_process_data WHERE user_id ='" . $this->ion_auth->get_user_id() . "' AND month_year='" . $month_year . "'");


			/*--------- DPST SEARCH --------*/

			$ar_type = array('90993', '90994');

			$month_end_ar_data = $this->base_model->month_end_ar_list_DPST($month_year, $ar_type);

			$table_rep = "month_end_ar_process_data";



			if (!empty($month_end_ar_data)) {
				$fetchData = array();
				foreach ($month_end_ar_data as $key => $m) {


					$fetchData[$key]['ar_type'] 		= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchData[$key]['vertical']		= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchData[$key]['cluster'] 		= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchData[$key]['sbu'] 			= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchData[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchData[$key]['country'] 		= get_country_name(get_area_country($m->area)->country_id);

					$fetchData[$key]['month_end_ar_id']	= $m->month_end_ar_id;
					$fetchData[$key]['month_year'] 		= $m->month_year;
					$fetchData[$key]['area'] 			= $m->area;
					$fetchData[$key]['region'] 			= $m->region;
					$fetchData[$key]['dpst'] 			= $m->dpst;
					$fetchData[$key]['month'] 			= $m->month;
					$fetchData[$key]['sales_engg_code'] = $m->sales_engg_code;
					$fetchData[$key]['sales_engg_name'] = $m->sales_engg_name;
					$fetchData[$key]['customer_group'] 	= $m->customer_group;
					$fetchData[$key]['parent_code'] 	= $m->parent_code;
					$fetchData[$key]['child_code'] 		= $m->child_code;
					$fetchData[$key]['customer_name'] 	= $m->customer_name;
					$fetchData[$key]['project_name'] 	= $m->project_name;
					$fetchData[$key]['po_name'] 		= $m->po_name;
					$fetchData[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData[$key]['company'] 		= $m->company;
					$fetchData[$key]['transaction_type'] = $m->transaction_type;
					$fetchData[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData[$key]['org_document_number'] = $m->org_document_number;
					$fetchData[$key]['document_number'] = $m->document_number;
					$fetchData[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData[$key]['invoice_date']	= $m->invoice_date;
					$fetchData[$key]['credit_days'] 	= $m->credit_days;
					$fetchData[$key]['due_date']		= $m->due_date;
					$fetchData[$key]['credit_days_adj'] = $m->credit_days_adj;
					$fetchData[$key]['rev_due_date'] 	= $m->rev_due_date;
					$fetchData[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData[$key]['paid_amount'] 	= $m->paid_amount;
					$fetchData[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData[$key]['currency']		= $m->currency;
					$fetchData[$key]['fx_rate'] 		= $m->fx_rate;
					$fetchData[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData[$key]['customer_type'] 	= $m->customer_type;
					$fetchData[$key]['ecl_category'] 	= $m->ecl_category;
					$fetchData[$key]['consol'] 			= $m->consol;
					$fetchData[$key]['org_dpst'] 		= $m->org_dpst;
					$fetchData[$key]['org_tt'] 			= $m->org_tt;
					$fetchData[$key]['fema_days'] 		= $m->fema_days;
					$fetchData[$key]['ecl_days'] 		= $m->ecl_days;
					$fetchData[$key]['user_id'] 		= $this->ion_auth->get_user_id();

					$fetchData[$key]['responsibility'] 		= get_user_input($m->org_document_number)->responsibility;

					$fetchData[$key]['planned_coll_amt'] = get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchData[$key]['planned_coll_date'] = get_user_input($m->org_document_number)->planned_coll_date;
					$fetchData[$key]['retention'] = get_user_input($m->org_document_number)->retention;
					$fetchData[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchData[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchData[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchData[$key]['pbg_lc'] = get_user_input($m->org_document_number)->pbg_lc;
					$fetchData[$key]['won'] = get_user_input($m->org_document_number)->won;
					$fetchData[$key]['cnaf'] = get_user_input($m->org_document_number)->cnaf;
					$fetchData[$key]['srn'] = get_user_input($m->org_document_number)->srn;
					$fetchData[$key]['foc'] = get_user_input($m->org_document_number)->foc;
					$fetchData[$key]['wds'] = get_user_input($m->org_document_number)->wds;
					$fetchData[$key]['tds'] = get_user_input($m->org_document_number)->tds;
					$fetchData[$key]['ld'] = get_user_input($m->org_document_number)->ld;
					$fetchData[$key]['legal'] = get_user_input($m->org_document_number)->legal;
					$fetchData[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchData[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData[$key]['modified_doc']			= 1;
					} else {
						$fetchData[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData[$key]['od_days'] >= '0') {
						$fetchData[$key]['overdue'] = $m->balance_amount - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData[$key]['within_due'] = $m->balance_amount - $fetchData[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchData[$key]['ftm_due'] = $fetchData[$key]['within_due'] - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['overdue'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData[$key]['ftm_due'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['od_days'] <= '30') {
						$fetchData[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData[$key]['od_days'] && $fetchData[$key]['od_days'] <= '60') {
						$fetchData[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData[$key]['od_days'] >= '61' && $fetchData[$key]['od_days'] <= '90') {
						$fetchData[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData[$key]['od_days'] >= '91' && $fetchData[$key]['od_days'] <= '120') {
						$fetchData[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData[$key]['od_days'] >= '121' && $fetchData[$key]['od_days'] <= '150') {
						$fetchData[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData[$key]['od_days'] >= '151' && $fetchData[$key]['od_days'] <= '180') {
						$fetchData[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData[$key]['od_days'] >= '181' && $fetchData[$key]['od_days'] <= '360') {
						$fetchData[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData[$key]['od_days'] >= '361' && $fetchData[$key]['od_days'] <= '720') {
						$fetchData[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData[$key]['od_days'] >= '721' && $fetchData[$key]['od_days'] <= '1080') {
						$fetchData[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData[$key]['od_days'] >= '1081') {
						$fetchData[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchData[$key]['fx_within_due'] 		= $fetchData[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchData[$key]['fx_overdue'] 		= $fetchData[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchData[$key]['fx_ftm_due'] 		= $fetchData[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact

					$fetchData[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchData[$key]['collection_days'] 		= $this->get_number_of_days($fetchData[$key]['planned_coll_date'], $fetchData[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('month_end_ar_list');
				}
			}


			if (!empty($fetchData)) {

				$this->base_model->setBatchImportProcessData($fetchData);

				$this->base_model->importDataProcessData();
			}



			/*--------- Tarial Units Transaction SEARCH --------*/


			$priority_list = $this->base_model->getTransactionPriorityList(2);

			if (!empty($priority_list)) {

				foreach ($priority_list as $p) {

					$TransactionTypeListArray = $this->base_model->getTransactionTypeList(2, $p->priority);

					$TransactionTypeList = array_column($TransactionTypeListArray, 'transaction_type_code');

					$month_end_ar_transaction = $this->base_model->month_end_ar_list_TransactionType($month_year, $TransactionTypeList);

					if (!empty($month_end_ar_transaction)) {
						$fetchData_TransactionType = array();
						foreach ($month_end_ar_transaction as $key => $m) {


							$fetchData_TransactionType[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);

							$fetchData_TransactionType[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);

							$fetchData_TransactionType[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

							$fetchData_TransactionType[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
							$fetchData_TransactionType[$key]['month_year'] 			= $m->month_year;
							$fetchData_TransactionType[$key]['area'] 				= $m->area;
							$fetchData_TransactionType[$key]['region'] 				= $m->region;
							$fetchData_TransactionType[$key]['dpst'] 				= $m->dpst;
							$fetchData_TransactionType[$key]['month'] 				= $m->month;
							$fetchData_TransactionType[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType[$key]['customer_group'] 		= $m->customer_group;
							$fetchData_TransactionType[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType[$key]['child_code'] 			= $m->child_code;
							$fetchData_TransactionType[$key]['customer_name'] 		= $m->customer_name;
							$fetchData_TransactionType[$key]['project_name'] 		= $m->project_name;
							$fetchData_TransactionType[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType[$key]['po_credit_term'] 		= $m->po_credit_term;
							$fetchData_TransactionType[$key]['company'] 			= $m->company;
							$fetchData_TransactionType[$key]['transaction_type'] 	= $m->transaction_type;
							$fetchData_TransactionType[$key]['invoice_number'] 		= $m->invoice_number;
							$fetchData_TransactionType[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType[$key]['dispatch_date'] 		= $m->dispatch_date;
							$fetchData_TransactionType[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType[$key]['rev_due_date'] 		= $m->rev_due_date;
							$fetchData_TransactionType[$key]['invoice_amount'] 		= $m->invoice_amount;
							$fetchData_TransactionType[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType[$key]['balance_amount'] 		= $m->balance_amount;
							$fetchData_TransactionType[$key]['currency']			= $m->currency;
							$fetchData_TransactionType[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
							$fetchData_TransactionType[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
							$fetchData_TransactionType[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
							$fetchData_TransactionType[$key]['customer_type'] 		= $m->customer_type;
							$fetchData_TransactionType[$key]['ecl_category'] 		= $m->ecl_category;
							$fetchData_TransactionType[$key]['ecl_days'] 			= $m->ecl_days;
							$fetchData_TransactionType[$key]['consol'] 				= $m->consol;
							$fetchData_TransactionType[$key]['org_dpst'] 			= $m->org_dpst;
							$fetchData_TransactionType[$key]['org_tt'] 				= $m->org_tt;
							$fetchData_TransactionType[$key]['fema_days'] 			= $m->fema_days;
							$fetchData_TransactionType[$key]['user_id'] 			= $this->ion_auth->get_user_id();

							$fetchData_TransactionType[$key]['responsibility'] 		= get_user_input($m->org_document_number)->responsibility;

							$fetchData_TransactionType[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
							$fetchData_TransactionType[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
							$fetchData_TransactionType[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
							$fetchData_TransactionType[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
							$fetchData_TransactionType[$key]['pbg_lc'] 				= get_user_input($m->org_document_number)->pbg_lc;
							$fetchData_TransactionType[$key]['won'] 	= get_user_input($m->org_document_number)->won;
							$fetchData_TransactionType[$key]['cnaf']	= get_user_input($m->org_document_number)->cnaf;
							$fetchData_TransactionType[$key]['srn'] 	= get_user_input($m->org_document_number)->srn;
							$fetchData_TransactionType[$key]['foc'] 	= get_user_input($m->org_document_number)->foc;
							$fetchData_TransactionType[$key]['wds'] 	= get_user_input($m->org_document_number)->wds;
							$fetchData_TransactionType[$key]['tds'] 	= get_user_input($m->org_document_number)->tds;
							$fetchData_TransactionType[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
							$fetchData_TransactionType[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

							$fetchData_TransactionType[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
							$fetchData_TransactionType[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType[$key]['od_days'] >= '0') {
								$fetchData_TransactionType[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							$from_date1 = $split_month[0];

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1 + 1) {
								$fetchData_TransactionType[$key]['ftm_due'] = $fetchData_TransactionType[$key]['within_due'] - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['overdue'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['od_days'] <= '30') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] && $fetchData_TransactionType[$key]['od_days'] <= '60') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '61' && $fetchData_TransactionType[$key]['od_days'] <= '90') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '91' && $fetchData_TransactionType[$key]['od_days'] <= '120') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '121' && $fetchData_TransactionType[$key]['od_days'] <= '150') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '151' && $fetchData_TransactionType[$key]['od_days'] <= '180') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '181' && $fetchData_TransactionType[$key]['od_days'] <= '360') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '361' && $fetchData_TransactionType[$key]['od_days'] <= '720') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '721' && $fetchData_TransactionType[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "0 days";
							}


							// Seventh cal FX within Due

							$fetchData_TransactionType[$key]['fx_within_due'] 		= $fetchData_TransactionType[$key]['within_due'] / $m->fx_rate;

							// Eight cal fx_overdue

							$fetchData_TransactionType[$key]['fx_overdue'] 		= $fetchData_TransactionType[$key]['overdue'] / $m->fx_rate;

							// Night cal fx_ftm_due

							$fetchData_TransactionType[$key]['fx_ftm_due'] 		= $fetchData_TransactionType[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

							// Eleven cal collection_days

							$fetchData_TransactionType[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType[$key]['planned_coll_date'], $fetchData_TransactionType[$key]['actual_coll_date']);

							// Update the Process Data
							$this->db->where('month_end_ar_id', $m->month_end_ar_id);
							$this->db->set('process_data', 1);
							$this->db->update('month_end_ar_list');
						}
					}
				}
			}

			if (!empty($fetchData_TransactionType)) {

				$this->base_model->setBatchImportProcessData($fetchData_TransactionType);

				$this->base_model->importDataProcessData();
			}

			// print_r("Avinash");die;


			/*--------- Value SEARCH --------*/

			$month_end_ar_by_value = $this->base_model->month_end_ar_list_value($month_year);

			if (!empty($month_end_ar_by_value)) {
				$fetchData_value = array();
				foreach ($month_end_ar_by_value as $key => $m) {


					if ($m->balance_amount < 100 && $m->balance_amount > 0) {


						$fetchData_value[$key]['vertical'] 			= get_vertical_name(18);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(18)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(18)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(18)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						$fetchData_value[$key]['ar_type'] 			= $m->consol . "-" . get_artype_name(13);
					} else if ($m->balance_amount < 0) {

						$fetchData_value[$key]['vertical'] 			= get_vertical_name(19);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(19)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(19)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(19)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						$fetchData_value[$key]['ar_type'] 			= $m->consol . "-" . get_artype_name(14);
					}

					$fetchData_value[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
					$fetchData_value[$key]['month_year'] 		= $m->month_year;
					$fetchData_value[$key]['area'] 				= $m->area;
					$fetchData_value[$key]['region'] 			= $m->region;
					$fetchData_value[$key]['dpst'] 				= $m->dpst;
					$fetchData_value[$key]['month'] 			= $m->month;
					$fetchData_value[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchData_value[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchData_value[$key]['customer_group'] 	= $m->customer_group;
					$fetchData_value[$key]['parent_code'] 		= $m->parent_code;
					$fetchData_value[$key]['child_code'] 		= $m->child_code;
					$fetchData_value[$key]['customer_name'] 	= $m->customer_name;
					$fetchData_value[$key]['project_name'] 		= $m->project_name;
					$fetchData_value[$key]['po_name'] 			= $m->po_name;
					$fetchData_value[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData_value[$key]['company'] 			= $m->company;
					$fetchData_value[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchData_value[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData_value[$key]['org_document_number'] = $m->org_document_number;
					$fetchData_value[$key]['document_number'] 	= $m->document_number;
					$fetchData_value[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData_value[$key]['invoice_date']		= $m->invoice_date;
					$fetchData_value[$key]['credit_days'] 		= $m->credit_days;
					$fetchData_value[$key]['due_date']			= $m->due_date;
					$fetchData_value[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchData_value[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchData_value[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData_value[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchData_value[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData_value[$key]['currency']			= $m->currency;
					$fetchData_value[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchData_value[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData_value[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData_value[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData_value[$key]['customer_type'] 	= $m->customer_type;
					$fetchData_value[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchData_value[$key]['consol'] 			= $m->consol;
					$fetchData_value[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchData_value[$key]['org_tt'] 			= $m->org_tt;
					$fetchData_value[$key]['fema_days'] 		= $m->fema_days;
					$fetchData_value[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchData_value[$key]['user_id'] 			= $this->ion_auth->get_user_id();
					$fetchData_value[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;


					$fetchData_value[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchData_value[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
					$fetchData_value[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
					$fetchData_value[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchData_value[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchData_value[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchData_value[$key]['pbg_lc'] 	= get_user_input($m->org_document_number)->pbg_lc;
					$fetchData_value[$key]['won'] 		= get_user_input($m->org_document_number)->won;
					$fetchData_value[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
					$fetchData_value[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
					$fetchData_value[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
					$fetchData_value[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
					$fetchData_value[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
					$fetchData_value[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
					$fetchData_value[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

					$fetchData_value[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchData_value[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData_value[$key]['modified_doc']			= 1;
					} else {
						$fetchData_value[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData_value[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData_value[$key]['od_days'] >= '0') {
						$fetchData_value[$key]['overdue'] = $m->balance_amount - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData_value[$key]['within_due'] = $m->balance_amount - $fetchData_value[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchData_value[$key]['ftm_due'] = $fetchData_value[$key]['within_due'] - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['overdue'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData_value[$key]['ftm_due'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData_value[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['od_days'] <= '30') {
						$fetchData_value[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData_value[$key]['od_days'] && $fetchData_value[$key]['od_days'] <= '60') {
						$fetchData_value[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '61' && $fetchData_value[$key]['od_days'] <= '90') {
						$fetchData_value[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '91' && $fetchData_value[$key]['od_days'] <= '120') {
						$fetchData_value[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '121' && $fetchData_value[$key]['od_days'] <= '150') {
						$fetchData_value[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '151' && $fetchData_value[$key]['od_days'] <= '180') {
						$fetchData_value[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '181' && $fetchData_value[$key]['od_days'] <= '360') {
						$fetchData_value[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '361' && $fetchData_value[$key]['od_days'] <= '720') {
						$fetchData_value[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '721' && $fetchData_value[$key]['od_days'] <= '1080') {
						$fetchData_value[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '1081') {
						$fetchData_value[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData_value[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchData_value[$key]['fx_within_due'] 		= $fetchData_value[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchData_value[$key]['fx_overdue'] 		= $fetchData_value[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchData_value[$key]['fx_ftm_due'] 		= $fetchData_value[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact
					$fetchData_value[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchData_value[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_value[$key]['planned_coll_date'], $fetchData_value[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('month_end_ar_list');
				}
			}


			if (!empty($fetchData_value)) {

				$this->base_model->setBatchImportProcessData($fetchData_value);

				$this->base_model->importDataProcessData();
			}



			/*--------- FOC Transaction SEARCH --------*/

			$Focpriority_list = $this->base_model->getTransactionPriorityList(4);

			if (!empty($Focpriority_list)) {

				foreach ($Focpriority_list as $p) {

					$FOCTransactionTypeListArray = $this->base_model->getTransactionTypeList(4, $p->priority);

					$FOCTransactionTypeList = array_column($FOCTransactionTypeListArray, 'transaction_type_code');

					$month_end_ar_transaction_list = $this->base_model->month_end_ar_list_TransactionType($month_year, $FOCTransactionTypeList);

					if (!empty($month_end_ar_transaction_list)) {
						$fetchData_TransactionType_Fourth = array();
						foreach ($month_end_ar_transaction_list as $key => $m) {



							$fetchData_TransactionType_Fourth[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);
							$fetchData_TransactionType_Fourth[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType_Fourth[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType_Fourth[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);

							$fetchData_TransactionType_Fourth[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType_Fourth[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);


							$fetchData_TransactionType_Fourth[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
							$fetchData_TransactionType_Fourth[$key]['month_year'] 		= $m->month_year;
							$fetchData_TransactionType_Fourth[$key]['area'] 			= $m->area;
							$fetchData_TransactionType_Fourth[$key]['region'] 			= $m->region;
							$fetchData_TransactionType_Fourth[$key]['dpst'] 			= $m->dpst;
							$fetchData_TransactionType_Fourth[$key]['month'] 			= $m->month;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType_Fourth[$key]['customer_group'] 	= $m->customer_group;
							$fetchData_TransactionType_Fourth[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType_Fourth[$key]['child_code'] 		= $m->child_code;
							$fetchData_TransactionType_Fourth[$key]['customer_name'] 	= $m->customer_name;
							$fetchData_TransactionType_Fourth[$key]['project_name'] 	= $m->project_name;
							$fetchData_TransactionType_Fourth[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType_Fourth[$key]['po_credit_term'] 	= $m->po_credit_term;
							$fetchData_TransactionType_Fourth[$key]['company'] 			= $m->company;
							$fetchData_TransactionType_Fourth[$key]['transaction_type'] = $m->transaction_type;
							$fetchData_TransactionType_Fourth[$key]['invoice_number'] 	= $m->invoice_number;
							$fetchData_TransactionType_Fourth[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType_Fourth[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType_Fourth[$key]['dispatch_date'] 	= $m->dispatch_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType_Fourth[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType_Fourth[$key]['rev_due_date'] 	= $m->rev_due_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_amount'] 	= $m->invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType_Fourth[$key]['balance_amount'] 	= $m->balance_amount;
							$fetchData_TransactionType_Fourth[$key]['currency']			= $m->currency;
							$fetchData_TransactionType_Fourth[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType_Fourth[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_balance_amount'] = $m->fx_balance_amount;
							$fetchData_TransactionType_Fourth[$key]['customer_type'] 	= $m->customer_type;
							$fetchData_TransactionType_Fourth[$key]['ecl_category'] 	= $m->ecl_category;
							$fetchData_TransactionType_Fourth[$key]['consol'] 			= $m->consol;
							$fetchData_TransactionType_Fourth[$key]['org_dpst'] 		= $m->org_dpst;
							$fetchData_TransactionType_Fourth[$key]['org_tt'] 			= $m->org_tt;
							$fetchData_TransactionType_Fourth[$key]['fema_days'] 		= $m->fema_days;
							$fetchData_TransactionType_Fourth[$key]['ecl_days'] 		= $m->ecl_days;
							$fetchData_TransactionType_Fourth[$key]['user_id'] 			= $this->ion_auth->get_user_id();

							$fetchData_TransactionType_Fourth[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

							$fetchData_TransactionType_Fourth[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
							$fetchData_TransactionType_Fourth[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
							$fetchData_TransactionType_Fourth[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
							$fetchData_TransactionType_Fourth[$key]['pbg_lc'] 	= get_user_input($m->org_document_number)->pbg_lc;
							$fetchData_TransactionType_Fourth[$key]['won'] 		= get_user_input($m->org_document_number)->won;
							$fetchData_TransactionType_Fourth[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
							$fetchData_TransactionType_Fourth[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
							$fetchData_TransactionType_Fourth[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
							$fetchData_TransactionType_Fourth[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
							$fetchData_TransactionType_Fourth[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
							$fetchData_TransactionType_Fourth[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
							$fetchData_TransactionType_Fourth[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

							$fetchData_TransactionType_Fourth[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
							$fetchData_TransactionType_Fourth[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType_Fourth[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0') {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType_Fourth[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							$from_date1 = $split_month[0];

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1 + 1) {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = $fetchData_TransactionType_Fourth[$key]['within_due'] - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['overdue'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType_Fourth[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '30') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '60') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '61' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '90') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '91' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '120') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '121' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '150') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '151' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '180') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '181' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '360') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '361' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '720') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '721' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "0 days";
							}


							// Seventh cal FX within Due

							$fetchData_TransactionType_Fourth[$key]['fx_within_due'] 		= $fetchData_TransactionType_Fourth[$key]['within_due'] / $m->fx_rate;

							// Eight cal fx_overdue

							$fetchData_TransactionType_Fourth[$key]['fx_overdue'] 		= $fetchData_TransactionType_Fourth[$key]['overdue'] / $m->fx_rate;

							// Night cal fx_ftm_due

							$fetchData_TransactionType_Fourth[$key]['fx_ftm_due'] 		= $fetchData_TransactionType_Fourth[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

							// Eleven cal collection_days

							$fetchData_TransactionType_Fourth[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType_Fourth[$key]['planned_coll_date'], $fetchData_TransactionType_Fourth[$key]['actual_coll_date']);


							// Update the Process Data
							$this->db->where('month_end_ar_id', $m->month_end_ar_id);
							$this->db->set('process_data', 1);
							$this->db->update('month_end_ar_list');


							$data['month_end_report'] = $fetchData_TransactionType_Fourth;
						}
					}
				}
			}

			if (!empty($fetchData_TransactionType_Fourth)) {

				$this->base_model->setBatchImportProcessData($fetchData_TransactionType_Fourth);

				$this->base_model->importDataProcessData();
			}




			/*--------- DPST Fifth stage SEARCH --------*/

			$logical_ar_type = array('4', '5', '7', '6');

			$ar_type = $this->base_model->month_end_ar_list_DPST_ar_type($logical_ar_type);

			$ar_typess = array_column($ar_type, 'dpst_code');

			$month_end_ar_data_last = $this->base_model->month_end_ar_list_DPST($month_year, $ar_typess);

			if (!empty($month_end_ar_data_last)) {
				$fetchDatalast = array();
				foreach ($month_end_ar_data_last as $key => $m) {


					$fetchDatalast[$key]['ar_type'] 			= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchDatalast[$key]['vertical'] 			= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchDatalast[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchDatalast[$key]['sbu']					= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchDatalast[$key]['console_entity'] 		= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchDatalast[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

					$fetchDatalast[$key]['month_end_ar_id'] 	= $m->month_end_ar_id;
					$fetchDatalast[$key]['month_year'] 			= $m->month_year;
					$fetchDatalast[$key]['area'] 				= $m->area;
					$fetchDatalast[$key]['region'] 				= $m->region;
					$fetchDatalast[$key]['dpst'] 				= $m->dpst;
					$fetchDatalast[$key]['month'] 				= $m->month;
					$fetchDatalast[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchDatalast[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchDatalast[$key]['customer_group'] 		= $m->customer_group;
					$fetchDatalast[$key]['parent_code'] 		= $m->parent_code;
					$fetchDatalast[$key]['child_code'] 			= $m->child_code;
					$fetchDatalast[$key]['customer_name'] 		= $m->customer_name;
					$fetchDatalast[$key]['project_name'] 		= $m->project_name;
					$fetchDatalast[$key]['po_name'] 			= $m->po_name;
					$fetchDatalast[$key]['po_credit_term'] 		= $m->po_credit_term;
					$fetchDatalast[$key]['company'] 			= $m->company;
					$fetchDatalast[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchDatalast[$key]['invoice_number'] 		= $m->invoice_number;
					$fetchDatalast[$key]['org_document_number'] = $m->org_document_number;
					$fetchDatalast[$key]['document_number'] 	= $m->document_number;
					$fetchDatalast[$key]['dispatch_date'] 		= $m->dispatch_date;
					$fetchDatalast[$key]['invoice_date']		= $m->invoice_date;
					$fetchDatalast[$key]['credit_days'] 		= $m->credit_days;
					$fetchDatalast[$key]['due_date']			= $m->due_date;
					$fetchDatalast[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchDatalast[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchDatalast[$key]['invoice_amount'] 		= $m->invoice_amount;
					$fetchDatalast[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchDatalast[$key]['balance_amount'] 		= $m->balance_amount;
					$fetchDatalast[$key]['currency']			= $m->currency;
					$fetchDatalast[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchDatalast[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
					$fetchDatalast[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
					$fetchDatalast[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
					$fetchDatalast[$key]['customer_type'] 		= $m->customer_type;
					$fetchDatalast[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchDatalast[$key]['consol'] 				= $m->consol;
					$fetchDatalast[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchDatalast[$key]['org_tt'] 				= $m->org_tt;
					$fetchDatalast[$key]['fema_days'] 			= $m->fema_days;
					$fetchDatalast[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchDatalast[$key]['user_id'] 			= $this->ion_auth->get_user_id();
					$fetchDatalast[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

					$fetchDatalast[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchDatalast[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
					$fetchDatalast[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
					$fetchDatalast[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchDatalast[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchDatalast[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchDatalast[$key]['pbg_lc'] 		= get_user_input($m->org_document_number)->pbg_lc;
					$fetchDatalast[$key]['won'] 		= get_user_input($m->org_document_number)->won;
					$fetchDatalast[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
					$fetchDatalast[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
					$fetchDatalast[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
					$fetchDatalast[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
					$fetchDatalast[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
					$fetchDatalast[$key]['ld'] 			= get_user_input($m->org_document_number)->ld;
					$fetchDatalast[$key]['legal'] 		= get_user_input($m->org_document_number)->legal;

					$fetchDatalast[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchDatalast[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchDatalast[$key]['modified_doc']			= 1;
					} else {
						$fetchDatalast[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchDatalast[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchDatalast[$key]['od_days'] >= '0') {
						$fetchDatalast[$key]['overdue'] = $m->balance_amount - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchDatalast[$key]['within_due'] = $m->balance_amount - $fetchDatalast[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchDatalast[$key]['ftm_due'] = $fetchDatalast[$key]['within_due'] - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['overdue'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchDatalast[$key]['ftm_due'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchDatalast[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['od_days'] <= '30') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchDatalast[$key]['od_days'] && $fetchDatalast[$key]['od_days'] <= '60') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '61' && $fetchDatalast[$key]['od_days'] <= '90') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '91' && $fetchDatalast[$key]['od_days'] <= '120') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '121' && $fetchDatalast[$key]['od_days'] <= '150') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '151' && $fetchDatalast[$key]['od_days'] <= '180') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '181' && $fetchDatalast[$key]['od_days'] <= '360') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '361' && $fetchDatalast[$key]['od_days'] <= '720') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '721' && $fetchDatalast[$key]['od_days'] <= '1080') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '1081') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchDatalast[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchDatalast[$key]['fx_within_due'] 		= $fetchDatalast[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchDatalast[$key]['fx_overdue'] 		= $fetchDatalast[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchDatalast[$key]['fx_ftm_due'] 		= $fetchDatalast[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact
					$fetchDatalast[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchDatalast[$key]['collection_days'] 		= $this->get_number_of_days($fetchDatalast[$key]['planned_coll_date'], $fetchDatalast[$key]['actual_coll_date']);



					// Update the Process Data
					$this->db->where('month_end_ar_id', $m->month_end_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('month_end_ar_list');
				}
			}



			if (!empty($fetchDatalast)) {

				$this->base_model->setBatchImportProcessData($fetchDatalast);

				$this->base_model->importDataProcessData();
			}




			//--------------- Excel Export ---------------------------//


			/*	$list = $this->base_model->getMonthEndReportListForExcel($month_year);


			
			$this->load->library('Excel');
			ob_start();
			
			$objPHPExcel = new PHPExcel();
			$styleArray = array(
				'font' => array(
					'size' => 13,
					'name' => 'Roboto'
				)
			);
			$fontArray = array(
				'font' => array(
					'bold' => true,
					'size' => 11,
					'name' => 'Roboto'
				)
			);
			$dateArray = array(
				'font' => array(
					'bold' => true,
				)
			);
			$bgcolor = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'E7E7E7'),
				)
			);

			$bgcolorblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '66bfff'),
				)
			);

			$bgblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'ff0000'),
				)
			);

			$bgbrr = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '82b7da'),
				)
			);
			
			$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
				->setLastModifiedBy("Comprehensive School Management")
				->setTitle("Office  XLSX Test Document")
				->setSubject("Office XLSX Test Document")
				->setDescription("Test document for Office XLSX, generated by PHP classes.")
				->setKeywords("office openxml php")
				->setCategory("Excel Sheet");


			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);

			$objPHPExcel->getActiveSheet(0)->getStyle('A1:AF1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


			$objPHPExcel->getActiveSheet()
				->getStyle('A')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('B')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('C')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('D')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('E')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('F')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('K')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('L')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()
				->getStyle('H')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('I')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('M')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('N')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('O')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('P')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('Q')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()->getStyle('A1:AF1')->applyFromArray($bgcolorblue);

			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
			$objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
			$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
			$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
			$objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Child_Code');
			$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Customer_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Project_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org_Document_Number');
			$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Invoice_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Rev_Due_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Invoice_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Paid_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Balance_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Currency');
			$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Fx_Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Planned_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Planned_Coll_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('T1', 'Retention');
			$objPHPExcel->getActiveSheet()->setCellValue('U1', 'Retention_Warranty');
			$objPHPExcel->getActiveSheet()->setCellValue('V1', 'Planned_RTN_WRTN_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Planned_RTN_WRTN_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('X1', 'PBG_LC');
			$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'WON');
			$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'CNAF');
			$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'SRN');
			$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'FOC');
			$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'WDS');
			$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'TDS');
			$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'LD');
			$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Legal');

			$c = '2';
			$count = '1';
			foreach ($list as $l) {

				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);

				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);

				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);

				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);

				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);

				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->child_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->customer_name);

				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->project_name);

				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_document_number);

				if ($l->invoice_date != '' or $l->invoice_date != '0000-00-00') {
					$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, date('d-M-Y', strtotime($l->invoice_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
				}

				if ($l->rev_due_date != '' or $l->rev_due_date != '0000-00-00') {
					$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
				}

				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!i', $l->invoice_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!i', $l->paid_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!i', $l->balance_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->currency);

				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!i', $l->fx_rate));

				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "");

				$c++;
				$count++;
			}

			ob_end_clean();

			$today = date('m-Y');

			$objPHPExcel->getActiveSheet()->setTitle('User Upload Template format v2');

			$objPHPExcel->setActiveSheetIndex(0);

			ob_clean();

			ob_end_flush();

			$filename = 'AR-' . $month_year . '.xlsx';

			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $filename . '"'); 
			
			header('Cache-Control: max-age=0');

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

			ob_end_clean();

			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/user_input_excels/" . $filename;
			

			$objWriter->save($path); */
		}

		echo json_encode(1);
	}


	public function get_number_of_days($date1, $date2)
	{
		$now = strtotime($date1); // or your date as well
		$your_date = strtotime($date2);
		$datediff = $now - $your_date;

		return round($datediff / (60 * 60 * 24));
	}


	//---------- Exchange Impact Report -------------------//

	public function ExchangeImpactReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$console_id = $_POST['console_id'];

		$denomination = $_POST['denomination'];

		$region_id = $_POST['region_id'];

		$vertical_list = $this->base_model->getVerticleMappingClusterss($sbu_id, $cluster_id, $vertical_id, $console_id);

		// print_r($this->db->last_query());die;


		$openModalFillData = "";

		if (!empty($vertical_list)) {
			foreach ($vertical_list as $ver) {

				$openModalFillData .= '<tr class="details' . $cluster_id . '" data-id="' . $ver->vertical_id . '' . $ver->cluster_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>' . get_vertical_name($ver->vertical_id) . '</td>';



				$verticalFxImpact = $this->base_model->getARSummaryByARTypeReportVerticalFxImpact($month_year, $sbu_id, $cluster_id, $ver->vertical_id, $console_id, $region_id);

				if ($verticalFxImpact != '') {

					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $verticalFxImpact / $denomination) . '</td>';
				} else {

					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$openModalFillData .= ' </tr>';
			}
		}



		$resultData['openModalFillData'] = $openModalFillData;

		echo json_encode($resultData['openModalFillData']);
	}

	//---------- Export Invoice FEMA Report -------------------//

	public function ExportInvoiceFEMAReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$console_id = $_POST['console_id'];

		$denomination = $_POST['denomination'];

		$fx_type_id = $_POST['fx_type_id'];

		$ar_type_id = $_POST['ar_type_id'];

		$country_id = $_POST['country_id'];

		$region_id = $_POST['region_id'];

		// $vertical_list = $this->base_model->getVerticleMappingClusterss_feema($sbu_id, $cluster_id, $vertical_id, $console_id);


		$openModalFillData = "";

		/* if (!empty($vertical_list)) {
			foreach ($vertical_list as $ver) {

				$openModalFillData .= '<tr class="details' . $cluster_id . '" data-id="' . $ver->vertical_id . '' . $ver->cluster_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td class="details-control-chk"></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>' . get_vertical_name($ver->vertical_id) . '</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$verticalBal = $this->base_model->getExportInvoiceFEMAReportVerticalBal($month_year, $sbu_id, $cluster_id, $ver->vertical_id, $console_id, $ar_type_id, $country_id, $region_id);

				if ($fx_type_id == 0) {

					if ($verticalBal != '') {

						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $verticalBal->bal / $denomination) . '</td>';
					} else {

						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				} elseif ($fx_type_id == 1) {

					if ($verticalBal != '') {

						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $verticalBal->fx_bal / $denomination) . '</td>';
					} else {

						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				}

				$openModalFillData .= ' </tr>'; */


				$month_end_ar_list = $this->base_model->getmonth_end_ar_list($month_year, $sbu_id, $cluster_id, $vertical_id, $console_id,  $ar_type_id, $country_id, $region_id);


				if (!empty($month_end_ar_list)) {
					foreach ($month_end_ar_list as $m) {

						$openModalFillData .= '<tr class="details' . $cluster_id . ' details-chk' . $vertical_id . '' . $cluster_id . ' " style="background: #d4d5ff  !important;"><td>  </td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>' . $m->org_document_number . '</td>';

						$openModalFillData .= '<td>' . $m->child_code . '</td>';

						$openModalFillData .= '<td>' . $m->customer_name . '</td>';

						$openModalFillData .= '<td>' . $m->fema_days . '</td>';

						if ($fx_type_id == 0) {

							if ($m->balance_amount != '') {

								$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $m->balance_amount / $denomination) . '</td>';
							} else {

								$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
							}
						} elseif ($fx_type_id == 1) {

							if ($m->fx_balance_amount != '') {

								$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $m->fx_balance_amount / $denomination) . '</td>';
							} else {

								$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
							}
						}

						$openModalFillData .= ' </tr>';
					}
				}
			// }
		// }



		$resultData['openModalFillData'] = $openModalFillData;

		echo json_encode($resultData['openModalFillData']);
	}



	//---------- Trade AR Summary Report -------------------//

	public function TradeARSummaryReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$denomination = $_POST['denomination'];

		$fx_type_id = $_POST['fx_type_id'];

		$consol_id = $_POST['consol_id'];

		$region_id = $_POST['region_id'];

		/* if(!empty($consol_id)){ $console_list = array();
					foreach($consol_id as $c){
						$console_list[] = get_console_id($c);
					}
				} */

		$vertical_list = $this->base_model->getVerticleMappingClusterss($sbu_id, $cluster_id, $vertical_id, $consol_id);


		$openModalFillData = "";

		if (!empty($vertical_list)) {
			foreach ($vertical_list as $ver) {

				$vertical_data = $this->base_model->getTradeARSummaryReportVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, $consol_id, $region_id)[0];

				$openModalFillData .= '<tr class="details' . $cluster_id . '" data-id="' . $ver->vertical_id . '' . $ver->cluster_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>' . get_vertical_name($ver->vertical_id) . '</td>';


				$ver_inv_amt = $vertical_data->inv_amt;

				$ver_collect_amt = $vertical_data->col_amt;

				if ($fx_type_id == 0) {

					$ver_balance_amt = $vertical_data->bal / $denomination;
				} elseif ($fx_type_id == 1) {

					$ver_balance_amt = $vertical_data->fx_bal / $denomination;
				}


				if ($ver_balance_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $ver_balance_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				if ($fx_type_id == 0) {

					$Within_Due1 = $vertical_data->within_due / $denomination;
				} elseif ($fx_type_id == 1) {

					$Within_Due1 = $vertical_data->fx_within_due / $denomination;
				}


				if ($Within_Due1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $Within_Due1) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				if ($fx_type_id == 0) {

					$FTM1 = $vertical_data->fx_ftm_due / $denomination;
				} elseif ($fx_type_id == 1) {

					$FTM1 = $vertical_data->fx_ftm_due / $denomination;
				}

				if ($FTM1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $FTM1) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$Retention1 = $vertical_data->retention / $denomination;


				if ($Retention1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $Retention1) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$war_ret1 = $vertical_data->war_ret / $denomination;

				if ($war_ret1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $war_ret1) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($fx_type_id == 0) {

					$overdue1 = $vertical_data->overdue / $denomination;
				} elseif ($fx_type_id == 1) {

					$overdue1 = $vertical_data->fx_overdue / $denomination;
				}

				if ($overdue1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $overdue1) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$out_amt1 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, 0, 360, $consol_id, $region_id)[0];


				if ($fx_type_id == 0) {

					if ($out_amt1 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt1->overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				} elseif ($fx_type_id == 1) {

					if ($out_amt1 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt1->fx_overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				}

				$out_amt2 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, 361, 720, $consol_id, $region_id)[0];

				if ($fx_type_id == 0) {

					if ($out_amt2 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt2->overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				} elseif ($fx_type_id == 1) {

					if ($out_amt2 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt2->fx_overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				}


				$out_amt3 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, 721, 1080, $consol_id, $region_id)[0];

				if ($fx_type_id == 0) {

					if ($out_amt3 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt3->overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				} elseif ($fx_type_id == 1) {

					if ($out_amt3 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt3->fx_overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				}


				$out_amt4 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, '', 1081, $consol_id, $region_id)[0];

				if ($fx_type_id == 0) {

					if ($out_amt4 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt4->overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				} elseif ($fx_type_id == 1) {

					if ($out_amt4 != '') {
						$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $out_amt4->fx_overdue2 / $denomination) . '</td>';
					} else {
						$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
					}
				}


				$nonCollectable_amt = $this->base_model->getNonCollectableAmtVertical($month_year, $sbu_id, $cluster_id, $ver->vertical_id, $consol_id, $region_id)[0];

				if ($nonCollectable_amt->won != '' && $nonCollectable_amt->won != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->won / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->ld != '' && $nonCollectable_amt->ld != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->ld / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->legal != '' && $nonCollectable_amt->legal != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->legal / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				if ($nonCollectable_amt->pbg_lc != '' && $nonCollectable_amt->pbg_lc != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->pbg_lc / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->cnaf != '' && $nonCollectable_amt->cnaf != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->cnaf / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->srn != '' && $nonCollectable_amt->srn != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->srn / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->foc != '' && $nonCollectable_amt->foc != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->foc / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->wds != '' && $nonCollectable_amt->wds != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->wds / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->gst_tds != '' && $nonCollectable_amt->gst_tds != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->gst_tds / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				if ($nonCollectable_amt->tds != '' && $nonCollectable_amt->tds != 0) {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $nonCollectable_amt->tds / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$openModalFillData .= ' </tr>';
			}
		}



		$resultData['openModalFillData'] = $openModalFillData;

		echo json_encode($resultData['openModalFillData']);
	}





	//------------------- Current AR Process Data ------------------------//

	public function current_ar_process_data()
	{

		$month_year = '';
		if ($this->input->post("month_year") != '') {
			$this->session->set_userdata("month_year_month_end_ar_report", $this->input->post("month_year"));
			$month_year = $this->session->userdata("month_year_month_end_ar_report");
		} else {

			$this->session->unset_userdata("month_year_month_end_ar_report");
			$month_year = '';
		}


		if ($this->input->post() != '') {
			$this->db->query("DELETE FROM current_ar_process_data WHERE user_id ='" . $this->ion_auth->get_user_id() . "' AND month_year='" . $month_year . "'");
			/*--------- DPST SEARCH --------*/

			$ar_type = array('90993', '90994');

			$current_ar_data = $this->base_model->current_ar_list_DPST($month_year, $ar_type);

			$table_rep = "current_ar_process_data";



			if (!empty($current_ar_data)) {
				$fetchData = array();
				foreach ($current_ar_data as $key => $m) {


					$fetchData[$key]['ar_type'] 		= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchData[$key]['vertical']		= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchData[$key]['cluster'] 		= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchData[$key]['sbu'] 			= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchData[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchData[$key]['country'] 		= get_country_name(get_area_country($m->area)->country_id);

					$fetchData[$key]['daily_ar_id']		= $m->daily_ar_id;
					$fetchData[$key]['month_year'] 		= $m->month_year;
					$fetchData[$key]['area'] 			= $m->area;
					$fetchData[$key]['region'] 			= $m->region;
					$fetchData[$key]['dpst'] 			= $m->dpst;
					$fetchData[$key]['month'] 			= $m->month;
					$fetchData[$key]['sales_engg_code'] = $m->sales_engg_code;
					$fetchData[$key]['sales_engg_name'] = $m->sales_engg_name;
					$fetchData[$key]['customer_group'] 	= $m->customer_group;
					$fetchData[$key]['parent_code'] 	= $m->parent_code;
					$fetchData[$key]['child_code'] 		= $m->child_code;
					$fetchData[$key]['customer_name'] 	= $m->customer_name;
					$fetchData[$key]['project_name'] 	= $m->project_name;
					$fetchData[$key]['po_name'] 		= $m->po_name;
					$fetchData[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData[$key]['company'] 		= $m->company;
					$fetchData[$key]['transaction_type'] = $m->transaction_type;
					$fetchData[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData[$key]['org_document_number'] = $m->org_document_number;
					$fetchData[$key]['document_number'] = $m->document_number;
					$fetchData[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData[$key]['invoice_date']	= $m->invoice_date;
					$fetchData[$key]['credit_days'] 	= $m->credit_days;
					$fetchData[$key]['due_date']		= $m->due_date;
					$fetchData[$key]['credit_days_adj'] = $m->credit_days_adj;
					$fetchData[$key]['rev_due_date'] 	= $m->rev_due_date;
					$fetchData[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData[$key]['paid_amount'] 	= $m->paid_amount;
					$fetchData[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData[$key]['currency']		= $m->currency;
					$fetchData[$key]['fx_rate'] 		= $m->fx_rate;
					$fetchData[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData[$key]['customer_type'] 	= $m->customer_type;
					$fetchData[$key]['ecl_category'] 	= $m->ecl_category;
					$fetchData[$key]['consol'] 			= $m->consol;
					$fetchData[$key]['org_dpst'] 		= $m->org_dpst;
					$fetchData[$key]['org_tt'] 			= $m->org_tt;
					$fetchData[$key]['fema_days'] 		= $m->fema_days;
					$fetchData[$key]['ecl_days'] 		= $m->ecl_days;
					$fetchData[$key]['user_id'] 		= $this->ion_auth->get_user_id();

					$fetchData[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

					$fetchData[$key]['planned_coll_amt'] = get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchData[$key]['planned_coll_date'] = get_user_input($m->org_document_number)->planned_coll_date;
					$fetchData[$key]['retention'] = get_user_input($m->org_document_number)->retention;
					$fetchData[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchData[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchData[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchData[$key]['pbg_lc'] = get_user_input($m->org_document_number)->pbg_lc;
					$fetchData[$key]['won'] = get_user_input($m->org_document_number)->won;
					$fetchData[$key]['cnaf'] = get_user_input($m->org_document_number)->cnaf;
					$fetchData[$key]['srn'] = get_user_input($m->org_document_number)->srn;
					$fetchData[$key]['foc'] = get_user_input($m->org_document_number)->foc;
					$fetchData[$key]['wds'] = get_user_input($m->org_document_number)->wds;
					$fetchData[$key]['tds'] = get_user_input($m->org_document_number)->tds;
					$fetchData[$key]['ld'] = get_user_input($m->org_document_number)->ld;
					$fetchData[$key]['legal'] = get_user_input($m->org_document_number)->legal;
					$fetchData[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchData[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData[$key]['modified_doc']			= 1;
					} else {
						$fetchData[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData[$key]['od_days'] >= '0') {
						$fetchData[$key]['overdue'] = $m->balance_amount - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData[$key]['within_due'] = $m->balance_amount - $fetchData[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchData[$key]['ftm_due'] = $fetchData[$key]['within_due'] - $fetchData[$key]['retention'] - $fetchData[$key]['warranty_retention'];
					} else {
						$fetchData[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['overdue'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData[$key]['ftm_due'] != '0') {
						$fetchData[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData[$key]['od_days'] >= '0' && $fetchData[$key]['od_days'] <= '30') {
						$fetchData[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData[$key]['od_days'] && $fetchData[$key]['od_days'] <= '60') {
						$fetchData[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData[$key]['od_days'] >= '61' && $fetchData[$key]['od_days'] <= '90') {
						$fetchData[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData[$key]['od_days'] >= '91' && $fetchData[$key]['od_days'] <= '120') {
						$fetchData[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData[$key]['od_days'] >= '121' && $fetchData[$key]['od_days'] <= '150') {
						$fetchData[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData[$key]['od_days'] >= '151' && $fetchData[$key]['od_days'] <= '180') {
						$fetchData[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData[$key]['od_days'] >= '181' && $fetchData[$key]['od_days'] <= '360') {
						$fetchData[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData[$key]['od_days'] >= '361' && $fetchData[$key]['od_days'] <= '720') {
						$fetchData[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData[$key]['od_days'] >= '721' && $fetchData[$key]['od_days'] <= '1080') {
						$fetchData[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData[$key]['od_days'] >= '1081') {
						$fetchData[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchData[$key]['fx_within_due'] 		= $fetchData[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchData[$key]['fx_overdue'] 		= $fetchData[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchData[$key]['fx_ftm_due'] 		= $fetchData[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact

					$fetchData[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchData[$key]['collection_days'] 		= $this->get_number_of_days($fetchData[$key]['planned_coll_date'], $fetchData[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('daily_ar');
				}
			}


			if (!empty($fetchData)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData);

				$this->base_model->importDataCurrentARProcessData();
			}




			/*--------- Tarial Units Transaction SEARCH --------*/

			$priority_list = $this->base_model->getTransactionPriorityList(2);

			if (!empty($priority_list)) {

				foreach ($priority_list as $p) {

					$TransactionTypeListArray = $this->base_model->getTransactionTypeList(2, $p->priority);

					$TransactionTypeList = array_column($TransactionTypeListArray, 'transaction_type_code');

					$current_ar_transaction = $this->base_model->current_ar_list_TransactionType($month_year, $TransactionTypeList);

					if (!empty($current_ar_transaction)) {
						$fetchData_TransactionType = array();
						foreach ($current_ar_transaction as $key => $m) {




							$fetchData_TransactionType[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);

							$fetchData_TransactionType[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);


							$fetchData_TransactionType[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);

							$fetchData_TransactionType[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

							$fetchData_TransactionType[$key]['daily_ar_id'] 		= $m->daily_ar_id;
							$fetchData_TransactionType[$key]['month_year'] 			= $m->month_year;
							$fetchData_TransactionType[$key]['area'] 				= $m->area;
							$fetchData_TransactionType[$key]['region'] 				= $m->region;
							$fetchData_TransactionType[$key]['dpst'] 				= $m->dpst;
							$fetchData_TransactionType[$key]['month'] 				= $m->month;
							$fetchData_TransactionType[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType[$key]['customer_group'] 		= $m->customer_group;
							$fetchData_TransactionType[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType[$key]['child_code'] 			= $m->child_code;
							$fetchData_TransactionType[$key]['customer_name'] 		= $m->customer_name;
							$fetchData_TransactionType[$key]['project_name'] 		= $m->project_name;
							$fetchData_TransactionType[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType[$key]['po_credit_term'] 		= $m->po_credit_term;
							$fetchData_TransactionType[$key]['company'] 			= $m->company;
							$fetchData_TransactionType[$key]['transaction_type'] 	= $m->transaction_type;
							$fetchData_TransactionType[$key]['invoice_number'] 		= $m->invoice_number;
							$fetchData_TransactionType[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType[$key]['dispatch_date'] 		= $m->dispatch_date;
							$fetchData_TransactionType[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType[$key]['rev_due_date'] 		= $m->rev_due_date;
							$fetchData_TransactionType[$key]['invoice_amount'] 		= $m->invoice_amount;
							$fetchData_TransactionType[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType[$key]['balance_amount'] 		= $m->balance_amount;
							$fetchData_TransactionType[$key]['currency']			= $m->currency;
							$fetchData_TransactionType[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
							$fetchData_TransactionType[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
							$fetchData_TransactionType[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
							$fetchData_TransactionType[$key]['customer_type'] 		= $m->customer_type;
							$fetchData_TransactionType[$key]['ecl_category'] 		= $m->ecl_category;
							$fetchData_TransactionType[$key]['consol'] 				= $m->consol;
							$fetchData_TransactionType[$key]['org_dpst'] 			= $m->org_dpst;
							$fetchData_TransactionType[$key]['org_tt'] 				= $m->org_tt;
							$fetchData_TransactionType[$key]['fema_days'] 			= $m->fema_days;
							$fetchData_TransactionType[$key]['ecl_days'] 			= $m->ecl_days;
							$fetchData_TransactionType[$key]['user_id'] 			= $this->ion_auth->get_user_id();

							$fetchData_TransactionType[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

							$fetchData_TransactionType[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
							$fetchData_TransactionType[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
							$fetchData_TransactionType[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
							$fetchData_TransactionType[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
							$fetchData_TransactionType[$key]['pbg_lc'] 				= get_user_input($m->org_document_number)->pbg_lc;
							$fetchData_TransactionType[$key]['won'] 	= get_user_input($m->org_document_number)->won;
							$fetchData_TransactionType[$key]['cnaf']	= get_user_input($m->org_document_number)->cnaf;
							$fetchData_TransactionType[$key]['srn'] 	= get_user_input($m->org_document_number)->srn;
							$fetchData_TransactionType[$key]['foc'] 	= get_user_input($m->org_document_number)->foc;
							$fetchData_TransactionType[$key]['wds'] 	= get_user_input($m->org_document_number)->wds;
							$fetchData_TransactionType[$key]['tds'] 	= get_user_input($m->org_document_number)->tds;
							$fetchData_TransactionType[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
							$fetchData_TransactionType[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

							$fetchData_TransactionType[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
							$fetchData_TransactionType[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType[$key]['od_days'] >= '0') {
								$fetchData_TransactionType[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							$from_date1 = $split_month[0];

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1 + 1) {
								$fetchData_TransactionType[$key]['ftm_due'] = $fetchData_TransactionType[$key]['within_due'] - $fetchData_TransactionType[$key]['retention'] - $fetchData_TransactionType[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['overdue'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType[$key]['od_days'] >= '0' && $fetchData_TransactionType[$key]['od_days'] <= '30') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] && $fetchData_TransactionType[$key]['od_days'] <= '60') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '61' && $fetchData_TransactionType[$key]['od_days'] <= '90') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '91' && $fetchData_TransactionType[$key]['od_days'] <= '120') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '121' && $fetchData_TransactionType[$key]['od_days'] <= '150') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '151' && $fetchData_TransactionType[$key]['od_days'] <= '180') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '181' && $fetchData_TransactionType[$key]['od_days'] <= '360') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '361' && $fetchData_TransactionType[$key]['od_days'] <= '720') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '721' && $fetchData_TransactionType[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType[$key]['od_ageing_category'] 		= "0 days";
							}


							// Seventh cal FX within Due

							$fetchData_TransactionType[$key]['fx_within_due'] 		= $fetchData_TransactionType[$key]['within_due'] / $m->fx_rate;

							// Eight cal fx_overdue

							$fetchData_TransactionType[$key]['fx_overdue'] 		= $fetchData_TransactionType[$key]['overdue'] / $m->fx_rate;

							// Night cal fx_ftm_due

							$fetchData_TransactionType[$key]['fx_ftm_due'] 		= $fetchData_TransactionType[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

							// Eleven cal collection_days

							$fetchData_TransactionType[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType[$key]['planned_coll_date'], $fetchData_TransactionType[$key]['actual_coll_date']);

							// Update the Process Data
							$this->db->where('daily_ar_id', $m->daily_ar_id);
							$this->db->set('process_data', 1);
							$this->db->update('daily_ar');
						}
					}
				}
			}


			if (!empty($fetchData_TransactionType)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData_TransactionType);

				$this->base_model->importDataCurrentARProcessData();
			}

			// print_r("Avinash");die;


			/*--------- Value SEARCH --------*/

			$current_ar_by_value = $this->base_model->current_ar_list_value($month_year);

			if (!empty($current_ar_by_value)) {
				$fetchData_value = array();
				foreach ($current_ar_by_value as $key => $m) {


					if ($m->balance_amount < 100 && $m->balance_amount > 0) {


						$fetchData_value[$key]['vertical'] 			= get_vertical_name(18);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(18)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(18)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(18)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						$fetchData_value[$key]['ar_type'] 			= $m->consol . "-" . get_artype_name(13);
					} else if ($m->balance_amount < 0) {

						$fetchData_value[$key]['vertical'] 			= get_vertical_name(19);
						$fetchData_value[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(19)->cluster_id);
						$fetchData_value[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(19)->sbu_id);
						$fetchData_value[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(19)->console_id);
						$fetchData_value[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);
						$fetchData_value[$key]['ar_type'] 			= $m->consol . "-" . get_artype_name(14);
					}

					$fetchData_value[$key]['daily_ar_id'] 		= $m->daily_ar_id;
					$fetchData_value[$key]['month_year'] 		= $m->month_year;
					$fetchData_value[$key]['area'] 				= $m->area;
					$fetchData_value[$key]['region'] 			= $m->region;
					$fetchData_value[$key]['dpst'] 				= $m->dpst;
					$fetchData_value[$key]['month'] 			= $m->month;
					$fetchData_value[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchData_value[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchData_value[$key]['customer_group'] 	= $m->customer_group;
					$fetchData_value[$key]['parent_code'] 		= $m->parent_code;
					$fetchData_value[$key]['child_code'] 		= $m->child_code;
					$fetchData_value[$key]['customer_name'] 	= $m->customer_name;
					$fetchData_value[$key]['project_name'] 		= $m->project_name;
					$fetchData_value[$key]['po_name'] 			= $m->po_name;
					$fetchData_value[$key]['po_credit_term'] 	= $m->po_credit_term;
					$fetchData_value[$key]['company'] 			= $m->company;
					$fetchData_value[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchData_value[$key]['invoice_number'] 	= $m->invoice_number;
					$fetchData_value[$key]['org_document_number'] = $m->org_document_number;
					$fetchData_value[$key]['document_number'] 	= $m->document_number;
					$fetchData_value[$key]['dispatch_date'] 	= $m->dispatch_date;
					$fetchData_value[$key]['invoice_date']		= $m->invoice_date;
					$fetchData_value[$key]['credit_days'] 		= $m->credit_days;
					$fetchData_value[$key]['due_date']			= $m->due_date;
					$fetchData_value[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchData_value[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchData_value[$key]['invoice_amount'] 	= $m->invoice_amount;
					$fetchData_value[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchData_value[$key]['balance_amount'] 	= $m->balance_amount;
					$fetchData_value[$key]['currency']			= $m->currency;
					$fetchData_value[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchData_value[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
					$fetchData_value[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
					$fetchData_value[$key]['fx_balance_amount'] = $m->fx_balance_amount;
					$fetchData_value[$key]['customer_type'] 	= $m->customer_type;
					$fetchData_value[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchData_value[$key]['consol'] 			= $m->consol;
					$fetchData_value[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchData_value[$key]['org_tt'] 			= $m->org_tt;
					$fetchData_value[$key]['fema_days'] 		= $m->fema_days;
					$fetchData_value[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchData_value[$key]['user_id'] 			= $this->ion_auth->get_user_id();

					$fetchData_value[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;


					$fetchData_value[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchData_value[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
					$fetchData_value[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
					$fetchData_value[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchData_value[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchData_value[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchData_value[$key]['pbg_lc'] 	= get_user_input($m->org_document_number)->pbg_lc;
					$fetchData_value[$key]['won'] 		= get_user_input($m->org_document_number)->won;
					$fetchData_value[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
					$fetchData_value[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
					$fetchData_value[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
					$fetchData_value[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
					$fetchData_value[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
					$fetchData_value[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
					$fetchData_value[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

					$fetchData_value[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchData_value[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchData_value[$key]['modified_doc']			= 1;
					} else {
						$fetchData_value[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchData_value[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchData_value[$key]['od_days'] >= '0') {
						$fetchData_value[$key]['overdue'] = $m->balance_amount - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchData_value[$key]['within_due'] = $m->balance_amount - $fetchData_value[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchData_value[$key]['ftm_due'] = $fetchData_value[$key]['within_due'] - $fetchData_value[$key]['retention'] - $fetchData_value[$key]['warranty_retention'];
					} else {
						$fetchData_value[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['overdue'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchData_value[$key]['ftm_due'] != '0') {
						$fetchData_value[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchData_value[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchData_value[$key]['od_days'] >= '0' && $fetchData_value[$key]['od_days'] <= '30') {
						$fetchData_value[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchData_value[$key]['od_days'] && $fetchData_value[$key]['od_days'] <= '60') {
						$fetchData_value[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '61' && $fetchData_value[$key]['od_days'] <= '90') {
						$fetchData_value[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '91' && $fetchData_value[$key]['od_days'] <= '120') {
						$fetchData_value[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '121' && $fetchData_value[$key]['od_days'] <= '150') {
						$fetchData_value[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '151' && $fetchData_value[$key]['od_days'] <= '180') {
						$fetchData_value[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '181' && $fetchData_value[$key]['od_days'] <= '360') {
						$fetchData_value[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '361' && $fetchData_value[$key]['od_days'] <= '720') {
						$fetchData_value[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '721' && $fetchData_value[$key]['od_days'] <= '1080') {
						$fetchData_value[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchData_value[$key]['od_days'] >= '1081') {
						$fetchData_value[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchData_value[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchData_value[$key]['fx_within_due'] 		= $fetchData_value[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchData_value[$key]['fx_overdue'] 		= $fetchData_value[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchData_value[$key]['fx_ftm_due'] 		= $fetchData_value[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact
					$fetchData_value[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchData_value[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_value[$key]['planned_coll_date'], $fetchData_value[$key]['actual_coll_date']);


					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('daily_ar');
				}
			}


			if (!empty($fetchData_value)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData_value);

				$this->base_model->importDataCurrentARProcessData();
			}



			/*--------- FOC Transaction SEARCH --------*/


			$Focpriority_list = $this->base_model->getTransactionPriorityList(4);

			if (!empty($Focpriority_list)) {

				foreach ($Focpriority_list as $p) {

					$FOCTransactionTypeListArray = $this->base_model->getTransactionTypeList(4, $p->priority);

					$FOCTransactionTypeList = array_column($FOCTransactionTypeListArray, 'transaction_type_code');

					$current_ar_transaction_list = $this->base_model->current_ar_list_TransactionType($month_year, $FOCTransactionTypeList);

					if (!empty($current_ar_transaction_list)) {
						$fetchData_TransactionType_Fourth = array();
						foreach ($current_ar_transaction_list as $key => $m) {



							$fetchData_TransactionType_Fourth[$key]['vertical'] 			= get_vertical_name(get_transaction_type($m->transaction_type)->vertical_id);
							$fetchData_TransactionType_Fourth[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->cluster_id);
							$fetchData_TransactionType_Fourth[$key]['sbu'] 				= get_sbu_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->sbu_id);
							$fetchData_TransactionType_Fourth[$key]['console_entity'] 	= get_console_name(get_vertical_entity_mapping(get_transaction_type($m->transaction_type)->vertical_id)->console_id);
							$fetchData_TransactionType_Fourth[$key]['ar_type'] 			= get_artype_name(get_transaction_type_ar_type($m->transaction_type)->ar_type_id);
							$fetchData_TransactionType_Fourth[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);


							$fetchData_TransactionType_Fourth[$key]['daily_ar_id'] 		= $m->daily_ar_id;
							$fetchData_TransactionType_Fourth[$key]['month_year'] 		= $m->month_year;
							$fetchData_TransactionType_Fourth[$key]['area'] 			= $m->area;
							$fetchData_TransactionType_Fourth[$key]['region'] 			= $m->region;
							$fetchData_TransactionType_Fourth[$key]['dpst'] 			= $m->dpst;
							$fetchData_TransactionType_Fourth[$key]['month'] 			= $m->month;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_code'] 	= $m->sales_engg_code;
							$fetchData_TransactionType_Fourth[$key]['sales_engg_name'] 	= $m->sales_engg_name;
							$fetchData_TransactionType_Fourth[$key]['customer_group'] 	= $m->customer_group;
							$fetchData_TransactionType_Fourth[$key]['parent_code'] 		= $m->parent_code;
							$fetchData_TransactionType_Fourth[$key]['child_code'] 		= $m->child_code;
							$fetchData_TransactionType_Fourth[$key]['customer_name'] 	= $m->customer_name;
							$fetchData_TransactionType_Fourth[$key]['project_name'] 	= $m->project_name;
							$fetchData_TransactionType_Fourth[$key]['po_name'] 			= $m->po_name;
							$fetchData_TransactionType_Fourth[$key]['po_credit_term'] 	= $m->po_credit_term;
							$fetchData_TransactionType_Fourth[$key]['company'] 			= $m->company;
							$fetchData_TransactionType_Fourth[$key]['transaction_type'] = $m->transaction_type;
							$fetchData_TransactionType_Fourth[$key]['invoice_number'] 	= $m->invoice_number;
							$fetchData_TransactionType_Fourth[$key]['org_document_number'] = $m->org_document_number;
							$fetchData_TransactionType_Fourth[$key]['document_number'] 	= $m->document_number;
							$fetchData_TransactionType_Fourth[$key]['dispatch_date'] 	= $m->dispatch_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_date']		= $m->invoice_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days'] 		= $m->credit_days;
							$fetchData_TransactionType_Fourth[$key]['due_date']			= $m->due_date;
							$fetchData_TransactionType_Fourth[$key]['credit_days_adj'] 	= $m->credit_days_adj;
							$fetchData_TransactionType_Fourth[$key]['rev_due_date'] 	= $m->rev_due_date;
							$fetchData_TransactionType_Fourth[$key]['invoice_amount'] 	= $m->invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['paid_amount'] 		= $m->paid_amount;
							$fetchData_TransactionType_Fourth[$key]['balance_amount'] 	= $m->balance_amount;
							$fetchData_TransactionType_Fourth[$key]['currency']			= $m->currency;
							$fetchData_TransactionType_Fourth[$key]['fx_rate'] 			= $m->fx_rate;
							$fetchData_TransactionType_Fourth[$key]['fx_invoice_amount'] = $m->fx_invoice_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_paid_amount'] 	= $m->fx_paid_amount;
							$fetchData_TransactionType_Fourth[$key]['fx_balance_amount'] = $m->fx_balance_amount;
							$fetchData_TransactionType_Fourth[$key]['customer_type'] 	= $m->customer_type;
							$fetchData_TransactionType_Fourth[$key]['ecl_category'] 	= $m->ecl_category;
							$fetchData_TransactionType_Fourth[$key]['consol'] 			= $m->consol;
							$fetchData_TransactionType_Fourth[$key]['org_dpst'] 		= $m->org_dpst;
							$fetchData_TransactionType_Fourth[$key]['org_tt'] 			= $m->org_tt;
							$fetchData_TransactionType_Fourth[$key]['fema_days'] 		= $m->fema_days;
							$fetchData_TransactionType_Fourth[$key]['ecl_days'] 		= $m->ecl_days;
							$fetchData_TransactionType_Fourth[$key]['user_id'] 			= $this->ion_auth->get_user_id();

							$fetchData_TransactionType_Fourth[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

							$fetchData_TransactionType_Fourth[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
							$fetchData_TransactionType_Fourth[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
							$fetchData_TransactionType_Fourth[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
							$fetchData_TransactionType_Fourth[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
							$fetchData_TransactionType_Fourth[$key]['pbg_lc'] 	= get_user_input($m->org_document_number)->pbg_lc;
							$fetchData_TransactionType_Fourth[$key]['won'] 		= get_user_input($m->org_document_number)->won;
							$fetchData_TransactionType_Fourth[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
							$fetchData_TransactionType_Fourth[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
							$fetchData_TransactionType_Fourth[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
							$fetchData_TransactionType_Fourth[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
							$fetchData_TransactionType_Fourth[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
							$fetchData_TransactionType_Fourth[$key]['ld'] 		= get_user_input($m->org_document_number)->ld;
							$fetchData_TransactionType_Fourth[$key]['legal'] 	= get_user_input($m->org_document_number)->legal;

							$fetchData_TransactionType_Fourth[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
							$fetchData_TransactionType_Fourth[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

							// First Cal

							if ($m->org_document_number != $m->document_number) {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 1;
							} else {
								$fetchData_TransactionType_Fourth[$key]['modified_doc']			= 0;
							}



							// Third Cal

							$fetchData_TransactionType_Fourth[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


							// Fifth Cal 

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0') {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['overdue'] = '0';
							}


							// Fourth Cal 

							$fetchData_TransactionType_Fourth[$key]['within_due'] = $m->balance_amount - $fetchData_TransactionType_Fourth[$key]['overdue'];


							// Six FTM_Due Cal

							$split_month = explode('-', $m->month);

							$split_rev_month = explode('-', $m->rev_due_date);

							$from_date1 = $split_month[0];

							$from_date2 = $split_rev_month[0];



							if ($from_date2 == $from_date1 + 1) {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = $fetchData_TransactionType_Fourth[$key]['within_due'] - $fetchData_TransactionType_Fourth[$key]['retention'] - $fetchData_TransactionType_Fourth[$key]['warranty_retention'];
							} else {
								$fetchData_TransactionType_Fourth[$key]['ftm_due'] = '0';
							}


							// Second Cal

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['overdue'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "OD";
							} elseif ($fetchData_TransactionType_Fourth[$key]['ftm_due'] != '0') {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "FTM";
							} else {
								$fetchData_TransactionType_Fourth[$key]['invoice_type'] 		= "Not Due";
							}



							// Six cal OD Ageing category

							if ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '0' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '30') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "1 > 30 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '60') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "31 > 60 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '61' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '90') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "61 > 90 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '91' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '120') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "91 > 120 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '121' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '150') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "121 > 150 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '151' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '180') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "151 > 180 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '181' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '360') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "181 > 360 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '361' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '720') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "361 > 720 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '721' && $fetchData_TransactionType_Fourth[$key]['od_days'] <= '1080') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "721 > 1080 days";
							} elseif ($fetchData_TransactionType_Fourth[$key]['od_days'] >= '1081') {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "Above 1080 days";
							} else {
								$fetchData_TransactionType_Fourth[$key]['od_ageing_category'] 		= "0 days";
							}


							// Seventh cal FX within Due

							$fetchData_TransactionType_Fourth[$key]['fx_within_due'] 		= $fetchData_TransactionType_Fourth[$key]['within_due'] / $m->fx_rate;

							// Eight cal fx_overdue

							$fetchData_TransactionType_Fourth[$key]['fx_overdue'] 		= $fetchData_TransactionType_Fourth[$key]['overdue'] / $m->fx_rate;

							// Night cal fx_ftm_due

							$fetchData_TransactionType_Fourth[$key]['fx_ftm_due'] 		= $fetchData_TransactionType_Fourth[$key]['ftm_due'] / $m->fx_rate;

							// Tenth cal fx_impact
							$fetchData_TransactionType_Fourth[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

							// Eleven cal collection_days

							$fetchData_TransactionType_Fourth[$key]['collection_days'] 		= $this->get_number_of_days($fetchData_TransactionType_Fourth[$key]['planned_coll_date'], $fetchData_TransactionType_Fourth[$key]['actual_coll_date']);


							// Update the Process Data
							$this->db->where('daily_ar_id', $m->daily_ar_id);
							$this->db->set('process_data', 1);
							$this->db->update('daily_ar');
						}
					}
				}
			}


			if (!empty($fetchData_TransactionType_Fourth)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchData_TransactionType_Fourth);

				$this->base_model->importDataCurrentARProcessData();
			}




			/*--------- DPST Fifth stage SEARCH --------*/

			$logical_ar_type = array('4', '5', '7', '6');

			$ar_type = $this->base_model->month_end_ar_list_DPST_ar_type($logical_ar_type);

			$ar_typess = array_column($ar_type, 'dpst_code');

			$current_ar_data_last = $this->base_model->current_ar_list_DPST($month_year, $ar_typess);

			if (!empty($current_ar_data_last)) {
				$fetchDatalast = array();
				foreach ($current_ar_data_last as $key => $m) {


					$fetchDatalast[$key]['ar_type'] 			= get_artype_name(get_ar_type($m->dpst)->ar_type_id);
					$fetchDatalast[$key]['vertical'] 			= get_vertical_name(get_ar_type($m->dpst)->vertical_id);
					$fetchDatalast[$key]['cluster'] 			= get_cluster_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->cluster_id);
					$fetchDatalast[$key]['sbu']					= get_sbu_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->sbu_id);
					$fetchDatalast[$key]['console_entity'] 		= get_console_name(get_vertical_entity_mapping(get_ar_type($m->dpst)->vertical_id)->console_id);
					$fetchDatalast[$key]['country'] 			= get_country_name(get_area_country($m->area)->country_id);

					$fetchDatalast[$key]['daily_ar_id'] 		= $m->daily_ar_id;
					$fetchDatalast[$key]['month_year'] 			= $m->month_year;
					$fetchDatalast[$key]['area'] 				= $m->area;
					$fetchDatalast[$key]['region'] 				= $m->region;
					$fetchDatalast[$key]['dpst'] 				= $m->dpst;
					$fetchDatalast[$key]['month'] 				= $m->month;
					$fetchDatalast[$key]['sales_engg_code'] 	= $m->sales_engg_code;
					$fetchDatalast[$key]['sales_engg_name'] 	= $m->sales_engg_name;
					$fetchDatalast[$key]['customer_group'] 		= $m->customer_group;
					$fetchDatalast[$key]['parent_code'] 		= $m->parent_code;
					$fetchDatalast[$key]['child_code'] 			= $m->child_code;
					$fetchDatalast[$key]['customer_name'] 		= $m->customer_name;
					$fetchDatalast[$key]['project_name'] 		= $m->project_name;
					$fetchDatalast[$key]['po_name'] 			= $m->po_name;
					$fetchDatalast[$key]['po_credit_term'] 		= $m->po_credit_term;
					$fetchDatalast[$key]['company'] 			= $m->company;
					$fetchDatalast[$key]['transaction_type'] 	= $m->transaction_type;
					$fetchDatalast[$key]['invoice_number'] 		= $m->invoice_number;
					$fetchDatalast[$key]['org_document_number'] = $m->org_document_number;
					$fetchDatalast[$key]['document_number'] 	= $m->document_number;
					$fetchDatalast[$key]['dispatch_date'] 		= $m->dispatch_date;
					$fetchDatalast[$key]['invoice_date']		= $m->invoice_date;
					$fetchDatalast[$key]['credit_days'] 		= $m->credit_days;
					$fetchDatalast[$key]['due_date']			= $m->due_date;
					$fetchDatalast[$key]['credit_days_adj'] 	= $m->credit_days_adj;
					$fetchDatalast[$key]['rev_due_date'] 		= $m->rev_due_date;
					$fetchDatalast[$key]['invoice_amount'] 		= $m->invoice_amount;
					$fetchDatalast[$key]['paid_amount'] 		= $m->paid_amount;
					$fetchDatalast[$key]['balance_amount'] 		= $m->balance_amount;
					$fetchDatalast[$key]['currency']			= $m->currency;
					$fetchDatalast[$key]['fx_rate'] 			= $m->fx_rate;
					$fetchDatalast[$key]['fx_invoice_amount'] 	= $m->fx_invoice_amount;
					$fetchDatalast[$key]['fx_paid_amount'] 		= $m->fx_paid_amount;
					$fetchDatalast[$key]['fx_balance_amount'] 	= $m->fx_balance_amount;
					$fetchDatalast[$key]['customer_type'] 		= $m->customer_type;
					$fetchDatalast[$key]['ecl_category'] 		= $m->ecl_category;
					$fetchDatalast[$key]['consol'] 				= $m->consol;
					$fetchDatalast[$key]['org_dpst'] 			= $m->org_dpst;
					$fetchDatalast[$key]['org_tt'] 				= $m->org_tt;
					$fetchDatalast[$key]['fema_days'] 			= $m->fema_days;
					$fetchDatalast[$key]['ecl_days'] 			= $m->ecl_days;
					$fetchDatalast[$key]['user_id'] 			= $this->ion_auth->get_user_id();

					$fetchDatalast[$key]['responsibility'] 	= get_user_input($m->org_document_number)->responsibility;

					$fetchDatalast[$key]['planned_coll_amt'] 	= get_user_input($m->org_document_number)->planned_coll_amt;
					$fetchDatalast[$key]['planned_coll_date'] 	= get_user_input($m->org_document_number)->planned_coll_date;
					$fetchDatalast[$key]['retention'] 		= get_user_input($m->org_document_number)->retention;
					$fetchDatalast[$key]['warranty_retention'] = get_user_input($m->org_document_number)->warranty_retention;
					$fetchDatalast[$key]['planned_rtn_wrtn_coll_amt'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_coll_amt;
					$fetchDatalast[$key]['planned_rtn_wrtn_date'] = get_user_input($m->org_document_number)->planned_rtn_wrtn_date;
					$fetchDatalast[$key]['pbg_lc'] 		= get_user_input($m->org_document_number)->pbg_lc;
					$fetchDatalast[$key]['won'] 		= get_user_input($m->org_document_number)->won;
					$fetchDatalast[$key]['cnaf']		= get_user_input($m->org_document_number)->cnaf;
					$fetchDatalast[$key]['srn'] 		= get_user_input($m->org_document_number)->srn;
					$fetchDatalast[$key]['foc'] 		= get_user_input($m->org_document_number)->foc;
					$fetchDatalast[$key]['wds'] 		= get_user_input($m->org_document_number)->wds;
					$fetchDatalast[$key]['tds'] 		= get_user_input($m->org_document_number)->tds;
					$fetchDatalast[$key]['ld'] 			= get_user_input($m->org_document_number)->ld;
					$fetchDatalast[$key]['legal'] 		= get_user_input($m->org_document_number)->legal;

					$fetchDatalast[$key]['actual_coll_date'] = get_daily_collection($m->org_document_number)->document_date;
					$fetchDatalast[$key]['actual_coll_amount'] = get_daily_collection($m->org_document_number)->collection;

					// First Cal

					if ($m->org_document_number != $m->document_number) {
						$fetchDatalast[$key]['modified_doc']			= 1;
					} else {
						$fetchDatalast[$key]['modified_doc']			= 0;
					}



					// Third Cal

					$fetchDatalast[$key]['od_days'] = $this->get_number_of_days($m->month, $m->rev_due_date);


					// Fifth Cal 

					if ($fetchDatalast[$key]['od_days'] >= '0') {
						$fetchDatalast[$key]['overdue'] = $m->balance_amount - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['overdue'] = '0';
					}


					// Fourth Cal 

					$fetchDatalast[$key]['within_due'] = $m->balance_amount - $fetchDatalast[$key]['overdue'];


					// Six FTM_Due Cal

					$split_month = explode('-', $m->month);

					$split_rev_month = explode('-', $m->rev_due_date);

					$from_date1 = $split_month[0];

					$from_date2 = $split_rev_month[0];



					if ($from_date2 == $from_date1 + 1) {
						$fetchDatalast[$key]['ftm_due'] = $fetchDatalast[$key]['within_due'] - $fetchDatalast[$key]['retention'] - $fetchDatalast[$key]['warranty_retention'];
					} else {
						$fetchDatalast[$key]['ftm_due'] = '0';
					}


					// Second Cal

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['overdue'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "OD";
					} elseif ($fetchDatalast[$key]['ftm_due'] != '0') {
						$fetchDatalast[$key]['invoice_type'] 		= "FTM";
					} else {
						$fetchDatalast[$key]['invoice_type'] 		= "Not Due";
					}



					// Six cal OD Ageing category

					if ($fetchDatalast[$key]['od_days'] >= '0' && $fetchDatalast[$key]['od_days'] <= '30') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "1 > 30 days";
					} elseif ($fetchDatalast[$key]['od_days'] && $fetchDatalast[$key]['od_days'] <= '60') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "31 > 60 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '61' && $fetchDatalast[$key]['od_days'] <= '90') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "61 > 90 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '91' && $fetchDatalast[$key]['od_days'] <= '120') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "91 > 120 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '121' && $fetchDatalast[$key]['od_days'] <= '150') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "121 > 150 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '151' && $fetchDatalast[$key]['od_days'] <= '180') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "151 > 180 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '181' && $fetchDatalast[$key]['od_days'] <= '360') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "181 > 360 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '361' && $fetchDatalast[$key]['od_days'] <= '720') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "361 > 720 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '721' && $fetchDatalast[$key]['od_days'] <= '1080') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "721 > 1080 days";
					} elseif ($fetchDatalast[$key]['od_days'] >= '1081') {
						$fetchDatalast[$key]['od_ageing_category'] 		= "Above 1080 days";
					} else {
						$fetchDatalast[$key]['od_ageing_category'] 		= "0 days";
					}


					// Seventh cal FX within Due

					$fetchDatalast[$key]['fx_within_due'] 		= $fetchDatalast[$key]['within_due'] / $m->fx_rate;

					// Eight cal fx_overdue

					$fetchDatalast[$key]['fx_overdue'] 		= $fetchDatalast[$key]['overdue'] / $m->fx_rate;

					// Night cal fx_ftm_due

					$fetchDatalast[$key]['fx_ftm_due'] 		= $fetchDatalast[$key]['ftm_due'] / $m->fx_rate;

					// Tenth cal fx_impact
					$fetchDatalast[$key]['fx_impact'] 		= (get_month_end_fx_rates($m->currency, $m->month_year) - $m->fx_rate) * $m->fx_balance_amount;

					// Eleven cal collection_days

					$fetchDatalast[$key]['collection_days'] 		= $this->get_number_of_days($fetchDatalast[$key]['planned_coll_date'], $fetchDatalast[$key]['actual_coll_date']);



					// Update the Process Data
					$this->db->where('daily_ar_id', $m->daily_ar_id);
					$this->db->set('process_data', 1);
					$this->db->update('daily_ar');
				}
			}


			if (!empty($fetchDatalast)) {

				$this->base_model->setBatchImportCurrentARProcessData($fetchDatalast);

				$this->base_model->importDataCurrentARProcessData();
			}




			//--------------- Excel Export ---------------------------//


			/* $list = $this->base_model->getCurrentARReportListForExcel($month_year);
			
			$this->load->library('Excel');
			ob_start();
			
			$objPHPExcel = new PHPExcel();
			$styleArray = array(
				'font' => array(
					'size' => 13,
					'name' => 'Roboto'
				)
			);
			$fontArray = array(
				'font' => array(
					'bold' => true,
					'size' => 11,
					'name' => 'Roboto'
				)
			);
			$dateArray = array(
				'font' => array(
					'bold' => true,
				)
			);
			$bgcolor = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'E7E7E7'),
				)
			);

			$bgcolorblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '66bfff'),
				)
			);

			$bgblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'ff0000'),
				)
			);

			$bgbrr = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '82b7da'),
				)
			);


			$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
				->setLastModifiedBy("Comprehensive School Management")
				->setTitle("Office  XLSX Test Document")
				->setSubject("Office XLSX Test Document")
				->setDescription("Test document for Office XLSX, generated by PHP classes.")
				->setKeywords("office openxml php")
				->setCategory("Excel Sheet");

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);

			$objPHPExcel->getActiveSheet(0)->getStyle('A1:AF1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


			$objPHPExcel->getActiveSheet()
				->getStyle('A')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('B')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('C')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('D')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('E')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('F')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('K')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()
				->getStyle('L')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()
				->getStyle('H')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('I')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('N')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				
			$objPHPExcel->getActiveSheet()
				->getStyle('M')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('O')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			$objPHPExcel->getActiveSheet()
				->getStyle('P')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

			$objPHPExcel->getActiveSheet()
				->getStyle('Q')
				->getAlignment()
				->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


			$objPHPExcel->getActiveSheet()->getStyle('A1:AF1')->applyFromArray($bgcolorblue);

			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
			$objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
			$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
			$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
			$objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Child_Code');
			$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Customer_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Project_Name');
			$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org_Document_Number');
			$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Invoice_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Rev_Due_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Invoice_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Paid_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Balance_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Currency');
			$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Fx_Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Planned_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Planned_Coll_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('T1', 'Retention');
			$objPHPExcel->getActiveSheet()->setCellValue('U1', 'Retention_Warranty');
			$objPHPExcel->getActiveSheet()->setCellValue('V1', 'Planned_RTN_WRTN_Coll_Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Planned_RTN_WRTN_Date');
			$objPHPExcel->getActiveSheet()->setCellValue('X1', 'PBG_LC');
			$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'WON');
			$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'CNAF');
			$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'SRN');
			$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'FOC');
			$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'WDS');
			$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'TDS');
			$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'LD');
			$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Legal');

			$c = '2';
			$count = '1';
			foreach ($list as $l) {

				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);

				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);

				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);

				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);

				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);

				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);

				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->child_code);

				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->customer_name);

				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->project_name);

				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_document_number);

				if ($l->invoice_date != '' or $l->invoice_date != '0000-00-00') {
					$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, date('d-M-Y', strtotime($l->invoice_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
				}

				if ($l->rev_due_date != '' or $l->rev_due_date != '0000-00-00') {
					$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
				} else {
					$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
				}

				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!i', $l->invoice_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!i', $l->paid_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!i', $l->balance_amount));

				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->currency);

				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!i', $l->fx_rate));

				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "");

				$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "");

				$c++;
				$count++;
			}

			ob_end_clean();

			$today = date('m-Y');
			
			$objPHPExcel->getActiveSheet()->setTitle('User Upload Template format v2');

			$objPHPExcel->setActiveSheetIndex(0);

			ob_clean();

			ob_end_flush();

			$filename = 'AR-' . $month_year . '.xlsx'; 
			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $filename . '"'); 
			
			header('Cache-Control: max-age=0');

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

			ob_end_clean();

			$path = $_SERVER['DOCUMENT_ROOT'] . "/upload/user_input_excels/" . $filename;
			
			$objWriter->save($path);
			// exit(); */
		}

		echo json_encode(1);
	}




	//---------- Collection Summary Report -------------------//

	public function CollectionSummaryReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$console_entity_id = $_POST['console_entity_id'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$denomination = $_POST['denomination'];

		$fx_type_id = $_POST['fx_type_id'];

		$region_id = $_POST['region_id'];


		$cluster_list = $this->base_model->getClusterMappingNames($sbu_id, $cluster_id, $vertical_id, $console_entity_id);


		$openModalFillData = "";

		if (!empty($cluster_list)) {
			foreach ($cluster_list as $clu) {

				$c_mon_AR = $this->base_model->getClusterwiseCollectionSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);


				$openModalFillData .= '<tr class="details' . $sbu_id . '" data-id="' . $clu->cluster_id . '' . $clu->sbu_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td class="details-control-chk"></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>' . get_cluster_name($clu->cluster_id) . '</td>';

				$openModalFillData .= '<td style="border-right: solid 6px #fff;">-</td>';

				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->bal / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_bal / $denomination) . '</td>';
				}


				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->overdue / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_overdue / $denomination) . '</td>';
				}


				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->ftm_due / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_ftm_due / $denomination) . '</td>';
				}

				if ($fx_type_id == 0) {

					$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->ftm_due;
				} elseif ($fx_type_id == 1) {

					$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->fx_ftm_due;
				}

				if ($notdue != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $notdue / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$tot_ret = $c_mon_AR->ret + $c_mon_AR->wret;

				if ($tot_ret != '') {
					$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >' . money_format('%!i', $tot_ret / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >0.00</td>';
				}

				$c_coll_plan = $this->base_model->getClusterCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->adv / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->col / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->od / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->ftm / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->not_due / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan->sam / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;">' . money_format('%!i', $c_coll_plan->rtn_w_rtn / $denomination) . '</td>';


				$c_actual_coll_plan = $this->base_model->getClusterActualCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_actual_coll_plan->adv / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_actual_coll_plan->col / $denomination) . '</td>';


				$c_od_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "OD", $region_id);

				if ($c_od_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_od_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$c_ftm_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "FTM", $region_id);


				if ($c_ftm_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_ftm_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$c_notdue_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "Not Due", $region_id);


				if ($c_notdue_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_notdue_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$same1 = $c_actual_coll_plan->col - $c_od_amt->actual_coll_amount - $c_ftm_amt->actual_coll_amount - $c_notdue_amt->actual_coll_amount;

				if ($same1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $same1 / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >0.00</td>';


				//--------- Percentage Calculation ---------------

				$per_adv = $c_actual_coll_plan->adv * 100 / $c_coll_plan->adv;

				if ($per_adv != 0 && !is_infinite($per_adv) && !is_nan($per_adv)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_adv, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_cols = $c_actual_coll_plan->col * 100 / $c_coll_plan->col;

				if ($per_cols != 0 && !is_infinite($per_cols) && !is_nan($per_cols)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_cols, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_ods = (($c_od_amt->actual_coll_amount * 100) / $c_coll_plan->od);

				if ($per_ods != 0 && !is_infinite($per_ods) && !is_nan($per_ods)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_ods, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_ftms = (($c_ftm_amt->actual_coll_amount * 100) / $c_coll_plan->ftm);

				if ($per_ftms != 0 && !is_infinite($per_ftms) && !is_nan($per_ftms)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_ftms, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_not_due = $c_notdue_amt->actual_coll_amount * 100 / $c_coll_plan->not_due;

				if ($per_not_due != 0 && !is_infinite($per_not_due) && !is_nan($per_not_due)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_not_due, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_same11 = $same1 * 100 / $c_coll_plan->sam;

				if ($per_same11 != 0 && !is_infinite($per_same11) && !is_nan($per_same11)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_same11, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

				$openModalFillData .= ' </tr>';


				$vertical_list = $this->base_model->getVerticleMappingClusterNames($sbu_id, $clu->cluster_id, $vertical_id, $console_entity_id);

				// print_r($this->db->last_query());die;

				if (!empty($vertical_list)) {
					foreach ($vertical_list as $ver) {

						$v_mon_AR = $this->base_model->getVerticalCollectionSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

						// $openModalFillData .= '<tr class="details' . $sbu_id . '" data-id="' . $ver->sbu_id . '' . $ver->vertical_id . '" style="background: #d4d5ff !important;">';

						$openModalFillData .= '<tr class="details_Project' . $sbu_id . ' details-chk' . $clu->cluster_id . '' . $clu->sbu_id . ' display-none" style="background: #f3f3f3 !important;">';

						$openModalFillData .= '<td></td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td style="border-right: solid 6px #fff;">' . get_vertical_name($ver->vertical_id) . '</td>';

						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->bal / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_bal / $denomination) . '</td>';
						}


						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->overdue / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_overdue / $denomination) . '</td>';
						}


						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->ftm_due / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_ftm_due / $denomination) . '</td>';
						}

						if ($fx_type_id == 0) {

							$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->ftm_due;
						} elseif ($fx_type_id == 1) {

							$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->fx_ftm_due;
						}



						if ($notdue != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $notdue / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}

						$tot_ret = $v_mon_AR->ret + $v_mon_AR->wret;

						if ($tot_ret != '') {
							$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >' . money_format('%!i', $tot_ret / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';
						}



						$v_coll_plan = $this->base_model->getVerticalCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id);

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->adv / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->col / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->od / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->ftm / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->not_due / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan->sam / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;">' . money_format('%!i', $v_coll_plan->rtn_w_rtn / $denomination) . '</td>';


						$v_actual_coll_plan = $this->base_model->getVerticalActualCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

						$openModalFillData .= '<td style="text-align:right !important; ">' . money_format('%!i', $v_actual_coll_plan->adv / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_actual_coll_plan->col / $denomination) . '</td>';


						$v_od_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "OD", $region_id);


						if ($v_od_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_od_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_ftm_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM", $region_id);


						if ($v_ftm_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_ftm_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_notdue_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due", $region_id);


						if ($v_notdue_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_notdue_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_same = $v_actual_coll_plan->col - $v_od_amt->actual_coll_amount - $v_ftm_amt->actual_coll_amount - $v_notdue_amt->actual_coll_amount;

						if ($v_same != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_same / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

						//--------- Percentage Calculation ---------------

						$v_per_adv = $v_actual_coll_plan->adv * 100 / $v_coll_plan->adv;

						if ($v_per_adv != 0 && !is_infinite($v_per_adv) && !is_nan($v_per_adv)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_adv, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_col = $v_actual_coll_plan->col * 100 / $v_coll_plan->col;

						if ($v_per_col != 0 && !is_infinite($v_per_col) && !is_nan($v_per_col)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_col, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_od = $v_od_amt->actual_coll_amount * 100 / $v_coll_plan->od;

						if ($v_per_od != 0 && !is_infinite($v_per_od) && !is_nan($v_per_od)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_od, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_ftm = $v_ftm_amt->actual_coll_amount * 100 / $v_coll_plan->ftm;

						if ($v_per_ftm != 0 && !is_infinite($v_per_ftm) && !is_nan($v_per_ftm)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_ftm, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_not_due = $v_notdue_amt->actual_coll_amount * 100 / $v_coll_plan->not_due;

						if ($v_per_not_due != 0 && !is_infinite($v_per_not_due) && !is_nan($v_per_not_due)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_not_due, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_same11 = $v_same * 100 / $v_coll_plan->sam;

						if ($v_per_same11 != 0 && !is_infinite($v_per_same11) && !is_nan($v_per_same11)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_same11, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

						$openModalFillData .= ' </tr>';
					}
				}
			}
		}

		$resultData['openModalFillData'] = $openModalFillData;
		echo json_encode($resultData['openModalFillData']);
	}

	function month_end_ar_reports_excel()
	{


		if ($this->input->post('month_year')) {

			if (!$this->ion_auth->is_admin()) {
				$vertical_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			} else {
				$vertical_id = '';
				$month_year = $this->input->post('month_year');
			}

			$list = $this->base_model->getMonthEndReportListForExcelMapping($month_year, $vertical_id);


			//load PHPExcel library
			$this->load->library('Excel');
			ob_start();
			// Create new PHPExcel object
			$objPHPExcel = new PHPExcel();
			$styleArray = array(
				'font' => array(
					'size' => 13,
					'name' => 'Roboto'
				)
			);
			$fontArray = array(
				'font' => array(
					'bold' => true,
					'size' => 11,
					'name' => 'Roboto'
				)
			);
			$dateArray = array(
				'font' => array(
					'bold' => true,
				)
			);
			$bgcolor = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'E7E7E7'),
				)
			);

			$bgcolorblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '66bfff'),
				)
			);

			$bgblue = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'ff0000'),
				)
			);

			$bgbrr = array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '82b7da'),
				)
			);



			// Set document properties
			$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
				->setLastModifiedBy("Comprehensive School Management")
				->setTitle("Office  XLSX Test Document")
				->setSubject("Office XLSX Test Document")
				->setDescription("Test document for Office XLSX, generated by PHP classes.")
				->setKeywords("office openxml php")
				->setCategory("Excel Sheet");


			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);

			$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AY')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('AZ')->setWidth(20);

			$objPHPExcel->getActiveSheet()->getColumnDimension('BA')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BB')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BC')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BD')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BE')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BF')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BG')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BH')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BI')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BJ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BK')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BL')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BM')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BN')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BO')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BP')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BQ')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BR')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BS')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BT')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('BU')->setWidth(20);

			$objPHPExcel->getActiveSheet(0)->getStyle('A1:BU1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$objPHPExcel->getActiveSheet(0)->getStyle('A:BU')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			$objPHPExcel->getActiveSheet()->getStyle('A1:BU1')->applyFromArray($bgcolorblue);

			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol Entity');
			$objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
			$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
			$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
			$objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR Type');
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'Consol');
			$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Area');
			$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Region');
			$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org DPST');
			$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Org TT');
			$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Month');
			$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Sales Engg Code');
			$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Sales Engg Name');
			$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Customer Group');
			$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Parent Code');
			$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Child Code');
			$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Customer Name');
			$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Project Name');
			$objPHPExcel->getActiveSheet()->setCellValue('T1', 'PO Number');
			$objPHPExcel->getActiveSheet()->setCellValue('U1', 'PO Credit Term');
			$objPHPExcel->getActiveSheet()->setCellValue('V1', 'Company');
			$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Invoice Number');
			$objPHPExcel->getActiveSheet()->setCellValue('X1', 'Org. Document Number');
			$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'Dispatch Date');
			$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'Invoice Date');


			$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'Credit Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'Due Date');
			$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'Credit Days Adj');
			$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'Rev Due Date');

			$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Balance Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AH1', 'Currency');

			$objPHPExcel->getActiveSheet()->setCellValue('AI1', 'FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AJ1', 'FX Invoice Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AK1', 'FX Paid Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('AL1', 'FX Balance Amount');

			$objPHPExcel->getActiveSheet()->setCellValue('AM1', 'Customer Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AN1', 'ECL Category');
			$objPHPExcel->getActiveSheet()->setCellValue('AO1', 'ECL RTN Days');
			$objPHPExcel->getActiveSheet()->setCellValue('AP1', 'FEMA Days');

			$objPHPExcel->getActiveSheet()->setCellValue('AQ1', 'Current Mth FX Rate');
			$objPHPExcel->getActiveSheet()->setCellValue('AR1', 'Modified Doc');
			$objPHPExcel->getActiveSheet()->setCellValue('AS1', 'Invoice Type');
			$objPHPExcel->getActiveSheet()->setCellValue('AT1', 'OD Days');

			$objPHPExcel->getActiveSheet()->setCellValue('AU1', 'Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AV1', 'Overdue');
			$objPHPExcel->getActiveSheet()->setCellValue('AW1', 'FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AX1', 'OD Ageing Category');

			$objPHPExcel->getActiveSheet()->setCellValue('AY1', 'FX Within Due');
			$objPHPExcel->getActiveSheet()->setCellValue('AZ1', 'FX Over Due');


			$objPHPExcel->getActiveSheet()->setCellValue('BA1', 'FX FTM Due');
			$objPHPExcel->getActiveSheet()->setCellValue('BB1', 'FX Impact');
			$objPHPExcel->getActiveSheet()->setCellValue('BC1', 'Collection Days');
			$objPHPExcel->getActiveSheet()->setCellValue('BD1', 'Responsibity');

			$objPHPExcel->getActiveSheet()->setCellValue('BE1', 'Planned Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BF1', 'Planned Coll Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BG1', 'Retention');
			$objPHPExcel->getActiveSheet()->setCellValue('BH1', 'Warranty Retention');

			$objPHPExcel->getActiveSheet()->setCellValue('BI1', 'Planned RTN/WTN Coll Amount');
			$objPHPExcel->getActiveSheet()->setCellValue('BJ1', 'Planned RTN/WTN Coll Date');
			$objPHPExcel->getActiveSheet()->setCellValue('BK1', 'WON');
			$objPHPExcel->getActiveSheet()->setCellValue('BL1', 'LD');

			$objPHPExcel->getActiveSheet()->setCellValue('BM1', 'Legal');
			$objPHPExcel->getActiveSheet()->setCellValue('BN1', 'PBG_LC');
			$objPHPExcel->getActiveSheet()->setCellValue('BO1', 'CNAF');
			$objPHPExcel->getActiveSheet()->setCellValue('BP1', 'SRN');

			$objPHPExcel->getActiveSheet()->setCellValue('BQ1', 'FOC');
			$objPHPExcel->getActiveSheet()->setCellValue('BR1', 'WDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BS1', 'TDS');
			$objPHPExcel->getActiveSheet()->setCellValue('BT1', 'Actual Coll Amount');

			$objPHPExcel->getActiveSheet()->setCellValue('BU1', 'Actual Coll Date');


			$c = '2';
			$count = '1';
			foreach ($list as $l) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->consol);
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->area);
				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->region);
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_dpst);
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, $l->org_tt);
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, $l->month);
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, $l->sales_engg_code);
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, $l->sales_engg_name);
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, $l->customer_group);
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->parent_code);
				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, $l->child_node);
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, $l->customer_name);
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, $l->project_name);
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, $l->po_name);
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, $l->po_credit_term);
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, $l->company);
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, $l->invoice_number);
				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, $l->org_document_number);
				$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, $l->dispatch_date);
				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, $l->invoice_date);

				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, $l->credit_days);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, $l->due_date);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, $l->credit_days_adj);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, $l->rev_due_date);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, $l->invoice_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, $l->paid_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, $l->balance_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AH' . $c, $l->currency);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AI' . $c, $l->fx_rate);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AJ' . $c, $l->fx_invoice_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AK' . $c, $l->fx_paid_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AL' . $c, $l->fx_balance_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AM' . $c, $l->customer_type);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AN' . $c, $l->ecl_category);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AO' . $c, $l->ecl_days);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AP' . $c, $l->fema_days);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AQ' . $c, $l->current_mth_fx_rate);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AR' . $c, $l->modified_doc);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AS' . $c, $l->invoice_type);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AT' . $c, $l->od_days);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AU' . $c, $l->within_due);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AV' . $c, $l->overdue);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AW' . $c, $l->ftm_due);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AX' . $c, $l->od_ageing_category);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AY' . $c, $l->fx_within_due);
				$objPHPExcel->getActiveSheet(0)->setCellValue('AZ' . $c, $l->fx_over_due);

				$objPHPExcel->getActiveSheet(0)->setCellValue('BA' . $c, $l->fx_ftm_due);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BB' . $c, $l->fx_impact);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BC' . $c, $l->collection_days);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BD' . $c, $l->responsibility);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BE' . $c, $l->planned_coll_amt);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BF' . $c, $l->planned_coll_date);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BG' . $c, $l->retention);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BH' . $c, $l->warranty_retention);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BI' . $c, $l->planned_rtn_wrtn_coll_amt);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BJ' . $c, $l->planned_rtn_wrtn_date);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BK' . $c, $l->won);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BL' . $c, $l->ld);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BM' . $c, $l->legal);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BN' . $c, $l->pbg_lc);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BO' . $c, $l->cnaf);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BP' . $c, $l->srn);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BQ' . $c, $l->foc);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BR' . $c, $l->wds);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BS' . $c, $l->tds);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BT' . $c, $l->actual_coll_amount);
				$objPHPExcel->getActiveSheet(0)->setCellValue('BU' . $c, $l->actual_coll_date);
				$c++;
				$count++;
			}

			ob_end_clean();
			$today = date('m-Y');
			// Rename worksheet (worksheet, not filename)
			$objPHPExcel->getActiveSheet()->setTitle('Month AR Excel');
			// Set active sheet index to the first sheet, so Excel opens this as the first sheet
			$objPHPExcel->setActiveSheetIndex(0);
			// Redirect output to a client’s web browser (Excel2007)
			$filename = 'Month-End-AR-Report-' . $month_year . '.xlsx'; //save our workbook as this file name
			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
			header('Cache-Control: max-age=0');
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
		}
	}

	function check_cron_status()
	{
		$monthYear = trim($this->input->post('monthYear'));
		$cron_type = trim($this->input->post('cron_type'));

		$month_check = $this->db->query("select * from cron_table where cron_type='" . $cron_type . "' and 
		month='" . $monthYear . "'")->row();

		if (count($month_check) >= 1) {
			$month_end_array = $this->db->query("select * from cron_table where cron_type='" . $cron_type . "' and 
		month='" . $monthYear . "' and cron_status ='1' and process_data ='1'")->row();

			if (count($month_end_array) >= 1) {
				/* display in process */
				echo '1';
			} else {
				/* display month */
				echo '0';
			}
		} else {
			echo '2';
		}
	}


	public function user_input_check()
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		$month_year = $this->input->post('month_year');

		// $val = base_url('upload/user_input_excels/AR-'.$month_year .'.xlsx');

		$val = $_SERVER['DOCUMENT_ROOT'] . '/upload/elgi_month_end_ar/Month End AR Report-' . $month_year . '.xlsx';

		if (file_exists($val)) {
			echo json_encode(1);
		} else {
			echo json_encode(0);
		}
	}

	public function cron_type_validation()
	{
		$month_year = trim($this->input->post('month_year'));
		$cron_type = trim($this->input->post('cron_type'));

		$month_check = $this->db->query("select * from cron_table where cron_type='" . $cron_type . "' and 
		month='" . $month_year . "'")->row();

		if (count($month_check) >= 1) {
			$cron_status = $this->db->query("select * from cron_table where cron_type='" . $cron_type . "' and 
		month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

			if (count($cron_status) >= 1) {
				echo '1';
			} else {
				echo '0';
			}
		} else {
			echo '2';
		}
	}


	public function coll_performance_cust($param = '')
	{
		if ($this->ion_auth->is_admin()) {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} elseif ($this->ion_auth->is_user()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}

			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();
			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		if ($param == "search") {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
				$this->data['month_year'] = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
				$this->data['month_year'] = $month_year;
			}

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}


			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $this->input->post("ar_type_id");
			}

			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $this->input->post("consol_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $this->input->post("country_id");
			}

			if ($this->input->post("denomination") != '') {
				$this->data['denomination'] = $this->input->post("denomination");
			} else {
				$this->data['denomination'] = 1;
			}

			$this->data['top_15_collection_performance_customer'] = $this->base_model->top_15_collection_performance_customerAll($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);
		} else {

			$this->data['top_15_collection_performance_customer'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/coll_performance_cust');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/coll_performance_cust', $this->data);
	}

	public function coll_performance_resp($param = '')
	{
		if ($this->ion_auth->is_admin()) {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} elseif ($this->ion_auth->is_user()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}

			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();
			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		if ($param == "search") {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
				$this->data['month_year'] = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
				$this->data['month_year'] = $month_year;
			}

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}


			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $this->input->post("ar_type_id");
			}

			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $this->input->post("consol_id");
			}

			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $this->input->post("country_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			if ($this->input->post("denomination") != '') {
				$this->data['denomination'] = $this->input->post("denomination");
			} else {
				$this->data['denomination'] = 1;
			}

			$this->data['top_15_collection_performance_responsibility'] = $this->base_model->top_15_collection_performance_responsibilityAll($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);
		} else {

			$this->data['top_15_collection_performance_responsibility'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/coll_performance_resp');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/coll_performance_resp', $this->data);
	}


	public function coll_performance_sum($param = '')
	{
		if ($this->ion_auth->is_admin()) {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} elseif ($this->ion_auth->is_user()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}

			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();
			$this->data['console_master'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['cluster_master'] 	= $this->db->query("select * from cluster_master order by position")->result();
			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['console_master'] 	= $this->db->query("select * from console_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		if ($param != '') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
				$this->data['month_year'] = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
				$this->data['month_year'] = $month_year;
			}

			if ($this->input->post("sbu_id") != '') {
				$sbu_id = $this->input->post("sbu_id");
				$this->data['sbu_id'] = $this->input->post("sbu_id");
			}

			if ($this->input->post("cluster_id") != '') {
				$cluster_id = $this->input->post("cluster_id");
				$this->data['cluster_id'] = $cluster_id;
			}

			if ($this->input->post("vertical_id") != '') {
				$vertical_id = $this->input->post("vertical_id");
				$this->data['vertical_id'] = $this->input->post("vertical_id");
			}


			if ($this->input->post("ar_type_id") != '') {
				$ar_type_id = $this->input->post("ar_type_id");
				$this->data['ar_type_id'] = $this->input->post("ar_type_id");
			}

			if ($this->input->post("consol_id") != '') {
				$consol_id = $this->input->post("consol_id");
				$this->data['consol_id'] = $this->input->post("consol_id");
			}

			if ($this->input->post("region_id") != '') {
				$region_id = $this->input->post("region_id");
				$this->data['region_id'] = $this->input->post("region_id");
			}

			if ($this->input->post("country_id") != '') {
				$country_id = $this->input->post("country_id");
				$this->data['country_id'] = $this->input->post("country_id");
			}

			if ($this->input->post("denomination") != '') {
				$this->data['denomination'] = $this->input->post("denomination");
			} else {
				$this->data['denomination'] = 1;
			}

			$this->data['top_15_collection_performance'] = $this->base_model->getCollectionPerformancesummaryAll($month_year, $sbu_id, $cluster_id, $vertical_id, $consol_id, $country_id, $ar_type_id, $region_id);
		} else {

			$this->data['top_15_collection_performance'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/coll_performance_sum');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/coll_performance_sum', $this->data);
	}

	public function coll_performance_sum_ajax()
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
			redirect('auth/login', 'refresh');
		}

		// POST data
		$postData = $this->input->post();
		// Get data
		$data = $this->Ajax_model->coll_performance_sum_ajaxdata($postData);

		echo json_encode($data);
	}

	public function user_input_DailyCollection_for_table()
	{
		// Insert process_pending_list Data 

		$process_data_list = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'month' => $this->input->post('month_year')))->result();

		if (count($process_data_list) > 0) {

			$this->db->set("user_input_start_status", 0);
			$this->db->set("user_input_end_status", 0);
			$this->db->where("month", $this->input->post('month_year'));
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');
		}

		echo json_encode(1);
	}

	public function user_input_excel_for_table()
	{
		// Insert process_pending_list Data 

		$process_data_list = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'month' => $this->input->post('month_year'), 'cron_status' => 1, 'process_data' => 1))->result();

		if (count($process_data_list) > 0) {

			$this->db->set("user_input_excel", 0);
			$this->db->set("user_input_start_excel", 0);
			$this->db->where("month", $this->input->post('month_year'));
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');
		}

		echo json_encode(1);
	}

	public function month_end_ar_excel_for_table()
	{
		// Insert process_pending_list Data 

		$process_data_list = $this->db->get_where('cron_table', array('cron_type' => 'month_end_ar', 'month' => $this->input->post('month_year'), 'cron_status' => 1, 'process_data' => 1))->result();

		if (count($process_data_list) > 0) {

			$this->db->set("excel_report", 0);
			$this->db->set("excel_start_report", 0);
			$this->db->where("month", $this->input->post('month_year'));
			$this->db->where("cron_type", "month_end_ar");
			$this->db->update('cron_table');
		}

		echo json_encode(1);
	}

	function exchange_impact_report_excel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;



		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}

		if ($this->input->post("console_entity_id") != '') {
			$console_entity_id = explode(',', $this->input->post("console_entity_id"));
			$this->data['console_entity_id'] = implode(',', $this->input->post("console_entity_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}

		$vertical_list = $this->base_model->getVerticleMappingCluster($sbu_id, $cluster_id, $vertical_id, $console_entity_id);


		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);

		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'E7E7E7'),
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '66bfff'),
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ff0000'),
			)
		);

		$bgbrr = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '82b7da'),
			)
		);



		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', ' - Exchange Impact Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);

		$objPHPExcel->getActiveSheet(0)->getStyle('A1:E1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


		$objPHPExcel->getActiveSheet()
			->getStyle('A')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('B')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('C')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('D')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('E')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


		// Add some data

		$objPHPExcel->getActiveSheet()->getStyle('A4:E4')->applyFromArray($bgcolorblue);



		$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Consol_Entity');
		$objPHPExcel->getActiveSheet()->setCellValue('B4', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Fx Impact');

		$c = '5';
		foreach ($vertical_list as $l) {

			if (!empty($l->console_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, get_console_name($l->console_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
			}

			if (!empty($l->sbu_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, get_sbu_name($l->sbu_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
			}

			if (!empty($l->cluster_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, get_cluster_name($l->cluster_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
			}


			$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "-");

			$fx_impact = $this->base_model->getARSummaryByARTypeReportFxImpact($month_year, $sbu_id, $l->cluster_id, $vertical_id, $console_entity_id, $region_id);


			if (!empty($fx_impact)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $fx_impact / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "0.00");
			}


			$vertical_listsss = $this->base_model->getVerticleMappingClusterss($sbu_id, $l->cluster_id, $vertical_id, $console_entity_id);


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}

			// print_r($c);die;

			if (!empty($vertical_listsss)) {
				foreach ($vertical_listsss as $ver) {

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

					if (!empty($l->cluster_id)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, get_vertical_name($ver->vertical_id));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "NA");
					}

					$verticalFxImpact = $this->base_model->getARSummaryByARTypeReportVerticalFxImpact($month_year, $sbu_id, $l->cluster_id, $ver->vertical_id, $console_entity_id, $region_id);

					if (!empty($verticalFxImpact)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $verticalFxImpact / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "0.00");
					}


					$D++;
				}
			}

			$c = $D;

			$c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Exchange Impact Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Exchange Impact Report -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
	}


	function trade_ar_summary_report_excel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;

		if ($this->input->post("fx_type_id") != '') {
			$fx_type_id = $this->input->post("fx_type_id");
		} else {
			$fx_type_id = '0';
		}

		$this->data['fx_type_id'] = $fx_type_id;



		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("console_id") != '') {
			$console_id = explode(',', $this->input->post("console_id"));
			$this->data['console_id'] = implode(',', $this->input->post("console_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}



		// print_r($this->input->post("console_id"));die;

		$vertical_list = $this->base_model->getVerticleMappingCluster($sbu_id, $cluster_id, $vertical_id, $console_id);

		// print_r($this->db->last_query());die;


		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);

		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'E7E7E7'),
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '66bfff'),
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ff0000'),
			)
		);

		$bgbrr = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '82b7da'),
			)
		);



		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', ' - Trade AR Summary Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);

		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);

		$objPHPExcel->getActiveSheet(0)->getStyle('A1:X1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


		$objPHPExcel->getActiveSheet()
			->getStyle('A')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('B')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('C')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('D')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('E:X')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);


		// Add some data

		$objPHPExcel->getActiveSheet()->getStyle('A4:X4')->applyFromArray($bgcolorblue);



		$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Consol_Entity');
		$objPHPExcel->getActiveSheet()->setCellValue('B4', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Total AR');
		$objPHPExcel->getActiveSheet()->setCellValue('F4', 'Within Due');
		$objPHPExcel->getActiveSheet()->setCellValue('G4', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('H4', 'Retention');
		$objPHPExcel->getActiveSheet()->setCellValue('I4', 'Warrenty RET');
		$objPHPExcel->getActiveSheet()->setCellValue('J4', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('K4', '0 to 360');
		$objPHPExcel->getActiveSheet()->setCellValue('L4', '361 - 720');
		$objPHPExcel->getActiveSheet()->setCellValue('M4', '721 - 1080');
		$objPHPExcel->getActiveSheet()->setCellValue('N4', '> 1081');

		$objPHPExcel->getActiveSheet()->setCellValue('O4', 'WON');
		$objPHPExcel->getActiveSheet()->setCellValue('P4', 'LD');
		$objPHPExcel->getActiveSheet()->setCellValue('Q4', 'LEGAL');
		$objPHPExcel->getActiveSheet()->setCellValue('R4', 'PBG_LC');
		$objPHPExcel->getActiveSheet()->setCellValue('S4', 'CNAF');
		$objPHPExcel->getActiveSheet()->setCellValue('T4', 'SRN');
		$objPHPExcel->getActiveSheet()->setCellValue('U4', 'FOC');
		$objPHPExcel->getActiveSheet()->setCellValue('V4', 'WDS');
		$objPHPExcel->getActiveSheet()->setCellValue('W4', 'GST TDS');
		$objPHPExcel->getActiveSheet()->setCellValue('X4', 'TDS');


		$c = '5';
		foreach ($vertical_list as $l) {

			if (!empty($l->console_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, get_console_name($l->console_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
			}

			if (!empty($l->sbu_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, get_sbu_name($l->sbu_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
			}

			if (!empty($l->cluster_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, get_cluster_name($l->cluster_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
			}


			$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "-");


			$data_list = $this->base_model->getTradeARSummaryReport($month_year, $sbu_id, $l->cluster_id, $vertical_id, $console_id, $region_id)[0];

			if ($fx_type_id == 0) {
				$balance_amt = $data_list->bal / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $balance_amt));
			} elseif ($fx_type_id == 1) {
				$balance_amt = $data_list->fx_bal / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $balance_amt));
			}


			if ($fx_type_id == 0) {
				$within_due = $data_list->within_due / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $within_due));
			} elseif ($fx_type_id == 1) {
				$fx_within_due = $data_list->fx_within_due / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $fx_within_due));
			}


			$fx_ftm_due = $data_list->fx_ftm_due / $denomination;
			$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, money_format('%!n', $fx_ftm_due));

			$retention = $data_list->retention / $denomination;
			$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, money_format('%!n', $retention));

			$war_ret = $data_list->war_ret / $denomination;
			$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, money_format('%!n', $war_ret));


			if ($fx_type_id == 0) {
				$overdue = $data_list->overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, money_format('%!n', $overdue));
			} elseif ($fx_type_id == 1) {
				$fx_overdue = $data_list->fx_overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, money_format('%!n', $fx_overdue));
			}

			$out_amt = $this->base_model->getODdaysAmt($month_year, $sbu_id, $l->cluster_id, $vertical_id, 0, 360, $console_id, $region_id)[0];

			if ($fx_type_id == 0) {
				$overdue1 = $out_amt->overdue1 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, money_format('%!n', $overdue1));
			} elseif ($fx_type_id == 1) {
				$fx_overdue1 = $out_amt->fx_overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, money_format('%!n', $fx_overdue1));
			}

			$out_amt1 = $this->base_model->getODdaysAmt($month_year, $sbu_id, $l->cluster_id, $vertical_id, 361, 720, $console_id, $region_id)[0];

			if ($fx_type_id == 0) {
				$overdue1 = $out_amt1->overdue1 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, money_format('%!n', $overdue1));
			} elseif ($fx_type_id == 1) {
				$fx_overdue1 = $out_amt1->fx_overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, money_format('%!n', $fx_overdue1));
			}

			$out_amt2 = $this->base_model->getODdaysAmt($month_year, $sbu_id, $l->cluster_id, $vertical_id, 721, 1080, $console_id, $region_id)[0];

			if ($fx_type_id == 0) {
				$overdue1 = $out_amt2->overdue1 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!n', $overdue1));
			} elseif ($fx_type_id == 1) {
				$fx_overdue1 = $out_amt2->fx_overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!n', $fx_overdue1));
			}


			$out_amt3 = $this->base_model->getODdaysAmt($month_year, $sbu_id, $l->cluster_id, $vertical_id, '', 1081, $console_id, $region_id)[0];

			if ($fx_type_id == 0) {
				$overdue1 = $out_amt3->overdue1 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!n', $overdue1));
			} elseif ($fx_type_id == 1) {
				$fx_overdue1 = $out_amt3->fx_overdue / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!n', $fx_overdue1));
			}


			$Noncollectible = $this->base_model->getNonCollectableAmt($month_year, $sbu_id, $l->cluster_id, $vertical_id, $console_id, $region_id)[0];


			$clu_won = $Noncollectible->won / $denomination;
			if ($clu_won != '' && $clu_won != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!n', $clu_won));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "0");
			}


			$clu_ld = $Noncollectible->ld / $denomination;
			if ($clu_ld != '' && $clu_ld != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, money_format('%!n', $clu_ld));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "0");
			}

			$clu_legal = $Noncollectible->legal / $denomination;
			if ($clu_legal != '' && $clu_legal != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!n', $clu_legal));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "0");
			}


			$clu_pbg_lc = $Noncollectible->pbg_lc / $denomination;
			if ($clu_pbg_lc != '' && $clu_pbg_lc != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!n', $clu_pbg_lc));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "0");
			}

			$clu_cnaf = $Noncollectible->pbg_lc / $denomination;
			if ($clu_cnaf != '' && $clu_cnaf != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, money_format('%!n', $clu_cnaf));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "0");
			}

			$clu_srn = $Noncollectible->srn / $denomination;
			if ($clu_srn != '' && $clu_srn != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!n', $clu_srn));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "0");
			}

			$clu_foc = $Noncollectible->foc / $denomination;
			if ($clu_foc != '' && $clu_foc != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!n', $clu_foc));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "0");
			}

			$clu_wds = $Noncollectible->wds / $denomination;
			if ($clu_wds != '' && $clu_wds != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!n', $clu_wds));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "0");
			}

			$clu_gst_tds = $Noncollectible->gst_tds / $denomination;
			if ($clu_gst_tds != '' && $clu_gst_tds != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, money_format('%!n', $clu_gst_tds));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "0");
			}

			$clu_tds = $Noncollectible->tds / $denomination;
			if ($clu_tds != '' && $clu_tds != 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, money_format('%!n', $clu_tds));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "0");
			}



			$vertical_listsss = $this->base_model->getVerticleMappingClusterss($sbu_id, $l->cluster_id, $vertical_id, $console_id);


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}


			if (!empty($vertical_listsss)) {
				foreach ($vertical_listsss as $ver) {

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

					if (!empty($l->cluster_id)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, get_vertical_name($ver->vertical_id));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "NA");
					}


					$vertical_data = $this->base_model->getTradeARSummaryReportVertical($month_year, $sbu_id, $l->cluster_id, $ver->vertical_id, $console_id, $region_id)[0];


					if ($fx_type_id == 0) {

						$ver_balance_amt = $vertical_data->bal / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $ver_balance_amt));
					} elseif ($fx_type_id == 1) {

						$ver_balance_amt = $vertical_data->fx_bal / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $ver_balance_amt));
					}


					if ($fx_type_id == 0) {

						$within_due = $vertical_data->within_due / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $within_due));
					} elseif ($fx_type_id == 1) {

						$fx_within_due = $vertical_data->fx_within_due / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $fx_within_due));
					}



					$fx_ftm_due = $vertical_data->fx_ftm_due / $denomination;
					$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, money_format('%!n', $fx_ftm_due));


					$retention = $vertical_data->retention / $denomination;
					$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, money_format('%!n', $retention));

					$war_ret = $vertical_data->war_ret / $denomination;
					$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, money_format('%!n', $war_ret));


					if ($fx_type_id == 0) {

						$overdue = $vertical_data->overdue / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $D, money_format('%!n', $overdue));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $vertical_data->fx_overdue / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $D, money_format('%!n', $fx_overdue));
					}


					$out_amt1 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $ver->cluster_id, $ver->vertical_id, 0, 360, $console_id, $region_id)[0];

					if ($fx_type_id == 0) {

						$overdue = $out_amt1->overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, money_format('%!n', $overdue));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $out_amt1->fx_overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, money_format('%!n', $fx_overdue));
					}


					$out_amt2 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $ver->cluster_id, $ver->vertical_id, 361, 720, $console_id, $region_id)[0];

					if ($fx_type_id == 0) {

						$overdue = $out_amt2->overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, money_format('%!n', $overdue));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $out_amt2->fx_overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, money_format('%!n', $fx_overdue));
					}


					$out_amt3 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $ver->cluster_id, $ver->vertical_id, 721, 1080, $console_id, $region_id)[0];

					if ($fx_type_id == 0) {

						$overdue = $out_amt3->overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, money_format('%!n', $overdue));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $out_amt3->fx_overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, money_format('%!n', $fx_overdue));
					}

					$out_amt4 = $this->base_model->getODdaysAmtVertical($month_year, $sbu_id, $ver->cluster_id, $ver->vertical_id, '', 1081, $console_id, $region_id)[0];

					if ($fx_type_id == 0) {

						$overdue = $out_amt4->overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, money_format('%!n', $overdue));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $out_amt4->fx_overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, money_format('%!n', $fx_overdue));
					}


					$nonCollectable_amt = $this->base_model->getNonCollectableAmtVertical($month_year, $sbu_id, $ver->cluster_id, $ver->vertical_id, $console_id, $region_id)[0];

					$ver_won = $nonCollectable_amt->won / $denomination;
					if ($ver_won != '' && $ver_won != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $D, money_format('%!n', $ver_won));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $D, "0");
					}

					$ver_ld = $nonCollectable_amt->ld / $denomination;
					if ($ver_ld != '' && $ver_ld != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, money_format('%!n', $ver_ld));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, "0");
					}


					$ver_legal = $nonCollectable_amt->legal / $denomination;
					if ($ver_legal != '' && $ver_legal != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $D, money_format('%!n', $ver_legal));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $D, "0");
					}

					$ver_pbg_lc = $nonCollectable_amt->pbg_lc / $denomination;
					if ($ver_pbg_lc != '' && $ver_pbg_lc != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, money_format('%!n', $ver_pbg_lc));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, "0");
					}

					$ver_cnaf = $nonCollectable_amt->cnaf / $denomination;
					if ($ver_cnaf != '' && $ver_cnaf != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, money_format('%!n', $ver_cnaf));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, "0");
					}


					$ver_srn = $nonCollectable_amt->srn / $denomination;
					if ($ver_srn != '' && $ver_srn != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, money_format('%!n', $ver_srn));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, "0");
					}

					$ver_foc = $nonCollectable_amt->foc / $denomination;
					if ($ver_foc != '' && $ver_foc != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, money_format('%!n', $ver_foc));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, "0");
					}

					$ver_wds = $nonCollectable_amt->wds / $denomination;
					if ($ver_wds != '' && $ver_wds != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, money_format('%!n', $ver_wds));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, "0");
					}

					$ver_gst_tds = $nonCollectable_amt->gst_tds / $denomination;
					if ($ver_gst_tds != '' && $ver_gst_tds != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, money_format('%!n', $ver_gst_tds));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, "0");
					}

					$ver_tds = $nonCollectable_amt->tds / $denomination;
					if ($ver_tds != '' && $ver_tds != 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $D, money_format('%!n', $ver_tds));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $D, "0");
					}

					/* 	$total_non_collectable =  $Noncollectible->won + $Noncollectible->ld + $Noncollectible->legal + $Noncollectible->pbg_lc + $Noncollectible->cnaf + $Noncollectible->srn + $Noncollectible->foc + $Noncollectible->wds + $Noncollectible->gst_tds + $Noncollectible->tds ; */


					$D++;
				}
			}

			$c = $D;

			$c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Trade AR Summary Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Trade AR Summary Report -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
	}



	function export_invoice_fema_report_excel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;

		if ($this->input->post("fx_type_id") != '') {
			$fx_type_id = $this->input->post("fx_type_id");
		} else {
			$fx_type_id = '0';
		}

		$this->data['fx_type_id'] = $fx_type_id;


		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}

		if ($this->input->post("console_entity_id") != '') {
			$console_entity_id = explode(',', $this->input->post("console_entity_id"));
			$this->data['console_entity_id'] = implode(',', $this->input->post("console_entity_id"));
		}

		if ($this->input->post("ar_type_id") != '') {
			$ar_type_id = explode(',', $this->input->post("ar_type_id"));
			$this->data['ar_type_id'] = implode(',', $this->input->post("ar_type_id"));
		}

		if ($this->input->post("country_id") != '') {
			$country_id = explode(',', $this->input->post("country_id"));
			$this->data['country_id'] = implode(',', $this->input->post("country_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}




		$vertical_list = $this->base_model->getVerticleMappingClusterCurrency($sbu_id, $cluster_id, $vertical_id, $console_entity_id);


		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);

		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'E7E7E7'),
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '66bfff'),
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ff0000'),
			)
		);

		$bgbrr = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '82b7da'),
			)
		);



		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', ' - Exchange Impact Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);

		$objPHPExcel->getActiveSheet(0)->getStyle('A1:I1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


		$objPHPExcel->getActiveSheet()
			->getStyle('A:G')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		$objPHPExcel->getActiveSheet()
			->getStyle('H:I')
			->getAlignment()
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

		// Add some data

		$objPHPExcel->getActiveSheet()->getStyle('A4:I4')->applyFromArray($bgcolorblue);



		$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Consol_Entity');
		$objPHPExcel->getActiveSheet()->setCellValue('B4', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Org Document Number');
		$objPHPExcel->getActiveSheet()->setCellValue('F4', 'Child Code');
		$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Customer Number');
		$objPHPExcel->getActiveSheet()->setCellValue('H4', 'FEMA Days');
		$objPHPExcel->getActiveSheet()->setCellValue('I4', 'Total AR');

		$c = '5';
		foreach ($vertical_list as $l) {

			if (!empty($l->console_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, get_console_name($l->console_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
			}

			if (!empty($l->sbu_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, get_sbu_name($l->sbu_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
			}

			if (!empty($l->cluster_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, get_cluster_name($l->cluster_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
			}
			
			if (!empty($l->vertical_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, get_vertical_name($l->vertical_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "NA");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "-");

			$tot_bal =  $this->base_model->getExportInvoiceFEMAReport($month_year, $l->sbu_id, $l->cluster_id, $l->vertical_id, $l->console_id, $ar_type_id, $country_id, $region_id);


			if ($fx_type_id == 0) {

				$overdue = $out_amt4->overdue2 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, money_format('%!n', $tot_bal->bal));
			} elseif ($fx_type_id == 1) {

				$fx_overdue = $out_amt4->fx_overdue2 / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, money_format('%!n', $tot_bal->fx_bal));
			}


			// $vertical_listsss = $this->base_model->getVerticleMappingClusterss($sbu_id, $l->cluster_id, $vertical_id, $console_entity_id);


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}

			// print_r($c);die;

			/* if (!empty($vertical_listsss)) {
				foreach ($vertical_listsss as $ver) {

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

					if (!empty($l->cluster_id)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, get_vertical_name($ver->vertical_id));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "NA");
					}


					$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, "-");


					$verticalBal = $this->base_model->getExportInvoiceFEMAReportVerticalBal($month_year, $sbu_id, $l->cluster_id, $ver->vertical_id, $console_entity_id, $ar_type_id, $country_id, $region_id);


					if ($fx_type_id == 0) {

						$overdue = $out_amt4->overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, money_format('%!n', $verticalBal->bal));
					} elseif ($fx_type_id == 1) {

						$fx_overdue = $out_amt4->fx_overdue2 / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, money_format('%!n', $verticalBal->fx_bal));
					} */





					$month_end_ar_list = $this->base_model->getmonth_end_ar_list($month_year, $l->sbu_id, $l->cluster_id, $l->vertical_id, $l->console_id, $ar_type_id, $country_id, $region_id);


					/* if ($D != '0') {
						$E = $D + 1;
					} else {
						$E = '0';
					} */

					if (!empty($month_end_ar_list)) {
						foreach ($month_end_ar_list as $m) {

							$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, $m->org_document_number);

							$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, $m->child_code);

							$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, $m->customer_name);

							$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, $m->fema_days);

							if ($fx_type_id == 0) {

								$bal = $m->balance_amount / $denomination;
								$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, money_format('%!n', $bal));
							} elseif ($fx_type_id == 1) {

								$fx_bal = $m->fx_balance_amount / $denomination;
								$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, money_format('%!n', $fx_bal));
							}

							$D++;
						}
					}

					// $D = $E;

					// $D++;
				// }
			// }

			$c = $D;

			// $c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Export Invoice FEMA Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Export Invoice FEMA Report -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
	}




	//-------- Collection Summary Excel Export ----------

	function collection_summary_report_excel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;

		if ($this->input->post("fx_type_id") != '') {
			$fx_type_id = $this->input->post("fx_type_id");
		} else {
			$fx_type_id = '0';
		}

		$this->data['fx_type_id'] = $fx_type_id;



		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("console_entity_id") != '') {
			$console_entity_id = explode(',', $this->input->post("console_entity_id"));
			$this->data['console_entity_id'] = implode(',', $this->input->post("console_entity_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}


		$sbu_list = $this->base_model->getVerticalSBUlist($console_entity_id, $sbu_id, $cluster_id, $vertical_id);




		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);

		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '00a65a'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$collectionpercolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f7ac4f'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$bgcolor_color = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ffffff'),
				'bold'  => true,
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'e5e3e3'),
			),
			'font' => array(
				'bold' => true
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'a80606'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$bgbrr = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '0878b0'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);




		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', ' - Collection Summary Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(15);

		$objPHPExcel->getActiveSheet(0)->getStyle('B:AF')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

		$objPHPExcel->getActiveSheet(0)->getStyle('A4:AF4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


		// Add some data


		$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('J5:P5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('R5:X5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('Z5:AF5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('B4:H4')->applyFromArray($bgblue);
		$objPHPExcel->getActiveSheet()->getStyle('J4:P4')->applyFromArray($bgbrr);
		$objPHPExcel->getActiveSheet()->getStyle('R4:X4')->applyFromArray($bgcolor);
		$objPHPExcel->getActiveSheet()->getStyle('Z4:AF4')->applyFromArray($collectionpercolor);

		// $objPHPExcel->getActiveSheet()->getStyle('D4:X4')->applyFromArray($bgcolor_color);

		$objPHPExcel->setActiveSheetIndex()->mergeCells('D4:H4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('J4:P4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('R4:X4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('Z4:AF4');

		$objPHPExcel->setActiveSheetIndex()->mergeCells('A4:C4');

		if ($denomination == 1) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'INR');
		} elseif ($denomination == 1000) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Thousands');
		} elseif ($denomination == 1000000) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'MN');
		}

		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'AR');
		$objPHPExcel->getActiveSheet()->setCellValue('J4', 'COLLECTION PLAN');
		$objPHPExcel->getActiveSheet()->setCellValue('R4', 'ACTUAL COLLECTION');
		$objPHPExcel->getActiveSheet()->setCellValue('Z4', 'COLLECTION (IN %)');

		$objPHPExcel->getActiveSheet()->setCellValue('A5', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('B5', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('C5', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('D5', 'Total');
		$objPHPExcel->getActiveSheet()->setCellValue('E5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('F5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('G5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('H5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('I5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('J5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('K5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('L5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('M5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('N5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('O5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('P5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('Q5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('R5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('S5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('T5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('U5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('V5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('W5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('X5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('Y5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('Z5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('AA5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('AB5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('AC5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('AD5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('AE5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('AF5', 'RTN/W-RTN');


		$c = '6';
		foreach ($sbu_list as $s) {

			$li = $this->base_model->getSBUCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id);

			if (!empty($s->sbu_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, get_sbu_name($s->sbu_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "-");

			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, money_format('%!n', $li->bal / $denomination));
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, money_format('%!n', $li->fx_bal / $denomination));
			}

			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $li->overdue / $denomination));
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $li->fx_overdue / $denomination));
			}
				
				
			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $li->ftm_due / $denomination));
				
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $li->fx_ftm_due / $denomination));
				
			}

				if ($fx_type_id == 0) {

				$notdue = $li->within_due - $li->ret - $li->wret - $li->ftm_due;
						
				} elseif ($fx_type_id == 1) {

				$notdue = $li->within_due - $li->ret - $li->wret - $li->fx_ftm_due;
				}

			if ($notdue != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, money_format('%!n', $notdue / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "-");
			}

			$tot_ret = $li->ret + $li->wret;

			if ($tot_ret != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, money_format('%!n', $tot_ret / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "-");
			}


			$coll_plan = $this->base_model->getSBUCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id);


			$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, "");


			if ($coll_plan->adv != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, money_format('%!n', $coll_plan->adv / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, "-");
			}


			if ($coll_plan->col != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, money_format('%!n', $coll_plan->col / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
			}

			if ($coll_plan->od != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, money_format('%!n', $coll_plan->od / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
			}

			if ($coll_plan->ftm != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!n', $coll_plan->ftm / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, "-");
			}

			if ($coll_plan->not_due != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!n', $coll_plan->not_due / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, "-");
			}

			if ($coll_plan->sam != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!n', $coll_plan->sam / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "-");
			}

			if ($coll_plan->rtn_w_rtn != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, money_format('%!n', $coll_plan->rtn_w_rtn / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "-");
			}


			$actual_coll_plan = $this->base_model->getSBUActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id);

			$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "");


			if ($actual_coll_plan->adv != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!n', $actual_coll_plan->adv / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "-");
			}


			if ($actual_coll_plan->col != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, money_format('%!n', $actual_coll_plan->col / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "-");
			}


			$od_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "OD", $region_id);


			if ($od_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!n', $od_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "-");
			}

			$ftm_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "FTM", $region_id);

			if ($ftm_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!n', $ftm_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "-");
			}

			$notdue_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "Not Due", $region_id);

			if ($notdue_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!n', $notdue_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "-");
			}

			$same = $actual_coll_plan->col - $od_amt->actual_coll_amount - $ftm_amt->actual_coll_amount - $notdue_amt->actual_coll_amount;

			if ($same != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, money_format('%!n', $same / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "");


			$per_adv = number_format($actual_coll_plan->adv * 100 / $coll_plan->adv, 2);

			if ($per_adv != 0 && !is_infinite($per_adv) && !is_nan($per_adv)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, number_format($per_adv, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "-");
			}

			$per_col = number_format($actual_coll_plan->col * 100 / $coll_plan->col, 2);

			if ($per_col != 0 && !is_infinite($per_col) && !is_nan($per_col)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, number_format($per_col, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "-");
			}

			$per_od = number_format($od_amt->actual_coll_amount * 100 / $coll_plan->od, 2);

			if ($per_od != 0 && !is_infinite($per_od) && !is_nan($per_od)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, number_format($per_od, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "-");
			}

			$per_ftm = number_format($ftm_amt->actual_coll_amount * 100 / $coll_plan->ftm, 2);

			if ($per_ftm != 0 && !is_infinite($per_ftm) && !is_nan($per_ftm)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, number_format($per_ftm, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "-");
			}

			$per_not_due = number_format($notdue_amt->actual_coll_amount * 100 / $coll_plan->not_due, 2);

			if ($per_not_due != 0 && !is_infinite($per_not_due) && !is_nan($per_not_due)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, number_format($per_not_due, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "-");
			}

			$per_same = number_format($same * 100 / $coll_plan->sam, 2);

			if ($per_same != 0 && !is_infinite($per_same) && !is_nan($per_same)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, number_format($per_same, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "-");


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}


			$cluster_list = $this->base_model->getClusterMappingNames($s->sbu_id, $cluster_id, $vertical_id, $console_entity_id);


			if (!empty($cluster_list)) {
				foreach ($cluster_list as $clu) {

					$c_mon_AR = $this->base_model->getClusterwiseCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, get_cluster_name($clu->cluster_id));

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, money_format('%!n', $c_mon_AR->bal / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, money_format('%!n', $c_mon_AR->fx_bal / $denomination));
					}

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $c_mon_AR->overdue / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $c_mon_AR->fx_overdue / $denomination));
					}

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $c_mon_AR->ftm_due / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $c_mon_AR->fx_ftm_due / $denomination));
					}

					if ($fx_type_id == 0) {

						$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->ftm_due;
					} elseif ($fx_type_id == 1) {

						$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->fx_ftm_due;
					}

					if ($notdue != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, money_format('%!n', $notdue / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, "-");
					}

					$tot_ret = $c_mon_AR->ret + $c_mon_AR->wret;

					if ($tot_ret != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, money_format('%!n', $tot_ret / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, "-");
					}

					$c_coll_plan = $this->base_model->getClusterCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, "");

					if ($c_coll_plan->adv != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $D, money_format('%!n', $c_coll_plan->adv / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $D, "-");
					}

					if ($c_coll_plan->col != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, money_format('%!n', $c_coll_plan->col / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, "-");
					}

					if ($c_coll_plan->od != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, money_format('%!n', $c_coll_plan->od / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, "-");
					}

					if ($c_coll_plan->ftm != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, money_format('%!n', $c_coll_plan->ftm / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, "-");
					}

					if ($c_coll_plan->not_due != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, money_format('%!n', $c_coll_plan->not_due / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, "-");
					}

					if ($c_coll_plan->sam != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $D, money_format('%!n', $c_coll_plan->sam / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $D, "-");
					}

					if ($c_coll_plan->rtn_w_rtn != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, money_format('%!n', $c_coll_plan->rtn_w_rtn / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, "-");
					}

					$c_actual_coll_plan = $this->base_model->getClusterActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $D, "");

					if ($c_actual_coll_plan->adv != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, money_format('%!n', $c_actual_coll_plan->adv / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, "-");
					}

					if ($c_actual_coll_plan->col != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, money_format('%!n', $c_actual_coll_plan->col / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, "-");
					}


					$c_od_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "OD");

					if ($c_od_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, money_format('%!n', $c_od_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, "-");
					}

					$c_ftm_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "FTM");

					if ($c_ftm_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, money_format('%!n', $c_ftm_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, "-");
					}


					$c_notdue_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "Not Due");

					if ($c_notdue_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, money_format('%!n', $c_notdue_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, "-");
					}

					$same1 = $c_actual_coll_plan->col - $c_od_amt->actual_coll_amount - $c_ftm_amt->actual_coll_amount - $c_notdue_amt->actual_coll_amount;


					if ($same1 != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, money_format('%!n', $same1 / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $D, "");

					$per_adv_ver = $c_actual_coll_plan->adv * 100 / $c_coll_plan->adv;

					if ($per_adv_ver != 0 && !is_infinite($per_adv_ver) && !is_nan($per_adv_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $D, number_format($per_adv_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $D, "-");
					}

					$per_cols_ver = $c_actual_coll_plan->col * 100 / $c_coll_plan->col;

					if ($per_cols_ver != 0 && !is_infinite($per_cols_ver) && !is_nan($per_cols_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $D, number_format($per_cols_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $D, "-");
					}

					$per_ods_ver = (($c_od_amt->actual_coll_amount * 100) / $c_coll_plan->od);

					if ($per_ods_ver != 0 && !is_infinite($per_ods_ver) && !is_nan($per_ods_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $D, number_format($per_ods_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $D, "-");
					}

					$per_ftms_ver = (($c_ftm_amt->actual_coll_amount * 100) / $c_coll_plan->ftm);

					if ($per_ftms_ver != 0 && !is_infinite($per_ftms_ver) && !is_nan($per_ftms_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $D, number_format($per_ftms_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $D, "-");
					}

					$per_not_due_ver = $c_notdue_amt->actual_coll_amount * 100 / $c_coll_plan->not_due;

					if ($per_not_due_ver != 0 && !is_infinite($per_not_due_ver) && !is_nan($per_not_due_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $D, number_format($per_not_due_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $D, "-");
					}

					$per_same11_ver = $same1 * 100 / $c_coll_plan->sam;

					if ($per_same11_ver != 0 && !is_infinite($per_same11_ver) && !is_nan($per_same11_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $D, number_format($per_same11_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $D, "-");


					$vertical_list = $this->base_model->getVerticleMappingClusterNames($s->sbu_id, $clu->cluster_id, $vertical_id, $console_entity_id);

					if ($D != '0') {
						$E = $D + 1;
					} else {
						$E = '0';
					}

					if (!empty($vertical_list)) {
						foreach ($vertical_list as $ver) {

							$v_mon_AR = $this->base_model->getVerticalCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);



							$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $E, get_vertical_name($ver->vertical_id));

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $E, money_format('%!n', $v_mon_AR->bal / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $E, money_format('%!n', $v_mon_AR->fx_bal / $denomination));
							}

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $E, money_format('%!n', $v_mon_AR->overdue / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $E, money_format('%!n', $v_mon_AR->fx_overdue / $denomination));
							}

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $E, money_format('%!n', $v_mon_AR->ftm_due / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $E, money_format('%!n', $v_mon_AR->fx_ftm_due / $denomination));
							}


								if ($fx_type_id == 0) {

								$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->ftm_due;
										
								} elseif ($fx_type_id == 1) {

								$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->fx_ftm_due;
								
								}

							if ($notdue != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $E,  money_format('%!i', $notdue / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $E, "-");
							}


							$tot_ret = $v_mon_AR->ret + $v_mon_AR->wret;

							if ($tot_ret != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $E,  money_format('%!i', $tot_ret / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $E, "-");
							}

							$v_coll_plan = $this->base_model->getVerticalCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id);

							$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $E, "");

							if ($v_coll_plan->adv != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $E,  money_format('%!i', $v_coll_plan->adv / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $E, "-");
							}


							if ($v_coll_plan->col != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $E,  money_format('%!i', $v_coll_plan->col / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $E, "-");
							}

							if ($v_coll_plan->od != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $E,  money_format('%!i', $v_coll_plan->od / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $E, "-");
							}


							if ($v_coll_plan->ftm != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $E,  money_format('%!i', $v_coll_plan->ftm / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $E, "-");
							}


							if ($v_coll_plan->not_due != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $E,  money_format('%!i', $v_coll_plan->not_due / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $E, "-");
							}

							if ($v_coll_plan->sam != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $E,  money_format('%!i', $v_coll_plan->sam / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $E, "-");
							}

							if ($v_coll_plan->rtn_w_rtn != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $E,  money_format('%!i', $v_coll_plan->rtn_w_rtn / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $E, "-");
							}

							$v_actual_coll_plan = $this->base_model->getVerticalActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id);

							// print_r($this->db->last_query());die;

							$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $E, "");

							if ($v_actual_coll_plan->adv != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $E,  money_format('%!i', $v_actual_coll_plan->adv / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $E, "-");
							}


							if ($v_actual_coll_plan->col != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $E,  money_format('%!i', $v_actual_coll_plan->col / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $E, "-");
							}


							$v_od_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "OD");

							if ($v_od_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $E,  money_format('%!i', $v_od_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $E, "-");
							}

							$v_ftm_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM");

							if ($v_ftm_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $E,  money_format('%!i', $v_ftm_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $E, "-");
							}

							$v_notdue_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due");

							if ($v_notdue_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $E,  money_format('%!i', $v_notdue_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $E, "-");
							}

							$v_same = $v_actual_coll_plan->col - $v_od_amt->actual_coll_amount - $v_ftm_amt->actual_coll_amount - $v_notdue_amt->actual_coll_amount;

							if ($v_same != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $E, money_format('%!i', $v_same / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $E, "-");
							}

							$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $E, "");


							$v_per_adv = $v_actual_coll_plan->adv * 100 / $v_coll_plan->adv;

							if ($v_per_adv != 0 && !is_infinite($v_per_adv) && !is_nan($v_per_adv)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $E, number_format($v_per_adv, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $E, "-");
							}


							$v_per_col = $v_actual_coll_plan->col * 100 / $v_coll_plan->col;

							if ($v_per_col != 0 && !is_infinite($v_per_col) && !is_nan($v_per_col)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $E, number_format($v_per_col, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $E, "-");
							}

							$v_per_od = $v_od_amt->actual_coll_amount * 100 / $v_coll_plan->od;

							if ($v_per_od != 0 && !is_infinite($v_per_od) && !is_nan($v_per_od)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $E, number_format($v_per_od, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $E, "-");
							}

							$v_per_ftm = $v_ftm_amt->actual_coll_amount * 100 / $v_coll_plan->ftm;

							if ($v_per_ftm != 0 && !is_infinite($v_per_ftm) && !is_nan($v_per_ftm)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $E, number_format($v_per_ftm, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $E, "-");
							}

							$v_per_not_due = $v_notdue_amt->actual_coll_amount * 100 / $v_coll_plan->not_due;

							if ($v_per_not_due != 0 && !is_infinite($v_per_not_due) && !is_nan($v_per_not_due)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $E, number_format($v_per_not_due, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $E, "-");
							}

							$v_per_same11 = $v_same * 100 / $v_coll_plan->sam;

							if ($v_per_same11 != 0 && !is_infinite($v_per_same11) && !is_nan($v_per_same11)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $E, number_format($v_per_same11, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $E, "-");
							}

							$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $E, "-");


							$E++;
						}
					}

					$D = $E;

					$D++;
				}
			}

			$c = $D;

			$c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Collection Summary Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Collection Summary Report -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
	}



	public function exceld()
	{

		$month_year = $this->input->post('month_year');

		if ($this->input->post("ar_type_id") != '') {
			$ar_type = array();
			foreach ($this->input->post("ar_type_id") as $a) {
				$ar_type[] = "'" . $a . "'";
			}
			$ar_type_id = " AND ar_type IN (" . implode(',', $ar_type) . ")";
		}

		if ($this->input->post("consol_id") != '') {
			$console = array();
			foreach ($this->input->post("consol_id") as $c) {
				$console[] = "'" . $c . "'";
			}
			$consol_id = " AND console_entity IN (" . implode(',', $console) . ")";
		}

		if ($this->input->post("sbu_id") != '') {
			$sbu = array();
			foreach ($this->input->post("sbu_id") as $s) {
				$sbu[] = "'" . $s . "'";
			}
			$sbu_id = " AND sbu IN (" . implode(',', $sbu) . ")";
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster = array();
			foreach ($this->input->post("cluster_id") as $cc) {
				$cluster[] = "'" . $cc . "'";
			}
			$cluster_id = " AND cluster IN (" . implode(',', $cluster) . ")";
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical = array();
			foreach ($this->input->post("vertical_id") as $v) {
				$vertical[] = "'" . $v . "'";
			}
			$vertical_id = " AND vertical IN (" . implode(',', $vertical) . ")";
		}

		if ($this->input->post("country_id") != '') {
			$country_id = array();
			foreach ($this->input->post("country_id") as $co) {
				$country_id[] = "'" . $co . "'";
			}
			$country = " AND country IN (" . implode(',', $country_id) . ")";
		}

		if ($this->input->post("region_id") != '') {
			$region_id = array();
			foreach ($this->input->post("region_id") as $co) {
				$region_id[] = "'" . $co . "'";
			}
			$region = " AND region IN (" . implode(',', $region_id) . ")";
		}

		if ($this->input->post("cust_type") != '') {
			$cust_type = " AND customer_type ='" . $this->input->post("cust_type") . "'";
		}

		if ($this->input->post("child_code") != '') {
			$child_code = " AND child_code ='" . $this->input->post("child_code") . "'";
		}

		if ($this->input->post("doc_num") != '') {
			$doc_num = " AND org_document_number ='" . $this->input->post("doc_num") . "'";
		}

		$data = $this->db->query("select * from month_end_ar_process_data WHERE month_year ='" . $month_year . "' " . $sbu_id . " " . $ar_type_id . " " . $consol_id . " " . $cluster_id . " " . $vertical_id . " " . $country . "" . $region . "" . $cust_type . "" . $child_code . "" . $doc_num)->result();

		if (isset($_POST['down_csv'])) {
			// $csvData[] = array(
			// 	"Consol_Entity", "SBU", "Cluster", "Vertical", "Country", "AR_Type", "Consol", "Area", "Region", "Org DPST", "Org TT", "Month", "Sales Engg Code", "Sales Engg Name", "Customer Group",
			// 	"Parent Code",
			// 	"Child Code",
			// 	"Customer_Name",
			// 	"Project_Name",
			// 	"PO Number",
			// 	"PO Credit Term",
			// 	"Company",
			// 	"Transaction Type",
			// 	"Invoice Number",
			// 	"Org. Document Number",
			// 	"Dispatch Date",
			// 	"Invoice_Date",
			// 	"Credit Days",
			// 	"Due Date",
			// 	"Credit Days Adj",
			// 	"Rev Due date",
			// 	"Invoice Amount",
			// 	"Paid Amount",
			// 	"Balance Amount",
			// 	"Currency",
			// 	"FX Rate",
			// 	"FX Invoice Amount",
			// 	"FX Paid Amount",
			// 	"FX Balance Amount",
			// 	"Customer Type",
			// 	"ECL Category",
			// 	"ECL RTN Days",
			// 	"FEMA Days",
			// 	"Current Mth FX Rate",
			// 	"Modified Doc",
			// 	"Invoice Type",
			// 	"OD Days",
			// 	"Within Due",
			// 	"Overdue",
			// 	"FTM Due",
			// 	"OD Ageing Category",
			// 	"FX Within Due",
			// 	"FX Over Due",
			// 	"FX FTM Due",
			// 	"FX Impact",
			// 	"Collection Days",
			// 	"Responsibity",
			// 	"Planned Coll Amount",
			// 	"Planned_Coll_Date",
			// 	"Retention",
			// 	"Retention_Warranty",
			// 	"Planned_RTN_WRTN_Coll_Amount",
			// 	"Planned_RTN_WRTN_Date",
			// 	"WON",
			// 	"LD",
			// 	"Legal",
			// 	"PBG_LC",
			// 	"CNAF",
			// 	"SRN",
			// 	"FOC",
			// 	"WDS",
			// 	"GST_TDS",
			// 	"TDS",
			// 	"Actual Coll Amount",
			// 	"Actual Coll Date",
			// 	"Commissioning"
			// );

			$csvData[] = array(
				"Consol_Entity", "SBU", "Cluster", "Vertical", "Country", "AR_Type", "Area", "Region", "Org DPST", "Month",
				"Parent Code",
				"Child Code",
				"Customer_Name",
				"Project_Name",
				"PO Number",
				"PO Credit Term",
				"Company",
				"Transaction Type",
				"Invoice Number",
				"Org. Document Number",
				"Invoice_Date",
				"Credit Days",
				"Due Date",
				"Invoice Amount",
				"Paid Amount",
				"Balance Amount",
				"Currency",
				"FX Rate",
				"FX Invoice Amount",
				"FX Paid Amount",
				"FX Balance Amount",
				"Customer Type",
				"ECL Category",
				"ECL RTN Days",
				"FEMA Days",
				"Current Mth FX Rate",
				"Modified Doc",
				"Invoice Type",
				"OD Days",
				"Within Due",
				"Overdue",
				"FTM Due",
				"OD Ageing Category",
				"FX Within Due",
				"FX Over Due",
				"FX FTM Due",
				"FX Impact",
				"Collection Days",
				"Responsibity",
				"Planned Coll Amount",
				"Planned_Coll_Date",
				"Retention",
				"Retention_Warranty",
				"Total_Warranty",
				"Planned_RTN_WRTN_Coll_Amount",
				"Planned_RTN_WRTN_Date",
				"Commissioning",
				"PBG_LC",
				"LD",
				"GST_TDS",
				"TDS",
				"WON",
				"CNAF",
				"SRN",
				"FOC",
				"Legal",
				"Total",
				"Validation"
				
				
				
			);

			foreach ($data as $cnt) {

				$total_retention = money_format('%!i',($cnt->retention)) + money_format('%!i',($cnt->warranty_retention));

				$total =  money_format('%!i',$total_retention) +  money_format('%!i',$cnt->commissioning) +  money_format('%!i',($cnt->pbg_lc)) +  money_format('%!i',($cnt->ld)) +  money_format('%!i',($cnt->gst_tds)) +  money_format('%!i',($cnt->tds)) +  money_format('%!i',($cnt->won)) +  money_format('%!i',($cnt->cnaf)) +  money_format('%!i',($cnt->srn)) +  money_format('%!i',($cnt->foc)) +  money_format('%!i',($cnt->legal));

				$validation =  $cnt->balance_amount - $total;

				$csvData[] = array(
					$cnt->console_entity,
					$cnt->sbu,
					$cnt->cluster,
					$cnt->vertical,
					$cnt->country,
					$cnt->ar_type,
					// $cnt->consol,
					$cnt->area . '-' . $cnt->region,
					$cnt->region,
					$cnt->org_dpst,
					// $cnt->org_tt,
					$cnt->month,
					// $cnt->sales_engg_code,
					// $cnt->sales_engg_name,
					// $cnt->customer_group,
					$cnt->parent_code,
					$cnt->child_code,
					$cnt->customer_name,
					$cnt->project_name,
					$cnt->po_name,
					$cnt->po_credit_term,
					$cnt->company,
					$cnt->transaction_type,
					$cnt->invoice_number,
					$cnt->org_document_number,
					// format_date($cnt->dispatch_date),
					format_date($cnt->invoice_date),
					$cnt->credit_days,
					format_date($cnt->due_date),
					// $cnt->credit_days_adj,
					// format_date($cnt->rev_due_date),
					money_format('%!i', $cnt->invoice_amount),
					money_format('%!i', $cnt->paid_amount),
					money_format('%!i', $cnt->balance_amount),
					$cnt->currency,
					money_format('%!i', $cnt->fx_rate),
					money_format('%!i', $cnt->fx_invoice_amount),
					money_format('%!i', $cnt->fx_paid_amount),
					money_format('%!i', $cnt->fx_balance_amount),
					$cnt->customer_type,
					$cnt->ecl_category,
					$cnt->ecl_days,
					$cnt->fema_days,
					money_format('%!i', $cnt->current_mth_fx_rate),
					$cnt->modified_doc,
					$cnt->invoice_type,
					$cnt->od_days,
					$cnt->within_due,
					money_format('%!i', $cnt->overdue),
					$cnt->ftm_due,
					$cnt->od_ageing_category,
					money_format('%!i', $cnt->fx_within_due),
					money_format('%!i', $cnt->fx_overdue),
					money_format('%!i', $cnt->fx_ftm_due),
					money_format('%!i', $cnt->fx_impact),
					$cnt->collection_days,
					$cnt->responsibility,
					money_format('%!i', $cnt->planned_coll_amt),
					format_date($cnt->planned_coll_date),
					money_format('%!i', $cnt->retention),
					money_format('%!i', $cnt->warranty_retention),
					money_format('%!i', $total_retention),
					money_format('%!i', $cnt->planned_rtn_wrtn_coll_amt),
					format_date($cnt->planned_rtn_wrtn_date),
					money_format('%!i', $cnt->commissioning),
					money_format('%!i', $cnt->pbg_lc),
					money_format('%!i', $cnt->ld),
					money_format('%!i', $cnt->gst_tds),
					money_format('%!i', $cnt->tds),
					money_format('%!i', $cnt->won),
					money_format('%!i', $cnt->cnaf),
					money_format('%!i', $cnt->srn),
					money_format('%!i', $cnt->foc),
					money_format('%!i', $cnt->legal),
					money_format('%!i', $total),
					money_format('%!i', $validation),
					
					
					// money_format('%!i', $cnt->wds),
					
					// money_format('%!i', $cnt->actual_coll_amount),
					// format_date($cnt->actual_coll_date),
					
				);
			}

			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");
			header("Content-Disposition: attachment;filename=Elgi-MEND_" . time() . ".csv");
			header("Content-Transfer-Encoding: binary");
			$df = fopen("php://output", 'w');
			array_walk($csvData, function ($row) use ($df) {
				fputcsv($df, $row);
			});
			fclose($df);
		}
		if (isset($_POST['down_xlsx'])) {

			if ($this->input->post("fx_type_id") == 1) {
				include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
				$header = array(
					'Consol Entity' => 'string', //text
					'SBU' => 'string', //text
					'Cluster' => 'string', //text
					'Vertical' => 'string', //text
					'Country' => 'string', //text
					'AR Type' => 'string', //text
					// 'Consol' => 'string', //text
					'Area' => 'string', //text
					'Region' => 'string', //text
					'Org DPST' => 'string', //text
					// 'Org TT' => 'string', //text
					'Month' => 'DD-MM-YYYY',
					// 'Sales Engg Code' => 'string', //text
					// 'Sales Engg Name' => 'string', //text
					// 'Customer Group' => 'string', //text
					'Parent Code' => 'string', //text
					'Child Code' => 'string', //text
					'Customer Name' => 'string', //text
					'Project Name' => 'string', //text
					'PO Number' => 'string', //text
					'PO Credit Term' => 'string', //text
					'Company' => 'string', //text
					'Transaction Type' => 'string', //text
					'Invoice Number' => 'string', //text
					'Org Document Number' => 'string', //text
					// 'Dispatch Date' => 'DD-MM-YYYY',
					'Invoice Date' => 'DD-MM-YYYY',
					'Credit Days' => 'integer', //text
					'Due Date' => 'DD-MM-YYYY',
					// 'Credit Days Adj' => 'integer', //text
					// 'Rev Due date' => 'DD-MM-YYYY',
					'Invoice_Amount' => '#,##0.00', //custom
					'Paid_Amount' => '#,##0.00', //custom
					'Balance_Amount' => '#,##0.00', //custom
					'Currency' => 'string', //text
					'Fx Rate' => '#,##0.00', //custom
					'Fx Invoice Amount' => '#,##0.00', //custom
					'Fx Paid Amount' => '#,##0.00', //custom
					'Fx Balance Amount' => '#,##0.00', //custom
					'Customer Type' => 'string', //text
					'ECL Category' => 'string', //text
					'ECL RTN Days' => 'integer', //text
					'FEMA Days' => 'integer', //text
					'Current Mth FX Rate' =>  '#,##0.00', //custom
					'Modified Doc' => 'integer', //text
					'Invoice Type' => 'string', //text
					'OD Days' => 'integer', //text
					'Within Due' => '#,##0.00', //custom
					'Over Due' =>  '#,##0.00', //custom
					'FTM Due' => '#,##0.00', //custom
					'OD Ageing Category' => 'string', //text
					'FX Within Due' =>  '#,##0.00', //custom
					'FX Over Due' =>  '#,##0.00', //custom
					'FX FTM Due' => '#,##0.00', //custom
					'FX Impact' =>  '#,##0.00', //custom
					'Collection Days' => 'integer', //text
					'Responsibility' => 'string', //text
					'Planned Coll Amount' => '#,##0.00', //custom
					'Planned Coll Date' => 'DD-MM-YYYY',
					'Retention' =>  '#,##0.00', //custom
					'Retention Warranty' =>  '#,##0.00', //custom
					'Total Retention' =>  '#,##0.00', //custom
					'Planned RTN WRTN Coll Amount' => '#,##0.00', //custom
					'Planned RTN WRTN Date' => 'DD-MM-YYYY',
					'Commissioning' => 'string', //text
					'PBG LC' => '#,##0.00', //custom
					'LD' => '#,##0.00', //custom
					'TDS' => '#,##0.00', //custom
					'GST_TDS' => '#,##0.00', //custom
					'WON' => '#,##0.00', //custom
					'CNAF' => '#,##0.00', //custom
					'SRN' => '#,##0.00', //custom
					'FOC' => '#,##0.00', //custom
					// 'WDS' => '#,##0.00', //custom
					
					
					'Legal' => '#,##0.00', //custom
					'Total' => '#,##0.00', //custom
					'Validation' => '#,##0.00', //custom
					// 'Actual Coll Amount' => '#,##0.00', //custom
					// 'Actual Coll Date' => 'DD-MM-YYYY',
					
				);
				$writer = new XLSXWriter();
				$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  20, 20, 20, 20, 20], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'],  ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff']]);
				foreach ($data as $cnt) {
					
					// if ($cnt->dispatch_date == '0000-00-00' || $cnt->dispatch_date == '1970-01-01' || empty($cnt->dispatch_date)) {
					// 	$Dispatch_date = '';
					// } else {
					// 	$Dispatch_date = $cnt->dispatch_date;
					// }

					if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
						$Invoice_date = '';
					} else {
						$Invoice_date = $cnt->invoice_date;
					}

					if ($cnt->due_date == '0000-00-00' || $cnt->due_date == '1970-01-01' || empty($cnt->due_date)) {
						$Due_date = '';
					} else {
						$Due_date = $cnt->due_date;
					}

					// if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
					// 	$Rev_date = '';
					// } else {
					// 	$Rev_date = $cnt->rev_due_date;
					// }

					if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
						$Planned_coll_date = '';
					} else {
						$Planned_coll_date = $cnt->planned_coll_date;
					}

					if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
						$Planned_rtn_date = '';
					} else {
						$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
					}

					// if ($cnt->actual_coll_date == '0000-00-00' || $cnt->actual_coll_date == '1970-01-01' || empty($cnt->actual_coll_date)) {
					// 	$Actual_coll_date = '';
					// } else {
					// 	$Actual_coll_date = $cnt->actual_coll_date;
					// }

					$total_retention = ($cnt->retention + $cnt->warranty_retention);

					$total = $total_retention + $cnt->commissioning + $cnt->pbg_lc + $cnt->ld + $cnt->gst_tds + $cnt->tds + $cnt->won + $cnt->cnaf + $cnt->srn + $cnt->foc + $cnt->legal;

					$validation = $cnt->balance_amount - $total;

					$csvData[] = array(
						$cnt->console_entity,
						$cnt->sbu,
						$cnt->cluster,
						$cnt->vertical,
						$cnt->country,
						$cnt->ar_type,
						// $cnt->consol,
						$cnt->area . '-' . $cnt->region,
						$cnt->region,
						$cnt->org_dpst,
						// $cnt->org_tt,
						$cnt->month,
						// $cnt->sales_engg_code,
						// $cnt->sales_engg_name,
						// $cnt->customer_group,
						$cnt->parent_code,
						$cnt->child_code,
						$cnt->customer_name,
						$cnt->project_name,
						$cnt->po_name,
						$cnt->po_credit_term,
						$cnt->company,
						$cnt->transaction_type,
						$cnt->invoice_number,
						$cnt->org_document_number,
						// $Dispatch_date,
						$Invoice_date,
						$cnt->credit_days,
						$Due_date,
						// $cnt->credit_days_adj,
						// $Rev_date,
						$cnt->invoice_amount,
						$cnt->paid_amount,
						$cnt->balance_amount, 
						$cnt->currency,
						$cnt->fx_rate,
						$cnt->fx_invoice_amount,
						$cnt->fx_paid_amount,
						$cnt->fx_balance_amount,
						$cnt->customer_type,
						$cnt->ecl_category,
						$cnt->ecl_days,
						$cnt->fema_days,
						$cnt->current_mth_fx_rate,
						$cnt->modified_doc,
						$cnt->invoice_type,
						$cnt->od_days,
						$cnt->within_due,
						$cnt->overdue,
						$cnt->ftm_due,
						$cnt->od_ageing_category,
						$cnt->fx_within_due,
						$cnt->fx_overdue,
						$cnt->fx_ftm_due,
						$cnt->fx_impact,
						$cnt->collection_days,
						$cnt->responsibility,
						$cnt->planned_coll_amt,
						$Planned_coll_date,
						$cnt->retention,
						$cnt->warranty_retention,
						$total_retention,
						$cnt->planned_rtn_wrtn_coll_amt,
						$Planned_rtn_date,
						$cnt->commissioning,
						$cnt->pbg_lc,
						$cnt->ld,
						$cnt->gst_tds,
						$cnt->tds,
						$cnt->won,
						$cnt->cnaf,
						$cnt->srn,
						$cnt->foc,
						// $cnt->wds,
						
						$cnt->legal,
						$total,
						$validation
						// $cnt->actual_coll_amount,
						// $Actual_coll_date
					);
				}

				foreach ($csvData as $row) {
					$writer->writeSheetRow('Sheet1', $row);
				}
				$file = 'Month_End_AR_' . date('d-m-Y') . '.xlsx';
				$writer->writeToFile($file);

				if (file_exists($file)) {
					header('Content-Description: File Transfer');
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . basename($file) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					readfile($file);
					unlink($file);
					exit;
				}
			} else {
				include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
				$header = array(
					'Consol Entity' => 'string', //text
					'SBU' => 'string', //text
					'Cluster' => 'string', //text
					'Vertical' => 'string', //text
					'Country' => 'string', //text
					'AR Type' => 'string', //text
					// 'Consol' => 'string', //text
					'Area' => 'string', //text
					'Region' => 'string', //text
					'Org DPST' => 'string', //text
					// 'Org TT' => 'string', //text
					'Month' => 'DD-MM-YYYY',
					// 'Sales Engg Code' => 'string', //text
					// 'Sales Engg Name' => 'string', //text
					// 'Customer Group' => 'string', //text
					'Parent Code' => 'string', //text
					'Child Code' => 'string', //text
					'Customer Name' => 'string', //text
					'Project Name' => 'string', //text
					'PO Number' => 'string', //text
					'PO Credit Term' => 'string', //text
					'Company' => 'string', //text
					'Transaction Type' => 'string', //text
					'Invoice Number' => 'string', //text
					'Org Document Number' => 'string', //text
					// 'Dispatch Date' => 'DD-MM-YYYY',
					'Invoice Date' => 'DD-MM-YYYY',
					'Credit Days' => 'integer', //text
					'Due Date' => 'DD-MM-YYYY',
					// 'Credit Days Adj' => 'integer', //text
					// 'Rev Due date' => 'DD-MM-YYYY',
					'Invoice_Amount' => '#,##0.00', //custom
					'Paid_Amount' => '#,##0.00', //custom
					'Balance_Amount' => '#,##0.00', //custom
					'Currency' => 'string', //text
					'Fx Rate' => '#,##0.00', //custom
					'Fx Invoice Amount' => '#,##0.00', //custom
					'Fx Paid Amount' => '#,##0.00', //custom
					'Fx Balance Amount' => '#,##0.00', //custom
					'Customer Type' => 'string', //text
					'ECL Category' => 'string', //text
					'ECL RTN Days' => 'integer', //text
					'FEMA Days' => 'integer', //text
					'Current Mth FX Rate' =>  '#,##0.00', //custom
					'Modified Doc' => 'integer', //text
					'Invoice Type' => 'string', //text
					'OD Days' => 'integer', //text
					'Within Due' => '#,##0.00', //custom
					'Over Due' =>  '#,##0.00', //custom
					'FTM Due' => '#,##0.00', //custom
					'OD Ageing Category' => 'string', //text
					'FX Within Due' =>  '#,##0.00', //custom
					'FX Over Due' =>  '#,##0.00', //custom
					'FX FTM Due' => '#,##0.00', //custom
					'FX Impact' =>  '#,##0.00', //custom
					'Collection Days' => 'integer', //text
					'Responsibility' => 'string', //text
					'Planned Coll Amount' => '#,##0.00', //custom
					'Planned Coll Date' => 'DD-MM-YYYY',
					'Retention' =>  '#,##0.00', //custom
					'Retention Warranty' =>  '#,##0.00', //custom
					'Total Retention' =>  '#,##0.00', //custom
					'Planned RTN WRTN Coll Amount' => '#,##0.00', //custom
					'Planned RTN WRTN Date' => 'DD-MM-YYYY',
					'Commissioning' => 'string', //text
					'PBG LC' => '#,##0.00', //custom
					'LD' => '#,##0.00', //custom
					'TDS' => '#,##0.00', //custom
					'GST_TDS' => '#,##0.00', //custom
					'WON' => '#,##0.00', //custom
					'CNAF' => '#,##0.00', //custom
					'SRN' => '#,##0.00', //custom
					'FOC' => '#,##0.00', //custom
					// 'WDS' => '#,##0.00', //custom
					
					
					'Legal' => '#,##0.00', //custom
					'Total' => '#,##0.00', //custom
					'Validation' => '#,##0.00', //custom
					// 'Actual Coll Amount' => '#,##0.00', //custom
					// 'Actual Coll Date' => 'DD-MM-YYYY',
					
				);
				$writer = new XLSXWriter();
				$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  20, 20, 20, 20, 20], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'],  ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff']]);
				foreach ($data as $cnt) {
					// if ($cnt->dispatch_date == '0000-00-00' || $cnt->dispatch_date == '1970-01-01' || empty($cnt->dispatch_date)) {
					// 	$Dispatch_date = '';
					// } else {
					// 	$Dispatch_date = $cnt->dispatch_date;
					// }

					if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
						$Invoice_date = '';
					} else {
						$Invoice_date = $cnt->invoice_date;
					}

					if ($cnt->due_date == '0000-00-00' || $cnt->due_date == '1970-01-01' || empty($cnt->due_date)) {
						$Due_date = '';
					} else {
						$Due_date = $cnt->due_date;
					}

					// if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
					// 	$Rev_date = '';
					// } else {
					// 	$Rev_date = $cnt->rev_due_date;
					// }

					if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
						$Planned_coll_date = '';
					} else {
						$Planned_coll_date = $cnt->planned_coll_date;
					}

					if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
						$Planned_rtn_date = '';
					} else {
						$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
					}

					// if ($cnt->actual_coll_date == '0000-00-00' || $cnt->actual_coll_date == '1970-01-01' || empty($cnt->actual_coll_date)) {
					// 	$Actual_coll_date = '';
					// } else {
					// 	$Actual_coll_date = $cnt->actual_coll_date;
					// }


					$total_retention = ($cnt->retention + $cnt->warranty_retention);

					$total = $total_retention + $cnt->commissioning + $cnt->pbg_lc + $cnt->ld + $cnt->gst_tds + $cnt->tds + $cnt->won + $cnt->cnaf + $cnt->srn + $cnt->foc + $cnt->legal;

					$validation = $cnt->balance_amount - $total;

					$csvData[] = array(
						$cnt->console_entity,
						$cnt->sbu,
						$cnt->cluster,
						$cnt->vertical,
						$cnt->country,
						$cnt->ar_type,
						// $cnt->consol,
						$cnt->area . '-' . $cnt->region,
						$cnt->region,
						$cnt->org_dpst,
						// $cnt->org_tt,
						$cnt->month,
						// $cnt->sales_engg_code,
						// $cnt->sales_engg_name,
						// $cnt->customer_group,
						$cnt->parent_code,
						$cnt->child_code,
						$cnt->customer_name,
						$cnt->project_name,
						$cnt->po_name,
						$cnt->po_credit_term,
						$cnt->company,
						$cnt->transaction_type,
						$cnt->invoice_number,
						$cnt->org_document_number,
						// $Dispatch_date,
						$Invoice_date,
						$cnt->credit_days,
						$Due_date,
						// $cnt->credit_days_adj,
						// $Rev_date,
						$cnt->invoice_amount,
						$cnt->paid_amount,
						$cnt->balance_amount,
						$cnt->currency,
						$cnt->fx_rate,
						$cnt->fx_invoice_amount,
						$cnt->fx_paid_amount,
						$cnt->fx_balance_amount,
						$cnt->customer_type,
						$cnt->ecl_category,
						$cnt->ecl_days,
						$cnt->fema_days,
						$cnt->current_mth_fx_rate,
						$cnt->modified_doc,
						$cnt->invoice_type,
						$cnt->od_days,
						$cnt->within_due,
						$cnt->overdue,
						$cnt->ftm_due,
						$cnt->od_ageing_category,
						$cnt->fx_within_due,
						$cnt->fx_overdue,
						$cnt->fx_ftm_due,
						$cnt->fx_impact,
						$cnt->collection_days,
						$cnt->responsibility,
						$cnt->planned_coll_amt,
						$Planned_coll_date,
						$cnt->retention,
						$cnt->warranty_retention,
						$total_retention,
						$cnt->planned_rtn_wrtn_coll_amt,
						$Planned_rtn_date,
						$cnt->commissioning,
						$cnt->pbg_lc,
						$cnt->ld,
						$cnt->gst_tds,
						$cnt->tds,
						$cnt->won,
						$cnt->cnaf,
						$cnt->srn,
						$cnt->foc,
						// $cnt->wds,
						
						$cnt->legal,
						$total,
						$validation
						// $cnt->actual_coll_amount,
						// $Actual_coll_date
					);
				}

				foreach ($csvData as $row) {
					$writer->writeSheetRow('Sheet1', $row);
				}
				$file = 'Month_End_AR_' . date('d-m-Y') . '.xlsx';
				$writer->writeToFile($file);

				if (file_exists($file)) {
					header('Content-Description: File Transfer');
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . basename($file) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					readfile($file);
					unlink($file);
					exit;
				}
			}
		}
	}

	public function user_input_excel_download()
	{

		if (!$this->ion_auth->is_admin()) {
			$vertical_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		} else {
			$vertical_id = '';
			$month_year = $this->input->post('month_year');
		}

		$data = $this->base_model->getMonthEndReportListForExcelMapping($month_year, $vertical_id, $this->ion_auth->get_user_id());
		/* 		print_r($this->db->last_query());die;  */
		if (isset($_POST['down_csv'])) {
			$csvData[] = array(
				"Consol_Entity", "SBU", "Cluster", "Vertical", "Country", "AR_Type", "Org_DPST", "Area", "Region", "Sales_Engg_Name", "Customer_Type",
				"Child_Code",
				"Customer_Name",
				"Project_Name",
				"Org_Document_Number",
				"Invoice_Date",
				"Rev_Due_Date",
				"Invoice_Amount",
				"Paid_Amount",
				"Balance_Amount",
				"Currency",
				"Fx_Rate",
				"Planned_Coll_Amount",
				"Planned_Coll_Date",
				"Retention",
				"Retention_Warranty",
				"Planned_RTN_WRTN_Coll_Amount",
				"Planned_RTN_WRTN_Date",
				"PBG_LC",
				"WON",
				"CNAF",
				"SRN",
				"FOC_VALUE",
				"WDS",
				"GST_TDS",
				"TDS",
				"LD",
				"Legal",
				"Responsibility",
				"Commissioning",
			);

			foreach ($data as $cnt) {
				$csvData[] = array(
					$cnt->console_entity,
					$cnt->sbu,
					$cnt->cluster,
					$cnt->vertical,
					$cnt->country,
					$cnt->ar_type,

					$cnt->org_dpst,
					$cnt->area . '-' . $cnt->region,
					$cnt->region,
					$cnt->sales_engg_name,
					$cnt->customer_type,

					$cnt->child_code,
					$cnt->customer_name,
					$cnt->project_name,
					$cnt->org_document_number,
					format_date($cnt->invoice_date),
					format_date($cnt->rev_due_date),
					money_format('%!i', $cnt->invoice_amount),
					money_format('%!i', $cnt->paid_amount),
					money_format('%!i', $cnt->balance_amount),
					$cnt->currency,
					money_format('%!i', $cnt->fx_rate),
					money_format('%!i', $cnt->planned_coll_amt),
					format_date($cnt->planned_coll_date),
					money_format('%!i', $cnt->retention),
					money_format('%!i', $cnt->warranty_retention),
					money_format('%!i', $cnt->planned_rtn_wrtn_coll_amt),
					format_date($cnt->planned_rtn_wrtn_date),
					money_format('%!i', $cnt->pbg_lc),
					money_format('%!i', $cnt->won),
					money_format('%!i', $cnt->cnaf),
					money_format('%!i', $cnt->srn),
					money_format('%!i', $cnt->foc),
					money_format('%!i', $cnt->wds),
					money_format('%!i', $cnt->gst_tds),
					money_format('%!i', $cnt->tds),
					money_format('%!i', $cnt->ld),
					money_format('%!i', $cnt->legal),
					$cnt->responsibility,
					money_format('%!i', $cnt->commissioning),
				);
			}

			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");
			header("Content-Disposition: attachment;filename=Userinput_" . time() . ".csv");
			header("Content-Transfer-Encoding: binary");
			$df = fopen("php://output", 'w');
			array_walk($csvData, function ($row) use ($df) {
				fputcsv($df, $row);
			});
			fclose($df);
		}

		if (isset($_POST['down_xlsx'])) {
			include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
			$header = array(
				'Consol_Entity' => 'string', //text
				'SBU' => 'string', //text
				'Cluster' => 'string', //text
				'Vertical' => 'string', //text
				'Country' => 'string', //text
				'AR_Type' => 'string', //text
				'Org_DPST' => 'string',
				'Area' => 'string',
				'Region' => 'string',
				'Sales_Engg_Name' => 'string',
				'Customer_Type' => 'string',
				'Child_Code' => 'string', //text
				'Customer_Name' => 'string', //text
				'Project_Name' => 'string', //text
				'Org_Document_Number' => 'string', //text
				'Invoice_Date' => 'DD-MM-YYYY',
				'Rev_Due_Date' => 'DD-MM-YYYY',
				'Invoice_Amount' => '#,##0.00', //custom
				'Paid_Amount' => '#,##0.00', //custom
				'Balance_Amount' => '#,##0.00', //custom
				'Currency' => 'string', //text
				'Fx_Rate' => '#,##0.00', //custom
				'Planned_Coll_Amount' => '#,##0.00', //custom
				//'Planned_Coll_Amount1' => '#,##0.00', //custom
				'Planned_Coll_Date' => 'DD-MM-YYYY',
				//'Planned_Coll_Date1' => 'DD-MM-YYYY',
				'Retention' => 'string', //text
				//'Retention1' => 'string', //text
				'Retention_Warranty' => 'string', //text
				//'Retention_Warranty1' => 'string', //text
				'Planned_RTN_WRTN_Coll_Amount' => '#,##0.00', //custom
				//'Planned_RTN_WRTN_Coll_Amount1' => '#,##0.00', //custom
				'Planned_RTN_WRTN_Date' => 'DD-MM-YYYY',
				//'Planned_RTN_WRTN_Date1' => 'DD-MM-YYYY',
				'PBG_LC' => '#,##0.00', //custom
				//'PBG_LC1' => '#,##0.00', //custom
				'WON' => '#,##0.00', //custom
				//'WON1' => '#,##0.00', //custom
				'CNAF' => '#,##0.00', //custom
				//'CNAF1' => '#,##0.00', //custom
				'SRN' => '#,##0.00', //custom
				//'SRN1' => '#,##0.00', //custom
				'FOC_VALUE' => '#,##0.00', //custom
				//'FOC1' => '#,##0.00', //custom
				'WDS' => '#,##0.00', //custom
				//'WDS1' => '#,##0.00', //custom
				'GST_TDS' => '#,##0.00', //custom
				//'GST_TDS1' => '#,##0.00', //custom
				'TDS' => '#,##0.00', //custom
				//'TDS1' => '#,##0.00', //custom
				'LD' => '#,##0.00', //custom
				//'LD1' => '#,##0.00', //custom
				'Legal' => '#,##0.00', //custom
				//'Legal1' => '#,##0.00', //custom
				'Responsibility' => 'string', //text
				'Commissioning' => '#,##0.00', //text


			);


			$writer = new XLSXWriter();
			$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 20,  20, 20, 20, 20, 20, 40, 30, 20, 20, 20, 20, 20, 20, 20, 30, 20, 20, 20, 30, 40, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 30, 20], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'],  ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['height' => 20]]);
			foreach ($data as $cnt) {
				if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
					$Invoice_date = '';
				} else {
					$Invoice_date = $cnt->invoice_date;
				}

				if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
					$Rev_date = '';
				} else {
					$Rev_date = $cnt->rev_due_date;
				}

				if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
					$Planned_coll_date = '';
				} else {
					$Planned_coll_date = $cnt->planned_coll_date;
				}

				if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
					$Planned_rtn_date = '';
				} else {
					$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
				}

				$dummy = Null;
				$DataToBeDumped[] = array(
					$cnt->console_entity,
					$cnt->sbu,
					$cnt->cluster,
					$cnt->vertical,
					$cnt->country,
					$cnt->ar_type,
					$cnt->org_dpst,
					$cnt->area . '-' . $cnt->region,
					$cnt->region,
					$cnt->sales_engg_name,
					$cnt->customer_type,
					$cnt->child_code,
					$cnt->customer_name,
					$cnt->project_name,
					$cnt->org_document_number,
					$Invoice_date,
					$Rev_date,
					$cnt->invoice_amount,
					$cnt->paid_amount,
					$cnt->balance_amount,
					$cnt->currency,
					$cnt->fx_rate,
					$cnt->planned_coll_amt,
					//$dummy,
					$Planned_coll_date,
					//$dummy,
					$cnt->retention,
					//$dummy,
					$cnt->warranty_retention,
					//$dummy,
					$cnt->planned_rtn_wrtn_coll_amt,
					//$dummy,
					$Planned_rtn_date,
					//$dummy,
					$cnt->pbg_lc,
					//$dummy,
					$cnt->won,
					//$dummy,
					$cnt->cnaf,
					//$dummy,
					$cnt->srn,
					//$dummy,
					$cnt->foc,
					//$dummy,
					$cnt->wds,
					//$dummy,
					$cnt->gst_tds,
					//$dummy,
					$cnt->tds,
					//$dummy,
					$cnt->ld,
					//$dummy,
					$cnt->legal,
					//$dummy,
					$cnt->responsibility,
					$cnt->commissioning,
					//$dummy
				);
			}
			foreach ($DataToBeDumped as $row) {
				$writer->writeSheetRow('Sheet1', $row);
			}
			$file = 'User_Input_' . date('d-m-Y') . '.xlsx';
			$writer->writeToFile($file);

			if (file_exists($file)) {
				header('Content-Description: File Transfer');
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename="' . basename($file) . '"');
				header('Expires: 0');
				header('Cache-Control: must-revalidate');
				header('Pragma: public');
				header('Content-Length: ' . filesize($file));
				readfile($file);
				unlink($file);
				exit;
			}
		}
	}


	public function excel_download_current_ar()
	{

		if ($this->input->post("ar_type_id") != '') {
			$ar_type = array();
			foreach ($this->input->post("ar_type_id") as $a) {
				$ar_type[] = "'" . $a . "'";
			}
			$ar_type_id = " AND ar_type IN (" . implode(',', $ar_type) . ")";
		}

		if ($this->input->post("consol_id") != '') {
			$console = array();
			foreach ($this->input->post("consol_id") as $c) {
				$console[] = "'" . $c . "'";
			}
			$consol_id = " AND console_entity IN (" . implode(',', $console) . ")";
		}

		if ($this->input->post("sbu_id") != '') {
			$sbu = array();
			foreach ($this->input->post("sbu_id") as $s) {
				$sbu[] = "'" . $s . "'";
			}
			$sbu_id = " AND sbu IN (" . implode(',', $sbu) . ")";
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster = array();
			foreach ($this->input->post("cluster_id") as $cc) {
				$cluster[] = "'" . $cc . "'";
			}
			$cluster_id = " AND cluster IN (" . implode(',', $cluster) . ")";
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical = array();
			foreach ($this->input->post("vertical_id") as $v) {
				$vertical[] = "'" . $v . "'";
			}
			$vertical_id = " AND vertical IN (" . implode(',', $vertical) . ")";
		}

		if ($this->input->post("country_id") != '') {
			$country_id = array();
			foreach ($this->input->post("country_id") as $co) {
				$country_id[] = "'" . $co . "'";
			}
			$country = " AND country IN (" . implode(',', $country_id) . ")";
		}

		if ($this->input->post("region_id") != '') {
			$region_id = array();
			foreach ($this->input->post("region_id") as $co) {
				$region_id[] = "'" . $co . "'";
			}
			$region = " AND region IN (" . implode(',', $region_id) . ")";
		}

		if ($this->input->post("cust_type") != '') {
			$cust_type = " AND customer_type ='" . $this->input->post("cust_type") . "'";
		}

		if ($this->input->post("child_code") != '') {
			$child_code = " AND child_code ='" . $this->input->post("child_code") . "'";
		}

		if ($this->input->post("doc_num") != '') {
			$doc_num = " AND org_document_number ='" . $this->input->post("doc_num") . "'";
		}

		$data = $this->db->query("select * from current_ar_process_data where daily_ar_id !='0' " . $sbu_id . " " . $ar_type_id . " " . $consol_id . " " . $cluster_id . " " . $vertical_id . " " . $country . "" . $region . "" . $cust_type . "" . $child_code . "" . $doc_num)->result();
		// print_r($this->db->last_query());
		// die;
		if (isset($_POST['down_csv'])) {
			$csvData[] = array(
				"Consol_Entity", "SBU", "Cluster", "Vertical", "Country", "AR_Type", "Consol", "Area", "Region", "Org DPST", "Org TT", "Month", "Sales Engg Code", "Sales Engg Name", "Customer Group",
				"Parent Code",
				"Child Code",
				"Customer_Name",
				"Project_Name",
				"PO Number",
				"PO Credit Term",
				"Company",
				"Transaction Type",
				"Invoice Number",
				"Org. Document Number",
				"Dispatch Date",
				"Invoice_Date",
				"Credit Days",
				"Due Date",
				"Credit Days Adj",
				"Rev Due date",
				"Invoice Amount",
				"Paid Amount",
				"Balance Amount",
				"Currency",
				"FX Rate",
				"FX Invoice Amount",
				"FX Paid Amount",
				"FX Balance Amount",
				"Customer Type",
				"ECL Category",
				"ECL RTN Days",
				"FEMA Days",
				"Current Mth FX Rate",
				"Modified Doc",
				"Invoice Type",
				"OD Days",
				"Within Due",
				"Overdue",
				"FTM Due",
				"OD Ageing Category",
				"FX Within Due",
				"FX Over Due",
				"FX FTM Due",
				"FX Impact",
				"Collection Days",
				"Responsibity",
				"Planned Coll Amount",
				"Planned_Coll_Date",
				"Retention",
				"Retention_Warranty",
				"Planned_RTN_WRTN_Coll_Amount",
				"Planned_RTN_WRTN_Date",
				"WON",
				"LD",
				"Legal",
				"PBG_LC",
				"CNAF",
				"SRN",
				"FOC",
				"WDS",
				"TDS",
				"Actual Coll Amount",
				"Actual Coll Date"
			);

			foreach ($data as $cnt) {
				$csvData[] = array(
					$cnt->console_entity,
					$cnt->sbu,
					$cnt->cluster,
					$cnt->vertical,
					$cnt->country,
					$cnt->ar_type,
					$cnt->consol,
					$cnt->area,
					$cnt->region,
					$cnt->org_dpst,
					$cnt->org_tt,
					$cnt->month,
					$cnt->sales_engg_code,
					$cnt->sales_engg_name,
					$cnt->customer_group,
					$cnt->parent_code,
					$cnt->child_code,
					$cnt->customer_name,
					$cnt->project_name,
					$cnt->po_name,
					$cnt->po_credit_term,
					$cnt->company,
					$cnt->transaction_type,
					$cnt->invoice_number,
					$cnt->org_document_number,
					format_date($cnt->dispatch_date),
					format_date($cnt->invoice_date),
					$cnt->credit_days,
					format_date($cnt->due_date),
					$cnt->credit_days_adj,
					format_date($cnt->rev_due_date),
					money_format('%!i', $cnt->invoice_amount),
					money_format('%!i', $cnt->paid_amount),
					money_format('%!i', $cnt->balance_amount),
					$cnt->currency,
					money_format('%!i', $cnt->fx_rate),
					money_format('%!i', $cnt->fx_invoice_amount),
					money_format('%!i', $cnt->fx_paid_amount),
					money_format('%!i', $cnt->fx_balance_amount),
					$cnt->customer_type,
					$cnt->ecl_category,
					$cnt->ecl_days,
					$cnt->fema_days,
					money_format('%!i', $cnt->current_mth_fx_rate),
					$cnt->modified_doc,
					$cnt->invoice_type,
					$cnt->od_days,
					$cnt->within_due,
					money_format('%!i', $cnt->overdue),
					$cnt->ftm_due,
					$cnt->od_ageing_category,
					money_format('%!i', $cnt->fx_within_due),
					money_format('%!i', $cnt->fx_overdue),
					money_format('%!i', $cnt->fx_ftm_due),
					money_format('%!i', $cnt->fx_impact),
					$cnt->collection_days,
					$cnt->responsibility,
					money_format('%!i', $cnt->planned_coll_amt),
					format_date($cnt->planned_coll_date),
					money_format('%!i', $cnt->retention),
					money_format('%!i', $cnt->warranty_retention),
					money_format('%!i', $cnt->planned_rtn_wrtn_coll_amt),
					format_date($cnt->planned_rtn_wrtn_date),
					money_format('%!i', $cnt->won),
					money_format('%!i', $cnt->ld),
					money_format('%!i', $cnt->legal),
					money_format('%!i', $cnt->pbg_lc),
					money_format('%!i', $cnt->cnaf),
					money_format('%!i', $cnt->srn),
					money_format('%!i', $cnt->foc),
					money_format('%!i', $cnt->wds),
					money_format('%!i', $cnt->tds),
					money_format('%!i', $cnt->actual_coll_amount),
					format_date($cnt->actual_coll_date)
				);
			}

			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");
			header("Content-Disposition: attachment;filename=Current-AR-CSV_" . time() . ".csv");
			header("Content-Transfer-Encoding: binary");
			$df = fopen("php://output", 'w');
			array_walk($csvData, function ($row) use ($df) {
				fputcsv($df, $row);
			});
			fclose($df);
		}
		if (isset($_POST['down_xlsx'])) {
			if ($this->input->post("fx_type_id") == 1) {
				include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
				$header = array(
					'Consol Entity' => 'string', //text
					'SBU' => 'string', //text
					'Cluster' => 'string', //text
					'Vertical' => 'string', //text
					'Country' => 'string', //text
					'AR Type' => 'string', //text
					'Consol' => 'string', //text
					'Area' => 'string', //text
					'Region' => 'string', //text
					'Org DPST' => 'string', //text
					'Org TT' => 'string', //text
					'Month' => 'DD-MM-YYYY',
					'Sales Engg Code' => 'string', //text
					'Sales Engg Name' => 'string', //text
					'Customer Group' => 'string', //text
					'Parent Code' => 'string', //text
					'Child Code' => 'string', //text
					'Customer Name' => 'string', //text
					'Project Name' => 'string', //text
					'PO Number' => 'string', //text
					'PO Credit Term' => 'string', //text
					'Company' => 'string', //text
					'Transaction Type' => 'string', //text
					'Invoice Number' => 'string', //text
					'Org Document Number' => 'string', //text
					'Dispatch Date' => 'DD-MM-YYYY',
					'Invoice Date' => 'DD-MM-YYYY',
					'Credit Days' => 'integer', //text
					'Due Date' => 'DD-MM-YYYY',
					'Credit Days Adj' => 'integer', //text
					'Rev Due date' => 'DD-MM-YYYY',
					/* 				'Invoice_Amount' => '#,##0.00', //custom
					'Paid_Amount' => '#,##0.00', //custom
					'Balance_Amount' => '#,##0.00', //custom */
					'Currency' => 'string', //text
					'Fx Rate' => '#,##0.00', //custom
					'Fx Invoice Amount' => '#,##0.00', //custom
					'Fx Paid Amount' => '#,##0.00', //custom
					'Fx Balance Amount' => '#,##0.00', //custom
					'Customer Type' => 'string', //text
					'ECL Category' => 'string', //text
					'ECL RTN Days' => 'integer', //text
					'FEMA Days' => 'integer', //text
					'Current Mth FX Rate' =>  '#,##0.00', //custom
					'Modified Doc' => 'integer', //text
					'Invoice Type' => 'string', //text
					'OD Days' => 'integer', //text
					'Within Due' => '#,##0.00', //custom
					'Over Due' =>  '#,##0.00', //custom
					'FTM Due' => '#,##0.00', //custom
					'OD Ageing Category' => 'string', //text
					'FX Within Due' =>  '#,##0.00', //custom
					'FX Over Due' =>  '#,##0.00', //custom
					'FX FTM Due' => '#,##0.00', //custom
					'FX Impact' =>  '#,##0.00', //custom
					'Collection Days' => 'integer', //text
					'Responsibility' => 'string', //text
					'Planned Coll Amount' => '#,##0.00', //custom
					'Planned Coll Date' => 'DD-MM-YYYY',
					'Retention' =>  '#,##0.00', //custom
					'Retention Warranty' =>  '#,##0.00', //custom
					'Planned RTN WRTN Coll Amount' => '#,##0.00', //custom
					'Planned RTN WRTN Date' => 'DD-MM-YYYY',
					'PBG LC' => '#,##0.00', //custom
					'WON' => '#,##0.00', //custom
					'CNAF' => '#,##0.00', //custom
					'SRN' => '#,##0.00', //custom
					'FOC' => '#,##0.00', //custom
					'WDS' => '#,##0.00', //custom
					'TDS' => '#,##0.00', //custom
					'LD' => '#,##0.00', //custom
					'Legal' => '#,##0.00', //custom
					'Actual Coll Amount' => '#,##0.00', //custom
					'Actual Coll Date' => 'DD-MM-YYYY',
				);
				$writer = new XLSXWriter();
				$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff']]);
				foreach ($data as $cnt) {
					if ($cnt->dispatch_date == '0000-00-00' || $cnt->dispatch_date == '1970-01-01' || empty($cnt->dispatch_date)) {
						$Dispatch_date = '';
					} else {
						$Dispatch_date = $cnt->dispatch_date;
					}

					if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
						$Invoice_date = '';
					} else {
						$Invoice_date = $cnt->invoice_date;
					}

					if ($cnt->due_date == '0000-00-00' || $cnt->due_date == '1970-01-01' || empty($cnt->due_date)) {
						$Due_date = '';
					} else {
						$Due_date = $cnt->due_date;
					}

					if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
						$Rev_date = '';
					} else {
						$Rev_date = $cnt->rev_due_date;
					}

					if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
						$Planned_coll_date = '';
					} else {
						$Planned_coll_date = $cnt->planned_coll_date;
					}

					if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
						$Planned_rtn_date = '';
					} else {
						$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
					}

					if ($cnt->actual_coll_date == '0000-00-00' || $cnt->actual_coll_date == '1970-01-01' || empty($cnt->actual_coll_date)) {
						$Actual_coll_date = '';
					} else {
						$Actual_coll_date = $cnt->actual_coll_date;
					}
					$csvData[] = array(
						$cnt->console_entity,
						$cnt->sbu,
						$cnt->cluster,
						$cnt->vertical,
						$cnt->country,
						$cnt->ar_type,
						$cnt->consol,
						$cnt->area,
						$cnt->region,
						$cnt->org_dpst,
						$cnt->org_tt,
						$cnt->month,
						$cnt->sales_engg_code,
						$cnt->sales_engg_name,
						$cnt->customer_group,
						$cnt->parent_code,
						$cnt->child_code,
						$cnt->customer_name,
						$cnt->project_name,
						$cnt->po_name,
						$cnt->po_credit_term,
						$cnt->company,
						$cnt->transaction_type,
						$cnt->invoice_number,
						$cnt->org_document_number,
						$Dispatch_date,
						$Invoice_date,
						$cnt->credit_days,
						$Due_date,
						$cnt->credit_days_adj,
						$Rev_date,
						/* 	$cnt->invoice_amount,
						$cnt->paid_amount,
						$cnt->balance_amount, */
						$cnt->currency,
						$cnt->fx_rate,
						$cnt->fx_invoice_amount,
						$cnt->fx_paid_amount,
						$cnt->fx_balance_amount,
						$cnt->customer_type,
						$cnt->ecl_category,
						$cnt->ecl_days,
						$cnt->fema_days,
						$cnt->current_mth_fx_rate,
						$cnt->modified_doc,
						$cnt->invoice_type,
						$cnt->od_days,
						$cnt->within_due,
						$cnt->overdue,
						$cnt->ftm_due,
						$cnt->od_ageing_category,
						$cnt->fx_within_due,
						$cnt->fx_overdue,
						$cnt->fx_ftm_due,
						$cnt->fx_impact,
						$cnt->collection_days,
						$cnt->responsibility,
						$cnt->planned_coll_amt,
						$Planned_coll_date,
						$cnt->retention,
						$cnt->warranty_retention,
						$cnt->planned_rtn_wrtn_coll_amt,
						$Planned_rtn_date,
						$cnt->pbg_lc,
						$cnt->won,
						$cnt->cnaf,
						$cnt->srn,
						$cnt->foc,
						$cnt->wds,
						$cnt->tds,
						$cnt->ld,
						$cnt->legal,
						$cnt->actual_coll_amount,
						$Actual_coll_date
					);
				}

				foreach ($csvData as $row) {
					$writer->writeSheetRow('Sheet1', $row);
				}
				$file = 'Current_AR_' . date('d-m-Y') . '.xlsx';
				$writer->writeToFile($file);

				if (file_exists($file)) {
					header('Content-Description: File Transfer');
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . basename($file) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					readfile($file);
					unlink($file);
					exit;
				}
			} else {
				include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
				$header = array(
					'Consol Entity' => 'string', //text
					'SBU' => 'string', //text
					'Cluster' => 'string', //text
					'Vertical' => 'string', //text
					'Country' => 'string', //text
					'AR Type' => 'string', //text
					'Consol' => 'string', //text
					'Area' => 'string', //text
					'Region' => 'string', //text
					'Org DPST' => 'string', //text
					'Org TT' => 'string', //text
					'Month' => 'DD-MM-YYYY',
					'Sales Engg Code' => 'string', //text
					'Sales Engg Name' => 'string', //text
					'Customer Group' => 'string', //text
					'Parent Code' => 'string', //text
					'Child Code' => 'string', //text
					'Customer Name' => 'string', //text
					'Project Name' => 'string', //text
					'PO Number' => 'string', //text
					'PO Credit Term' => 'string', //text
					'Company' => 'string', //text
					'Transaction Type' => 'string', //text
					'Invoice Number' => 'string', //text
					'Org Document Number' => 'string', //text
					'Dispatch Date' => 'DD-MM-YYYY',
					'Invoice Date' => 'DD-MM-YYYY',
					'Credit Days' => 'integer', //text
					'Due Date' => 'DD-MM-YYYY',
					'Credit Days Adj' => 'integer', //text
					'Rev Due date' => 'DD-MM-YYYY',
					'Invoice_Amount' => '#,##0.00', //custom
					'Paid_Amount' => '#,##0.00', //custom
					'Balance_Amount' => '#,##0.00', //custom
					'Currency' => 'string', //text
					'Fx Rate' => '#,##0.00', //custom
					/* 'Fx Invoice Amount' => '#,##0.00', //custom
					'Fx Paid Amount' => '#,##0.00', //custom
					'Fx Balance Amount' => '#,##0.00', //custom */
					'Customer Type' => 'string', //text
					'ECL Category' => 'string', //text
					'ECL RTN Days' => 'integer', //text
					'FEMA Days' => 'integer', //text
					'Current Mth FX Rate' =>  '#,##0.00', //custom
					'Modified Doc' => 'integer', //text
					'Invoice Type' => 'string', //text
					'OD Days' => 'integer', //text
					'Within Due' => '#,##0.00', //custom
					'Over Due' =>  '#,##0.00', //custom
					'FTM Due' => '#,##0.00', //custom
					'OD Ageing Category' => 'string', //text
					'FX Within Due' =>  '#,##0.00', //custom
					'FX Over Due' =>  '#,##0.00', //custom
					'FX FTM Due' => '#,##0.00', //custom
					'FX Impact' =>  '#,##0.00', //custom
					'Collection Days' => 'integer', //text
					'Responsibility' => 'string', //text
					'Planned Coll Amount' => '#,##0.00', //custom
					'Planned Coll Date' => 'DD-MM-YYYY',
					'Retention' =>  '#,##0.00', //custom
					'Retention Warranty' =>  '#,##0.00', //custom
					'Planned RTN WRTN Coll Amount' => '#,##0.00', //custom
					'Planned RTN WRTN Date' => 'DD-MM-YYYY',
					'PBG LC' => '#,##0.00', //custom
					'WON' => '#,##0.00', //custom
					'CNAF' => '#,##0.00', //custom
					'SRN' => '#,##0.00', //custom
					'FOC' => '#,##0.00', //custom
					'WDS' => '#,##0.00', //custom
					'TDS' => '#,##0.00', //custom
					'LD' => '#,##0.00', //custom
					'Legal' => '#,##0.00', //custom
					'Actual Coll Amount' => '#,##0.00', //custom
					'Actual Coll Date' => 'DD-MM-YYYY',
				);
				$writer = new XLSXWriter();
				$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff']]);
				foreach ($data as $cnt) {
					if ($cnt->dispatch_date == '0000-00-00' || $cnt->dispatch_date == '1970-01-01' || empty($cnt->dispatch_date)) {
						$Dispatch_date = '';
					} else {
						$Dispatch_date = $cnt->dispatch_date;
					}

					if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
						$Invoice_date = '';
					} else {
						$Invoice_date = $cnt->invoice_date;
					}

					if ($cnt->due_date == '0000-00-00' || $cnt->due_date == '1970-01-01' || empty($cnt->due_date)) {
						$Due_date = '';
					} else {
						$Due_date = $cnt->due_date;
					}

					if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
						$Rev_date = '';
					} else {
						$Rev_date = $cnt->rev_due_date;
					}

					if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
						$Planned_coll_date = '';
					} else {
						$Planned_coll_date = $cnt->planned_coll_date;
					}

					if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
						$Planned_rtn_date = '';
					} else {
						$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
					}

					if ($cnt->actual_coll_date == '0000-00-00' || $cnt->actual_coll_date == '1970-01-01' || empty($cnt->actual_coll_date)) {
						$Actual_coll_date = '';
					} else {
						$Actual_coll_date = $cnt->actual_coll_date;
					}
					$csvData[] = array(
						$cnt->console_entity,
						$cnt->sbu,
						$cnt->cluster,
						$cnt->vertical,
						$cnt->country,
						$cnt->ar_type,
						$cnt->consol,
						$cnt->area,
						$cnt->region,
						$cnt->org_dpst,
						$cnt->org_tt,
						$cnt->month,
						$cnt->sales_engg_code,
						$cnt->sales_engg_name,
						$cnt->customer_group,
						$cnt->parent_code,
						$cnt->child_code,
						$cnt->customer_name,
						$cnt->project_name,
						$cnt->po_name,
						$cnt->po_credit_term,
						$cnt->company,
						$cnt->transaction_type,
						$cnt->invoice_number,
						$cnt->org_document_number,
						$Dispatch_date,
						$Invoice_date,
						$cnt->credit_days,
						$Due_date,
						$cnt->credit_days_adj,
						$Rev_date,
						$cnt->invoice_amount,
						$cnt->paid_amount,
						$cnt->balance_amount,
						$cnt->currency,
						$cnt->fx_rate,
						/* $cnt->fx_invoice_amount,
						$cnt->fx_paid_amount,
						$cnt->fx_balance_amount, */
						$cnt->customer_type,
						$cnt->ecl_category,
						$cnt->ecl_days,
						$cnt->fema_days,
						$cnt->current_mth_fx_rate,
						$cnt->modified_doc,
						$cnt->invoice_type,
						$cnt->od_days,
						$cnt->within_due,
						$cnt->overdue,
						$cnt->ftm_due,
						$cnt->od_ageing_category,
						$cnt->fx_within_due,
						$cnt->fx_overdue,
						$cnt->fx_ftm_due,
						$cnt->fx_impact,
						$cnt->collection_days,
						$cnt->responsibility,
						$cnt->planned_coll_amt,
						$Planned_coll_date,
						$cnt->retention,
						$cnt->warranty_retention,
						$cnt->planned_rtn_wrtn_coll_amt,
						$Planned_rtn_date,
						$cnt->pbg_lc,
						$cnt->won,
						$cnt->cnaf,
						$cnt->srn,
						$cnt->foc,
						$cnt->wds,
						$cnt->tds,
						$cnt->ld,
						$cnt->legal,
						$cnt->actual_coll_amount,
						$Actual_coll_date
					);
				}

				foreach ($csvData as $row) {
					$writer->writeSheetRow('Sheet1', $row);
				}
				$file = 'Current_AR__' . date('d-m-Y') . '.xlsx';
				$writer->writeToFile($file);

				if (file_exists($file)) {
					header('Content-Description: File Transfer');
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . basename($file) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					readfile($file);
					unlink($file);
					exit;
				}
			}
		}
	}



	public function upload_user_input_exel()
	{

		$month_year = $this->input->post('month_year');

		if ($this->input->post("ar_type_id") != '') {
			$ar_type = array();
			foreach ($this->input->post("ar_type_id") as $a) {
				$ar_type[] = "'" . $a . "'";
			}
			$ar_type_id = " AND ar_type IN (" . implode(',', $ar_type) . ")";
		}

		if ($this->input->post("sbu_id") != '') {
			$sbu = array();
			foreach ($this->input->post("sbu_id") as $s) {
				$sbu[] = "'" . $s . "'";
			}
			$sbu_id = " AND sbu IN (" . implode(',', $sbu) . ")";
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster = array();
			foreach ($this->input->post("cluster_id") as $cc) {
				$cluster[] = "'" . $cc . "'";
			}
			$cluster_id = " AND cluster IN (" . implode(',', $cluster) . ")";
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical = array();
			foreach ($this->input->post("vertical_id") as $v) {
				$vertical[] = "'" . $v . "'";
			}
			$vertical_id = " AND vertical IN (" . implode(',', $vertical) . ")";
		}

		$data = $this->db->query("select * from user_input WHERE month_year ='" . $month_year . "' " . $sbu_id . " " . $ar_type_id . " " . $cluster_id . " " . $vertical_id . " AND user_id='" . $this->ion_auth->get_user_id() . "'")->result();

		include_once(APPPATH . "/third_party/PHP_XLSXWriter/xlsxwriter.class.php");
		$header = array(
			'Consol_Entity' => 'string', //text
			'SBU' => 'string', //text
			'Cluster' => 'string', //text
			'Vertical' => 'string', //text
			'Country' => 'string', //text
			'AR_Type' => 'string', //text
			'Child_Code' => 'string', //text
			'Customer_Name' => 'string', //text
			'Project_Name' => 'string', //text
			'Org_Document_Number' => 'string', //text
			'Invoice_Date' => 'DD-MM-YYYY',
			'Rev_Due_Date' => 'DD-MM-YYYY',
			'Invoice_Amount' => '#,##0.00', //custom
			'Paid_Amount' => '#,##0.00', //custom
			'Balance_Amount' => '#,##0.00', //custom
			'Currency' => 'string', //text
			'Fx_Rate' => '#,##0.00', //custom
			'Planned_Coll_Amount' => '#,##0.00', //custom
			'Planned_Coll_Date' => 'DD-MM-YYYY',
			'Retention' => 'string', //text
			'Retention_Warranty' => 'string', //text
			'Planned_RTN_WRTN_Coll_Amount' => '#,##0.00', //custom
			'Planned_RTN_WRTN_Date' => 'DD-MM-YYYY',
			'PBG_LC' => '#,##0.00', //custom
			'WON' => '#,##0.00', //custom
			'CNAF' => '#,##0.00', //custom
			'SRN' => '#,##0.00', //custom
			'FOC' => '#,##0.00', //custom
			'WDS' => '#,##0.00', //custom
			'TDS' => '#,##0.00', //custom
			'LD' => '#,##0.00', //custom
			'Legal' => '#,##0.00', //custom
			'Responsibility' => 'string', //text
			'Legal' => '#,##0.00', //custom

		);

		$writer = new XLSXWriter();
		$writer->writeSheetHeader('Sheet1', $header, $col_options = ['widths' => [20, 20, 20, 20, 20, 20, 20, 40, 30, 20, 20, 20, 20, 20, 20, 20, 30, 20, 20, 20, 30, 40, 40, 20, 20, 20, 20, 20, 20, 20, 20, 20, 30], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['fill' => '#0558ff', 'font-style' => 'bold', 'font-size' => 11, 'color' => '#ffffff'], ['height' => 20]]);
		foreach ($data as $cnt) {
			if ($cnt->invoice_date == '0000-00-00' || $cnt->invoice_date == '1970-01-01' || empty($cnt->invoice_date)) {
				$Invoice_date = '';
			} else {
				$Invoice_date = $cnt->invoice_date;
			}

			if ($cnt->rev_due_date == '0000-00-00' || $cnt->rev_due_date == '1970-01-01' || empty($cnt->rev_due_date)) {
				$Rev_date = '';
			} else {
				$Rev_date = $cnt->rev_due_date;
			}

			if ($cnt->planned_coll_date == '0000-00-00' || $cnt->planned_coll_date == '1970-01-01' || empty($cnt->planned_coll_date)) {
				$Planned_coll_date = '';
			} else {
				$Planned_coll_date = $cnt->planned_coll_date;
			}

			if ($cnt->planned_rtn_wrtn_date == '0000-00-00' || $cnt->planned_rtn_wrtn_date == '1970-01-01' || empty($cnt->planned_rtn_wrtn_date)) {
				$Planned_rtn_date = '';
			} else {
				$Planned_rtn_date = $cnt->planned_rtn_wrtn_date;
			}

			$DataToBeDumped[] = array(
				$cnt->console_entity,
				$cnt->sbu,
				$cnt->cluster,
				$cnt->vertical,
				$cnt->country,
				$cnt->ar_type,
				$cnt->child_node,
				$cnt->customer_name,
				$cnt->project_name,
				$cnt->org_document_number,
				$Invoice_date,
				$Rev_date,
				$cnt->invoice_amount,
				$cnt->paid_amount,
				$cnt->balance_amount,
				$cnt->currency,
				$cnt->fx_rate,
				$cnt->planned_coll_amt,
				$Planned_coll_date,
				$cnt->retention,
				$cnt->warranty_retention,
				$cnt->planned_rtn_wrtn_coll_amt,
				$Planned_rtn_date,
				$cnt->pbg_lc,
				$cnt->won,
				$cnt->cnaf,
				$cnt->srn,
				$cnt->foc,
				$cnt->wds,
				$cnt->tds,
				$cnt->ld,
				$cnt->legal,
				$cnt->responsibility,
				$cnt->commissioning
			);
		}
		foreach ($DataToBeDumped as $row) {
			$writer->writeSheetRow('Sheet1', $row);
		}
		$file = 'User_Input_' . date('d-m-Y') . '.xlsx';
		$writer->writeToFile($file);

		if (file_exists($file)) {
			header('Content-Description: File Transfer');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename="' . basename($file) . '"');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			header('Content-Length: ' . filesize($file));
			readfile($file);
			unlink($file);
			exit;
		}
	}


	public function collection_plan_horizon($param='')
	{
		
		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();

			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("child_code") != '') {
				$child_code = $this->input->post("child_code");
			} else {
				$child_code = '';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}
			

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['region_id'] = $region_id;

			$this->data['month_end_ar_list'] = $this->base_model->CollectionPlanHorizontalReport($month_year, $console_entity_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id);
			
		} else {

			$this->data['month_end_ar_list'] = '';
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			$this->data['month_year'] = $month_year;
		}
		

		/* templete */
		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/collection_plan_horizon');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/collection_plan_horizon', $this->data);
	}

	public function rolling_collection_plan($param = '')
	{

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();

			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("child_code") != '') {
				$child_code = $this->input->post("child_code");
			} else {
				$child_code = '';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}


			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$org_document_no = $this->input->post("org_document_no");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['org_document_no'] = $org_document_no;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['region_id'] = $region_id;

			$this->data['month_end_ar_list'] = $this->base_model->rollingCollectionReport($month_year, $console_entity_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $org_document_no, $region_id);
		} else {

			$this->data['month_end_ar_list'] = '';
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			$this->data['month_year'] = $month_year;
		}

		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/rolling_collection_plan');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/rolling_collection_plan', $this->data);
	}


	public function delayed_collection($param = '')
	{

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();

			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("child_code") != '') {
				$child_code = $this->input->post("child_code");
			} else {
				$child_code = '';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$child_code = $this->input->post("child_code");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['child_code'] = $child_code;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['region_id'] = $region_id;

			$this->data['month_end_ar_list'] = $this->base_model->getDelayedCollectionReport($month_year, $console_entity_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $child_code, $region_id);

			// print_r($this->db->last_query());die;

		} else {

			$this->data['month_end_ar_list'] = '';
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();

		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/delayed_collection');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/delayed_collection', $this->data);
	}


	public function collection_details_report($param = '')
	{

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();

			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			/* if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			} */

			if ($this->input->post("child_code") != '') {
				$child_code = $this->input->post("child_code");
			} else {
				$child_code = '';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("consol_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$child_code = $this->input->post("child_code");
			$org_document_no = $this->input->post("org_document_no");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['consol_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['child_code'] = $child_code;
			$this->data['denomination'] = $denomination;
			// $this->data['fx_type_id'] = $fx_type_id;
			$this->data['org_document_no'] = $org_document_no;
			$this->data['region_id'] = $region_id;

			$this->data['month_end_ar_list'] = $this->base_model->getCollectionDetailedReport($month_year, $console_entity_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $child_code, $org_document_no, $region_id);

			// print_r($this->db->last_query());die;

		} else {

			$this->data['month_end_ar_list'] = '';
		}

		$this->data['region_master'] = $this->db->query("select * from region_master")->result();

		$this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/reports/collection_details_report');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		$this->template->admin_render('admin/reports/collection_details_report', $this->data);
	}
	
	
	
	//---------- Collection Plan Horizontal Report -------------------//

	public function CollectionPlanHorizontalReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$denomination = $_POST['denomination'];

		$fx_type_id = $_POST['fx_type_id'];

		$consol_id = $_POST['consol_id'];

		$region_id = $_POST['region_id'];
		
		$country_id = $_POST['country_id'];
		
		$ar_type_id = $_POST['ar_type_id'];



		$openModalFillData = "";

		if (!empty($vertical_id)) {
		
				$openModalFillData .= '<tr class="details' . preg_replace("/\s+/", "",$vertical_id) . '" data-id="' . $vertical_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';
				
				$openModalFillData .= '<td>OD</td>';
				
				$od_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, '');

				if ($fx_type_id == 0) {

					$ver_od_amt = $od_amt->overdue / $denomination;
				} elseif ($fx_type_id == 1) {

					$ver_od_amt = $od_amt->fx_overdue / $denomination;
				}


				if ($ver_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $ver_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				
				
			$od_total = 0; for($i=3; $i>=1; $i--){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'OD')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;

				if ($actual_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $actual_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_avrage = ($od_total / 3);

				if ($od_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				$od_planned_total = 0; for($e=1; $e<=12; $e++){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id, 'OD', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;

				if ($planned_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $planned_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_planned_avrage = ($od_planned_total);
				

				if ($od_planned_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_planned_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$openModalFillData .= ' </tr>';
				
				
				//------- FTM --------------//
				
				$openModalFillData .= '<tr class="details' . preg_replace("/\s+/", "",$vertical_id) . '" data-id="' . $vertical_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';
				
				$openModalFillData .= '<td>FTM</td>';
				
				$od_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, '');

				if ($fx_type_id == 0) {

					$ver_od_amt = $od_amt->ftm_due / $denomination;
				} elseif ($fx_type_id == 1) {

					$ver_od_amt = $od_amt->fx_ftm_due / $denomination;
				}


				if ($ver_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $ver_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				
				
			$od_total = 0; for($i=3; $i>=1; $i--){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'FTM')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;

				if ($actual_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $actual_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_avrage = ($od_total / 3);

				if ($od_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				$od_planned_total = 0; for($e=1; $e<=12; $e++){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id, 'FTM', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;

				if ($planned_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $planned_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_planned_avrage = ($od_planned_total);
				

				if ($od_planned_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_planned_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$openModalFillData .= ' </tr>';
				
				
				//----------- NOT Due -----------//
				
				
				$openModalFillData .= '<tr class="details' . preg_replace("/\s+/", "",$vertical_id) . '" data-id="' . $vertical_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';
				
				$openModalFillData .= '<td>Not Due</td>';
				
				$not_due_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, '');

				$ver_od_amt = (($not_due_amt->within_due - $not_due_amt->ret - $not_due_amt->wret - $not_due_amt->ftm_due) / $denomination);


				if ($ver_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $ver_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				
				
			$od_total = 0; for($i=3; $i>=1; $i--){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'Not Due')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;

				if ($actual_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $actual_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_avrage = ($od_total / 3);

				if ($od_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				$od_planned_total = 0; for($e=1; $e<=12; $e++){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id, 'Not Due', $country_id)->planned / $denomination;
				
				
				$od_planned_total = $od_planned_total + $planned_od_amt;

				if ($planned_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $planned_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_planned_avrage = ($od_planned_total);
				

				if ($od_planned_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_planned_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$openModalFillData .= ' </tr>';
				
				
				//----------- SAME MONTH -----------//
				
				
				$openModalFillData .= '<tr class="details' . preg_replace("/\s+/", "",$vertical_id) . '" data-id="' . $vertical_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';
				
				$openModalFillData .= '<td>SAME MTH</td>';
				
				$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				
			$od_total = 0; for($i=3; $i>=1; $i--){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$actual_od_amt0 =  $this->base_model->ActualCollectionDateAmt(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id, $country_id)->actual / $denomination;
				
				
				$actual_od_amt1 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'OD')->actual / $denomination;
				
				$actual_od_amt2 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'FTM')->actual / $denomination;
				
			    $actual_od_amt3 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, 'Not Due')->actual / $denomination;
				
				$actual_od_amt  = $actual_od_amt0 - $actual_od_amt1 - $actual_od_amt2 - $actual_od_amt3;
				
				$od_total = $od_total + $actual_od_amt;

				if ($actual_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $actual_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
			}
		
		
				$od_avrage = ($od_total / 3);

				if ($od_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				$od_planned_total = 0; for($i=1; $i<=12; $i++){	

				$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				
				}
				
				$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';

				$openModalFillData .= ' </tr>';
				
				
				//----------- RTN/ WRTN ---------------//
				
				
				$openModalFillData .= '<tr class="details' . preg_replace("/\s+/", "",$vertical_id) . '" data-id="' . $vertical_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>-</td>';
				
				$openModalFillData .= '<td>RTN/WRTN</td>';
				
				$rtn_wrtn_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $vertical_id, $region_id, $country_id, $ar_type_id, '');

				$ver_od_amt = (($rtn_wrtn_amt->ret + $rtn_wrtn_amt->wret) / $denomination);

				if ($ver_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $ver_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				
				
			$od_total = 0; for($i=3; $i>=1; $i--){	
				
				$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				
				
				}
		
		
				$od_avrage = ($od_total / 3);

				if ($od_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
				
				$od_planned_total = 0; for($e=1; $e<=12; $e++){	
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$planned_od_amt = $this->base_model->CollectionRTNPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $region_id, '', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;

				if ($planned_od_amt != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $planned_od_amt) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}
				
		}
		
		
				$od_planned_avrage = ($od_planned_total);
				

				if ($od_planned_avrage != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $od_planned_avrage) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$openModalFillData .= ' </tr>';
				
				
				
		}



		$resultData['openModalFillData'] = $openModalFillData;

		echo json_encode($resultData['openModalFillData']);
	}
	
	
	
	
	//-------- Collection Plan Horizontal Excel Export -----------------//
	
	function CollectionPlanHorizontalExcel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;

		if ($this->input->post("fx_type_id") != '') {
			$fx_type_id = $this->input->post("fx_type_id");
		} else {
			$fx_type_id = '0';
		}

		$this->data['fx_type_id'] = $fx_type_id;



		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("console_id") != '') {
			$console_id = explode(',', $this->input->post("console_id"));
			$this->data['console_id'] = implode(',', $this->input->post("console_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}
		
		if ($this->input->post("Country_id") != '') {
			$Country_id = explode(',', $this->input->post("Country_id"));
			$this->data['Country_id'] = implode(',', $this->input->post("Country_id"));
		}
		
		$vertical_list = $this->base_model->CollectionPlanHorizontalReport($month_year, $console_id, $sbu_id, $cluster_id, $vertical_id, $ar_type_id, $org_document_no, $region_id);

		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);
		
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '0070c0'),
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff'),
				'bold' => true
			)
		);
		
		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '808080'),
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff'),
				'bold' => true
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '00B050'),
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff'),
				'bold' => true
			)
		);

	

		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '2', ' - Collection Plan Horizontal Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
		
		$objPHPExcel->getActiveSheet()->getRowDimension('5')->setRowHeight(20);
		$objPHPExcel->getActiveSheet()->getRowDimension('4')->setRowHeight(20);
				
		$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Last 3 Months Actual Collection Avg');
		$objPHPExcel->getActiveSheet()->setCellValue('K4', 'Collection Plan (Rolling 12 months with Month 1 = current on going calendar month)');
		
		$objPHPExcel->getActiveSheet(0)->getStyle('F:W')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		
		$objPHPExcel->getActiveSheet(0)->getStyle('A5:E5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
		$objPHPExcel->getActiveSheet(0)->getStyle('F5:W5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		
		$objPHPExcel->getActiveSheet(0)->getStyle('E')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
		
		$objPHPExcel->getActiveSheet(0)->getStyle('G4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objPHPExcel->getActiveSheet(0)->getStyle('K4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


		// Add some data

		$objPHPExcel->getActiveSheet()->getStyle('A5:W5')->applyFromArray($bgcolorblue);
		
		$objPHPExcel->getActiveSheet()->getStyle('G4:J4')->applyFromArray($bgcolor);
		
		$objPHPExcel->getActiveSheet()->getStyle('K4:W4')->applyFromArray($bgblue);
		
		
		$objPHPExcel->setActiveSheetIndex()->mergeCells('G4:J4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('K4:W4');

		$objPHPExcel->getActiveSheet()->setCellValue('A5', 'Consol_Entity');
		$objPHPExcel->getActiveSheet()->setCellValue('B5', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('C5', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('D5', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('E5', 'Invoice Type');
		$objPHPExcel->getActiveSheet()->setCellValue('F5', 'Balance Amount');
		
		$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));

		$mm = "G";
		for($i=3; $i>=1; $i--){
			$objPHPExcel->getActiveSheet()->setCellValue($mm.'5', date('m-Y', strtotime("-".$i ." month", $StartYearMonth)));
			$mm++;
		}	
		
		$objPHPExcel->getActiveSheet()->setCellValue('J5', 'Average');
		
		$mn = "K";
		for($e=1; $e<=12; $e++){
			$objPHPExcel->getActiveSheet()->setCellValue($mn.'5', date('m-Y', strtotime($e ." month", $StartYearMonth)));
			$mn++;
		}	
		
		$objPHPExcel->getActiveSheet()->setCellValue('W5', 'TOTAL');


		$c = '6';
		
		foreach ($vertical_list as $l) {

			if (!empty($l->console_entity)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
			}

			if (!empty($l->sbu)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
			}

			if (!empty($l->cluster)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
			}
			
			if (!empty($l->vertical)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "NA");
			}
			
			
			$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "-");
			
			if ($fx_type_id == 0) {
				$balance_amt = $l->bal / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $balance_amt));
			} elseif ($fx_type_id == 1) {
				$balance_amt = $l->fx_bal / $denomination;
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $balance_amt));
			}
			
			
			$mv = "G";
			$total =0;  for($i=3; $i>=1; $i--){
				
				$total_actual =  $this->base_model->ActualCollectionDateAmt(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $console_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, $country_id)->actual / $denomination;
				   
				$total = $total + $total_actual;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv .''.$c , money_format('%!n', $total_actual));
				
				$mv++;
			}
			
			
			$avrage = ($total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$c , money_format('%!n', $avrage));
			
			
			$mo = "K";
			$total_plan = 0; $od_planned_total1 = 0; for($e=1; $e<=12; $e++){
				
				$total_plan_coll =  $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $console_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, '', $country_id)->planned / $denomination;
				
				$planned_od_amt = $this->base_model->CollectionRTNPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $console_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, '', $country_id)->planned / $denomination;
				
				$od_planned_total1 = $od_planned_total1 + $planned_od_amt;
				   
				$total_plan = $total_plan + $total_plan_coll;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo.''.$c, money_format('%!n', ($total_plan_coll + $planned_od_amt)));
				
				$mo++;
			}	
		
		 $tot_average = ($total_plan + $od_planned_total1);
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$c , money_format('%!n', $tot_average));


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}
			
			//----------------- OD -----------------//

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");
					
					$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");
					
					$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "OD");
					
					
					$od_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, '');
			
					if ($fx_type_id == 0) {
						$balance_amt1 = $od_amt->overdue / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $balance_amt1));
					} elseif ($fx_type_id == 1) {
						$balance_amt1 = $od_amt->fx_overdue / $denomination;
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $balance_amt1));
					}
					
			
			
			$mv1 = "G";
			$od_total = 0;  for($i=3; $i>=1; $i--){
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'OD')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv1 .''.$D , money_format('%!n', $actual_od_amt));
				
				$mv1++;
			}
			
			
			$od_avrage = ($od_total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$D , money_format('%!n', $od_avrage));
			
			
			$mo1 = "K";
			$od_planned_total = 0; for($e=1; $e<=12; $e++){
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, 'OD', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo1.''.$D, money_format('%!n', $planned_od_amt));
				
				$mo1++;
			}	
		
		 $od_planned_avrage = ($od_planned_total);
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$D , money_format('%!n', $od_planned_avrage));
		 
		 $D++;
		 
		 
		 //------------------- FTM ------------//

		
        $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "FTM");
					
					
		$od_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, '');
			
		if ($fx_type_id == 0) {
		 $balance_amt1 = $od_amt->ftm_due / $denomination;
		 $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $balance_amt1));
		} elseif ($fx_type_id == 1) {
		 $balance_amt1 = $od_amt->fx_ftm_due / $denomination;
		 $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $balance_amt1));
		}	
			
			$mv4 = "G";
			$od_total = 0;  for($i=3; $i>=1; $i--){
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'FTM')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv4 .''.$D , money_format('%!n', $actual_od_amt));
				
				$mv4++;
			}
			
			
			$od_avrage = ($od_total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$D , money_format('%!n', $od_avrage));
			
			
			$mo4 = "K";
			$od_planned_total = 0; for($e=1; $e<=12; $e++){
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, 'FTM', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo4.''.$D, money_format('%!n', $planned_od_amt));
				
				$mo4++;
			}	
		
		 $od_planned_avrage = ($od_planned_total);
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$D , money_format('%!n', $od_planned_avrage));
		 
		 $D++;

		//---------------- Not Due ------------//	
			
        $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "Not Due");
					
					
		$not_due_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, '');

		$ver_od_amt = (($not_due_amt->within_due - $not_due_amt->ret - $not_due_amt->wret - $not_due_amt->ftm_due));
		
		$ver_od_amt1 = $ver_od_amt / $denomination;
		$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $ver_od_amt1));	
			
			$mv2 = "G";
			$od_total = 0;  for($i=3; $i>=1; $i--){
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
			    $actual_od_amt = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'Not Due')->actual / $denomination;
				
				$od_total = $od_total + $actual_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv2 .''.$D , money_format('%!n', $actual_od_amt));
				
				$mv2++;
			}
			
			
			$od_avrage = ($od_total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$D , money_format('%!n', $od_avrage));
			
			
			$mo2 = "K";
			$od_planned_total = 0; for($e=1; $e<=12; $e++){
				
				$planned_od_amt = $this->base_model->CollectionPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, 'Not Due', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo2.''.$D, money_format('%!n', $planned_od_amt));
				
				$mo2++;
			}	
		
		 $od_planned_avrage = ($od_planned_total);
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$D , money_format('%!n', $od_planned_avrage));
		 
		 $D++;
		 
		 
		 //------------ SAME Month -----------------------//
		 
        $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "SAME MTH");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', "0.00"));	
			
			$mv3 = "G";
			$od_total = 0;  for($i=3; $i>=1; $i--){
				
				$StartYearMonth = strtotime(date('Y-m-d', strtotime("01-" . $month_year)));
				
				$actual_od_amt0 =  $this->base_model->ActualCollectionDateAmt(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, $country_id)->actual / $denomination;
				
				
				$actual_od_amt1 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'OD')->actual / $denomination;
				
				$actual_od_amt2 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'FTM')->actual / $denomination;
				
			    $actual_od_amt3 = $this->base_model->getODCollectionPlanHorizontal(date('m-Y', strtotime("-".$i ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, 'Not Due')->actual / $denomination;
				
				$actual_od_amt  = $actual_od_amt0 - $actual_od_amt1 - $actual_od_amt2 - $actual_od_amt3;
				
				$od_total = $od_total + $actual_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv3 .''.$D , money_format('%!n', $actual_od_amt));
				
				$mv3++;
			}
			
			
			$od_avrage = ($od_total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$D , money_format('%!n', $od_avrage));
			
			
			$mo3 = "K";
			$od_planned_total = 0; for($e=1; $e<=12; $e++){
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo3.''.$D, "0.00");
				
				$mo3++;
			}	
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$D , "0.00");
		 
		 $D++;
		 
		 //---------- RTN / WRTN -------------//
					
		
		$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, "-");

		$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, "-");
					
		$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, "RTN/WRTN");
					
					
		$rtn_wrtn_amt = $this->base_model->getODCollectionPlanHorizontal($month_year, $consol_id, $sbu_id, $cluster_id, $l->vertical, $region_id, $country_id, $ar_type_id, '');

		$ver_od_amt = (($rtn_wrtn_amt->ret + $rtn_wrtn_amt->wret));
		
		$ver_od_amt1 = $ver_od_amt / $denomination;
		
		$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $ver_od_amt1));	
		
			
			$mv5 = "G";
			$od_total = 0;  for($i=3; $i>=1; $i--){
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mv5 .''.$D, "0.00");
				
				$mv5++;
			}
			
			
			$od_avrage = ($od_total / 3);
			
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$D , money_format('%!n', $od_avrage));
			
			
			$mo5 = "K";
			$od_planned_total = 0; for($e=1; $e<=12; $e++){
				
				$planned_od_amt = $this->base_model->CollectionRTNPlanHorizontalDateAmt($month_year, date('m-Y', strtotime($e ." month", $StartYearMonth)), $consol_id, $sbu_id, $cluster_id, $l->vertical, $ar_type_id, $region_id, '', $country_id)->planned / $denomination;
				
				$od_planned_total = $od_planned_total + $planned_od_amt;
				   
				$objPHPExcel->getActiveSheet()->setCellValue($mo5.''.$D, money_format('%!n', $planned_od_amt));
				
				$mo5++;
			}	
		
		 $od_planned_avrage = ($od_planned_total);
		
		 $objPHPExcel->getActiveSheet()->setCellValue('W'.$D , money_format('%!n', $od_planned_avrage));
		 
		  $D++;

			$c = $D;

			$c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Collection Plan Horizontal Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Collection Plan Horizontal Report -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
		
	}


	//------------------- User Wise Colection Summary Report -----------------------//

	function user_collection_summary_report($param = '')
	{
		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}

		if (!$this->ion_auth->is_admin()) {

			$ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

			$ver = '';
			if (!empty($ver_id)) {
				$ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
			} else {
				$ver = '';
			}

			/* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

			if (!empty($ver)) {
				$this->data['vertical_master']  = $ver;
			} else {
				$this->data['vertical_master']  = '';
			}


			$this->data['cluster_master'] 	= $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


			$this->data['ar_type_master'] 	= $this->db->query("select * from ar_type_master")->result();

			$this->data['sbu_master'] 		= $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


			$this->data['console_entity'] 	= $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


			$this->data['country_master'] 	= $this->db->query("select * from country_master")->result();
		} else {
			$this->data['vertical_master']  = $this->db->query("select * from vertical_master order by position")->result();
			$this->data['ar_type_master']   = $this->db->query("select * from ar_type_master")->result();
			$this->data['console_entity']   = $this->db->query("select * from console_master")->result();
			$this->data['cluster_master']   = $this->db->query("select * from cluster_master order by position")->result();
			$this->data['sbu_master'] 		= $this->db->query("select * from sbu_master")->result();
		}

		if ($param == 'search') {

			if ($this->input->post("month_year") != '') {
				$month_year = $this->input->post("month_year");
			} else {
				$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
			}

			if ($this->input->post("fx_type_id") != '') {
				$fx_type_id = $this->input->post("fx_type_id");
			} else {
				$fx_type_id = '0';
			}

			if ($this->input->post("denomination") != '') {
				$denomination = $this->input->post("denomination");
			} else {
				$denomination = '1';
			}

			$month_check = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "'")->row();

			if (count($month_check) >= 1) {
				$month_end_array = $this->db->query("select * from cron_table where cron_type='month_end_ar' and 
			month='" . $month_year . "' and cron_status ='1' and process_data ='1'")->row();

				if (count($month_end_array) >= 1) {
					$this->data['cron_status'] = 1;
				} else {
					$this->data['cron_status'] = 0;
				}
			} else {
				$this->data['cron_status'] = 2;
			}

			$ar_type_id = $this->input->post("ar_type_id");
			$console_entity_id = $this->input->post("console_entity_id");
			$sbu_id = $this->input->post("sbu_id");
			$cluster_id = $this->input->post("cluster_id");
			$vertical_id = $this->input->post("vertical_id");
			$region_id = $this->input->post("region_id");
			$this->data['month_year'] = $month_year;
			$this->data['ar_type_id'] = $ar_type_id;
			$this->data['console_entity_id'] = $console_entity_id;
			$this->data['sbu_id'] = $sbu_id;
			$this->data['cluster_id'] = $cluster_id;
			$this->data['vertical_id'] = $vertical_id;
			$this->data['denomination'] = $denomination;
			$this->data['fx_type_id'] = $fx_type_id;
			$this->data['region_id'] = $region_id;

			$this->data['sbu_list'] = $this->base_model->getVerticalSBUlist($console_entity_id, $sbu_id, $cluster_id, $vertical_id);
		} else {


			$this->data['sbu_list'] = '';
		}
		$this->data['region_master'] = $this->db->query("select * from region_master")->result();
		$this->template->admin_render('admin/reports/user_collection_summary_report', $this->data);
	}	
	
	
	
	//---------- User Collection Summary Report -------------------//

	public function UserCollectionSummaryReportAjaxMethod($value = '')
	{

		$month_year = $_POST['month_year'];

		$console_entity_id = $_POST['console_entity_id'];

		$cluster_id = $_POST['cluster_id'];

		$sbu_id = $_POST['sbu_id'];

		$vertical_id = $_POST['vertical_id'];

		$denomination = $_POST['denomination'];

		$fx_type_id = $_POST['fx_type_id'];

		$region_id = $_POST['region_id'];


		$cluster_list = $this->base_model->getClusterMappingNames($sbu_id, $cluster_id, $vertical_id, $console_entity_id);


		$openModalFillData = "";

		if (!empty($cluster_list)) {
			foreach ($cluster_list as $clu) {

				$c_mon_AR = $this->base_model->getClusterwiseCollectionSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);


				$openModalFillData .= '<tr class="details' . $sbu_id . '" data-id="' . $clu->cluster_id . '' . $clu->sbu_id . '" style="background: #d4d5ff !important;">';

				$openModalFillData .= '<td class="details-control-chk"></td>';

				$openModalFillData .= '<td>-</td>';

				$openModalFillData .= '<td>' . get_cluster_name($clu->cluster_id) . '</td>';

				$openModalFillData .= '<td style="border-right: solid 6px #fff;">-</td>';

				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->bal / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_bal / $denomination) . '</td>';
				}


				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->overdue / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_overdue / $denomination) . '</td>';
				}


				if ($fx_type_id == 0) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->ftm_due / $denomination) . '</td>';
				} elseif ($fx_type_id == 1) {

					$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_mon_AR->fx_ftm_due / $denomination) . '</td>';
				}

				if ($fx_type_id == 0) {

					$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->ftm_due;
				} elseif ($fx_type_id == 1) {

					$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->fx_ftm_due;
				}

				if ($notdue != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $notdue / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}

				$tot_ret = $c_mon_AR->ret + $c_mon_AR->wret;

				if ($tot_ret != '') {
					$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >' . money_format('%!i', $tot_ret / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >0.00</td>';
				}

				
				$c_coll_plan = $this->base_model->getClusterUserCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);
					 
				$c_coll_rtn_wrtn_plan = $this->base_model->getClusterUserCollectionPlanSummaryrtnwrtn($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', ($c_coll_plan->col + $c_coll_rtn_wrtn_plan->rtn_wrtn_amt) / $denomination) . '</td>';
				
				$c_coll_plan_od = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "OD", $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan_od->planned_coll_amt / $denomination) . '</td>';
				
				$c_coll_plan_ftm = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "FTM", $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan_ftm->planned_coll_amt / $denomination) . '</td>';
				
				$c_coll_plan_not_due = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "Not Due", $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_coll_plan_not_due->planned_coll_amt / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';

				$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;">' . money_format('%!i', $c_coll_rtn_wrtn_plan->rtn_wrtn_amt / $denomination) . '</td>';


				$c_actual_coll_plan = $this->base_model->getClusterActualCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, $region_id);

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_actual_coll_plan->adv / $denomination) . '</td>';

				$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $c_actual_coll_plan->col / $denomination) . '</td>';


				$c_od_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "OD", $region_id);

				if ($c_od_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_od_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$c_ftm_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "FTM", $region_id);


				if ($c_ftm_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_ftm_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$c_notdue_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $vertical_id, "Not Due", $region_id);


				if ($c_notdue_amt->actual_coll_amount != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $c_notdue_amt->actual_coll_amount / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$same1 = $c_actual_coll_plan->col - $c_od_amt->actual_coll_amount - $c_ftm_amt->actual_coll_amount - $c_notdue_amt->actual_coll_amount;

				if ($same1 != '') {
					$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $same1 / $denomination) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
				}


				$openModalFillData .= '<td style="text-align:right !important;border-right: solid 6px #fff;" >0.00</td>';


				//--------- Percentage Calculation ---------------

				$per_adv = $c_actual_coll_plan->adv * 100 / 0;

				if ($per_adv != 0 && !is_infinite($per_adv) && !is_nan($per_adv)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_adv, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_cols = $c_actual_coll_plan->col * 100 / ($c_coll_plan->col + $c_coll_rtn_wrtn_plan->rtn_wrtn_amt);

				if ($per_cols != 0 && !is_infinite($per_cols) && !is_nan($per_cols)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_cols, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_ods = (($c_od_amt->actual_coll_amount * 100) / $c_coll_plan_od->planned_coll_amt);

				if ($per_ods != 0 && !is_infinite($per_ods) && !is_nan($per_ods)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_ods, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_ftms = (($c_ftm_amt->actual_coll_amount * 100) / $c_coll_plan_ftm->planned_coll_amt);

				if ($per_ftms != 0 && !is_infinite($per_ftms) && !is_nan($per_ftms)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_ftms, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_not_due = $c_notdue_amt->actual_coll_amount * 100 / $c_coll_plan_not_due->planned_coll_amt;

				if ($per_not_due != 0 && !is_infinite($per_not_due) && !is_nan($per_not_due)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_not_due, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$per_same11 = $same1 * 100 / $c_coll_plan->sam;

				if ($per_same11 != 0 && !is_infinite($per_same11) && !is_nan($per_same11)) {
					$openModalFillData .= '<td style="text-align:right !important;">' . number_format($per_same11, 2) . '</td>';
				} else {
					$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
				}


				$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

				$openModalFillData .= ' </tr>';


				$vertical_list = $this->base_model->getVerticleMappingClusterNames($sbu_id, $clu->cluster_id, $vertical_id, $console_entity_id);


				if (!empty($vertical_list)) {
					foreach ($vertical_list as $ver) {

						$v_mon_AR = $this->base_model->getVerticalCollectionSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

						// $openModalFillData .= '<tr class="details' . $sbu_id . '" data-id="' . $ver->sbu_id . '' . $ver->vertical_id . '" style="background: #d4d5ff !important;">';

						$openModalFillData .= '<tr class="details_Project' . $sbu_id . ' details-chk' . $clu->cluster_id . '' . $clu->sbu_id . ' display-none" style="background: #f3f3f3 !important;">';

						$openModalFillData .= '<td></td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td>-</td>';

						$openModalFillData .= '<td style="border-right: solid 6px #fff;">' . get_vertical_name($ver->vertical_id) . '</td>';

						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->bal / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_bal / $denomination) . '</td>';
						}


						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->overdue / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_overdue / $denomination) . '</td>';
						}


						if ($fx_type_id == 0) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->ftm_due / $denomination) . '</td>';
						} elseif ($fx_type_id == 1) {

							$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_mon_AR->fx_ftm_due / $denomination) . '</td>';
						}

						if ($fx_type_id == 0) {

							$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->ftm_due;
						} elseif ($fx_type_id == 1) {

							$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->fx_ftm_due;
						}



						if ($notdue != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $notdue / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}

						$tot_ret = $v_mon_AR->ret + $v_mon_AR->wret;

						if ($tot_ret != '') {
							$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >' . money_format('%!i', $tot_ret / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';
						}


						
						$v_coll_plan = $this->base_model->getVerticalUserCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);
						
					 
						$v_coll_rtn_wrtn_plan = $this->base_model->getVerticalUserCollectionPlanSummaryrtnwrtn($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

						$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', ($v_coll_plan->col + $v_coll_rtn_wrtn_plan->rtn_wrtn_amt) / $denomination) . '</td>';
						
						$v_coll_plan_od = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "OD", $region_id);
					
						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan_od->planned_coll_amt / $denomination) . '</td>';
						
						$v_coll_plan_ftm = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM", $region_id);

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan_ftm->planned_coll_amt / $denomination) . '</td>';
						
						$v_coll_plan_not_due = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due", $region_id);

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_coll_plan_not_due->planned_coll_amt / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';

						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;">' . money_format('%!i', $v_coll_rtn_wrtn_plan->rtn_wrtn_amt / $denomination) . '</td>';


						$v_actual_coll_plan = $this->base_model->getVerticalActualCollectionPlanSummary($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

						$openModalFillData .= '<td style="text-align:right !important; ">' . money_format('%!i', $v_actual_coll_plan->adv / $denomination) . '</td>';

						$openModalFillData .= '<td style="text-align:right !important;">' . money_format('%!i', $v_actual_coll_plan->col / $denomination) . '</td>';


						$v_od_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "OD", $region_id);


						if ($v_od_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_od_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_ftm_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM", $region_id);


						if ($v_ftm_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_ftm_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_notdue_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due", $region_id);


						if ($v_notdue_amt->actual_coll_amount != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_notdue_amt->actual_coll_amount / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$v_same = $v_actual_coll_plan->col - $v_od_amt->actual_coll_amount - $v_ftm_amt->actual_coll_amount - $v_notdue_amt->actual_coll_amount;

						if ($v_same != '') {
							$openModalFillData .= '<td style="text-align:right !important;" >' . money_format('%!i', $v_same / $denomination) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;" >0.00</td>';
						}


						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

						//--------- Percentage Calculation ---------------

						$v_per_adv = $v_actual_coll_plan->adv * 100 / 0;

						if ($v_per_adv != 0 && !is_infinite($v_per_adv) && !is_nan($v_per_adv)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_adv, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_col = $v_actual_coll_plan->col * 100 / ($v_coll_plan->col + $v_coll_rtn_wrtn_plan->rtn_wrtn_amt);

						if ($v_per_col != 0 && !is_infinite($v_per_col) && !is_nan($v_per_col)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_col, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_od = $v_od_amt->actual_coll_amount * 100 / $v_coll_plan_od->planned_coll_amt;

						if ($v_per_od != 0 && !is_infinite($v_per_od) && !is_nan($v_per_od)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_od, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_ftm = $v_ftm_amt->actual_coll_amount * 100 / $v_coll_plan_ftm->planned_coll_amt;

						if ($v_per_ftm != 0 && !is_infinite($v_per_ftm) && !is_nan($v_per_ftm)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_ftm, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_not_due = $v_notdue_amt->actual_coll_amount * 100 / $v_coll_plan_not_due->planned_coll_amt;

						if ($v_per_not_due != 0 && !is_infinite($v_per_not_due) && !is_nan($v_per_not_due)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_not_due, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$v_per_same11 = $v_same * 100 / 0;

						if ($v_per_same11 != 0 && !is_infinite($v_per_same11) && !is_nan($v_per_same11)) {
							$openModalFillData .= '<td style="text-align:right !important;">' . number_format($v_per_same11, 2) . '</td>';
						} else {
							$openModalFillData .= '<td style="text-align:right !important;">0.00</td>';
						}


						$openModalFillData .= '<td style="text-align:right !important; border-right: solid 6px #fff;" >0.00</td>';

						$openModalFillData .= ' </tr>';
					}
				}
			}
		}

		$resultData['openModalFillData'] = $openModalFillData;
		echo json_encode($resultData['openModalFillData']);
	}
	
	
	//-------------- Collection Summary Report - User Plan -------------------//

	function collection_summary_report_user_plan_excel_report($param = '')
	{

		if (!$this->ion_auth->logged_in()) {
			redirect('auth/login', 'refresh');
		}


		if ($this->input->post("month_year") != '') {
			$month_year = $this->input->post("month_year");
		} else {
			$month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
		}

		$this->data['month_year'] = $month_year;

		if ($this->input->post("denomination") != '') {
			$denomination = $this->input->post("denomination");
		} else {
			$denomination = '1';
		}

		$this->data['denomination'] = $denomination;

		if ($this->input->post("fx_type_id") != '') {
			$fx_type_id = $this->input->post("fx_type_id");
		} else {
			$fx_type_id = '0';
		}

		$this->data['fx_type_id'] = $fx_type_id;



		if ($this->input->post("sbu_id") != '') {
			$sbu_id = explode(',', $this->input->post("sbu_id"));
			$this->data['sbu_id'] = implode(',', $this->input->post("sbu_id"));
		}

		if ($this->input->post("console_entity_id") != '') {
			$console_entity_id = explode(',', $this->input->post("console_entity_id"));
			$this->data['console_entity_id'] = implode(',', $this->input->post("console_entity_id"));
		}

		if ($this->input->post("cluster_id") != '') {
			$cluster_id = explode(',', $this->input->post("cluster_id"));
			$this->data['cluster_id'] = implode(',', $this->input->post("cluster_id"));
		}

		if ($this->input->post("vertical_id") != '') {
			$vertical_id = explode(',', $this->input->post("vertical_id"));
			$this->data['vertical_id'] = implode(',', $this->input->post("vertical_id"));
		}

		if ($this->input->post("region_id") != '') {
			$region_id = explode(',', $this->input->post("region_id"));
			$this->data['region_id'] = implode(',', $this->input->post("region_id"));
		}


		$sbu_list = $this->base_model->getVerticalSBUlist($console_entity_id, $sbu_id, $cluster_id, $vertical_id);




		//load PHPExcel library
		$this->load->library('Excel');
		ob_start();
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$styleArray = array(
			'font' => array(
				'size' => 13,
				'name' => 'Roboto'
			)
		);

		$fontArray = array(
			'font' => array(
				'bold' => true,
				'size' => 11,
				'name' => 'Roboto'
			)
		);
		$dateArray = array(
			'font' => array(
				'bold' => true,
			)
		);
		$bgcolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '00a65a'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$collectionpercolor = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f7ac4f'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$bgcolor_color = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'ffffff'),
				'bold'  => true,
			)
		);

		$bgcolorblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'e5e3e3'),
			),
			'font' => array(
				'bold' => true
			)
		);

		$bgblue = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'a80606'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);

		$bgbrr = array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '0878b0'),
				'bold'  => true,
			),
			'font' => array(
				'color' => array('rgb' => 'ffffff')
			)
		);




		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
			->setLastModifiedBy("Comprehensive School Management")
			->setTitle("Office  XLSX Test Document")
			->setSubject("Office XLSX Test Document")
			->setDescription("Test document for Office XLSX, generated by PHP classes.")
			->setKeywords("office openxml php")
			->setCategory("Excel Sheet");

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . '1', ' - Collection Summary Report - Generated On ' . date('F d, Y'));

		$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(1);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(15);

		$objPHPExcel->getActiveSheet(0)->getStyle('B:AF')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

		$objPHPExcel->getActiveSheet(0)->getStyle('A4:AF4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


		// Add some data


		$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('J5:P5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('R5:X5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('Z5:AF5')->applyFromArray($bgcolorblue);
		$objPHPExcel->getActiveSheet()->getStyle('B4:H4')->applyFromArray($bgblue);
		$objPHPExcel->getActiveSheet()->getStyle('J4:P4')->applyFromArray($bgbrr);
		$objPHPExcel->getActiveSheet()->getStyle('R4:X4')->applyFromArray($bgcolor);
		$objPHPExcel->getActiveSheet()->getStyle('Z4:AF4')->applyFromArray($collectionpercolor);

		// $objPHPExcel->getActiveSheet()->getStyle('D4:X4')->applyFromArray($bgcolor_color);

		$objPHPExcel->setActiveSheetIndex()->mergeCells('D4:H4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('J4:P4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('R4:X4');
		$objPHPExcel->setActiveSheetIndex()->mergeCells('Z4:AF4');

		$objPHPExcel->setActiveSheetIndex()->mergeCells('A4:C4');

		if ($denomination == 1) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'INR');
		} elseif ($denomination == 1000) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Thousands');
		} elseif ($denomination == 1000000) {
			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'MN');
		}

		$objPHPExcel->getActiveSheet()->setCellValue('D4', 'AR');
		$objPHPExcel->getActiveSheet()->setCellValue('J4', 'USER COLLECTION PLAN');
		$objPHPExcel->getActiveSheet()->setCellValue('R4', 'ACTUAL COLLECTION');
		$objPHPExcel->getActiveSheet()->setCellValue('Z4', 'COLLECTION (IN %)');

		$objPHPExcel->getActiveSheet()->setCellValue('A5', 'SBU');
		$objPHPExcel->getActiveSheet()->setCellValue('B5', 'Cluster');
		$objPHPExcel->getActiveSheet()->setCellValue('C5', 'Vertical');
		$objPHPExcel->getActiveSheet()->setCellValue('D5', 'Total');
		$objPHPExcel->getActiveSheet()->setCellValue('E5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('F5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('G5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('H5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('I5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('J5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('K5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('L5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('M5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('N5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('O5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('P5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('Q5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('R5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('S5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('T5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('U5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('V5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('W5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('X5', 'RTN/W-RTN');
		$objPHPExcel->getActiveSheet()->setCellValue('Y5', '');
		$objPHPExcel->getActiveSheet()->setCellValue('Z5', 'ADV');
		$objPHPExcel->getActiveSheet()->setCellValue('AA5', 'COLL');
		$objPHPExcel->getActiveSheet()->setCellValue('AB5', 'OD');
		$objPHPExcel->getActiveSheet()->setCellValue('AC5', 'FTM');
		$objPHPExcel->getActiveSheet()->setCellValue('AD5', 'Not Due');
		$objPHPExcel->getActiveSheet()->setCellValue('AE5', 'SAME MTH');
		$objPHPExcel->getActiveSheet()->setCellValue('AF5', 'RTN/W-RTN');


		$c = '6';
		foreach ($sbu_list as $s) {

			$li = $this->base_model->getSBUCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id);

			if (!empty($s->sbu_id)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, get_sbu_name($s->sbu_id));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "-");

			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, money_format('%!n', $li->bal / $denomination));
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, money_format('%!n', $li->fx_bal / $denomination));
			}

			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $li->overdue / $denomination));
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, money_format('%!n', $li->fx_overdue / $denomination));
			}

			if ($fx_type_id == 0) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $li->ftm_due / $denomination));
			} elseif ($fx_type_id == 1) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, money_format('%!n', $li->fx_ftm_due / $denomination));
			}

			
			
			if ($fx_type_id == 0) {

								$notdue = $li->within_due - $li->ret - $li->wret - $li->ftm_due;
										
								} elseif ($fx_type_id == 1) {

								$notdue = $li->within_due - $li->ret - $li->wret - $li->fx_ftm_due;
								}

			if ($notdue != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, money_format('%!n', $notdue / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "-");
			}

			$tot_ret = $li->ret + $li->wret;

			if ($tot_ret != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, money_format('%!n', $tot_ret / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "-");
			}

			
			$planned_coll_plan = $this->base_model->getSBUUserCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id);
					 
			$planned_rtn_wrtn_coll_plan = $this->base_model->getSBUUserCollectionPlanSummaryrtnwrtn($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id); 


			$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, "");

			$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, "0.00");
			
			$s_coll_plan = $planned_coll_plan->col + $planned_rtn_wrtn_coll_plan->rtn_wrtn_amt ;

			if ($s_coll_plan != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, money_format('%!n', $s_coll_plan / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
			}
			
			$s_od_amt_1 = $this->base_model->getSBUUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "OD", $region_id); 
			
			if ($s_od_amt_1->planned_coll_amt != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, money_format('%!n', $s_od_amt_1->planned_coll_amt / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
			}
			
			$s_ftm_amt_1 = $this->base_model->getSBUUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "FTM", $region_id); 
			
			if ($s_ftm_amt_1->planned_coll_amt != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!n', $s_ftm_amt_1->planned_coll_amt / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, "-");
			}
			
			$s_notdue_amt_1 = $this->base_model->getSBUUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "Not Due", $region_id); 
			
			if ($s_notdue_amt_1->planned_coll_amt != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!n', $s_notdue_amt_1->planned_coll_amt / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, "-");
			}
			
			$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "0.00");
			

			if ($planned_rtn_wrtn_coll_plan->rtn_wrtn_amt != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, money_format('%!n', $planned_rtn_wrtn_coll_plan->rtn_wrtn_amt / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "-");
			}


			$actual_coll_plan = $this->base_model->getSBUActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, $region_id);

			$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "");


			if ($actual_coll_plan->adv != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!n', $actual_coll_plan->adv / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "-");
			}


			if ($actual_coll_plan->col != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, money_format('%!n', $actual_coll_plan->col / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "-");
			}


			$od_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "OD", $region_id);


			if ($od_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!n', $od_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "-");
			}

			$ftm_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "FTM", $region_id);

			if ($ftm_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!n', $ftm_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "-");
			}

			$notdue_amt = $this->base_model->getSBUCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $cluster_id, $vertical_id, "Not Due", $region_id);

			if ($notdue_amt->actual_coll_amount != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!n', $notdue_amt->actual_coll_amount / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "-");
			}

			$same = $actual_coll_plan->col - $od_amt->actual_coll_amount - $ftm_amt->actual_coll_amount - $notdue_amt->actual_coll_amount;

			if ($same != '') {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, money_format('%!n', $same / $denomination));
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "-");

			$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "");


			$per_adv = number_format($actual_coll_plan->adv * 100 / 0, 2);

			if ($per_adv != 0 && !is_infinite($per_adv) && !is_nan($per_adv)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, number_format($per_adv, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "-");
			}

			$per_col = number_format($actual_coll_plan->col * 100 / ($planned_coll_plan->col + $planned_rtn_wrtn_coll_plan->rtn_wrtn_amt), 2);

			if ($per_col != 0 && !is_infinite($per_col) && !is_nan($per_col)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, number_format($per_col, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "-");
			}

			$per_od = number_format($od_amt->actual_coll_amount * 100 / $s_od_amt_1->planned_coll_amt, 2);

			if ($per_od != 0 && !is_infinite($per_od) && !is_nan($per_od)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, number_format($per_od, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "-");
			}

			$per_ftm = number_format($ftm_amt->actual_coll_amount * 100 / $s_od_amt_1->planned_coll_amt, 2);

			if ($per_ftm != 0 && !is_infinite($per_ftm) && !is_nan($per_ftm)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, number_format($per_ftm, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "-");
			}

			$per_not_due = number_format($notdue_amt->actual_coll_amount * 100 / $s_od_amt_1->planned_coll_amt, 2);

			if ($per_not_due != 0 && !is_infinite($per_not_due) && !is_nan($per_not_due)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, number_format($per_not_due, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "-");
			}

			$per_same = number_format($same * 100 / 0, 2);

			if ($per_same != 0 && !is_infinite($per_same) && !is_nan($per_same)) {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, number_format($per_same, 2) . "");
			} else {
				$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "-");
			}

			$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "0.00");


			if ($c != '0') {
				$D = $c + 1;
			} else {
				$D = '0';
			}


			$cluster_list = $this->base_model->getClusterMappingNames($s->sbu_id, $cluster_id, $vertical_id, $console_entity_id);


			if (!empty($cluster_list)) {
				foreach ($cluster_list as $clu) {

					$c_mon_AR = $this->base_model->getClusterwiseCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $D, get_cluster_name($clu->cluster_id));

					$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $D, "-");

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, money_format('%!n', $c_mon_AR->bal / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $D, money_format('%!n', $c_mon_AR->fx_bal / $denomination));
					}

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $c_mon_AR->overdue / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $D, money_format('%!n', $c_mon_AR->fx_overdue / $denomination));
					}

					if ($fx_type_id == 0) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $c_mon_AR->ftm_due / $denomination));
					} elseif ($fx_type_id == 1) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $D, money_format('%!n', $c_mon_AR->fx_ftm_due / $denomination));
					}

					if ($fx_type_id == 0) {

						$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->ftm_due;
					} elseif ($fx_type_id == 1) {

						$notdue = $c_mon_AR->within_due - $c_mon_AR->ret - $c_mon_AR->wret - $c_mon_AR->fx_ftm_due;
					}

					if ($notdue != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, money_format('%!n', $notdue / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $D, "-");
					}

					$tot_ret = $c_mon_AR->ret + $c_mon_AR->wret;

					if ($tot_ret != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, money_format('%!n', $tot_ret / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $D, "");
					
					
					$c_coll_plan = $this->base_model->getClusterUserCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);
					 
					$c_coll_rtn_wrtn_plan = $this->base_model->getClusterUserCollectionPlanSummaryrtnwrtn($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $D, "0.00");
					
					$c_coll_plan_1 = $c_coll_plan->col + $c_coll_rtn_wrtn_plan->rtn_wrtn_amt;

					if ($c_coll_plan_1 != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, money_format('%!n', $c_coll_plan_1 / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $D, "-");
					}
					
					$c_coll_plan_od = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "OD", $region_id);
					
					if ($c_coll_plan_od->planned_coll_amt != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, money_format('%!n', $c_coll_plan_od->planned_coll_amt / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $D, "-");
					}
					
					$c_coll_plan_ftm = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "FTM", $region_id);
					
					if ($c_coll_plan_ftm->planned_coll_amt != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, money_format('%!n', $c_coll_plan_ftm->planned_coll_amt / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $D, "-");
					}
					
					$c_coll_plan_not_due = $this->base_model->getClusterUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "Not Due", $region_id);
					
					if ($c_coll_plan_not_due->planned_coll_amt != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, money_format('%!n', $c_coll_plan_not_due->planned_coll_amt / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $D, "0.00");

					if ($c_coll_rtn_wrtn_plan->rtn_wrtn_amt != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, money_format('%!n', $c_coll_rtn_wrtn_plan->rtn_wrtn_amt / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $D, "-");
					}

					$c_actual_coll_plan = $this->base_model->getClusterActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, $region_id);

					$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $D, "");

					if ($c_actual_coll_plan->adv != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, money_format('%!n', $c_actual_coll_plan->adv / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $D, "-");
					}

					if ($c_actual_coll_plan->col != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, money_format('%!n', $c_actual_coll_plan->col / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $D, "-");
					}


					$c_od_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "OD");

					if ($c_od_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, money_format('%!n', $c_od_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $D, "-");
					}

					$c_ftm_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "FTM");

					if ($c_ftm_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, money_format('%!n', $c_ftm_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $D, "-");
					}


					$c_notdue_amt = $this->base_model->getClusterCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $vertical_id, "Not Due");

					if ($c_notdue_amt->actual_coll_amount != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, money_format('%!n', $c_notdue_amt->actual_coll_amount / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $D, "-");
					}

					$same1 = $c_actual_coll_plan->col - $c_od_amt->actual_coll_amount - $c_ftm_amt->actual_coll_amount - $c_notdue_amt->actual_coll_amount;


					if ($same1 != '') {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, money_format('%!n', $same1 / $denomination));
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $D, "-");

					$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $D, "");

					$per_adv_ver = $c_actual_coll_plan->adv * 100 / 0;

					if ($per_adv_ver != 0 && !is_infinite($per_adv_ver) && !is_nan($per_adv_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $D, number_format($per_adv_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $D, "-");
					}

					$per_cols_ver = $c_actual_coll_plan->col * 100 / $c_coll_plan_1;

					if ($per_cols_ver != 0 && !is_infinite($per_cols_ver) && !is_nan($per_cols_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $D, number_format($per_cols_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $D, "-");
					}

					$per_ods_ver = (($c_od_amt->actual_coll_amount * 100) / $c_coll_plan_od->planned_coll_amt);

					if ($per_ods_ver != 0 && !is_infinite($per_ods_ver) && !is_nan($per_ods_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $D, number_format($per_ods_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $D, "-");
					}

					$per_ftms_ver = (($c_ftm_amt->actual_coll_amount * 100) / $c_coll_plan_ftm->planned_coll_amt);

					if ($per_ftms_ver != 0 && !is_infinite($per_ftms_ver) && !is_nan($per_ftms_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $D, number_format($per_ftms_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $D, "-");
					}

					$per_not_due_ver = $c_notdue_amt->actual_coll_amount * 100 / $c_coll_plan_not_due->planned_coll_amt;

					if ($per_not_due_ver != 0 && !is_infinite($per_not_due_ver) && !is_nan($per_not_due_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $D, number_format($per_not_due_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $D, "-");
					}

					$per_same11_ver = $same1 * 100 / 0;

					if ($per_same11_ver != 0 && !is_infinite($per_same11_ver) && !is_nan($per_same11_ver)) {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $D, number_format($per_same11_ver, 2) . "");
					} else {
						$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $D, "-");
					}

					$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $D, "0.00");


					$vertical_list = $this->base_model->getVerticleMappingClusterNames($s->sbu_id, $clu->cluster_id, $vertical_id, $console_entity_id);

					if ($D != '0') {
						$E = $D + 1;
					} else {
						$E = '0';
					}

					if (!empty($vertical_list)) {
						foreach ($vertical_list as $ver) {

							$v_mon_AR = $this->base_model->getVerticalCollectionSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);

							$objPHPExcel->getActiveSheet(0)->setCellValue('A' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('B' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('C' . $E, get_vertical_name($ver->vertical_id));

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $E, money_format('%!n', $v_mon_AR->bal / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('D' . $E, money_format('%!n', $v_mon_AR->fx_bal / $denomination));
							}

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $E, money_format('%!n', $v_mon_AR->overdue / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('E' . $E, money_format('%!n', $v_mon_AR->fx_overdue / $denomination));
							}

							if ($fx_type_id == 0) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $E, money_format('%!n', $v_mon_AR->ftm_due / $denomination));
							} elseif ($fx_type_id == 1) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('F' . $E, money_format('%!n', $v_mon_AR->fx_ftm_due / $denomination));
							}


							
							
								if ($fx_type_id == 0) {

								$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->ftm_due;
										
								} elseif ($fx_type_id == 1) {

								$notdue = $v_mon_AR->within_due - $v_mon_AR->ret - $v_mon_AR->wret - $v_mon_AR->fx_ftm_due;
								}

							if ($notdue != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $E,  money_format('%!i', $notdue / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('G' . $E, "-");
							}


							$tot_ret = $v_mon_AR->ret + $v_mon_AR->wret;

							if ($tot_ret != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $E,  money_format('%!i', $tot_ret / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('H' . $E, "-");
							}

							
							$objPHPExcel->getActiveSheet(0)->setCellValue('I' . $E, "");
							
							

							$objPHPExcel->getActiveSheet(0)->setCellValue('J' . $E, "0.00");
							
							$v_coll_plan = $this->base_model->getVerticalUserCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);
						
							$v_coll_rtn_wrtn_plan = $this->base_model->getVerticalUserCollectionPlanSummaryrtnwrtn($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, $region_id);
							
							$v_coll_plan_1 = $v_coll_plan->col + $v_coll_rtn_wrtn_plan->rtn_wrtn_amt;
							
							if ($v_coll_plan_1 != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $E,  money_format('%!i', $v_coll_plan_1 / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('K' . $E, "-");
							}
							
							$v_coll_plan_od = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "OD", $region_id);

							if ($v_coll_plan_od->planned_coll_amt != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $E,  money_format('%!i', $v_coll_plan_od->planned_coll_amt / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('L' . $E, "-");
							}

							$v_coll_plan_ftm = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM", $region_id);
							
							if ($v_coll_plan_ftm->planned_coll_amt != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $E,  money_format('%!i', $v_coll_plan_ftm->planned_coll_amt / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('M' . $E, "-");
							}
							
							$v_coll_plan_not_due = $this->base_model->getVerticalUserCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due", $region_id);
							
							if ($v_coll_plan_not_due->planned_coll_amt != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $E,  money_format('%!i', $v_coll_plan_not_due->planned_coll_amt / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('N' . $E, "-");
							}

							$objPHPExcel->getActiveSheet(0)->setCellValue('O' . $E, "0.00");

							if ($v_coll_rtn_wrtn_plan->rtn_wrtn_amt != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $E,  money_format('%!i', $v_coll_rtn_wrtn_plan->rtn_wrtn_amt / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('P' . $E, "-");
							}

							$v_actual_coll_plan = $this->base_model->getVerticalActualCollectionPlanSummary($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id);

							// print_r($this->db->last_query());die;

							$objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $E, "");

							if ($v_actual_coll_plan->adv != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $E,  money_format('%!i', $v_actual_coll_plan->adv / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('R' . $E, "-");
							}


							if ($v_actual_coll_plan->col != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $E,  money_format('%!i', $v_actual_coll_plan->col / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('S' . $E, "-");
							}


							$v_od_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "OD");

							if ($v_od_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $E,  money_format('%!i', $v_od_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('T' . $E, "-");
							}

							$v_ftm_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "FTM");

							if ($v_ftm_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $E,  money_format('%!i', $v_ftm_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('U' . $E, "-");
							}

							$v_notdue_amt = $this->base_model->getVerticalCollectionSummaryMonthEndAR($month_year, $console_entity_id, $s->sbu_id, $clu->cluster_id, $ver->vertical_id, "Not Due");

							if ($v_notdue_amt->actual_coll_amount != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $E,  money_format('%!i', $v_notdue_amt->actual_coll_amount / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('V' . $E, "-");
							}

							$v_same = $v_actual_coll_plan->col - $v_od_amt->actual_coll_amount - $v_ftm_amt->actual_coll_amount - $v_notdue_amt->actual_coll_amount;

							if ($v_same != '') {
								$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $E, money_format('%!i', $v_same / $denomination));
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('W' . $E, "-");
							}

							$objPHPExcel->getActiveSheet(0)->setCellValue('X' . $E, "-");

							$objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $E, "");


							$v_per_adv = $v_actual_coll_plan->adv * 100 / 0;

							if ($v_per_adv != 0 && !is_infinite($v_per_adv) && !is_nan($v_per_adv)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $E, number_format($v_per_adv, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $E, "-");
							}


							$v_per_col = $v_actual_coll_plan->col * 100 / $v_coll_plan_1;

							if ($v_per_col != 0 && !is_infinite($v_per_col) && !is_nan($v_per_col)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $E, number_format($v_per_col, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $E, "-");
							}

							$v_per_od = $v_od_amt->actual_coll_amount * 100 / $v_coll_plan_od->planned_coll_amt;

							if ($v_per_od != 0 && !is_infinite($v_per_od) && !is_nan($v_per_od)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $E, number_format($v_per_od, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $E, "-");
							}

							$v_per_ftm = $v_ftm_amt->actual_coll_amount * 100 / $v_coll_plan_ftm->planned_coll_amt;

							if ($v_per_ftm != 0 && !is_infinite($v_per_ftm) && !is_nan($v_per_ftm)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $E, number_format($v_per_ftm, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $E, "-");
							}

							$v_per_not_due = $v_notdue_amt->actual_coll_amount * 100 / $v_coll_plan_not_due->planned_coll_amt;

							if ($v_per_not_due != 0 && !is_infinite($v_per_not_due) && !is_nan($v_per_not_due)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $E, number_format($v_per_not_due, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $E, "-");
							}

							$v_per_same11 = $v_same * 100 / 0;

							if ($v_per_same11 != 0 && !is_infinite($v_per_same11) && !is_nan($v_per_same11)) {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $E, number_format($v_per_same11, 2) . "");
							} else {
								$objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $E, "-");
							}

							$objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $E, "0.00");


							$E++;
						}
					}

					$D = $E;

					$D++;
				}
			}

			$c = $D;

			$c++;
		}

		ob_end_clean();

		$today = date('m-Y');

		// Rename worksheet (worksheet, not filename)
		$objPHPExcel->getActiveSheet()->setTitle('Collection Summary Report');

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client’s web browser (Excel2007)

		$filename = 'Collection Summary Report - User Plan -' . $month_year . '.xlsx'; //save our workbook as this file name

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();

		$objWriter->save('php://output');
	}
	
	
	
}
