<?php defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . '/third_party/spout/src/Spout/Autoloader/autoload.php';

//lets Use the Spout Namespaces
use Box\Spout\Reader\Common\Creator\ReaderEntityFactory;
use Box\Spout\Common\Type;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
use Box\Spout\Common\Entity\Style\CellAlignment;
use Box\Spout\Common\Entity\Style\Color;


class Resources extends Admin_Controller
{

    public function __construct()
    {

        parent::__construct();

        /* Title Page :: Common */
        $this->page_title->push(lang('menu_resources'));
        $this->data['pagetitle'] = $this->page_title->show();



        $this->load->library('excel');
        $this->load->model('Ajax_model');
        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_resources'), 'admin/resources');
    }


    public function index()
    {
        if (!$this->ion_auth->logged_in() or !$this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        } else {
            /* Breadcrumbs */
            require_once APPPATH . "/third_party/spout/src/Spout/Autoloader/autoload.php";
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Load Template */
            $this->template->admin_render('admin/resources/index', $this->data);
        }
    }

    /* DPST-Vertical Mapping */
    /* Kiran */
    public function dpst_vertical_mapping($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('dpst_id', 'DPST Name', 'xss_clean|required');
            $this->form_validation->set_rules('ar_type_id', 'AR Type Name', 'xss_clean|required');
            $this->form_validation->set_rules('vertical_id', 'Vertical Name', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "dpst_vertical_mapping";
                $inputdata['dpst_id']                        = $this->input->post('dpst_id');
                $inputdata['ar_type_id']                        = $this->input->post('ar_type_id');
                $inputdata['vertical_id']                        = $this->input->post('vertical_id');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', 'DPST Updated Succesfully');
                        redirect('admin/resources/dpst_vertical_mapping', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/resources/dpst_vertical_mapping');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', 'DPST Added Succesfully');
                    redirect('admin/resources/dpst_vertical_mapping', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/resources/dpst_vertical_mapping');
                }
            }
        }

        if ($param1 == "edit") {
            $dpst_vertical_mapping_details = $this->db->get_where('dpst_vertical_mapping', array('id' => $param2))->result();
            $this->data['dpst_vertical_mapping_details'] =  $dpst_vertical_mapping_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('dpst_vertical_mapping', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'DPST Deleted Succesfully');
                redirect('admin/resources/dpst_vertical_mapping');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/resources/dpst_vertical_mapping');
            }
        }
        $this->data['dpst_master'] = $this->db->query("select * from dpst_master")->result();
        $this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
        $this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
        $this->data['dpst_vertical_mapping'] = $this->db->query("select * from dpst_vertical_mapping")->result();

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/dpst_vertical_mapping');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/dpst_vertical_mapping', $this->data);
    }


    public function dpst_vertical_mapping_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        // POST data
        $postData = $this->input->post();
        // Get data
        $data = $this->Ajax_model->dpst_vertical_mapping_ajaxdata($postData);
        echo json_encode($data);
    }

    /* DPST-Vertical Validation */
    /*Kiran */
    public function dpst_manual_vertical_validation()
    {
        $dpst_name = trim($this->input->post('dpst_name'));
        $ar_type_name = trim($this->input->post('ar_type_name'));
        $vertical_name = trim($this->input->post('vertical_name'));
        $dpst_vertical = $this->db->query("select * from dpst_vertical_mapping where dpst_id='" . $dpst_name . "' and ar_type_id='" . $ar_type_name . "' and vertical_id='" . $vertical_name . "' ")->row();

        if (count($dpst_vertical) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }


    /* Transaction-Type Mapping */
    /* Kiran */
    public function transaction_type_mapping($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('transaction_type_id', 'Transaction Type', 'xss_clean|required');
            $this->form_validation->set_rules('vertical_id', 'Vertical Name', 'xss_clean|required');
            $this->form_validation->set_rules('ar_type_id', 'AR Type Name', 'xss_clean|required');
            $this->form_validation->set_rules('priority', 'Priority', 'xss_clean|required');
            $this->form_validation->set_rules('sequence_id', 'Sequence', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');


            if ($this->form_validation->run() == TRUE) {
                $table = "transaction_type_mapping";
                $inputdata['transaction_type_id']        = $this->input->post('transaction_type_id');
                $inputdata['vertical_id']                 = $this->input->post('vertical_id');
                $inputdata['ar_type_id']                 = $this->input->post('ar_type_id');
                $inputdata['priority']                 = $this->input->post('priority');
                $inputdata['sequence_id']                 = $this->input->post('sequence_id');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', ' Updated Succesfully');
                        redirect('admin/resources/transaction_type_mapping', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/resources/transaction_type_mapping');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', ' Added Succesfully');
                    redirect('admin/resources/transaction_type_mapping', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/resources/transaction_type_mapping');
                }
            }
        }

        if ($param1 == "edit") {
            $transaction_type_mapping_details = $this->db->get_where('transaction_type_mapping', array('id' => $param2))->result();
            $this->data['transaction_type_mapping_details'] =  $transaction_type_mapping_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('transaction_type_mapping', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'DPST Deleted Succesfully');
                redirect('admin/resources/transaction_type_mapping');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/resources/transaction_type_mapping');
            }
        }
        $this->data['transaction_type_master'] = $this->db->query("select * from transaction_type_master")->result();
        $this->data['ar_type_master'] = $this->db->query("select * from ar_type_master")->result();
        $this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
        $this->data['transaction_type_mapping'] = $this->db->query("select * from transaction_type_mapping")->result();

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/transaction_type_mapping');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/transaction_type_mapping', $this->data);
    }

    /* Transaction-Type Mapping validation */
    /* Kiran */
    public function transaction_type_manual_validation()
    {
        $transaction_type = trim($this->input->post('transaction_type'));
        $vertical_type = trim($this->input->post('vertical_type'));
        $transaction_type_manual = $this->db->query("select * from transaction_type_mapping where transaction_type_id='" . $transaction_type . "' and vertical_id='" . $vertical_type . "'")->row();

        if (count($transaction_type_manual) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    /*Country Mapping*/
    /* Kiran */
    public function area_country_mapping($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('area_name_id', 'Area Name', 'xss_clean|required');
            $this->form_validation->set_rules('country_id', 'Country Name', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "area_country_mapping";

                $inputdata['area_name_id']        = $this->input->post('area_name_id');
                $inputdata['country_id']                 = $this->input->post('country_id');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', ' Updated Succesfully');
                        redirect('admin/resources/area_country_mapping', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/resources/area_country_mapping');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', ' Added Succesfully');
                    redirect('admin/resources/area_country_mapping', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/resources/area_country_mapping');
                }
            }
        }

        if ($param1 == "edit") {
            $area_country_mapping_details = $this->db->get_where('area_country_mapping', array('id' => $param2))->result();
            $this->data['area_country_mapping_details'] =  $area_country_mapping_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('area_country_mapping', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'DPST Deleted Succesfully');
                redirect('admin/resources/area_country_mapping');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/resources/area_country_mapping');
            }
        }
        $this->data['area_master'] = $this->db->query("select * from area_master")->result();
        $this->data['country_master'] = $this->db->query("select * from country_master")->result();
        $this->data['area_country_mapping'] = $this->db->query("select * from area_country_mapping")->result();

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/area_country_mapping');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/area_country_mapping', $this->data);
    }
    /* Area Country Manual Validation */
    /*Kiran */
    public function area_country_manual_validation()
    {
        $area_name_id = trim($this->input->post('area_name_id'));
        $country_id = trim($this->input->post('country_id'));
        $area_country_manual = $this->db->query("select * from area_country_mapping where area_name_id='" . $area_name_id . "' and country_id='" . $country_id . "'")->row();
        if (count($area_country_manual) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }
    /*VERTICAL ENTITY CURRENCY*/
    /*Kiran */
    public function vertical_entity_mapping($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('vertical_id', 'Vertical Name', 'xss_clean|required');
            $this->form_validation->set_rules('cluster_id', 'Cluster Name', 'xss_clean|required');
            $this->form_validation->set_rules('sbu_id', 'SBU Name', 'xss_clean|required');
            $this->form_validation->set_rules('console_id', 'Console Name', 'xss_clean|required');
            $this->form_validation->set_rules('reporting_fx_id', 'Reporting FX Name', 'xss_clean|required');
            $this->form_validation->set_rules('local_fx_id', 'Local FX Name', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');


            if ($this->form_validation->run() == TRUE) {
                $table = "vertical_entity_mapping";
                $inputdata['vertical_id']        = $this->input->post('vertical_id');
                $inputdata['cluster_id']        = $this->input->post('cluster_id');
                $inputdata['sbu_id']        = $this->input->post('sbu_id');
                $inputdata['console_id']        = $this->input->post('console_id');
                $inputdata['reporting_fx_id']                 = $this->input->post('reporting_fx_id');
                $inputdata['local_fx_id']                 = $this->input->post('local_fx_id');
                $inputdata['user_id']                        = $this->ion_auth->get_user_id();
                $inputdata['sys_created_on']                        = date("Y-m-d h:i:s");

                if ($this->input->post('id')) {
                    $this->db->where('id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', ' Updated Succesfully');
                        redirect('admin/resources/vertical_entity_mapping', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/resources/vertical_entity_mapping');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', ' Added Succesfully');
                    redirect('admin/resources/vertical_entity_mapping', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/resources/vertical_entity_mapping');
                }
            }
        }

        if ($param1 == "edit") {
            $vertical_entity_mapping_details = $this->db->get_where('vertical_entity_mapping', array('id' => $param2))->result();
            $this->data['vertical_entity_mapping_details'] =  $vertical_entity_mapping_details[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('vertical_entity_mapping', array('id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'DPST Deleted Succesfully');
                redirect('admin/resources/vertical_entity_mapping');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/resources/vertical_entity_mapping');
            }
        }
        $this->data['vertical_master'] = $this->db->query("select * from vertical_master order by position")->result();
        $this->data['cluster_master'] = $this->db->query("select * from cluster_master order by position")->result();
        $this->data['sbu_master'] = $this->db->query("select * from sbu_master")->result();
        $this->data['console_master'] = $this->db->query("select * from console_master")->result();
        $this->data['local_fx_master'] = $this->db->query("select * from local_fx_master")->result();
        $this->data['vertical_entity_mapping'] = $this->db->query("select * from vertical_entity_mapping")->result();

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/vertical_entity_mapping');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/vertical_entity_mapping', $this->data);
    }
    /*VERTICAL ENTITY CURRENCY Validation*/
    /*Kiran */
    public function vertical_entity_manual_validation()
    {
        $vertical_id = trim($this->input->post('vertical_id'));
        $cluster_id = trim($this->input->post('cluster_id'));
        $sbu_id = trim($this->input->post('sbu_id'));
        $console_id = trim($this->input->post('console_id'));
        $local_fx_id = trim($this->input->post('local_fx_id'));
        $vertical_entity_manual = $this->db->query("select * from vertical_entity_mapping where vertical_id='" . $vertical_id . "' and cluster_id='" . $cluster_id . "' and sbu_id='" . $sbu_id . "' and console_id='" . $console_id . "' and local_fx_id='" . $local_fx_id . "'")->row();

        if (count($vertical_entity_manual) > 0) {
            echo "1";
        } else {
            echo "0";
        }
    }

    public function dpst_vertical_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/dpst_vertical_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/dpst_vertical_upload', $this->data);
    }

    public function dpst_vertical_map_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['dpst_vertical_upload_file']['name'] != '') {
            if ($_FILES['dpst_vertical_upload_file']['name']) {
                $f_type                             = explode(".", $_FILES['dpst_vertical_upload_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['dpst_vertical_upload_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('DPST_Code', 'ARType_Code', 'Vertical_Code');
                    $makeArray = array('DPST_Code' => 'DPST_Code', 'ARType_Code' => 'ARType_Code', 'Vertical_Code' => 'Vertical_Code');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->dpst_vertical_validation($dataInSheet);
                            if ($dataInSheet['G'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $DPST_Code = $SheetDataKey['DPST_Code'];
                                $ARType_Code = $SheetDataKey['ARType_Code'];
                                $Vertical_Code = $SheetDataKey['Vertical_Code'];

                                $DPST_Code = filter_var(trim($allDataInSheet[$i][$DPST_Code]), FILTER_SANITIZE_STRING);
                                $ARType_Code = filter_var(trim($allDataInSheet[$i][$ARType_Code]), FILTER_SANITIZE_STRING);
                                $Vertical_Code = filter_var(trim($allDataInSheet[$i][$Vertical_Code]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $dpst_id = $this->db->query("select id from dpst_master where dpst_code='" . $DPST_Code . "'")->row();
                                $ar_type_id = $this->db->query("select id from ar_type_master where ar_type_code='" .  $ARType_Code . "'")->row();
                                $vertical_id = $this->db->query("select id from vertical_master where vertical_code='" .  $Vertical_Code . "'")->row();

                                $fetchData[] = array(
                                    'dpst_id' =>  $dpst_id->id,
                                    'ar_type_id' => $ar_type_id->id,
                                    'vertical_id' => $vertical_id->id,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->base_model->setBatchImportDPSTVertical($fetchData);
                            if ($this->base_model->importDataDPSTVertical() == 1) {
                                $msg_success = count($fetchData) . "  rows of DPST Vertical Mapping info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo 'no';
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('G2:G' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('G2:G' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('G1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }

    /*DPST Vertical Upload Validation*/
    /* Kiran */
    function dpst_vertical_validation($dataInSheet)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";
        $record_status['error_msg2'] = "";
        $record_status['error_msg3'] = "";

        if ($dataInSheet['A'] != "DPST_Code" || $dataInSheet['C'] != "ARType_Code" || $dataInSheet['E'] != "Vertical_Code") {

            if ($dataInSheet['A'] == NULL || $dataInSheet['C'] == NULL || $dataInSheet['E'] == NULL) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['A']) {
                $dpst_code = $this->db->query("select id from dpst_master where dpst_code='" . $dataInSheet['A'] . "'")->row();
                if (count($dpst_code) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg1'] = "DPST_Code does not exits";
                    if ($record_status['error_msg1'] != '') {
                        $A = '|';
                    }
                }
            }

            if ($dataInSheet['C']) {
                $ar_type_code = $this->db->query("select id from ar_type_master where ar_type_code='" . $dataInSheet['C'] . "'")->row();
                if (count($ar_type_code) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg2'] = "ARType_Code does not exits";
                    if ($record_status['error_msg2'] != '') {
                        $C = '|';
                    }
                }
            }

            if ($dataInSheet['E']) {
                $vertical_code = $this->db->query("select id from vertical_master where vertical_code='" .  $dataInSheet['E'] . "'")->row();
                if (count($vertical_code) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg3'] = "Vertical_Code does not exits";
                    if ($record_status['error_msg3'] != '') {
                        $T = '|';
                    }
                }
            }

            $dpst_code = $this->db->query("select id from dpst_master where dpst_code='" . $dataInSheet['A'] . "'")->row();
            $ar_type_code = $this->db->query("select id from ar_type_master where ar_type_code='" . $dataInSheet['C'] . "'")->row();
            $vertical_code = $this->db->query("select id from vertical_master where vertical_code='" .  $dataInSheet['E'] . "'")->row();

            $dpst_vertical_exists__or_not = $this->db->query("select u.*from dpst_vertical_mapping as u where u.dpst_id='" . $dpst_code->id . "' and u.ar_type_id='" . $ar_type_code->id . "' and u.vertical_id='" . $vertical_code->id . "'")->result();
            if (count($dpst_vertical_exists__or_not) >= 1) {
                $record_status['error'] = 1;
                $record_status['error_msg4'] = "DPST Vertical Mapping already exits";
                if ($record_status['error_msg4'] != '') {
                    $G = '|';
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['G'] = $record_status['error_msg'] .  $A . $record_status['error_msg1'] .  $C . $record_status['error_msg2'] .  $T . $record_status['error_msg3'] .  $G . $record_status['error_msg4'];
        }
        return $dataInSheet;
    }

    public function area_country_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/area_country_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/area_country_upload', $this->data);
    }

    public function area_country_map_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['area_country_upload_file']['name'] != '') {
            if ($_FILES['area_country_upload_file']['name']) {
                $f_type                             = explode(".", $_FILES['area_country_upload_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['area_country_upload_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Area_Code', 'Country_Code');
                    $makeArray = array('Area_Code' => 'Area_Code', 'Country_Code' => 'Country_Code');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->area_country_validation($dataInSheet);
                            if ($dataInSheet['E'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }

                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Area_Code = $SheetDataKey['Area_Code'];
                                $Country_Code = $SheetDataKey['Country_Code'];
                                $Area_Code = filter_var(trim($allDataInSheet[$i][$Area_Code]), FILTER_SANITIZE_STRING);
                                $Country_Code = filter_var(trim($allDataInSheet[$i][$Country_Code]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $area_id = $this->db->query("select id from area_master where area_code='" . $Area_Code . "'")->row();
                                $country_id = $this->db->query("select id from country_master where country_code='" .  $Country_Code . "'")->row();

                                $fetchData[] = array(
                                    'area_name_id' =>  $area_id->id,
                                    'country_id' => $country_id->id,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->base_model->setBatchImportAreaCountry($fetchData);
                            if ($this->base_model->importDataAreaCountry() == 1) {
                                $msg_success = count($fetchData) . "  rows of Area Country Mapping info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo 'no';
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('E2:E' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('E2:E' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('E1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function area_country_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";
        $record_status['error_msg2'] = "";
        $record_status['error_msg3'] = "";
        $record_status['error_msg4'] = "";

        if ($dataInSheet['B'] != "Area_Code" || $dataInSheet['D'] != "Country_Code") {

            if ($dataInSheet['B'] == NULL || $dataInSheet['D'] == NULL) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['B']) {
                $area_exists__or_not = $this->db->query("select u.*from area_master as u where u.area_code='" . $dataInSheet['B'] . "'")->result();
                if (count($area_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg1'] = "Area_Code does not exits";
                    if ($record_status['error_msg1'] != '') {
                        $A = '|';
                    }
                }
            }

            if ($dataInSheet['D']) {
                $country_exists__or_not = $this->db->query("select u.*from country_master as u where u.country_code='" . $dataInSheet['D'] . "'")->result();
                if (count($country_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg2'] = "Country_Code does not exits";
                    if ($record_status['error_msg2'] != '') {
                        $C = '|';
                    }
                }
            }

            $area_id = $this->db->query("select id from area_master where area_code='" . $dataInSheet['B'] . "'")->row();
            $country_id = $this->db->query("select id from country_master where country_code='" .  $dataInSheet['D'] . "'")->row();

            $area_country_exists__or_not = $this->db->query("select u.*from area_country_mapping as u where u.area_name_id='" . $area_id->id . "' and u.country_id='" . $country_id->id . "'")->result();
            if (count($area_country_exists__or_not) >= 1) {
                $record_status['error'] = 1;
                $record_status['error_msg4'] = "Area Country Mapping already exits";
                if ($record_status['error_msg4'] != '') {
                    $G = '|';
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['E'] = $record_status['error_msg'] .  $A . $record_status['error_msg1'] .  $C . $record_status['error_msg2'] .  $G . $record_status['error_msg4'];
        }
        return $dataInSheet;
    }

    public function transaction_type_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/transaction_type_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/transaction_type_upload', $this->data);
    }

    public function transaction_type_map_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['transaction_type_upload_file']['name'] != '') {
            if ($_FILES['transaction_type_upload_file']['name']) {
                $f_type                             = explode(".", $_FILES['transaction_type_upload_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['transaction_type_upload_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Transcation_Type_Code', 'ARType_Code', 'Vertical_Code', 'Priority', 'Sequence');
                    $makeArray = array('Transcation_Type_Code' => 'Transcation_Type_Code', 'ARType_Code' => 'ARType_Code', 'Vertical_Code' => 'Vertical_Code', 'Priority' => 'Priority', 'Sequence' => 'Sequence');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->transaction_type_validation($dataInSheet);
                            if ($dataInSheet['I'] != '') {

                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Transcation_Type_Code = $SheetDataKey['Transcation_Type_Code'];
                                $ARType_Code = $SheetDataKey['ARType_Code'];
                                $Vertical_Code = $SheetDataKey['Vertical_Code'];
                                $Priority = $SheetDataKey['Priority'];
                                $Sequence = $SheetDataKey['Sequence'];

                                $Transcation_Type_Code = filter_var(trim($allDataInSheet[$i][$Transcation_Type_Code]), FILTER_SANITIZE_STRING);
                                $ARType_Code = filter_var(trim($allDataInSheet[$i][$ARType_Code]), FILTER_SANITIZE_STRING);
                                $Vertical_Code = filter_var(trim($allDataInSheet[$i][$Vertical_Code]), FILTER_SANITIZE_STRING);
                                $Priority = filter_var(trim($allDataInSheet[$i][$Priority]), FILTER_SANITIZE_STRING);
                                $Sequence = filter_var(trim($allDataInSheet[$i][$Sequence]), FILTER_SANITIZE_STRING);

                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();
                                $transaction_id = $this->db->query("select id from transaction_type_master where transaction_type_code='" . $Transcation_Type_Code . "'")->row();
                                $ar_type_id = $this->db->query("select id from ar_type_master where ar_type_code='" .  $ARType_Code . "'")->row();
                                $vertical_id = $this->db->query("select id from vertical_master where vertical_code='" . $Vertical_Code . "'")->row();


                                $fetchData[] = array(
                                    'transaction_type_id' =>  $transaction_id->id,
                                    'vertical_id' => $vertical_id->id,
                                    'ar_type_id' =>  $ar_type_id->id,
                                    'priority' => $Priority,
                                    'sequence_id' => $Sequence,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->base_model->setBatchImportTransactionTypeMap($fetchData);
                            if ($this->base_model->importDataTransactionTypeMap() == 1) {
                                $msg_success = count($fetchData) . "  rows of Transaction Type Mapping info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo 'no';
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('I1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }


    function transaction_type_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";
        $record_status['error_msg2'] = "";
        $record_status['error_msg3'] = "";
        $record_status['error_msg4'] = "";

        if ($dataInSheet['A'] != "Transcation_Type_Code" || $dataInSheet['C'] != "ARType_Code" || $dataInSheet['E'] != "Vertical_Code" || $dataInSheet['G'] != "Priority" || $dataInSheet['H'] != "Sequence") {

            if ($dataInSheet['A'] == NULL || $dataInSheet['C'] == NULL || $dataInSheet['E'] == NULL || $dataInSheet['G'] == NULL || $dataInSheet['H'] == NULL) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['A']) {
                $transaction_exists__or_not = $this->db->query("select u.*from transaction_type_master as u where u.transaction_type_code='" . $dataInSheet['A'] . "'")->result();
                if (count($transaction_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg1'] = "Transcation_Type_Code does not exits";
                    if ($record_status['error_msg1'] != '') {
                        $B = '|';
                    }
                }
            }

            if ($dataInSheet['C']) {
                $ar_type_exists__or_not = $this->db->query("select u.*from ar_type_master as u where u.ar_type_code='" . $dataInSheet['C'] . "'")->result();
                if (count($ar_type_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg2'] = "ARType_Code does not exits";
                    if ($record_status['error_msg2'] != '') {
                        $D = '|';
                    }
                }
            }

            if ($dataInSheet['E']) {
                $vertical_exists__or_not = $this->db->query("select u.*from vertical_master as u where u.vertical_code='" . $dataInSheet['E'] . "'")->result();
                if (count($vertical_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg3'] = "Vertical_Code does not exits";
                    if ($record_status['error_msg3'] != '') {
                        $F = '|';
                    }
                }
            }

            $transaction_id = $this->db->query("select id from transaction_type_master where transaction_type_code='" . $dataInSheet['A'] . "'")->row();
            $ar_type_id = $this->db->query("select id from ar_type_master where ar_type_code='" .  $dataInSheet['C'] . "'")->row();
            $vertical_id = $this->db->query("select id from vertical_master where vertical_code='" . $dataInSheet['E'] . "'")->row();
            $transaction_type_exists__or_not = $this->db->query("select u.*from transaction_type_mapping as u where u.transaction_type_id='" . $transaction_id->id . "' and u.vertical_id='" . $vertical_id->id . "' and u.ar_type_id='" . $ar_type_id->id . "'")->result();
            if (count($transaction_type_exists__or_not) >= 1) {
                $record_status['error'] = 1;
                $record_status['error_msg4'] = "Transcation Type Mapping already exits";
                if ($record_status['error_msg4'] != '') {
                    $G = '|';
                }
            }
        }



        if ($record_status['error'] == 1) {
            $dataInSheet['I'] = $record_status['error_msg'] .  $B . $record_status['error_msg1'] .  $D . $record_status['error_msg2'] .  $F . $record_status['error_msg3'] .  $G . $record_status['error_msg4'];
        }
        return $dataInSheet;
    }


    public function vertical_entity_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/mapping/vertical_entity_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/mapping/vertical_entity_upload', $this->data);
    }

    public function vertical_entity_map_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['vertical_entity_upload_file']['name'] != '') {
            if ($_FILES['vertical_entity_upload_file']['name']) {
                $f_type                             = explode(".", $_FILES['vertical_entity_upload_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['vertical_entity_upload_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Vertical_Code', 'Cluster_Code', 'SBU_Code', 'Consol_Code', 'Reporting_FX', 'Local_FX');
                    $makeArray = array('Vertical_Code' => 'Vertical_Code', 'Cluster_Code' => 'Cluster_Code', 'SBU_Code' => 'SBU_Code', 'Consol_Code' => 'Consol_Code', 'Reporting_FX' => 'Reporting_FX', 'Local_FX' => 'Local_FX');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->vertical_entity_validation($dataInSheet);
                            if ($dataInSheet['K'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Vertical_Code = $SheetDataKey['Vertical_Code'];
                                $Cluster_Code = $SheetDataKey['Cluster_Code'];
                                $SBU_Code = $SheetDataKey['SBU_Code'];
                                $Consol_Code = $SheetDataKey['Consol_Code'];
                                $Reporting_FX = $SheetDataKey['Reporting_FX'];
                                $Local_FX = $SheetDataKey['Local_FX'];
                                $Vertical_Code = filter_var(trim($allDataInSheet[$i][$Vertical_Code]), FILTER_SANITIZE_STRING);
                                $Cluster_Code = filter_var(trim($allDataInSheet[$i][$Cluster_Code]), FILTER_SANITIZE_STRING);
                                $SBU_Code = filter_var(trim($allDataInSheet[$i][$SBU_Code]), FILTER_SANITIZE_STRING);
                                $Consol_Code = filter_var(trim($allDataInSheet[$i][$Consol_Code]), FILTER_SANITIZE_STRING);
                                $Reporting_FX = filter_var(trim($allDataInSheet[$i][$Reporting_FX]), FILTER_SANITIZE_STRING);
                                $Local_FX = filter_var(trim($allDataInSheet[$i][$Local_FX]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $vertical_id = $this->db->query("select id from vertical_master where vertical_code='" . $Vertical_Code . "'")->row();
                                $cluster_id = $this->db->query("select id from cluster_master where cluster_code='" .  $Cluster_Code . "'")->row();
                                $sbu_id = $this->db->query("select id from sbu_master where sbu_code='" . $SBU_Code . "'")->row();

                                $console_id = $this->db->query("select id from console_master where console_code='" . $Consol_Code . "'")->row();
                                $reporting_id = $this->db->query("select id from local_fx_master where local_fx_name='" .  $Reporting_FX . "'")->row();
                                $local_id = $this->db->query("select id from local_fx_master where local_fx_name='" . $Local_FX . "'")->row();


                                $fetchData[] = array(
                                    'vertical_id' =>  $vertical_id->id,
                                    'cluster_id' => $cluster_id->id,
                                    'sbu_id' =>  $sbu_id->id,
                                    'console_id' => $console_id->id,
                                    'reporting_fx_id' =>  $reporting_id->id,
                                    'local_fx_id' =>  $local_id->id,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->base_model->setBatchImportVerticalEntity($fetchData);
                            if ($this->base_model->importDataVerticalEntity() == 1) {
                                $msg_success = count($fetchData) . "  rows of Vertical Entity Mapping info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo 'no';
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('K2:K' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('K2:K' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('K1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }


    function vertical_entity_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";
        $record_status['error_msg2'] = "";
        $record_status['error_msg3'] = "";
        $record_status['error_msg4'] = "";

        if ($dataInSheet['A'] != "Vertical_Code" || $dataInSheet['C'] != "Cluster_Code" || $dataInSheet['E'] != "SBU_Code" || $dataInSheet['G'] != "Consol_Code" || $dataInSheet['I'] != "Reporting_FX" || $dataInSheet['J'] != "Local_FX") {

            if ($dataInSheet['A'] == Null || $dataInSheet['C'] == Null || $dataInSheet['E'] == Null || $dataInSheet['G'] == Null || $dataInSheet['I'] == Null || $dataInSheet['J'] == Null) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['A']) {
                $vertical__or_not = $this->db->query("select u.*from vertical_master as u where u.vertical_code='" . $dataInSheet['A'] . "'")->result();
                if (count($vertical__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg1'] = "Vertical_Code does not exits";
                    if ($record_status['error_msg1'] != '') {
                        $B = '|';
                    }
                }
            }

            if ($dataInSheet['C']) {
                $cluster_exists__or_not = $this->db->query("select u.*from cluster_master as u where u.cluster_code='" . $dataInSheet['C'] . "'")->result();
                if (count($cluster_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg2'] = "Cluster_Code does not exits";
                    if ($record_status['error_msg2'] != '') {
                        $D = '|';
                    }
                }
            }

            if ($dataInSheet['E']) {
                $sbu_exists__or_not = $this->db->query("select u.*from sbu_master as u where u.sbu_code='" . $dataInSheet['E'] . "'")->result();
                if (count($sbu_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg3'] = "SBU_Code does not exits";
                    if ($record_status['error_msg3'] != '') {
                        $F = '|';
                    }
                }
            }

            if ($dataInSheet['G']) {
                $console_exists__or_not = $this->db->query("select u.*from console_master as u where u.console_code='" . $dataInSheet['G'] . "'")->result();
                if (count($console_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg4'] = "Consol_Code does not exits";
                    if ($record_status['error_msg4'] != '') {
                        $H = '|';
                    }
                }
            }

            if ($dataInSheet['I']) {
                $local_fx_exists__or_not = $this->db->query("select u.*from local_fx_master as u where u.local_fx_name='" . $dataInSheet['I'] . "'")->result();
                if (count($local_fx_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg5'] = "Reporting_FX does not exits";
                    if ($record_status['error_msg5'] != '') {
                        $I = '|';
                    }
                }
            }

            if ($dataInSheet['J']) {
                $local_fx_exists__or_not = $this->db->query("select u.*from local_fx_master as u where u.local_fx_name='" . $dataInSheet['J'] . "'")->result();
                if (count($local_fx_exists__or_not) == 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg6'] = "Local_FX does not exits";
                    if ($record_status['error_msg6'] != '') {
                        $J = '|';
                    }
                }
            }
            $vertical_id = $this->db->query("select id from vertical_master where vertical_code='" . $dataInSheet['A'] . "'")->row();
            $cluster_id = $this->db->query("select id from cluster_master where cluster_code='" .  $dataInSheet['C'] . "'")->row();
            $sbu_id = $this->db->query("select id from sbu_master where sbu_code='" . $dataInSheet['E'] . "'")->row();
            $console_id = $this->db->query("select id from console_master where console_code='" . $dataInSheet['G'] . "'")->row();
            $reporting_id = $this->db->query("select id from local_fx_master where local_fx_name='" .  $dataInSheet['I'] . "'")->row();
            $local_id = $this->db->query("select id from local_fx_master where local_fx_name='" . $dataInSheet['J'] . "'")->row();

            $vertical_entity_exists__or_not = $this->db->query("select u.*from vertical_entity_mapping as u where u.vertical_id='" . $vertical_id->id . "' and u.cluster_id='" . $cluster_id->id . "' and u.sbu_id='" . $sbu_id->id . "' and u.console_id='" . $console_id->id . "' and u.reporting_fx_id='" . $reporting_id->id . "' and u.local_fx_id='" . $local_id->id . "'")->result();
            if (count($vertical_entity_exists__or_not) >= 1) {
                $record_status['error'] = 1;
                $record_status['error_msg7'] = "Vertical-Entity-Currency Mapping already exits";
                if ($record_status['error_msg7'] != '') {
                    $G = '|';
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['K'] = $record_status['error_msg'] .  $B . $record_status['error_msg1'] .  $D . $record_status['error_msg2'] .  $F . $record_status['error_msg3'] .  $H . $record_status['error_msg4'] .  $I . $record_status['error_msg5'] .  $J . $record_status['error_msg6'] .  $G . $record_status['error_msg7'];
        }
        return $dataInSheet;
    }

    /*Month End AR List*/
    /* Kiran */
    public function month_end_ar_list($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        $this->data['dpst_master'] = $this->db->query("select * from dpst_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/month_end_ar_list');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/month_end_ar_list', $this->data);
    }



    public function month_end_ar_list_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        // POST data
        $postData = $this->input->post();

        // Get data
        $data = $this->Ajax_model->month_end_ar_list_ajaxdata($postData);

        //$data = $this->db->query("select * from month_end_ar_list")->result();

        echo json_encode($data);
    }

    public function upload_month_end_transcation()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->template->admin_render('admin/transcation/upload_month_end_transcation', $this->data);
    }

    /*bulk upload*/
    /* Kiran */
    public function month_end_ar_list_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['month_end_ar_list_file']['name'] != '') {
            if ($_FILES['month_end_ar_list_file']['name']) {
                $f_type                             = explode(".", $_FILES['month_end_ar_list_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['month_end_ar_list_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;

                    $createArray = array('Area', 'Region', 'DPST', 'Month', 'Sales_Engg_Code', 'Sales_Engg_Name', 'Customer_Group', 'Parent_Code', 'Child_Code', 'Customer_Name', 'Project_Name', 'PO_Number', 'PO_Credit_Term', 'Company', 'Transaction_Type', 'Invoice_Number', 'Org_Document_Number', 'Document_Number', 'Dispatch_Date', 'Invoice_Date', 'Credit_Days', 'Due_Date', 'Credit_Days_Adj', 'Rev_Due_Date', 'Invoice_Amount', 'Paid_Amount', 'Balance_Amount', 'Currency', 'Fx_Rate', 'Fx_Invoice_Amount',  'Fx_Paid_Amount', 'Fx_Balance_Amount', 'Customer_Type', 'ECL_Category', 'ECL_RTN_Days',  'FEMA_Days', 'Consol', 'Org_DPST', 'Org_TT');

                    $makeArray = array('Area' => 'Area', 'Region' => 'Region', 'DPST' => 'DPST', 'Month' => 'Month', 'Sales_Engg_Code' => 'Sales_Engg_Code', 'Sales_Engg_Name' => 'Sales_Engg_Name', 'Customer_Group' => 'Customer_Group', 'Parent_Code' => 'Parent_Code', 'Child_Code' => 'Child_Code', 'Customer_Name' => 'Customer_Name', 'Project_Name' => 'Project_Name', 'PO_Number' => 'PO_Number', 'PO_Credit_Term' => 'PO_Credit_Term', 'Company' => 'Company', 'Transaction_Type' => 'Transaction_Type', 'Invoice_Number' => 'Invoice_Number', 'Org_Document_Number' => 'Org_Document_Number', 'Document_Number' => 'Document_Number', 'Dispatch_Date' => 'Dispatch_Date', 'Invoice_Date' => 'Invoice_Date', 'Credit_Days' => 'Credit_Days', 'Due_Date' => 'Due_Date', 'Credit_Days_Adj' => 'Credit_Days_Adj', 'Rev_Due_Date' => 'Rev_Due_Date', 'Invoice_Amount' => 'Invoice_Amount', 'Paid_Amount' => 'Paid_Amount', 'Balance_Amount' => 'Balance_Amount', 'Currency' => 'Currency', 'Fx_Rate' => 'Fx_Rate', 'Customer_Type' => 'Customer_Type', 'ECL_Category' => 'ECL_Category', 'ECL_RTN_Days' => 'ECL_RTN_Days', 'FEMA_Days' => 'FEMA_Days', 'Consol' => 'Consol', 'Org_DPST' => 'Org_DPST', 'Org_TT' => 'Org_TT');

                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->month_end_ar_validation($dataInSheet);
                            if ($dataInSheet['AN'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }

                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Area = $SheetDataKey['Area'];
                                $Region = $SheetDataKey['Region'];
                                $DPST = $SheetDataKey['DPST'];
                                $Month = $SheetDataKey['Month'];
                                $Sales_Engg_Code = $SheetDataKey['Sales_Engg_Code'];
                                $Sales_Engg_Name = $SheetDataKey['Sales_Engg_Name'];
                                $Customer_Group = $SheetDataKey['Customer_Group'];
                                $Parent_Code = $SheetDataKey['Parent_Code'];
                                $Child_Code = $SheetDataKey['Child_Code'];
                                $Customer_Name = $SheetDataKey['Customer_Name'];
                                $Project_Name = $SheetDataKey['Project_Name'];
                                $PO_Number = $SheetDataKey['PO_Number'];
                                $PO_Credit_Term = $SheetDataKey['PO_Credit_Term'];
                                $Company = $SheetDataKey['Company'];
                                $Transaction_Type = $SheetDataKey['Transaction_Type'];
                                $Invoice_Number = $SheetDataKey['Invoice_Number'];
                                $Org_Document_Number = $SheetDataKey['Org_Document_Number'];
                                $Document_Number = $SheetDataKey['Document_Number'];
                                $Dispatch_Date = $SheetDataKey['Dispatch_Date'];
                                $Invoice_Date = $SheetDataKey['Invoice_Date'];
                                $Credit_Days = $SheetDataKey['Credit_Days'];
                                $Due_Date = $SheetDataKey['Due_Date'];
                                $Credit_Days_Adj = $SheetDataKey['Credit_Days_Adj'];
                                $Rev_Due_Date = $SheetDataKey['Rev_Due_Date'];
                                $Invoice_Amount = $SheetDataKey['Invoice_Amount'];
                                $Paid_Amount = $SheetDataKey['Paid_Amount'];
                                $Balance_Amount = $SheetDataKey['Balance_Amount'];
                                $Currency = $SheetDataKey['Currency'];
                                $Fx_Rate = $SheetDataKey['Fx_Rate'];
                                $Fx_Invoice_Amount = $SheetDataKey['Fx_Invoice_Amount'];
                                $Fx_Paid_Amount = $SheetDataKey['Fx_Paid_Amount'];
                                $Fx_Balance_Amount = $SheetDataKey['Fx_Balance_Amount'];
                                $Customer_Type = $SheetDataKey['Customer_Type'];
                                $ECL_Category = $SheetDataKey['ECL_Category'];
                                $ECL_RTN_Days = $SheetDataKey['ECL_RTN_Days'];
                                $FEMA_Days = $SheetDataKey['FEMA_Days'];
                                $Consol = $SheetDataKey['Consol'];
                                $Org_DPST = $SheetDataKey['Org_DPST'];
                                $Org_TT = $SheetDataKey['Org_TT'];
                                // $Commissioning = $SheetDataKey['Commissioning'];

                                $Area = filter_var(trim($allDataInSheet[$i][$Area]), FILTER_SANITIZE_STRING);
                                $Region = filter_var(trim($allDataInSheet[$i][$Region]), FILTER_SANITIZE_STRING);
                                $DPST = filter_var(trim($allDataInSheet[$i][$DPST]), FILTER_SANITIZE_STRING);
                                $Month = filter_var(trim($allDataInSheet[$i][$Month]), FILTER_SANITIZE_STRING);
                                $Sales_Engg_Code = filter_var(trim($allDataInSheet[$i][$Sales_Engg_Code]), FILTER_SANITIZE_STRING);
                                $Sales_Engg_Name = filter_var(trim($allDataInSheet[$i][$Sales_Engg_Name]), FILTER_SANITIZE_STRING);
                                $Customer_Group = filter_var(trim($allDataInSheet[$i][$Customer_Group]), FILTER_SANITIZE_STRING);
                                $Parent_Code = filter_var(trim($allDataInSheet[$i][$Parent_Code]), FILTER_SANITIZE_STRING);
                                $Child_Code = filter_var(trim($allDataInSheet[$i][$Child_Code]), FILTER_SANITIZE_STRING);
                                $Customer_Name = filter_var(trim($allDataInSheet[$i][$Customer_Name]), FILTER_SANITIZE_STRING);
                                $Project_Name = filter_var(trim($allDataInSheet[$i][$Project_Name]), FILTER_SANITIZE_STRING);
                                $PO_Number = filter_var(trim($allDataInSheet[$i][$PO_Number]), FILTER_SANITIZE_STRING);
                                $PO_Credit_Term = filter_var(trim($allDataInSheet[$i][$PO_Credit_Term]), FILTER_SANITIZE_STRING);
                                $Company = filter_var(trim($allDataInSheet[$i][$Company]), FILTER_SANITIZE_STRING);
                                $Transaction_Type = filter_var(trim($allDataInSheet[$i][$Transaction_Type]), FILTER_SANITIZE_STRING);
                                $Invoice_Number = filter_var(trim($allDataInSheet[$i][$Invoice_Number]), FILTER_SANITIZE_STRING);
                                $Org_Document_Number = filter_var(trim($allDataInSheet[$i][$Org_Document_Number]), FILTER_SANITIZE_STRING);
                                $Document_Number = filter_var(trim($allDataInSheet[$i][$Document_Number]), FILTER_SANITIZE_STRING);
                                $Dispatch_Date = filter_var(trim($allDataInSheet[$i][$Dispatch_Date]), FILTER_SANITIZE_STRING);

                                if ($Dispatch_Date != '' && $Dispatch_Date != '-' && $Dispatch_Date != 'NA' && $Dispatch_Date != '1970-01-01') {
                                    $Final_Dispatch_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Dispatch_Date)));
                                } else {
                                    $Final_Dispatch_Date = '0000-00-00';
                                }

                                $Invoice_Date = filter_var(trim($allDataInSheet[$i][$Invoice_Date]), FILTER_SANITIZE_STRING);
                                if ($Invoice_Date != '' && $Invoice_Date != '-' && $Invoice_Date != 'NA' && $Invoice_Date != '1970-01-01') {
                                    $Final_Invoice_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Invoice_Date)));
                                } else {
                                    $Final_Invoice_Date = '0000-00-00';
                                }
                                $Credit_Days = filter_var(trim($allDataInSheet[$i][$Credit_Days]), FILTER_SANITIZE_STRING);

                                $Due_Date = filter_var(trim($allDataInSheet[$i][$Due_Date]), FILTER_SANITIZE_STRING);
                                if ($Due_Date != '' && $Due_Date != '-' && $Due_Date != 'NA' && $Due_Date != '1970-01-01') {
                                    $Final_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Due_Date)));
                                } else {
                                    $Final_Due_Date = '0000-00-00';
                                }
                                $Credit_Days_Adj = filter_var(trim($allDataInSheet[$i][$Credit_Days_Adj]), FILTER_SANITIZE_STRING);
                                $Rev_Due_Date = filter_var(trim($allDataInSheet[$i][$Rev_Due_Date]), FILTER_SANITIZE_STRING);

                                if ($Rev_Due_Date != ''  && $Rev_Due_Date != '-' && $Rev_Due_Date != 'NA' && $Rev_Due_Date != '1970-01-01') {
                                    $Final_Rev_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Rev_Due_Date)));
                                } else {
                                    $Final_Rev_Due_Date = '0000-00-00';
                                }

                                $Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Paid_Amount = filter_var(trim($allDataInSheet[$i][$Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Balance_Amount = filter_var(trim($allDataInSheet[$i][$Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Currency = filter_var(trim($allDataInSheet[$i][$Currency]), FILTER_SANITIZE_STRING);
                                $Fx_Rate = filter_var(trim($allDataInSheet[$i][$Fx_Rate]), FILTER_SANITIZE_STRING);
                                $Fx_Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Fx_Paid_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Fx_Balance_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Customer_Type = filter_var(trim($allDataInSheet[$i][$Customer_Type]), FILTER_SANITIZE_STRING);
                                $ECL_Category = filter_var(trim($allDataInSheet[$i][$ECL_Category]), FILTER_SANITIZE_STRING);
                                $ECL_RTN_Days = filter_var(trim($allDataInSheet[$i][$ECL_RTN_Days]), FILTER_SANITIZE_STRING);
                                $FEMA_Days = filter_var(trim($allDataInSheet[$i][$FEMA_Days]), FILTER_SANITIZE_STRING);
                                $Consol = filter_var(trim($allDataInSheet[$i][$Consol]), FILTER_SANITIZE_STRING);
                                $Org_DPST = filter_var(trim($allDataInSheet[$i][$Org_DPST]), FILTER_SANITIZE_STRING);
                                $Org_TT = filter_var(trim($allDataInSheet[$i][$Org_TT]), FILTER_SANITIZE_STRING);
                                // $Commissioning = filter_var(trim($allDataInSheet[$i][$Commissioning]), FILTER_SANITIZE_STRING);
                                $sys_created_on =  date("Y-m-d h:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $fetchData[] = array(
                                    'month_year' => $this->input->post('month_year'),
                                    'area' =>  $Area,
                                    'region' => $Region,
                                    'dpst' => $DPST,
                                    'month' => date('Y-m-d', strtotime(str_replace("/", "-", $Month))),
                                    'sales_engg_code' => $Sales_Engg_Code,
                                    'sales_engg_name' => $Sales_Engg_Name,
                                    'customer_group' =>  $Customer_Group,
                                    'parent_code' => $Parent_Code,
                                    'child_code' => $Child_Code,
                                    'customer_name' =>  $Customer_Name,
                                    'project_name' => $Project_Name,
                                    'po_name' => $PO_Number,
                                    'po_credit_term' =>  $PO_Credit_Term,
                                    'company' => $Company,
                                    'transaction_type' => $Transaction_Type,
                                    'invoice_number' =>  $Invoice_Number,
                                    'org_document_number' => $Org_Document_Number,
                                    'document_number' => $Document_Number,
                                    'dispatch_date' => $Final_Dispatch_Date,
                                    'invoice_date' => $Final_Invoice_Date,
                                    'credit_days' => $Credit_Days,
                                    'due_date' =>  $Final_Due_Date,
                                    'credit_days_adj' => $Credit_Days_Adj,
                                    'rev_due_date' => $Final_Rev_Due_Date,
                                    'invoice_amount' => str_replace(',', '', $Invoice_Amount),
                                    'paid_amount' => str_replace(',', '', $Paid_Amount),
                                    'balance_amount' => str_replace(',', '', $Balance_Amount),
                                    'currency' =>  $Currency,
                                    'fx_rate' => str_replace(',', '', $Fx_Rate),
                                    'fx_invoice_amount' => str_replace(',', '', $Fx_Invoice_Amount),
                                    'fx_paid_amount' => str_replace(',', '', $Fx_Paid_Amount),
                                    'fx_balance_amount' => str_replace(',', '', $Fx_Balance_Amount),
                                    'customer_type' => $Customer_Type,
                                    'ecl_category' =>  $ECL_Category,
                                    'ecl_days' => $ECL_RTN_Days,
                                    'fema_days' => $FEMA_Days,
                                    'consol' => $Consol,
                                    'org_dpst' => $Org_DPST,
                                    'org_tt' =>  $Org_TT,
                                   // 'commissioning' =>  $Commissioning,
                                    'sys_created_on' => $sys_created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->db->delete('month_end_ar_list', array('month_year' => $this->input->post('month_year')));
                            $this->base_model->setBatchImportMonth_end_Ar_list($fetchData);
                            if ($this->base_model->importDataMonth_end_Ar_list() == 1) {
                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */
                                $msg_success = count($fetchData) . "  rows of month-end AR info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);


                                // // Insert process_pending_list Data 

                                // $process_data_list = $this->db->get_where('process_pending_list', array('report_name' => 'month_end_ar_upload', 'month' => $this->input->post('month_year'), 'status' => 1))->result();
                                // $data_array = array(
                                //     'report_name' => "month_end_ar_upload",
                                //     'month' => $this->input->post('month_year'),
                                //     'status' => 0
                                // );

                                // if (count($process_data_list) > 0) {

                                //     $this->db->where('report_name', 'month_end_ar_upload');
                                //     $this->db->where('month', $this->input->post('month_year'));
                                //     $this->db->update('process_pending_list', array('status' => 0));
                                // } else {

                                //     $this->db->insert('process_pending_list', $data_array);
                                // }

                                /* Update month end ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('month_end_ar_list', array('process_data' => 0));
                                /* Update current ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('daily_ar', array('process_data' => 0));
                            } else {
                                echo 'no';
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('AN2:AN' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AN2:AN' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('AN1:AN' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AN1:AN' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('AN1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function month_end_ar_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";

        if ($dataInSheet['G'] != 'Month' || $dataInSheet['V'] != 'Dispatch_Date' || $dataInSheet['W'] != 'Invoice_Date' || $dataInSheet['Y'] != 'Due_Date' || $dataInSheet['AA'] != 'Rev_Due_Date') {

            if ($dataInSheet['G'] != '' && $dataInSheet['G'] != 'NA') {
                if (!check_format_date($dataInSheet['G'])) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Check Month Format";
                }
            }

            if ($dataInSheet['V'] != ''  && $dataInSheet['V'] != "NA") {
                if (!check_format_date($dataInSheet['V'])) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Check Dispatch_Date Format";
                }
            }

            if ($dataInSheet['W'] != ''  && $dataInSheet['W'] != 'NA') {
                if (!check_format_date($dataInSheet['W'])) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Check Invoice_Date Format";
                }
            }

            if ($dataInSheet['Y'] != ''  && $dataInSheet['Y'] != 'NA') {
                if (!check_format_date($dataInSheet['Y'])) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Check Due_Date Format";
                }
            }

            if ($dataInSheet['AA'] != ''  && $dataInSheet['AA'] != 'NA') {
                if (!check_format_date($dataInSheet['AA'])) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Check Rev_Due_Date Format";
                }
            }
            
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['AO'] = $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Upload_Daily_Transcation*/
    public function upload_daily_collection()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->data['upload_daily_collection'] = $this->db->query("select * from daily_collection")->result();
        $this->data['dpst_master'] = $this->db->query("select * from dpst_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_daily_collection');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_daily_collection', $this->data);
    }

    /*upload_daily_ar*/
    public function upload_daily_ar($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->data['daily_ar'] = $this->db->query("select * from daily_ar")->result();
        $this->data['dpst_master'] = $this->db->query("select * from dpst_master")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_daily_ar');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_daily_ar', $this->data);
    }

    /*Month_End_FX_Rates*/
    /* Kiran */
    public function month_end_fx_rates($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('month_year', 'Month Year', 'xss_clean|required');
            $this->form_validation->set_rules('local_fx_id', 'Local FX Name', 'xss_clean|required');
            $this->form_validation->set_rules('rate', 'Rate', 'xss_clean|required|numeric');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            if ($this->form_validation->run() == TRUE) {
                $table = "month_end_fx_rates";
                $inputdata['month_year']        = $this->input->post('month_year');
                $inputdata['local_fx_id']        = $this->input->post('local_fx_id');
                $inputdata['rate']                 = $this->input->post('rate');
                $inputdata['created_on']                        = date('Y-m-d');

                if ($this->input->post('id')) {
                    $this->db->where('month_end_fx_rates_id', $this->input->post('id'));
                    if ($this->db->update($table, $inputdata)) {
                        $this->session->set_flashdata('flash_message', ' Updated Succesfully');
                        redirect('admin/resources/month_end_fx_rates', 'refresh');
                    } else {
                        $this->session->set_flashdata('flash_message', 'Unable to update');
                        redirect('admin/resources/month_end_fx_rates');
                    }
                }

                if ($this->db->insert($table, $inputdata)) {
                    $this->session->set_flashdata('flash_message', ' Added Succesfully');
                    redirect('admin/resources/month_end_fx_rates', 'refresh');
                } else {
                    $this->session->set_flashdata('flash_message', 'Unable to Add');
                    redirect('admin/resources/month_end_fx_rates');
                }
            }
        }

        if ($param1 == "edit") {
            $month_end_fx_rates = $this->db->get_where('month_end_fx_rates', array('month_end_fx_rates_id' => $param2))->result();
            $this->data['month_end_fx_rates'] =  $month_end_fx_rates[0];
        }

        if ($param1 == "delete") {
            if ($this->db->delete('month_end_fx_rates', array('month_end_fx_rates_id' => $param2))) {
                $this->session->set_flashdata('flash_message', 'Month-End FX Rate Deleted Succesfully');
                redirect('admin/resources/month_end_fx_rates');
            } else {
                $this->session->set_flashdata('flash_message', 'Unable to Delete');
                redirect('admin/resources/month_end_fx_rates');
            }
        }

        $this->data['local_fx_master'] = $this->db->query("select * from local_fx_master")->result();
       // $this->data['month_end_fx_rates_list'] = $this->db->query("select * from month_end_fx_rates where month_year='" . date('m-Y', strtotime(date('Y-m') . " -1 month")) . "'")->result();
       $this->data['month_end_fx_rates_list'] = $this->db->query("select * from month_end_fx_rates")->result();
        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/month_end_fx_rates');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/month_end_fx_rates', $this->data);
    }

    /* Month End Fx Rates Validation */
    /*Kiran */
    public function month_end_fx_rates_validation()
    {
        $month_year = trim($this->input->post('month_year'));
        $local_fx_id = trim($this->input->post('local_fx_id'));
        $rate = trim($this->input->post('rate'));
        /*  echo $month_year . '<br>';
        echo $local_fx_id. '<br>';
        echo $rate;
        die; */
        $month_end_fx_rates = $this->db->query("select * from month_end_fx_rates where month_year='" . $month_year . "' and local_fx_id='" . $local_fx_id . "'")->result();

        if (count($month_end_fx_rates) >= 1) {
            echo '1';
        } else {
            echo "0";
        }
    }

    /*Bulk Upload Month-End FX Rates*/
    /*Kiran */
    public function month_end_fx_rates_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->template->admin_render('admin/transcation/month_end_fx_rates_upload', $this->data);
    }


    /*bulk upload*/
    /* Kiran */
    public function month_end_fx_rates_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['month_end_fx_rates_file']['name'] != '') {
            if ($_FILES['month_end_fx_rates_file']['name']) {
                $f_type                             = explode(".", $_FILES['month_end_fx_rates_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['month_end_fx_rates_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();



                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Local_FX_Name', 'Rate', 'Month_Year');
                    $makeArray = array('Local_FX_Name' => 'Local_FX_Name', 'Rate' => 'Rate', 'Month_Year' => 'Month_Year');
                    $SheetDataKey = array();
                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->month_fx_validation($dataInSheet);
                            if ($dataInSheet['D'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Month_Year = $SheetDataKey['Month_Year'];
                                $Local_FX_Name = $SheetDataKey['Local_FX_Name'];
                                $Rate = $SheetDataKey['Rate'];
                                $Month_Year = filter_var(trim($allDataInSheet[$i][$Month_Year]), FILTER_SANITIZE_STRING);
                                $Local_FX_Name = filter_var(trim($allDataInSheet[$i][$Local_FX_Name]), FILTER_SANITIZE_STRING);
                                $Rate = filter_var(trim($allDataInSheet[$i][$Rate]), FILTER_SANITIZE_STRING);
                                $created_on =   date("Y-m-d h:i:s");
                                $user_id =  $this->ion_auth->get_user_id();
                                $newDate = date('m-Y', strtotime(str_replace("/", "-", $Month_Year)));
                                $local_fx_id = $this->db->query("select id from local_fx_master where local_fx_name='" . $Local_FX_Name . "'")->row();

                                $fetchData[] = array(
                                    'month_year' => $newDate,
                                    'local_fx_id' => $local_fx_id->id,
                                    'rate' => str_replace(',', '', $Rate),
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->db->query("delete from month_end_fx_rates where month_year='" . $newDate . "' and local_fx_id='" . $local_fx_id->id . "'");

                            /*  $data['vertical_info'] = $fetchData; */
                            $this->base_model->setBatchImportMonth_end_fx_rate($fetchData);
                            if ($this->base_model->importDataMonth_end_fx_rate() == 1) {
                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */
                                $msg_success = count($fetchData) . " Rows of Month-End FX Rate Uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);


                                // Insert process_pending_list Data 

                                // $process_data_list = $this->db->get_where('process_pending_list', array('report_name' => 'month_end_fx_rates_upload', 'month' => $this->input->post('month_year'), 'status' => 1))->result();

                                // $data_array = array(
                                //     'report_name' => "month_end_fx_rates_upload",
                                //     'month' => $this->input->post('month_year'),
                                //     'status' => 0
                                // );

                                // if (count($process_data_list) > 0) {

                                //     $this->db->where('report_name', 'month_end_fx_rates_upload');
                                //     $this->db->where('month', $this->input->post('month_year'));
                                //     $this->db->update('process_pending_list', array('status' => 0));
                                // } else {

                                //     $this->db->insert('process_pending_list', $data_array);
                                // }

                                /* Update month end ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('month_end_ar_list', array('process_data' => 0));
                                /* Update current ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('daily_ar', array('process_data' => 0));

                                //redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                            } else {
                                echo "no";
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('Month-End_FX-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('D2:D' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('D2:D' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('D1:D' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('D1:D' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('D1')->setValue('Remarks');

                        //echo "<pre>";
                        //print_r($erroredRcords);die;

                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;

                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        //$this->session->set_flashdata('unsucces', $msg);
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                        // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function month_fx_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";

        if ($dataInSheet['A'] != 'Month_Year') {

            if (!check_format_date_month_fx_rates($dataInSheet['A'])) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Check Month_Year Format";
                if ($record_status['error_msg'] != '') {
                    $D = '|';
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['AN'] = $D . $record_status['error_msg'];
        }

        return $dataInSheet;
    }

    /*Month End_AR_User_Inputs*/
    public function month_end_ar_user_inputs($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/month_end_ar_user_inputs');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/month_end_ar_user_inputs', $this->data);
    }

    /* Kiran */
    public function upload_user_input()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        $month_year = '';
        if ($this->input->post("month_year") != '') {
            $this->session->set_userdata("month_year", $this->input->post("month_year"));
            $month_year = $this->session->userdata("month_year");
        } else {

            $month_year = date('m-Y');
        }

        if (!$this->ion_auth->is_admin()) {

            $ver_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;

            $ver = '';
            if (!empty($ver_id)) {
                $ver = $this->db->query("select * from vertical_master where id IN (" . $ver_id . ") ORDER by position ")->result();
            } else {
                $ver = '';
            }

            /* $ver = array();
			if (!empty($ver_id)) {
				foreach (explode(',', $ver_id) as $v) {

					$ver[] = $this->db->query("select * from vertical_master where id=" . $v)->result()[0];
				}
			} */

            if (!empty($ver)) {
                $this->data['vertical_master']  = $ver;
            } else {
                $this->data['vertical_master']  = '';
            }


            $this->data['cluster_master']     = $this->db->query("select c.* from cluster_master as c, vertical_entity_mapping as v where v.cluster_id =c.id AND v.vertical_id IN (" . $ver_id . ") Group by c.id ORDER by c.position")->result();


            $this->data['ar_type_master']     = $this->db->query("select * from ar_type_master")->result();

            $this->data['sbu_master']         = $this->db->query("select s.* from sbu_master as s, vertical_entity_mapping as v where v.sbu_id =s.id AND v.vertical_id IN (" . $ver_id . ") Group by s.id")->result();


            $this->data['console_master']     = $this->db->query("select co.* from console_master as co, vertical_entity_mapping as v where v.console_id =co.id AND v.vertical_id IN (" . $ver_id . ") Group by co.id")->result();


            $this->data['country_master']     = $this->db->query("select * from country_master")->result();
        } else {

            $this->data['vertical_master']     = $this->db->query("select * from vertical_master order by position")->result();
            $this->data['cluster_master']     = $this->db->query("select * from cluster_master order by position")->result();
            $this->data['ar_type_master']     = $this->db->query("select * from ar_type_master")->result();
            $this->data['sbu_master']         = $this->db->query("select * from sbu_master")->result();
            $this->data['country_master']     = $this->db->query("select * from country_master")->result();
        }

        if (!$this->ion_auth->is_admin()) {
            $vertical_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
            $this->data['upload_user_input'] = $this->base_model->getUserInputList($month_year, $vertical_id);
        } else {
            $this->data['upload_user_input'] = $this->db->query("select * from user_input WHERE month_year=" . $month_year)->result();
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_user_input');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_user_input', $this->data);
    }

    public function upload_user_input_upload($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_user_input_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_user_input_upload', $this->data);
    }
    public function user_input_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        // POST data
        $postData = $this->input->post();
        // Get data
        $data = $this->Ajax_model->user_input_ajaxdata($postData);
        //$data = $this->db->query("select * from month_end_ar_list")->result();
        echo json_encode($data);
    }


    /*bulk upload*/
    /* Kiran */
    public function upload_user_input_upload_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['upload_user_input_list_file']['name'] != '') {
            if ($_FILES['upload_user_input_list_file']['name']) {
                $f_type                           = explode(".", $_FILES['upload_user_input_list_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['upload_user_input_list_file']['tmp_name'];
                    $inputFileName                             = $file;
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();
                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Consol_Entity', 'SBU', 'Cluster', 'Vertical', 'Country', 'AR_Type', 'Org_DPST', 'Area', 'Region', 'Sales_Engg_Name', 'Customer_Type', 'Child_Code', 'Customer_Name', 'Project_Name', 'Org_Document_Number', 'Invoice_Date', 'Rev_Due_Date', 'Invoice_Amount', 'Paid_Amount', 'Balance_Amount', 'Currency', 'Fx_Rate', 'Planned_Coll_Amount',  'Planned_Coll_Date', 'Retention', 'Retention_Warranty',  'Planned_RTN_WRTN_Coll_Amount', 'Planned_RTN_WRTN_Date', 'PBG_LC',  'WON', 'CNAF', 'SRN', 'FOC_VALUE',  'WDS',  'GST_TDS', 'TDS', 'LD', 'Legal', 'Responsibility' , 'Commissioning');
                    $makeArray = array('Consol_Entity' => 'Consol_Entity', 'SBU' => 'SBU', 'Cluster' => 'Cluster', 'Vertical' => 'Vertical', 'Country' => 'Country', 'AR_Type' => 'AR_Type', 'Org_DPST' => 'Org_DPST', 'Area' => 'Area', 'Region' => 'Region', 'Sales_Engg_Name' => 'Sales_Engg_Name',  'Customer_Type' => 'Customer_Type', 'Child_Code' => 'Child_Code', 'Customer_Name' => 'Customer_Name', 'Project_Name' => 'Project_Name', 'Org_Document_Number' => 'Org_Document_Number', 'Invoice_Date' => 'Invoice_Date', 'Rev_Due_Date' => 'Rev_Due_Date', 'Invoice_Amount' => 'Invoice_Amount', 'Paid_Amount' => 'Paid_Amount', 'Balance_Amount' => 'Balance_Amount', 'Currency' => 'Currency', 'Fx_Rate' => 'Fx_Rate', 'Planned_Coll_Amount' => 'Planned_Coll_Amount',  'Planned_Coll_Date' => 'Planned_Coll_Date', 'Retention' => 'Retention', 'Retention_Warranty' => 'Retention_Warranty', 'Planned_RTN_WRTN_Coll_Amount' => 'Planned_RTN_WRTN_Coll_Amount', 'Planned_RTN_WRTN_Date' => 'Planned_RTN_WRTN_Date', 'PBG_LC' => 'PBG_LC', 'WON' => 'WON', 'CNAF' => 'CNAF', 'SRN' => 'SRN', 'FOC_VALUE' => 'FOC_VALUE', 'WDS' => 'WDS', 'GST_TDS' => 'GST_TDS', 'TDS' => 'TDS', 'LD' => 'LD', 'Legal' => 'Legal', 'Responsibility' => 'Responsibility' , 'Commissioning' => 'Commissioning');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            }
                        }

                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) > 0) {
                            ///if (1 != 1) {
                            // echo '<pre>';
                            // print_r($result);
                            // die;
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $user_id = $this->ion_auth->get_user_id();
                            // if (!$this->ion_auth->is_admin()) {
                            //     $this->db->delete('user_input', array('month_year' => $this->input->post('month_year'), 'user_id' =>  $user_id));
                            // } else {
                            //     $this->db->delete('user_input', array('month_year' => $this->input->post('month_year'), 'user_id' =>  $user_id));
                            // }
                            $dataInSheet = $this->user_input_upload_validation($dataInSheet, $this->input->post('month_year'));
                            if ($dataInSheet['AO'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }

                    if (empty($erroredRcords)) {
                        if (count($result) == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Consol_Entity = trim($SheetDataKey['Consol_Entity']);
                                $SBU = trim($SheetDataKey['SBU']);
                                $Cluster = trim($SheetDataKey['Cluster']);
                                $Vertical = trim($SheetDataKey['Vertical']);
                                $Country = trim($SheetDataKey['Country']);
                                $AR_Type = trim($SheetDataKey['AR_Type']);
                                $Org_DPST = trim($SheetDataKey['Org_DPST']);
                                $Area = trim($SheetDataKey['Area']);
                                $Region = trim($SheetDataKey['Region']);
                                $Sales_Engg_Name = trim($SheetDataKey['Sales_Engg_Name']);
                                $Customer_Type = trim($SheetDataKey['Customer_Type']);
                                $Child_Code = trim($SheetDataKey['Child_Code']);
                                $Customer_Name = trim($SheetDataKey['Customer_Name']);
                                $Project_Name = trim($SheetDataKey['Project_Name']);
                                $Org_Document_Number = trim($SheetDataKey['Org_Document_Number']);
                                $Invoice_Date = trim($SheetDataKey['Invoice_Date']);
                                $Rev_Due_Date = trim($SheetDataKey['Rev_Due_Date']);
                                $Invoice_Amount = trim($SheetDataKey['Invoice_Amount']);
                                $Paid_Amount = trim($SheetDataKey['Paid_Amount']);
                                $Balance_Amount = trim($SheetDataKey['Balance_Amount']);
                                $Currency = trim($SheetDataKey['Currency']);
                                $Fx_Rate = trim($SheetDataKey['Fx_Rate']);
                                $Planned_Coll_Amount = trim($SheetDataKey['Planned_Coll_Amount']);
                                $Planned_Coll_Date = trim($SheetDataKey['Planned_Coll_Date']);
                                $Retention = trim($SheetDataKey['Retention']);
                                $Retention_Warranty = trim($SheetDataKey['Retention_Warranty']);
                                $Planned_RTN_WRTN_Coll_Amount = trim($SheetDataKey['Planned_RTN_WRTN_Coll_Amount']);
                                $Planned_RTN_WRTN_Date = trim($SheetDataKey['Planned_RTN_WRTN_Date']);
                                $PBG_LC = trim($SheetDataKey['PBG_LC']);
                                $WON = trim($SheetDataKey['WON']);
                                $CNAF = trim($SheetDataKey['CNAF']);
                                $SRN = trim($SheetDataKey['SRN']);
                                $FOC = trim($SheetDataKey['FOC_VALUE']);
                                $WDS = trim($SheetDataKey['WDS']);
                                $GST_TDS = trim($SheetDataKey['GST_TDS']);
                                $TDS = trim($SheetDataKey['TDS']);
                                $LD = trim($SheetDataKey['LD']);
                                $Legal = trim($SheetDataKey['Legal']);
                                $Responsibility = trim($SheetDataKey['Responsibility']);
                                $Commissioning = trim($SheetDataKey['Commissioning']);

                                $Consol_Entity = filter_var(trim($allDataInSheet[$i][$Consol_Entity]), FILTER_SANITIZE_STRING);
                                $SBU = filter_var(trim($allDataInSheet[$i][$SBU]), FILTER_SANITIZE_STRING);
                                $Cluster = filter_var(trim($allDataInSheet[$i][$Cluster]), FILTER_SANITIZE_STRING);
                                $Vertical = filter_var(trim($allDataInSheet[$i][$Vertical]), FILTER_SANITIZE_STRING);
                                $Country = filter_var(trim($allDataInSheet[$i][$Country]), FILTER_SANITIZE_STRING);
                                $AR_Type = filter_var(trim($allDataInSheet[$i][$AR_Type]), FILTER_SANITIZE_STRING);
                                $Org_DPST = filter_var(trim($allDataInSheet[$i][$Org_DPST]), FILTER_SANITIZE_STRING);
                                $Area = filter_var(trim($allDataInSheet[$i][$Area]), FILTER_SANITIZE_STRING);
                                $Region = filter_var(trim($allDataInSheet[$i][$Region]), FILTER_SANITIZE_STRING);
                                $Sales_Engg_Name = filter_var(trim($allDataInSheet[$i][$Sales_Engg_Name]), FILTER_SANITIZE_STRING);
                                $Customer_Type = filter_var(trim($allDataInSheet[$i][$Customer_Type]), FILTER_SANITIZE_STRING);
                                $Child_Code = filter_var(trim($allDataInSheet[$i][$Child_Code]), FILTER_SANITIZE_STRING);
                                $Customer_Name = filter_var(trim($allDataInSheet[$i][$Customer_Name]), FILTER_SANITIZE_STRING);
                                $Project_Name = filter_var(trim($allDataInSheet[$i][$Project_Name]), FILTER_SANITIZE_STRING);
                                $Org_Document_Number = filter_var(trim($allDataInSheet[$i][$Org_Document_Number]), FILTER_SANITIZE_STRING);
                                $Invoice_Date = filter_var(trim($allDataInSheet[$i][$Invoice_Date]), FILTER_SANITIZE_STRING);


                                if ($Invoice_Date != '' && $Invoice_Date != '-' && $Invoice_Date != 'NA' && $Invoice_Date != '1970-01-01') {
                                    $Final_Invoice_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Invoice_Date)));
                                } else {
                                    $Final_Invoice_Date = '0000-00-00';
                                }
                                $Rev_Due_Date = filter_var(trim($allDataInSheet[$i][$Rev_Due_Date]), FILTER_SANITIZE_STRING);

                                if ($Rev_Due_Date != ''  && $Rev_Due_Date != '-' && $Rev_Due_Date != 'NA' && $Rev_Due_Date != '1970-01-01') {
                                    $Final_Rev_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Rev_Due_Date)));
                                } else {
                                    $Final_Rev_Due_Date = '0000-00-00';
                                }

                                $Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Paid_Amount = filter_var(trim($allDataInSheet[$i][$Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Balance_Amount = filter_var(trim($allDataInSheet[$i][$Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Currency = filter_var(trim($allDataInSheet[$i][$Currency]), FILTER_SANITIZE_STRING);
                                $Fx_Rate = filter_var(trim($allDataInSheet[$i][$Fx_Rate]), FILTER_SANITIZE_STRING);
                                $Planned_Coll_Amount = filter_var(trim($allDataInSheet[$i][$Planned_Coll_Amount]), FILTER_SANITIZE_STRING);
                                $Planned_Coll_Date = filter_var(trim($allDataInSheet[$i][$Planned_Coll_Date]), FILTER_SANITIZE_STRING);

                                if ($Planned_Coll_Date != ''  && $Planned_Coll_Date != '-' && $Planned_Coll_Date != 'NA'  && $Planned_Coll_Date != '1970-01-01') {
                                    $Final_Planned_coll_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_Coll_Date)));
                                } else {
                                    $Final_Planned_coll_Date = '0000-00-00';
                                }
                                $Retention = filter_var(trim($allDataInSheet[$i][$Retention]), FILTER_SANITIZE_STRING);
                                $Retention_Warranty = filter_var(trim($allDataInSheet[$i][$Retention_Warranty]), FILTER_SANITIZE_STRING);
                                $Planned_RTN_WRTN_Coll_Amount = filter_var(trim($allDataInSheet[$i][$Planned_RTN_WRTN_Coll_Amount]), FILTER_SANITIZE_STRING);
                                $Planned_RTN_WRTN_Date = filter_var(trim($allDataInSheet[$i][$Planned_RTN_WRTN_Date]), FILTER_SANITIZE_STRING);

                                if ($Planned_RTN_WRTN_Date != ''  && $Planned_RTN_WRTN_Date != '-' && $Planned_RTN_WRTN_Date != 'NA'  && $Planned_RTN_WRTN_Date != '1970-01-01') {
                                    $Final_Planned_RTN_WRTN_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Planned_RTN_WRTN_Date)));
                                } else {
                                    $Final_Planned_RTN_WRTN_Date = '0000-00-00';
                                }
                                $PBG_LC = filter_var(trim($allDataInSheet[$i][$PBG_LC]), FILTER_SANITIZE_STRING);
                                $WON = filter_var(trim($allDataInSheet[$i][$WON]), FILTER_SANITIZE_STRING);
                                $CNAF = filter_var(trim($allDataInSheet[$i][$CNAF]), FILTER_SANITIZE_STRING);
                                $SRN = filter_var(trim($allDataInSheet[$i][$SRN]), FILTER_SANITIZE_STRING);
                                $FOC = filter_var(trim($allDataInSheet[$i][$FOC]), FILTER_SANITIZE_STRING);
                                $WDS = filter_var(trim($allDataInSheet[$i][$WDS]), FILTER_SANITIZE_STRING);
                                $GST_TDS = filter_var(trim($allDataInSheet[$i][$GST_TDS]), FILTER_SANITIZE_STRING);
                                $TDS = filter_var(trim($allDataInSheet[$i][$TDS]), FILTER_SANITIZE_STRING);
                                $LD = filter_var(trim($allDataInSheet[$i][$LD]), FILTER_SANITIZE_STRING);
                                $Legal = filter_var(trim($allDataInSheet[$i][$Legal]), FILTER_SANITIZE_STRING);
                                $Responsibility = filter_var(trim($allDataInSheet[$i][$Responsibility]), FILTER_SANITIZE_STRING);
                                $Commissioning = filter_var(trim($allDataInSheet[$i][$Commissioning]), FILTER_SANITIZE_STRING);
                                $created_on =   date("Y-m-d h:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $month_end_ar_data = $this->db->query("select month_end_ar_process_data.* from  month_end_ar_process_data where month_end_ar_process_data.org_document_number != '' AND month_end_ar_process_data.month_year='" . $this->input->post('month_year') . "' AND month_end_ar_process_data.org_document_number='" . $Org_Document_Number . "'")->result()[0];

                                if (
                                    $month_end_ar_data->planned_coll_amt != $Planned_Coll_Amount || $month_end_ar_data->planned_coll_date  !=   $Final_Planned_coll_Date || $month_end_ar_data->retention  !=  $Retention ||
                                    $month_end_ar_data->warranty_retention != $Retention_Warranty || $month_end_ar_data->planned_rtn_wrtn_coll_amt  != $Planned_RTN_WRTN_Coll_Amount || $month_end_ar_data->planned_rtn_wrtn_date  !=  $Final_Planned_RTN_WRTN_Date ||
                                    $month_end_ar_data->pbg_lc  !=  $PBG_LC || $month_end_ar_data->won  !=  $WON || $month_end_ar_data->cnaf  !=  $CNAF || $month_end_ar_data->srn  !=  $SRN ||
                                    $month_end_ar_data->foc  !=  $FOC || $month_end_ar_data->wds  !=   $WDS || $month_end_ar_data->gst_tds  !=  $GST_TDS || $month_end_ar_data->tds  != $TDS || $month_end_ar_data->ld  !=  $LD || $month_end_ar_data->legal  != $Legal || $month_end_ar_data->responsibility  != $Responsibility || $month_end_ar_data->commissioning  != $Commissioning
                                ) {
                                    if (($Planned_Coll_Amount != NULL && $Planned_Coll_Amount != 0 && $Planned_Coll_Amount != '' && $Planned_Coll_Amount != '-') || ($Planned_Coll_Date != NULL && $Planned_Coll_Date != 0 && $Planned_Coll_Date != '' && $Planned_Coll_Date != '-') || ($Retention != NULL && $Retention != 0 && $Retention != '' && $Retention != '-') || ($Retention_Warranty != NULL && $Retention_Warranty != 0 && $Retention_Warranty != '' && $Retention_Warranty != '-') || ($Planned_RTN_WRTN_Coll_Amount != NULL && $Planned_RTN_WRTN_Coll_Amount != 0 && $Planned_RTN_WRTN_Coll_Amount != '' && $Planned_RTN_WRTN_Coll_Amount != '-') || ($Planned_RTN_WRTN_Date != NULL && $Planned_RTN_WRTN_Date != 0 && $Planned_RTN_WRTN_Date != '' && $Planned_RTN_WRTN_Date != '-') || ($WON != NULL && $WON != 0 && $WON != '' && $WON != '-') || ($CNAF != NULL && $CNAF != 0 && $CNAF != '' && $CNAF != '-') || ($SRN != NULL && $SRN != 0 && $SRN != '' && $SRN != '-') || ($FOC != NULL && $FOC != 0 && $FOC != '' && $FOC != '-') || ($WDS != NULL && $WDS != 0 && $WDS != '' && $WDS != '-') || ($TDS != NULL && $TDS != 0 && $TDS != '' && $TDS != '-') || ($LD != NULL && $LD != 0 && $LD != '' && $LD != '-') || ($Legal != NULL && $Legal != 0 && $Legal != '' && $Legal != '-') || ($PBG_LC != NULL && $PBG_LC != 0 && $PBG_LC != '' && $PBG_LC != '-') || ($GST_TDS != NULL && $GST_TDS != 0 && $GST_TDS != '' && $GST_TDS != '-') || ($Commissioning != NULL && $Commissioning != 0 && $Commissioning != '' && $Commissioning != '-')) {
                                        $fetchData[] = array(
                                            'month_year' =>  $this->input->post('month_year'),
                                            'console_entity' =>  $Consol_Entity,
                                            'sbu' => $SBU,
                                            'cluster' => $Cluster,
                                            'vertical' =>  $Vertical,
                                            'country' => $Country,
                                            'ar_type' => $AR_Type,
                                            'org_dpst' => $Org_DPST,
                                            'area' => $Area,
                                            'region' => $Region,
                                            'sales_engg_name' => $Sales_Engg_Name,
                                            'customer_type' => $Customer_Type,
                                            'child_node' => $Child_Code,
                                            'customer_name' =>  $Customer_Name,
                                            'project_name' => $Project_Name,
                                            'org_document_number' => $Org_Document_Number,
                                            'invoice_date' => $Final_Invoice_Date,
                                            'rev_due_date' => $Final_Rev_Due_Date,
                                            'invoice_amount' => str_replace(',', '', $Invoice_Amount),
                                            'paid_amount' => str_replace(',', '', $Paid_Amount),
                                            'balance_amount' =>  str_replace(',', '', $Balance_Amount),
                                            'currency' =>  $Currency,
                                            'fx_rate' =>  str_replace(',', '', $Fx_Rate),
                                            'planned_coll_amt' => str_replace(',', '', $Planned_Coll_Amount),
                                            'planned_coll_date' => $Final_Planned_coll_Date,
                                            'retention' => str_replace(',', '', $Retention),
                                            'warranty_retention' => str_replace(',', '', $Retention_Warranty),
                                            'planned_rtn_wrtn_coll_amt' => str_replace(',', '', $Planned_RTN_WRTN_Coll_Amount),
                                            'planned_rtn_wrtn_date' => $Final_Planned_RTN_WRTN_Date,
                                            'pbg_lc' => str_replace(',', '', $PBG_LC),
                                            'won' => str_replace(',', '', $WON),
                                            'cnaf' => str_replace(',', '', $CNAF),
                                            'srn' => str_replace(',', '', $SRN),
                                            'foc' => str_replace(',', '', $FOC),
                                            'wds' => str_replace(',', '', $WDS),
                                            'gst_tds' => str_replace(',', '', $GST_TDS),
                                            'tds' => str_replace(',', '', $TDS),
                                            'ld' => str_replace(',', '', $LD),
                                            'legal' => str_replace(',', '', $Legal),
                                            'responsibility' =>  $Responsibility,
                                            'commissioning' =>  str_replace(',', '', $Commissioning),
                                            'sys_created_on' => $created_on,
                                            'user_id' => $user_id
                                        );

                                        $this->db->delete('user_input', array('month_year' => $this->input->post('month_year'), 'user_id' =>  $user_id, 'org_document_number' => $Org_Document_Number));
                                    }
                                }
                            }

                            // echo '<pre>';
                            // print_r($fetchData);
                            // die;

                            if (!empty($fetchData)) {
                                $this->base_model->setBatchImportUploadUserInput($fetchData);
                                if ($this->base_model->importDataUploadUserInput() == 1) {
                                    $msg_success = count($fetchData) . "  Rows of User Input Info Uploaded Successfully.";
                                    $output = array('success'  => true, 'msg_success' => $msg_success);
                                }
                            } else {
                                $msg_success = "User Input Info Uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            }
                        }
                    }

                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('AO2:AO' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AO2:AO' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('AO1:AO' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AO1:AO' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('AO1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {
                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function user_input_upload_validation($dataInSheet, $month)
    {

        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";

        if ($dataInSheet['O'] != "Org_Document_Number") {
            if ($dataInSheet['O'] == NULL) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Field Cannot be empty";
            }


            // if ($dataInSheet['O']) {
            //     $duplicate_doc_num = $this->db->query("select org_document_number from user_input where org_document_number='" . trim($dataInSheet['O']) . "' and month_year='" . $month . "' and user_id='" . $this->ion_auth->get_user_id() . "' ")->row();
            //     if (count($duplicate_doc_num) >= 1) {
            //         $record_status['error'] = 1;
            //         $record_status['error_msg1'] = "Duplicate Document Number";
            //     }
            // }
        }


        //  if ($dataInSheet['O'] != "Org_Document_Number") {

        // $total = (str_replace(',', '', $dataInSheet['AC']) + str_replace(',', '', $dataInSheet['AD']) + str_replace(',', '', $dataInSheet['AC'] ) + str_replace(',', '', $dataInSheet['AE']) + str_replace(',', '', $dataInSheet['AF']) + str_replace(',', '', $dataInSheet['AG']) + str_replace(',', '', $dataInSheet['AI']) + str_replace(',', '', $dataInSheet['AJ']) + str_replace(',', '', $dataInSheet['AK']) + str_replace(',', '', $dataInSheet['AL']) + str_replace(',', '', $dataInSheet['AN'])  + str_replace(',', '', $dataInSheet['Y']) + str_replace(',', '', $dataInSheet['Z']));

        // if($total != str_replace(',', '',$dataInSheet['T'])){
        //      $record_status['error'] = 1;
        //      $record_status['error_msg'] = "Balance Amount should be equal to sum of Retention, Retention_Warranty, PBG_LC, WON, CNAF, SRN, FOC, GST_TDS, TDS, LD, Legal, Commissioning";
        // }

        // }

        // if ($dataInSheet['A'] != "Consol_Entity" || $dataInSheet['B'] != "SBU" || $dataInSheet['C'] != "Cluster" || $dataInSheet['D'] != "Vertical" || $dataInSheet['E'] != "Country" || $dataInSheet['F'] != "AR_Type" || $dataInSheet['K'] != 'Invoice_Date' /* || $dataInSheet['L'] != 'Rev_Due_Date' */ || $dataInSheet['S'] != 'Planned_Coll_Date' || $dataInSheet['W'] != 'Planned_RTN_WRTN_Date') {

        // /* if ($dataInSheet['A'] == NULL || $dataInSheet['B'] == NULL || $dataInSheet['C'] == NULL || $dataInSheet['D'] == NULL || $dataInSheet['E'] == NULL || $dataInSheet['F'] == NULL) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Fields Cannot be empty";
        // } */

        // /*  if ($dataInSheet['A'] && $dataInSheet['A'] != "NA") {
        // $console_status = $this->db->query("select u.*from console_master as u where u.console_name='" . $dataInSheet['A'] . "'")->result();
        // if (count($console_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Console does not exits";
        // }
        // }

        // if ($dataInSheet['B']  && $dataInSheet['B'] != "NA") {
        // $sbu_status = $this->db->query("select u.*from sbu_master as u where u.sbu_name='" . $dataInSheet['B'] . "'")->result();
        // if (count($sbu_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "SBU does not exits";
        // }
        // }

        // if ($dataInSheet['C']  && $dataInSheet['C'] != "NA") {
        // $cluster_status = $this->db->query("select u.*from cluster_master as u where u.cluster_name='" . $dataInSheet['C'] . "'")->result();
        // if (count($cluster_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Cluster does not exits";
        // }
        // }  */

        // if ($dataInSheet['D']  && $dataInSheet['D'] != "NA" && $dataInSheet['D'] != "0") {

        // /* $vertical_status = $this->db->query("select u.*from vertical_master as u where u.vertical_name='" . $dataInSheet['D'] . "'")->result();

        // if (count($vertical_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Vertical does not exits";
        // } */


        // if (!($this->ion_auth->is_admin())) {
        // $vertical_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
        // $array_verticals_ids = explode(',', $vertical_id);
        // $array_vertical_names = array();
        // foreach ($array_verticals_ids as $ver) {
        // $array_vertical_names[] = trim(get_vertical_name($ver));
        // }

        // if (!(in_array($dataInSheet['D'], $array_vertical_names))) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "This vertical not assigned for this user";
        // }
        // }
        // }

        // /*  if ($dataInSheet['E']  && $dataInSheet['E'] != "NA") {
        // $country_status = $this->db->query("select u.*from country_master as u where u.country_name='" . $dataInSheet['E'] . "'")->result();
        // if (count($country_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Country does not exits";
        // }
        // } 


        // if ($dataInSheet['F']  && $dataInSheet['F'] != "NA") {
        // $artype_status = $this->db->query("select u.*from month_end_ar_process_data as u where u.ar_type='" . $dataInSheet['F'] . "'")->result();
        // if (count($artype_status) <= 0) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "AR Type does not exits";
        // }
        // } */

        // if ($dataInSheet['K'] != '' && $dataInSheet['K'] != 'NA' && $dataInSheet['K'] != '0') {
        // if (!check_format_date_user_input($dataInSheet['K'])) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Check Invoice Date Format";
        // } 
        // }

        // /*  if ($dataInSheet['L'] != '' && $dataInSheet['L'] != 'NA') {
        // if (!check_format_date_user_input($dataInSheet['L'])) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Check Rev Due Date Format";
        // }
        // } */

        // if ($dataInSheet['S'] != '' && $dataInSheet['S'] != 'NA' && $dataInSheet['S'] != '0') {
        // if (!check_format_date_user_input($dataInSheet['S'])) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Check Planned_Coll_Date Format";
        // }
        // }
        // if ($dataInSheet['W'] != '' && $dataInSheet['W'] != 'NA' && $dataInSheet['W'] != '0') {
        // if (!check_format_date_user_input($dataInSheet['W'])) {
        // $record_status['error'] = 1;
        // $record_status['error_msg'] = "Check Planned_RTN_WRTN_Date Format";
        // }
        // }
        // }

        if ($record_status['error'] == 1) {
            $dataInSheet['AO'] = $record_status['error_msg'] . '|' . $record_status['error_msg1'];
        }
        return $dataInSheet;

    }

    public function upload_daily_collection_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }


        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_daily_collection_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_daily_collection_upload', $this->data);
    }

    public function import_export_user_input($param1 = '', $param2 = '')
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/import_export_user_input');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/import_export_user_input', $this->data);
    }



    /*bulk upload*/
    /* Kiran */
    public function upload_daily_coll_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['upload_daily_coll_list_file']['name'] != '') {
            if ($_FILES['upload_daily_coll_list_file']['name']) {
                $f_type                             = explode(".", $_FILES['upload_daily_coll_list_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['upload_daily_coll_list_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    //echo "<pre>";
                    //print_r($allDataInSheet);die;  
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Consol', 'DPST_Code', 'DPST_Name', 'Zone', 'Area_Code', 'Area_Name', 'Customer_Number', 'Customer_Name', 'Company', 'Transaction_Type', 'Invoice_Number', 'Original_Document_Number', 'Due_Date', 'Document_Date', 'Received_Document_Type', 'Received_Document_Number', 'Org_Company', 'Org_Doc_Type', 'Collection', 'Advance');
                    $makeArray = array('Consol' => 'Consol', 'DPST_Code' => 'DPST_Code', 'DPST_Name' => 'DPST_Name', 'Zone' => 'Zone', 'Area_Code' => 'Area_Code', 'Area_Name' => 'Area_Name', 'Customer_Number' => 'Customer_Number', 'Customer_Name' => 'Customer_Name', 'Company' => 'Company', 'Transaction_Type' => 'Transaction_Type', 'Invoice_Number' => 'Invoice_Number', 'Original_Document_Number' => 'Original_Document_Number', 'Due_Date' => 'Due_Date', 'Document_Date' => 'Document_Date', 'Received_Document_Type' => 'Received_Document_Type', 'Received_Document_Number' => 'Received_Document_Number', 'Org_Company' => 'Org_Company', 'Org_Doc_Type' => 'Org_Doc_Type', 'Collection' => 'Collection', 'Advance' => 'Advance');
                    $SheetDataKey = array();


                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            }
                        }

                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->daily_collection_validation($dataInSheet);
                            if ($dataInSheet['V'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                                //continue;
                                //print_r($erroredRcords);  
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Consol = $SheetDataKey['Consol'];
                                $DPST_Code = $SheetDataKey['DPST_Code'];
                                $DPST_Name = $SheetDataKey['DPST_Name'];
                                $Zone = $SheetDataKey['Zone'];
                                $Area_Code = $SheetDataKey['Area_Code'];
                                $Area_Name = $SheetDataKey['Area_Name'];
                                $Customer_Number = $SheetDataKey['Customer_Number'];
                                $Customer_Name = $SheetDataKey['Customer_Name'];
                                $Company = $SheetDataKey['Company'];
                                $Transaction_Type = $SheetDataKey['Transaction_Type'];
                                $Invoice_Number = $SheetDataKey['Invoice_Number'];
                                $Original_Document_Number = $SheetDataKey['Original_Document_Number'];
                                $Due_Date = $SheetDataKey['Due_Date'];
                                $Document_Date = $SheetDataKey['Document_Date'];
                                $Received_Document_Type = $SheetDataKey['Received_Document_Type'];
                                $Received_Document_Number = $SheetDataKey['Received_Document_Number'];
                                $Org_Company = $SheetDataKey['Org_Company'];
                                $Org_Doc_Type = $SheetDataKey['Org_Doc_Type'];
                                //$Org_Doc_Number = $SheetDataKey['Org_Doc_Number'];
                                $Collection = $SheetDataKey['Collection'];
                                $Advance = $SheetDataKey['Advance'];

                                $Consol = filter_var(trim($allDataInSheet[$i][$Consol]), FILTER_SANITIZE_STRING);
                                $DPST_Code = filter_var(trim($allDataInSheet[$i][$DPST_Code]), FILTER_SANITIZE_STRING);
                                $DPST_Name = filter_var(trim($allDataInSheet[$i][$DPST_Name]), FILTER_SANITIZE_STRING);
                                $Zone = filter_var(trim($allDataInSheet[$i][$Zone]), FILTER_SANITIZE_STRING);
                                $Area_Code = filter_var(trim($allDataInSheet[$i][$Area_Code]), FILTER_SANITIZE_STRING);
                                $Area_Name = filter_var(trim($allDataInSheet[$i][$Area_Name]), FILTER_SANITIZE_STRING);
                                $Customer_Number = filter_var(trim($allDataInSheet[$i][$Customer_Number]), FILTER_SANITIZE_STRING);
                                $Customer_Name = filter_var(trim($allDataInSheet[$i][$Customer_Name]), FILTER_SANITIZE_STRING);
                                $Company = filter_var(trim($allDataInSheet[$i][$Company]), FILTER_SANITIZE_STRING);
                                $Transaction_Type = filter_var(trim($allDataInSheet[$i][$Transaction_Type]), FILTER_SANITIZE_STRING);
                                $Invoice_Number = filter_var(trim($allDataInSheet[$i][$Invoice_Number]), FILTER_SANITIZE_STRING);
                                $Original_Document_Number = filter_var(trim($allDataInSheet[$i][$Original_Document_Number]), FILTER_SANITIZE_STRING);
                                $Due_Date = filter_var(trim($allDataInSheet[$i][$Due_Date]), FILTER_SANITIZE_STRING);
                                if ($Due_Date != '' && $Due_Date != '-' && $Due_Date != 'NA' && $Due_Date != '1970-01-01') {
                                    $Final_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Due_Date)));
                                } else {
                                    $Final_Due_Date = '0000-00-00';
                                }
                                $Document_Date = filter_var(trim($allDataInSheet[$i][$Document_Date]), FILTER_SANITIZE_STRING);
                                if ($Document_Date != ''  && $Document_Date != '-' && $Document_Date != 'NA' && $Document_Date != '1970-01-01') {
                                    $Final_Document_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Document_Date)));
                                } else {
                                    $Final_Document_Date = '0000-00-00';
                                }
                                $Received_Document_Type = filter_var(trim($allDataInSheet[$i][$Received_Document_Type]), FILTER_SANITIZE_STRING);
                                $Received_Document_Number = filter_var(trim($allDataInSheet[$i][$Received_Document_Number]), FILTER_SANITIZE_STRING);
                                $Org_Company = filter_var(trim($allDataInSheet[$i][$Org_Company]), FILTER_SANITIZE_STRING);
                                $Org_Doc_Type = filter_var(trim($allDataInSheet[$i][$Org_Doc_Type]), FILTER_SANITIZE_STRING);
                                //$Org_Doc_Number = filter_var(trim($allDataInSheet[$i][$Org_Doc_Number]), FILTER_SANITIZE_STRING);
                                $Collection = filter_var(trim($allDataInSheet[$i][$Collection]), FILTER_SANITIZE_STRING);
                                $Advance = filter_var(trim($allDataInSheet[$i][$Advance]), FILTER_SANITIZE_STRING);
                                $user_id =  $this->ion_auth->get_user_id();
                                $created_on =   date("Y-m-d h:i:s");
                                $uploaded_on =  date("Y-m-d");
                                $fetchData[] = array(
                                    'month_year' => $this->input->post('month_year'),
                                    'uploaded_on' => $uploaded_on,
                                    'consol' =>  $Consol,
                                    'vertical' =>  get_vertical_name(get_ar_type($DPST_Code)->vertical_id),
                                    'sbu' =>  get_sbu_name(get_vertical_entity_mapping(get_ar_type($DPST_Code)->vertical_id)->sbu_id),
                                    'cluster' => get_cluster_name(get_vertical_entity_mapping(get_ar_type($DPST_Code)->vertical_id)->cluster_id),
                                    // 'country' => get_country_name(get_area_country($DPST_Code)->country_id),
                                    'dpst_code' => $DPST_Code,
                                    'dpst_name' => $DPST_Name,
                                    'zone' =>  $Zone,
                                    'area_code' => $Area_Code,
                                    'area_name' => $Area_Name,
                                    'customer_number' =>  $Customer_Number,
                                    'customer_name' => $Customer_Name,
                                    'company' => $Company,
                                    'transaction_type' => $Transaction_Type,
                                    'invoice_number' => $Invoice_Number,
                                    'original_doc_number' =>  $Original_Document_Number,
                                    'due_date' =>   $Final_Due_Date,
                                    'document_date' =>    $Final_Document_Date,
                                    'recv_doc_type' =>  $Received_Document_Type,
                                    'recv_doc_no' => $Received_Document_Number,
                                    'org_company' => $Org_Company,
                                    'org_doc_type' => $Org_Doc_Type,
                                    //'org_doc_number' => $Org_Doc_Number,
                                    'collection' => str_replace(',', '', $Collection),
                                    'adavance' => str_replace(',', '', $Advance),
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }


                            $this->db->delete('daily_collection', array('month_year' => $this->input->post('month_year')));
                            $this->base_model->setBatchImportUploadDailyColl($fetchData);
                            if ($this->base_model->importDataUploadDailyColl() == 1) {
                                /* $this->session->set_flashdata('succes', '' . count($fetchData) . ' rows of vertical info uploaded Successfully.'); */
                                $msg_success = count($fetchData) . " rows of daily collection info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);


                                // // Insert process_pending_list Data 

                                // $process_data_list = $this->db->get_where('process_pending_list', array('report_name' => 'daily_collection_upload', 'month' => $this->input->post('month_year'), 'status' => 1))->result();

                                // $data_array = array(
                                //     'report_name' => "daily_collection_upload",
                                //     'month' => $this->input->post('month_year'),
                                //     'status' => 0
                                // );

                                // if (count($process_data_list) > 0) {

                                //     $this->db->where('report_name', 'daily_collection_upload');
                                //     $this->db->where('month', $this->input->post('month_year'));
                                //     $this->db->update('process_pending_list', array('status' => 0));
                                // } else {

                                //     $this->db->insert('process_pending_list', $data_array);
                                // }

                                /* Update month end ar  */
                                // $this->db->where('month_year', $this->input->post('month_year'));
                                // $this->db->update('month_end_ar_list', array('process_data' => 0));
                                /* Update current ar  */
                                /*  $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('daily_ar', array('process_data' => 0)); */

                                //redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                            } else {
                                echo 'no';
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('V2:V' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('V2:V' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('V1:V' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('V1:V' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('V1')->setValue('Remarks');

                        //echo "<pre>";
                        //print_r($erroredRcords);die;

                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        //$this->session->set_flashdata('unsucces', $msg);

                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);

                        // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function daily_collection_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";
        $record_status['error_msg1'] = "";


        if ($dataInSheet['M'] != 'Due_Date' || $dataInSheet['N'] != 'Document_Date' || $dataInSheet['B'] != 'DPST_Code') {

            if (!empty($dataInSheet['B'] != '') && $dataInSheet['B'] == '0' && $dataInSheet['B'] == null) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "DPST Code must be required!";
                if ($record_status['error_msg'] != '') {
                    $B = '|';
                }
            }

            if (!check_format_date($dataInSheet['M']) && $dataInSheet['M'] != '' && $dataInSheet['M'] != null && $dataInSheet['M'] != 0 && $dataInSheet['M'] != 'NA' && $dataInSheet['M'] != '-') {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Check Due_Date Format";
                if ($record_status['error_msg'] != '') {
                    $M = '|';
                }
            }
            if (!check_format_date($dataInSheet['N']) && $dataInSheet['N'] != '' && $dataInSheet['N'] != null && $dataInSheet['N'] != 0 && $dataInSheet['N'] != 'NA' && $dataInSheet['N'] != '-') {
                $record_status['error'] = 1;
                $record_status['error_msg1'] = "Check Document_Date Format";
                if ($record_status['error_msg1'] != '') {
                    $N = '|';
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['V'] = $M . $record_status['error_msg'] .  $N . $record_status['error_msg1'] .  $B . $record_status['error_msg1'];
        }

        return $dataInSheet;
    }
    public function upload_daily_ar_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_daily_ar_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_daily_ar_upload', $this->data);
    }


    /*bulk upload*/
    /* Kiran */
    public function upload_daily_ar_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['upload_daily_ar_file']['name'] != '') {
            if ($_FILES['upload_daily_ar_file']['name']) {
                $f_type                             = explode(".", $_FILES['upload_daily_ar_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['upload_daily_ar_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                   
                    
                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Consol', 'Area', 'Region', 'Org_DPST', 'Org_TT', 'DPST', 'Month', 'Sales_Engg_Code', 'Sales_Engg_Name', 'Customer_Group', 'Parent_Code', 'Child_Code', 'Customer_Name', 'Project_Name', 'PO_Number', 'PO_Credit_Term', 'Company', 'Transaction_Type', 'Invoice_Number', 'Org_Document_Number', 'Document_Number', 'Dispatch_Date', 'Invoice_Date', 'Credit_Days', 'Due_Date', 'Credit_Days_Adj', 'Rev_Due_Date', 'Invoice_Amount', 'Paid_Amount', 'Balance_Amount',  'Currency', 'Fx_Rate', 'Fx_Invoice_Amount', 'Fx_Paid_Amount', 'Fx_Balance_Amount',  'Customer_Type', 'ECL_Category', 'ECL_RTN_Days', 'FEMA_Days');
                    $makeArray = array('Consol' => 'Consol', 'Area' => 'Area', 'Region' => 'Region', 'Org_DPST' => 'Org_DPST', 'Org_TT' => 'Org_TT', 'DPST' => 'DPST', 'Month' => 'Month', 'Sales_Engg_Code' => 'Sales_Engg_Code', 'Sales_Engg_Name' => 'Sales_Engg_Name', 'Customer_Group' => 'Customer_Group', 'Parent_Code' => 'Parent_Code', 'Child_Code' => 'Child_Code', 'Customer_Name' => 'Customer_Name', 'Project_Name' => 'Project_Name', 'PO_Number' => 'PO_Number', 'PO_Credit_Term' => 'PO_Credit_Term', 'Company' => 'Company', 'Transaction_Type' => 'Transaction_Type', 'Invoice_Number' => 'Invoice_Number', 'Org_Document_Number' => 'Org_Document_Number', 'Document_Number' => 'Document_Number', 'Dispatch_Date' => 'Dispatch_Date', 'Invoice_Date' => 'Invoice_Date', 'Credit_Days' => 'Credit_Days', 'Due_Date' => 'Due_Date', 'Credit_Days_Adj' => 'Credit_Days_Adj', 'Rev_Due_Date' => 'Rev_Due_Date', 'Invoice_Amount' => 'Invoice_Amount', 'Paid_Amount' => 'Paid_Amount', 'Balance_Amount' => 'Balance_Amount', 'Currency' => 'Currency', 'Fx_Rate' => 'Fx_Rate', 'Fx_Invoice_Amount' => 'Fx_Invoice_Amount', 'Fx_Paid_Amount' => 'Fx_Paid_Amount', 'Fx_Balance_Amount' => 'Fx_Balance_Amount', 'Customer_Type' => 'Customer_Type', 'ECL_Category' => 'ECL_Category', 'ECL_RTN_Days' => 'ECL_RTN_Days', 'FEMA_Days' => 'FEMA_Days');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }

                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->month_end_ar_validation($dataInSheet);
                            if ($dataInSheet['AN'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                                //continue;
                                //print_r($erroredRcords);
                            }
                        }
                    }

                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Area = $SheetDataKey['Area'];
                                $Region = $SheetDataKey['Region'];
                                $DPST = $SheetDataKey['DPST'];
                                $Month = $SheetDataKey['Month'];
                                $Sales_Engg_Code = $SheetDataKey['Sales_Engg_Code'];
                                $Sales_Engg_Name = $SheetDataKey['Sales_Engg_Name'];
                                $Customer_Group = $SheetDataKey['Customer_Group'];
                                $Parent_Code = $SheetDataKey['Parent_Code'];
                                $Child_Code = $SheetDataKey['Child_Code'];
                                $Customer_Name = $SheetDataKey['Customer_Name'];
                                $Project_Name = $SheetDataKey['Project_Name'];
                                $PO_Number = $SheetDataKey['PO_Number'];
                                $PO_Credit_Term = $SheetDataKey['PO_Credit_Term'];
                                $Company = $SheetDataKey['Company'];
                                $Transaction_Type = $SheetDataKey['Transaction_Type'];
                                $Invoice_Number = $SheetDataKey['Invoice_Number'];
                                $Org_Document_Number = $SheetDataKey['Org_Document_Number'];
                                $Document_Number = $SheetDataKey['Document_Number'];
                                $Dispatch_Date = $SheetDataKey['Dispatch_Date'];
                                $Invoice_Date = $SheetDataKey['Invoice_Date'];
                                $Credit_Days = $SheetDataKey['Credit_Days'];
                                $Due_Date = $SheetDataKey['Due_Date'];
                                $Credit_Days_Adj = $SheetDataKey['Credit_Days_Adj'];
                                $Rev_Due_Date = $SheetDataKey['Rev_Due_Date'];
                                $Invoice_Amount = $SheetDataKey['Invoice_Amount'];
                                $Paid_Amount = $SheetDataKey['Paid_Amount'];
                                $Balance_Amount = $SheetDataKey['Balance_Amount'];
                                $Currency = $SheetDataKey['Currency'];
                                $Fx_Rate = $SheetDataKey['Fx_Rate'];
                                $Fx_Invoice_Amount = $SheetDataKey['Fx_Invoice_Amount'];
                                $Fx_Paid_Amount = $SheetDataKey['Fx_Paid_Amount'];
                                $Fx_Balance_Amount = $SheetDataKey['Fx_Balance_Amount'];
                                $Customer_Type = $SheetDataKey['Customer_Type'];
                                $ECL_Category = $SheetDataKey['ECL_Category'];
                                $ECL_RTN_Days = $SheetDataKey['ECL_RTN_Days'];
                                $FEMA_Days = $SheetDataKey['FEMA_Days'];
                                $Consol = $SheetDataKey['Consol'];
                                $Org_DPST = $SheetDataKey['Org_DPST'];
                                $Org_TT = $SheetDataKey['Org_TT'];

                                $Area = filter_var(trim($allDataInSheet[$i][$Area]), FILTER_SANITIZE_STRING);
                                $Region = filter_var(trim($allDataInSheet[$i][$Region]), FILTER_SANITIZE_STRING);
                                $DPST = filter_var(trim($allDataInSheet[$i][$DPST]), FILTER_SANITIZE_STRING);
                                $Month = filter_var(trim($allDataInSheet[$i][$Month]), FILTER_SANITIZE_STRING);
                                $Sales_Engg_Code = filter_var(trim($allDataInSheet[$i][$Sales_Engg_Code]), FILTER_SANITIZE_STRING);
                                $Sales_Engg_Name = filter_var(trim($allDataInSheet[$i][$Sales_Engg_Name]), FILTER_SANITIZE_STRING);
                                $Customer_Group = filter_var(trim($allDataInSheet[$i][$Customer_Group]), FILTER_SANITIZE_STRING);
                                $Parent_Code = filter_var(trim($allDataInSheet[$i][$Parent_Code]), FILTER_SANITIZE_STRING);
                                $Child_Code = filter_var(trim($allDataInSheet[$i][$Child_Code]), FILTER_SANITIZE_STRING);
                                $Customer_Name = filter_var(trim($allDataInSheet[$i][$Customer_Name]), FILTER_SANITIZE_STRING);
                                $Project_Name = filter_var(trim($allDataInSheet[$i][$Project_Name]), FILTER_SANITIZE_STRING);
                                $PO_Number = filter_var(trim($allDataInSheet[$i][$PO_Number]), FILTER_SANITIZE_STRING);
                                $PO_Credit_Term = filter_var(trim($allDataInSheet[$i][$PO_Credit_Term]), FILTER_SANITIZE_STRING);
                                $Company = filter_var(trim($allDataInSheet[$i][$Company]), FILTER_SANITIZE_STRING);
                                $Transaction_Type = filter_var(trim($allDataInSheet[$i][$Transaction_Type]), FILTER_SANITIZE_STRING);
                                $Invoice_Number = filter_var(trim($allDataInSheet[$i][$Invoice_Number]), FILTER_SANITIZE_STRING);
                                $Org_Document_Number = filter_var(trim($allDataInSheet[$i][$Org_Document_Number]), FILTER_SANITIZE_STRING);
                                $Document_Number = filter_var(trim($allDataInSheet[$i][$Document_Number]), FILTER_SANITIZE_STRING);

                                if ($Dispatch_Date != '' && $Dispatch_Date != '-' && $Dispatch_Date != 'NA' && $Dispatch_Date != '1970-01-01') {
                                    $Final_Dispatch_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Dispatch_Date)));
                                } else {
                                    $Final_Dispatch_Date = '0000-00-00';
                                }

                                $Invoice_Date = filter_var(trim($allDataInSheet[$i][$Invoice_Date]), FILTER_SANITIZE_STRING);
                                if ($Invoice_Date != '' && $Invoice_Date != '-' && $Invoice_Date != 'NA' && $Invoice_Date != '1970-01-01') {
                                    $Final_Invoice_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Invoice_Date)));
                                } else {
                                    $Final_Invoice_Date = '0000-00-00';
                                }
                                $Credit_Days = filter_var(trim($allDataInSheet[$i][$Credit_Days]), FILTER_SANITIZE_STRING);

                                $Due_Date = filter_var(trim($allDataInSheet[$i][$Due_Date]), FILTER_SANITIZE_STRING);
                                if ($Due_Date != '' && $Due_Date != '-' && $Due_Date != 'NA' && $Due_Date != '1970-01-01') {
                                    $Final_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Due_Date)));
                                } else {
                                    $Final_Due_Date = '0000-00-00';
                                }
                                $Credit_Days_Adj = filter_var(trim($allDataInSheet[$i][$Credit_Days_Adj]), FILTER_SANITIZE_STRING);
                                $Rev_Due_Date = filter_var(trim($allDataInSheet[$i][$Rev_Due_Date]), FILTER_SANITIZE_STRING);

                                if ($Rev_Due_Date != ''  && $Rev_Due_Date != '-' && $Rev_Due_Date != 'NA' && $Rev_Due_Date != '1970-01-01') {
                                    $Final_Rev_Due_Date =  date('Y-m-d', strtotime(str_replace('/', '-', $Rev_Due_Date)));
                                } else {
                                    $Final_Rev_Due_Date = '0000-00-00';
                                }


                                $Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Paid_Amount = filter_var(trim($allDataInSheet[$i][$Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Balance_Amount = filter_var(trim($allDataInSheet[$i][$Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Currency = filter_var(trim($allDataInSheet[$i][$Currency]), FILTER_SANITIZE_STRING);
                                $Fx_Rate = filter_var(trim($allDataInSheet[$i][$Fx_Rate]), FILTER_SANITIZE_STRING);
                                $Fx_Invoice_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Invoice_Amount]), FILTER_SANITIZE_STRING);
                                $Fx_Paid_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Paid_Amount]), FILTER_SANITIZE_STRING);
                                $Fx_Balance_Amount = filter_var(trim($allDataInSheet[$i][$Fx_Balance_Amount]), FILTER_SANITIZE_STRING);
                                $Customer_Type = filter_var(trim($allDataInSheet[$i][$Customer_Type]), FILTER_SANITIZE_STRING);
                                $ECL_Category = filter_var(trim($allDataInSheet[$i][$ECL_Category]), FILTER_SANITIZE_STRING);
                                $ECL_RTN_Days = filter_var(trim($allDataInSheet[$i][$ECL_RTN_Days]), FILTER_SANITIZE_STRING);
                                $FEMA_Days = filter_var(trim($allDataInSheet[$i][$FEMA_Days]), FILTER_SANITIZE_STRING);
                                $Consol = filter_var(trim($allDataInSheet[$i][$Consol]), FILTER_SANITIZE_STRING);
                                $Org_DPST = filter_var(trim($allDataInSheet[$i][$Org_DPST]), FILTER_SANITIZE_STRING);
                                $Org_TT = filter_var(trim($allDataInSheet[$i][$Org_TT]), FILTER_SANITIZE_STRING);
                                $created_on =  date("Y-m-d H:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $fetchData[] = array(
                                    'month_year' => $this->input->post('month_year'),
                                    'uploaded_on' => date("Y-m-d"),
                                    'area' =>  $Area,
                                    'region' => $Region,
                                    'dpst' => $DPST,
                                    'month' =>  date('Y-m-d', strtotime(str_replace("/", "-", $Month))),
                                    'sales_engg_code' => $Sales_Engg_Code,
                                    'sales_engg_name' => $Sales_Engg_Name,
                                    'customer_group' =>  $Customer_Group,
                                    'parent_code' => $Parent_Code,
                                    'child_code' => $Child_Code,
                                    'customer_name' =>  $Customer_Name,
                                    'project_name' => $Project_Name,
                                    'po_name' => $PO_Number,
                                    'po_credit_term' =>  $PO_Credit_Term,
                                    'company' => $Company,
                                    'transaction_type' => $Transaction_Type,
                                    'invoice_number' =>  $Invoice_Number,
                                    'org_document_number' => $Org_Document_Number,
                                    'document_number' => $Document_Number,
                                    'dispatch_date' =>  $Final_Dispatch_Date,
                                    'invoice_date' => $Final_Invoice_Date,
                                    'credit_days' => $Credit_Days,
                                    'due_date' =>  $Final_Due_Date,
                                    'credit_days_adj' => $Credit_Days_Adj,
                                    'rev_due_date' => $Final_Rev_Due_Date,
                                    'invoice_amount' => str_replace(',', '', $Invoice_Amount),
                                    'paid_amount' => str_replace(',', '', $Paid_Amount),
                                    'balance_amount' => str_replace(',', '', $Balance_Amount),
                                    'currency' =>  $Currency,
                                    'fx_rate' => str_replace(',', '', $Fx_Rate),
                                    'fx_invoice_amount' => str_replace(',', '', $Fx_Invoice_Amount),
                                    'fx_paid_amount' => str_replace(',', '', $Fx_Paid_Amount),
                                    'fx_balance_amount' => str_replace(',', '', $Fx_Balance_Amount),
                                    'customer_type' => $Customer_Type,
                                    'ecl_category' =>  $ECL_Category,
                                    'ecl_days' => $ECL_RTN_Days,
                                    'fema_days' => $FEMA_Days,
                                    'consol' => $Consol,
                                    'org_dpst' => $Org_DPST,
                                    'org_tt' =>  $Org_TT,
                                    'sys_created_on' => $created_on,
                                    'user_id' => $user_id
                                );
                            }

                            //$this->db->delete('daily_ar', array('month_year' => $this->input->post('month_year')));
                            $this->db->empty_table('daily_ar');
                            $this->base_model->setBatchImportUploadDailyAR($fetchData);
                            if ($this->base_model->importDataUploadDailyAR() == 1) {
                                $msg_success = count($fetchData) . " Rows of Current AR Uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                                // $process_data_list = $this->db->get_where('process_pending_list', array('report_name' => 'daily_ar_upload', 'month' => $this->input->post('month_year'), 'status' => 1))->result();

                                // $data_array = array(
                                //     'report_name' => "daily_ar_upload",
                                //     'month' => $this->input->post('month_year'),
                                //     'status' => 0
                                // );

                                // if (count($process_data_list) > 0) {

                                //     $this->db->where('report_name', 'daily_ar_upload');
                                //     $this->db->where('month', $this->input->post('month_year'));
                                //     $this->db->update('process_pending_list', array('status' => 0));
                                // } else {

                                //     $this->db->insert('process_pending_list', $data_array);
                                // }

                                /* Update month end ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('month_end_ar_list', array('process_data' => 0));
                                /* Update current ar  */
                                $this->db->where('month_year', $this->input->post('month_year'));
                                $this->db->update('daily_ar', array('process_data' => 0));
                            } else {
                                echo "no";
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('AN2:AN' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AN2:AN' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getStyle('AN1:AN' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('AN1:AN' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('AN1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;

                        //}
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        //$this->session->set_flashdata('unsucces', $msg);

                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);

                        // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    }
                }
            }
        }

        echo json_encode($output);
    }


    public function upload_daily_ar_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }
        // POST data
        $postData = $this->input->post();
        // Get data
        $data = $this->Ajax_model->upload_daily_ar_ajaxdata($postData);
        echo json_encode($data);
    }


    public function upload_daily_collection_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }
        // POST data
        $postData = $this->input->post();
        // Get data
        $data = $this->Ajax_model->upload_daily_collection_ajaxdata($postData);
        echo json_encode($data);
    }


    public function user_input_check()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $month_year = $this->input->post('month_year');

        // $val = base_url('upload/user_input_excels/AR-'.$month_year .'.xlsx');

        $val = $_SERVER['DOCUMENT_ROOT'] . '/upload/user_input_excels/AR-' . $month_year . '.xlsx';

        if (file_exists($val)) {
            echo json_encode(1);
        } else {
            echo json_encode(0);
        }
    }

    public function user_input_excel_download()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        //--------------- Excel Export ---------------------------//

        if (!$this->ion_auth->is_admin()) {
            $vertical_id = getUserInfo($this->ion_auth->get_user_id())->vertical_id;
            $month_year = date('m-Y', strtotime('-1 months', strtotime(date('Y-m'))));
        } else {
            $vertical_id = '';
            $month_year = $this->input->post('month_year');
        }

        $list = $this->base_model->getMonthEndReportListForExcelMapping($month_year, $vertical_id);

        if (empty($list)) {

            $this->session->set_flashdata('unsucces', 'No Data Available in this vertical');
            redirect('admin/resources/import_export_user_input', 'refresh');
        } else {

            //load PHPExcel library
            $this->load->library('Excel');
            ob_start();
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
            $styleArray = array(
                'font' => array(
                    'size' => 13,
                    'name' => 'Roboto'
                )
            );
            $fontArray = array(
                'font' => array(
                    'bold' => true,
                    'size' => 11,
                    'name' => 'Roboto'
                )
            );
            $dateArray = array(
                'font' => array(
                    'bold' => true,
                )
            );
            $bgcolor = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'E7E7E7'),
                )
            );

            $bgcolorblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '66bfff'),
                )
            );

            $bgblue = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ff0000'),
                )
            );

            $bgbrr = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '82b7da'),
                )
            );



            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
                ->setLastModifiedBy("Comprehensive School Management")
                ->setTitle("Office  XLSX Test Document")
                ->setSubject("Office XLSX Test Document")
                ->setDescription("Test document for Office XLSX, generated by PHP classes.")
                ->setKeywords("office openxml php")
                ->setCategory("Excel Sheet");


            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(20);

            $objPHPExcel->getActiveSheet(0)->getStyle('A1:AG1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


            $objPHPExcel->getActiveSheet()
                ->getStyle('A')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('B')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('C')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('D')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('E')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('F')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('K')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()
                ->getStyle('L')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            $objPHPExcel->getActiveSheet()
                ->getStyle('H')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('I')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('M')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('N')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('O')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('P')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

            $objPHPExcel->getActiveSheet()
                ->getStyle('Q')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


            // Add some data

            $objPHPExcel->getActiveSheet()->getStyle('A1:AG1')->applyFromArray($bgcolorblue);



            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'Consol_Entity');
            $objPHPExcel->getActiveSheet()->setCellValue('B1', 'SBU');
            $objPHPExcel->getActiveSheet()->setCellValue('C1', 'Cluster');
            $objPHPExcel->getActiveSheet()->setCellValue('D1', 'Vertical');
            $objPHPExcel->getActiveSheet()->setCellValue('E1', 'Country');
            $objPHPExcel->getActiveSheet()->setCellValue('F1', 'AR_Type');
            $objPHPExcel->getActiveSheet()->setCellValue('G1', 'Child_Code');
            $objPHPExcel->getActiveSheet()->setCellValue('H1', 'Customer_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('I1', 'Project_Name');
            $objPHPExcel->getActiveSheet()->setCellValue('J1', 'Org_Document_Number');
            $objPHPExcel->getActiveSheet()->setCellValue('K1', 'Invoice_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('L1', 'Rev_Due_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('M1', 'Invoice_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('N1', 'Paid_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('O1', 'Balance_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('P1', 'Currency');
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Fx_Rate');
            $objPHPExcel->getActiveSheet()->setCellValue('R1', 'Planned_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('S1', 'Planned_Coll_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('T1', 'Retention');
            $objPHPExcel->getActiveSheet()->setCellValue('U1', 'Retention_Warranty');
            $objPHPExcel->getActiveSheet()->setCellValue('V1', 'Planned_RTN_WRTN_Coll_Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('W1', 'Planned_RTN_WRTN_Date');
            $objPHPExcel->getActiveSheet()->setCellValue('X1', 'PBG_LC');
            $objPHPExcel->getActiveSheet()->setCellValue('Y1', 'WON');
            $objPHPExcel->getActiveSheet()->setCellValue('Z1', 'CNAF');
            $objPHPExcel->getActiveSheet()->setCellValue('AA1', 'SRN');
            $objPHPExcel->getActiveSheet()->setCellValue('AB1', 'FOC');
            $objPHPExcel->getActiveSheet()->setCellValue('AC1', 'WDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AD1', 'TDS');
            $objPHPExcel->getActiveSheet()->setCellValue('AE1', 'LD');
            $objPHPExcel->getActiveSheet()->setCellValue('AF1', 'Legal');
            $objPHPExcel->getActiveSheet()->setCellValue('AG1', 'Responsibility');

            $c = '2';
            $count = '1';
            foreach ($list as $l) {

                if (!empty($l->console_entity)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l->console_entity);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, "NA");
                }

                if (!empty($l->sbu)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, $l->sbu);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('B' . $c, "NA");
                }

                if (!empty($l->cluster)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, $l->cluster);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('C' . $c, "NA");
                }

                if (!empty($l->vertical)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, $l->vertical);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('D' . $c, "NA");
                }

                if (!empty($l->country)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, $l->country);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('E' . $c, "NA");
                }

                if (!empty($l->ar_type)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, $l->ar_type);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('F' . $c, "NA");
                }

                if (!empty($l->child_code)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, $l->child_code);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('G' . $c, "NA");
                }

                if (!empty($l->customer_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, $l->customer_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('H' . $c, "NA");
                }

                if (!empty($l->project_name)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, $l->project_name);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('I' . $c, "NA");
                }

                if (!empty($l->org_document_number)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, $l->org_document_number);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('J' . $c, "NA");
                }

                if ($l->invoice_date != '' && $l->invoice_date != null && $l->invoice_date != '1970-01-01' && $l->invoice_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, date('d-M-Y', strtotime($l->invoice_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('K' . $c, "-");
                }

                if ($l->rev_due_date != '' && $l->rev_due_date != null && $l->rev_due_date != '1970-01-01' && $l->rev_due_date != '0000-00-00') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, date('d-M-Y', strtotime($l->rev_due_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('L' . $c, "-");
                }

                if (!empty($l->invoice_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, money_format('%!i', $l->invoice_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('M' . $c, "0");
                }

                if (!empty($l->paid_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, money_format('%!i', $l->paid_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('N' . $c, "0");
                }

                if (!empty($l->balance_amount)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, money_format('%!i', $l->balance_amount));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('O' . $c, "0");
                }

                if (!empty($l->currency)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, $l->currency);
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('P' . $c, "0");
                }

                if (!empty($l->fx_rate)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, money_format('%!i', $l->fx_rate));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Q' . $c, "0");
                }

                if (!empty($l->planned_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, money_format('%!i', $l->planned_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('R' . $c, "0");
                }

                if ($l->planned_coll_date != null && $l->planned_coll_date != '0000-00-00' && $l->planned_coll_date != '' && $l->planned_coll_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, date('d-M-Y', strtotime($l->planned_coll_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('S' . $c, "");
                }

                if (!empty($l->retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, money_format('%!i', $l->retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('T' . $c, "0");
                }

                if (!empty($l->warranty_retention)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, money_format('%!i', $l->warranty_retention));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('U' . $c, "0");
                }

                if (!empty($l->planned_rtn_wrtn_coll_amt)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, money_format('%!i', $l->planned_rtn_wrtn_coll_amt));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('V' . $c, "0");
                }

                if ($l->planned_rtn_wrtn_date != null && $l->planned_rtn_wrtn_date != '0000-00-00' && $l->planned_rtn_wrtn_date != '' && $l->planned_rtn_wrtn_date != '1970-01-01') {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, date('d-M-Y', strtotime($l->planned_rtn_wrtn_date)));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('W' . $c, "");
                }

                if (!empty($l->pbg_lc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, money_format('%!i', $l->pbg_lc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('X' . $c, "0");
                }

                if (!empty($l->won)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, money_format('%!i', $l->won));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Y' . $c, "0");
                }

                if (!empty($l->cnaf)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, money_format('%!i', $l->cnaf));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('Z' . $c, "0");
                }

                if (!empty($l->srn)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, money_format('%!i', $l->srn));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AA' . $c, "0");
                }

                if (!empty($l->foc)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, money_format('%!i', $l->foc));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AB' . $c, "0");
                }

                if (!empty($l->wds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, money_format('%!i', $l->wds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AC' . $c, "0");
                }

                if (!empty($l->tds)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, money_format('%!i', $l->tds));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AD' . $c, "0");
                }

                if (!empty($l->ld)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, money_format('%!i', $l->ld));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AE' . $c, "0");
                }

                if (!empty($l->legal)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, money_format('%!i', $l->legal));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AF' . $c, "0");
                }

                if (!empty($l->responsibility)) {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, money_format('%!i', $l->responsibility));
                } else {
                    $objPHPExcel->getActiveSheet(0)->setCellValue('AG' . $c, "");
                }

                $c++;
                $count++;
            }

            ob_end_clean();

            $today = date('m-Y');

            // Rename worksheet (worksheet, not filename)
            $objPHPExcel->getActiveSheet()->setTitle('User Upload Template format v2');

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            // Redirect output to a client’s web browser (Excel2007)

            $filename = 'AR-' . $month_year . '.xlsx'; //save our workbook as this file name

            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0');

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            ob_end_clean();
            $objWriter->save('php://output');
        }
    }

    /* Kiran */
    public function upload_collec_plan()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->data['vertical_master']     = $this->db->query("select * from vertical_master order by position")->result();
        $this->data['cluster_master']     = $this->db->query("select * from cluster_master order by position")->result();
        $this->data['ar_type_master']     = $this->db->query("select * from ar_type_master")->result();
        $this->data['sbu_master']         = $this->db->query("select * from sbu_master")->result();
        $this->data['country_master']     = $this->db->query("select * from country_master")->result();

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_collec_plan');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_collec_plan', $this->data);
    }


    public function upload_collec_plan_upload()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        /* templete */
        $this->breadcrumbs->unshift(2, lang('menu_resources'), 'admin/transcation/upload_collec_plan_upload');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/transcation/upload_collec_plan_upload', $this->data);
    }


    public function upload_collection_plan_ajax()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }
        // POST data
        $postData = $this->input->post();
        // Get data
        $data = $this->Ajax_model->upload_collection_plan_ajaxdata($postData);
        echo json_encode($data);
    }

    public function upload_coll_plan_upload_ajax()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $error = '';
        $output = array();

        if ($_FILES['upload_coll_plan_list_file']['name'] != '') {
            if ($_FILES['upload_coll_plan_list_file']['name']) {
                $f_type                             = explode(".", $_FILES['upload_coll_plan_list_file']['name']);
                $last_in                          = (count($f_type) - 1);

                if ($f_type[$last_in] !== "xlsx") {
                    $this->session->set_flashdata('unsucces', "Invalid file!!! Please upload .xlsx format");
                    // redirect('admin/masters/vertical_bulk_upload_master', 'refresh');
                    $error = 'Invalid file!!! Please upload .xlsx format';
                    $output = array('error'  => $error);
                } else {
                    include(FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');
                    $file                                     = $_FILES['upload_coll_plan_list_file']['tmp_name'];
                    $inputFileName                             = $file;
                    //$objReader 								= new PHPExcel_Reader_Excel5();
                    $objReader = PHPExcel_IOFactory::createReader('Excel2007');

                    $objPHPExcel                             = $objReader->load($inputFileName);
                    $objWorksheet = $objPHPExcel->setActiveSheetIndex(0);
                    $data = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                    $data = array_map('array_filter', $data);
                    $allDataInSheet = array_filter($data);

                    $i                                         = 0;
                    $j                                         = 0;
                    $data                                     = array();
                    $valid                                     = 1;
                    $erroredRcords = array();

                    $arrayCount = count($allDataInSheet);
                    $flag = 0;
                    $createArray = array('Vertical_Name', 'Advance', 'OD', 'FTM', 'Not_Due', 'SAME_MTH', 'RTN_W_RTN');
                    $makeArray = array('Vertical_Name' => 'Vertical_Name', 'Advance' => 'Advance', 'OD' => 'OD', 'FTM' => 'FTM', 'SAME_MTH' => 'SAME_MTH', 'RTN_W_RTN' => 'RTN_W_RTN', 'Not_Due' => 'Not_Due');
                    $SheetDataKey = array();

                    foreach ($allDataInSheet as $dataInSheet) {
                        foreach ($dataInSheet as $key => $value) {
                            if (in_array(trim($value), $createArray)) {
                                $value = preg_replace('/\s+/', '', $value);
                                $SheetDataKey[trim($value)] = $key;
                            } else {
                            }
                        }
                        $Key_words = array();
                        $Key_words = array_flip($SheetDataKey);
                        $result = array_diff($createArray, $Key_words);

                        /*  print_r($result);
                        die; */

                        if (count($result) != 0) {
                            $msg = "Please check the standard template.";
                            $output = array('error'  => $msg);
                        } else {
                            $dataInSheet = $this->upload_collec_plan_validation($dataInSheet);
                            if ($dataInSheet['I'] != '') {
                                $erroredRcords[$j++] = $dataInSheet;
                            }
                        }
                    }


                    if (empty($erroredRcords)) {
                        $data = array_diff_key($makeArray, $SheetDataKey);
                        if (!empty($data)) {
                            $flag = 1;
                        }

                        if ($flag == 0) {
                            for ($i = 2; $i <= $arrayCount; $i++) {
                                $Vertical_Name = $SheetDataKey['Vertical_Name'];
                                $Advance = $SheetDataKey['Advance'];
                                $OD = $SheetDataKey['OD'];
                                $FTM = $SheetDataKey['FTM'];
                                $Not_Due = $SheetDataKey['Not_Due'];
                                $SAME_MTH = $SheetDataKey['SAME_MTH'];
                                $RTN_W_RTN = $SheetDataKey['RTN_W_RTN'];
                                $Vertical_Name = filter_var(trim($allDataInSheet[$i][$Vertical_Name]), FILTER_SANITIZE_STRING);
                                $Advance = filter_var(trim($allDataInSheet[$i][$Advance]), FILTER_SANITIZE_STRING);
                                $OD = filter_var(trim($allDataInSheet[$i][$OD]), FILTER_SANITIZE_STRING);
                                $FTM = filter_var(trim($allDataInSheet[$i][$FTM]), FILTER_SANITIZE_STRING);
                                $Not_Due = filter_var(trim($allDataInSheet[$i][$Not_Due]), FILTER_SANITIZE_STRING);
                                $SAME_MTH = filter_var(trim($allDataInSheet[$i][$SAME_MTH]), FILTER_SANITIZE_STRING);
                                $RTN_W_RTN = filter_var(trim($allDataInSheet[$i][$RTN_W_RTN]), FILTER_SANITIZE_STRING);
                                $sys_created_on =  date("Y-m-d h:i:s");
                                $user_id =  $this->ion_auth->get_user_id();

                                $fetchData[] = array(
                                    'month_year' => $this->input->post('month_year'),
                                    'vertical_name' => $Vertical_Name,
                                    'advance' => str_replace(',', '', $Advance),
                                    'od' => str_replace(',', '', $OD),
                                    'ftm' => str_replace(',', '', $FTM),
                                    'not_due' => str_replace(',', '', $Not_Due),
                                    'same_eith_mht' => str_replace(',', '', $SAME_MTH),
                                    'rtn_w_rtn' => str_replace(',', '', $RTN_W_RTN),
                                    'collection' => str_replace(',', '', $OD) + str_replace(',', '', $FTM) + str_replace(',', '', $Not_Due) + str_replace(',', '', $SAME_MTH) + str_replace(',', '', $RTN_W_RTN),
                                    'sys_created_on' => $sys_created_on,
                                    'user_id' => $user_id
                                );
                            }

                            $this->db->delete('upload_collection_plan', array('month_year' => $this->input->post('month_year')));
                            $this->base_model->setBatchImportUploadCollecPlan($fetchData);
                            if ($this->base_model->importDataUploadCollecPlan() == 1) {
                                $msg_success = count($fetchData) . "  rows of month-end AR info uploaded Successfully.";
                                $output = array('success'  => true, 'msg_success' => $msg_success);
                            } else {
                                echo 'no';
                            }
                        }
                    }


                    if (!empty($erroredRcords)) {
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
                        $objPHPExcel->getActiveSheet()->removeRow(2, 255);
                        $objSheet = $objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
                        //if($param1 == 'variancestock'){
                        $objSheet->setTitle('User-Input-Error-List' . date("Y-m-d"));
                        $red_cl = count($erroredRcords) + 1;
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->setBold(true)->setSize(12);
                        $objSheet->getStyle('I2:I' . $red_cl)->getFont()->getColor()->setRGB('FF0000');
                        $objSheet->getCell('I1')->setValue('Remarks');
                        $file_name = "Error-list-" . time() . ".xlsx";
                        if (!is_dir('upload/elgi_error_excel/')) {

                            mkdir('upload/elgi_error_excel/', 0777);
                        }
                        $objWriter->save('upload/elgi_error_excel/' . $file_name);
                        $download = base_url() . 'upload/elgi_error_excel/' . $file_name;
                        $this->session->set_userdata("recent_download", $download);
                        $total_data_rows = $arrayCount - 1;
                        $msg = "Found " . $j . " rows with error out of " . $total_data_rows . " rows. Please download for reference and clear the error in the original file and upload again.<br/><br/>Click here download error file<span style='color:#fff;'> <a target='_blank' href='" . $download . "'>Download</a></span>";
                        $output = array('error'  => $msg, 'total_line' => $total_data_rows);
                    }
                }
            }
        }

        echo json_encode($output);
    }

    function upload_collec_plan_validation($dataInSheet)
    {
        $record_status = array();
        $record_status['error'] = 0;
        $record_status['error_msg'] = "";

        if ($dataInSheet['A'] != "Vertical_Name") {


            if ($dataInSheet['A'] == NULL) {
                $record_status['error'] = 1;
                $record_status['error_msg'] = "Fields Cannot be empty";
            }

            if ($dataInSheet['A']) {
                $vertical_status = $this->db->query("select u.*from vertical_master as u where u.vertical_name='" . $dataInSheet['A'] . "'")->result();
                if (count($vertical_status) <= 0) {
                    $record_status['error'] = 1;
                    $record_status['error_msg'] = "Vertical does not exits";
                    if ($record_status['error_msg'] != '') {
                        $_ver = '|';
                    }
                }
            }
        }

        if ($record_status['error'] == 1) {
            $dataInSheet['I'] = $_ver . $record_status['error_msg'];
        }
        return $dataInSheet;
    }


    function download_collec_plan_templete()
    {
        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $ar_type_id = $this->db->query("select id from ar_type_master where ar_type_name='TRADE'")->row();
        $array_verticals = $this->db->query("select DISTINCT vertical_id from dpst_vertical_mapping where ar_type_id='" . $ar_type_id->id . "' and vertical_id !='27'")->result();
        $vertical_names = array();
        foreach ($array_verticals as $value) {
            $array_verticals_ids[] = $value->vertical_id;
        }
        foreach ($array_verticals_ids as $ver) {
            $vertical_names[] = trim(get_vertical_name($ver));
        }

        //load PHPExcel library
        $this->load->library('Excel');
        ob_start();
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
        $styleArray = array(
            'font' => array(
                'size' => 13,
                'name' => 'Roboto'
            )
        );
        $fontArray = array(
            'font' => array(
                'bold' => true,
                'size' => 11,
                'name' => 'Roboto'
            )
        );
        $dateArray = array(
            'font' => array(
                'bold' => true,
            )
        );
        $bgcolor = array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'E7E7E7'),
            )
        );

        $bgcolorblue = array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => '66bfff'),
            )
        );

        $bgblue = array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'ff0000'),
            )
        );

        $bgbrr = array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => '82b7da'),
            )
        );

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Comprehensive School Management")
            ->setLastModifiedBy("Comprehensive School Management")
            ->setTitle("Office  XLSX Test Document")
            ->setSubject("Office XLSX Test Document")
            ->setDescription("Test document for Office XLSX, generated by PHP classes.")
            ->setKeywords("office openxml php")
            ->setCategory("Excel Sheet");

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);

        $objPHPExcel->getActiveSheet(0)->getStyle('A1:G1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('A')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('B')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('C')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('D')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('E')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('F')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getStyle('G')
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()->getStyle('A1:G1')->applyFromArray($bgcolorblue);

        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'Vertical_Name');
        $objPHPExcel->getActiveSheet()->setCellValue('B1', 'Advance');
        $objPHPExcel->getActiveSheet()->setCellValue('C1', 'OD');
        $objPHPExcel->getActiveSheet()->setCellValue('D1', 'FTM');
        $objPHPExcel->getActiveSheet()->setCellValue('E1', 'Not_Due');
        $objPHPExcel->getActiveSheet()->setCellValue('F1', 'SAME_MTH');
        $objPHPExcel->getActiveSheet()->setCellValue('G1', 'RTN_W_RTN');

        $c = '2';
        $count = '1';

        foreach ($vertical_names as $l) {
            $objPHPExcel->getActiveSheet(0)->setCellValue('A' . $c, $l);
            $c++;
            $count++;
        }

        ob_end_clean();
        $today = date('m-Y');
        // Rename worksheet (worksheet, not filename)
        $objPHPExcel->getActiveSheet()->setTitle('Collection Plan Templete');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // Redirect output to a client’s web browser (Excel2007)

        $filename = 'collection_plan.xlsx'; //save our workbook as this file name

        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
        header('Cache-Control: max-age=0');

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $objWriter->save('php://output');
    }
}
