<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Users extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();


        $this->load->helper('security');

        $this->load->model('Base_model');

        $this->load->model('ajax_model');

        $this->load->library('form_validation');

        $this->load->helper('url');
        $this->lang->load('auth');
        $this->load->helper('number');

        /* Load :: Common */
        $this->lang->load('admin/users');

        /* Title Page :: Common */
        $this->page_title->push(lang('menu_users'));
        $this->data['pagetitle'] = $this->page_title->show();

        //<!------------------------- List Of Company---------------------->//

        $company = $this->db->query("SELECT * from companies where flag=0")->result();
        if (count($company) > 0) {
            foreach ($company as $com) :
                $company_list[$com->company_id] = $com->company_name;
            endforeach;
            $this->data['company_list'] = array('' => 'Please Choose Company') + $company_list;
        } else {

            $this->data['company_list'] = array('' => 'No Company');
        }



        //<!------------------------- End List Of Company---------------------->//


        //<!-------------------------- List of Audit_Roles ---------------------------->//

        $audit_role = $this->db->query("SELECT * from roles where flag=0")->result();
        if (count($audit_role) > 0) {
            foreach ($audit_role as $s) :
                $audit_role_list[$s->role_id] = $s->role_name;
            endforeach;
            $this->data['audit_role_list'] = array('' => 'Please Choose Role') + $audit_role_list;
        } else {

            $this->data['audit_role_list'] = array('' => 'No Role');
        }

        //<!-------------------------- End List of Audit_Roles ---------------------------->//

        //<!-------------------------- List of Client_Roles ---------------------------->//

        $client_role = $this->db->query("SELECT * from roles where flag=0")->result();
        if (count($client_role) > 0) {
            foreach ($client_role as $s) :
                $client_role_list[$s->role_id] = $s->role_name;
            endforeach;
            $this->data['client_role_list'] = array('' => 'Please Choose Role') + $client_role_list;
        } else {

            $this->data['client_role_list'] = array('' => 'No Role');
        }

        //<!-------------------------- End List of Client_Roles ---------------------------->//


        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_users'), 'admin/users');
    }


    public function index()
    {
        if (!$this->ion_auth->logged_in() or !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Get all users */

            $this->data['users']                 = $this->base_model->run_query(
                "SELECT ug.*, u.*, u.id as uid from users as u, users_groups as ug where ug.user_id = u.id AND ug.group_id=3 "
            );
            /* Load Template */
            $this->template->admin_render('admin/users/index', $this->data);
        }
    }


    public function create($param = '', $param1 = '')
    {


        //echo "raghu";die;
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */
        $tables = $this->config->item('tables', 'ion_auth');

        /* Validate form input */
        $this->form_validation->set_rules('username', 'lang:users_username', 'required');
        $this->form_validation->set_rules('role_id', 'Role', 'required');
        $this->form_validation->set_rules('email', 'lang:users_email', 'required|valid_email|is_unique[' . $tables['users'] . '.email]');
        $this->form_validation->set_rules('phone', 'lang:users_phone', 'required');
        $this->form_validation->set_rules('company', 'lang:users_company', 'required');
        $this->form_validation->set_rules('password', 'lang:users_password', 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', 'lang:users_password_confirm', 'required');

        if ($this->form_validation->run() == TRUE) {
            $username = strtolower($this->input->post('username'));
            $email    = strtolower($this->input->post('email'));

            //print_r($this->input->post('groups'));die;

            $group_id    = 3;



            $password = $this->input->post('password');

            $additional_data = array(
                'first_name' => $this->input->post('first_name'),
                'last_name'  => $this->input->post('last_name'),
                'company'    => $this->input->post('company'),
                'phone'      => $this->input->post('phone'),
                'role_id'     =>    $this->input->post('role_id'),
            );
        }

        if ($param == "delete") {
            if ($this->db->delete('users', array('id' => $param1))) {
                $this->session->set_flashdata('succes', 'Client User Deleted Succesfully');
                redirect('admin/users');
            } else {
                $this->session->set_flashdata('unsucces', 'Client user Unable Deleted Succesfully');
                redirect('admin/users');
            }
        }

        if ($this->form_validation->run() == TRUE && $this->ion_auth->register($username, $password, $email, $group_id, $additional_data)) {
            $this->session->set_flashdata('succes', 'Client User Added Successfully.');
            redirect('admin/users', 'refresh');
        } else {
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['username'] = array(
                'name'  => 'username',
                'id'    => 'username',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('username'),
            );
            $this->data['last_name'] = array(
                'name'  => 'last_name',
                'id'    => 'last_name',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('last_name'),
            );
            $this->data['email'] = array(
                'name'  => 'email',
                'id'    => 'email',
                'type'  => 'email',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('email'),
            );
            $this->data['company'] = array(
                'name'  => 'company',
                'id'    => 'company',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('company'),
            );
            $this->data['phone'] = array(
                'name'  => 'phone',
                'id'    => 'phone',
                'type'  => 'tel',
                'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('phone'),
            );
            $this->data['password'] = array(
                'name'  => 'password',
                'id'    => 'password',
                'type'  => 'password',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('password'),
            );
            $this->data['password_confirm'] = array(
                'name'  => 'password_confirm',
                'id'    => 'password_confirm',
                'type'  => 'password',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('password_confirm'),
            );



            $groups        = $this->ion_auth->groups()->result_array();
            $this->data['groups']        = $groups;

            /* Load Template */
            $this->template->admin_render('admin/users/create', $this->data);
        }
    }


    public function edit($id)
    {
        $id = (int) $id;

        if (!$this->ion_auth->logged_in() or (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id))) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_users_edit'), 'admin/users/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Data */
        $user          = $this->ion_auth->user($id)->row();
        $groups        = 3;
        $currentGroups = $this->ion_auth->get_users_groups($id)->result();

        /* Validate form input */
        $this->form_validation->set_rules('username', 'Username', 'required');
        $this->form_validation->set_rules('phone', 'Phone', 'required');
        $this->form_validation->set_rules('company', 'Company', 'required');

        if (isset($_POST) && !empty($_POST)) {
            if ($this->_valid_csrf_nonce() === FALSE or $id != $this->input->post('id')) {
                show_error($this->lang->line('error_csrf'));
            }

            if ($this->input->post('password')) {
                $this->form_validation->set_rules('password', 'Password', 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
                $this->form_validation->set_rules('password_confirm', 'Confirm Password', 'required');
            }

            if ($this->form_validation->run() == TRUE) {

                // print_r($this->input->post('company'));die;

                $data = array(
                    'username' => $this->input->post('username'),
                    'company'    => $this->input->post('company'),
                    'phone'      => $this->input->post('phone'),
                    'role_id'    => $this->input->post('role_id')
                );

                if ($this->input->post('password')) {
                    $data['password'] = $this->input->post('password');
                }

                if ($this->ion_auth->is_admin()) {
                    $groupData = $this->input->post('groups');

                    if (isset($groupData) && !empty($groupData)) {
                        $this->ion_auth->remove_from_group('', $id);

                        foreach ($groupData as $grp) {
                            $this->ion_auth->add_to_group($grp, $id);
                        }
                    }
                }

                if ($this->ion_auth->update($user->id, $data)) {
                    $this->session->set_flashdata('message', $this->ion_auth->messages());

                    if ($this->ion_auth->is_admin()) {
                        $this->session->set_flashdata('succes', 'Client User Updated Successfully.');
                        redirect('admin/users', 'refresh');
                    } else {
                        redirect('admin', 'refresh');
                    }
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());

                    if ($this->ion_auth->is_admin()) {
                        redirect('auth', 'refresh');
                    } else {
                        redirect('/', 'refresh');
                    }
                }
            }
        }

        // display the edit user form
        $this->data['csrf'] = $this->_get_csrf_nonce();

        // set the flash data error message if there is one
        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

        // pass the user to the view
        $this->data['user']          = $user;
        $this->data['groups']        = $groups;
        $this->data['currentGroups'] = $currentGroups;

        $this->data['username'] = array(
            'name'  => 'username',
            'id'    => 'username',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('username', $user->username)
        );
        $this->data['last_name'] = array(
            'name'  => 'last_name',
            'id'    => 'last_name',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('last_name', $user->last_name)
        );
        $this->data['company'] = array(
            'name'  => 'company',
            'id'    => 'company',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('company', $user->company)
        );
        $this->data['phone'] = array(
            'name'  => 'phone',
            'id'    => 'phone',
            'type'  => 'tel',
            'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('phone', $user->phone)
        );
        $this->data['password'] = array(
            'name' => 'password',
            'id'   => 'password',
            'class' => 'form-control',
            'type' => 'password'
        );
        $this->data['password_confirm'] = array(
            'name' => 'password_confirm',
            'id'   => 'password_confirm',
            'class' => 'form-control',
            'type' => 'password'
        );


        /* Load Template */
        $this->template->admin_render('admin/users/edit', $this->data);
    }


    function activate($id, $code = FALSE)
    {
        $id = (int) $id;

        if ($code !== FALSE) {
            $activation = $this->ion_auth->activate($id, $code);
        } else if ($this->ion_auth->is_admin()) {
            $activation = $this->ion_auth->activate($id);
        }

        if ($activation) {
            $parent_rec                         = $this->db->get_where(
                'users_groups',
                array('user_id' => $id)
            )->result();

            if ($parent_rec[0]->group_id == "3") {

                $this->session->set_flashdata('succes', 'Client User Active Successfully.');
                redirect('admin/users', 'refresh');
            } else {
                $this->session->set_flashdata('succes', 'Audit User Active Successfully.');
                redirect('admin/users/audit_user_list', 'refresh');
            }
        } else {
            $this->session->set_flashdata('message', $this->ion_auth->errors());
            redirect('auth/forgot_password', 'refresh');
        }
    }


    public function deactivate($id = NULL)
    {
        if (!$this->ion_auth->logged_in() or !$this->ion_auth->is_admin()) {
            return show_error('You must be an administrator to view this page.');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_users_deactivate'), 'admin/users/deactivate');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Validate form input */
        $this->form_validation->set_rules('confirm', 'lang:deactivate_validation_confirm_label', 'required');
        $this->form_validation->set_rules('id', 'lang:deactivate_validation_user_id_label', 'required|alpha_numeric');

        $id = (int) $id;

        if ($this->form_validation->run() === FALSE) {
            $user = $this->ion_auth->user($id)->row();

            $this->data['csrf']       = $this->_get_csrf_nonce();
            $this->data['id']         = (int) $user->id;
            $this->data['firstname']  = !empty($user->first_name) ? htmlspecialchars($user->first_name, ENT_QUOTES, 'UTF-8') : NULL;
            $this->data['lastname']   = !empty($user->last_name) ? ' ' . htmlspecialchars($user->last_name, ENT_QUOTES, 'UTF-8') : NULL;

            /* Load Template */
            $this->template->admin_render('admin/users/deactivate', $this->data);
        } else {
            if ($this->input->post('confirm') == 'yes') {
                if ($this->_valid_csrf_nonce() === FALSE or $id != $this->input->post('id')) {
                    show_error($this->lang->line('error_csrf'));
                }

                if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
                    $this->ion_auth->deactivate($id);
                }
            }

            $parent_rec                         = $this->db->get_where(
                'users_groups',
                array('user_id' => $id)
            )->result();

            if ($parent_rec[0]->group_id == "3") {

                $this->session->set_flashdata('succes', 'Client User Deactivate Successfully.');
                redirect('admin/users', 'refresh');
            } else {
                $this->session->set_flashdata('succes', 'Audit User Deactivate Successfully.');
                redirect('admin/users/audit_user_list', 'refresh');
            }
        }
    }


    public function profile($id)
    {
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_users_profile'), 'admin/groups/profile');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Data */
        $id = (int) $id;

        $this->data['user_info'] = $this->ion_auth->user($id)->result();
        foreach ($this->data['user_info'] as $k => $user) {
            $this->data['user_info'][$k]->groups = $this->ion_auth->get_users_groups($user->id)->result();
        }

        $this->data['old_password']         = array(
            'name'                             => 'old',
            'id'                             => 'old',
            'type'                             => 'password',
        );
        $this->data['new_password']         = array(
            'name'                             => 'new',
            'id'                             => 'new',
            'type'                             => 'password',
            'pattern'                         => '^.{' . $this->data['min_password_length'] . '}.*$',
        );
        $this->data['new_password_confirm'] = array(
            'name'                             => 'new_confirm',
            'id'                             => 'new_confirm',
            'type'                             => 'password',
            'pattern'                         => '^.{' . $this->data['min_password_length'] . '}.*$',
        );
        $this->data['user_id']                 = array(
            'name'                             => 'user_id',
            'id'                             => 'user_id',
            'type'                             => 'hidden',
            'value'                         => $user->id,
        );


        if ($this->input->post()) {

            $this->form_validation->set_rules('first_name', 'first_name', 'xss_clean');
            $this->form_validation->set_rules('last_name', 'last_name', 'xss_clean');
            $this->form_validation->set_rules('username', 'username', 'xss_clean');
            $this->form_validation->set_rules('email', 'Email', 'xss_clean');
            $this->form_validation->set_rules('company', 'company', 'xss_clean');
            $this->form_validation->set_rules('phone', 'phone', 'xss_clean');

            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            $table = "users";

            if ($this->form_validation->run() == TRUE) {

                $additional_data = array(
                    'first_name'              => $this->input->post('first_name'),
                    'last_name'                  => $this->input->post('last_name'),
                    'username'                => $this->input->post('username'),
                    'email'                       =>    $this->input->post('email'),
                    'company'              =>    $this->input->post('company'),
                    'phone'              =>    $this->input->post('phone'),
                );


                if ($this->input->post('id')) {
                    $where = $this->input->post('id');
                    $this->db->where('id', $where);
                    if ($this->db->update($table, $additional_data)) {

                        $uril = $this->uri->segment(4);
                        $this->session->set_flashdata('succes', "Profile Update Succesfully");
                        redirect('admin/users/profile/' . $uril, 'refresh');
                    } else {

                        $this->prepare_flashmessage("Unable to update", 1);
                        redirect('admin/audits/audit_allocation_all', 'refresh');
                    }
                }
            } else {
                echo "Avinash";
                die;
            }
        }



        /* Load Template */
        $this->template->admin_render('admin/users/profile', $this->data);
    }


    public function _get_csrf_nonce()
    {
        $this->load->helper('string');
        $key   = random_string('alnum', 8);
        $value = random_string('alnum', 20);
        $this->session->set_flashdata('csrfkey', $key);
        $this->session->set_flashdata('csrfvalue', $value);

        return array($key => $value);
    }


    public function _valid_csrf_nonce()
    {
        if ($this->input->post($this->session->flashdata('csrfkey')) !== FALSE && $this->input->post($this->session->flashdata('csrfkey')) == $this->session->flashdata('csrfvalue')) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function audit_user_create($param = '', $param1 = '')
    {

        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/audit_user_create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */
        $tables = $this->config->item('tables', 'ion_auth');

        /* Validate form input */
        $this->form_validation->set_rules('username', 'lang:users_username', 'required');
        $this->form_validation->set_rules('email', 'lang:users_email', 'required|valid_email|is_unique[' . $tables['users'] . '.email]');
        $this->form_validation->set_rules('phone', 'lang:users_phone', 'required');
        $this->form_validation->set_rules('role_id', 'Role', 'required');
        $this->form_validation->set_rules('company', 'lang:users_company', 'required');
        $this->form_validation->set_rules('password', 'lang:users_password', 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', 'lang:users_password_confirm', 'required');

        if ($this->form_validation->run() == TRUE) {
            $username = strtolower($this->input->post('username'));
            $email    = strtolower($this->input->post('email'));

            $groups                     =  2;



            $password = $this->input->post('password');

            $additional_data = array(
                'username'     => $this->input->post('username'),
                'company'    => $this->input->post('company'),
                'phone'      => $this->input->post('phone'),
                'role_id'     =>    $this->input->post('role_id'),
            );
        }

        if ($param == "audit_user_delete") {
            if ($this->db->delete('users', array('id' => $param1))) {
                $this->session->set_flashdata('succes', 'Audit User Deleted Succesfully');
                redirect('admin/users/audit_user_list');
            } else {
                $this->session->set_flashdata('unsucces', 'Audit user Unable Deleted Succesfully');
                redirect('admin/users/audit_user_list');
            }
        }

        if ($this->form_validation->run() == TRUE && $this->ion_auth->register($username, $password, $email, $groups, $additional_data)) {
            $this->session->set_flashdata('succes', 'Audit User Added Successfully.');
            redirect('admin/users/audit_user_list', 'refresh');
        } else {


            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            //$username = strtolower($this->input->post('username'));

            $this->data['username'] = array(
                'name'  => 'username',
                'id'    => 'username',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('username'),
            );


            $this->data['email'] = array(
                'name'  => 'email',
                'id'    => 'email',
                'type'  => 'email',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('email'),
            );



            $this->data['company'] = array(
                'name'  => 'company',
                'id'    => 'company',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('company'),
            );



            $this->data['phone'] = array(
                'name'  => 'phone',
                'id'    => 'phone',
                'type'  => 'tel',
                'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('phone'),
            );
            $this->data['password'] = array(
                'name'  => 'password',
                'id'    => 'password',
                'type'  => 'password',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('password'),
            );



            $this->data['password_confirm'] = array(
                'name'  => 'password_confirm',
                'id'    => 'password_confirm',
                'type'  => 'password',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('password_confirm'),
            );



            $groups        = $this->ion_auth->groups()->result_array();
            $this->data['groups']        = $groups;


            $this->template->admin_render('admin/users/audit_user_create', $this->data);
        }
    }


    public function audit_user_edit($id)
    {
        $id = (int) $id;

        if (!$this->ion_auth->logged_in() or (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id))) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_users_edit'), 'admin/users/audit_user_edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Data */
        $user          = $this->ion_auth->user($id)->row();
        $groups        = 2;
        $currentGroups = $this->ion_auth->get_users_groups($id)->result();

        /* Validate form input */
        $this->form_validation->set_rules('username', 'Username', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required');
        $this->form_validation->set_rules('phone', 'Phone', 'required');
        $this->form_validation->set_rules('company', 'Company', 'required');
        $this->form_validation->set_rules('role_id', 'Role', 'required');

        if (isset($_POST) && !empty($_POST)) {
            if ($this->_valid_csrf_nonce() === FALSE or $id != $this->input->post('id')) {
                show_error($this->lang->line('error_csrf'));
            }



            if ($this->input->post('password')) {


                $this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
                $this->form_validation->set_rules('password_confirm', $this->lang->line('edit_user_validation_password_confirm_label'), 'required');
            }

            if ($this->form_validation->run() == TRUE) {


                $data = array(
                    'username' => $this->input->post('username'),
                    'company'    => $this->input->post('company'),
                    'email'    => $this->input->post('email'),
                    'phone'      => $this->input->post('phone'),
                    'role_id'    => $this->input->post('role_id')

                );

                if ($this->input->post('password')) {

                    $data['password'] = $this->input->post('password');
                }

                if ($this->ion_auth->is_admin()) {
                    $groupData = $this->input->post('groups');

                    if (isset($groupData) && !empty($groupData)) {
                        $this->ion_auth->remove_from_group('', $id);

                        foreach ($groupData as $grp) {
                            $this->ion_auth->add_to_group($grp, $id);
                        }
                    }
                }

                if ($this->ion_auth->update($user->id, $data)) {

                    if ($this->ion_auth->is_admin()) {
                        $this->session->set_flashdata('succes', 'Audit User Updated Successfully.');
                        redirect('admin/users/audit_user_list', 'refresh');
                    } else {
                        redirect('admin', 'refresh');
                    }
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());

                    if ($this->ion_auth->is_admin()) {
                        redirect('auth', 'refresh');
                    } else {
                        redirect('/', 'refresh');
                    }
                }
            }
        }

        // display the edit user form
        $this->data['csrf'] = $this->_get_csrf_nonce();

        // set the flash data error message if there is one
        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

        // pass the user to the view
        $this->data['user']          = $user;
        $this->data['groups']        = $groups;
        $this->data['currentGroups'] = $currentGroups;

        $this->data['username'] = array(
            'name'  => 'username',
            'id'    => 'username',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('username', $user->username)
        );

        $this->data['company'] = array(
            'name'  => 'company',
            'id'    => 'company',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('company', $user->company)
        );

        $this->data['role_id'] = array(
            'name'  => 'role_id',
            'id'    => 'role_id',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('role_id', $user->role_id)
        );

        $this->data['email'] = array(
            'name'  => 'email',
            'id'    => 'email',
            'type'  => 'text',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('email', $user->email)
        );

        //print_r($this->data['role_id']);die;

        $this->data['phone'] = array(
            'name'  => 'phone',
            'id'    => 'phone',
            'type'  => 'tel',
            'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
            'class' => 'form-control',
            'value' => $this->form_validation->set_value('phone', $user->phone)
        );
        $this->data['password'] = array(
            'name' => 'password',
            'id'   => 'password',
            'class' => 'form-control',
            'type' => 'password'
        );
        $this->data['password_confirm'] = array(
            'name' => 'password_confirm',
            'id'   => 'password_confirm',
            'class' => 'form-control',
            'type' => 'password'
        );


        /* Load Template */
        $this->template->admin_render('admin/users/audit_user_edit', $this->data);
    }



    public function audit_user_list()
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        $this->data['audit_users']                 = $this->base_model->run_query(
            "SELECT ug.*, u.*, u.id as uid from users as u, users_groups as ug where ug.user_id = u.id AND ug.group_id=2 "
        );

        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/audit_user_list');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        $this->template->admin_render('admin/users/audit_user_list', $this->data);
    }

    public function role_master_create($param = '', $param1 = '')
    {

        if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->input->post()) {


            $this->form_validation->set_rules('role_name', 'Role Name', 'xss_clean|required');
            $this->form_validation->set_rules('role_code', 'Role Code', 'xss_clean|required');
            $this->form_validation->set_rules('role_for', 'Role For', 'xss_clean|required');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

            $table = "roles";

            if ($this->form_validation->run() == TRUE) {

                $inputdata1['role_name']        = $this->input->post("role_name");
                $inputdata1['role_code']        = $this->input->post("role_code");
                $inputdata1['role_for']            = $this->input->post("role_for");
                $inputdata1['user_id']            = $this->ion_auth->get_user_id();

                if ($this->input->post('role_id')) {
                    $inputdata1['updated_on']        = date("Y-m-d H:i:s");
                } else {
                    $inputdata1['created_on']        = date("Y-m-d H:i:s");
                }

                if ($this->input->post('role_id')) {
                    $where = $this->input->post('role_id');
                    $this->db->where('role_id', $where);

                    if ($this->db->update($table, $inputdata1)) {


                        $this->session->set_flashdata('succes', 'Role Updated Successfully.');
                        redirect('admin/users/role_master_create', 'refresh');
                    } else {

                        $this->session->set_flashdata('unsucces', 'Unable to Add.');
                        redirect('admin/users/role_master_create');
                    }
                }


                if ($this->base_model->insert_operation($inputdata1, $table)) {
                    $this->session->set_flashdata('succes', 'Role Added Successfully.');
                    redirect('admin/users/role_master_create', 'refresh');
                } else {
                    $this->session->set_flashdata('unsucces', 'Unable to Add.');
                    redirect('admin/users/role_master_create');
                }
            }
        }

        if ($param == "edit") {
            $parent_rec                         = $this->db->get_where(
                'roles',
                array('role_id' => $param1)
            )->result();
            $this->data['parent_rec']            = $parent_rec[0];
        }

        if ($param == "delete") {
            $this->db->set('flag', 1);
            $this->db->where('role_id', $param1);
            if ($this->db->update('roles')) {
                $this->session->set_flashdata('succes', 'Brand Deleted Successfully.');
                redirect('admin/users/role_master_create');
            } else {
                $this->session->set_flashdata('unsucces', 'Brand Unable Delete.');
                redirect('admin/users/role_master_create');
            }
        }


        $this->data['list']                 = $this->base_model->run_query(
            "select * from roles where flag=0 "
        );


        $this->breadcrumbs->unshift(2, lang('menu_users_create'), 'admin/users/role_master_create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->template->admin_render('admin/users/role_master_create', $this->data);
    }



    // change password
    function change_password()
    {

        $this->form_validation->set_rules('old', $this->lang->line('change_password_validation_old_password_label'), 'required');
        $this->form_validation->set_rules('new', $this->lang->line('change_password_validation_new_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[new_confirm]');
        $this->form_validation->set_rules('new_confirm', $this->lang->line('change_password_validation_new_password_confirm_label'), 'required');

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }

        // $user = $this->ion_auth->user()->row();
        $user_login  = $this->prefs_model->user_info_login($this->ion_auth->user()->row()->id);
        if ($this->form_validation->run() == true) {
            // // display the form
            // // set the flash data error message if there is one
            // $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

            // $this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
            // $this->data['old_password'] = array(
            //     'name' => 'old',
            //     'id'   => 'old',
            //     'type' => 'password',
            // );
            // $this->data['new_password'] = array(
            //     'name'    => 'new',
            //     'id'      => 'new',
            //     'type'    => 'password',
            //     'pattern' => '^.{' . $this->data['min_password_length'] . '}.*$',
            // );
            // $this->data['new_password_confirm'] = array(
            //     'name'    => 'new_confirm',
            //     'id'      => 'new_confirm',
            //     'type'    => 'password',
            //     'pattern' => '^.{' . $this->data['min_password_length'] . '}.*$',
            // );
            // $this->data['user_id'] = array(
            //     'name'  => 'user_id',
            //     'id'    => 'user_id',
            //     'type'  => 'hidden',
            //     'value' => $user->id,
            // );
            // $this->_render_page('admin/users/profile', $this->data);
            $identity = $this->session->userdata('identity');
            $change = $this->ion_auth->change_password($identity, $this->input->post('old'), $this->input->post('new'));

            if ($change) {
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                redirect('auth/logout', 'refresh');
            } else {
                $this->session->set_flashdata('unsuccess', "Incorrect current password");
                redirect('admin/users/profile/' . $user_login['id'], 'refresh');
            }
        } else {
            $this->session->set_flashdata('unsuccess', "Passwords did not match or Passwords must be minimum 8 characters");
            redirect('admin/users/profile/' . $user_login['id'], 'refresh');
        }
    }
}
