<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Audits extends Client_Controller {

    public function __construct()
    {
        parent::__construct();
		
      
        $this->load->helper('security');
	   
	    $this->load->model('Base_model');
		
		$this->load->model('ajax_model');

		$this->load->library('form_validation');
		
		$this->load->helper('url');
		
		//<!-----------  List of Audit Types --------------------------->
		$audit_types = $this->db->query("SELECT * from audit_types where flag=0 ")->result();
		if(count($audit_types)>0){
		foreach($audit_types as $audit):
			$audit_type_list[$audit->audit_id] = $audit->audit_type;			
		endforeach;
		$this->data['audit_type_list'] = array('' => 'Please Choose Audit Type')+$audit_type_list;
		}else{
			
			$this->data['audit_type_list'] = array('' => 'No Audit Type');
		}
		//<!----------- End List of Audit Types --------------------------->
		
		//<!-----------  List of Stores as per client --------------------------->
		$stores = $this->db->query("select s.*, u.company from users as u, stores as s where u.company = s.company_id and u.id = ".$this->ion_auth->get_user_id() ." and s.flag=0 ")->result();
		if(count($stores)>0){
		foreach($stores as $s):
			$stores_list[$s->store_id] = $s->store_name;			
		endforeach;
		$this->data['stores_list'] = array('' => 'Please Choose Store')+$stores_list;
		}else{
			
			$this->data['stores_list'] = array('' => 'No Store');
		}
		//<!----------- End List of Stores as per client --------------------------->
		
		
		//<!-----------  List of brands --------------------------->
		
		$brands = $this->db->query("SELECT * from brands where flag=0")->result();
		if(count($brands)>0){
		foreach($brands as $b):
			$brand_list[$b->brand_id] = $b->brand_name;			
		endforeach;
		$this->data['brand_list'] = array('' => 'Please Choose Brand')+$brand_list;
		}else{
			
			$this->data['brand_list'] = array('' => 'No Brand');
		}
		//<!-----------  End List of brands--------------------------->
		
		
		//<!-------------------------- List of Company ---------------------------->//
		
		
		
		$company = $this->db->query(" select u.*,c.*  from  companies c Left join users as u on c.company_id = u.company where u.id =".$this->ion_auth->get_user_id()   )->result();
		//print_r($this->db->last_query());die;
		if(count($company)>0){
		foreach($company as $s):
			$company_list_client[$s->company_id] = $s->company_name;			
		endforeach;
		$this->data['company_list_client'] = $company_list_client;
		}else{
			
			$this->data['company_list_client'] = array('' => 'No Company');
		}
		
		//<!-------------------------- End List of Company ---------------------------->//
		
    }


	public function index()
	{
		
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_client())
        {
            redirect('auth/login', 'refresh');
        }
       
	}
	
	function company_session($param1 = '',$param2 = '')
	{ 
	
	
	if($param1==''){
	if($this->input->post('company_id')!='' && $this->input->post('date_range') != '' ){
		
		$date_range = explode('/',$this->input->post('date_range'));
				

				$this->session->set_userdata("schedule_from_date",$date_range[0]);
				$this->session->set_userdata("schedule_to_date",$date_range[1]);
				
		$this->session->set_userdata("company_id",$this->input->post('company_id'));
	}else{
		
		$this->session->set_userdata("company_id",1);
	}
		
		echo json_encode(array("error"=>0,"msg"=>"Date range Changed" ));
		
	}else{
		
		$this->session->set_userdata("company_id",$param1);
		redirect('client/audits/client_store_list');
	}
		
		
	}
	
	public function store_list($param='', $param1='')
	{
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
		
            $this->template->client_render('client/audits/store_list', $this->data);
       
	}
	
	public function new_store()
	{ 
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
            /* Load Template */
            $this->template->client_render('client/audits/new_store', $this->data);
       
	}
	
	public function upload_audit()
	{ 
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
	

            /* Load Template */
            $this->template->client_render('client/audits/upload_store_list', $this->data);
       
	}
	
	// Read Excel Format Questions and Insert into DB
	function readexcel_audit($param = '')
	{
		if (!$this->ion_auth->logged_in() && (!$this->ion_auth->is_admin())){
			$this->prepare_flashmessage($this->lang->line('you_have_no_access_to_this_module') , 1);
			redirect('auth/login');
		}
		
		if ($_FILES['userfile']['name']) {
				$f_type							 = explode(".", $_FILES['userfile']['name']);
				$last_in 						 = (count($f_type) - 1);
				
				if($f_type[$last_in] !== "xlsx"){
					$this->session->set_flashdata('unsucces',"invalid_file");
					redirect('client/audits/client_store_list');
				}
			}
	    
		if ($param == "audit" || $param == "customers") {
		include (FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

		$file 									= $_FILES['userfile']['tmp_name'];
		$inputFileName 							= $file;
		//$objReader 								= new PHPExcel_Reader_Excel5();
		$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		
		
		$objPHPExcel 							= $objReader->load($inputFileName);
		echo '<hr />';
		$sheetData 								= $objPHPExcel->getActiveSheet()->toArray(
		null, true, true, true
		);
		$i 										= 0;
		$j 										= 0;
		$data 									= array();
		$valid 									= 1;
		$erroredRcords=array();
		foreach($sheetData as $r) {
			
			if ($i++ != 0) {
				if ($valid == 1){
					if ($param == 'audit') {
						$r=$this->audit_validation($r);
						
						//print_r($r);die;
						
					if($r['K']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{ 
							$inputdata_mat 		= array(
							
							'store_id' 						=> $r['A'],
							'audit_type'    				=> $r['C'],
							'day_night'         			=> $r['E'],
							'surprise_regular' 	            => $r['F'],
							'local_os' 						=> $r['G'],	
							'schedule_from_date'			=> convert_date($r['H']),	
							'schedule_to_date' 				=> convert_date($r['I']),
							'no_of_days' 					=> $r['J'],
							'created_on' 	    			=> date("Y-m-d H:i:s"),
							'user_id'     					=> $this->ion_auth->get_user_id(),
						
						);
					  }
						
					}elseif ($param == 'customers'){ 
						$r=$this->customer_validation($r);
						if(isset($r['R']) && $r['R']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{
							$inputdata 			= array(
								'client_id'     => $this->session->userdata('client_id'),
								'customer_code' => $r['A'],
								'name'          => $r['B'],
								'email' 		=> $r['C'],
								'phone'         => $r['D'],
								'city' 	        => $r['E'],
								'address' 	    => $r['F'],
								'zip_code' 	    => $r['G'],
								'contact_name1' => $r['H'],
								'contact_phone1'=> $r['I'],
								'contact_email1'=> $r['J'],
								'designation1'	=> $r['K'],
								'remark1'		=> $r['L'],
								'contact_name2' => $r['M'],
								'contact_phone2'=> $r['N'],
								'contact_email2'=> $r['O'],
								'designation2'	=> $r['P'],
								'remark2'		=> $r['Q'],
								'active' 	    => 1,
								'created_on' 	    => date("Y-m-d H:i:s"),
							);
						}
					}
					//echo "<pre>"; print_r($inputdata_mat);
					header_remove('Set-Cookie');
					$this->base_model->insert_operation($inputdata_mat, $param);
					$this->session->set_flashdata('succes', 'Audit Store Created Successfully.');
				}
				else {
					break;
				}
			}
		}
	   
		if (!empty($erroredRcords)){
			
			
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objPHPExcel->getActiveSheet()->removeRow(2, 255);
			$objSheet=$objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
			if($param == 'customers'){
				$objSheet->setTitle('Customer-List'.date("Y-m-d"));
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('R1')->setValue('Remark');
				$file_name="C-list-".time().".xlsx";
				if(!is_dir('upload/upload_material/'.$this->session->userdata("client_name"))){
					
					mkdir('upload/upload_material/'.$this->session->userdata("client_name"), 0777);
				}
				$objWriter->save('upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name);
				$download='upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name;
			}elseif($param == 'audit'){
				$objSheet->setTitle('Material-List'.date("Y-m-d"));
				$objSheet->getStyle('K2:K'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('K2:K'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('K1')->setValue('Remark');
				$file_name="A-list-".time().".xlsx";
				if(!is_dir('upload/showroom/upload_audit/')){
					
					mkdir('upload/showroom/upload_audit/', 0777);
				}
				$objWriter->save('upload/showroom/upload_audit/'.$file_name);
				$download='upload/showroom/upload_audit/'.$file_name;
				
			}
		    $this->session->set_userdata("recent_download",$download);
			$msg = "Some records are not uploaded. Please download the file to see the status of records";
			$this->session->set_flashdata('unsucces', $msg);
			redirect('client/audits/upload_audit/'.$param, 'refresh');
		}
			
			redirect('client/audits/client_store_list', 'refresh');
			
		}
		else {
		
			$this->session->set_flashdata('unsucces',$this->lang->line('incorrect_operation'));
			redirect('client/audits/upload_audit/'.$param);
		}
	}
	
	function audit_validation($r){
		
	
		$record_status=array();
		$record_status['error']=0;
		$date=array();
		$m=""; $e="";
		$record_status['error_msg']="";

		if($r['A']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Store ID field is required."; 
		
		}elseif($r['C']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Audit Type ID field is required."; 
		
		}elseif($r['E']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Day/Night field is required."; 
		
		}elseif($r['F']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Surprise/Regular field is required."; 
		
		}elseif($r['G']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Local/OS field is required."; 
		
		}elseif($r['H']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Audit From Date field is required."; 
		
		}elseif($r['I']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="Audit To Date field is required."; 
		
		}elseif($r['J']==''){
			
			$record_status['error']=1;
			$record_status['error_msg']="No Of Days field is required."; 
		
		}
		
		
	     if($record_status['error']==1){
			$r['K']=$record_status['error_msg'];
		}else{
			//if($r['AR']!="")$r['AR']=$m;
			//$r['AR']=$m;
			//if($r['AS']!="")$r['AS']=$e;
		} 

		return $r;
	}
	
	
	
	public function client_store_list()
	{ 
		
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
		if($this->session->userdata("schedule_from_date")=='' || $this->session->userdata("schedule_to_date")==''){
			
		 $db_from_date =  $this->session->set_userdata("schedule_from_date",date('d-m-Y', strtotime("-30 days")));
		 $db_to_date   =  $this->session->set_userdata("schedule_to_date",date('d-m-Y'));
		 
		}else{}
		
		if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			 
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		 $com =  $this->base_model->run_query("select * from users where id=".$this->ion_auth->get_user_id())[0];
		 
		// print_r(count($com));die;
		 
	$company_login='';
		if(count($com)>0){
			
			$this->session->set_userdata("company_id",$com->company);
			$company_login= " and s.company_id =".$this->session->userdata("company_id");
		}else{
			$company_login='';
			
		}
		
		
			$query = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."'  OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 ".$company_login ."  " );
		
		if(count($query)>0){
			
			
		
		$query1 = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 ".$company_login ."  " );
		
		
		
		if(count($query1)>0){
			
		
		$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id and ( a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."' ) where s.flag=0 ".$company_login ."  " );
		
		
		} else {
		
		
		$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  where s.flag=0 ".$company_login ." and a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' " );
		
		
		}
			
		}else{
			
				
			
			$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  where s.flag=0 ".$company_login ." group by a.store_id " );
		
		}
		
		//print_r($this->db->last_query());die;
		
		
		if($this->input->post()){
		
		$this->form_validation->set_rules('audit_type', 'Audit Type' , 'xss_clean|required');
		$this->form_validation->set_rules('day_night', 'Day/Night' , 'xss_clean');
		$this->form_validation->set_rules('local_os', 'Local/OS' , 'xss_clean|required');
		$this->form_validation->set_rules('no_of_days', 'No Of Days' , 'xss_clean|required');
		$this->form_validation->set_rules('surprise_regular', 'Surprise/ Regular' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required'); 
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "audit";
		
		if($this->form_validation->run()== TRUE){
			
			$choice = $this->input->post("day_night");
			
    if(is_null($choice))
    {
        $choice = array();
    }
    $val = implode(',', $choice);
			
			$inputdata1['store_id']						= $this->input->post("store_id");
			$inputdata1['company_id']					= $this->session->userdata("company_id");
			$inputdata1['schedule_from_date']			= date("Y-m-d", strtotime($this->input->post("schedule_from_date")));
			$inputdata1['schedule_to_date']				= date("Y-m-d", strtotime($this->input->post("schedule_to_date")));
			$inputdata1['user_id']						= $this->ion_auth->get_user_id();
			$inputdata1['surprise_regular']				= $this->input->post("surprise_regular");
			$inputdata1['audit_type']					= $this->input->post("audit_type");
			$inputdata1['day_night']					= $val;
			$inputdata1['schedule_status']				= $this->input->post("schedule_status");
			$inputdata1['local_os']						= $this->input->post("local_os");
			$inputdata1['no_of_days']					= $this->input->post("no_of_days");
			
			
				if ($this->input->post('audit_id')){
					$inputdata1['updated_on']		= date("Y-m-d H:i:s");
					
				}else{
					$inputdata1['created_on']		= date("Y-m-d H:i:s");
					
				}
				
				if ($this->input->post('audit_id')) {
				$where = $this->input->post('audit_id');
				$this->db->where('audit_id', $where);
				if ($this->db->update($table, $inputdata1)) {
						
						$this->session->set_flashdata('succes',"Audit Schedule Update Succesfully");
						redirect('client/audits/client_store_list', 'refresh'); 
					}
					else {
						
						$this->prepare_flashmessage("Unable to update" , 1);
						redirect('client/audits/client_store_list', 'refresh'); 
					}
				
			}
			
			if($this->input->post('schedule_to_date')!=''){
				
				
					if ($this->base_model->insert_operation($inputdata1, $table)){
				
				$this->session->set_flashdata('succes', 'Audit Store Create Succesfully.');
						redirect('client/audits/client_store_list', 'refresh'); 
				}else{
				
				
						$this->session->set_flashdata('unsucces', "Unable to Add");
						redirect('client/audits/client_store_list');
			}
			
			}
			
			 
		}
		
		}
		
		$this->data['active_allocation'] = "active";
				$this->data['client_store_list'] = "active";

            /* Load Template */
            $this->template->client_sidebar_render('client/audits/client_store_list', $this->data);
       
	}
	
	public function client_store_list_pending()
	{ 
		
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
		
		if($this->session->userdata("schedule_from_date")=='' || $this->session->userdata("schedule_to_date")==''){
			
		 $db_from_date =  $this->session->set_userdata("schedule_from_date",date('d-m-Y', strtotime("-30 days")));
		 $db_to_date   =  $this->session->set_userdata("schedule_to_date",date('d-m-Y'));
		 
		}else{}
		
		if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			 
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		 $com =  $this->base_model->run_query("select * from users where id=".$this->ion_auth->get_user_id())[0];
		 
	$company_login='';
		if(count($com)>0){
			
			$this->session->set_userdata("company_id",$com->company);
			$company_login= " and s.company_id =".$this->session->userdata("company_id");
		}else{
			$company_login='';
			
		}
		
			
			
			$query = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."'  OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 ".$company_login ."  " );
		
		
		
		if(count($query)>0){
			
			
		$query1 = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') and (a.schedule_status = 0 OR a.schedule_status = '' )  where s.flag=0 ".$company_login ."  " );
		
		
		
		if(count($query1)>0){
			
			$query2 = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 and a.schedule_status = 1 ".$company_login ."  " );
			
		if(count($query2)>0){
			
			$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id and ( a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."' ) and (a.schedule_status = 0 OR a.schedule_status = '' )  where s.flag=0 ".$company_login." and s.store_id != ".$query2[0]->store_id  );
			
		}else{
			
			$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id and ( a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."' ) and (a.schedule_status = 0 OR a.schedule_status = '' ) where s.flag=0 ".$company_login ."  " );
			
		}
		
		} else {
			
		
		
		$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id and (a.schedule_status = 0 OR a.schedule_status = '' ) where s.flag=0  ".$company_login ." and a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."' " );
		
		
		
		}
			
		}else{
			
			
			$this->data['list'] 				= $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  where s.flag=0 ".$company_login ." group by a.store_id " );
		
		
		
		}
		
		
		
		if($this->input->post()){
			
		$this->form_validation->set_rules('audit_type', 'Audit Type' , 'xss_clean|required');
		$this->form_validation->set_rules('day_night', 'Day/Night' , 'xss_clean');
		$this->form_validation->set_rules('local_os', 'Local/OS' , 'xss_clean|required');
		$this->form_validation->set_rules('no_of_days', 'No Of Days' , 'xss_clean|required');
		$this->form_validation->set_rules('surprise_regular', 'Surprise/ Regular' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "audit";
		
		if($this->form_validation->run()== TRUE){
			
			$choice = $this->input->post("day_night");
			
    if(is_null($choice))
    {
        $choice = array();
    }
    $val = implode(',', $choice);
			
			$inputdata1['store_id']						= $this->input->post("store_id");
			$inputdata1['company_id']					= $this->session->userdata("company_id");
			$inputdata1['schedule_from_date']			= date("Y-m-d", strtotime($this->input->post("schedule_from_date")));
			$inputdata1['schedule_to_date']				= date("Y-m-d", strtotime($this->input->post("schedule_to_date")));
			$inputdata1['user_id']						= $this->ion_auth->get_user_id();
			$inputdata1['surprise_regular']				= $this->input->post("surprise_regular");
			$inputdata1['audit_type']					= $this->input->post("audit_type");
			$inputdata1['day_night']					= $val;
			$inputdata1['schedule_status']				= $this->input->post("schedule_status");
			$inputdata1['local_os']						= $this->input->post("local_os");
			$inputdata1['no_of_days']					= $this->input->post("no_of_days");
			
			
				if ($this->input->post('audit_id')){
					$inputdata1['updated_on']		= date("Y-m-d H:i:s");
					
				}else{
					$inputdata1['created_on']		= date("Y-m-d H:i:s");
					
				}
				
				if ($this->input->post('audit_id')) {
				$where = $this->input->post('audit_id');
				$this->db->where('audit_id', $where);
				if ($this->db->update($table, $inputdata1)) {
						
						$this->session->set_flashdata('succes',"Audit Schedule Update Succesfully");
						redirect('client/audits/client_store_list_pending', 'refresh'); 
					}
					else {
						
						$this->prepare_flashmessage("Unable to update" , 1);
						redirect('client/audits/client_store_list_pending', 'refresh'); 
					}
				
			}
			
			if($this->input->post('schedule_to_date')!=''){
				
				
					if ($this->base_model->insert_operation($inputdata1, $table)){
				
				$this->session->set_flashdata('succes', 'Audit Store Create Succesfully.');
						redirect('client/audits/client_store_list_pending', 'refresh'); 
				}else{
				
				
						$this->session->set_flashdata('unsucces', "Unable to Add");
						redirect('client/audits/client_store_list_pending');
			}
			
			}
		}
		
		}
		
			$this->data['active_allocation'] = "active";
				$this->data['client_store_list_pending'] = "active";
		

            /* Load Template */
            $this->template->client_sidebar_render('client/audits/client_store_list_pending', $this->data);
       
	}
	
	public function client_store_list_complete()
	{ 
		
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
		
		if($this->session->userdata("schedule_from_date")=='' || $this->session->userdata("schedule_to_date")==''){
			
		 $db_from_date =  $this->session->set_userdata("schedule_from_date",date('d-m-Y', strtotime("-30 days")));
		 $db_to_date   =  $this->session->set_userdata("schedule_to_date",date('d-m-Y'));
		 
		}else{}
		
		if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			 
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		 $com =  $this->base_model->run_query("select * from users where id=".$this->ion_auth->get_user_id())[0];
		 
	$company_login='';
		if(count($com)>0){
			
			$this->session->set_userdata("company_id",$com->company);
			$company_login= " and s.company_id =".$this->session->userdata("company_id");
		}else{
			$company_login='';
			
		}
		
		
				$this->data['list']                = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from stores as s left join audit as a on s.store_id = a.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."'  OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 and a.schedule_status=1 ".$company_login );
		
		//print_r($this->db->last_query());die;
		
		if($this->input->post()){
		
		$this->form_validation->set_rules('audit_type', 'Audit Type' , 'xss_clean|required');
		$this->form_validation->set_rules('day_night', 'Day/Night' , 'xss_clean');
		$this->form_validation->set_rules('local_os', 'Local/OS' , 'xss_clean|required');
		$this->form_validation->set_rules('no_of_days', 'No Of Days' , 'xss_clean|required');
		$this->form_validation->set_rules('surprise_regular', 'Surprise/ Regular' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "audit";
		
		if($this->form_validation->run()== TRUE){
			
			$choice = $this->input->post("day_night");
			
    if(is_null($choice))
    {
        $choice = array();
    }
    $val = implode(',', $choice);
			
			$inputdata1['store_id']						= $this->input->post("store_id");
			$inputdata1['company_id']					= $this->session->userdata("company_id");
			$inputdata1['schedule_from_date']			= date("Y-m-d", strtotime($this->input->post("schedule_from_date")));
			$inputdata1['schedule_to_date']				= date("Y-m-d", strtotime($this->input->post("schedule_to_date")));
			$inputdata1['user_id']						= $this->ion_auth->get_user_id();
			$inputdata1['surprise_regular']				= $this->input->post("surprise_regular");
			$inputdata1['audit_type']					= $this->input->post("audit_type");
			$inputdata1['day_night']					= $val;
			$inputdata1['schedule_status']				= $this->input->post("schedule_status");
			$inputdata1['local_os']						= $this->input->post("local_os");
			$inputdata1['no_of_days']					= $this->input->post("no_of_days");
			
			
				if ($this->input->post('audit_id')){
					$inputdata1['updated_on']		= date("Y-m-d H:i:s");
					
				}else{
					$inputdata1['created_on']		= date("Y-m-d H:i:s");
					
				}
				
				if ($this->input->post('audit_id')) {
				$where = $this->input->post('audit_id');
				$this->db->where('audit_id', $where);
				if ($this->db->update($table, $inputdata1)) {
						
						$this->session->set_flashdata('succes',"Audit Schedule Update Succesfully");
						redirect('admin/audits/audit_list_schedule', 'refresh'); 
					}
					else {
						
						$this->prepare_flashmessage("Unable to update" , 1);
						redirect('admin/audits/audit_list_schedule', 'refresh'); 
					}
				
			}
		}
		
		}
		
				$this->data['active_allocation'] = "active";
				$this->data['client_store_list_complete'] = "active";
			
			
            /* Load Template */
            $this->template->client_sidebar_render('client/audits/client_store_list_complete', $this->data);
       
	}
	
	public function new_audit($param='', $param1='')
	{ 
		
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
	
	
	if($this->input->post()){
		
		$this->form_validation->set_rules('store_id', 'Store' , 'xss_clean|required');
		$this->form_validation->set_rules('day_night', 'Day/Night' , 'xss_clean|required');
		$this->form_validation->set_rules('local_os', 'Local/OS' , 'xss_clean|required');
		$this->form_validation->set_rules('no_of_days', 'No Of Days' , 'xss_clean|required');
		$this->form_validation->set_rules('audit_type', 'Audit Type' , 'xss_clean|required');
		$this->form_validation->set_rules('surprise_regular', 'Surprise/ Regular' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "audit";
		
		
		if($this->form_validation->run()== TRUE){
			
			$inputdata['company_id']					= $this->input->post("company_id");
			$inputdata['store_id']						= $this->input->post("store_id");
			$inputdata['day_night']						= $this->input->post("day_night");
			$inputdata['local_os']						= $this->input->post("local_os");
			$inputdata['no_of_days']					= $this->input->post("no_of_days");
			$inputdata['audit_type']					= $this->input->post("audit_type");
			$inputdata['surprise_regular']				= $this->input->post("surprise_regular");
			$inputdata['schedule_from_date']			= date("Y-m-d", strtotime($this->input->post("schedule_from_date")));
			$inputdata['schedule_to_date']				= date("Y-m-d", strtotime($this->input->post("schedule_to_date")));
			$inputdata['user_id']						= $this->ion_auth->get_user_id();
			
			
			
				if ($this->input->post('audit_id')){
					$inputdata['updated_on']		= date("Y-m-d H:i:s");
					
				}else{
					$inputdata['created_on']		= date("Y-m-d H:i:s");
				}
				
				if ($this->input->post('audit_id')) {
				$where = $this->input->post('audit_id');
				$this->db->where('audit_id', $where);
				if ($this->db->update($table, $inputdata)) {
					
						
						$this->session->set_flashdata('succes',"Audit Store Update Succesfully");
						redirect('client/audits/client_store_list', 'refresh'); 
					}
					else {
						
						$this->prepare_flashmessage("Unable to update" , 1);
						redirect('client/audits/client_store_list', 'refresh'); 
					}
				
			}
				
				$query = $this->db->query("SELECT u.company from users as u where id=".$this->ion_auth->get_user_id())->result()[0];
				
				$mapping = $this->db->query("SELECT um.* from user_mapping as um where um.role_id=2 and um.company_id=".$query->company ." and flag=0" )->result()[0];
				
				if(count($mapping)>0){
					
						$inputdata['lead_user_id']					= $mapping->map_user_id;
						if ($this->base_model->insert_operation($inputdata, $table)){
											
						$this->session->set_flashdata('succes', 'Audit Store Create Succesfully.');
						redirect('client/audits/client_store_list', 'refresh'); 
							}else{
				
						$this->session->set_flashdata('unsucces', "Unable to Add");
						redirect('client/audits/client_store_list');
						}
			
				}else{
						echo "<script>";
						echo "alert('Account Manager Is Not Assigned, Please Contact Admin');";
						echo "</script>";
						
				}
				
				//print_r($this->db->last_query());die;
			
			
		}
		}
		
		if($param=="edit"){
			$parent_rec 						= $this->db->get_where('audit', 
			array('audit_id' => $param1))->result();
			$this->data['parent_rec']			= $parent_rec[0];
		
		}

            /* Load Template */
            $this->template->client_render('client/audits/new_audit', $this->data);
       
	}
	
	public function audit_plan(){
		 
		 
            $ids = $this->input->post('id');
			$table= "audit";
			
						foreach ($ids as $id_mat)
							{
								if($id_mat == "All"){
								
								
								
								}else{
									
									$this->db->query("UPDATE audit SET plan_status=1  WHERE audit_id=".$id_mat );
									
								}
							}
	}
	
	public function audit_un_plan(){
		 
		 
            $ids = $this->input->post('id');
			$table= "audit";
			
					
								if($ids != ''){
									
								$this->db->query("UPDATE audit SET plan_status=0  WHERE audit_id=".$ids );
								
								}else{
									
								}
								
	}
	
	
		public function approval_pending($param='', $param1='')
	{ 
		
		if (!$this->ion_auth->logged_in() && !$this->ion_auth->is_client()){
			redirect('auth/login', 'refresh');
		}
		
		
		if($this->session->userdata("schedule_from_date")=='' || $this->session->userdata("schedule_to_date")==''){
			
		 $db_from_date =  $this->session->set_userdata("schedule_from_date",date('d-m-Y', strtotime("-30 days")));
		 $db_to_date   =  $this->session->set_userdata("schedule_to_date",date('d-m-Y'));
		 
		}else{}
		
		if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			 
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		 $com =  $this->base_model->run_query("select * from users where id=".$this->ion_auth->get_user_id())[0];
		 
	$company_login='';
		if(count($com)>0){
			
			$this->session->set_userdata("company_id",$com->company);
			$company_login= " and s.company_id =".$this->session->userdata("company_id");
		}else{
			$company_login='';
			
		}
		
		
		$this->data['list']                = $this->base_model->run_query(
		"select s.*, s.store_id as st_id, a.* from client_audit as a left join stores as s on a.store_id = s.store_id  and (a.schedule_from_date between '". $db_from_date."'  AND '".$db_to_date."'  OR a.schedule_to_date between '". $db_from_date."'  AND '".$db_to_date."') where s.flag=0 ".$company_login );
		
			if($this->input->post()){
		
		$this->form_validation->set_rules('audit_type', 'Audit Type' , 'xss_clean|required');
		$this->form_validation->set_rules('day_night', 'Day/Night' , 'xss_clean');
		$this->form_validation->set_rules('local_os', 'Local/OS' , 'xss_clean|required');
		$this->form_validation->set_rules('no_of_days', 'No Of Days' , 'xss_clean|required');
		$this->form_validation->set_rules('surprise_regular', 'Surprise/ Regular' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required'); 
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "client_audit";
		
		if($this->form_validation->run()== TRUE){
			
			$choice = $this->input->post("day_night");
			
    if(is_null($choice))
    {
        $choice = array();
    }
    $val = implode(',', $choice);
			
			$inputdata1['store_id']						= $this->input->post("store_id");
			$inputdata1['company_id']					= $this->session->userdata("company_id");
			$inputdata1['schedule_from_date']			= date("Y-m-d", strtotime($this->input->post("schedule_from_date")));
			$inputdata1['schedule_to_date']				= date("Y-m-d", strtotime($this->input->post("schedule_to_date")));
			$inputdata1['user_id']						= $this->ion_auth->get_user_id();
			$inputdata1['surprise_regular']				= $this->input->post("surprise_regular");
			$inputdata1['audit_type']					= $this->input->post("audit_type");
			$inputdata1['day_night']					= $val;
			$inputdata1['schedule_status']				= $this->input->post("schedule_status");
			$inputdata1['local_os']						= $this->input->post("local_os");
			$inputdata1['no_of_days']					= $this->input->post("no_of_days");
			
			
				if ($this->input->post('client_audit_id')){
					$inputdata1['updated_on']		= date("Y-m-d H:i:s");
					
				}else{
					$inputdata1['created_on']		= date("Y-m-d H:i:s");
					
				}
				
				if ($this->input->post('client_audit_id')) {
				$where = $this->input->post('client_audit_id');
				$this->db->where('client_audit_id', $where);
				if ($this->db->update($table, $inputdata1)) {
						
						$this->session->set_flashdata('succes',"Audit Schedule Update Succesfully");
						redirect('client/audits/approval_pending', 'refresh'); 
					}
					else {
						
						$this->prepare_flashmessage("Unable to update" , 1);
						redirect('client/audits/approval_pending', 'refresh'); 
					}
				
			}
			
			if($this->input->post('schedule_to_date')!=''){
				
				
					if ($this->base_model->insert_operation($inputdata1, $table)){
				
				$this->session->set_flashdata('succes', 'Audit Store Create Succesfully.');
						redirect('client/audits/approval_pending', 'refresh'); 
				}else{
				
				
						$this->session->set_flashdata('unsucces', "Unable to Add");
						redirect('client/audits/approval_pending');
			}
			
			}
			
			 
		}
		
		}
		
		$this->data['active_app_pending'] = "active";
				
		  $this->template->client_sidebar_render('client/audits/approval_pending', $this->data);
		
	}
	
	
	public function audit_excecution_all($param='')
	{
		if ( ! $this->ion_auth->logged_in() ){
			redirect('auth/login', 'refresh');
		}

			$this->session->unset_userdata('filter_schedule_from_date');
			$this->session->unset_userdata('filter_schedule_to_date');
			$this->session->unset_userdata('search_keyword');
			$this->session->unset_userdata('search_location');
		
		if($param == 'reset'){
			$this->session->unset_userdata('filter_schedule_from_date');
			$this->session->unset_userdata('filter_schedule_to_date');
			$this->session->unset_userdata('search_keyword');
			$this->session->unset_userdata('search_location');

			redirect('client/audits/audit_excecution_all');
		}

		$date_range = $this->input->post('date_range'); 
		$search_keyword = $this->input->post('keyword');
		$search_location = $this->input->post('location');

		if($this->session->userdata("filter_schedule_from_date")!='' || $this->session->userdata("filter_schedule_to_date")!=''){
				
				$db_from_date = date('Y-m-d', strtotime($this->session->userdata("filter_schedule_from_date")));
				$db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("filter_schedule_to_date")));
				 
			}
			else{
					$db_from_date = date('Y-m-d', strtotime($this->session->userdata("filter_schedule_from_date")));
				 	$db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("filter_schedule_to_date")));
				}
		 
		
		
		
		 
		$company_login='';
		if($this->session->userdata("company_id")!=''){
			
			if($this->session->userdata("company_id") == 0){
				
			$company_login='';
			
			}else{
				$company_login= " and s.company_id =".$this->session->userdata("company_id");
			}
		}else{
			$company_login='';
			
		}
		
			
			if($this->input->post()){

				$date_range_query = '';
				$search_keyword_query = '';
				$search_location_query = '';

				if($date_range != ''){

					$date_range = explode('/', $date_range);
					$db_from_date = date('Y-m-d', strtotime($date_range[0]));
					$db_to_date = date('Y-m-d', strtotime($date_range[1]));
					$date_range_query = " AND ( a.schedule_from_date  >= '".$db_from_date."' AND a.schedule_to_date <= '".$db_to_date."') ";

					$this->session->set_userdata("filter_schedule_from_date",$date_range[0]);
					$this->session->set_userdata("filter_schedule_to_date",$date_range[1]);
				}
				else{
					$this->session->set_userdata("filter_schedule_from_date",'');
					$this->session->set_userdata("filter_schedule_to_date",'');	
				}
				if($search_keyword != ''){
					$search_keyword_query = " AND (cm.company_name LIKE '%".$search_keyword."%' OR s.store_name LIKE '%".$search_keyword."%' OR s.store_no LIKE '%".$search_keyword."%') ";
					$this->session->set_userdata("search_keyword",$search_keyword);
				}
				else{
					$this->session->set_userdata("search_keyword",'');
				}
				if ($search_location != '') {
					$search_location_query = "AND (s.location LIKE '%".$search_location."%')";
					$this->session->set_userdata("search_location",$search_location);
				}
				else{
					$this->session->set_userdata("search_location",'');
				}
				
				
				 
				if($this->ion_auth->is_client()){
				
				$this->data['list'] 				= $this->base_model->run_query(
				"select a.*, s.*, cm.* from audit as a 
				left join stores as s on a.store_id = s.store_id 
				left join companies as cm on a.company_id = cm.company_id
				where s.flag = 0 and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' ".$date_range_query.$search_keyword_query.$search_location_query );
			
				
					}else{
						
				$this->data['list'] 				= $this->base_model->run_query( 
				"select a.*, um.*, s.*, cm.* from audit as a 
				left join user_mapping as um on a.company_id = um.company_id 
				left join stores as s on a.store_id = s.store_id 
				left join companies as cm on a.company_id = cm.company_id
				where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' ".$date_range_query.$search_keyword_query.$search_location_query );
				
					}
		}

			else{


			if($this->ion_auth->is_client()){
				
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*, s.* from audit as a 
		left join stores as s on a.store_id = s.store_id 
		where s.flag = 0 and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' " );
	
		
			}else{
				
				   $team_lead				= $this->base_model->run_query(
                  "SELECT role_id from users as u where id=".$this->ion_auth->get_user_id())[0];
                  
			
			
          if($team_lead->role_id == 2 ){
			
				
		$this->data['list'] 				= $this->base_model->run_query( 
		"select a.*, um.*, s.* from audit as a 
		left join user_mapping as um on a.company_id = um.company_id 
		left join stores as s on a.store_id = s.store_id 
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' " ); 
		 
		 
		  }elseif($team_lead->role_id == 1){
			  
			  $this->data['list'] 				= $this->base_model->run_query( 
		"select a.*, s.* from audit as a
		left join stores as s on a.store_id = s.store_id 
		where s.flag = 0 and a.team_lead_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' " ); 
			  
		  }else{ 
			  
			$this->data['list'] 				= $this->base_model->run_query( 
		"select a.*, um.*, s.* from audit as a 
		left join user_mapping as um on a.company_id = um.company_id 
		left join stores as s on a.store_id = s.store_id 
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.schedule_from_date!='0000-00-00' " );   
			  
		  }
		 
	}
}
		
				$this->data['active_excecution'] = "active"; 
				$this->data['active_excecution_all'] = "active";
		
             /* Load Template */
            $this->template->client_sidebar_render('client/audits/audit_excecution_all', $this->data);
       
	}
	
	public function audit_excecution_overdue($param='', $param1='')
	{
		
		 if ( ! $this->ion_auth->logged_in() ){
			redirect('auth/login', 'refresh');
		}
		
		if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
$company_login='';
		if($this->session->userdata("company_id")!=''){
			
			if($this->session->userdata("company_id") == 0){
				
			$company_login='';
			
			}else{
				$company_login= " and s.company_id =".$this->session->userdata("company_id");
			}
		}else{
			$company_login='';
			
		}
		
		
		$today_date = date("Y-m-d");
			
			if($this->ion_auth->is_client()){
				
		$this->data['list'] 				= $this->base_model->run_query(
	"select a.*, s.* from audit as a  
		left join stores as s on a.store_id = s.store_id 
		where s.flag = 0 and a.execution_status=1 and a.plan_complete_status=1 and a.audit_status!='Completed' and a.plan_status=1 and a.schedule_status=1 and schedule_from_date!='0000-00-00' and (a.schedule_from_date < '".$today_date ."'  OR  a.schedule_to_date < '".$today_date ."' )");
		
		
		
			}else{
				
				  $team_lead				= $this->base_model->run_query(
                  "SELECT role_id from users as u where id=".$this->ion_auth->get_user_id())[0];
                  
			
			
          if($team_lead->role_id == 2 ){
			  
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*,um.*,s.* from audit as a  
		left join user_mapping as um on a.company_id = um.company_id
		left join stores as s on a.store_id = s.store_id  
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.audit_status!='Completed' and a.schedule_from_date!='0000-00-00' AND (  a.schedule_from_date < '".$today_date ."'  OR  a.schedule_to_date < '".$today_date ."' ) "  );
		
		
		  }elseif($team_lead->role_id == 1){ 
		  
		  $this->data['list'] 				= $this->base_model->run_query(
		"select a.*,s.* from audit as a  
		left join stores as s on a.store_id = s.store_id  
		where s.flag = 0 and a.team_lead_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.audit_status!='Completed' and a.schedule_from_date!='0000-00-00' AND (  a.schedule_from_date < '".$today_date ."'  OR  a.schedule_to_date < '".$today_date ."' ) "  );
		
		  }else{
			  
			  $this->data['list'] 				= $this->base_model->run_query(
		"select a.*,um.*,s.* from audit as a  
		left join user_mapping as um on a.company_id = um.company_id
		left join stores as s on a.store_id = s.store_id  
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and a.audit_status!='Completed' and a.schedule_from_date!='0000-00-00' AND (  a.schedule_from_date < '".$today_date ."'  OR  a.schedule_to_date < '".$today_date ."' ) "  );
		
		  }
		
		// print_r($this->db->last_query());die; 
		
			}
		
				$this->data['active_excecution'] = "active";
				$this->data['active_excecution_overdue'] = "active";
		
             /* Load Template */
            $this->template->client_sidebar_render('client/audits/audit_excecution_overdue', $this->data);
       
	}
	
	public function audit_excecution_current($param='', $param1='')
	{
		
		 if ( ! $this->ion_auth->logged_in() ){
			redirect('auth/login', 'refresh');
		}
		
			 
			if($this->session->userdata("schedule_from_date")!='' || $this->session->userdata("schedule_to_date")!=''){
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
		}else{
			
		}
		
		 $db_from_date = date('Y-m-d', strtotime($this->session->userdata("schedule_from_date")));
		 $db_to_date   =  date('Y-m-d', strtotime($this->session->userdata("schedule_to_date")));
		 
	$company_login='';
		if($this->session->userdata("company_id")!=''){
			
			if($this->session->userdata("company_id") == 0){
				
			$company_login='';
			
			}else{
				$company_login= " and s.company_id =".$this->session->userdata("company_id");
			}
		}else{
			$company_login='';
			
		}
		
		
			$today_date = date("Y-m-d");
			
			if($this->ion_auth->is_client()){
				
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*, s.* from audit as a 		
		left join stores as s on a.store_id = s.store_id 
		where s.flag = 0 and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and schedule_from_date!='0000-00-00' AND ( a.schedule_from_date = '".$today_date ."'  OR  a.schedule_to_date = '".$today_date ."' ) ");
		
		
		
			}else{
				
				 $team_lead				= $this->base_model->run_query(
                  "SELECT role_id from users as u where id=".$this->ion_auth->get_user_id())[0];
                  
			
			
          if($team_lead->role_id == 2 ){
			  
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*, um.*, s.* from audit as a 
		left join user_mapping as um on a.company_id = um.company_id 
		left join stores as s on a.store_id = s.store_id  
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and schedule_from_date!='0000-00-00' AND ( a.schedule_from_date = '".$today_date ."'  OR  a.schedule_to_date = '".$today_date ."' ) "  );
		
		
		  }elseif($team_lead->role_id == 1){ 
		  
		  $this->data['list'] 				= $this->base_model->run_query(
		"select a.*, s.* from audit as a 
		left join stores as s on a.store_id = s.store_id  
		where s.flag = 0 and a.team_lead_user_id =".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and schedule_from_date!='0000-00-00' AND ( a.schedule_from_date = '".$today_date ."'  OR  a.schedule_to_date = '".$today_date ."' ) "  );
		  
		  }else{
			 
		$this->data['list'] 				= $this->base_model->run_query(
		"select a.*, um.*, s.* from audit as a 
		left join user_mapping as um on a.company_id = um.company_id 
		left join stores as s on a.store_id = s.store_id  
		where um.flag=0 and s.flag = 0 and um.map_user_id=".$this->ion_auth->get_user_id() ." and a.execution_status=1 and a.plan_complete_status=1 and a.plan_status=1 and a.schedule_status=1 and schedule_from_date!='0000-00-00' AND ( a.schedule_from_date = '".$today_date ."'  OR  a.schedule_to_date = '".$today_date ."' ) "  );			 
			  
		  }
		
		//print_r($this->db->last_query());die;
		
		
		
			}
		
				$this->data['active_excecution'] = "active";
				$this->data['active_excecution_current'] = "active";
		
             /* Load Template */
            $this->template->client_sidebar_render('client/audits/audit_excecution_current', $this->data);
       
	}
	
	
	public function excecution_stage_info($param='', $param1='', $param2='')
	{
		 if ( ! $this->ion_auth->logged_in() ){
			redirect('auth/login', 'refresh');
		}
		
		  $this->data['list'] 				= $this->base_model->run_query(
		"select a.*, s.*,s.company_id as company from audit as a, stores as s where s.store_id = a.store_id and a.audit_id =".$param )[0];
		
		$this->data['execution'] = $this->base_model->run_query("select * from execution_milestone where audit_id =".$param ); 
		 
		
		 $this->data['deliverable'] = $this->base_model->run_query("select * from audit_deliverables where audit_id=".$param );
		 
		 $this->data['checklist'] = $this->base_model->run_query("select * from audit_checklist where audit_id =".$param ); 
		
		$this->data['resource'] 				= $this->base_model->run_query(
		"select * from resource where flag=0 and audit_id=".$param);
		
		$this->data['stock'] 				= $this->base_model->run_query(
		"select * from stock_report where audit_id=".$param);
		
		$this->data['equipment_list'] 				= $this->base_model->run_query(
		"select * from equipment where flag=0 and audit_id=".$param);
		
		$this->data['expenses_list'] 				= $this->base_model->run_query(
		"select * from expenses where flag=0 and audit_id=".$param);
		
		
		if($this->input->post()){
		
		$this->form_validation->set_rules('team_lead_user_id', 'Team Lead' , 'xss_clean');
		$this->form_validation->set_rules('schedule_from_date', 'From Date' , 'xss_clean|required');
		$this->form_validation->set_rules('schedule_to_date', 'To Date' , 'xss_clean|required');
		$this->form_validation->set_rules('audit_status', 'Audit Status' , 'xss_clean|required');
		$this->form_validation->set_rules('reschedule_date', 'Reschedule Date' , 'xss_clean');
		$this->form_validation->set_rules('remarks', 'Remarks' , 'xss_clean'); 
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');		
		$table = "audit";
		
		if($this->form_validation->run()== TRUE){
			
			$additional_data 				= array(
			'schedule_from_date'			=>date("Y-m-d", strtotime($this->input->post("schedule_from_date"))),
			'schedule_to_date'				=>date("Y-m-d", strtotime($this->input->post("schedule_to_date"))),
			'reschedule_date'				=>date("Y-m-d", strtotime($this->input->post("reschedule_date"))),
			'audit_status'					=>$this->input->post("audit_status"),
			'remarks'						=>$this->input->post("remarks"),
			);			
												
				if ($this->input->post('audit_id')) {
				$where = $this->input->post('audit_id');
				$this->db->where('audit_id', $where);
				if ($this->db->update($table, $additional_data)) {
						$this->session->set_flashdata('succes',"Audit Status Updated Succesfully");
						redirect('client/audits/audit_excecution_all', 'refresh');
							
								}else {
						
						$this->session->set_flashdata('unsucces',"Unable to update");
						redirect('client/audits/audit_excecution_all');
					}
				
			}
		
		
		}
		
		}
		
		if($param1 == "pod"){
			
			 for($i = 0; $i < $filesCount; $i++){
                $_FILES['pod']['name'] = $_FILES['pod']['name'][$i];
                $_FILES['pod']['type'] = $_FILES['pod']['type'][$i];
                $_FILES['pod']['tmp_name'] = $_FILES['pod']['tmp_name'][$i];
                $_FILES['pod']['error'] = $_FILES['pod']['error'][$i];
                $_FILES['pod']['size'] = $_FILES['pod']['size'][$i];

                $uploadPath = './uploads/showroom/pod/';
                $config['upload_path'] = $uploadPath;
                 $config['allowed_types'] = '*';
                
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if($this->upload->do_upload('pod')){
                    $fileData = $this->upload->data();
                    $answer_updatedata1['pod'] = $fileData['file_name'];
					$this->db->where('execution_id', $param2);
					$this->db->update('execution_milestone', $answer_updatedata1);	
					  } else {
							return false;
					  }
            } 
			
		}
		
		
		if($param1 == "bookstock"){
			
			if($param2 == "readexcel_bookstock" ){
			
			
			if (!$this->ion_auth->logged_in() ){
			$this->session->set_flashdata('unsucces',$this->lang->line('you_have_no_access_to_this_module'));
			redirect('auth/login');
		}
		
		if ($_FILES['userfile']['name']) {
				$f_type							 = explode(".", $_FILES['userfile']['name']);
				$last_in 						 = (count($f_type) - 1);
				
				if($f_type[$last_in] !== "xlsx"){
					$this->session->set_flashdata('unsucces',"invalid_file");
					redirect('client/audits/excecution_stage_info/'.$param .'/bookstock', 'refresh');
				}
			}
	    
		if ($param1 == "bookstock" || $param1 == "customers") {
		include (FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

		$file 									= $_FILES['userfile']['tmp_name'];
		$inputFileName 							= $file;
		//$objReader 								= new PHPExcel_Reader_Excel5();
		$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		
		$objPHPExcel 							= $objReader->load($inputFileName); 
		//echo '<hr />';
		$sheetData 								= $objPHPExcel->getActiveSheet()->toArray(
		null, true, true, true
		);
		$i 										= 0;
		$j 										= 0;
		$data 									= array();
		$valid 									= 1;
		$erroredRcords=array();
	
		
		foreach($sheetData as $r) {
				
			if ($i++ != 0) {
				if ($valid == 1){
					if ($param1 == 'bookstock') {
						$r=$this->bookstock_validation($r, $param);
						
					if($r['I']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{ 
						
						
				$get_store_book		= $this->base_model->run_query(
		"select * from audit where audit_id=".$param)[0];
						
						// print_r($this->db->last_query());die;
						
							$inputdata_mat 		= array(
							
							'audit_id'						=> $param,
							'store_id'						=> $get_store_book->store_id,
							'brand_code'    				=> $r['A'],
							'product_category'         		=> $r['B'],
							'barcode' 	            		=> $r['C'],
							'stylecode' 					=> $r['D'],	
							'item_desc'						=> $r['E'],	
							'cost' 							=> $r['F'],
							'mrp' 							=> $r['G'],
							'bookstock_qty' 				=> $r['H'],
							'bookstock_value' 				=> ( ($r['F']) * ($r['H']) ),
							'created_on' 	    			=> date("Y-m-d H:i:s"),
							'user_id'     					=> $this->ion_auth->get_user_id(),
						
						);
						
					  }
						
					}elseif ($param1 == 'customers'){ 
						$r=$this->customer_validation($r);
						if(isset($r['R']) && $r['R']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{
							$inputdata 			= array(
								'client_id'     => $this->session->userdata('client_id'),
								'customer_code' => $r['A'],
								'name'          => $r['B'],
								'email' 		=> $r['C'],
								'phone'         => $r['D'],
								'city' 	        => $r['E'],
								'address' 	    => $r['F'],
								'zip_code' 	    => $r['G'],
								'contact_name1' => $r['H'],
								'contact_phone1'=> $r['I'],
								'contact_email1'=> $r['J'],
								'designation1'	=> $r['K'],
								'remark1'		=> $r['L'],
								'contact_name2' => $r['M'],
								'contact_phone2'=> $r['N'],
								'contact_email2'=> $r['O'],
								'designation2'	=> $r['P'],
								'remark2'		=> $r['Q'],
								'active' 	    => 1,
								'created_on' 	=> date("Y-m-d H:i:s"),
							);
						}
					}
					
					
					$table="stock_report";
					header_remove('Set-Cookie');
					 $this->base_model->insert_operation($inputdata_mat, $table);
					$this->session->set_flashdata('succes', 'Book Stock Created Successfully.');
				}
				else {
					break;
				}
			}
		}
	   
		if (!empty($erroredRcords)){
			
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objPHPExcel->getActiveSheet()->removeRow(2, 255);
			$objSheet=$objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
			if($param1 == 'customers'){
				$objSheet->setTitle('Customer-List'.date("Y-m-d"));
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('R1')->setValue('Remark');
				$file_name="C-list-".time().".xlsx";
				if(!is_dir('upload/upload_bookstock/'.$this->session->userdata("client_name"))){
					
					mkdir('upload/upload_bookstock/'.$this->session->userdata("client_name"), 0777);
				}
				$objWriter->save('upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name);
				$download='upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name;
			}elseif($param1 == 'bookstock'){
				$objSheet->setTitle('Material-List'.date("Y-m-d"));
				$objSheet->getStyle('I2:I'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('I2:I'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('I1')->setValue('Remark');
				$file_name="A-list-".time().".xlsx";
				if(!is_dir('upload/showroom/upload_bookstock/')){
					
					mkdir('upload/showroom/upload_bookstock/', 0777);
				}
				$objWriter->save('upload/showroom/upload_bookstock/'.$file_name);
				$download='upload/showroom/upload_bookstock/'.$file_name;
				
			}
		    $this->session->set_userdata("recent_download",$download);
			$msg = "Some records are not uploaded. Please download the file to see the status of records";
			$this->session->set_flashdata('unsucces', $msg);
			redirect('client/audits/excecution_stage_info/'.$param .'/bookstock', 'refresh');
		}
			
			redirect('client/audits/excecution_stage_info/'.$param .'/stocklist', 'refresh');
			
		}
		else {
		
			// $this->session->set_flashdata('unsucces',$this->lang->line('incorrect_operation'));
			// redirect('admin/audits/excecution_stage_info/'.$param ."/".$param1 );
		}
			
			
		}
		
		}
		
		
		if($param1 == "physicalstock"){
			
			if($param2 == "readexcel_physicalstock" ){
			
			
			if (!$this->ion_auth->logged_in() ){
			$this->session->set_flashdata('unsucces',$this->lang->line('you_have_no_access_to_this_module'));
			redirect('auth/login');
		}
		
		if ($_FILES['userfile']['name']) {
				$f_type							 = explode(".", $_FILES['userfile']['name']);
				$last_in 						 = (count($f_type) - 1);
				
				if($f_type[$last_in] !== "xlsx"){
					$this->session->set_flashdata('unsucces',"invalid_file");
					redirect('client/audits/excecution_stage_info/'.$param .'/physicalstock', 'refresh');
				}
			}
	    
		if ($param1 == "physicalstock" || $param1 == "customers") {
		include (FCPATH . '/assets/excelassets/PHPExcel/IOFactory.php');

		$file 									= $_FILES['userfile']['tmp_name'];
		$inputFileName 							= $file;
		//$objReader 								= new PHPExcel_Reader_Excel5();
		$objReader = PHPExcel_IOFactory::createReader('Excel2007');
		
		$objPHPExcel 							= $objReader->load($inputFileName); 
		//echo '<hr />';
		$sheetData 								= $objPHPExcel->getActiveSheet()->toArray(
		null, true, true, true
		);
		$i 										= 0;
		$j 										= 0;
		$data 									= array();
		$valid 									= 1;
		$erroredRcords=array();
	
		
		foreach($sheetData as $r) {
				
			if ($i++ != 0) {
				if ($valid == 1){
					if ($param1 == 'physicalstock') {
						$r=$this->physicalstock_validation($r,$param);
						
					if($r['C']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{ 

							$get_store_id		= $this->base_model->run_query(
		"select * from audit where audit_id=".$param)[0];
					
			$get_book_cost 		= $this->db->get_where('stock_report', 
			array('audit_id' => $param, 'store_id'=>$get_store_id->store_id, 'barcode' => $r['A'] ))->result()[0];
						
							$inputdata_mat 		= array(
							
							'physicalstock_qty'         	=> $r['B'],
							'physicalstock_value' 	        => (($get_book_cost->cost) * $r['B']),
							'qty_descrepancy' 	        	=> ( $r['B'] - ($get_book_cost->bookstock_qty)),
							'value_descrepancy' 	        => ((($get_book_cost->cost) * $r['B']) - (($get_book_cost->cost) * ($get_book_cost->bookstock_qty))),
							'created_on' 	    			=> date("Y-m-d H:i:s"),
							'user_id'     					=> $this->ion_auth->get_user_id(),
						
						);
						
					  } //die;
						
					}elseif ($param1 == 'customers'){ 
						$r=$this->customer_validation($r);
						if(isset($r['R']) && $r['R']!=''){
							$erroredRcords[$j++]=$r;
							continue;
						}else{
							$inputdata 			= array(
								'client_id'     => $this->session->userdata('client_id'),
								'customer_code' => $r['A'],
								'name'          => $r['B'],
								'email' 		=> $r['C'],
								'phone'         => $r['D'],
								'city' 	        => $r['E'],
								'address' 	    => $r['F'],
								'zip_code' 	    => $r['G'],
								'contact_name1' => $r['H'],
								'contact_phone1'=> $r['I'],
								'contact_email1'=> $r['J'],
								'designation1'	=> $r['K'],
								'remark1'		=> $r['L'],
								'contact_name2' => $r['M'],
								'contact_phone2'=> $r['N'],
								'contact_email2'=> $r['O'],
								'designation2'	=> $r['P'],
								'remark2'		=> $r['Q'],
								'active' 	    => 1,
								'created_on' 	=> date("Y-m-d H:i:s"),
							);
						}
					}
					
					
					$table="stock_report";
					$array = array('audit_id' => $param, 'barcode' => $r['A'], 'store_id' => $get_store_id->store_id );
					header_remove('Set-Cookie');
					$this->db->where($array);
					$this->db->update($table, $inputdata_mat);
					$this->session->set_flashdata('succes', 'Physical Stock Updated Successfully.');
				} 
				else {
					break;
				}
				
			}
		}    
	   
		if (!empty($erroredRcords)){
			
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objPHPExcel->getActiveSheet()->removeRow(2, 255);
			$objSheet=$objPHPExcel->getActiveSheet()->fromArray($erroredRcords, NULL, 'A2');
			if($param1 == 'customers'){
				$objSheet->setTitle('Customer-List'.date("Y-m-d"));
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('R2:R'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('R1')->setValue('Remark');
				$file_name="C-list-".time().".xlsx";
				if(!is_dir('upload/upload_physicalstock/'.$this->session->userdata("client_name"))){
					
					mkdir('upload/upload_physicalstock/'.$this->session->userdata("client_name"), 0777);
				}
				$objWriter->save('upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name);
				$download='upload/customer_list/'.$this->session->userdata("client_name").'/'.$file_name;
			}elseif($param1 == 'physicalstock'){
				$objSheet->setTitle('Material-List'.date("Y-m-d"));
				$objSheet->getStyle('C2:C'.count($erroredRcords))->getFont()->setBold(true)->setSize(12);
				$objSheet->getStyle('C2:C'.count($erroredRcords))->getFont()->getColor()->setRGB('FF0000');
				$objSheet->getCell('C1')->setValue('Remark');
				$file_name="A-list-".time().".xlsx";
				if(!is_dir('upload/showroom/upload_physicalstock/')){
					
					mkdir('upload/showroom/upload_physicalstock/', 0777);
				}
				$objWriter->save('upload/showroom/upload_physicalstock/'.$file_name);
				$download='upload/showroom/upload_physicalstock/'.$file_name;
				
			}
		    $this->session->set_userdata("recent_download",$download);
			$msg = "Some records are not uploaded. Please download the file to see the status of records";
			$this->session->set_flashdata('unsucces', $msg);
			redirect('client/audits/excecution_stage_info/'.$param .'/physicalstock', 'refresh');
		}
			
			redirect('client/audits/excecution_stage_info/'.$param .'/stocklist', 'refresh');
			
		}
		else {
		
			// $this->session->set_flashdata('unsucces',$this->lang->line('incorrect_operation'));
			// redirect('admin/audits/excecution_stage_info/'.$param ."/".$param1 );
		}
			
			
		}
		
		}
		
             /* Load Template */
            $this->template->client_render('client/audits/excecution_stage_info', $this->data);
       
	}
	
}
