<?php
   defined('BASEPATH') OR exit('No direct script access allowed');
   
   ?>
<div class="content-wrapper">
   <section class="content-header">
      <?php //echo $pagetitle; ?>
      <?php //echo $breadcrumb; ?>
   </section>
   <section class="content">
      <div class="row">
         <div class="col-md-12">
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">
                     Client Users List
                  </h3>
                  <!--<?php echo anchor('admin/users/create','<i class="fa fa-plus"></i> '. lang('users_create_user'), array('class' => 'btn btn-block btn-primary btn-flat')); ?>-->
                  <a href="<?php echo site_url('admin/users/create');?>" class="pull-right" ><button class="btn btn-block btn-primary btn-flat pull-right"><i class="fa fa-plus"></i>Create Client User</button></a>
               </div>
               <div class="box-body">
                  <?php if($this->session->flashdata('succes')!=''){?>
                  <div class="alert alert-success alert-dismissible">
                     <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                     <h4><i class="icon fa fa-check"></i><?php echo $this->session->flashdata('succes'); ?></h4>
                  </div>
                  <?php } ?>
                  <?php if($this->session->flashdata('unsucces')!=''){?>
                  <div class="alert alert-danger alert-dismissible">
                     <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                     <h4><i class="icon fa fa-ban"></i><?php echo $this->session->flashdata('unsucces'); ?></h4>
                  </div>
                  <?php } ?>
                  <table class="table table-bordered table-striped dataTable">
                     <thead>
                        <tr>
                           <th><?php echo lang('users_username');?></th>
                           <th><?php echo lang('users_email');?></th>
                           <th><?php echo "Role";?></th>
                           <th><?php echo lang('users_status');?></th>
                           <th><?php echo lang('users_action');?></th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php foreach ($users as $user):?>
                        <tr>
                           <td><?php echo htmlspecialchars($user->username, ENT_QUOTES, 'UTF-8'); ?></td>
                           <td><?php echo htmlspecialchars($user->email, ENT_QUOTES, 'UTF-8'); ?></td>
                           <td><?php echo get_role_name($user->role_id); ?></td>
                           <td><?php echo ($user->active) ? anchor('admin/users/deactivate/'.$user->id, '<span class="label label-success">'.lang('users_active').'</span>') : anchor('admin/users/activate/'. $user->id, '<span class="label label-default">'.lang('users_inactive').'</span>'); ?></td>
                           <td>
                              <!--<?php echo anchor('admin/users/edit/'.$user->id, lang('actions_edit')); ?>
                                 <?php echo anchor('admin/users/profile/'.$user->id, lang('actions_see')); ?>-->
                              <a href="<?php echo site_url('admin/users/edit/'.$user->id)?>" class="" title="Edit details"><i class="fa fa-edit"></i></a>
                              &nbsp;&nbsp;
                              <a href="<?php echo site_url('admin/users/create/delete/'.$user->id)?>" class="" title="Delete details"><i class="fa fa-trash" aria-hidden="true"></i></a>
                           </td>
                        </tr>
                        <?php endforeach;?>
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </section>
</div>
